--- ./tcpnice.c.orig	2001-03-17 08:41:51.000000000 +0100
+++ ./tcpnice.c	2014-07-22 13:20:14.000000000 +0200
@@ -41,107 +41,106 @@
 }
 
 static void
-send_tcp_window_advertisement(int sock, struct libnet_ip_hdr *ip,
+send_tcp_window_advertisement(libnet_t *l, struct libnet_ipv4_hdr *ip,
 			     struct libnet_tcp_hdr *tcp)
 {
 	int len;
 	
 	ip->ip_hl = 5;
-	ip->ip_len = htons(IP_H + TCP_H);
-	ip->ip_id = libnet_get_prand(PRu16);
-	memcpy(buf, (u_char *)ip, IP_H);
+	ip->ip_len = htons(LIBNET_IPV4_H + LIBNET_TCP_H);
+	ip->ip_id = libnet_get_prand(LIBNET_PRu16);
+	memcpy(buf, (u_char *)ip, LIBNET_IPV4_H);
 	
 	tcp->th_off = 5;
 	tcp->th_win = htons(MIN_WIN);
-	memcpy(buf + IP_H, (u_char *)tcp, TCP_H);
+	memcpy(buf + LIBNET_IPV4_H, (u_char *)tcp, LIBNET_TCP_H);
 	
-	libnet_do_checksum(buf, IPPROTO_TCP, TCP_H);
+	libnet_do_checksum(l, buf, IPPROTO_TCP, LIBNET_TCP_H);
 	
-	len = IP_H + TCP_H;
+	len = LIBNET_IPV4_H + LIBNET_TCP_H;
 	
-	if (libnet_write_ip(sock, buf, len) != len)
+	if (libnet_write_raw_ipv4(l, buf, len) != len)
 		warn("write");
 	
 	fprintf(stderr, "%s:%d > %s:%d: . ack %lu win %d\n",
-		libnet_host_lookup(ip->ip_src.s_addr, 0), ntohs(tcp->th_sport),
-		libnet_host_lookup(ip->ip_dst.s_addr, 0), ntohs(tcp->th_dport),
+		libnet_addr2name4(ip->ip_src.s_addr, 0), ntohs(tcp->th_sport),
+		libnet_addr2name4(ip->ip_dst.s_addr, 0), ntohs(tcp->th_dport),
 		ntohl(tcp->th_ack), 1);
 }
 
 static void
-send_icmp_source_quench(int sock, struct libnet_ip_hdr *ip)
+send_icmp_source_quench(libnet_t *l, struct libnet_ipv4_hdr *ip)
 {
-	struct libnet_icmp_hdr *icmp;
+	struct libnet_icmpv4_hdr *icmp;
 	int len;
 	
 	len = (ip->ip_hl * 4) + 8;
 
-	libnet_build_ip(ICMP_ECHO_H + len, 0, libnet_get_prand(PRu16),
-			0, 64, IPPROTO_ICMP, ip->ip_dst.s_addr,
-			ip->ip_src.s_addr, NULL, 0, buf);
-	
-	icmp = (struct libnet_icmp_hdr *)(buf + IP_H);
+	icmp = (struct libnet_icmpv4_hdr *)(buf + LIBNET_IPV4_H);
 	icmp->icmp_type = ICMP_SOURCEQUENCH;
 	icmp->icmp_code = 0;
-	memcpy((u_char *)icmp + ICMP_ECHO_H, (u_char *)ip, len);
+	memcpy((u_char *)icmp + LIBNET_ICMPV4_ECHO_H, (u_char *)ip, len);
 	
-	libnet_do_checksum(buf, IPPROTO_ICMP, ICMP_ECHO_H + len);
+	len += LIBNET_ICMPV4_ECHO_H;
 	
-	len += (IP_H + ICMP_ECHO_H);
+	libnet_build_ipv4(LIBNET_IPV4_H + len, 0,
+			  libnet_get_prand(LIBNET_PRu16), 0, 64, IPPROTO_ICMP,
+			  0, ip->ip_dst.s_addr, ip->ip_src.s_addr,
+			  (u_int8_t *) icmp, len, l, 0);
 	
-	if (libnet_write_ip(sock, buf, len) != len)
+	if (libnet_write(l) != len)
 		warn("write");
 	
 	fprintf(stderr, "%s > %s: icmp: source quench\n",
-		libnet_host_lookup(ip->ip_dst.s_addr, 0),
-		libnet_host_lookup(ip->ip_src.s_addr, 0));
+		libnet_addr2name4(ip->ip_dst.s_addr, 0),
+		libnet_addr2name4(ip->ip_src.s_addr, 0));
 }
 
 static void
-send_icmp_frag_needed(int sock, struct libnet_ip_hdr *ip)
+send_icmp_frag_needed(libnet_t *l, struct libnet_ipv4_hdr *ip)
 {
-	struct libnet_icmp_hdr *icmp;
+	struct libnet_icmpv4_hdr *icmp;
 	int len;
 
 	len = (ip->ip_hl * 4) + 8;
 	
-	libnet_build_ip(ICMP_MASK_H + len, 4, libnet_get_prand(PRu16),
-			0, 64, IPPROTO_ICMP, ip->ip_dst.s_addr,
-			ip->ip_src.s_addr, NULL, 0, buf);
-
-	icmp = (struct libnet_icmp_hdr *)(buf + IP_H);
+	icmp = (struct libnet_icmpv4_hdr *)(buf + LIBNET_IPV4_H);
 	icmp->icmp_type = ICMP_UNREACH;
 	icmp->icmp_code = ICMP_UNREACH_NEEDFRAG;
 	icmp->hun.frag.pad = 0;
 	icmp->hun.frag.mtu = htons(MIN_MTU);
-	memcpy((u_char *)icmp + ICMP_MASK_H, (u_char *)ip, len);
+	memcpy((u_char *)icmp + LIBNET_ICMPV4_MASK_H, (u_char *)ip, len);
 
-	libnet_do_checksum(buf, IPPROTO_ICMP, ICMP_MASK_H + len);
-	
-	len += (IP_H + ICMP_MASK_H);
+	len += LIBNET_ICMPV4_MASK_H;
+
+	libnet_build_ipv4(LIBNET_IPV4_H + len, 4,
+			  libnet_get_prand(LIBNET_PRu16), 0, 64, IPPROTO_ICMP,
+			  0, ip->ip_dst.s_addr, ip->ip_src.s_addr,
+			  (u_int8_t *) icmp, len, l, 0);
 	
-	if (libnet_write_ip(sock, buf, len) != len)
+	if (libnet_write(l) != len)
 		warn("write");
 	
 	fprintf(stderr, "%s > %s: icmp: ",
-		libnet_host_lookup(ip->ip_dst.s_addr, 0),
-		libnet_host_lookup(ip->ip_src.s_addr, 0));
+		libnet_addr2name4(ip->ip_dst.s_addr, 0),
+		libnet_addr2name4(ip->ip_src.s_addr, 0));
 	fprintf(stderr, "%s unreachable - need to frag (mtu %d)\n",
-		libnet_host_lookup(ip->ip_src.s_addr, 0), MIN_MTU);
+		libnet_addr2name4(ip->ip_src.s_addr, 0), MIN_MTU);
 }
 
 static void
 tcp_nice_cb(u_char *user, const struct pcap_pkthdr *pcap, const u_char *pkt)
 {
-	struct libnet_ip_hdr *ip;
+	struct libnet_ipv4_hdr *ip;
 	struct libnet_tcp_hdr *tcp;
-	int *sock, len;
+	int len;
+	libnet_t *l;
 
-	sock = (int *)user;
+	l = (libnet_t *)user;
 	pkt += pcap_off;
 	len = pcap->caplen - pcap_off;
 
-	ip = (struct libnet_ip_hdr *)pkt;
+	ip = (struct libnet_ipv4_hdr *)pkt;
 	if (ip->ip_p != IPPROTO_TCP)
 		return;
 	
@@ -151,11 +150,11 @@
 	
 	if (ntohs(ip->ip_len) > (ip->ip_hl << 2) + (tcp->th_off << 2)) {
 		if (Opt_icmp)
-			send_icmp_source_quench(*sock, ip);
+			send_icmp_source_quench(l, ip);
 		if (Opt_win)
-			send_tcp_window_advertisement(*sock, ip, tcp);
+			send_tcp_window_advertisement(l, ip, tcp);
 		if (Opt_pmtu)
-			send_icmp_frag_needed(*sock, ip);
+			send_icmp_frag_needed(l, ip);
 	}
 }
 
@@ -164,8 +163,10 @@
 {
 	extern char *optarg;
 	extern int optind;
-	int c, sock;
+	int c;
 	char *intf, *filter, ebuf[PCAP_ERRBUF_SIZE];
+	char libnet_ebuf[LIBNET_ERRBUF_SIZE];
+	libnet_t *l;
 	pcap_t *pd;
 	
 	intf = NULL;
@@ -209,14 +210,14 @@
 	if ((pcap_off = pcap_dloff(pd)) < 0)
 		errx(1, "couldn't determine link layer offset");
 	
-	if ((sock = libnet_open_raw_sock(IPPROTO_RAW)) == -1)
+	if ((l = libnet_init(LIBNET_RAW4, intf, libnet_ebuf)) == NULL)
 		errx(1, "couldn't initialize sending");
 	
-	libnet_seed_prand();
+	libnet_seed_prand(l);
 	
 	warnx("listening on %s [%s]", intf, filter);
 	
-	pcap_loop(pd, -1, tcp_nice_cb, (u_char *)&sock);
+	pcap_loop(pd, -1, tcp_nice_cb, (u_char *)l);
 	
 	/* NOTREACHED */
 	
