#
#
# This file lists old files (OLD_FILES), libraries (OLD_LIBS, MOVED_LIBS)
# and directories (OLD_DIRS) which should get removed after an update.
# Recently removed entries should be listed first (with the date as a
# comment). OLD_LIBS and MOVED_LIBS should only list dynamic libraries.
# Static libraries, links to dynamic libraries (lib*.so), and linker scripts
# should be listed in OLD_FILES. OLD_LIBS and MOVED_LIBS are removed by the
# delete-old-libs target, whereas OLD_FILES and OLD_DIRS are removed by the
# delete-old target. This separation allows users to avoid deleting old
# dynamic libraries still required by existing binaries.
#
# MOVED_LIBS should be used instead of OLD_LIBS when a library is moved
# from usr/lib to lib or vice versa.  This avoids removing libraries for
# alternate ABIs (such as lib32) which store all libraries in a single
# directory (e.g. usr/lib32).
#
# For files listed in OLD_FILES, OLD_LIBS, and MOVED_LIBS, the check-old*
# and delete-old* targets will also delete associated debug symbols from
# usr/lib/debug.
#
# In case of a complete directory hierarchy the sorting is in depth first
# order.
#
# Files that are installed or removed depending on some build option
# should be listed in /usr/src/tools/build/mk/OptionalObsoleteFiles.inc
# instead of in this file.
#
# Before you commit changes to this file please check if any entries in
# tools/build/mk/OptionalObsoleteFiles.inc can be removed. The following
# command tells which files are listed more than once regardless of some
# architecture specific conditionals, so you can not blindly trust the
# output:
# ( grep '+=' /usr/src/ObsoleteFiles.inc | sort -u ; \
# grep '+=' /usr/src/tools/build/mk/OptionalObsoleteFiles.inc | sort -u) | \
# sort | uniq -d
#
# To find regular duplicates not dependent on optional components, you can
# also use something that will not give you false positives, e.g.:
# for t in `make -V TARGETS universe`; do
#   __MAKE_CONF=/dev/null make -f Makefile.inc1 TARGET=$t \
#   -V OLD_FILES -V OLD_LIBS -V MOVED_LIBS -V OLD_DIRS check-old | \
#   xargs -n1 | sort | uniq -d;
# done
#
# For optional components, you can use the following to see if some entries
# in OptionalObsoleteFiles.inc have been obsoleted by ObsoleteFiles.inc
# for o in tools/build/options/WITH*; do
#   __MAKE_CONF=/dev/null make -f Makefile.inc1 -D${o##*/} \
#   -V OLD_FILES -V OLD_LIBS -V MOVED_LIBS -V OLD_DIRS check-old | \
#   xargs -n1 | sort | uniq -d;
# done

# 20251006: Remove libnss_tacplus.a (it never should have been installed)
OLD_FILES+=usr/lib/libnss_tacplus.a

# 20251003: kgdb python scripts moved
OLD_FILES+=usr/libexec/kgdb/acttrace.py
OLD_DIRS+=usr/libexec/kgdb

# 20251001: test helper sendto-IP_MULTICAST_IF renamed
OLD_FILES+=usr/tests/sys/netinet/sendto-IP_MULTICAST_IF

# 20250930: Rename wlanstats to wlanstat
OLD_FILES+=usr/sbin/wlanstats
OLD_FILES+=usr/share/man/man8/wlanstats.8.gz

# 20250929: Remove ftpd(8)
OLD_FILES+=etc/rc.d/ftpd
OLD_FILES+=usr/libexec/ftpd
OLD_FILES+=usr/share/man/man5/ftpchroot.5.gz
OLD_FILES+=usr/share/man/man8/ftpd.8.gz

# 20250917: VREF macro removed
OLD_FILES+=usr/share/man/man9/VREF.9.gz

# 20250917: Remove a miscapitalized manual
OLD_FILES+=usr/share/man/man9/vnet.9.gz
OLD_FILES+=usr/share/man/man9/vimage.9.gz

# 20250911: This tool is no longer needed
OLD_FILES+=usr/tests/bin/cp/sparse

# 20250826: Remove a misspelled manual
OLD_FILES+=usr/share/man/man3/sysdecode_syscallnames.3.gz

# 20250812: Remove a bogus manlink
OLD_FILES+=usr/share/man/man3/quota_statfs.3.gz

# 20250808: nvmfd removed from base install
OLD_FILES+=usr/sbin/nvmfd
OLD_FILES+=usr/share/man/man8/nvmfd.8.gz

# 20250807: Replace lib/libgssapi with krb5/lib/gssapi
OLD_FILES+=usr/include/gssapi_krb5/gssapi.h
OLD_FILES+=usr/include/gssapi_krb5/gssapi/gssapi.h
OLD_FILES+=usr/include/gssapi_krb5/gssapi/mechglue.h
OLD_DIRS+=usr/include/gssapi_krb5/gssapi
OLD_DIRS+=usr/include/gssapi_krb5
OLD_FILES+=etc/gssapi/qop

# 20250802: libutil bumped to 10
OLD_LIBS+=lib/libutil.so.9

# 20250801: libopencsd libraries moved to /usr/lib and made private
OLD_FILES+=lib/libopencsd.so.0
OLD_FILES+=usr/lib/libopencsd.a
OLD_FILES+=usr/lib/libopencsd.so

# 20250801: Move compile_et to /usr/sbin
OLD_FILES+=usr/share/et/compile_et

# 20250728: zfsboot (MBR) removed
OLD_FILES+=boot/zfsboot
OLD_FILES+=usr/share/man/man8/zfsboot.8.gz

# 20250728: Machine versions of 'runq.h' do not exist anymore
OLD_FILES+=usr/include/machine/runq.h

# 20250727: libvmmapi bumped to 7
OLD_LIBS+=usr/lib/libvmmapi.so.6

# 20250726: MIT KRB5 DSO bump
OLD_LIBS+=usr/lib/libcom_err.so.121
OLD_LIBS+=usr/lib/libgssapi_krb5.so.121
OLD_LIBS+=usr/lib/libgssrpc.so.121
OLD_LIBS+=usr/lib/libk5crypto.so.121
OLD_LIBS+=usr/lib/libkadm5clnt_mit.so.121
OLD_LIBS+=usr/lib/libkadm5srv_mit.so.121
OLD_LIBS+=usr/lib/libkdb5.so.121
OLD_LIBS+=usr/lib/libkrad.so.121
OLD_LIBS+=usr/lib/libkrb5.so.121
OLD_LIBS+=usr/lib/libkrb5profile.so.121
OLD_LIBS+=usr/lib/libkrb5support.so.121
OLD_LIBS+=usr/lib/libverto.so.121

# 20250726: xargs tests rewritten
OLD_FILES+=usr/tests/usr.bin/xargs/legacy_test
OLD_FILES+=usr/tests/usr.bin/xargs/regress.n2147483647.out
OLD_FILES+=usr/tests/usr.bin/xargs/regress.sh

# 20250726: This file is now installed in /etc/dma
OLD_FILES+=usr/share/examples/dma/auth.conf

# 20250725: libbsnmp bumped to version 7
OLD_LIBS+=usr/lib/libbsnmp.so.6

# 20250725: Files which were briefly installed by WITH_MITKRB5 in 15.0.
OLD_FILES+=usr/include/kadm5/admin_internal.h
OLD_FILES+=usr/include/kadm5/admin_xdr.h
OLD_FILES+=usr/include/kadm5/kadm_rpc.h
OLD_FILES+=usr/include/kadm5/server_internal.h
OLD_FILES+=usr/include/internal.h
OLD_FILES+=usr/include/t_daemon.h
OLD_FILES+=usr/include/t_test.h
OLD_FILES+=usr/include/dyn.h
OLD_FILES+=usr/include/dynP.h
OLD_FILES+=usr/include/gssrpcint.h
OLD_FILES+=usr/include/import_err.h
OLD_FILES+=usr/share/man/man3/db_btree.3.gz
OLD_FILES+=usr/share/man/man3/db_hash.3.gz
OLD_FILES+=usr/share/man/man3/db_lock.3.gz
OLD_FILES+=usr/share/man/man3/db_log.3.gz
OLD_FILES+=usr/share/man/man3/db_mpool.3.gz
OLD_FILES+=usr/share/man/man3/db_open.3.gz
OLD_FILES+=usr/share/man/man3/db_recno.3.gz
OLD_FILES+=usr/share/man/man3/db_txn.3.gz
OLD_FILES+=usr/share/man/man5/profile.5.gz
OLD_FILES+=usr/share/man/man8/kamdin.local.8.gz

# 20250716: Remove an old manual page, vn(4) was removed in FreeBSD 5.0
OLD_FILES+=usr/share/man/man4/vn.4.gz

# 20250710: share: Delete bitrotted make_*_driver.sh scripts
OLD_FILES+=usr/share/examples/drivers/README
OLD_FILES+=usr/share/examples/drivers/make_device_driver.sh
OLD_FILES+=usr/share/examples/drivers/make_pseudo_driver.sh
OLD_DIRS+=usr/share/examples/drivers

# 20250710: shar(1) removed
OLD_FILES+=usr/bin/shar

# 20250708: For 34 days 15.0-CURRENT installed libkadm5clnt symlink without .so
OLD_FILES+=usr/lib/libkadm5clnt

# 20250626: For 11 days 15.0-CURRENT installed libtpool to the wrong location
MOVED_LIBS+=usr/lib/libtpool.so.2

# 20250626: replace yaml.lua with lyaml
OLD_FILES+=usr/share/flua/yaml.lua

# 20250615: don't install man page for absent function
OLD_FILES+=usr/share/man/man9/vm_map_simplify_entry.9.gz

# 20250615: OpenSSL 3.5.0
OLD_LIBS+=lib/libcrypto.so.30
OLD_FILES+=usr/include/openssl/asn1_mac.h
OLD_LIBS+=usr/lib/libssl.so.30
OLD_FILES+=usr/share/man/man3/TS_VERIFY_CTX_set_certs.3
OLD_FILES+=usr/share/man/man7/crypto.7
OLD_FILES+=usr/share/man/man7/migration_guide.7
OLD_FILES+=usr/share/man/man7/ssl.7

# 20250521: don't install zoneinfo version
OLD_FILES+=usr/share/zoneinfo/version

# 20250516: NDFREE(9) -> NDFREE_PNBUF(9)
OLD_FILES+=usr/share/man/man9/NDFREE.9.gz

# 20250511: mailx test renamed
OLD_FILES+=usr/tests/usr.bin/mail/mail_sigint_test

# 20250505: Remove audio(8) files after rename to sndctl(8)
OLD_FILES+=usr/sbin/audio
OLD_FILES+=usr/share/man/man8/audio.8.gz

# 20250409: removal of iwlwifi firmware files
OLD_FILES+=usr/share/doc/legal/intel_iwlwifi_firmware.LICENCE

# 20250331: removal of TCPPCAP
OLD_FILES+=usr/include/netinet/tcp_pcap.h

# 20250310: caroot bundle updated
OLD_FILES+=usr/share/certs/trusted/Entrust_Root_Certification_Authority_-_G4.pem
OLD_FILES+=usr/share/certs/trusted/SecureSign_RootCA11.pem
OLD_FILES+=usr/share/certs/trusted/Security_Communication_RootCA3.pem
OLD_FILES+=usr/share/certs/trusted/SwissSign_Silver_CA_-_G2.pem
OLD_FILES+=usr/share/certs/untrusted/AddTrust_External_Root.pem
OLD_FILES+=usr/share/certs/untrusted/AddTrust_Low-Value_Services_Root.pem
OLD_FILES+=usr/share/certs/untrusted/Staat_der_Nederlanden_Root_CA_-_G2.pem
OLD_FILES+=usr/share/certs/untrusted/Cybertrust_Global_Root.pem
OLD_FILES+=usr/share/certs/untrusted/DST_Root_CA_X3.pem
OLD_FILES+=usr/share/certs/untrusted/GlobalSign_Root_CA_-_R2.pem
OLD_FILES+=usr/share/certs/untrusted/QuoVadis_Root_CA.pem
OLD_FILES+=usr/share/certs/untrusted/Sonera_Class_2_Root_CA.pem
OLD_FILES+=usr/share/certs/untrusted/GeoTrust_Global_CA.pem
OLD_FILES+=usr/share/certs/untrusted/Staat_der_Nederlanden_EV_Root_CA.pem
OLD_FILES+=usr/share/certs/untrusted/E-Tugra_Certification_Authority.pem
OLD_FILES+=usr/share/certs/untrusted/Hongkong_Post_Root_CA_1.pem
OLD_FILES+=usr/share/certs/untrusted/Security_Communication_Root_CA.pem
OLD_FILES+=usr/share/certs/untrusted/Trustis_FPS_Root_CA.pem

# 20250205: bus_generic_attach.9 removed after the function was deprecated
OLD_FILES+=usr/share/man/man9/bus_generic_attach.9.gz

# 20250204: sys/vm/stack test symbols moved to /usr/lib/debug
OLD_FILES+=usr/tests/sys/vm/stack/.debug/libsoxstack.so.debug
OLD_DIRS+=usr/tests/sys/vm/stack/.debug

# 20250129: libdevinfo bumped to version 7
OLD_LIBS+=usr/lib/libdevinfo.so.6

# 20250123: Remove gvinum(8)
OLD_FILES+=sbin/gvinum
OLD_FILES+=usr/share/man/man8/gvinum.8.gz

# 20250122: Remove publickey(5) stuff
OLD_FILES+=usr/bin/chkey
OLD_FILES+=usr/bin/keylogin
OLD_FILES+=usr/bin/keylogout
OLD_FILES+=usr/sbin/keyserv
OLD_FILES+=usr/bin/newkey
OLD_FILES+=usr/share/man/man1/chkey.1.gz
OLD_FILES+=usr/share/man/man1/keylogin.1.gz
OLD_FILES+=usr/share/man/man1/keylogout.1.gz
OLD_FILES+=usr/share/man/man5/publickey.5.gz
OLD_FILES+=usr/share/man/man8/keyserv.1.gz
OLD_FILES+=etc/rc.d/keyserv

# 20241206: Remove Altera DE4 drivers
OLD_FILES+=usr/share/man/man4/altera_atse.4.gz
OLD_FILES+=usr/share/man/man4/altera_avgen.4.gz
OLD_FILES+=usr/share/man/man4/altera_jtag_uart.4.gz
OLD_FILES+=usr/share/man/man4/altera_sdcard.4.gz
OLD_FILES+=usr/share/man/man4/altera_sdcardc.4.gz
OLD_FILES+=usr/share/man/man4/atse.4.gz

# 20241124: library and tests of OpenBSD dc
OLD_FILES+=usr/share/misc/bc.library
OLD_FILES+=usr/tests/usr.bin/dc/Kyuafile
OLD_FILES+=usr/tests/usr.bin/dc/bcode
OLD_FILES+=usr/tests/usr.bin/dc/inout
OLD_DIRS+=usr/tests/usr.bin/dc

# 20241119: rewrite mv tests
OLD_FILES+=usr/tests/bin/mv/legacy_test

# 20241112: Retire MK_PROFILE support
OLD_FILES+=usr/lib/lib80211_p.a
OLD_FILES+=usr/lib/lib9p_p.a
OLD_FILES+=usr/lib/libBlocksRuntime_p.a
OLD_FILES+=usr/lib/libalias_dummy_p.a
OLD_FILES+=usr/lib/libalias_ftp_p.a
OLD_FILES+=usr/lib/libalias_irc_p.a
OLD_FILES+=usr/lib/libalias_nbt_p.a
OLD_FILES+=usr/lib/libalias_p.a
OLD_FILES+=usr/lib/libalias_pptp_p.a
OLD_FILES+=usr/lib/libalias_skinny_p.a
OLD_FILES+=usr/lib/libalias_smedia_p.a
OLD_FILES+=usr/lib/libarchive_p.a
OLD_FILES+=usr/lib/libasn1_p.a
OLD_FILES+=usr/lib/libavl_p.a
OLD_FILES+=usr/lib/libbe_p.a
OLD_FILES+=usr/lib/libbegemot_p.a
OLD_FILES+=usr/lib/libblacklist_p.a
OLD_FILES+=usr/lib/libbluetooth_p.a
OLD_FILES+=usr/lib/libbsdxml_p.a
OLD_FILES+=usr/lib/libbsm_p.a
OLD_FILES+=usr/lib/libbsnmp_p.a
OLD_FILES+=usr/lib/libbz2_p.a
OLD_FILES+=usr/lib/libc++_p.a
OLD_FILES+=usr/lib/libc_p.a
OLD_FILES+=usr/lib/libcalendar_p.a
OLD_FILES+=usr/lib/libcam_p.a
OLD_FILES+=usr/lib/libcom_err_p.a
OLD_FILES+=usr/lib/libcompat_p.a
OLD_FILES+=usr/lib/libcompiler_rt_p.a
OLD_FILES+=usr/lib/libcrypt_p.a
OLD_FILES+=usr/lib/libcrypto_p.a
OLD_FILES+=usr/lib/libctf_p.a
OLD_FILES+=usr/lib/libcurses_p.a
OLD_FILES+=usr/lib/libcursesw_p.a
OLD_FILES+=usr/lib/libcuse_p.a
OLD_FILES+=usr/lib/libcxxrt_p.a
OLD_FILES+=usr/lib/libdevctl_p.a
OLD_FILES+=usr/lib/libdevinfo_p.a
OLD_FILES+=usr/lib/libdevstat_p.a
OLD_FILES+=usr/lib/libdialog_p.a
OLD_FILES+=usr/lib/libdl_p.a
OLD_FILES+=usr/lib/libdpv_p.a
OLD_FILES+=usr/lib/libdtrace_p.a
OLD_FILES+=usr/lib/libdwarf_p.a
OLD_FILES+=usr/lib/libedit_p.a
OLD_FILES+=usr/lib/libefivar_p.a
OLD_FILES+=usr/lib/libelf_p.a
OLD_FILES+=usr/lib/libexecinfo_p.a
OLD_FILES+=usr/lib/libfetch_p.a
OLD_FILES+=usr/lib/libfigpar_p.a
OLD_FILES+=usr/lib/libfl_p.a
OLD_FILES+=usr/lib/libform_p.a
OLD_FILES+=usr/lib/libformw_p.a
OLD_FILES+=usr/lib/libgcc_eh_p.a
OLD_FILES+=usr/lib/libgcc_p.a
OLD_FILES+=usr/lib/libgeom_p.a
OLD_FILES+=usr/lib/libgpio_p.a
OLD_FILES+=usr/lib/libgssapi_krb5_p.a
OLD_FILES+=usr/lib/libgssapi_ntlm_p.a
OLD_FILES+=usr/lib/libgssapi_p.a
OLD_FILES+=usr/lib/libgssapi_spnego_p.a
OLD_FILES+=usr/lib/libhdb_p.a
OLD_FILES+=usr/lib/libheimbase_p.a
OLD_FILES+=usr/lib/libheimntlm_p.a
OLD_FILES+=usr/lib/libheimsqlite_p.a
OLD_FILES+=usr/lib/libhistory_p.a
OLD_FILES+=usr/lib/libhx509_p.a
OLD_FILES+=usr/lib/libicp_p.a
OLD_FILES+=usr/lib/libicp_rescue_p.a
OLD_FILES+=usr/lib/libipsec_p.a
OLD_FILES+=usr/lib/libipt_p.a
OLD_FILES+=usr/lib/libjail_p.a
OLD_FILES+=usr/lib/libkadm5clnt_p.a
OLD_FILES+=usr/lib/libkadm5srv_p.a
OLD_FILES+=usr/lib/libkafs5_p.a
OLD_FILES+=usr/lib/libkdc_p.a
OLD_FILES+=usr/lib/libkiconv_p.a
OLD_FILES+=usr/lib/libkrb5_p.a
OLD_FILES+=usr/lib/libkvm_p.a
OLD_FILES+=usr/lib/libl_p.a
OLD_FILES+=usr/lib/libln_p.a
OLD_FILES+=usr/lib/liblzma_p.a
OLD_FILES+=usr/lib/libm_p.a
OLD_FILES+=usr/lib/libmagic_p.a
OLD_FILES+=usr/lib/libmd_p.a
OLD_FILES+=usr/lib/libmemstat_p.a
OLD_FILES+=usr/lib/libmenu_p.a
OLD_FILES+=usr/lib/libmenuw_p.a
OLD_FILES+=usr/lib/libmilter_p.a
OLD_FILES+=usr/lib/libmp_p.a
OLD_FILES+=usr/lib/libmt_p.a
OLD_FILES+=usr/lib/libncurses_p.a
OLD_FILES+=usr/lib/libncursesw_p.a
OLD_FILES+=usr/lib/libnetgraph_p.a
OLD_FILES+=usr/lib/libnetmap_p.a
OLD_FILES+=usr/lib/libnss_tacplus_p.a
OLD_FILES+=usr/lib/libnv_p.a
OLD_FILES+=usr/lib/libnvpair_p.a
OLD_FILES+=usr/lib/libopencsd_p.a
OLD_FILES+=usr/lib/libpanel_p.a
OLD_FILES+=usr/lib/libpanelw_p.a
OLD_FILES+=usr/lib/libpathconv_p.a
OLD_FILES+=usr/lib/libpcap_p.a
OLD_FILES+=usr/lib/libpjdlog_p.a
OLD_FILES+=usr/lib/libpmc_p.a
OLD_FILES+=usr/lib/libprivateatf-c++_p.a
OLD_FILES+=usr/lib/libprivateatf-c_p.a
OLD_FILES+=usr/lib/libprivateauditd_p.a
OLD_FILES+=usr/lib/libprivatebsdstat_p.a
OLD_FILES+=usr/lib/libprivatecbor_p.a
OLD_FILES+=usr/lib/libprivatedevdctl_p.a
OLD_FILES+=usr/lib/libprivateevent1_p.a
OLD_FILES+=usr/lib/libprivatefido2_p.a
OLD_FILES+=usr/lib/libprivategmock_main_p.a
OLD_FILES+=usr/lib/libprivategmock_p.a
OLD_FILES+=usr/lib/libprivategtest_main_p.a
OLD_FILES+=usr/lib/libprivategtest_p.a
OLD_FILES+=usr/lib/libprivateheimipcc_p.a
OLD_FILES+=usr/lib/libprivateheimipcs_p.a
OLD_FILES+=usr/lib/libprivateldns_p.a
OLD_FILES+=usr/lib/libprivatesqlite3_p.a
OLD_FILES+=usr/lib/libprivatessh_p.a
OLD_FILES+=usr/lib/libprivateucl_p.a
OLD_FILES+=usr/lib/libprivateunbound_p.a
OLD_FILES+=usr/lib/libprivatezstd_p.a
OLD_FILES+=usr/lib/libproc_p.a
OLD_FILES+=usr/lib/libprocstat_p.a
OLD_FILES+=usr/lib/libpthread_p.a
OLD_FILES+=usr/lib/libradius_p.a
OLD_FILES+=usr/lib/libregex_p.a
OLD_FILES+=usr/lib/libroken_p.a
OLD_FILES+=usr/lib/librpcsvc_p.a
OLD_FILES+=usr/lib/librss_p.a
OLD_FILES+=usr/lib/librt_p.a
OLD_FILES+=usr/lib/librtld_db_p.a
OLD_FILES+=usr/lib/libsbuf_p.a
OLD_FILES+=usr/lib/libsdp_p.a
OLD_FILES+=usr/lib/libsmb_p.a
OLD_FILES+=usr/lib/libspl_p.a
OLD_FILES+=usr/lib/libssl_p.a
OLD_FILES+=usr/lib/libstats_p.a
OLD_FILES+=usr/lib/libstdbuf_p.a
OLD_FILES+=usr/lib/libstdthreads_p.a
OLD_FILES+=usr/lib/libsysdecode_p.a
OLD_FILES+=usr/lib/libtacplus_p.a
OLD_FILES+=usr/lib/libtermcap_p.a
OLD_FILES+=usr/lib/libtermcapw_p.a
OLD_FILES+=usr/lib/libtermlib_p.a
OLD_FILES+=usr/lib/libtermlibw_p.a
OLD_FILES+=usr/lib/libthr_p.a
OLD_FILES+=usr/lib/libthread_db_p.a
OLD_FILES+=usr/lib/libtinfo_p.a
OLD_FILES+=usr/lib/libtinfow_p.a
OLD_FILES+=usr/lib/libtpool_p.a
OLD_FILES+=usr/lib/libufs_p.a
OLD_FILES+=usr/lib/libugidfw_p.a
OLD_FILES+=usr/lib/libulog_p.a
OLD_FILES+=usr/lib/libumem_p.a
OLD_FILES+=usr/lib/libusb_p.a
OLD_FILES+=usr/lib/libusbhid_p.a
OLD_FILES+=usr/lib/libutempter_p.a
OLD_FILES+=usr/lib/libutil_p.a
OLD_FILES+=usr/lib/libuutil_p.a
OLD_FILES+=usr/lib/libvgl_p.a
OLD_FILES+=usr/lib/libvmmapi_p.a
OLD_FILES+=usr/lib/libwind_p.a
OLD_FILES+=usr/lib/libwrap_p.a
OLD_FILES+=usr/lib/libxo_p.a
OLD_FILES+=usr/lib/liby_p.a
OLD_FILES+=usr/lib/libypclnt_p.a
OLD_FILES+=usr/lib/libz_p.a
OLD_FILES+=usr/lib/libzfs_core_p.a
OLD_FILES+=usr/lib/libzfs_p.a
OLD_FILES+=usr/lib/libzfsbootenv_p.a
OLD_FILES+=usr/lib/libzutil_p.a

# 20241112: move p9fs from section 5 to section 4
OLD_FILES+=usr/share/man/man5/p9fs.5.gz

# 20241104: remove the outdated c2x.7 symlink in favor of c23.7
OLD_FILES+=usr/share/man/man7/c2x.7.gz

# 20241023: new clang import which bumps version from 18 to 19
OLD_FILES+=usr/lib/clang/18/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/18/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/18/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/18/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/18/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/18/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/18/include/__clang_cuda_math.h
OLD_FILES+=usr/lib/clang/18/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/18/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/18/include/__clang_cuda_texture_intrinsics.h
OLD_FILES+=usr/lib/clang/18/include/__clang_hip_cmath.h
OLD_FILES+=usr/lib/clang/18/include/__clang_hip_libdevice_declares.h
OLD_FILES+=usr/lib/clang/18/include/__clang_hip_math.h
OLD_FILES+=usr/lib/clang/18/include/__clang_hip_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/18/include/__clang_hip_stdlib.h
OLD_FILES+=usr/lib/clang/18/include/__stdarg___gnuc_va_list.h
OLD_FILES+=usr/lib/clang/18/include/__stdarg___va_copy.h
OLD_FILES+=usr/lib/clang/18/include/__stdarg_va_arg.h
OLD_FILES+=usr/lib/clang/18/include/__stdarg_va_copy.h
OLD_FILES+=usr/lib/clang/18/include/__stdarg_va_list.h
OLD_FILES+=usr/lib/clang/18/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/18/include/__stddef_null.h
OLD_FILES+=usr/lib/clang/18/include/__stddef_nullptr_t.h
OLD_FILES+=usr/lib/clang/18/include/__stddef_offsetof.h
OLD_FILES+=usr/lib/clang/18/include/__stddef_ptrdiff_t.h
OLD_FILES+=usr/lib/clang/18/include/__stddef_rsize_t.h
OLD_FILES+=usr/lib/clang/18/include/__stddef_size_t.h
OLD_FILES+=usr/lib/clang/18/include/__stddef_unreachable.h
OLD_FILES+=usr/lib/clang/18/include/__stddef_wchar_t.h
OLD_FILES+=usr/lib/clang/18/include/__stddef_wint_t.h
OLD_FILES+=usr/lib/clang/18/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/18/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/18/include/adcintrin.h
OLD_FILES+=usr/lib/clang/18/include/adxintrin.h
OLD_FILES+=usr/lib/clang/18/include/altivec.h
OLD_FILES+=usr/lib/clang/18/include/ammintrin.h
OLD_FILES+=usr/lib/clang/18/include/amxcomplexintrin.h
OLD_FILES+=usr/lib/clang/18/include/amxfp16intrin.h
OLD_FILES+=usr/lib/clang/18/include/amxintrin.h
OLD_FILES+=usr/lib/clang/18/include/arm64intr.h
OLD_FILES+=usr/lib/clang/18/include/arm_acle.h
OLD_FILES+=usr/lib/clang/18/include/arm_bf16.h
OLD_FILES+=usr/lib/clang/18/include/arm_cde.h
OLD_FILES+=usr/lib/clang/18/include/arm_cmse.h
OLD_FILES+=usr/lib/clang/18/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/18/include/arm_mve.h
OLD_FILES+=usr/lib/clang/18/include/arm_neon.h
OLD_FILES+=usr/lib/clang/18/include/arm_neon_sve_bridge.h
OLD_FILES+=usr/lib/clang/18/include/arm_sme_draft_spec_subject_to_change.h
OLD_FILES+=usr/lib/clang/18/include/arm_sve.h
OLD_FILES+=usr/lib/clang/18/include/arm_vector_types.h
OLD_FILES+=usr/lib/clang/18/include/armintr.h
OLD_FILES+=usr/lib/clang/18/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512bf16intrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512fp16intrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vlbf16intrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vlfp16intrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vlvp2intersectintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vp2intersectintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/18/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/18/include/avxifmaintrin.h
OLD_FILES+=usr/lib/clang/18/include/avxintrin.h
OLD_FILES+=usr/lib/clang/18/include/avxneconvertintrin.h
OLD_FILES+=usr/lib/clang/18/include/avxvnniint16intrin.h
OLD_FILES+=usr/lib/clang/18/include/avxvnniint8intrin.h
OLD_FILES+=usr/lib/clang/18/include/avxvnniintrin.h
OLD_FILES+=usr/lib/clang/18/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/18/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/18/include/builtins.h
OLD_FILES+=usr/lib/clang/18/include/cet.h
OLD_FILES+=usr/lib/clang/18/include/cetintrin.h
OLD_FILES+=usr/lib/clang/18/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/18/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/18/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/18/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/18/include/cmpccxaddintrin.h
OLD_FILES+=usr/lib/clang/18/include/cpuid.h
OLD_FILES+=usr/lib/clang/18/include/crc32intrin.h
OLD_FILES+=usr/lib/clang/18/include/cuda_wrappers/algorithm
OLD_FILES+=usr/lib/clang/18/include/cuda_wrappers/bits/basic_string.h
OLD_FILES+=usr/lib/clang/18/include/cuda_wrappers/bits/basic_string.tcc
OLD_FILES+=usr/lib/clang/18/include/cuda_wrappers/bits/shared_ptr_base.h
OLD_DIRS+=usr/lib/clang/18/include/cuda_wrappers/bits
OLD_FILES+=usr/lib/clang/18/include/cuda_wrappers/cmath
OLD_FILES+=usr/lib/clang/18/include/cuda_wrappers/complex
OLD_FILES+=usr/lib/clang/18/include/cuda_wrappers/new
OLD_DIRS+=usr/lib/clang/18/include/cuda_wrappers
OLD_FILES+=usr/lib/clang/18/include/emmintrin.h
OLD_FILES+=usr/lib/clang/18/include/enqcmdintrin.h
OLD_FILES+=usr/lib/clang/18/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/18/include/float.h
OLD_FILES+=usr/lib/clang/18/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/18/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/18/include/fuzzer/FuzzedDataProvider.h
OLD_DIRS+=usr/lib/clang/18/include/fuzzer
OLD_FILES+=usr/lib/clang/18/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/18/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/18/include/hexagon_circ_brev_intrinsics.h
OLD_FILES+=usr/lib/clang/18/include/hexagon_protos.h
OLD_FILES+=usr/lib/clang/18/include/hexagon_types.h
OLD_FILES+=usr/lib/clang/18/include/hlsl/hlsl_basic_types.h
OLD_FILES+=usr/lib/clang/18/include/hlsl/hlsl_intrinsics.h
OLD_DIRS+=usr/lib/clang/18/include/hlsl
OLD_FILES+=usr/lib/clang/18/include/hlsl.h
OLD_FILES+=usr/lib/clang/18/include/hresetintrin.h
OLD_FILES+=usr/lib/clang/18/include/htmintrin.h
OLD_FILES+=usr/lib/clang/18/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/18/include/hvx_hexagon_protos.h
OLD_FILES+=usr/lib/clang/18/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/18/include/immintrin.h
OLD_FILES+=usr/lib/clang/18/include/intrin.h
OLD_FILES+=usr/lib/clang/18/include/inttypes.h
OLD_FILES+=usr/lib/clang/18/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/18/include/iso646.h
OLD_FILES+=usr/lib/clang/18/include/keylockerintrin.h
OLD_FILES+=usr/lib/clang/18/include/larchintrin.h
OLD_FILES+=usr/lib/clang/18/include/lasxintrin.h
OLD_FILES+=usr/lib/clang/18/include/limits.h
OLD_FILES+=usr/lib/clang/18/include/lsxintrin.h
OLD_FILES+=usr/lib/clang/18/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/18/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/18/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/18/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/18/include/mmintrin.h
OLD_FILES+=usr/lib/clang/18/include/module.modulemap
OLD_FILES+=usr/lib/clang/18/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/18/include/msa.h
OLD_FILES+=usr/lib/clang/18/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/18/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/18/include/omp-tools.h
OLD_FILES+=usr/lib/clang/18/include/omp.h
OLD_FILES+=usr/lib/clang/18/include/ompt.h
OLD_FILES+=usr/lib/clang/18/include/opencl-c-base.h
OLD_FILES+=usr/lib/clang/18/include/opencl-c.h
OLD_FILES+=usr/lib/clang/18/include/openmp_wrappers/__clang_openmp_device_functions.h
OLD_FILES+=usr/lib/clang/18/include/openmp_wrappers/cmath
OLD_FILES+=usr/lib/clang/18/include/openmp_wrappers/complex
OLD_FILES+=usr/lib/clang/18/include/openmp_wrappers/complex.h
OLD_FILES+=usr/lib/clang/18/include/openmp_wrappers/complex_cmath.h
OLD_FILES+=usr/lib/clang/18/include/openmp_wrappers/math.h
OLD_FILES+=usr/lib/clang/18/include/openmp_wrappers/new
OLD_DIRS+=usr/lib/clang/18/include/openmp_wrappers
OLD_FILES+=usr/lib/clang/18/include/orc_rt/c_api.h
OLD_DIRS+=usr/lib/clang/18/include/orc_rt
OLD_FILES+=usr/lib/clang/18/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/18/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/18/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/18/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/18/include/ppc_wrappers/bmi2intrin.h
OLD_FILES+=usr/lib/clang/18/include/ppc_wrappers/bmiintrin.h
OLD_FILES+=usr/lib/clang/18/include/ppc_wrappers/emmintrin.h
OLD_FILES+=usr/lib/clang/18/include/ppc_wrappers/immintrin.h
OLD_FILES+=usr/lib/clang/18/include/ppc_wrappers/mm_malloc.h
OLD_FILES+=usr/lib/clang/18/include/ppc_wrappers/mmintrin.h
OLD_FILES+=usr/lib/clang/18/include/ppc_wrappers/nmmintrin.h
OLD_FILES+=usr/lib/clang/18/include/ppc_wrappers/pmmintrin.h
OLD_FILES+=usr/lib/clang/18/include/ppc_wrappers/smmintrin.h
OLD_FILES+=usr/lib/clang/18/include/ppc_wrappers/tmmintrin.h
OLD_FILES+=usr/lib/clang/18/include/ppc_wrappers/x86gprintrin.h
OLD_FILES+=usr/lib/clang/18/include/ppc_wrappers/x86intrin.h
OLD_FILES+=usr/lib/clang/18/include/ppc_wrappers/xmmintrin.h
OLD_DIRS+=usr/lib/clang/18/include/ppc_wrappers
OLD_FILES+=usr/lib/clang/18/include/prfchiintrin.h
OLD_FILES+=usr/lib/clang/18/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/18/include/profile/InstrProfData.inc
OLD_FILES+=usr/lib/clang/18/include/profile/MemProfData.inc
OLD_DIRS+=usr/lib/clang/18/include/profile
OLD_FILES+=usr/lib/clang/18/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/18/include/raointintrin.h
OLD_FILES+=usr/lib/clang/18/include/rdpruintrin.h
OLD_FILES+=usr/lib/clang/18/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/18/include/riscv_bitmanip.h
OLD_FILES+=usr/lib/clang/18/include/riscv_crypto.h
OLD_FILES+=usr/lib/clang/18/include/riscv_ntlh.h
OLD_FILES+=usr/lib/clang/18/include/riscv_vector.h
OLD_FILES+=usr/lib/clang/18/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/18/include/s390intrin.h
OLD_FILES+=usr/lib/clang/18/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/18/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/18/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/18/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/18/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/18/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/18/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/18/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/18/include/sanitizer/memprof_interface.h
OLD_FILES+=usr/lib/clang/18/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/18/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/18/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/18/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/18/include/sanitizer/tsan_interface_atomic.h
OLD_FILES+=usr/lib/clang/18/include/sanitizer/ubsan_interface.h
OLD_DIRS+=usr/lib/clang/18/include/sanitizer
OLD_FILES+=usr/lib/clang/18/include/serializeintrin.h
OLD_FILES+=usr/lib/clang/18/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/18/include/sha512intrin.h
OLD_FILES+=usr/lib/clang/18/include/shaintrin.h
OLD_FILES+=usr/lib/clang/18/include/sifive_vector.h
OLD_FILES+=usr/lib/clang/18/include/sm3intrin.h
OLD_FILES+=usr/lib/clang/18/include/sm4intrin.h
OLD_FILES+=usr/lib/clang/18/include/smmintrin.h
OLD_FILES+=usr/lib/clang/18/include/stdalign.h
OLD_FILES+=usr/lib/clang/18/include/stdarg.h
OLD_FILES+=usr/lib/clang/18/include/stdatomic.h
OLD_FILES+=usr/lib/clang/18/include/stdbool.h
OLD_FILES+=usr/lib/clang/18/include/stdckdint.h
OLD_FILES+=usr/lib/clang/18/include/stddef.h
OLD_FILES+=usr/lib/clang/18/include/stdint.h
OLD_FILES+=usr/lib/clang/18/include/stdnoreturn.h
OLD_FILES+=usr/lib/clang/18/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/18/include/tgmath.h
OLD_FILES+=usr/lib/clang/18/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/18/include/tsxldtrkintrin.h
OLD_FILES+=usr/lib/clang/18/include/uintrintrin.h
OLD_FILES+=usr/lib/clang/18/include/unwind.h
OLD_FILES+=usr/lib/clang/18/include/usermsrintrin.h
OLD_FILES+=usr/lib/clang/18/include/vadefs.h
OLD_FILES+=usr/lib/clang/18/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/18/include/varargs.h
OLD_FILES+=usr/lib/clang/18/include/vecintrin.h
OLD_FILES+=usr/lib/clang/18/include/velintrin.h
OLD_FILES+=usr/lib/clang/18/include/velintrin_approx.h
OLD_FILES+=usr/lib/clang/18/include/velintrin_gen.h
OLD_FILES+=usr/lib/clang/18/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/18/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/18/include/wasm_simd128.h
OLD_FILES+=usr/lib/clang/18/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/18/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/18/include/x86gprintrin.h
OLD_FILES+=usr/lib/clang/18/include/x86intrin.h
OLD_FILES+=usr/lib/clang/18/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/18/include/xopintrin.h
OLD_FILES+=usr/lib/clang/18/include/xray/xray_interface.h
OLD_FILES+=usr/lib/clang/18/include/xray/xray_log_interface.h
OLD_FILES+=usr/lib/clang/18/include/xray/xray_records.h
OLD_DIRS+=usr/lib/clang/18/include/xray
OLD_FILES+=usr/lib/clang/18/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/18/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/18/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/18/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/18/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/18/include
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-aarch64.so
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-arm.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-arm.so
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-armhf.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-armhf.so
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-powerpc64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-powerpc64.so
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-powerpc64le.so
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-preinit-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-preinit-arm.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-preinit-armhf.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-preinit-powerpc64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-preinit-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-preinit-riscv64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-riscv64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-riscv64.so
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan_cxx-arm.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan_cxx-armhf.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan_cxx-riscv64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan_static-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan_static-i386.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan_static-powerpc64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan_static-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.asan_static-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.cfi-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.cfi-arm.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.cfi-armhf.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.cfi-i386.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.cfi-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.cfi_diag-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.cfi_diag-arm.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.cfi_diag-armhf.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.cfi_diag-i386.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.cfi_diag-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.dd-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.dd-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.fuzzer-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.fuzzer-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.fuzzer_interceptors-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.fuzzer_interceptors-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.fuzzer_no_main-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.fuzzer_no_main-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.msan-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.msan-powerpc64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.msan-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.msan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.msan_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.msan_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.profile-powerpc.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.profile-powerpc64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.profile-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.profile-riscv64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.safestack-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.stats-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.stats-arm.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.stats-armhf.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.stats-powerpc64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.stats-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.stats-riscv64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.stats_client-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.stats_client-arm.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.stats_client-armhf.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.stats_client-powerpc64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.stats_client-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.stats_client-riscv64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.tsan-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.tsan-powerpc64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.tsan-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.tsan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.tsan_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.tsan_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_minimal-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_minimal-arm.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_minimal-armhf.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_minimal-powerpc64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_minimal-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_minimal-riscv64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_standalone-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_standalone-arm.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_standalone-armhf.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_standalone-powerpc64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_standalone-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_standalone-riscv64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_standalone_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_standalone_cxx-arm.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_standalone_cxx-armhf.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_standalone_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_standalone_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_standalone_cxx-riscv64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-arm.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-armhf.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-basic-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-basic-arm.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-basic-armhf.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-basic-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-basic-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-fdr-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-fdr-arm.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-fdr-armhf.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-fdr-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-fdr-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-profiling-aarch64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-profiling-arm.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-profiling-armhf.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-profiling-powerpc64le.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-profiling-x86_64.a
OLD_FILES+=usr/lib/clang/18/lib/freebsd/libclang_rt.xray-x86_64.a
OLD_DIRS+=usr/lib/clang/18/lib/freebsd
OLD_DIRS+=usr/lib/clang/18/lib
OLD_FILES+=usr/lib/clang/18/share/asan_ignorelist.txt
OLD_FILES+=usr/lib/clang/18/share/cfi_ignorelist.txt
OLD_FILES+=usr/lib/clang/18/share/msan_ignorelist.txt
OLD_DIRS+=usr/lib/clang/18/share
OLD_DIRS+=usr/lib/clang/18

# 20241023: new libc++ import which bumps version from 18 to 19
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_any_all_none_of.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_backend.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_backends/cpu_backend.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_backends/cpu_backends/any_of.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_backends/cpu_backends/backend.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_backends/cpu_backends/fill.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_backends/cpu_backends/find_if.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_backends/cpu_backends/for_each.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_backends/cpu_backends/libdispatch.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_backends/cpu_backends/merge.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_backends/cpu_backends/serial.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_backends/cpu_backends/stable_sort.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_backends/cpu_backends/thread.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_backends/cpu_backends/transform.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_backends/cpu_backends/transform_reduce.h
OLD_DIRS+=usr/include/c++/v1/__algorithm/pstl_backends/cpu_backends
OLD_DIRS+=usr/include/c++/v1/__algorithm/pstl_backends
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_copy.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_count.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_equal.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_fill.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_find.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_for_each.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_frontend_dispatch.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_generate.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_is_partitioned.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_merge.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_move.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_replace.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_rotate_copy.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_sort.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_stable_sort.h
OLD_FILES+=usr/include/c++/v1/__algorithm/pstl_transform.h
OLD_FILES+=usr/include/c++/v1/__availability
OLD_FILES+=usr/include/c++/v1/__format/format_fwd.h
OLD_FILES+=usr/include/c++/v1/__fwd/get.h
OLD_FILES+=usr/include/c++/v1/__fwd/hash.h
OLD_FILES+=usr/include/c++/v1/__numeric/pstl_reduce.h
OLD_FILES+=usr/include/c++/v1/__numeric/pstl_transform_reduce.h
OLD_FILES+=usr/include/c++/v1/__threading_support
OLD_FILES+=usr/include/c++/v1/__tuple/pair_like.h
OLD_FILES+=usr/include/c++/v1/__type_traits/apply_cv.h
OLD_FILES+=usr/include/c++/v1/__type_traits/is_copy_assignable.h
OLD_FILES+=usr/include/c++/v1/__type_traits/is_copy_constructible.h
OLD_FILES+=usr/include/c++/v1/__type_traits/is_default_constructible.h
OLD_FILES+=usr/include/c++/v1/__type_traits/is_move_assignable.h
OLD_FILES+=usr/include/c++/v1/__type_traits/is_move_constructible.h
OLD_FILES+=usr/include/c++/v1/__type_traits/is_nothrow_copy_assignable.h
OLD_FILES+=usr/include/c++/v1/__type_traits/is_nothrow_copy_constructible.h
OLD_FILES+=usr/include/c++/v1/__type_traits/is_nothrow_default_constructible.h
OLD_FILES+=usr/include/c++/v1/__type_traits/is_nothrow_move_assignable.h
OLD_FILES+=usr/include/c++/v1/__type_traits/is_nothrow_move_constructible.h
OLD_FILES+=usr/include/c++/v1/__type_traits/is_trivially_copy_assignable.h
OLD_FILES+=usr/include/c++/v1/__type_traits/is_trivially_copy_constructible.h
OLD_FILES+=usr/include/c++/v1/__type_traits/is_trivially_default_constructible.h
OLD_FILES+=usr/include/c++/v1/__type_traits/is_trivially_move_assignable.h
OLD_FILES+=usr/include/c++/v1/__type_traits/is_trivially_move_constructible.h
OLD_FILES+=usr/include/c++/v1/__type_traits/operation_traits.h
OLD_FILES+=usr/include/c++/v1/experimental/__memory

# 20241014: move divapp to netpfil/common/
OLD_FILES+=usr/tests/sys/netpfil/pf/divapp

# 20240930: libmd bumped to version 7
OLD_LIBS+=lib/libmd.so.6

# 20240827: retire fips.so
OLD_LIBS+=usr/lib/ossl-modules/fips.so

# 20240824: sound examples: midi.c moved out of oss/
OLD_FILES+=usr/share/examples/sound/oss/midi.c

# 20240824: sound examples: Remove ossinit.h and rename basic.c to audio.c
OLD_FILES+=usr/share/examples/sound/oss/ossinit.h
OLD_FILES+=usr/share/examples/sound/oss/basic.c

# 20240824: sound examples: Remove ossmidi.h
OLD_FILES+=usr/share/examples/sound/oss/ossmidi.h

# 20240729: rename quick_exit_test to libc_exit_test
OLD_FILES+=usr/tests/lib/libc/stdlib/quick_exit_test

# 20240729: retire ifaddr_byindex
OLD_FILES+=usr/share/man/man9/ifaddr_byindex.9.gz

# 20240729: remove MD5(9)
OLD_FILES+=usr/share/man/man9/MD5.9.gz
OLD_FILES+=usr/share/man/man9/MD5Init.9.gz
OLD_FILES+=usr/share/man/man9/MD5Transform.9.gz

# 20240726: deprecate contigfree(9)
OLD_FILES+=usr/share/man/man9/contigfree.9.gz

# 20240721: retire vm_page_alloc_freelist
OLD_FILES+=usr/share/man/man9/vm_page_alloc_freelist.9.gz
OLD_FILES+=usr/share/man/man9/vm_page_alloc_freelist_domain.9.gz

# 20240716: retire mergemaster
OLD_FILES+=usr/sbin/mergemaster
OLD_FILES+=usr/share/man/man8/mergemaster.8.gz

# 20240527: csh: Remove hardlink /.cshrc
OLD_FILES+=.cshrc

# 20240511: move file system driver manuals to section four
OLD_FILES+=usr/share/man/man5/autofs.5.gz
OLD_FILES+=usr/share/man/man5/cd9660.5.gz
OLD_FILES+=usr/share/man/man5/devfs.5.gz
OLD_FILES+=usr/share/man/man5/ext2fs.5.gz
OLD_FILES+=usr/share/man/man5/ext4fs.5.gz
OLD_FILES+=usr/share/man/man5/fdescfs.5.gz
OLD_FILES+=usr/share/man/man5/fusefs.5.gz
OLD_FILES+=usr/share/man/man5/lindebugfs.5.gz
OLD_FILES+=usr/share/man/man5/linprocfs.5.gz
OLD_FILES+=usr/share/man/man5/linsysfs.5.gz
OLD_FILES+=usr/share/man/man5/mqueuefs.5.gz
OLD_FILES+=usr/share/man/man5/msdosfs.5.gz
OLD_FILES+=usr/share/man/man5/msdos.5.gz
OLD_FILES+=usr/share/man/man5/nullfs.5.gz
OLD_FILES+=usr/share/man/man5/procfs.5.gz
OLD_FILES+=usr/share/man/man5/smbfs.5.gz
OLD_FILES+=usr/share/man/man5/tarfs.5.gz
OLD_FILES+=usr/share/man/man5/tmpfs.5.gz
OLD_FILES+=usr/share/man/man5/unionfs.5.gz
OLD_FILES+=usr/share/man/man7/ffs.7.gz

# 20240508: Remove remnants of portsnap(8)
OLD_DIRS+=var/db/portsnap

# 20240507: remove gbde
OLD_FILES+=boot/kernel/geom_bde.ko
OLD_FILES+=etc/rc.d/gbde
OLD_FILES+=rescue/gbde
OLD_FILES+=sbin/gbde
OLD_FILES+=usr/share/man/man4/gbde.4.gz
OLD_FILES+=usr/share/man/man8/gbde.8.gz

# 20240422: remove improperly installed libcxxrt.so.1
MOVED_LIBS+=usr/lib/libcxxrt.so.1

# 20240414: unix_socketpair_test renamed
OLD_FILES+=usr/tests/sys/kern/unix_socketpair_test

# 20240406: new clang import which bumps version from 17 to 18
OLD_FILES+=usr/lib/clang/17/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/17/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/17/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/17/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/17/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/17/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/17/include/__clang_cuda_math.h
OLD_FILES+=usr/lib/clang/17/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/17/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/17/include/__clang_cuda_texture_intrinsics.h
OLD_FILES+=usr/lib/clang/17/include/__clang_hip_cmath.h
OLD_FILES+=usr/lib/clang/17/include/__clang_hip_libdevice_declares.h
OLD_FILES+=usr/lib/clang/17/include/__clang_hip_math.h
OLD_FILES+=usr/lib/clang/17/include/__clang_hip_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/17/include/__clang_hip_stdlib.h
OLD_FILES+=usr/lib/clang/17/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/17/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/17/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/17/include/adxintrin.h
OLD_FILES+=usr/lib/clang/17/include/altivec.h
OLD_FILES+=usr/lib/clang/17/include/ammintrin.h
OLD_FILES+=usr/lib/clang/17/include/amxcomplexintrin.h
OLD_FILES+=usr/lib/clang/17/include/amxfp16intrin.h
OLD_FILES+=usr/lib/clang/17/include/amxintrin.h
OLD_FILES+=usr/lib/clang/17/include/arm64intr.h
OLD_FILES+=usr/lib/clang/17/include/arm_acle.h
OLD_FILES+=usr/lib/clang/17/include/arm_bf16.h
OLD_FILES+=usr/lib/clang/17/include/arm_cde.h
OLD_FILES+=usr/lib/clang/17/include/arm_cmse.h
OLD_FILES+=usr/lib/clang/17/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/17/include/arm_mve.h
OLD_FILES+=usr/lib/clang/17/include/arm_neon.h
OLD_FILES+=usr/lib/clang/17/include/arm_neon_sve_bridge.h
OLD_FILES+=usr/lib/clang/17/include/arm_sme_draft_spec_subject_to_change.h
OLD_FILES+=usr/lib/clang/17/include/arm_sve.h
OLD_FILES+=usr/lib/clang/17/include/armintr.h
OLD_FILES+=usr/lib/clang/17/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512bf16intrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512fp16intrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vlbf16intrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vlfp16intrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vlvp2intersectintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vp2intersectintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/17/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/17/include/avxifmaintrin.h
OLD_FILES+=usr/lib/clang/17/include/avxintrin.h
OLD_FILES+=usr/lib/clang/17/include/avxneconvertintrin.h
OLD_FILES+=usr/lib/clang/17/include/avxvnniint16intrin.h
OLD_FILES+=usr/lib/clang/17/include/avxvnniint8intrin.h
OLD_FILES+=usr/lib/clang/17/include/avxvnniintrin.h
OLD_FILES+=usr/lib/clang/17/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/17/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/17/include/builtins.h
OLD_FILES+=usr/lib/clang/17/include/cet.h
OLD_FILES+=usr/lib/clang/17/include/cetintrin.h
OLD_FILES+=usr/lib/clang/17/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/17/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/17/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/17/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/17/include/cmpccxaddintrin.h
OLD_FILES+=usr/lib/clang/17/include/cpuid.h
OLD_FILES+=usr/lib/clang/17/include/crc32intrin.h
OLD_FILES+=usr/lib/clang/17/include/cuda_wrappers/algorithm
OLD_FILES+=usr/lib/clang/17/include/cuda_wrappers/bits/basic_string.h
OLD_FILES+=usr/lib/clang/17/include/cuda_wrappers/bits/basic_string.tcc
OLD_FILES+=usr/lib/clang/17/include/cuda_wrappers/bits/shared_ptr_base.h
OLD_DIRS+=usr/lib/clang/17/include/cuda_wrappers/bits
OLD_FILES+=usr/lib/clang/17/include/cuda_wrappers/cmath
OLD_FILES+=usr/lib/clang/17/include/cuda_wrappers/complex
OLD_FILES+=usr/lib/clang/17/include/cuda_wrappers/new
OLD_FILES+=usr/lib/clang/17/include/cuda_wrappers/shared_ptr_base.h
OLD_DIRS+=usr/lib/clang/17/include/cuda_wrappers
OLD_FILES+=usr/lib/clang/17/include/emmintrin.h
OLD_FILES+=usr/lib/clang/17/include/enqcmdintrin.h
OLD_FILES+=usr/lib/clang/17/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/17/include/float.h
OLD_FILES+=usr/lib/clang/17/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/17/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/17/include/fuzzer/FuzzedDataProvider.h
OLD_DIRS+=usr/lib/clang/17/include/fuzzer
OLD_FILES+=usr/lib/clang/17/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/17/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/17/include/hexagon_circ_brev_intrinsics.h
OLD_FILES+=usr/lib/clang/17/include/hexagon_protos.h
OLD_FILES+=usr/lib/clang/17/include/hexagon_types.h
OLD_FILES+=usr/lib/clang/17/include/hlsl/hlsl_basic_types.h
OLD_FILES+=usr/lib/clang/17/include/hlsl/hlsl_intrinsics.h
OLD_DIRS+=usr/lib/clang/17/include/hlsl
OLD_FILES+=usr/lib/clang/17/include/hlsl.h
OLD_FILES+=usr/lib/clang/17/include/hresetintrin.h
OLD_FILES+=usr/lib/clang/17/include/htmintrin.h
OLD_FILES+=usr/lib/clang/17/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/17/include/hvx_hexagon_protos.h
OLD_FILES+=usr/lib/clang/17/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/17/include/immintrin.h
OLD_FILES+=usr/lib/clang/17/include/intrin.h
OLD_FILES+=usr/lib/clang/17/include/inttypes.h
OLD_FILES+=usr/lib/clang/17/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/17/include/iso646.h
OLD_FILES+=usr/lib/clang/17/include/keylockerintrin.h
OLD_FILES+=usr/lib/clang/17/include/larchintrin.h
OLD_FILES+=usr/lib/clang/17/include/limits.h
OLD_FILES+=usr/lib/clang/17/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/17/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/17/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/17/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/17/include/mmintrin.h
OLD_FILES+=usr/lib/clang/17/include/module.modulemap
OLD_FILES+=usr/lib/clang/17/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/17/include/msa.h
OLD_FILES+=usr/lib/clang/17/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/17/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/17/include/omp-tools.h
OLD_FILES+=usr/lib/clang/17/include/omp.h
OLD_FILES+=usr/lib/clang/17/include/ompt.h
OLD_FILES+=usr/lib/clang/17/include/opencl-c-base.h
OLD_FILES+=usr/lib/clang/17/include/opencl-c.h
OLD_FILES+=usr/lib/clang/17/include/openmp_wrappers/__clang_openmp_device_functions.h
OLD_FILES+=usr/lib/clang/17/include/openmp_wrappers/cmath
OLD_FILES+=usr/lib/clang/17/include/openmp_wrappers/complex
OLD_FILES+=usr/lib/clang/17/include/openmp_wrappers/complex.h
OLD_FILES+=usr/lib/clang/17/include/openmp_wrappers/complex_cmath.h
OLD_FILES+=usr/lib/clang/17/include/openmp_wrappers/math.h
OLD_FILES+=usr/lib/clang/17/include/openmp_wrappers/new
OLD_DIRS+=usr/lib/clang/17/include/openmp_wrappers
OLD_FILES+=usr/lib/clang/17/include/orc_rt/c_api.h
OLD_DIRS+=usr/lib/clang/17/include/orc_rt
OLD_FILES+=usr/lib/clang/17/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/17/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/17/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/17/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/17/include/ppc_wrappers/bmi2intrin.h
OLD_FILES+=usr/lib/clang/17/include/ppc_wrappers/bmiintrin.h
OLD_FILES+=usr/lib/clang/17/include/ppc_wrappers/emmintrin.h
OLD_FILES+=usr/lib/clang/17/include/ppc_wrappers/immintrin.h
OLD_FILES+=usr/lib/clang/17/include/ppc_wrappers/mm_malloc.h
OLD_FILES+=usr/lib/clang/17/include/ppc_wrappers/mmintrin.h
OLD_FILES+=usr/lib/clang/17/include/ppc_wrappers/pmmintrin.h
OLD_FILES+=usr/lib/clang/17/include/ppc_wrappers/smmintrin.h
OLD_FILES+=usr/lib/clang/17/include/ppc_wrappers/tmmintrin.h
OLD_FILES+=usr/lib/clang/17/include/ppc_wrappers/x86gprintrin.h
OLD_FILES+=usr/lib/clang/17/include/ppc_wrappers/x86intrin.h
OLD_FILES+=usr/lib/clang/17/include/ppc_wrappers/xmmintrin.h
OLD_DIRS+=usr/lib/clang/17/include/ppc_wrappers
OLD_FILES+=usr/lib/clang/17/include/prfchiintrin.h
OLD_FILES+=usr/lib/clang/17/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/17/include/profile/InstrProfData.inc
OLD_FILES+=usr/lib/clang/17/include/profile/MemProfData.inc
OLD_DIRS+=usr/lib/clang/17/include/profile
OLD_FILES+=usr/lib/clang/17/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/17/include/raointintrin.h
OLD_FILES+=usr/lib/clang/17/include/rdpruintrin.h
OLD_FILES+=usr/lib/clang/17/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/17/include/riscv_ntlh.h
OLD_FILES+=usr/lib/clang/17/include/riscv_vector.h
OLD_FILES+=usr/lib/clang/17/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/17/include/s390intrin.h
OLD_FILES+=usr/lib/clang/17/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/17/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/17/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/17/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/17/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/17/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/17/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/17/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/17/include/sanitizer/memprof_interface.h
OLD_FILES+=usr/lib/clang/17/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/17/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/17/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/17/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/17/include/sanitizer/tsan_interface_atomic.h
OLD_FILES+=usr/lib/clang/17/include/sanitizer/ubsan_interface.h
OLD_DIRS+=usr/lib/clang/17/include/sanitizer
OLD_FILES+=usr/lib/clang/17/include/serializeintrin.h
OLD_FILES+=usr/lib/clang/17/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/17/include/sha512intrin.h
OLD_FILES+=usr/lib/clang/17/include/shaintrin.h
OLD_FILES+=usr/lib/clang/17/include/sifive_vector.h
OLD_FILES+=usr/lib/clang/17/include/sm3intrin.h
OLD_FILES+=usr/lib/clang/17/include/sm4intrin.h
OLD_FILES+=usr/lib/clang/17/include/smmintrin.h
OLD_FILES+=usr/lib/clang/17/include/stdalign.h
OLD_FILES+=usr/lib/clang/17/include/stdarg.h
OLD_FILES+=usr/lib/clang/17/include/stdatomic.h
OLD_FILES+=usr/lib/clang/17/include/stdbool.h
OLD_FILES+=usr/lib/clang/17/include/stddef.h
OLD_FILES+=usr/lib/clang/17/include/stdint.h
OLD_FILES+=usr/lib/clang/17/include/stdnoreturn.h
OLD_FILES+=usr/lib/clang/17/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/17/include/tgmath.h
OLD_FILES+=usr/lib/clang/17/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/17/include/tsxldtrkintrin.h
OLD_FILES+=usr/lib/clang/17/include/uintrintrin.h
OLD_FILES+=usr/lib/clang/17/include/unwind.h
OLD_FILES+=usr/lib/clang/17/include/vadefs.h
OLD_FILES+=usr/lib/clang/17/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/17/include/varargs.h
OLD_FILES+=usr/lib/clang/17/include/vecintrin.h
OLD_FILES+=usr/lib/clang/17/include/velintrin.h
OLD_FILES+=usr/lib/clang/17/include/velintrin_approx.h
OLD_FILES+=usr/lib/clang/17/include/velintrin_gen.h
OLD_FILES+=usr/lib/clang/17/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/17/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/17/include/wasm_simd128.h
OLD_FILES+=usr/lib/clang/17/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/17/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/17/include/x86gprintrin.h
OLD_FILES+=usr/lib/clang/17/include/x86intrin.h
OLD_FILES+=usr/lib/clang/17/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/17/include/xopintrin.h
OLD_FILES+=usr/lib/clang/17/include/xray/xray_interface.h
OLD_FILES+=usr/lib/clang/17/include/xray/xray_log_interface.h
OLD_FILES+=usr/lib/clang/17/include/xray/xray_records.h
OLD_DIRS+=usr/lib/clang/17/include/xray
OLD_FILES+=usr/lib/clang/17/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/17/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/17/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/17/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/17/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/17/include
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-aarch64.so
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-arm.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-arm.so
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-armhf.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-armhf.so
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-powerpc64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-powerpc64.so
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-powerpc64le.so
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-preinit-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-preinit-arm.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-preinit-armhf.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-preinit-powerpc64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-preinit-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-preinit-riscv64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-riscv64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-riscv64.so
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan_cxx-arm.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan_cxx-armhf.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan_cxx-riscv64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan_static-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan_static-i386.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan_static-powerpc64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan_static-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan_static-riscv64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.asan_static-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.cfi-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.cfi-arm.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.cfi-armhf.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.cfi-i386.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.cfi-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.cfi_diag-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.cfi_diag-arm.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.cfi_diag-armhf.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.cfi_diag-i386.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.cfi_diag-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.dd-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.dd-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.fuzzer-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.fuzzer-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.fuzzer_interceptors-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.fuzzer_interceptors-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.fuzzer_no_main-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.fuzzer_no_main-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.msan-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.msan-powerpc64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.msan-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.msan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.msan_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.msan_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.profile-powerpc.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.profile-powerpc64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.profile-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.profile-riscv64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.safestack-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.stats-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.stats-arm.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.stats-armhf.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.stats-powerpc64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.stats-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.stats-riscv64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.stats_client-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.stats_client-arm.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.stats_client-armhf.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.stats_client-powerpc64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.stats_client-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.stats_client-riscv64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.tsan-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.tsan-powerpc64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.tsan-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.tsan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.tsan_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.tsan_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_minimal-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_minimal-arm.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_minimal-armhf.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_minimal-powerpc64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_minimal-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_minimal-riscv64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_standalone-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_standalone-arm.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_standalone-armhf.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_standalone-powerpc64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_standalone-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_standalone-riscv64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_standalone_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_standalone_cxx-arm.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_standalone_cxx-armhf.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_standalone_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_standalone_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_standalone_cxx-riscv64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-arm.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-armhf.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-basic-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-basic-arm.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-basic-armhf.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-basic-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-basic-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-fdr-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-fdr-arm.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-fdr-armhf.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-fdr-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-fdr-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-profiling-aarch64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-profiling-arm.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-profiling-armhf.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-profiling-powerpc64le.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-profiling-x86_64.a
OLD_FILES+=usr/lib/clang/17/lib/freebsd/libclang_rt.xray-x86_64.a
OLD_DIRS+=usr/lib/clang/17/lib/freebsd
OLD_DIRS+=usr/lib/clang/17/lib
OLD_FILES+=usr/lib/clang/17/share/asan_ignorelist.txt
OLD_FILES+=usr/lib/clang/17/share/cfi_ignorelist.txt
OLD_FILES+=usr/lib/clang/17/share/msan_ignorelist.txt
OLD_DIRS+=usr/lib/clang/17/share
OLD_DIRS+=usr/lib/clang/17

# 20240406: new libc++ import which bumps version from 17 to 18
OLD_FILES+=usr/include/c++/v1/__pstl/internal/algorithm_fwd.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/algorithm_impl.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/execution_defs.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/execution_impl.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/glue_algorithm_defs.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/glue_algorithm_impl.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/glue_memory_defs.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/glue_memory_impl.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/glue_numeric_defs.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/glue_numeric_impl.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/memory_impl.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/numeric_fwd.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/numeric_impl.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/omp/parallel_for.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/omp/parallel_for_each.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/omp/parallel_invoke.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/omp/parallel_merge.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/omp/parallel_scan.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/omp/parallel_stable_partial_sort.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/omp/parallel_stable_sort.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/omp/parallel_transform_reduce.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/omp/parallel_transform_scan.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/omp/util.h
OLD_DIRS+=usr/include/c++/v1/__pstl/internal/omp
OLD_FILES+=usr/include/c++/v1/__pstl/internal/parallel_backend.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/parallel_backend_omp.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/parallel_backend_serial.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/parallel_backend_tbb.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/parallel_backend_utils.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/unseq_backend_simd.h
OLD_FILES+=usr/include/c++/v1/__pstl/internal/utils.h
OLD_DIRS+=usr/include/c++/v1/__pstl/internal
OLD_FILES+=usr/include/c++/v1/__pstl_algorithm
OLD_FILES+=usr/include/c++/v1/__pstl_memory
OLD_FILES+=usr/include/c++/v1/__pstl_numeric
OLD_FILES+=usr/include/c++/v1/__type_traits/predicate_traits.h
OLD_FILES+=usr/include/c++/v1/__utility/terminate_on_exception.h
OLD_FILES+=usr/include/c++/v1/experimental/deque
OLD_FILES+=usr/include/c++/v1/experimental/forward_list
OLD_FILES+=usr/include/c++/v1/experimental/list
OLD_FILES+=usr/include/c++/v1/experimental/map
OLD_FILES+=usr/include/c++/v1/experimental/memory_resource
OLD_FILES+=usr/include/c++/v1/experimental/regex
OLD_FILES+=usr/include/c++/v1/experimental/set
OLD_FILES+=usr/include/c++/v1/experimental/string
OLD_FILES+=usr/include/c++/v1/experimental/unordered_map
OLD_FILES+=usr/include/c++/v1/experimental/unordered_set
OLD_FILES+=usr/include/c++/v1/experimental/vector
OLD_FILES+=usr/include/c++/v1/limits.h
OLD_FILES+=usr/include/c++/v1/setjmp.h

# 20240321: remove empty /usr/libdata/gcc directory
OLD_DIRS+=usr/libdata/gcc

# 20240315: stop installing CAM.4 link to scsi.4
OLD_FILES+=usr/share/man/man4/CAM.4.gz

# 20240307: Improperly installed awk tests removed
OLD_FILES+=usr/tests/usr.bin/awk/bugs-fixed/missing-precision.ok
OLD_FILES+=usr/tests/usr.bin/awk/bugs-fixed/negative-nf.ok
OLD_FILES+=usr/tests/usr.bin/awk/bugs-fixed/pfile-overflow.ok
OLD_FILES+=usr/tests/usr.bin/awk/bugs-fixed/system-status.awk
OLD_FILES+=usr/tests/usr.bin/awk/bugs-fixed/system-status.bad
OLD_FILES+=usr/tests/usr.bin/awk/bugs-fixed/system-status.ok
OLD_FILES+=usr/tests/usr.bin/awk/bugs-fixed/system-status.ok2

# 20240211: caroot bundle updated
OLD_FILES+=usr/share/certs/trusted/Security_Communication_Root_CA.pem

# 20240202: remove obsolete share/examples/IPv6/USAGE
OLD_FILES+=usr/share/examples/IPv6/USAGE
OLD_DIRS+=usr/share/examples/IPv6

# 20240122: callout_async_drain() removed
OLD_FILES+=usr/share/man/man9/callout_async_drain.9.gz

# 20240114: Removal of geom_map(4)
OLD_FILES+=usr/share/man/man4/geom_map.4.gz

# 20240112: remove pmap_init2()
OLD_FILES+=usr/share/man/man9/pmap_init2.9.gz

# 20240112: remove pmap_pinit2()
OLD_FILES+=usr/share/man/man9/pmap_pinit2.9.gz

# 20240112: replaced NetBSD tests for uniq with our own
OLD_FILES+=usr/tests/usr.bin/uniq/d_basic.in
OLD_FILES+=usr/tests/usr.bin/uniq/d_basic.out
OLD_FILES+=usr/tests/usr.bin/uniq/d_counts.out
OLD_FILES+=usr/tests/usr.bin/uniq/d_input.in
OLD_FILES+=usr/tests/usr.bin/uniq/d_show_duplicates.out
OLD_FILES+=usr/tests/usr.bin/uniq/d_show_uniques.out

# 20231208: new clang import which bumps version from 16 to 17
OLD_FILES+=usr/lib/clang/16/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/16/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/16/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/16/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/16/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/16/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/16/include/__clang_cuda_math.h
OLD_FILES+=usr/lib/clang/16/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/16/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/16/include/__clang_cuda_texture_intrinsics.h
OLD_FILES+=usr/lib/clang/16/include/__clang_hip_cmath.h
OLD_FILES+=usr/lib/clang/16/include/__clang_hip_libdevice_declares.h
OLD_FILES+=usr/lib/clang/16/include/__clang_hip_math.h
OLD_FILES+=usr/lib/clang/16/include/__clang_hip_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/16/include/__clang_hip_stdlib.h
OLD_FILES+=usr/lib/clang/16/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/16/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/16/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/16/include/adxintrin.h
OLD_FILES+=usr/lib/clang/16/include/altivec.h
OLD_FILES+=usr/lib/clang/16/include/ammintrin.h
OLD_FILES+=usr/lib/clang/16/include/amxfp16intrin.h
OLD_FILES+=usr/lib/clang/16/include/amxintrin.h
OLD_FILES+=usr/lib/clang/16/include/arm64intr.h
OLD_FILES+=usr/lib/clang/16/include/arm_acle.h
OLD_FILES+=usr/lib/clang/16/include/arm_bf16.h
OLD_FILES+=usr/lib/clang/16/include/arm_cde.h
OLD_FILES+=usr/lib/clang/16/include/arm_cmse.h
OLD_FILES+=usr/lib/clang/16/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/16/include/arm_mve.h
OLD_FILES+=usr/lib/clang/16/include/arm_neon.h
OLD_FILES+=usr/lib/clang/16/include/arm_neon_sve_bridge.h
OLD_FILES+=usr/lib/clang/16/include/arm_sve.h
OLD_FILES+=usr/lib/clang/16/include/armintr.h
OLD_FILES+=usr/lib/clang/16/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512bf16intrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512fp16intrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vlbf16intrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vlfp16intrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vlvp2intersectintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vp2intersectintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/16/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/16/include/avxifmaintrin.h
OLD_FILES+=usr/lib/clang/16/include/avxintrin.h
OLD_FILES+=usr/lib/clang/16/include/avxneconvertintrin.h
OLD_FILES+=usr/lib/clang/16/include/avxvnniint8intrin.h
OLD_FILES+=usr/lib/clang/16/include/avxvnniintrin.h
OLD_FILES+=usr/lib/clang/16/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/16/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/16/include/builtins.h
OLD_FILES+=usr/lib/clang/16/include/cet.h
OLD_FILES+=usr/lib/clang/16/include/cetintrin.h
OLD_FILES+=usr/lib/clang/16/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/16/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/16/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/16/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/16/include/cmpccxaddintrin.h
OLD_FILES+=usr/lib/clang/16/include/cpuid.h
OLD_FILES+=usr/lib/clang/16/include/crc32intrin.h
OLD_FILES+=usr/lib/clang/16/include/cuda_wrappers/algorithm
OLD_FILES+=usr/lib/clang/16/include/cuda_wrappers/cmath
OLD_FILES+=usr/lib/clang/16/include/cuda_wrappers/complex
OLD_FILES+=usr/lib/clang/16/include/cuda_wrappers/new
OLD_DIRS+=usr/lib/clang/16/include/cuda_wrappers
OLD_FILES+=usr/lib/clang/16/include/emmintrin.h
OLD_FILES+=usr/lib/clang/16/include/enqcmdintrin.h
OLD_FILES+=usr/lib/clang/16/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/16/include/float.h
OLD_FILES+=usr/lib/clang/16/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/16/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/16/include/fuzzer/FuzzedDataProvider.h
OLD_DIRS+=usr/lib/clang/16/include/fuzzer
OLD_FILES+=usr/lib/clang/16/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/16/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/16/include/hexagon_circ_brev_intrinsics.h
OLD_FILES+=usr/lib/clang/16/include/hexagon_protos.h
OLD_FILES+=usr/lib/clang/16/include/hexagon_types.h
OLD_FILES+=usr/lib/clang/16/include/hlsl/hlsl_basic_types.h
OLD_FILES+=usr/lib/clang/16/include/hlsl/hlsl_intrinsics.h
OLD_DIRS+=usr/lib/clang/16/include/hlsl
OLD_FILES+=usr/lib/clang/16/include/hlsl.h
OLD_FILES+=usr/lib/clang/16/include/hresetintrin.h
OLD_FILES+=usr/lib/clang/16/include/htmintrin.h
OLD_FILES+=usr/lib/clang/16/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/16/include/hvx_hexagon_protos.h
OLD_FILES+=usr/lib/clang/16/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/16/include/immintrin.h
OLD_FILES+=usr/lib/clang/16/include/intrin.h
OLD_FILES+=usr/lib/clang/16/include/inttypes.h
OLD_FILES+=usr/lib/clang/16/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/16/include/iso646.h
OLD_FILES+=usr/lib/clang/16/include/keylockerintrin.h
OLD_FILES+=usr/lib/clang/16/include/larchintrin.h
OLD_FILES+=usr/lib/clang/16/include/limits.h
OLD_FILES+=usr/lib/clang/16/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/16/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/16/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/16/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/16/include/mmintrin.h
OLD_FILES+=usr/lib/clang/16/include/module.modulemap
OLD_FILES+=usr/lib/clang/16/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/16/include/msa.h
OLD_FILES+=usr/lib/clang/16/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/16/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/16/include/omp-tools.h
OLD_FILES+=usr/lib/clang/16/include/omp.h
OLD_FILES+=usr/lib/clang/16/include/ompt.h
OLD_FILES+=usr/lib/clang/16/include/opencl-c-base.h
OLD_FILES+=usr/lib/clang/16/include/opencl-c.h
OLD_FILES+=usr/lib/clang/16/include/openmp_wrappers/__clang_openmp_device_functions.h
OLD_FILES+=usr/lib/clang/16/include/openmp_wrappers/cmath
OLD_FILES+=usr/lib/clang/16/include/openmp_wrappers/complex
OLD_FILES+=usr/lib/clang/16/include/openmp_wrappers/complex.h
OLD_FILES+=usr/lib/clang/16/include/openmp_wrappers/complex_cmath.h
OLD_FILES+=usr/lib/clang/16/include/openmp_wrappers/math.h
OLD_FILES+=usr/lib/clang/16/include/openmp_wrappers/new
OLD_DIRS+=usr/lib/clang/16/include/openmp_wrappers
OLD_FILES+=usr/lib/clang/16/include/orc_rt/c_api.h
OLD_DIRS+=usr/lib/clang/16/include/orc_rt
OLD_FILES+=usr/lib/clang/16/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/16/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/16/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/16/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/16/include/ppc_wrappers/bmi2intrin.h
OLD_FILES+=usr/lib/clang/16/include/ppc_wrappers/bmiintrin.h
OLD_FILES+=usr/lib/clang/16/include/ppc_wrappers/emmintrin.h
OLD_FILES+=usr/lib/clang/16/include/ppc_wrappers/immintrin.h
OLD_FILES+=usr/lib/clang/16/include/ppc_wrappers/mm_malloc.h
OLD_FILES+=usr/lib/clang/16/include/ppc_wrappers/mmintrin.h
OLD_FILES+=usr/lib/clang/16/include/ppc_wrappers/pmmintrin.h
OLD_FILES+=usr/lib/clang/16/include/ppc_wrappers/smmintrin.h
OLD_FILES+=usr/lib/clang/16/include/ppc_wrappers/tmmintrin.h
OLD_FILES+=usr/lib/clang/16/include/ppc_wrappers/x86gprintrin.h
OLD_FILES+=usr/lib/clang/16/include/ppc_wrappers/x86intrin.h
OLD_FILES+=usr/lib/clang/16/include/ppc_wrappers/xmmintrin.h
OLD_DIRS+=usr/lib/clang/16/include/ppc_wrappers
OLD_FILES+=usr/lib/clang/16/include/prfchiintrin.h
OLD_FILES+=usr/lib/clang/16/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/16/include/profile/InstrProfData.inc
OLD_FILES+=usr/lib/clang/16/include/profile/MemProfData.inc
OLD_DIRS+=usr/lib/clang/16/include/profile
OLD_FILES+=usr/lib/clang/16/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/16/include/raointintrin.h
OLD_FILES+=usr/lib/clang/16/include/rdpruintrin.h
OLD_FILES+=usr/lib/clang/16/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/16/include/riscv_vector.h
OLD_FILES+=usr/lib/clang/16/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/16/include/s390intrin.h
OLD_FILES+=usr/lib/clang/16/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/16/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/16/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/16/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/16/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/16/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/16/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/16/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/16/include/sanitizer/memprof_interface.h
OLD_FILES+=usr/lib/clang/16/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/16/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/16/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/16/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/16/include/sanitizer/tsan_interface_atomic.h
OLD_FILES+=usr/lib/clang/16/include/sanitizer/ubsan_interface.h
OLD_DIRS+=usr/lib/clang/16/include/sanitizer
OLD_FILES+=usr/lib/clang/16/include/serializeintrin.h
OLD_FILES+=usr/lib/clang/16/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/16/include/shaintrin.h
OLD_FILES+=usr/lib/clang/16/include/smmintrin.h
OLD_FILES+=usr/lib/clang/16/include/stdalign.h
OLD_FILES+=usr/lib/clang/16/include/stdarg.h
OLD_FILES+=usr/lib/clang/16/include/stdatomic.h
OLD_FILES+=usr/lib/clang/16/include/stdbool.h
OLD_FILES+=usr/lib/clang/16/include/stddef.h
OLD_FILES+=usr/lib/clang/16/include/stdint.h
OLD_FILES+=usr/lib/clang/16/include/stdnoreturn.h
OLD_FILES+=usr/lib/clang/16/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/16/include/tgmath.h
OLD_FILES+=usr/lib/clang/16/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/16/include/tsxldtrkintrin.h
OLD_FILES+=usr/lib/clang/16/include/uintrintrin.h
OLD_FILES+=usr/lib/clang/16/include/unwind.h
OLD_FILES+=usr/lib/clang/16/include/vadefs.h
OLD_FILES+=usr/lib/clang/16/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/16/include/varargs.h
OLD_FILES+=usr/lib/clang/16/include/vecintrin.h
OLD_FILES+=usr/lib/clang/16/include/velintrin.h
OLD_FILES+=usr/lib/clang/16/include/velintrin_approx.h
OLD_FILES+=usr/lib/clang/16/include/velintrin_gen.h
OLD_FILES+=usr/lib/clang/16/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/16/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/16/include/wasm_simd128.h
OLD_FILES+=usr/lib/clang/16/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/16/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/16/include/x86gprintrin.h
OLD_FILES+=usr/lib/clang/16/include/x86intrin.h
OLD_FILES+=usr/lib/clang/16/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/16/include/xopintrin.h
OLD_FILES+=usr/lib/clang/16/include/xray/xray_interface.h
OLD_FILES+=usr/lib/clang/16/include/xray/xray_log_interface.h
OLD_FILES+=usr/lib/clang/16/include/xray/xray_records.h
OLD_DIRS+=usr/lib/clang/16/include/xray
OLD_FILES+=usr/lib/clang/16/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/16/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/16/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/16/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/16/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/16/include
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-aarch64.so
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-arm.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-arm.so
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-armhf.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-armhf.so
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-powerpc64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-powerpc64.so
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-powerpc64le.so
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-preinit-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-preinit-arm.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-preinit-armhf.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-preinit-powerpc64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-preinit-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-preinit-riscv64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-riscv64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-riscv64.so
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan_cxx-arm.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan_cxx-armhf.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan_cxx-riscv64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan_static-i386.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan_static-powerpc64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan_static-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.asan_static-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.cfi-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.cfi-arm.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.cfi-armhf.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.cfi-i386.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.cfi-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.cfi_diag-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.cfi_diag-arm.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.cfi_diag-armhf.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.cfi_diag-i386.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.cfi_diag-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.dd-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.dd-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.fuzzer-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.fuzzer-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.fuzzer_interceptors-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.fuzzer_no_main-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.fuzzer_no_main-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.msan-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.msan-powerpc64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.msan-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.msan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.msan_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.msan_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.profile-powerpc.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.profile-powerpc64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.profile-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.profile-riscv64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.safestack-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.stats-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.stats-arm.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.stats-armhf.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.stats-powerpc64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.stats-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.stats-riscv64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.stats_client-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.stats_client-arm.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.stats_client-armhf.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.stats_client-powerpc64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.stats_client-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.stats_client-riscv64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.tsan-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.tsan-powerpc64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.tsan-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.tsan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.tsan_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.tsan_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_minimal-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_minimal-arm.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_minimal-armhf.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_minimal-powerpc64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_minimal-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_minimal-riscv64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_standalone-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_standalone-arm.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_standalone-armhf.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_standalone-powerpc64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_standalone-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_standalone-riscv64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_standalone_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_standalone_cxx-arm.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_standalone_cxx-armhf.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_standalone_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_standalone_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_standalone_cxx-riscv64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-arm.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-armhf.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-basic-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-basic-arm.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-basic-armhf.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-basic-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-basic-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-fdr-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-fdr-arm.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-fdr-armhf.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-fdr-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-fdr-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-profiling-aarch64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-profiling-arm.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-profiling-armhf.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-profiling-powerpc64le.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-profiling-x86_64.a
OLD_FILES+=usr/lib/clang/16/lib/freebsd/libclang_rt.xray-x86_64.a
OLD_DIRS+=usr/lib/clang/16/lib/freebsd
OLD_DIRS+=usr/lib/clang/16/lib
OLD_FILES+=usr/lib/clang/16/share/asan_ignorelist.txt
OLD_FILES+=usr/lib/clang/16/share/cfi_ignorelist.txt
OLD_FILES+=usr/lib/clang/16/share/msan_ignorelist.txt
OLD_DIRS+=usr/lib/clang/16/share
OLD_DIRS+=usr/lib/clang/16

# 20231208: new libc++ import which bumps version from 16 to 17
OLD_FILES+=usr/include/c++/v1/__bsd_locale_defaults.h
OLD_FILES+=usr/include/c++/v1/__bsd_locale_fallbacks.h
OLD_FILES+=usr/include/c++/v1/__debug
OLD_FILES+=usr/include/c++/v1/__errc
OLD_FILES+=usr/include/c++/v1/__functional/unwrap_ref.h
OLD_FILES+=usr/include/c++/v1/__mutex_base
OLD_FILES+=usr/include/c++/v1/__ranges/copyable_box.h
OLD_FILES+=usr/include/c++/v1/__std_stream
OLD_FILES+=usr/include/c++/v1/__tuple_dir/apply_cv.h
OLD_FILES+=usr/include/c++/v1/__tuple_dir/make_tuple_types.h
OLD_FILES+=usr/include/c++/v1/__tuple_dir/pair_like.h
OLD_FILES+=usr/include/c++/v1/__tuple_dir/sfinae_helpers.h
OLD_FILES+=usr/include/c++/v1/__tuple_dir/tuple_element.h
OLD_FILES+=usr/include/c++/v1/__tuple_dir/tuple_indices.h
OLD_FILES+=usr/include/c++/v1/__tuple_dir/tuple_like.h
OLD_FILES+=usr/include/c++/v1/__tuple_dir/tuple_like_ext.h
OLD_FILES+=usr/include/c++/v1/__tuple_dir/tuple_size.h
OLD_FILES+=usr/include/c++/v1/__tuple_dir/tuple_types.h
OLD_DIRS+=usr/include/c++/v1/__tuple_dir
OLD_FILES+=usr/include/c++/v1/experimental/algorithm
OLD_FILES+=usr/include/c++/v1/experimental/coroutine
OLD_FILES+=usr/include/c++/v1/experimental/functional

# 20231117: libufs version bumped to 8
OLD_LIBS+=lib/libufs.so.7

# 20231018: pmc.k7(3) removed
OLD_FILES+=usr/share/man/man3/pmc.k7.3.gz

# 20231018: Remove misspelled man page link
OLD_FILES+=usr/share/man/man3/dbm_dirnfo.3.gz

# 20231006: rename tcp6_v4unmapped_bind_test
OLD_FILES+=usr/tests/sys/netinet/tcp6_v4unmapped_bind_test

# 20231005: Remove man page link for now gone net80211 function.
OLD_FILES+=usr/share/man/man9/ieee80211_unref_node.9.gz

# 20231005: bsdconfig remove support for floppy and ftp
OLD_FILES+=usr/share/bsdconfig/media/floppy.subr
OLD_FILES+=usr/share/bsdconfig/media/ftp.subr

# 20230927: Man pages renamed to match the actual functions
OLD_FILES+=usr/share/man/man9/cr_seeothergids.9.gz
OLD_FILES+=usr/share/man/man9/cr_seeotheruids.9.gz

# 20230925
OLD_FILES+=usr/share/examples/diskless/ME
OLD_FILES+=usr/share/examples/diskless/README.BOOTP
OLD_FILES+=usr/share/examples/diskless/README.TEMPLATING
OLD_FILES+=usr/share/examples/diskless/clone_root

# 20230905
OLD_FILES+=usr/share/doc/legal/realtek_rtw88_firmware.LICENCE

# 20230828
MOVED_LIBS+=usr/lib/librt.so.1

# 20230826:
OLD_FILES+=usr/share/man/man9/knlist_remove_inevent.9.gz

# 20230825: caroot bundle updated
OLD_FILES+=usr/share/certs/trusted/E-Tugra_Certification_Authority.pem
OLD_FILES+=usr/share/certs/trusted/E-Tugra_Global_Root_CA_ECC_v3.pem
OLD_FILES+=usr/share/certs/trusted/E-Tugra_Global_Root_CA_RSA_v3.pem
OLD_FILES+=usr/share/certs/trusted/Hongkong_Post_Root_CA_1.pem

# 20230807: GoogleTest 1.14.0 upgrade.
OLD_FILES+=usr/include/private/gmock/gmock-generated-actions.h
OLD_FILES+=usr/include/private/gmock/gmock-generated-function-mockers.h
OLD_FILES+=usr/include/private/gmock/gmock-generated-matchers.h
OLD_FILES+=usr/include/private/gmock/gmock-generated-nice-strict.h
OLD_FILES+=usr/include/private/gmock/internal/gmock-generated-internal-utils.h
OLD_FILES+=usr/include/private/gtest/internal/gtest-linked_ptr.h
OLD_FILES+=usr/include/private/gtest/internal/gtest-param-util-generated.h
OLD_FILES+=usr/include/private/gtest/internal/gtest-tuple.h
OLD_FILES+=usr/tests/lib/googletest/gmock_main/gmock-generated-actions_test
OLD_FILES+=usr/tests/lib/googletest/gmock_main/gmock-generated-function-mockers_test
OLD_FILES+=usr/tests/lib/googletest/gmock_main/gmock-generated-internal-utils_test
OLD_FILES+=usr/tests/lib/googletest/gmock_main/gmock-generated-matchers_test
OLD_FILES+=usr/tests/lib/googletest/gmock_main/gmock-matchers_test
OLD_FILES+=usr/tests/lib/googletest/gtest_main/googletest-linked-ptr-test

# 20230807: Removal of the ath(4) AHB bus-frontend for MIPS
OLD_FILES+=usr/share/man/man4/ath_ahb.4.gz
OLD_FILES+=usr/share/man/man4/ath_pci.4.gz
OLD_FILES+=usr/share/man/man4/if_ath_pci.4.gz

# 20230803: Removal of support for cloning pseudo interfaces from iflib(9)
OLD_FILES+=usr/include/net/iflib_private.h

# 20230802: Remove a copy of libdtrace.so installed to the wrong path
MOVED_LIBS+=usr/lib/libdtrace.so.2

# 20230726: Removal of support for the VTOC8 partitioning scheme
OLD_FILES+=usr/include/sys/disk/vtoc.h
OLD_FILES+=usr/include/sys/vtoc.h

# 20230724: Remove unneeded arm headers
.if ${TARGET_ARCH} == "arm"
OLD_FILES+=usr/include/machine/atomic-v6.h
OLD_FILES+=usr/include/machine/cpu-v6.h
OLD_FILES+=usr/include/machine/pmap-v6.h
OLD_FILES+=usr/include/machine/pte-v6.h
OLD_FILES+=usr/include/machine/swi.h
.endif

# 20230714: gsignal
OLD_FILES+=usr/share/man/man9/gsignal.9.gz

# 20230704: kinst dtrace tests moved to common
OLD_DIRS+=usr/tests/cddl/usr.sbin/dtrace/amd64/kinst

# 20230626: Only install sys/dev/nvme/nvme.h to /usr/include
OLD_FILES+=usr/include/dev/nvme/nvme_private.h

# 20230623: OpenSSL 3.0.9
OLD_LIBS+=lib/libcrypto.so.111
OLD_FILES+=usr/include/openssl/rand_drbg.h
OLD_LIBS+=usr/lib/engines/capi.so
OLD_LIBS+=usr/lib/engines/padlock.so
OLD_LIBS+=usr/lib/libssl.so.111
OLD_DIRS+=usr/lib/engines
.for libcompat in ${_ALL_libcompats}
OLD_DIRS+=usr/lib${libcompat}/engines
.endfor
OLD_FILES+=usr/share/man/man1/list.1
OLD_FILES+=usr/share/man/man1/openssl-tsget.1
OLD_FILES+=usr/share/man/man3/ECDH_get_ex_data.3
OLD_FILES+=usr/share/man/man3/ECDH_get_ex_new_index.3
OLD_FILES+=usr/share/man/man3/ECDH_set_ex_data.3
OLD_FILES+=usr/share/man/man3/ERR_GET_FUNC.3
OLD_FILES+=usr/share/man/man3/EVP_PKEY_CTX_hkdf_mode.3
OLD_FILES+=usr/share/man/man3/EVP_PKEY_set_alias_type.3
OLD_FILES+=usr/share/man/man3/EVP_aes.3
OLD_FILES+=usr/share/man/man3/EVP_aria.3
OLD_FILES+=usr/share/man/man3/EVP_camellia.3
OLD_FILES+=usr/share/man/man3/EVP_des.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_bytes.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_cleanup_entropy_fn.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_cleanup_nonce_fn.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_free.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_generate.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_get0_master.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_get0_private.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_get0_public.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_get_entropy_fn.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_get_ex_data.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_get_ex_new_index.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_get_nonce_fn.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_instantiate.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_new.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_reseed.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_secure_new.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_set.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_set_callbacks.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_set_defaults.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_set_ex_data.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_set_reseed_defaults.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_set_reseed_interval.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_set_reseed_time_interval.3
OLD_FILES+=usr/share/man/man3/RAND_DRBG_uninstantiate.3
OLD_FILES+=usr/share/man/man3/RSA_padding_add_SSLv23.3
OLD_FILES+=usr/share/man/man3/RSA_padding_check_SSLv23.3
OLD_FILES+=usr/share/man/man7/RAND_DRBG.7
OLD_FILES+=usr/share/man/man7/scrypt.7

# 20230622: new clang import which bumps version from 15.0.7 to 16.0.1
OLD_FILES+=usr/lib/clang/15.0.7/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/15.0.7/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/15.0.7/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/15.0.7/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/15.0.7/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/15.0.7/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/15.0.7/include/__clang_cuda_math.h
OLD_FILES+=usr/lib/clang/15.0.7/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/15.0.7/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/15.0.7/include/__clang_cuda_texture_intrinsics.h
OLD_FILES+=usr/lib/clang/15.0.7/include/__clang_hip_cmath.h
OLD_FILES+=usr/lib/clang/15.0.7/include/__clang_hip_libdevice_declares.h
OLD_FILES+=usr/lib/clang/15.0.7/include/__clang_hip_math.h
OLD_FILES+=usr/lib/clang/15.0.7/include/__clang_hip_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/15.0.7/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/15.0.7/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/15.0.7/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/15.0.7/include/adxintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/altivec.h
OLD_FILES+=usr/lib/clang/15.0.7/include/ammintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/amxintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/arm64intr.h
OLD_FILES+=usr/lib/clang/15.0.7/include/arm_acle.h
OLD_FILES+=usr/lib/clang/15.0.7/include/arm_bf16.h
OLD_FILES+=usr/lib/clang/15.0.7/include/arm_cde.h
OLD_FILES+=usr/lib/clang/15.0.7/include/arm_cmse.h
OLD_FILES+=usr/lib/clang/15.0.7/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/15.0.7/include/arm_mve.h
OLD_FILES+=usr/lib/clang/15.0.7/include/arm_neon.h
OLD_FILES+=usr/lib/clang/15.0.7/include/arm_neon_sve_bridge.h
OLD_FILES+=usr/lib/clang/15.0.7/include/arm_sve.h
OLD_FILES+=usr/lib/clang/15.0.7/include/armintr.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512bf16intrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512fp16intrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vlbf16intrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vlfp16intrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vlvp2intersectintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vp2intersectintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avxintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/avxvnniintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/builtins.h
OLD_FILES+=usr/lib/clang/15.0.7/include/cet.h
OLD_FILES+=usr/lib/clang/15.0.7/include/cetintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/cpuid.h
OLD_FILES+=usr/lib/clang/15.0.7/include/crc32intrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/cuda_wrappers/algorithm
OLD_FILES+=usr/lib/clang/15.0.7/include/cuda_wrappers/complex
OLD_FILES+=usr/lib/clang/15.0.7/include/cuda_wrappers/new
OLD_DIRS+=usr/lib/clang/15.0.7/include/cuda_wrappers
OLD_FILES+=usr/lib/clang/15.0.7/include/emmintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/enqcmdintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/float.h
OLD_FILES+=usr/lib/clang/15.0.7/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/fuzzer/FuzzedDataProvider.h
OLD_DIRS+=usr/lib/clang/15.0.7/include/fuzzer
OLD_FILES+=usr/lib/clang/15.0.7/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/hexagon_circ_brev_intrinsics.h
OLD_FILES+=usr/lib/clang/15.0.7/include/hexagon_protos.h
OLD_FILES+=usr/lib/clang/15.0.7/include/hexagon_types.h
OLD_FILES+=usr/lib/clang/15.0.7/include/hlsl/hlsl_basic_types.h
OLD_FILES+=usr/lib/clang/15.0.7/include/hlsl/hlsl_intrinsics.h
OLD_DIRS+=usr/lib/clang/15.0.7/include/hlsl
OLD_FILES+=usr/lib/clang/15.0.7/include/hlsl.h
OLD_FILES+=usr/lib/clang/15.0.7/include/hresetintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/htmintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/hvx_hexagon_protos.h
OLD_FILES+=usr/lib/clang/15.0.7/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/immintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/intrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/inttypes.h
OLD_FILES+=usr/lib/clang/15.0.7/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/iso646.h
OLD_FILES+=usr/lib/clang/15.0.7/include/keylockerintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/limits.h
OLD_FILES+=usr/lib/clang/15.0.7/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/15.0.7/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/15.0.7/include/mmintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/module.modulemap
OLD_FILES+=usr/lib/clang/15.0.7/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/msa.h
OLD_FILES+=usr/lib/clang/15.0.7/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/omp-tools.h
OLD_FILES+=usr/lib/clang/15.0.7/include/omp.h
OLD_FILES+=usr/lib/clang/15.0.7/include/ompt.h
OLD_FILES+=usr/lib/clang/15.0.7/include/opencl-c-base.h
OLD_FILES+=usr/lib/clang/15.0.7/include/opencl-c.h
OLD_FILES+=usr/lib/clang/15.0.7/include/openmp_wrappers/__clang_openmp_device_functions.h
OLD_FILES+=usr/lib/clang/15.0.7/include/openmp_wrappers/cmath
OLD_FILES+=usr/lib/clang/15.0.7/include/openmp_wrappers/complex
OLD_FILES+=usr/lib/clang/15.0.7/include/openmp_wrappers/complex.h
OLD_FILES+=usr/lib/clang/15.0.7/include/openmp_wrappers/complex_cmath.h
OLD_FILES+=usr/lib/clang/15.0.7/include/openmp_wrappers/math.h
OLD_FILES+=usr/lib/clang/15.0.7/include/openmp_wrappers/new
OLD_DIRS+=usr/lib/clang/15.0.7/include/openmp_wrappers
OLD_FILES+=usr/lib/clang/15.0.7/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/ppc_wrappers/bmi2intrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/ppc_wrappers/bmiintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/ppc_wrappers/emmintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/ppc_wrappers/immintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/ppc_wrappers/mm_malloc.h
OLD_FILES+=usr/lib/clang/15.0.7/include/ppc_wrappers/mmintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/ppc_wrappers/pmmintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/ppc_wrappers/smmintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/ppc_wrappers/tmmintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/ppc_wrappers/x86gprintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/ppc_wrappers/x86intrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/ppc_wrappers/xmmintrin.h
OLD_DIRS+=usr/lib/clang/15.0.7/include/ppc_wrappers
OLD_FILES+=usr/lib/clang/15.0.7/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/profile/InstrProfData.inc
OLD_FILES+=usr/lib/clang/15.0.7/include/profile/MemProfData.inc
OLD_DIRS+=usr/lib/clang/15.0.7/include/profile
OLD_FILES+=usr/lib/clang/15.0.7/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/rdpruintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/riscv_vector.h
OLD_FILES+=usr/lib/clang/15.0.7/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/s390intrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/15.0.7/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/15.0.7/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/15.0.7/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/15.0.7/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/15.0.7/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/15.0.7/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/15.0.7/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/15.0.7/include/sanitizer/memprof_interface.h
OLD_FILES+=usr/lib/clang/15.0.7/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/15.0.7/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/15.0.7/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/15.0.7/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/15.0.7/include/sanitizer/tsan_interface_atomic.h
OLD_FILES+=usr/lib/clang/15.0.7/include/sanitizer/ubsan_interface.h
OLD_DIRS+=usr/lib/clang/15.0.7/include/sanitizer
OLD_FILES+=usr/lib/clang/15.0.7/include/serializeintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/shaintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/smmintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/stdalign.h
OLD_FILES+=usr/lib/clang/15.0.7/include/stdarg.h
OLD_FILES+=usr/lib/clang/15.0.7/include/stdatomic.h
OLD_FILES+=usr/lib/clang/15.0.7/include/stdbool.h
OLD_FILES+=usr/lib/clang/15.0.7/include/stddef.h
OLD_FILES+=usr/lib/clang/15.0.7/include/stdint.h
OLD_FILES+=usr/lib/clang/15.0.7/include/stdnoreturn.h
OLD_FILES+=usr/lib/clang/15.0.7/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/tgmath.h
OLD_FILES+=usr/lib/clang/15.0.7/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/tsxldtrkintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/uintrintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/unwind.h
OLD_FILES+=usr/lib/clang/15.0.7/include/vadefs.h
OLD_FILES+=usr/lib/clang/15.0.7/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/varargs.h
OLD_FILES+=usr/lib/clang/15.0.7/include/vecintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/velintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/velintrin_approx.h
OLD_FILES+=usr/lib/clang/15.0.7/include/velintrin_gen.h
OLD_FILES+=usr/lib/clang/15.0.7/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/wasm_simd128.h
OLD_FILES+=usr/lib/clang/15.0.7/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/x86gprintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/x86intrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/xopintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/xray/xray_interface.h
OLD_FILES+=usr/lib/clang/15.0.7/include/xray/xray_log_interface.h
OLD_FILES+=usr/lib/clang/15.0.7/include/xray/xray_records.h
OLD_DIRS+=usr/lib/clang/15.0.7/include/xray
OLD_FILES+=usr/lib/clang/15.0.7/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/15.0.7/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/15.0.7/include
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-aarch64.so
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-arm.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-arm.so
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-armhf.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-armhf.so
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-powerpc64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-powerpc64.so
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-powerpc64le.so
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-preinit-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-preinit-arm.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-preinit-armhf.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-preinit-powerpc64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-preinit-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-preinit-riscv64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-riscv64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-riscv64.so
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan_cxx-arm.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan_cxx-armhf.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan_cxx-riscv64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan_static-i386.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan_static-powerpc64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan_static-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.asan_static-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.cfi-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.cfi-arm.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.cfi-armhf.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.cfi-i386.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.cfi-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.cfi_diag-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.cfi_diag-arm.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.cfi_diag-armhf.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.cfi_diag-i386.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.cfi_diag-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.dd-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.dd-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.fuzzer-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.fuzzer-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.fuzzer_interceptors-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.fuzzer_no_main-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.fuzzer_no_main-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.msan-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.msan-powerpc64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.msan-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.msan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.msan_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.msan_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.profile-powerpc.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.profile-powerpc64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.profile-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.profile-riscv64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.safestack-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.stats-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.stats-arm.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.stats-armhf.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.stats-powerpc64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.stats-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.stats-riscv64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.stats_client-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.stats_client-arm.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.stats_client-armhf.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.stats_client-powerpc64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.stats_client-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.stats_client-riscv64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.tsan-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.tsan-powerpc64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.tsan-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.tsan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.tsan_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.tsan_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_minimal-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_minimal-arm.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_minimal-armhf.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_minimal-powerpc64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_minimal-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_minimal-riscv64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_standalone-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_standalone-arm.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_standalone-armhf.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_standalone-powerpc64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_standalone-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_standalone-riscv64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_standalone_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_standalone_cxx-arm.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_standalone_cxx-armhf.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_standalone_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_standalone_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_standalone_cxx-riscv64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-arm.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-armhf.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-basic-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-basic-arm.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-basic-armhf.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-basic-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-basic-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-fdr-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-fdr-arm.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-fdr-armhf.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-fdr-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-fdr-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-profiling-aarch64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-profiling-arm.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-profiling-armhf.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-profiling-powerpc64le.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-profiling-x86_64.a
OLD_FILES+=usr/lib/clang/15.0.7/lib/freebsd/libclang_rt.xray-x86_64.a
OLD_DIRS+=usr/lib/clang/15.0.7/lib/freebsd
OLD_DIRS+=usr/lib/clang/15.0.7/lib
OLD_FILES+=usr/lib/clang/15.0.7/share/asan_ignorelist.txt
OLD_FILES+=usr/lib/clang/15.0.7/share/cfi_ignorelist.txt
OLD_FILES+=usr/lib/clang/15.0.7/share/msan_ignorelist.txt
OLD_DIRS+=usr/lib/clang/15.0.7/share
OLD_DIRS+=usr/lib/clang/15.0.7

# 20230622: new libc++ import which bumps version from 15.0.7 to 16.0.1
OLD_FILES+=usr/include/c++/v1/__bits
OLD_FILES+=usr/include/c++/v1/__tuple
OLD_FILES+=usr/include/c++/v1/__utility/transaction.h

# 20230614: caroot bundle updated
OLD_FILES+=usr/share/certs/trusted/Cybertrust_Global_Root.pem
OLD_FILES+=usr/share/certs/trusted/DST_Root_CA_X3.pem
OLD_FILES+=usr/share/certs/trusted/GlobalSign_Root_CA_-_R2.pem
OLD_FILES+=usr/share/certs/trusted/Hellenic_Academic_and_Research_Institutions_RootCA_2011.pem
OLD_FILES+=usr/share/certs/trusted/Network_Solutions_Certificate_Authority.pem
OLD_FILES+=usr/share/certs/trusted/Staat_der_Nederlanden_EV_Root_CA.pem
OLD_FILES+=usr/share/certs/trusted/TrustCor_ECA-1.pem
OLD_FILES+=usr/share/certs/trusted/TrustCor_RootCert_CA-1.pem
OLD_FILES+=usr/share/certs/trusted/TrustCor_RootCert_CA-2.pem

# 20230510: twe(4) driver removed
OLD_FILES+=usr/share/man/man4/twe.4.gz

# 20230505: md5 tests are now self-contained
OLD_FILES+=usr/tests/sbin/md5/1.inp
OLD_FILES+=usr/tests/sbin/md5/1.sha512-p.chk
OLD_FILES+=usr/tests/sbin/md5/1.sha512sum-p.chk
OLD_FILES+=usr/tests/sbin/md5/2.inp
OLD_FILES+=usr/tests/sbin/md5/2.sha512-p.chk
OLD_FILES+=usr/tests/sbin/md5/2.sha512sum-p.chk
OLD_FILES+=usr/tests/sbin/md5/3.inp
OLD_FILES+=usr/tests/sbin/md5/3.sha512-p.chk
OLD_FILES+=usr/tests/sbin/md5/3.sha512sum-p.chk
OLD_FILES+=usr/tests/sbin/md5/4.inp
OLD_FILES+=usr/tests/sbin/md5/4.sha512-p.chk
OLD_FILES+=usr/tests/sbin/md5/4.sha512sum-p.chk
OLD_FILES+=usr/tests/sbin/md5/5.inp
OLD_FILES+=usr/tests/sbin/md5/5.sha512-p.chk
OLD_FILES+=usr/tests/sbin/md5/5.sha512sum-p.chk
OLD_FILES+=usr/tests/sbin/md5/6.inp
OLD_FILES+=usr/tests/sbin/md5/6.sha512-p.chk
OLD_FILES+=usr/tests/sbin/md5/6.sha512sum-p.chk
OLD_FILES+=usr/tests/sbin/md5/7.inp
OLD_FILES+=usr/tests/sbin/md5/7.sha512-p.chk
OLD_FILES+=usr/tests/sbin/md5/7.sha512sum-p.chk
OLD_FILES+=usr/tests/sbin/md5/8.inp
OLD_FILES+=usr/tests/sbin/md5/8.sha512-p.chk
OLD_FILES+=usr/tests/sbin/md5/8.sha512sum-p.chk
OLD_FILES+=usr/tests/sbin/md5/algorithms.txt
OLD_FILES+=usr/tests/sbin/md5/bsd-c-test
OLD_FILES+=usr/tests/sbin/md5/bsd-p-test
OLD_FILES+=usr/tests/sbin/md5/bsd-s-test
OLD_FILES+=usr/tests/sbin/md5/coreutils-c-test
OLD_FILES+=usr/tests/sbin/md5/md5.digest
OLD_FILES+=usr/tests/sbin/md5/md5sum.digest
OLD_FILES+=usr/tests/sbin/md5/rmd160.digest
OLD_FILES+=usr/tests/sbin/md5/rmd160sum.digest
OLD_FILES+=usr/tests/sbin/md5/self-test
OLD_FILES+=usr/tests/sbin/md5/self-test.md5.chk
OLD_FILES+=usr/tests/sbin/md5/self-test.rmd160.chk
OLD_FILES+=usr/tests/sbin/md5/self-test.sh_inp
OLD_FILES+=usr/tests/sbin/md5/self-test.sha1.chk
OLD_FILES+=usr/tests/sbin/md5/self-test.sha224.chk
OLD_FILES+=usr/tests/sbin/md5/self-test.sha256.chk
OLD_FILES+=usr/tests/sbin/md5/self-test.sha384.chk
OLD_FILES+=usr/tests/sbin/md5/self-test.sha512.chk
OLD_FILES+=usr/tests/sbin/md5/self-test.sha512t224.chk
OLD_FILES+=usr/tests/sbin/md5/self-test.sha512t256.chk
OLD_FILES+=usr/tests/sbin/md5/self-test.skein1024.chk
OLD_FILES+=usr/tests/sbin/md5/self-test.skein256.chk
OLD_FILES+=usr/tests/sbin/md5/self-test.skein512.chk
OLD_FILES+=usr/tests/sbin/md5/sha1.digest
OLD_FILES+=usr/tests/sbin/md5/sha1sum.digest
OLD_FILES+=usr/tests/sbin/md5/sha224.digest
OLD_FILES+=usr/tests/sbin/md5/sha224sum.digest
OLD_FILES+=usr/tests/sbin/md5/sha256.digest
OLD_FILES+=usr/tests/sbin/md5/sha256sum.digest
OLD_FILES+=usr/tests/sbin/md5/sha384.digest
OLD_FILES+=usr/tests/sbin/md5/sha384sum.digest
OLD_FILES+=usr/tests/sbin/md5/sha512.digest
OLD_FILES+=usr/tests/sbin/md5/sha512sum.digest
OLD_FILES+=usr/tests/sbin/md5/sha512t224.digest
OLD_FILES+=usr/tests/sbin/md5/sha512t224sum.digest
OLD_FILES+=usr/tests/sbin/md5/sha512t256.digest
OLD_FILES+=usr/tests/sbin/md5/sha512t256sum.digest
OLD_FILES+=usr/tests/sbin/md5/skein1024.digest
OLD_FILES+=usr/tests/sbin/md5/skein1024sum.digest
OLD_FILES+=usr/tests/sbin/md5/skein256.digest
OLD_FILES+=usr/tests/sbin/md5/skein256sum.digest
OLD_FILES+=usr/tests/sbin/md5/skein512.digest
OLD_FILES+=usr/tests/sbin/md5/skein512sum.digest
OLD_FILES+=usr/tests/sbin/md5/sum_a.in
OLD_FILES+=usr/tests/sbin/md5/sum_b.in
OLD_FILES+=usr/tests/sbin/md5/sum_c.in
OLD_FILES+=usr/tests/sbin/md5/sum_sums.digest

# 20230420: portsnap.8 removed
OLD_FILES+=etc/portsnap.conf
OLD_FILES+=usr/libexec/make_index
OLD_FILES+=usr/sbin/portsnap
OLD_FILES+=usr/share/examples/etc/portsnap.conf
OLD_FILES+=usr/share/man/man8/portsnap.8.gz

# 20230331: libpcap updated to 1.10.3
OLD_FILES+=usr/include/fmtutils.h

# 20230329: libcasper libraries moved to /lib
MOVED_LIBS+=lib/casper/libcap_dns.so.2
MOVED_LIBS+=lib/casper/libcap_fileargs.so.1
MOVED_LIBS+=lib/casper/libcap_grp.so.1
MOVED_LIBS+=lib/casper/libcap_net.so.1
MOVED_LIBS+=lib/casper/libcap_netdb.so.1
MOVED_LIBS+=lib/casper/libcap_pwd.so.1
MOVED_LIBS+=lib/casper/libcap_sysctl.so.1
MOVED_LIBS+=lib/casper/libcap_sysctl.so.2
MOVED_LIBS+=lib/casper/libcap_syslog.so.1
OLD_DIRS+=lib/casper

# 20230324: libvmmapi shlib version bumped to 6
OLD_LIBS+=usr/lib/libvmmapi.so.5

# 20230323: tzdata 2023a imported
OLD_FILES+=usr/share/zoneinfo/posixrules

# 20230320: vcount.9 removed
OLD_FILES+=usr/share/man/man9/count_dev.9.gz
OLD_FILES+=usr/share/man/man9/vcount.9.gz

# 20230320: case-sensitive conflicts removed
OLD_FILES+=usr/tests/bin/pkill/pgrep-F_test
OLD_FILES+=usr/tests/bin/pkill/pgrep-LF_test
OLD_FILES+=usr/tests/bin/pkill/pgrep-P_test
OLD_FILES+=usr/tests/bin/pkill/pgrep-U_test
OLD_FILES+=usr/tests/bin/pkill/pkill-F_test
OLD_FILES+=usr/tests/bin/pkill/pkill-LF_test
OLD_FILES+=usr/tests/bin/pkill/pkill-P_test
OLD_FILES+=usr/tests/bin/pkill/pkill-U_test

# 20230309: remove remaining ATM support
OLD_FILES+=usr/bin/sscop
OLD_FILES+=usr/include/netgraph/atm/ng_ccatm.h
OLD_FILES+=usr/include/netgraph/atm/ng_sscfu.h
OLD_FILES+=usr/include/netgraph/atm/ng_sscop.h
OLD_FILES+=usr/include/netgraph/atm/ng_uni.h
OLD_FILES+=usr/include/netgraph/atm/ngatmbase.h
OLD_FILES+=usr/include/netgraph/ng_atmllc.h
OLD_FILES+=usr/include/netnatm/addr.h
OLD_FILES+=usr/include/netnatm/api/atmapi.h
OLD_FILES+=usr/include/netnatm/api/ccatm.h
OLD_FILES+=usr/include/netnatm/api/unisap.h
OLD_DIRS+=usr/include/netnatm/api
OLD_FILES+=usr/include/netnatm/msg/uni_config.h
OLD_FILES+=usr/include/netnatm/msg/uni_hdr.h
OLD_FILES+=usr/include/netnatm/msg/uni_ie.h
OLD_FILES+=usr/include/netnatm/msg/uni_msg.h
OLD_FILES+=usr/include/netnatm/msg/unimsglib.h
OLD_FILES+=usr/include/netnatm/msg/uniprint.h
OLD_FILES+=usr/include/netnatm/msg/unistruct.h
OLD_DIRS+=usr/include/netnatm/msg
OLD_FILES+=usr/include/netnatm/saal/sscfu.h
OLD_FILES+=usr/include/netnatm/saal/sscfudef.h
OLD_FILES+=usr/include/netnatm/saal/sscop.h
OLD_FILES+=usr/include/netnatm/saal/sscopdef.h
OLD_DIRS+=usr/include/netnatm/saal
OLD_FILES+=usr/include/netnatm/sig/uni.h
OLD_FILES+=usr/include/netnatm/sig/unidef.h
OLD_FILES+=usr/include/netnatm/sig/unisig.h
OLD_DIRS+=usr/include/netnatm/sig
OLD_FILES+=usr/include/netnatm/unimsg.h
OLD_DIRS+=usr/include/netnatm
OLD_FILES+=usr/lib/libngatm.a
OLD_FILES+=usr/lib/libngatm.so
OLD_LIBS+=usr/lib/libngatm.so.4
OLD_FILES+=usr/lib/libngatm_p.a
OLD_FILES+=usr/share/man/man1/sscop.1.gz
OLD_FILES+=usr/share/man/man3/libngatm.3.gz
OLD_FILES+=usr/share/man/man3/uniaddr.3.gz
OLD_FILES+=usr/share/man/man3/unifunc.3.gz
OLD_FILES+=usr/share/man/man3/unimsg.3.gz
OLD_FILES+=usr/share/man/man3/unisap.3.gz
OLD_FILES+=usr/share/man/man3/unistruct.3.gz
OLD_FILES+=usr/share/man/man4/ng_atmllc.4.gz
OLD_FILES+=usr/share/man/man4/ng_ccatm.4.gz
OLD_FILES+=usr/share/man/man4/ng_sscfu.4.gz
OLD_FILES+=usr/share/man/man4/ng_sscop.4.gz
OLD_FILES+=usr/share/man/man4/ng_uni.4.gz
OLD_FILES+=usr/share/man/man4/ngatmbase.4.gz

# 20230308: machine-id merged into hostid_save
OLD_FILES+=etc/rc.d/machine_id

# 20230306: remove tzsetwall(3)
OLD_FILES+=usr/share/man/man3/tzsetwall.3.gz

# 20230208: new clang import which bumps version from 14.0.5 to 15.0.7
OLD_FILES+=usr/lib/clang/14.0.5/include/cuda_wrappers/algorithm
OLD_FILES+=usr/lib/clang/14.0.5/include/cuda_wrappers/complex
OLD_FILES+=usr/lib/clang/14.0.5/include/cuda_wrappers/new
OLD_DIRS+=usr/lib/clang/14.0.5/include/cuda_wrappers
OLD_FILES+=usr/lib/clang/14.0.5/include/fuzzer/FuzzedDataProvider.h
OLD_DIRS+=usr/lib/clang/14.0.5/include/fuzzer
OLD_FILES+=usr/lib/clang/14.0.5/include/openmp_wrappers/__clang_openmp_device_functions.h
OLD_FILES+=usr/lib/clang/14.0.5/include/openmp_wrappers/cmath
OLD_FILES+=usr/lib/clang/14.0.5/include/openmp_wrappers/complex
OLD_FILES+=usr/lib/clang/14.0.5/include/openmp_wrappers/complex.h
OLD_FILES+=usr/lib/clang/14.0.5/include/openmp_wrappers/complex_cmath.h
OLD_FILES+=usr/lib/clang/14.0.5/include/openmp_wrappers/math.h
OLD_FILES+=usr/lib/clang/14.0.5/include/openmp_wrappers/new
OLD_DIRS+=usr/lib/clang/14.0.5/include/openmp_wrappers
OLD_FILES+=usr/lib/clang/14.0.5/include/ppc_wrappers/emmintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/ppc_wrappers/mm_malloc.h
OLD_FILES+=usr/lib/clang/14.0.5/include/ppc_wrappers/mmintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/ppc_wrappers/pmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/ppc_wrappers/smmintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/ppc_wrappers/tmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/ppc_wrappers/xmmintrin.h
OLD_DIRS+=usr/lib/clang/14.0.5/include/ppc_wrappers
OLD_FILES+=usr/lib/clang/14.0.5/include/profile/InstrProfData.inc
OLD_FILES+=usr/lib/clang/14.0.5/include/profile/MemProfData.inc
OLD_DIRS+=usr/lib/clang/14.0.5/include/profile
OLD_FILES+=usr/lib/clang/14.0.5/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/14.0.5/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/14.0.5/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/14.0.5/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/14.0.5/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/14.0.5/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/14.0.5/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/14.0.5/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/14.0.5/include/sanitizer/memprof_interface.h
OLD_FILES+=usr/lib/clang/14.0.5/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/14.0.5/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/14.0.5/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/14.0.5/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/14.0.5/include/sanitizer/tsan_interface_atomic.h
OLD_FILES+=usr/lib/clang/14.0.5/include/sanitizer/ubsan_interface.h
OLD_DIRS+=usr/lib/clang/14.0.5/include/sanitizer
OLD_FILES+=usr/lib/clang/14.0.5/include/xray/xray_interface.h
OLD_FILES+=usr/lib/clang/14.0.5/include/xray/xray_log_interface.h
OLD_FILES+=usr/lib/clang/14.0.5/include/xray/xray_records.h
OLD_DIRS+=usr/lib/clang/14.0.5/include/xray
OLD_FILES+=usr/lib/clang/14.0.5/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/14.0.5/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/14.0.5/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/14.0.5/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/14.0.5/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/14.0.5/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/14.0.5/include/__clang_cuda_math.h
OLD_FILES+=usr/lib/clang/14.0.5/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/14.0.5/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/14.0.5/include/__clang_cuda_texture_intrinsics.h
OLD_FILES+=usr/lib/clang/14.0.5/include/__clang_hip_cmath.h
OLD_FILES+=usr/lib/clang/14.0.5/include/__clang_hip_libdevice_declares.h
OLD_FILES+=usr/lib/clang/14.0.5/include/__clang_hip_math.h
OLD_FILES+=usr/lib/clang/14.0.5/include/__clang_hip_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/14.0.5/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/14.0.5/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/14.0.5/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/14.0.5/include/adxintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/altivec.h
OLD_FILES+=usr/lib/clang/14.0.5/include/ammintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/amxintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/arm64intr.h
OLD_FILES+=usr/lib/clang/14.0.5/include/arm_acle.h
OLD_FILES+=usr/lib/clang/14.0.5/include/arm_bf16.h
OLD_FILES+=usr/lib/clang/14.0.5/include/arm_cde.h
OLD_FILES+=usr/lib/clang/14.0.5/include/arm_cmse.h
OLD_FILES+=usr/lib/clang/14.0.5/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/14.0.5/include/arm_mve.h
OLD_FILES+=usr/lib/clang/14.0.5/include/arm_neon.h
OLD_FILES+=usr/lib/clang/14.0.5/include/arm_neon_sve_bridge.h
OLD_FILES+=usr/lib/clang/14.0.5/include/arm_sve.h
OLD_FILES+=usr/lib/clang/14.0.5/include/armintr.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512bf16intrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512fp16intrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vlbf16intrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vlfp16intrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vlvp2intersectintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vp2intersectintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avxintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/avxvnniintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/builtins.h
OLD_FILES+=usr/lib/clang/14.0.5/include/cet.h
OLD_FILES+=usr/lib/clang/14.0.5/include/cetintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/cpuid.h
OLD_FILES+=usr/lib/clang/14.0.5/include/crc32intrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/emmintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/enqcmdintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/float.h
OLD_FILES+=usr/lib/clang/14.0.5/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/hexagon_circ_brev_intrinsics.h
OLD_FILES+=usr/lib/clang/14.0.5/include/hexagon_protos.h
OLD_FILES+=usr/lib/clang/14.0.5/include/hexagon_types.h
OLD_FILES+=usr/lib/clang/14.0.5/include/hresetintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/htmintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/hvx_hexagon_protos.h
OLD_FILES+=usr/lib/clang/14.0.5/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/immintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/intrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/inttypes.h
OLD_FILES+=usr/lib/clang/14.0.5/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/iso646.h
OLD_FILES+=usr/lib/clang/14.0.5/include/keylockerintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/limits.h
OLD_FILES+=usr/lib/clang/14.0.5/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/14.0.5/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/14.0.5/include/mmintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/module.modulemap
OLD_FILES+=usr/lib/clang/14.0.5/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/msa.h
OLD_FILES+=usr/lib/clang/14.0.5/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/omp-tools.h
OLD_FILES+=usr/lib/clang/14.0.5/include/omp.h
OLD_FILES+=usr/lib/clang/14.0.5/include/ompt.h
OLD_FILES+=usr/lib/clang/14.0.5/include/opencl-c-base.h
OLD_FILES+=usr/lib/clang/14.0.5/include/opencl-c.h
OLD_FILES+=usr/lib/clang/14.0.5/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/riscv_vector.h
OLD_FILES+=usr/lib/clang/14.0.5/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/s390intrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/serializeintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/shaintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/smmintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/stdalign.h
OLD_FILES+=usr/lib/clang/14.0.5/include/stdarg.h
OLD_FILES+=usr/lib/clang/14.0.5/include/stdatomic.h
OLD_FILES+=usr/lib/clang/14.0.5/include/stdbool.h
OLD_FILES+=usr/lib/clang/14.0.5/include/stddef.h
OLD_FILES+=usr/lib/clang/14.0.5/include/stdint.h
OLD_FILES+=usr/lib/clang/14.0.5/include/stdnoreturn.h
OLD_FILES+=usr/lib/clang/14.0.5/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/tgmath.h
OLD_FILES+=usr/lib/clang/14.0.5/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/tsxldtrkintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/uintrintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/unwind.h
OLD_FILES+=usr/lib/clang/14.0.5/include/vadefs.h
OLD_FILES+=usr/lib/clang/14.0.5/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/varargs.h
OLD_FILES+=usr/lib/clang/14.0.5/include/vecintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/wasm_simd128.h
OLD_FILES+=usr/lib/clang/14.0.5/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/x86gprintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/x86intrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/xopintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/14.0.5/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/14.0.5/include
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-aarch64.so
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-arm.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-arm.so
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-armhf.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-armhf.so
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-powerpc64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-powerpc64.so
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-powerpc64le.so
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-preinit-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-preinit-arm.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-preinit-armhf.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-preinit-powerpc64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-preinit-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-preinit-riscv64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-riscv64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-riscv64.so
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan_cxx-arm.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan_cxx-armhf.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan_cxx-riscv64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan_static-i386.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan_static-powerpc64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan_static-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.asan_static-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.cfi-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.cfi-arm.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.cfi-armhf.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.cfi-i386.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.cfi-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.cfi_diag-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.cfi_diag-arm.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.cfi_diag-armhf.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.cfi_diag-i386.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.cfi_diag-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.dd-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.dd-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.fuzzer-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.fuzzer-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.fuzzer_interceptors-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.fuzzer_no_main-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.fuzzer_no_main-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.msan-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.msan-powerpc64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.msan-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.msan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.msan_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.msan_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.profile-powerpc.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.profile-powerpc64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.profile-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.profile-riscv64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.safestack-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.stats-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.stats-arm.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.stats-armhf.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.stats-powerpc64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.stats-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.stats-riscv64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.stats_client-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.stats_client-arm.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.stats_client-armhf.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.stats_client-powerpc64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.stats_client-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.stats_client-riscv64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.tsan-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.tsan-powerpc64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.tsan-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.tsan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.tsan_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.tsan_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_minimal-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_minimal-arm.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_minimal-armhf.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_minimal-powerpc64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_minimal-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_minimal-riscv64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_standalone-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_standalone-arm.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_standalone-armhf.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_standalone-powerpc64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_standalone-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_standalone-riscv64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_standalone_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_standalone_cxx-arm.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_standalone_cxx-armhf.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_standalone_cxx-powerpc64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_standalone_cxx-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_standalone_cxx-riscv64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-arm.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-armhf.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-basic-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-basic-arm.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-basic-armhf.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-basic-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-basic-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-fdr-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-fdr-arm.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-fdr-armhf.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-fdr-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-fdr-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-profiling-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-profiling-arm.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-profiling-armhf.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-profiling-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-profiling-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.5/lib/freebsd/libclang_rt.xray-x86_64.a
OLD_DIRS+=usr/lib/clang/14.0.5/lib/freebsd
OLD_DIRS+=usr/lib/clang/14.0.5/lib
OLD_FILES+=usr/lib/clang/14.0.5/share/asan_ignorelist.txt
OLD_FILES+=usr/lib/clang/14.0.5/share/cfi_ignorelist.txt
OLD_FILES+=usr/lib/clang/14.0.5/share/msan_ignorelist.txt
OLD_DIRS+=usr/lib/clang/14.0.5/share
OLD_DIRS+=usr/lib/clang/14.0.5

# 20230208: new libc++ import which bumps version from 14.0.5 to 15.0.7
OLD_FILES+=usr/include/c++/v1/__functional_base
OLD_FILES+=usr/include/c++/v1/__libcpp_version
OLD_FILES+=usr/include/c++/v1/__nullptr
OLD_FILES+=usr/include/c++/v1/__string
OLD_FILES+=usr/include/c++/v1/experimental/filesystem

# 20230203: loader help files renamed
OLD_FILES+=boot/loader.help

# 20230201: timeout moved from /usr/bin to /bin
OLD_FILES+=usr/tests/usr.bin/timeout/Kyuafile
OLD_FILES+=usr/tests/usr.bin/timeout/timeout_test

# 20230124: rtalloc.9 removed
OLD_FILES+=usr/share/man/man9/rtalloc.9.gz
OLD_FILES+=usr/share/man/man9/rtalloc_fib.9.gz
OLD_FILES+=usr/share/man/man9/rtalloc_ign.9.gz
OLD_FILES+=usr/share/man/man9/rtalloc_ign_fib.9.gz
OLD_FILES+=usr/share/man/man9/rtalloc1.9.gz
OLD_FILES+=usr/share/man/man9/rtalloc1_fib.9.gz
OLD_FILES+=usr/share/man/man9/rtfree.9.gz
OLD_FILES+=usr/share/man/man9/RT_ADDREF.9.gz
OLD_FILES+=usr/share/man/man9/RT_LOCK.9.gz
OLD_FILES+=usr/share/man/man9/RT_REMREF.9.gz
OLD_FILES+=usr/share/man/man9/RT_RTFREE.9.gz
OLD_FILES+=usr/share/man/man9/RT_UNLOCK.9.gz
OLD_FILES+=usr/share/man/man9/RTFREE.9.gz
OLD_FILES+=usr/share/man/man9/RTFREE_LOCKED.9.gz

# 20230123: PCBGROUP.9 removed
OLD_FILES+=usr/share/man/man9/PCBGROUP.9.gz
OLD_FILES+=usr/share/man/man9/in_pcbgroup_byhash.9.gz
OLD_FILES+=usr/share/man/man9/in_pcbgroup_byinpcb.9.gz
OLD_FILES+=usr/share/man/man9/in_pcbgroup_destroy.9.gz
OLD_FILES+=usr/share/man/man9/in_pcbgroup_enabled.9.gz
OLD_FILES+=usr/share/man/man9/in_pcbgroup_init.9.gz
OLD_FILES+=usr/share/man/man9/in_pcbgroup_remove.9.gz
OLD_FILES+=usr/share/man/man9/in_pcbgroup_update.9.gz
OLD_FILES+=usr/share/man/man9/in_pcbgroup_update_mbuf.9.gz
OLD_FILES+=usr/share/man/man9/in6_pcbgroup_byhash.9.gz

# 20221214: TCPDEBUG removed
OLD_FILES+=usr/include/netinet/tcp_debug.h

# 20221213: remove sync serial drivers and utilities
OLD_FILES+=sbin/sconfig
OLD_FILES+=usr/share/man/man4/ce.4.gz
OLD_FILES+=usr/share/man/man4/cp.4.gz
OLD_FILES+=usr/share/man/man8/sconfig.8.gz

# 20221202: remove trpt(8)
OLD_FILES+=usr/sbin/trpt
OLD_FILES+=usr/share/man/man8/trpt.8.gz

# 20221117: remove typo'd man page link
OLD_FILES+=usr/share/man/man9/vm_map_wire_mapped.9.gz

# 20221114: remove othermta
OLD_FILES+=etc/rc.d/othermta

# 20221109: remove rc.sendmail(8)
OLD_FILES+=etc/rc.sendmail
OLD_FILES+=usr/share/man/man8/rc.sendmail.8.gz

# 20221015: update the ithread(9) man page
OLD_FILES+=usr/share/man/man9/ithread.9.gz
OLD_FILES+=usr/share/man/man9/ithread_add_handler.9.gz
OLD_FILES+=usr/share/man/man9/ithread_create.9.gz
OLD_FILES+=usr/share/man/man9/ithread_destroy.9.gz
OLD_FILES+=usr/share/man/man9/ithread_priority.9.gz
OLD_FILES+=usr/share/man/man9/ithread_remove_handler.9.gz
OLD_FILES+=usr/share/man/man9/ithread_schedule.9.gz

# 20221012: remove nls support from sort
OLD_FILES+=usr/share/nls/hu_HU.ISO8859-2/sort.cat

# 20221003: ip6protosw.h removed
OLD_FILES+=usr/include/netinet6/ip6protosw.h

# 20221001: deorbit opie
OLD_FILES+=etc/opieaccess
OLD_FILES+=etc/opiekeys
OLD_FILES+=usr/bin/opieinfo
OLD_FILES+=usr/bin/opiekey
OLD_FILES+=usr/bin/opiepasswd
OLD_FILES+=usr/bin/otp-md4
OLD_FILES+=usr/bin/otp-md5
OLD_FILES+=usr/bin/otp-sha1
OLD_FILES+=usr/include/opie.h
OLD_FILES+=usr/lib/libopie.a
OLD_FILES+=usr/lib/libopie.so
OLD_LIBS+=usr/lib/libopie.so.8
OLD_FILES+=usr/lib/libopie_p.a
OLD_FILES+=usr/lib/pam_opie.so
OLD_LIBS+=usr/lib/pam_opie.so.6
OLD_FILES+=usr/lib/pam_opieaccess.so
OLD_LIBS+=usr/lib/pam_opieaccess.so.6
OLD_FILES+=usr/share/man/man1/opieinfo.1.gz
OLD_FILES+=usr/share/man/man1/opiekey.1.gz
OLD_FILES+=usr/share/man/man1/opiepasswd.1.gz
OLD_FILES+=usr/share/man/man1/otp-md4.1.gz
OLD_FILES+=usr/share/man/man1/otp-md5.1.gz
OLD_FILES+=usr/share/man/man1/otp-sha1.1.gz
OLD_FILES+=usr/share/man/man4/opie.4.gz
OLD_FILES+=usr/share/man/man4/skey.4.gz
OLD_FILES+=usr/share/man/man5/opieaccess.5.gz
OLD_FILES+=usr/share/man/man5/opiekeys.5.gz
OLD_FILES+=usr/share/man/man8/pam_opie.8.gz
OLD_FILES+=usr/share/man/man8/pam_opieaccess.8.gz

# 20220928: telnetd(8) removed
OLD_FILES+=etc/pam.d/telnetd
OLD_FILES+=usr/libexec/telnetd
OLD_FILES+=usr/share/man/man8/telnetd.8.gz

# 20220914: domain(9) updated
OLD_FILES+=usr/share/man/man9/domain_init.9.gz
OLD_FILES+=usr/share/man/man9/pfctlinput.9.gz
OLD_FILES+=usr/share/man/man9/pffinddomain.9.gz
OLD_FILES+=usr/share/man/man9/pffindproto.9.gz
OLD_FILES+=usr/share/man/man9/pffindtype.9.gz

# 20220825: awk tests moved to subdirs
OLD_FILES+=usr/tests/usr.bin/awk/awk_test
OLD_FILES+=usr/tests/usr.bin/awk/d_assign_NF.awk
OLD_FILES+=usr/tests/usr.bin/awk/d_assign_NF.in
OLD_FILES+=usr/tests/usr.bin/awk/d_assign_NF.out
OLD_FILES+=usr/tests/usr.bin/awk/d_big_regexp.awk
OLD_FILES+=usr/tests/usr.bin/awk/d_big_regexp.in
OLD_FILES+=usr/tests/usr.bin/awk/d_big_regexp.out
OLD_FILES+=usr/tests/usr.bin/awk/d_end1.awk
OLD_FILES+=usr/tests/usr.bin/awk/d_end1.in
OLD_FILES+=usr/tests/usr.bin/awk/d_end1.out
OLD_FILES+=usr/tests/usr.bin/awk/d_end2.awk
OLD_FILES+=usr/tests/usr.bin/awk/d_end2.in
OLD_FILES+=usr/tests/usr.bin/awk/d_end2.out
OLD_FILES+=usr/tests/usr.bin/awk/d_period.awk
OLD_FILES+=usr/tests/usr.bin/awk/d_period.in
OLD_FILES+=usr/tests/usr.bin/awk/d_period.out
OLD_FILES+=usr/tests/usr.bin/awk/d_string1.awk
OLD_FILES+=usr/tests/usr.bin/awk/d_string1.out
OLD_FILES+=usr/tests/usr.bin/awk/d_tolower.awk
OLD_FILES+=usr/tests/usr.bin/awk/d_tolower.in
OLD_FILES+=usr/tests/usr.bin/awk/d_tolower.out
OLD_FILES+=usr/tests/usr.bin/awk/d_toupper.awk
OLD_FILES+=usr/tests/usr.bin/awk/d_toupper.in
OLD_FILES+=usr/tests/usr.bin/awk/d_toupper.out

# 20220820: remove knlist_init_rw_reader()
OLD_FILES+=usr/share/man/man9/knlist_init_rw_reader.9.gz

# 20220813: minigzip(1) removed in favor of gzip(1)
OLD_FILES+=usr/bin/minigzip
OLD_FILES+=usr/share/man/man1/minigzip.1.gz

# 20220811: MP_WATCHDOG removed
OLD_FILES+=usr/include/machine/mp_watchdog.h

# 20220811: new iconv encoder trait added
OLD_LIBS+=usr/lib/i18n/libBIG5.so.4
OLD_LIBS+=usr/lib/i18n/libDECHanyu.so.4
OLD_LIBS+=usr/lib/i18n/libEUC.so.4
OLD_LIBS+=usr/lib/i18n/libEUCTW.so.4
OLD_LIBS+=usr/lib/i18n/libGBK2K.so.4
OLD_LIBS+=usr/lib/i18n/libHZ.so.4
OLD_LIBS+=usr/lib/i18n/libISO2022.so.4
OLD_LIBS+=usr/lib/i18n/libJOHAB.so.4
OLD_LIBS+=usr/lib/i18n/libMSKanji.so.4
OLD_LIBS+=usr/lib/i18n/libUES.so.4
OLD_LIBS+=usr/lib/i18n/libUTF1632.so.4
OLD_LIBS+=usr/lib/i18n/libUTF7.so.4
OLD_LIBS+=usr/lib/i18n/libUTF8.so.4
OLD_LIBS+=usr/lib/i18n/libVIQR.so.4
OLD_LIBS+=usr/lib/i18n/libZW.so.4
OLD_LIBS+=usr/lib/i18n/libiconv_none.so.4
OLD_LIBS+=usr/lib/i18n/libiconv_std.so.4
OLD_LIBS+=usr/lib/i18n/libmapper_646.so.4
OLD_LIBS+=usr/lib/i18n/libmapper_none.so.4
OLD_LIBS+=usr/lib/i18n/libmapper_parallel.so.4
OLD_LIBS+=usr/lib/i18n/libmapper_serial.so.4
OLD_LIBS+=usr/lib/i18n/libmapper_std.so.4
OLD_LIBS+=usr/lib/i18n/libmapper_zone.so.4

# 20220811: raw socket layer removed
OLD_FILES+=usr/include/net/raw_cb.h

# 20220721: libnv version bumps
OLD_LIBS+=lib/libnv.so.0

# 20220624: unix_passfd_test -> unix_passfd_stream/unix_passfd_dgram
OLD_FILES+=usr/tests/sys/kern/unix_passfd_test

# 20220621: ISA sound card drivers removed
OLD_FILES+=usr/share/man/man4/snd_ad1816.4.gz
OLD_FILES+=usr/share/man/man4/snd_ess.4.gz
OLD_FILES+=usr/share/man/man4/snd_gusc.4.gz
OLD_FILES+=usr/share/man/man4/snd_mss.4.gz
OLD_FILES+=usr/share/man/man4/snd_sb16.4.gz
OLD_FILES+=usr/share/man/man4/snd_sb8.4.gz
OLD_FILES+=usr/share/man/man4/snd_sbc.4.gz

# 20220612: new clang import which bumps version from 14.0.4 to 14.0.5
OLD_FILES+=usr/lib/clang/14.0.4/include/cuda_wrappers/algorithm
OLD_FILES+=usr/lib/clang/14.0.4/include/cuda_wrappers/complex
OLD_FILES+=usr/lib/clang/14.0.4/include/cuda_wrappers/new
OLD_DIRS+=usr/lib/clang/14.0.4/include/cuda_wrappers
OLD_FILES+=usr/lib/clang/14.0.4/include/fuzzer/FuzzedDataProvider.h
OLD_DIRS+=usr/lib/clang/14.0.4/include/fuzzer
OLD_FILES+=usr/lib/clang/14.0.4/include/openmp_wrappers/__clang_openmp_device_functions.h
OLD_FILES+=usr/lib/clang/14.0.4/include/openmp_wrappers/cmath
OLD_FILES+=usr/lib/clang/14.0.4/include/openmp_wrappers/complex
OLD_FILES+=usr/lib/clang/14.0.4/include/openmp_wrappers/complex.h
OLD_FILES+=usr/lib/clang/14.0.4/include/openmp_wrappers/complex_cmath.h
OLD_FILES+=usr/lib/clang/14.0.4/include/openmp_wrappers/math.h
OLD_FILES+=usr/lib/clang/14.0.4/include/openmp_wrappers/new
OLD_DIRS+=usr/lib/clang/14.0.4/include/openmp_wrappers
OLD_FILES+=usr/lib/clang/14.0.4/include/ppc_wrappers/emmintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/ppc_wrappers/mm_malloc.h
OLD_FILES+=usr/lib/clang/14.0.4/include/ppc_wrappers/mmintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/ppc_wrappers/pmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/ppc_wrappers/smmintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/ppc_wrappers/tmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/ppc_wrappers/xmmintrin.h
OLD_DIRS+=usr/lib/clang/14.0.4/include/ppc_wrappers
OLD_FILES+=usr/lib/clang/14.0.4/include/profile/InstrProfData.inc
OLD_FILES+=usr/lib/clang/14.0.4/include/profile/MemProfData.inc
OLD_DIRS+=usr/lib/clang/14.0.4/include/profile
OLD_FILES+=usr/lib/clang/14.0.4/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/14.0.4/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/14.0.4/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/14.0.4/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/14.0.4/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/14.0.4/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/14.0.4/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/14.0.4/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/14.0.4/include/sanitizer/memprof_interface.h
OLD_FILES+=usr/lib/clang/14.0.4/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/14.0.4/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/14.0.4/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/14.0.4/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/14.0.4/include/sanitizer/tsan_interface_atomic.h
OLD_FILES+=usr/lib/clang/14.0.4/include/sanitizer/ubsan_interface.h
OLD_DIRS+=usr/lib/clang/14.0.4/include/sanitizer
OLD_FILES+=usr/lib/clang/14.0.4/include/xray/xray_interface.h
OLD_FILES+=usr/lib/clang/14.0.4/include/xray/xray_log_interface.h
OLD_FILES+=usr/lib/clang/14.0.4/include/xray/xray_records.h
OLD_DIRS+=usr/lib/clang/14.0.4/include/xray
OLD_FILES+=usr/lib/clang/14.0.4/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/14.0.4/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/14.0.4/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/14.0.4/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/14.0.4/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/14.0.4/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/14.0.4/include/__clang_cuda_math.h
OLD_FILES+=usr/lib/clang/14.0.4/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/14.0.4/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/14.0.4/include/__clang_cuda_texture_intrinsics.h
OLD_FILES+=usr/lib/clang/14.0.4/include/__clang_hip_cmath.h
OLD_FILES+=usr/lib/clang/14.0.4/include/__clang_hip_libdevice_declares.h
OLD_FILES+=usr/lib/clang/14.0.4/include/__clang_hip_math.h
OLD_FILES+=usr/lib/clang/14.0.4/include/__clang_hip_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/14.0.4/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/14.0.4/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/14.0.4/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/14.0.4/include/adxintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/altivec.h
OLD_FILES+=usr/lib/clang/14.0.4/include/ammintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/amxintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/arm64intr.h
OLD_FILES+=usr/lib/clang/14.0.4/include/arm_acle.h
OLD_FILES+=usr/lib/clang/14.0.4/include/arm_bf16.h
OLD_FILES+=usr/lib/clang/14.0.4/include/arm_cde.h
OLD_FILES+=usr/lib/clang/14.0.4/include/arm_cmse.h
OLD_FILES+=usr/lib/clang/14.0.4/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/14.0.4/include/arm_mve.h
OLD_FILES+=usr/lib/clang/14.0.4/include/arm_neon.h
OLD_FILES+=usr/lib/clang/14.0.4/include/arm_neon_sve_bridge.h
OLD_FILES+=usr/lib/clang/14.0.4/include/arm_sve.h
OLD_FILES+=usr/lib/clang/14.0.4/include/armintr.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512bf16intrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512fp16intrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vlbf16intrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vlfp16intrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vlvp2intersectintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vp2intersectintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avxintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/avxvnniintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/builtins.h
OLD_FILES+=usr/lib/clang/14.0.4/include/cet.h
OLD_FILES+=usr/lib/clang/14.0.4/include/cetintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/cpuid.h
OLD_FILES+=usr/lib/clang/14.0.4/include/crc32intrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/emmintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/enqcmdintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/float.h
OLD_FILES+=usr/lib/clang/14.0.4/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/hexagon_circ_brev_intrinsics.h
OLD_FILES+=usr/lib/clang/14.0.4/include/hexagon_protos.h
OLD_FILES+=usr/lib/clang/14.0.4/include/hexagon_types.h
OLD_FILES+=usr/lib/clang/14.0.4/include/hresetintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/htmintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/hvx_hexagon_protos.h
OLD_FILES+=usr/lib/clang/14.0.4/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/immintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/intrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/inttypes.h
OLD_FILES+=usr/lib/clang/14.0.4/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/iso646.h
OLD_FILES+=usr/lib/clang/14.0.4/include/keylockerintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/limits.h
OLD_FILES+=usr/lib/clang/14.0.4/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/14.0.4/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/14.0.4/include/mmintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/module.modulemap
OLD_FILES+=usr/lib/clang/14.0.4/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/msa.h
OLD_FILES+=usr/lib/clang/14.0.4/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/omp-tools.h
OLD_FILES+=usr/lib/clang/14.0.4/include/omp.h
OLD_FILES+=usr/lib/clang/14.0.4/include/ompt.h
OLD_FILES+=usr/lib/clang/14.0.4/include/opencl-c-base.h
OLD_FILES+=usr/lib/clang/14.0.4/include/opencl-c.h
OLD_FILES+=usr/lib/clang/14.0.4/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/riscv_vector.h
OLD_FILES+=usr/lib/clang/14.0.4/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/s390intrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/serializeintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/shaintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/smmintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/stdalign.h
OLD_FILES+=usr/lib/clang/14.0.4/include/stdarg.h
OLD_FILES+=usr/lib/clang/14.0.4/include/stdatomic.h
OLD_FILES+=usr/lib/clang/14.0.4/include/stdbool.h
OLD_FILES+=usr/lib/clang/14.0.4/include/stddef.h
OLD_FILES+=usr/lib/clang/14.0.4/include/stdint.h
OLD_FILES+=usr/lib/clang/14.0.4/include/stdnoreturn.h
OLD_FILES+=usr/lib/clang/14.0.4/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/tgmath.h
OLD_FILES+=usr/lib/clang/14.0.4/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/tsxldtrkintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/uintrintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/unwind.h
OLD_FILES+=usr/lib/clang/14.0.4/include/vadefs.h
OLD_FILES+=usr/lib/clang/14.0.4/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/varargs.h
OLD_FILES+=usr/lib/clang/14.0.4/include/vecintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/wasm_simd128.h
OLD_FILES+=usr/lib/clang/14.0.4/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/x86gprintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/x86intrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/xopintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/14.0.4/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/14.0.4/include
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan-aarch64.so
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan-arm.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan-arm.so
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan-armhf.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan-armhf.so
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan-preinit-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan-preinit-arm.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan-preinit-armhf.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan_cxx-arm.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan_cxx-armhf.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan_static-i386.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.asan_static-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.cfi-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.cfi-arm.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.cfi-armhf.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.cfi-i386.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.cfi-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.cfi_diag-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.cfi_diag-arm.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.cfi_diag-armhf.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.cfi_diag-i386.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.cfi_diag-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.dd-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.dd-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.fuzzer-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.fuzzer-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.fuzzer_interceptors-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.fuzzer_no_main-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.fuzzer_no_main-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.msan-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.msan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.profile-powerpc.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.profile-powerpc64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.profile-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.safestack-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.stats-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.stats-arm.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.stats-armhf.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.stats_client-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.stats_client-arm.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.stats_client-armhf.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.tsan-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.tsan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.ubsan_minimal-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.ubsan_minimal-arm.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.ubsan_minimal-armhf.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.ubsan_standalone-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.ubsan_standalone-arm.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.ubsan_standalone-armhf.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.ubsan_standalone_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.ubsan_standalone_cxx-arm.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.ubsan_standalone_cxx-armhf.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.xray-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.xray-arm.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.xray-armhf.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.xray-basic-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.xray-basic-arm.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.xray-basic-armhf.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.xray-basic-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.xray-fdr-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.xray-fdr-arm.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.xray-fdr-armhf.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.xray-fdr-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.xray-profiling-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.xray-profiling-arm.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.xray-profiling-armhf.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.xray-profiling-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.4/lib/freebsd/libclang_rt.xray-x86_64.a
OLD_DIRS+=usr/lib/clang/14.0.4/lib/freebsd
OLD_DIRS+=usr/lib/clang/14.0.4/lib/share
OLD_DIRS+=usr/lib/clang/14.0.4/lib
OLD_FILES+=usr/lib/clang/14.0.4/share/asan_ignorelist.txt
OLD_FILES+=usr/lib/clang/14.0.4/share/cfi_ignorelist.txt
OLD_FILES+=usr/lib/clang/14.0.4/share/msan_ignorelist.txt
OLD_DIRS+=usr/lib/clang/14.0.4/share
OLD_DIRS+=usr/lib/clang/14.0.4

# 20220605: new clang import which bumps version from 14.0.3 to 14.0.4
OLD_FILES+=usr/lib/clang/14.0.3/include/cuda_wrappers/algorithm
OLD_FILES+=usr/lib/clang/14.0.3/include/cuda_wrappers/complex
OLD_FILES+=usr/lib/clang/14.0.3/include/cuda_wrappers/new
OLD_DIRS+=usr/lib/clang/14.0.3/include/cuda_wrappers
OLD_FILES+=usr/lib/clang/14.0.3/include/fuzzer/FuzzedDataProvider.h
OLD_DIRS+=usr/lib/clang/14.0.3/include/fuzzer
OLD_FILES+=usr/lib/clang/14.0.3/include/openmp_wrappers/__clang_openmp_device_functions.h
OLD_FILES+=usr/lib/clang/14.0.3/include/openmp_wrappers/cmath
OLD_FILES+=usr/lib/clang/14.0.3/include/openmp_wrappers/complex
OLD_FILES+=usr/lib/clang/14.0.3/include/openmp_wrappers/complex.h
OLD_FILES+=usr/lib/clang/14.0.3/include/openmp_wrappers/complex_cmath.h
OLD_FILES+=usr/lib/clang/14.0.3/include/openmp_wrappers/math.h
OLD_FILES+=usr/lib/clang/14.0.3/include/openmp_wrappers/new
OLD_DIRS+=usr/lib/clang/14.0.3/include/openmp_wrappers
OLD_FILES+=usr/lib/clang/14.0.3/include/ppc_wrappers/emmintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/ppc_wrappers/mm_malloc.h
OLD_FILES+=usr/lib/clang/14.0.3/include/ppc_wrappers/mmintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/ppc_wrappers/pmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/ppc_wrappers/smmintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/ppc_wrappers/tmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/ppc_wrappers/xmmintrin.h
OLD_DIRS+=usr/lib/clang/14.0.3/include/ppc_wrappers
OLD_FILES+=usr/lib/clang/14.0.3/include/profile/InstrProfData.inc
OLD_FILES+=usr/lib/clang/14.0.3/include/profile/MemProfData.inc
OLD_DIRS+=usr/lib/clang/14.0.3/include/profile
OLD_FILES+=usr/lib/clang/14.0.3/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/14.0.3/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/14.0.3/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/14.0.3/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/14.0.3/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/14.0.3/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/14.0.3/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/14.0.3/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/14.0.3/include/sanitizer/memprof_interface.h
OLD_FILES+=usr/lib/clang/14.0.3/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/14.0.3/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/14.0.3/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/14.0.3/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/14.0.3/include/sanitizer/tsan_interface_atomic.h
OLD_FILES+=usr/lib/clang/14.0.3/include/sanitizer/ubsan_interface.h
OLD_DIRS+=usr/lib/clang/14.0.3/include/sanitizer
OLD_FILES+=usr/lib/clang/14.0.3/include/xray/xray_interface.h
OLD_FILES+=usr/lib/clang/14.0.3/include/xray/xray_log_interface.h
OLD_FILES+=usr/lib/clang/14.0.3/include/xray/xray_records.h
OLD_DIRS+=usr/lib/clang/14.0.3/include/xray
OLD_FILES+=usr/lib/clang/14.0.3/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/14.0.3/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/14.0.3/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/14.0.3/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/14.0.3/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/14.0.3/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/14.0.3/include/__clang_cuda_math.h
OLD_FILES+=usr/lib/clang/14.0.3/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/14.0.3/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/14.0.3/include/__clang_cuda_texture_intrinsics.h
OLD_FILES+=usr/lib/clang/14.0.3/include/__clang_hip_cmath.h
OLD_FILES+=usr/lib/clang/14.0.3/include/__clang_hip_libdevice_declares.h
OLD_FILES+=usr/lib/clang/14.0.3/include/__clang_hip_math.h
OLD_FILES+=usr/lib/clang/14.0.3/include/__clang_hip_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/14.0.3/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/14.0.3/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/14.0.3/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/14.0.3/include/adxintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/altivec.h
OLD_FILES+=usr/lib/clang/14.0.3/include/ammintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/amxintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/arm64intr.h
OLD_FILES+=usr/lib/clang/14.0.3/include/arm_acle.h
OLD_FILES+=usr/lib/clang/14.0.3/include/arm_bf16.h
OLD_FILES+=usr/lib/clang/14.0.3/include/arm_cde.h
OLD_FILES+=usr/lib/clang/14.0.3/include/arm_cmse.h
OLD_FILES+=usr/lib/clang/14.0.3/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/14.0.3/include/arm_mve.h
OLD_FILES+=usr/lib/clang/14.0.3/include/arm_neon.h
OLD_FILES+=usr/lib/clang/14.0.3/include/arm_neon_sve_bridge.h
OLD_FILES+=usr/lib/clang/14.0.3/include/arm_sve.h
OLD_FILES+=usr/lib/clang/14.0.3/include/armintr.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512bf16intrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512fp16intrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vlbf16intrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vlfp16intrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vlvp2intersectintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vp2intersectintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avxintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/avxvnniintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/builtins.h
OLD_FILES+=usr/lib/clang/14.0.3/include/cet.h
OLD_FILES+=usr/lib/clang/14.0.3/include/cetintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/cpuid.h
OLD_FILES+=usr/lib/clang/14.0.3/include/crc32intrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/emmintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/enqcmdintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/float.h
OLD_FILES+=usr/lib/clang/14.0.3/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/hexagon_circ_brev_intrinsics.h
OLD_FILES+=usr/lib/clang/14.0.3/include/hexagon_protos.h
OLD_FILES+=usr/lib/clang/14.0.3/include/hexagon_types.h
OLD_FILES+=usr/lib/clang/14.0.3/include/hresetintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/htmintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/hvx_hexagon_protos.h
OLD_FILES+=usr/lib/clang/14.0.3/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/immintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/intrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/inttypes.h
OLD_FILES+=usr/lib/clang/14.0.3/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/iso646.h
OLD_FILES+=usr/lib/clang/14.0.3/include/keylockerintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/limits.h
OLD_FILES+=usr/lib/clang/14.0.3/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/14.0.3/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/14.0.3/include/mmintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/module.modulemap
OLD_FILES+=usr/lib/clang/14.0.3/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/msa.h
OLD_FILES+=usr/lib/clang/14.0.3/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/omp-tools.h
OLD_FILES+=usr/lib/clang/14.0.3/include/omp.h
OLD_FILES+=usr/lib/clang/14.0.3/include/ompt.h
OLD_FILES+=usr/lib/clang/14.0.3/include/opencl-c-base.h
OLD_FILES+=usr/lib/clang/14.0.3/include/opencl-c.h
OLD_FILES+=usr/lib/clang/14.0.3/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/riscv_vector.h
OLD_FILES+=usr/lib/clang/14.0.3/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/s390intrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/serializeintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/shaintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/smmintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/stdalign.h
OLD_FILES+=usr/lib/clang/14.0.3/include/stdarg.h
OLD_FILES+=usr/lib/clang/14.0.3/include/stdatomic.h
OLD_FILES+=usr/lib/clang/14.0.3/include/stdbool.h
OLD_FILES+=usr/lib/clang/14.0.3/include/stddef.h
OLD_FILES+=usr/lib/clang/14.0.3/include/stdint.h
OLD_FILES+=usr/lib/clang/14.0.3/include/stdnoreturn.h
OLD_FILES+=usr/lib/clang/14.0.3/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/tgmath.h
OLD_FILES+=usr/lib/clang/14.0.3/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/tsxldtrkintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/uintrintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/unwind.h
OLD_FILES+=usr/lib/clang/14.0.3/include/vadefs.h
OLD_FILES+=usr/lib/clang/14.0.3/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/varargs.h
OLD_FILES+=usr/lib/clang/14.0.3/include/vecintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/wasm_simd128.h
OLD_FILES+=usr/lib/clang/14.0.3/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/x86gprintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/x86intrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/xopintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/14.0.3/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/14.0.3/include
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan-aarch64.so
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan-arm.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan-arm.so
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan-armhf.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan-armhf.so
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan-preinit-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan-preinit-arm.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan-preinit-armhf.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan_cxx-arm.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan_cxx-armhf.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan_static-i386.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.asan_static-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.cfi-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.cfi-arm.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.cfi-armhf.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.cfi-i386.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.cfi-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.cfi_diag-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.cfi_diag-arm.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.cfi_diag-armhf.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.cfi_diag-i386.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.cfi_diag-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.dd-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.dd-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.fuzzer-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.fuzzer-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.fuzzer_interceptors-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.fuzzer_no_main-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.fuzzer_no_main-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.msan-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.msan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.profile-powerpc.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.profile-powerpc64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.profile-powerpc64le.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.safestack-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.stats-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.stats-arm.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.stats-armhf.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.stats_client-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.stats_client-arm.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.stats_client-armhf.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.tsan-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.tsan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.ubsan_minimal-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.ubsan_minimal-arm.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.ubsan_minimal-armhf.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.ubsan_standalone-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.ubsan_standalone-arm.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.ubsan_standalone-armhf.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.ubsan_standalone_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.ubsan_standalone_cxx-arm.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.ubsan_standalone_cxx-armhf.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.xray-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.xray-arm.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.xray-armhf.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.xray-basic-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.xray-basic-arm.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.xray-basic-armhf.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.xray-basic-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.xray-fdr-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.xray-fdr-arm.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.xray-fdr-armhf.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.xray-fdr-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.xray-profiling-aarch64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.xray-profiling-arm.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.xray-profiling-armhf.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.xray-profiling-x86_64.a
OLD_FILES+=usr/lib/clang/14.0.3/lib/freebsd/libclang_rt.xray-x86_64.a
OLD_DIRS+=usr/lib/clang/14.0.3/lib/freebsd
OLD_DIRS+=usr/lib/clang/14.0.3/lib/share
OLD_DIRS+=usr/lib/clang/14.0.3/lib
OLD_FILES+=usr/lib/clang/14.0.3/share/asan_ignorelist.txt
OLD_FILES+=usr/lib/clang/14.0.3/share/cfi_ignorelist.txt
OLD_FILES+=usr/lib/clang/14.0.3/share/msan_ignorelist.txt
OLD_DIRS+=usr/lib/clang/14.0.3/share
OLD_DIRS+=usr/lib/clang/14.0.3

# 20220524: libkqueue test updates
OLD_FILES+=usr/tests/sys/kqueue/libkqueue/kqtest

# 20220514: new clang import which bumps version from 13.0.0 to 14.0.3
OLD_FILES+=usr/lib/clang/13.0.0/include/cuda_wrappers/algorithm
OLD_FILES+=usr/lib/clang/13.0.0/include/cuda_wrappers/complex
OLD_FILES+=usr/lib/clang/13.0.0/include/cuda_wrappers/new
OLD_DIRS+=usr/lib/clang/13.0.0/include/cuda_wrappers
OLD_FILES+=usr/lib/clang/13.0.0/include/fuzzer/FuzzedDataProvider.h
OLD_DIRS+=usr/lib/clang/13.0.0/include/fuzzer
OLD_FILES+=usr/lib/clang/13.0.0/include/openmp_wrappers/__clang_openmp_device_functions.h
OLD_FILES+=usr/lib/clang/13.0.0/include/openmp_wrappers/cmath
OLD_FILES+=usr/lib/clang/13.0.0/include/openmp_wrappers/complex
OLD_FILES+=usr/lib/clang/13.0.0/include/openmp_wrappers/complex.h
OLD_FILES+=usr/lib/clang/13.0.0/include/openmp_wrappers/complex_cmath.h
OLD_FILES+=usr/lib/clang/13.0.0/include/openmp_wrappers/math.h
OLD_FILES+=usr/lib/clang/13.0.0/include/openmp_wrappers/new
OLD_DIRS+=usr/lib/clang/13.0.0/include/openmp_wrappers
OLD_FILES+=usr/lib/clang/13.0.0/include/ppc_wrappers/emmintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/ppc_wrappers/mm_malloc.h
OLD_FILES+=usr/lib/clang/13.0.0/include/ppc_wrappers/mmintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/ppc_wrappers/pmmintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/ppc_wrappers/smmintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/ppc_wrappers/tmmintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/ppc_wrappers/xmmintrin.h
OLD_DIRS+=usr/lib/clang/13.0.0/include/ppc_wrappers
OLD_FILES+=usr/lib/clang/13.0.0/include/profile/InstrProfData.inc
OLD_DIRS+=usr/lib/clang/13.0.0/include/profile
OLD_FILES+=usr/lib/clang/13.0.0/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/13.0.0/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/13.0.0/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/13.0.0/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/13.0.0/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/13.0.0/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/13.0.0/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/13.0.0/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/13.0.0/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/13.0.0/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/13.0.0/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/13.0.0/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/13.0.0/include/sanitizer/tsan_interface_atomic.h
OLD_FILES+=usr/lib/clang/13.0.0/include/sanitizer/ubsan_interface.h
OLD_DIRS+=usr/lib/clang/13.0.0/include/sanitizer
OLD_FILES+=usr/lib/clang/13.0.0/include/xray/xray_interface.h
OLD_FILES+=usr/lib/clang/13.0.0/include/xray/xray_log_interface.h
OLD_FILES+=usr/lib/clang/13.0.0/include/xray/xray_records.h
OLD_DIRS+=usr/lib/clang/13.0.0/include/xray
OLD_FILES+=usr/lib/clang/13.0.0/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/13.0.0/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/13.0.0/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/13.0.0/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/13.0.0/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/13.0.0/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/13.0.0/include/__clang_cuda_math.h
OLD_FILES+=usr/lib/clang/13.0.0/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/13.0.0/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/13.0.0/include/__clang_hip_cmath.h
OLD_FILES+=usr/lib/clang/13.0.0/include/__clang_hip_libdevice_declares.h
OLD_FILES+=usr/lib/clang/13.0.0/include/__clang_hip_math.h
OLD_FILES+=usr/lib/clang/13.0.0/include/__clang_hip_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/13.0.0/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/13.0.0/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/13.0.0/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/13.0.0/include/adxintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/altivec.h
OLD_FILES+=usr/lib/clang/13.0.0/include/ammintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/amxintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/arm64intr.h
OLD_FILES+=usr/lib/clang/13.0.0/include/arm_acle.h
OLD_FILES+=usr/lib/clang/13.0.0/include/arm_bf16.h
OLD_FILES+=usr/lib/clang/13.0.0/include/arm_cde.h
OLD_FILES+=usr/lib/clang/13.0.0/include/arm_cmse.h
OLD_FILES+=usr/lib/clang/13.0.0/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/13.0.0/include/arm_mve.h
OLD_FILES+=usr/lib/clang/13.0.0/include/arm_neon.h
OLD_FILES+=usr/lib/clang/13.0.0/include/arm_sve.h
OLD_FILES+=usr/lib/clang/13.0.0/include/armintr.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512bf16intrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512vlbf16intrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512vlvp2intersectintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512vp2intersectintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avxintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/avxvnniintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/builtins.h
OLD_FILES+=usr/lib/clang/13.0.0/include/cet.h
OLD_FILES+=usr/lib/clang/13.0.0/include/cetintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/cpuid.h
OLD_FILES+=usr/lib/clang/13.0.0/include/emmintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/enqcmdintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/float.h
OLD_FILES+=usr/lib/clang/13.0.0/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/hexagon_circ_brev_intrinsics.h
OLD_FILES+=usr/lib/clang/13.0.0/include/hexagon_protos.h
OLD_FILES+=usr/lib/clang/13.0.0/include/hexagon_types.h
OLD_FILES+=usr/lib/clang/13.0.0/include/hresetintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/htmintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/hvx_hexagon_protos.h
OLD_FILES+=usr/lib/clang/13.0.0/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/immintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/intrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/inttypes.h
OLD_FILES+=usr/lib/clang/13.0.0/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/iso646.h
OLD_FILES+=usr/lib/clang/13.0.0/include/keylockerintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/limits.h
OLD_FILES+=usr/lib/clang/13.0.0/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/13.0.0/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/13.0.0/include/mmintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/module.modulemap
OLD_FILES+=usr/lib/clang/13.0.0/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/msa.h
OLD_FILES+=usr/lib/clang/13.0.0/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/omp-tools.h
OLD_FILES+=usr/lib/clang/13.0.0/include/omp.h
OLD_FILES+=usr/lib/clang/13.0.0/include/ompt.h
OLD_FILES+=usr/lib/clang/13.0.0/include/opencl-c-base.h
OLD_FILES+=usr/lib/clang/13.0.0/include/opencl-c.h
OLD_FILES+=usr/lib/clang/13.0.0/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/riscv_vector.h
OLD_FILES+=usr/lib/clang/13.0.0/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/s390intrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/serializeintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/shaintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/smmintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/stdalign.h
OLD_FILES+=usr/lib/clang/13.0.0/include/stdarg.h
OLD_FILES+=usr/lib/clang/13.0.0/include/stdatomic.h
OLD_FILES+=usr/lib/clang/13.0.0/include/stdbool.h
OLD_FILES+=usr/lib/clang/13.0.0/include/stddef.h
OLD_FILES+=usr/lib/clang/13.0.0/include/stdint.h
OLD_FILES+=usr/lib/clang/13.0.0/include/stdnoreturn.h
OLD_FILES+=usr/lib/clang/13.0.0/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/tgmath.h
OLD_FILES+=usr/lib/clang/13.0.0/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/tsxldtrkintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/uintrintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/unwind.h
OLD_FILES+=usr/lib/clang/13.0.0/include/vadefs.h
OLD_FILES+=usr/lib/clang/13.0.0/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/varargs.h
OLD_FILES+=usr/lib/clang/13.0.0/include/vecintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/wasm_simd128.h
OLD_FILES+=usr/lib/clang/13.0.0/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/x86gprintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/x86intrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/xopintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/13.0.0/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/13.0.0/include
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan-aarch64.so
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan-arm.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan-arm.so
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan-armhf.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan-armhf.so
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan-preinit-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan-preinit-arm.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan-preinit-armhf.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan_cxx-arm.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan_cxx-armhf.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.cfi-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.cfi-arm.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.cfi-armhf.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.cfi-i386.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.cfi-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.cfi_diag-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.cfi_diag-arm.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.cfi_diag-armhf.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.cfi_diag-i386.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.cfi_diag-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.dd-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.dd-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.fuzzer-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.fuzzer-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.fuzzer_no_main-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.fuzzer_no_main-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.msan-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.msan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.profile-powerpc.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.profile-powerpc64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.profile-powerpc64le.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.safestack-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.stats-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.stats-arm.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.stats-armhf.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.stats_client-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.stats_client-arm.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.stats_client-armhf.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.tsan-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.tsan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.ubsan_minimal-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.ubsan_minimal-arm.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.ubsan_minimal-armhf.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.ubsan_standalone-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.ubsan_standalone-arm.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.ubsan_standalone-armhf.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-arm.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-armhf.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.xray-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.xray-arm.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.xray-armhf.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.xray-basic-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.xray-basic-arm.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.xray-basic-armhf.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.xray-basic-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.xray-fdr-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.xray-fdr-arm.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.xray-fdr-armhf.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.xray-fdr-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.xray-profiling-aarch64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.xray-profiling-arm.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.xray-profiling-armhf.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.xray-profiling-x86_64.a
OLD_FILES+=usr/lib/clang/13.0.0/lib/freebsd/libclang_rt.xray-x86_64.a
OLD_DIRS+=usr/lib/clang/13.0.0/lib/freebsd
OLD_DIRS+=usr/lib/clang/13.0.0/lib
OLD_DIRS+=usr/lib/clang/13.0.0

# 20220514: new libc++ import which bumps version from 13.0.0 to 14.0.3
OLD_FILES+=usr/include/c++/v1/__function_like.h
OLD_FILES+=usr/include/c++/v1/__memory/pointer_safety.h
OLD_FILES+=usr/include/c++/v1/__utility/__decay_copy.h

# 20220418: uudecode merged into uuencode and renamed to bintrans
OLD_FILES+=usr/lib/debug/usr/bin/uuencode.debug
OLD_FILES+=usr/lib/debug/usr/bin/uudecode.debug
OLD_FILES+=usr/tests/usr.bin/uuencode/Kyuafile
OLD_FILES+=usr/tests/usr.bin/uuencode/legacy_test
OLD_FILES+=usr/tests/usr.bin/uuencode/regress.base64.in
OLD_FILES+=usr/tests/usr.bin/uuencode/regress.traditional.out
OLD_FILES+=usr/tests/usr.bin/uuencode/regress.traditional.in
OLD_FILES+=usr/tests/usr.bin/uuencode/regress.out
OLD_FILES+=usr/tests/usr.bin/uuencode/regress.sh
OLD_FILES+=usr/tests/usr.bin/uuencode/regress.in
OLD_FILES+=usr/tests/usr.bin/uuencode/regress.153276.in
OLD_FILES+=usr/tests/usr.bin/uuencode/regress.base64.out
OLD_FILES+=usr/tests/usr.bin/uuencode/regress.153276.out
OLD_FILES+=usr/tests/usr.bin/uudecode/regress.base64.in
OLD_FILES+=usr/tests/usr.bin/uudecode/Kyuafile
OLD_FILES+=usr/tests/usr.bin/uudecode/regress.out
OLD_FILES+=usr/tests/usr.bin/uudecode/regress.sh
OLD_FILES+=usr/tests/usr.bin/uudecode/regress.153276.out
OLD_FILES+=usr/tests/usr.bin/uudecode/regress.traditional.in
OLD_FILES+=usr/tests/usr.bin/uudecode/legacy_test
OLD_FILES+=usr/tests/usr.bin/uudecode/regress.153276.in
OLD_DIRS+=usr/tests/usr.bin/uuencode
OLD_DIRS+=usr/tests/usr.bin/uudecode

# 20220318: snd_ds1 and snd_maestro drivers removed
OLD_FILES+=usr/share/man/man4/snd_ds1.4.gz
OLD_FILES+=usr/share/man/man4/snd_maestro.4.gz

# 20220307: remove 330.news
OLD_FILES+=etc/periodic/daily/330.news

# 20220210: unwind.h moved to /usr/include
OLD_FILES+=usr/include/c++/v1/unwind-arm.h
OLD_FILES+=usr/include/c++/v1/unwind-itanium.h
OLD_FILES+=usr/include/c++/v1/unwind.h

# 20220128: mips pmc events removed
OLD_FILES+=usr/share/man/man3/pmc.mips24k.3.gz
OLD_FILES+=usr/share/man/man3/pmc.octeon.3.gz

# 20220127: terasic_mtl.4 removed
OLD_FILES+=usr/share/man/man4/terasic_mtl.4.gz

# 20211229: libc++ moved to /lib
MOVED_LIBS+=usr/lib/libc++.so.1

# 20211221: efi_set_variables_supported.3 should be efi_variables_supported.3
OLD_FILES+=usr/share/man/man3/efi_set_variables_supported.3.gz

# 20211218: meteor.4 removed, see also 20200301 entry below
OLD_FILES+=usr/share/man/man4/meteor.4.gz

# 20211125: Old SCSI drivers removed
OLD_FILES+=usr/include/dev/ic/esp.h
OLD_FILES+=usr/share/man/man4/amr.4.gz
OLD_FILES+=usr/share/man/man4/esp.4.gz
OLD_FILES+=usr/share/man/man4/iir.4.gz
OLD_FILES+=usr/share/man/man4/mly.4.gz
OLD_FILES+=usr/share/man/man4/twa.4.gz

# 20211120: kernel_vmount function removed
OLD_FILES+=usr/share/man/man9/kernel_vmount.9.gz

# 20211115: vm_page busy functions removed
OLD_FILES+=usr/share/man/man9/vm_page_sbusy.9.gz
OLD_FILES+=usr/share/man/man9/vm_page_xbusy.9.gz
OLD_FILES+=usr/share/man/man9/vm_page_sleep_if_busy.9.gz

# 20211113: new clang import which bumps version from 12.0.1 to 13.0.0
OLD_FILES+=usr/lib/clang/12.0.1/include/cuda_wrappers/algorithm
OLD_FILES+=usr/lib/clang/12.0.1/include/cuda_wrappers/complex
OLD_FILES+=usr/lib/clang/12.0.1/include/cuda_wrappers/new
OLD_DIRS+=usr/lib/clang/12.0.1/include/cuda_wrappers
OLD_FILES+=usr/lib/clang/12.0.1/include/fuzzer/FuzzedDataProvider.h
OLD_DIRS+=usr/lib/clang/12.0.1/include/fuzzer
OLD_FILES+=usr/lib/clang/12.0.1/include/openmp_wrappers/__clang_openmp_device_functions.h
OLD_FILES+=usr/lib/clang/12.0.1/include/openmp_wrappers/cmath
OLD_FILES+=usr/lib/clang/12.0.1/include/openmp_wrappers/complex
OLD_FILES+=usr/lib/clang/12.0.1/include/openmp_wrappers/complex.h
OLD_FILES+=usr/lib/clang/12.0.1/include/openmp_wrappers/complex_cmath.h
OLD_FILES+=usr/lib/clang/12.0.1/include/openmp_wrappers/math.h
OLD_FILES+=usr/lib/clang/12.0.1/include/openmp_wrappers/new
OLD_DIRS+=usr/lib/clang/12.0.1/include/openmp_wrappers
OLD_FILES+=usr/lib/clang/12.0.1/include/ppc_wrappers/emmintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/ppc_wrappers/mm_malloc.h
OLD_FILES+=usr/lib/clang/12.0.1/include/ppc_wrappers/mmintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/ppc_wrappers/pmmintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/ppc_wrappers/smmintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/ppc_wrappers/tmmintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/ppc_wrappers/xmmintrin.h
OLD_DIRS+=usr/lib/clang/12.0.1/include/ppc_wrappers
OLD_FILES+=usr/lib/clang/12.0.1/include/profile/InstrProfData.inc
OLD_DIRS+=usr/lib/clang/12.0.1/include/profile
OLD_FILES+=usr/lib/clang/12.0.1/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/12.0.1/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/12.0.1/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/12.0.1/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/12.0.1/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/12.0.1/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/12.0.1/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/12.0.1/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/12.0.1/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/12.0.1/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/12.0.1/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/12.0.1/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/12.0.1/include/sanitizer/tsan_interface_atomic.h
OLD_FILES+=usr/lib/clang/12.0.1/include/sanitizer/ubsan_interface.h
OLD_DIRS+=usr/lib/clang/12.0.1/include/sanitizer
OLD_FILES+=usr/lib/clang/12.0.1/include/xray/xray_interface.h
OLD_FILES+=usr/lib/clang/12.0.1/include/xray/xray_log_interface.h
OLD_FILES+=usr/lib/clang/12.0.1/include/xray/xray_records.h
OLD_DIRS+=usr/lib/clang/12.0.1/include/xray
OLD_FILES+=usr/lib/clang/12.0.1/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/12.0.1/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/12.0.1/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/12.0.1/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/12.0.1/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/12.0.1/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/12.0.1/include/__clang_cuda_math.h
OLD_FILES+=usr/lib/clang/12.0.1/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/12.0.1/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/12.0.1/include/__clang_hip_cmath.h
OLD_FILES+=usr/lib/clang/12.0.1/include/__clang_hip_libdevice_declares.h
OLD_FILES+=usr/lib/clang/12.0.1/include/__clang_hip_math.h
OLD_FILES+=usr/lib/clang/12.0.1/include/__clang_hip_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/12.0.1/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/12.0.1/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/12.0.1/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/12.0.1/include/adxintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/altivec.h
OLD_FILES+=usr/lib/clang/12.0.1/include/ammintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/amxintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/arm64intr.h
OLD_FILES+=usr/lib/clang/12.0.1/include/arm_acle.h
OLD_FILES+=usr/lib/clang/12.0.1/include/arm_bf16.h
OLD_FILES+=usr/lib/clang/12.0.1/include/arm_cde.h
OLD_FILES+=usr/lib/clang/12.0.1/include/arm_cmse.h
OLD_FILES+=usr/lib/clang/12.0.1/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/12.0.1/include/arm_mve.h
OLD_FILES+=usr/lib/clang/12.0.1/include/arm_neon.h
OLD_FILES+=usr/lib/clang/12.0.1/include/arm_sve.h
OLD_FILES+=usr/lib/clang/12.0.1/include/armintr.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512bf16intrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512vlbf16intrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512vlvp2intersectintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512vp2intersectintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avxintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/avxvnniintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/cet.h
OLD_FILES+=usr/lib/clang/12.0.1/include/cetintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/cpuid.h
OLD_FILES+=usr/lib/clang/12.0.1/include/emmintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/enqcmdintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/float.h
OLD_FILES+=usr/lib/clang/12.0.1/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/hresetintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/htmintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/immintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/intrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/inttypes.h
OLD_FILES+=usr/lib/clang/12.0.1/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/iso646.h
OLD_FILES+=usr/lib/clang/12.0.1/include/keylockerintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/limits.h
OLD_FILES+=usr/lib/clang/12.0.1/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/12.0.1/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/12.0.1/include/mmintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/module.modulemap
OLD_FILES+=usr/lib/clang/12.0.1/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/msa.h
OLD_FILES+=usr/lib/clang/12.0.1/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/omp-tools.h
OLD_FILES+=usr/lib/clang/12.0.1/include/omp.h
OLD_FILES+=usr/lib/clang/12.0.1/include/ompt.h
OLD_FILES+=usr/lib/clang/12.0.1/include/opencl-c-base.h
OLD_FILES+=usr/lib/clang/12.0.1/include/opencl-c.h
OLD_FILES+=usr/lib/clang/12.0.1/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/s390intrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/serializeintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/shaintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/smmintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/stdalign.h
OLD_FILES+=usr/lib/clang/12.0.1/include/stdarg.h
OLD_FILES+=usr/lib/clang/12.0.1/include/stdatomic.h
OLD_FILES+=usr/lib/clang/12.0.1/include/stdbool.h
OLD_FILES+=usr/lib/clang/12.0.1/include/stddef.h
OLD_FILES+=usr/lib/clang/12.0.1/include/stdint.h
OLD_FILES+=usr/lib/clang/12.0.1/include/stdnoreturn.h
OLD_FILES+=usr/lib/clang/12.0.1/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/tgmath.h
OLD_FILES+=usr/lib/clang/12.0.1/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/tsxldtrkintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/uintrintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/unwind.h
OLD_FILES+=usr/lib/clang/12.0.1/include/vadefs.h
OLD_FILES+=usr/lib/clang/12.0.1/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/varargs.h
OLD_FILES+=usr/lib/clang/12.0.1/include/vecintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/wasm_simd128.h
OLD_FILES+=usr/lib/clang/12.0.1/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/x86gprintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/x86intrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/xopintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/12.0.1/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/12.0.1/include
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan-aarch64.so
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan-arm.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan-arm.so
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan-armhf.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan-armhf.so
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan-preinit-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan-preinit-arm.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan-preinit-armhf.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan_cxx-arm.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan_cxx-armhf.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.cfi-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.cfi-arm.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.cfi-armhf.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.cfi-i386.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.cfi-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.cfi_diag-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.cfi_diag-arm.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.cfi_diag-armhf.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.cfi_diag-i386.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.cfi_diag-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.dd-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.dd-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.fuzzer-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.fuzzer-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.fuzzer_no_main-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.fuzzer_no_main-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.msan-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.msan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.profile-powerpc.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.profile-powerpc64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.profile-powerpc64le.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.safestack-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.stats-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.stats-arm.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.stats-armhf.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.stats_client-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.stats_client-arm.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.stats_client-armhf.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.tsan-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.tsan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.ubsan_minimal-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.ubsan_minimal-arm.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.ubsan_minimal-armhf.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.ubsan_standalone-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.ubsan_standalone-arm.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.ubsan_standalone-armhf.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-arm.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-armhf.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.xray-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.xray-arm.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.xray-armhf.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.xray-basic-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.xray-basic-arm.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.xray-basic-armhf.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.xray-basic-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.xray-fdr-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.xray-fdr-arm.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.xray-fdr-armhf.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.xray-fdr-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.xray-profiling-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.xray-profiling-arm.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.xray-profiling-armhf.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.xray-profiling-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.1/lib/freebsd/libclang_rt.xray-x86_64.a
OLD_DIRS+=usr/lib/clang/12.0.1/lib/freebsd
OLD_DIRS+=usr/lib/clang/12.0.1/lib
OLD_DIRS+=usr/lib/clang/12.0.1

# 20211113: new libc++ import which bumps version from 12.0.1 to 13.0.0
OLD_FILES+=usr/include/c++/v1/__functional_03
OLD_FILES+=usr/include/c++/v1/__functional_base_03
OLD_FILES+=usr/include/c++/v1/__memory/base.h
OLD_FILES+=usr/include/c++/v1/__memory/utilities.h
OLD_FILES+=usr/include/c++/v1/__sso_allocator
OLD_FILES+=usr/include/c++/v1/tr1/__availability
OLD_FILES+=usr/include/c++/v1/tr1/__bit_reference
OLD_FILES+=usr/include/c++/v1/tr1/__bits
OLD_FILES+=usr/include/c++/v1/tr1/__bsd_locale_defaults.h
OLD_FILES+=usr/include/c++/v1/tr1/__bsd_locale_fallbacks.h
OLD_FILES+=usr/include/c++/v1/tr1/__config
OLD_FILES+=usr/include/c++/v1/tr1/__debug
OLD_FILES+=usr/include/c++/v1/tr1/__errc
OLD_FILES+=usr/include/c++/v1/tr1/__functional_03
OLD_FILES+=usr/include/c++/v1/tr1/__functional_base
OLD_FILES+=usr/include/c++/v1/tr1/__functional_base_03
OLD_FILES+=usr/include/c++/v1/tr1/__hash_table
OLD_FILES+=usr/include/c++/v1/tr1/__libcpp_version
OLD_FILES+=usr/include/c++/v1/tr1/__locale
OLD_FILES+=usr/include/c++/v1/tr1/__mutex_base
OLD_FILES+=usr/include/c++/v1/tr1/__node_handle
OLD_FILES+=usr/include/c++/v1/tr1/__nullptr
OLD_FILES+=usr/include/c++/v1/tr1/__split_buffer
OLD_FILES+=usr/include/c++/v1/tr1/__sso_allocator
OLD_FILES+=usr/include/c++/v1/tr1/__std_stream
OLD_FILES+=usr/include/c++/v1/tr1/__string
OLD_FILES+=usr/include/c++/v1/tr1/__threading_support
OLD_FILES+=usr/include/c++/v1/tr1/__tree
OLD_FILES+=usr/include/c++/v1/tr1/__tuple
OLD_FILES+=usr/include/c++/v1/tr1/__undef_macros
OLD_FILES+=usr/include/c++/v1/tr1/algorithm
OLD_FILES+=usr/include/c++/v1/tr1/any
OLD_FILES+=usr/include/c++/v1/tr1/array
OLD_FILES+=usr/include/c++/v1/tr1/atomic
OLD_FILES+=usr/include/c++/v1/tr1/barrier
OLD_FILES+=usr/include/c++/v1/tr1/bit
OLD_FILES+=usr/include/c++/v1/tr1/bitset
OLD_FILES+=usr/include/c++/v1/tr1/cassert
OLD_FILES+=usr/include/c++/v1/tr1/ccomplex
OLD_FILES+=usr/include/c++/v1/tr1/cctype
OLD_FILES+=usr/include/c++/v1/tr1/cerrno
OLD_FILES+=usr/include/c++/v1/tr1/cfenv
OLD_FILES+=usr/include/c++/v1/tr1/cfloat
OLD_FILES+=usr/include/c++/v1/tr1/charconv
OLD_FILES+=usr/include/c++/v1/tr1/chrono
OLD_FILES+=usr/include/c++/v1/tr1/cinttypes
OLD_FILES+=usr/include/c++/v1/tr1/ciso646
OLD_FILES+=usr/include/c++/v1/tr1/climits
OLD_FILES+=usr/include/c++/v1/tr1/clocale
OLD_FILES+=usr/include/c++/v1/tr1/cmath
OLD_FILES+=usr/include/c++/v1/tr1/codecvt
OLD_FILES+=usr/include/c++/v1/tr1/compare
OLD_FILES+=usr/include/c++/v1/tr1/complex
OLD_FILES+=usr/include/c++/v1/tr1/complex.h
OLD_FILES+=usr/include/c++/v1/tr1/concepts
OLD_FILES+=usr/include/c++/v1/tr1/condition_variable
OLD_FILES+=usr/include/c++/v1/tr1/csetjmp
OLD_FILES+=usr/include/c++/v1/tr1/csignal
OLD_FILES+=usr/include/c++/v1/tr1/cstdarg
OLD_FILES+=usr/include/c++/v1/tr1/cstdbool
OLD_FILES+=usr/include/c++/v1/tr1/cstddef
OLD_FILES+=usr/include/c++/v1/tr1/cstdint
OLD_FILES+=usr/include/c++/v1/tr1/cstdio
OLD_FILES+=usr/include/c++/v1/tr1/cstdlib
OLD_FILES+=usr/include/c++/v1/tr1/cstring
OLD_FILES+=usr/include/c++/v1/tr1/ctgmath
OLD_FILES+=usr/include/c++/v1/tr1/ctime
OLD_FILES+=usr/include/c++/v1/tr1/ctype.h
OLD_FILES+=usr/include/c++/v1/tr1/cwchar
OLD_FILES+=usr/include/c++/v1/tr1/cwctype
OLD_FILES+=usr/include/c++/v1/tr1/deque
OLD_FILES+=usr/include/c++/v1/tr1/errno.h
OLD_FILES+=usr/include/c++/v1/tr1/exception
OLD_FILES+=usr/include/c++/v1/tr1/execution
OLD_FILES+=usr/include/c++/v1/tr1/fenv.h
OLD_FILES+=usr/include/c++/v1/tr1/filesystem
OLD_FILES+=usr/include/c++/v1/tr1/float.h
OLD_FILES+=usr/include/c++/v1/tr1/forward_list
OLD_FILES+=usr/include/c++/v1/tr1/fstream
OLD_FILES+=usr/include/c++/v1/tr1/functional
OLD_FILES+=usr/include/c++/v1/tr1/future
OLD_FILES+=usr/include/c++/v1/tr1/initializer_list
OLD_FILES+=usr/include/c++/v1/tr1/inttypes.h
OLD_FILES+=usr/include/c++/v1/tr1/iomanip
OLD_FILES+=usr/include/c++/v1/tr1/ios
OLD_FILES+=usr/include/c++/v1/tr1/iosfwd
OLD_FILES+=usr/include/c++/v1/tr1/iostream
OLD_FILES+=usr/include/c++/v1/tr1/istream
OLD_FILES+=usr/include/c++/v1/tr1/iterator
OLD_FILES+=usr/include/c++/v1/tr1/latch
OLD_FILES+=usr/include/c++/v1/tr1/limits
OLD_FILES+=usr/include/c++/v1/tr1/limits.h
OLD_FILES+=usr/include/c++/v1/tr1/list
OLD_FILES+=usr/include/c++/v1/tr1/locale
OLD_FILES+=usr/include/c++/v1/tr1/locale.h
OLD_FILES+=usr/include/c++/v1/tr1/map
OLD_FILES+=usr/include/c++/v1/tr1/math.h
OLD_FILES+=usr/include/c++/v1/tr1/memory
OLD_FILES+=usr/include/c++/v1/tr1/mutex
OLD_FILES+=usr/include/c++/v1/tr1/new
OLD_FILES+=usr/include/c++/v1/tr1/numbers
OLD_FILES+=usr/include/c++/v1/tr1/numeric
OLD_FILES+=usr/include/c++/v1/tr1/optional
OLD_FILES+=usr/include/c++/v1/tr1/ostream
OLD_FILES+=usr/include/c++/v1/tr1/queue
OLD_FILES+=usr/include/c++/v1/tr1/random
OLD_FILES+=usr/include/c++/v1/tr1/ratio
OLD_FILES+=usr/include/c++/v1/tr1/regex
OLD_FILES+=usr/include/c++/v1/tr1/scoped_allocator
OLD_FILES+=usr/include/c++/v1/tr1/semaphore
OLD_FILES+=usr/include/c++/v1/tr1/set
OLD_FILES+=usr/include/c++/v1/tr1/setjmp.h
OLD_FILES+=usr/include/c++/v1/tr1/shared_mutex
OLD_FILES+=usr/include/c++/v1/tr1/span
OLD_FILES+=usr/include/c++/v1/tr1/sstream
OLD_FILES+=usr/include/c++/v1/tr1/stack
OLD_FILES+=usr/include/c++/v1/tr1/stdbool.h
OLD_FILES+=usr/include/c++/v1/tr1/stddef.h
OLD_FILES+=usr/include/c++/v1/tr1/stdexcept
OLD_FILES+=usr/include/c++/v1/tr1/stdint.h
OLD_FILES+=usr/include/c++/v1/tr1/stdio.h
OLD_FILES+=usr/include/c++/v1/tr1/stdlib.h
OLD_FILES+=usr/include/c++/v1/tr1/streambuf
OLD_FILES+=usr/include/c++/v1/tr1/string
OLD_FILES+=usr/include/c++/v1/tr1/string.h
OLD_FILES+=usr/include/c++/v1/tr1/string_view
OLD_FILES+=usr/include/c++/v1/tr1/strstream
OLD_FILES+=usr/include/c++/v1/tr1/system_error
OLD_FILES+=usr/include/c++/v1/tr1/tgmath.h
OLD_FILES+=usr/include/c++/v1/tr1/thread
OLD_FILES+=usr/include/c++/v1/tr1/tuple
OLD_FILES+=usr/include/c++/v1/tr1/type_traits
OLD_FILES+=usr/include/c++/v1/tr1/typeindex
OLD_FILES+=usr/include/c++/v1/tr1/typeinfo
OLD_FILES+=usr/include/c++/v1/tr1/unordered_map
OLD_FILES+=usr/include/c++/v1/tr1/unordered_set
OLD_FILES+=usr/include/c++/v1/tr1/utility
OLD_FILES+=usr/include/c++/v1/tr1/valarray
OLD_FILES+=usr/include/c++/v1/tr1/variant
OLD_FILES+=usr/include/c++/v1/tr1/vector
OLD_FILES+=usr/include/c++/v1/tr1/version
OLD_FILES+=usr/include/c++/v1/tr1/wchar.h
OLD_FILES+=usr/include/c++/v1/tr1/wctype.h
OLD_DIRS+=usr/include/c++/v1/tr1

# 20211027: libdialog shlib bumped to version 10 for dialog 1.3
OLD_LIBS+=usr/lib/libdialog.so.9
OLD_LIBS+=usr/lib/libdpv.so.2

# 20211026: retire obsolete iscsi initiator
OLD_FILES+=sbin/iscontrol
OLD_FILES+=usr/share/man/man4/iscsi_initiator.4.gz
OLD_FILES+=usr/share/man/man8/iscontrol.8.gz

# 20211022
OLD_FILES+=etc/rc.d/sppp
OLD_FILES+=rescue/spppcontrol
OLD_FILES+=sbin/spppcontrol
.if ${TARGET_ARCH} == "i386"
OLD_FILES+=usr/include/machine/cserial.h
.endif
OLD_FILES+=usr/include/net/if_sppp.h
OLD_FILES+=usr/include/netgraph/ng_sppp.h
OLD_FILES+=usr/share/man/man4/ng_sppp.4.gz
OLD_FILES+=usr/share/man/man4/sppp.4.gz
OLD_FILES+=usr/share/man/man8/spppcontrol.8.gz

# 20211004: Removed sparc64 tests for lastcomm/sa
OLD_FILES+=usr/tests/usr.bin/lastcomm/v1-sparc64-acct.in
OLD_FILES+=usr/tests/usr.bin/lastcomm/v1-sparc64.out
OLD_FILES+=usr/tests/usr.bin/lastcomm/v2-sparc64-acct.in
OLD_FILES+=usr/tests/usr.bin/lastcomm/v2-sparc64.out
OLD_FILES+=usr/tests/usr.sbin/sa/v1-sparc64-sav.in
OLD_FILES+=usr/tests/usr.sbin/sa/v1-sparc64-sav.out
OLD_FILES+=usr/tests/usr.sbin/sa/v1-sparc64-u.out
OLD_FILES+=usr/tests/usr.sbin/sa/v1-sparc64-usr.in
OLD_FILES+=usr/tests/usr.sbin/sa/v1-sparc64-usr.out
OLD_FILES+=usr/tests/usr.sbin/sa/v2-sparc64-sav.in
OLD_FILES+=usr/tests/usr.sbin/sa/v2-sparc64-u.out
OLD_FILES+=usr/tests/usr.sbin/sa/v2-sparc64-usr.in

# 20210929:
OLD_FILES+=usr/sbin/hcseriald
OLD_FILES+=usr/share/man/man8/hcseriald.8.gz

# 20210929: Remove ng_h4
OLD_FILES+=usr/include/netgraph/bluetooth/include/ng_h4.h
OLD_FILES+=usr/share/man/man4/ng_h4.4.gz

# 20210923: rename boot(9) to kern_reboot(9)
OLD_FILES+=usr/share/man/man9/boot.9.gz

# 20210921: remove cloudabi
OLD_FILES+=usr/share/man/man4/cloudabi.4.gz
OLD_FILES+=usr/share/man/man4/cloudabi32.4.gz
OLD_FILES+=usr/share/man/man4/cloudabi64.4.gz

# 20210906: stop installing {llvm,clang,lldb}-tblgen
OLD_FILES+=usr/bin/llvm-tblgen
OLD_FILES+=usr/bin/clang-tblgen
OLD_FILES+=usr/bin/lldb-tblgen
OLD_FILES+=usr/share/man/man1/llvm-tblgen.1.gz

# 20210810: remove Pentium-related man pages and references
OLD_FILES+=usr/share/man/man3/pmc.p4.3.gz
OLD_FILES+=usr/share/man/man3/pmc.p5.3.gz
OLD_FILES+=usr/share/man/man3/pmc.p6.3.gz

# 20210805: C.UTF-8 installed to the wrong location
OLD_FILES+=usr/share/C.UTF-8.LC_CTYPE

# 20210619: new clang import which bumps version from 12.0.0 to 12.0.1
OLD_FILES+=usr/lib/clang/12.0.0/include/cuda_wrappers/algorithm
OLD_FILES+=usr/lib/clang/12.0.0/include/cuda_wrappers/complex
OLD_FILES+=usr/lib/clang/12.0.0/include/cuda_wrappers/new
OLD_DIRS+=usr/lib/clang/12.0.0/include/cuda_wrappers
OLD_FILES+=usr/lib/clang/12.0.0/include/fuzzer/FuzzedDataProvider.h
OLD_DIRS+=usr/lib/clang/12.0.0/include/fuzzer
OLD_FILES+=usr/lib/clang/12.0.0/include/openmp_wrappers/__clang_openmp_device_functions.h
OLD_FILES+=usr/lib/clang/12.0.0/include/openmp_wrappers/cmath
OLD_FILES+=usr/lib/clang/12.0.0/include/openmp_wrappers/complex
OLD_FILES+=usr/lib/clang/12.0.0/include/openmp_wrappers/complex.h
OLD_FILES+=usr/lib/clang/12.0.0/include/openmp_wrappers/complex_cmath.h
OLD_FILES+=usr/lib/clang/12.0.0/include/openmp_wrappers/math.h
OLD_FILES+=usr/lib/clang/12.0.0/include/openmp_wrappers/new
OLD_DIRS+=usr/lib/clang/12.0.0/include/openmp_wrappers
OLD_FILES+=usr/lib/clang/12.0.0/include/ppc_wrappers/emmintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/ppc_wrappers/mm_malloc.h
OLD_FILES+=usr/lib/clang/12.0.0/include/ppc_wrappers/mmintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/ppc_wrappers/pmmintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/ppc_wrappers/smmintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/ppc_wrappers/tmmintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/ppc_wrappers/xmmintrin.h
OLD_DIRS+=usr/lib/clang/12.0.0/include/ppc_wrappers
OLD_FILES+=usr/lib/clang/12.0.0/include/profile/InstrProfData.inc
OLD_DIRS+=usr/lib/clang/12.0.0/include/profile
OLD_FILES+=usr/lib/clang/12.0.0/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/12.0.0/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/12.0.0/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/12.0.0/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/12.0.0/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/12.0.0/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/12.0.0/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/12.0.0/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/12.0.0/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/12.0.0/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/12.0.0/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/12.0.0/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/12.0.0/include/sanitizer/tsan_interface_atomic.h
OLD_FILES+=usr/lib/clang/12.0.0/include/sanitizer/ubsan_interface.h
OLD_DIRS+=usr/lib/clang/12.0.0/include/sanitizer
OLD_FILES+=usr/lib/clang/12.0.0/include/xray/xray_interface.h
OLD_FILES+=usr/lib/clang/12.0.0/include/xray/xray_log_interface.h
OLD_FILES+=usr/lib/clang/12.0.0/include/xray/xray_records.h
OLD_DIRS+=usr/lib/clang/12.0.0/include/xray
OLD_FILES+=usr/lib/clang/12.0.0/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/12.0.0/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/12.0.0/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/12.0.0/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/12.0.0/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/12.0.0/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/12.0.0/include/__clang_cuda_math.h
OLD_FILES+=usr/lib/clang/12.0.0/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/12.0.0/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/12.0.0/include/__clang_hip_cmath.h
OLD_FILES+=usr/lib/clang/12.0.0/include/__clang_hip_libdevice_declares.h
OLD_FILES+=usr/lib/clang/12.0.0/include/__clang_hip_math.h
OLD_FILES+=usr/lib/clang/12.0.0/include/__clang_hip_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/12.0.0/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/12.0.0/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/12.0.0/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/12.0.0/include/adxintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/altivec.h
OLD_FILES+=usr/lib/clang/12.0.0/include/ammintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/amxintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/arm64intr.h
OLD_FILES+=usr/lib/clang/12.0.0/include/arm_acle.h
OLD_FILES+=usr/lib/clang/12.0.0/include/arm_bf16.h
OLD_FILES+=usr/lib/clang/12.0.0/include/arm_cde.h
OLD_FILES+=usr/lib/clang/12.0.0/include/arm_cmse.h
OLD_FILES+=usr/lib/clang/12.0.0/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/12.0.0/include/arm_mve.h
OLD_FILES+=usr/lib/clang/12.0.0/include/arm_neon.h
OLD_FILES+=usr/lib/clang/12.0.0/include/arm_sve.h
OLD_FILES+=usr/lib/clang/12.0.0/include/armintr.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512bf16intrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512vlbf16intrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512vlvp2intersectintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512vp2intersectintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avxintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/avxvnniintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/cet.h
OLD_FILES+=usr/lib/clang/12.0.0/include/cetintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/cpuid.h
OLD_FILES+=usr/lib/clang/12.0.0/include/emmintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/enqcmdintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/float.h
OLD_FILES+=usr/lib/clang/12.0.0/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/hresetintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/htmintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/immintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/intrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/inttypes.h
OLD_FILES+=usr/lib/clang/12.0.0/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/iso646.h
OLD_FILES+=usr/lib/clang/12.0.0/include/keylockerintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/limits.h
OLD_FILES+=usr/lib/clang/12.0.0/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/12.0.0/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/12.0.0/include/mmintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/module.modulemap
OLD_FILES+=usr/lib/clang/12.0.0/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/msa.h
OLD_FILES+=usr/lib/clang/12.0.0/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/omp-tools.h
OLD_FILES+=usr/lib/clang/12.0.0/include/omp.h
OLD_FILES+=usr/lib/clang/12.0.0/include/ompt.h
OLD_FILES+=usr/lib/clang/12.0.0/include/opencl-c-base.h
OLD_FILES+=usr/lib/clang/12.0.0/include/opencl-c.h
OLD_FILES+=usr/lib/clang/12.0.0/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/s390intrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/serializeintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/shaintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/smmintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/stdalign.h
OLD_FILES+=usr/lib/clang/12.0.0/include/stdarg.h
OLD_FILES+=usr/lib/clang/12.0.0/include/stdatomic.h
OLD_FILES+=usr/lib/clang/12.0.0/include/stdbool.h
OLD_FILES+=usr/lib/clang/12.0.0/include/stddef.h
OLD_FILES+=usr/lib/clang/12.0.0/include/stdint.h
OLD_FILES+=usr/lib/clang/12.0.0/include/stdnoreturn.h
OLD_FILES+=usr/lib/clang/12.0.0/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/tgmath.h
OLD_FILES+=usr/lib/clang/12.0.0/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/tsxldtrkintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/uintrintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/unwind.h
OLD_FILES+=usr/lib/clang/12.0.0/include/vadefs.h
OLD_FILES+=usr/lib/clang/12.0.0/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/varargs.h
OLD_FILES+=usr/lib/clang/12.0.0/include/vecintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/wasm_simd128.h
OLD_FILES+=usr/lib/clang/12.0.0/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/x86gprintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/x86intrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/xopintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/12.0.0/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/12.0.0/include
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan-aarch64.so
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan-arm.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan-arm.so
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan-armhf.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan-armhf.so
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan-preinit-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan-preinit-arm.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan-preinit-armhf.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan_cxx-arm.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan_cxx-armhf.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.cfi-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.cfi-arm.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.cfi-armhf.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.cfi-i386.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.cfi-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.cfi_diag-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.cfi_diag-arm.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.cfi_diag-armhf.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.cfi_diag-i386.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.cfi_diag-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.dd-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.dd-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.fuzzer-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.fuzzer-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.fuzzer_no_main-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.fuzzer_no_main-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.msan-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.msan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.profile-powerpc.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.profile-powerpc64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.profile-powerpc64le.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.safestack-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.stats-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.stats-arm.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.stats-armhf.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.stats_client-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.stats_client-arm.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.stats_client-armhf.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.tsan-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.tsan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.ubsan_minimal-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.ubsan_minimal-arm.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.ubsan_minimal-armhf.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.ubsan_standalone-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.ubsan_standalone-arm.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.ubsan_standalone-armhf.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-arm.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-armhf.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.xray-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.xray-arm.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.xray-armhf.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.xray-basic-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.xray-basic-arm.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.xray-basic-armhf.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.xray-basic-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.xray-fdr-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.xray-fdr-arm.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.xray-fdr-armhf.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.xray-fdr-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.xray-profiling-aarch64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.xray-profiling-arm.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.xray-profiling-armhf.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.xray-profiling-x86_64.a
OLD_FILES+=usr/lib/clang/12.0.0/lib/freebsd/libclang_rt.xray-x86_64.a
OLD_DIRS+=usr/lib/clang/12.0.0/lib/freebsd
OLD_DIRS+=usr/lib/clang/12.0.0/lib
OLD_DIRS+=usr/lib/clang/12.0.0

# 20210616: Remove crypto_cursor_seg{base,len}
OLD_FILES+=usr/share/man/man9/crypto_cursor_segbase.9.gz
OLD_FILES+=usr/share/man/man9/crypto_cursor_seglen.9.gz

# 20210618: rename of usr/share/certs/blacklisted
OLD_FILES+=usr/share/certs/blacklisted/AddTrust_External_Root.pem
OLD_FILES+=usr/share/certs/blacklisted/AddTrust_Low-Value_Services_Root.pem
OLD_FILES+=usr/share/certs/blacklisted/Camerfirma_Chambers_of_Commerce_Root.pem
OLD_FILES+=usr/share/certs/blacklisted/Camerfirma_Global_Chambersign_Root.pem
OLD_FILES+=usr/share/certs/blacklisted/Certum_Root_CA.pem
OLD_FILES+=usr/share/certs/blacklisted/Chambers_of_Commerce_Root_-_2008.pem
OLD_FILES+=usr/share/certs/blacklisted/D-TRUST_Root_CA_3_2013.pem
OLD_FILES+=usr/share/certs/blacklisted/EC-ACC.pem
OLD_FILES+=usr/share/certs/blacklisted/EE_Certification_Centre_Root_CA.pem
OLD_FILES+=usr/share/certs/blacklisted/GeoTrust_Global_CA.pem
OLD_FILES+=usr/share/certs/blacklisted/GeoTrust_Primary_Certification_Authority_-_G2.pem
OLD_FILES+=usr/share/certs/blacklisted/GeoTrust_Primary_Certification_Authority_-_G3.pem
OLD_FILES+=usr/share/certs/blacklisted/GeoTrust_Primary_Certification_Authority.pem
OLD_FILES+=usr/share/certs/blacklisted/GeoTrust_Universal_CA_2.pem
OLD_FILES+=usr/share/certs/blacklisted/GeoTrust_Universal_CA.pem
OLD_FILES+=usr/share/certs/blacklisted/Global_Chambersign_Root_-_2008.pem
OLD_FILES+=usr/share/certs/blacklisted/LuxTrust_Global_Root_2.pem
OLD_FILES+=usr/share/certs/blacklisted/OISTE_WISeKey_Global_Root_GA_CA.pem
OLD_FILES+=usr/share/certs/blacklisted/QuoVadis_Root_CA.pem
OLD_FILES+=usr/share/certs/blacklisted/Sonera_Class_2_Root_CA.pem
OLD_FILES+=usr/share/certs/blacklisted/Staat_der_Nederlanden_Root_CA_-_G2.pem
OLD_FILES+=usr/share/certs/blacklisted/Staat_der_Nederlanden_Root_CA_-_G3.pem
OLD_FILES+=usr/share/certs/blacklisted/SwissSign_Platinum_CA_-_G2.pem
OLD_FILES+=usr/share/certs/blacklisted/Symantec_Class_1_Public_Primary_Certification_Authority_-_G4.pem
OLD_FILES+=usr/share/certs/blacklisted/Symantec_Class_1_Public_Primary_Certification_Authority_-_G6.pem
OLD_FILES+=usr/share/certs/blacklisted/Symantec_Class_2_Public_Primary_Certification_Authority_-_G4.pem
OLD_FILES+=usr/share/certs/blacklisted/Symantec_Class_2_Public_Primary_Certification_Authority_-_G6.pem
OLD_FILES+=usr/share/certs/blacklisted/Taiwan_GRCA.pem
OLD_FILES+=usr/share/certs/blacklisted/thawte_Primary_Root_CA_-_G2.pem
OLD_FILES+=usr/share/certs/blacklisted/thawte_Primary_Root_CA_-_G3.pem
OLD_FILES+=usr/share/certs/blacklisted/thawte_Primary_Root_CA.pem
OLD_FILES+=usr/share/certs/blacklisted/Trustis_FPS_Root_CA.pem
OLD_FILES+=usr/share/certs/blacklisted/Verisign_Class_1_Public_Primary_Certification_Authority_-_G3.pem
OLD_FILES+=usr/share/certs/blacklisted/Verisign_Class_2_Public_Primary_Certification_Authority_-_G3.pem
OLD_FILES+=usr/share/certs/blacklisted/Verisign_Class_3_Public_Primary_Certification_Authority_-_G3.pem
OLD_FILES+=usr/share/certs/blacklisted/VeriSign_Class_3_Public_Primary_Certification_Authority_-_G4.pem
OLD_FILES+=usr/share/certs/blacklisted/VeriSign_Class_3_Public_Primary_Certification_Authority_-_G5.pem
OLD_FILES+=usr/share/certs/blacklisted/VeriSign_Universal_Root_Certification_Authority.pem
OLD_DIRS+=usr/share/certs/blacklisted

# 20210613: new clang import which bumps version from 11.0.1 to 12.0.0
OLD_FILES+=usr/lib/clang/11.0.1/include/cuda_wrappers/algorithm
OLD_FILES+=usr/lib/clang/11.0.1/include/cuda_wrappers/complex
OLD_FILES+=usr/lib/clang/11.0.1/include/cuda_wrappers/new
OLD_DIRS+=usr/lib/clang/11.0.1/include/cuda_wrappers
OLD_FILES+=usr/lib/clang/11.0.1/include/fuzzer/FuzzedDataProvider.h
OLD_DIRS+=usr/lib/clang/11.0.1/include/fuzzer
OLD_FILES+=usr/lib/clang/11.0.1/include/openmp_wrappers/__clang_openmp_device_functions.h
OLD_FILES+=usr/lib/clang/11.0.1/include/openmp_wrappers/cmath
OLD_FILES+=usr/lib/clang/11.0.1/include/openmp_wrappers/complex
OLD_FILES+=usr/lib/clang/11.0.1/include/openmp_wrappers/complex.h
OLD_FILES+=usr/lib/clang/11.0.1/include/openmp_wrappers/math.h
OLD_FILES+=usr/lib/clang/11.0.1/include/openmp_wrappers/new
OLD_DIRS+=usr/lib/clang/11.0.1/include/openmp_wrappers
OLD_FILES+=usr/lib/clang/11.0.1/include/ppc_wrappers/emmintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/ppc_wrappers/mm_malloc.h
OLD_FILES+=usr/lib/clang/11.0.1/include/ppc_wrappers/mmintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/ppc_wrappers/pmmintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/ppc_wrappers/smmintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/ppc_wrappers/tmmintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/ppc_wrappers/xmmintrin.h
OLD_DIRS+=usr/lib/clang/11.0.1/include/ppc_wrappers
OLD_FILES+=usr/lib/clang/11.0.1/include/profile/InstrProfData.inc
OLD_DIRS+=usr/lib/clang/11.0.1/include/profile
OLD_FILES+=usr/lib/clang/11.0.1/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/11.0.1/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/11.0.1/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/11.0.1/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/11.0.1/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/11.0.1/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/11.0.1/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/11.0.1/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/11.0.1/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/11.0.1/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/11.0.1/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/11.0.1/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/11.0.1/include/sanitizer/tsan_interface_atomic.h
OLD_FILES+=usr/lib/clang/11.0.1/include/sanitizer/ubsan_interface.h
OLD_DIRS+=usr/lib/clang/11.0.1/include/sanitizer
OLD_FILES+=usr/lib/clang/11.0.1/include/xray/xray_interface.h
OLD_FILES+=usr/lib/clang/11.0.1/include/xray/xray_log_interface.h
OLD_FILES+=usr/lib/clang/11.0.1/include/xray/xray_records.h
OLD_DIRS+=usr/lib/clang/11.0.1/include/xray
OLD_FILES+=usr/lib/clang/11.0.1/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/11.0.1/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/11.0.1/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/11.0.1/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/11.0.1/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/11.0.1/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/11.0.1/include/__clang_cuda_math.h
OLD_FILES+=usr/lib/clang/11.0.1/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/11.0.1/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/11.0.1/include/__clang_hip_libdevice_declares.h
OLD_FILES+=usr/lib/clang/11.0.1/include/__clang_hip_math.h
OLD_FILES+=usr/lib/clang/11.0.1/include/__clang_hip_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/11.0.1/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/11.0.1/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/11.0.1/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/11.0.1/include/adxintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/altivec.h
OLD_FILES+=usr/lib/clang/11.0.1/include/ammintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/amxintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/arm64intr.h
OLD_FILES+=usr/lib/clang/11.0.1/include/arm_acle.h
OLD_FILES+=usr/lib/clang/11.0.1/include/arm_bf16.h
OLD_FILES+=usr/lib/clang/11.0.1/include/arm_cde.h
OLD_FILES+=usr/lib/clang/11.0.1/include/arm_cmse.h
OLD_FILES+=usr/lib/clang/11.0.1/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/11.0.1/include/arm_mve.h
OLD_FILES+=usr/lib/clang/11.0.1/include/arm_neon.h
OLD_FILES+=usr/lib/clang/11.0.1/include/arm_sve.h
OLD_FILES+=usr/lib/clang/11.0.1/include/armintr.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512bf16intrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512vlbf16intrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512vlvp2intersectintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512vp2intersectintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/avxintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/cet.h
OLD_FILES+=usr/lib/clang/11.0.1/include/cetintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/cpuid.h
OLD_FILES+=usr/lib/clang/11.0.1/include/emmintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/enqcmdintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/float.h
OLD_FILES+=usr/lib/clang/11.0.1/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/htmintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/immintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/intrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/inttypes.h
OLD_FILES+=usr/lib/clang/11.0.1/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/iso646.h
OLD_FILES+=usr/lib/clang/11.0.1/include/limits.h
OLD_FILES+=usr/lib/clang/11.0.1/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/11.0.1/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/11.0.1/include/mmintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/module.modulemap
OLD_FILES+=usr/lib/clang/11.0.1/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/msa.h
OLD_FILES+=usr/lib/clang/11.0.1/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/omp-tools.h
OLD_FILES+=usr/lib/clang/11.0.1/include/omp.h
OLD_FILES+=usr/lib/clang/11.0.1/include/ompt.h
OLD_FILES+=usr/lib/clang/11.0.1/include/opencl-c-base.h
OLD_FILES+=usr/lib/clang/11.0.1/include/opencl-c.h
OLD_FILES+=usr/lib/clang/11.0.1/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/s390intrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/serializeintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/shaintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/smmintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/stdalign.h
OLD_FILES+=usr/lib/clang/11.0.1/include/stdarg.h
OLD_FILES+=usr/lib/clang/11.0.1/include/stdatomic.h
OLD_FILES+=usr/lib/clang/11.0.1/include/stdbool.h
OLD_FILES+=usr/lib/clang/11.0.1/include/stddef.h
OLD_FILES+=usr/lib/clang/11.0.1/include/stdint.h
OLD_FILES+=usr/lib/clang/11.0.1/include/stdnoreturn.h
OLD_FILES+=usr/lib/clang/11.0.1/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/tgmath.h
OLD_FILES+=usr/lib/clang/11.0.1/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/tsxldtrkintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/unwind.h
OLD_FILES+=usr/lib/clang/11.0.1/include/vadefs.h
OLD_FILES+=usr/lib/clang/11.0.1/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/varargs.h
OLD_FILES+=usr/lib/clang/11.0.1/include/vecintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/wasm_simd128.h
OLD_FILES+=usr/lib/clang/11.0.1/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/x86intrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/xopintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/11.0.1/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/11.0.1/include
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan-aarch64.so
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan-arm.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan-arm.so
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan-armhf.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan-armhf.so
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan-preinit-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan-preinit-arm.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan-preinit-armhf.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan_cxx-arm.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan_cxx-armhf.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.cfi-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.cfi-arm.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.cfi-armhf.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.cfi-i386.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.cfi-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.cfi_diag-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.cfi_diag-arm.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.cfi_diag-armhf.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.cfi_diag-i386.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.cfi_diag-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.dd-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.dd-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.fuzzer-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.fuzzer-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.fuzzer_no_main-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.fuzzer_no_main-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.msan-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.msan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.profile-powerpc.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.profile-powerpc64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.profile-powerpc64le.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.safestack-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.stats-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.stats-arm.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.stats-armhf.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.stats_client-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.stats_client-arm.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.stats_client-armhf.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.tsan-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.tsan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.ubsan_minimal-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.ubsan_minimal-arm.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.ubsan_minimal-armhf.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.ubsan_standalone-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.ubsan_standalone-arm.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.ubsan_standalone-armhf.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-arm.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-armhf.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.xray-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.xray-arm.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.xray-armhf.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.xray-basic-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.xray-basic-arm.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.xray-basic-armhf.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.xray-basic-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.xray-fdr-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.xray-fdr-arm.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.xray-fdr-armhf.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.xray-fdr-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.xray-profiling-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.xray-profiling-arm.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.xray-profiling-armhf.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.xray-profiling-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.1/lib/freebsd/libclang_rt.xray-x86_64.a
OLD_DIRS+=usr/lib/clang/11.0.1/lib/freebsd
OLD_DIRS+=usr/lib/clang/11.0.1/lib
OLD_DIRS+=usr/lib/clang/11.0.1

# 20210613: Rename OpenZFS manual pages
OLD_FILES+=usr/share/man/man5/spl-module-parameters.5.gz
OLD_FILES+=usr/share/man/man5/zfs-events.5.gz
OLD_FILES+=usr/share/man/man5/zfs-module-parameters.5.gz
OLD_FILES+=usr/share/man/man8/zfsconcepts.8.gz
OLD_FILES+=usr/share/man/man8/zfsprops.8.gz
OLD_FILES+=usr/share/man/man5/zpool-features.5.gz
OLD_FILES+=usr/share/man/man8/zpoolconcepts.8.gz
OLD_FILES+=usr/share/man/man8/zpoolprops.8.gz

# 20210611: Remove svn and svnlite
OLD_FILES+=usr/bin/svn
OLD_FILES+=usr/bin/svnadmin
OLD_FILES+=usr/bin/svnbench
OLD_FILES+=usr/bin/svndumpfilter
OLD_FILES+=usr/bin/svnfsfs
OLD_FILES+=usr/bin/svnlite
OLD_FILES+=usr/bin/svnliteadmin
OLD_FILES+=usr/bin/svnlitebench
OLD_FILES+=usr/bin/svnlitedumpfilter
OLD_FILES+=usr/bin/svnlitefsfs
OLD_FILES+=usr/bin/svnlitelook
OLD_FILES+=usr/bin/svnlitemucc
OLD_FILES+=usr/bin/svnliterdump
OLD_FILES+=usr/bin/svnliteserve
OLD_FILES+=usr/bin/svnlitesync
OLD_FILES+=usr/bin/svnliteversion
OLD_FILES+=usr/bin/svnlook
OLD_FILES+=usr/bin/svnmucc
OLD_FILES+=usr/bin/svnrdump
OLD_FILES+=usr/bin/svnserve
OLD_FILES+=usr/bin/svnsync
OLD_FILES+=usr/bin/svnversion
OLD_FILES+=usr/share/man/man1/svnlite.1.gz

# 20210607: remove ancontrol(8) related programs
OLD_FILES+=usr/sbin/ancontrol
OLD_FILES+=usr/share/man/man8/ancontrol.8.gz

# 20210607: remove an(4)
OLD_FILES+=usr/include/dev/an/if_aironet_ieee.h
OLD_FILES+=usr/include/dev/an/if_anreg.h
OLD_FILES+=usr/share/man/man4/an.4.gz

# 20210426: remove unused libexec/rc.d/addswap
OLD_FILES+=etc/rc.d/addswap

# 20210413: Remove pfctlinput2
OLD_FILES+=usr/share/man/man9/pfctlinput2.9.gz

# 20210412: Remove kernel asymmetric crypto
OLD_FILES+=usr/share/man/man9/crypto_asym.9.gz
OLD_FILES+=usr/share/man/man9/crypto_kdispatch.9.gz
OLD_FILES+=usr/share/man/man9/crypto_kdone.9.gz
OLD_FILES+=usr/share/man/man9/crypto_kregister.9.gz
OLD_FILES+=usr/share/man/man9/CRYPTODEV_KPROCESS.9.gz

# 20210410: remove unused libexec/rc.d/archdep
OLD_FILES+=etc/rc.d/archdep

# 20210408: remove tcp_hostcache.h
OLD_FILES+=usr/include/netinet/tcp_hostcache.h

# 20210403: remove kgmon(8)
OLD_FILES+=usr/sbin/kgmon
OLD_FILES+=usr/share/man/man8/kgmon.8.gz

# 20210401: remove bt(4) man page
OLD_FILES+=usr/share/man/man4/bt.4.gz

# 20210322: retire mn(4) sync serial driver
OLD_FILES+=usr/share/man/man4/if_mn.4.gz
OLD_FILES+=usr/share/man/man4/mn.4.gz

# 20210318: remove the terminfo database
OLD_FILES+=usr/share/terminfo/1/1178
OLD_FILES+=usr/share/terminfo/1/1730-lm
OLD_DIRS+=usr/share/terminfo/1
OLD_FILES+=usr/share/terminfo/2/2621
OLD_FILES+=usr/share/terminfo/2/2621-wl
OLD_FILES+=usr/share/terminfo/2/2621A
OLD_FILES+=usr/share/terminfo/2/2621a
OLD_DIRS+=usr/share/terminfo/2/
OLD_FILES+=usr/share/terminfo/3/386at
OLD_FILES+=usr/share/terminfo/3/3b1
OLD_DIRS+=usr/share/terminfo/3/
OLD_FILES+=usr/share/terminfo/4/4025ex
OLD_FILES+=usr/share/terminfo/4/4027ex
OLD_FILES+=usr/share/terminfo/4/4410-w
OLD_DIRS+=usr/share/terminfo/4/
OLD_FILES+=usr/share/terminfo/5/5051
OLD_FILES+=usr/share/terminfo/5/5410-w
OLD_FILES+=usr/share/terminfo/5/5620
OLD_FILES+=usr/share/terminfo/5/5630-24
OLD_FILES+=usr/share/terminfo/5/5630DMD-24
OLD_DIRS+=usr/share/terminfo/5/
OLD_FILES+=usr/share/terminfo/6/6053
OLD_FILES+=usr/share/terminfo/6/6053-dg
OLD_FILES+=usr/share/terminfo/6/605x
OLD_FILES+=usr/share/terminfo/6/605x-dg
OLD_FILES+=usr/share/terminfo/6/630-lm
OLD_FILES+=usr/share/terminfo/6/630MTG-24
OLD_DIRS+=usr/share/terminfo/6/
OLD_FILES+=usr/share/terminfo/7/730MTG-24
OLD_FILES+=usr/share/terminfo/7/730MTG-41
OLD_FILES+=usr/share/terminfo/7/730MTG-41r
OLD_FILES+=usr/share/terminfo/7/730MTGr
OLD_FILES+=usr/share/terminfo/7/730MTGr-24
OLD_DIRS+=usr/share/terminfo/7/
OLD_FILES+=usr/share/terminfo/8/8510
OLD_DIRS+=usr/share/terminfo/8/
OLD_FILES+=usr/share/terminfo/9/955-hb
OLD_FILES+=usr/share/terminfo/9/955-w
OLD_FILES+=usr/share/terminfo/9/9term
OLD_DIRS+=usr/share/terminfo/9/
OLD_FILES+=usr/share/terminfo/A/Apple_Terminal
OLD_DIRS+=usr/share/terminfo/A/
OLD_FILES+=usr/share/terminfo/E/Eterm
OLD_FILES+=usr/share/terminfo/E/Eterm-256color
OLD_FILES+=usr/share/terminfo/E/Eterm-88color
OLD_FILES+=usr/share/terminfo/E/Eterm-color
OLD_DIRS+=usr/share/terminfo/E/
OLD_FILES+=usr/share/terminfo/L/LFT-PC850
OLD_DIRS+=usr/share/terminfo/L/
OLD_FILES+=usr/share/terminfo/M/MtxOrb
OLD_FILES+=usr/share/terminfo/M/MtxOrb162
OLD_FILES+=usr/share/terminfo/M/MtxOrb204
OLD_DIRS+=usr/share/terminfo/M/
OLD_FILES+=usr/share/terminfo/N/NCR260VT300WPP
OLD_FILES+=usr/share/terminfo/N/NCRVT100WPP
OLD_DIRS+=usr/share/terminfo/N/
OLD_FILES+=usr/share/terminfo/P/P12
OLD_FILES+=usr/share/terminfo/P/P12-M
OLD_FILES+=usr/share/terminfo/P/P12-M-W
OLD_FILES+=usr/share/terminfo/P/P12-W
OLD_FILES+=usr/share/terminfo/P/P14
OLD_FILES+=usr/share/terminfo/P/P14-M
OLD_FILES+=usr/share/terminfo/P/P14-M-W
OLD_FILES+=usr/share/terminfo/P/P14-W
OLD_FILES+=usr/share/terminfo/P/P4
OLD_FILES+=usr/share/terminfo/P/P5
OLD_FILES+=usr/share/terminfo/P/P7
OLD_FILES+=usr/share/terminfo/P/P8
OLD_FILES+=usr/share/terminfo/P/P8-W
OLD_FILES+=usr/share/terminfo/P/P9
OLD_FILES+=usr/share/terminfo/P/P9-8
OLD_FILES+=usr/share/terminfo/P/P9-8-W
OLD_FILES+=usr/share/terminfo/P/P9-W
OLD_DIRS+=usr/share/terminfo/P/
OLD_FILES+=usr/share/terminfo/Q/Q306-8-pc
OLD_FILES+=usr/share/terminfo/Q/Q310-vip-H
OLD_FILES+=usr/share/terminfo/Q/Q310-vip-H-am
OLD_FILES+=usr/share/terminfo/Q/Q310-vip-Hw
OLD_FILES+=usr/share/terminfo/Q/Q310-vip-w
OLD_FILES+=usr/share/terminfo/Q/Q310-vip-w-am
OLD_DIRS+=usr/share/terminfo/Q/
OLD_FILES+=usr/share/terminfo/X/X-hpterm
OLD_DIRS+=usr/share/terminfo/X/
OLD_FILES+=usr/share/terminfo/a/a210
OLD_FILES+=usr/share/terminfo/a/a80
OLD_FILES+=usr/share/terminfo/a/a980
OLD_FILES+=usr/share/terminfo/a/aa4080
OLD_FILES+=usr/share/terminfo/a/aaa
OLD_FILES+=usr/share/terminfo/a/aaa+dec
OLD_FILES+=usr/share/terminfo/a/aaa+rv
OLD_FILES+=usr/share/terminfo/a/aaa+unk
OLD_FILES+=usr/share/terminfo/a/aaa-18
OLD_FILES+=usr/share/terminfo/a/aaa-18-rv
OLD_FILES+=usr/share/terminfo/a/aaa-20
OLD_FILES+=usr/share/terminfo/a/aaa-22
OLD_FILES+=usr/share/terminfo/a/aaa-24
OLD_FILES+=usr/share/terminfo/a/aaa-24-rv
OLD_FILES+=usr/share/terminfo/a/aaa-26
OLD_FILES+=usr/share/terminfo/a/aaa-28
OLD_FILES+=usr/share/terminfo/a/aaa-30
OLD_FILES+=usr/share/terminfo/a/aaa-30-ctxt
OLD_FILES+=usr/share/terminfo/a/aaa-30-rv
OLD_FILES+=usr/share/terminfo/a/aaa-30-rv-ctxt
OLD_FILES+=usr/share/terminfo/a/aaa-30-s
OLD_FILES+=usr/share/terminfo/a/aaa-30-s-ctxt
OLD_FILES+=usr/share/terminfo/a/aaa-30-s-rv
OLD_FILES+=usr/share/terminfo/a/aaa-30-s-rv-ct
OLD_FILES+=usr/share/terminfo/a/aaa-36
OLD_FILES+=usr/share/terminfo/a/aaa-36-rv
OLD_FILES+=usr/share/terminfo/a/aaa-40
OLD_FILES+=usr/share/terminfo/a/aaa-40-rv
OLD_FILES+=usr/share/terminfo/a/aaa-48
OLD_FILES+=usr/share/terminfo/a/aaa-48-rv
OLD_FILES+=usr/share/terminfo/a/aaa-60
OLD_FILES+=usr/share/terminfo/a/aaa-60-dec-rv
OLD_FILES+=usr/share/terminfo/a/aaa-60-rv
OLD_FILES+=usr/share/terminfo/a/aaa-60-s
OLD_FILES+=usr/share/terminfo/a/aaa-60-s-rv
OLD_FILES+=usr/share/terminfo/a/aaa-ctxt
OLD_FILES+=usr/share/terminfo/a/aaa-db
OLD_FILES+=usr/share/terminfo/a/aaa-rv
OLD_FILES+=usr/share/terminfo/a/aaa-rv-ctxt
OLD_FILES+=usr/share/terminfo/a/aaa-rv-unk
OLD_FILES+=usr/share/terminfo/a/aaa-s
OLD_FILES+=usr/share/terminfo/a/aaa-s-ctxt
OLD_FILES+=usr/share/terminfo/a/aaa-s-rv
OLD_FILES+=usr/share/terminfo/a/aaa-s-rv-ctxt
OLD_FILES+=usr/share/terminfo/a/aaa-unk
OLD_FILES+=usr/share/terminfo/a/aas1901
OLD_FILES+=usr/share/terminfo/a/abm80
OLD_FILES+=usr/share/terminfo/a/abm85
OLD_FILES+=usr/share/terminfo/a/abm85e
OLD_FILES+=usr/share/terminfo/a/abm85h
OLD_FILES+=usr/share/terminfo/a/abm85h-old
OLD_FILES+=usr/share/terminfo/a/absolute
OLD_FILES+=usr/share/terminfo/a/act4
OLD_FILES+=usr/share/terminfo/a/act5
OLD_FILES+=usr/share/terminfo/a/addrinfo
OLD_FILES+=usr/share/terminfo/a/adds200
OLD_FILES+=usr/share/terminfo/a/adds980
OLD_FILES+=usr/share/terminfo/a/addsviewpoint
OLD_FILES+=usr/share/terminfo/a/addsvp60
OLD_FILES+=usr/share/terminfo/a/adm+sgr
OLD_FILES+=usr/share/terminfo/a/adm1
OLD_FILES+=usr/share/terminfo/a/adm11
OLD_FILES+=usr/share/terminfo/a/adm1178
OLD_FILES+=usr/share/terminfo/a/adm12
OLD_FILES+=usr/share/terminfo/a/adm1a
OLD_FILES+=usr/share/terminfo/a/adm2
OLD_FILES+=usr/share/terminfo/a/adm20
OLD_FILES+=usr/share/terminfo/a/adm21
OLD_FILES+=usr/share/terminfo/a/adm22
OLD_FILES+=usr/share/terminfo/a/adm3
OLD_FILES+=usr/share/terminfo/a/adm31
OLD_FILES+=usr/share/terminfo/a/adm31-old
OLD_FILES+=usr/share/terminfo/a/adm36
OLD_FILES+=usr/share/terminfo/a/adm3a
OLD_FILES+=usr/share/terminfo/a/adm3a+
OLD_FILES+=usr/share/terminfo/a/adm42
OLD_FILES+=usr/share/terminfo/a/adm42-ns
OLD_FILES+=usr/share/terminfo/a/adm5
OLD_FILES+=usr/share/terminfo/a/aepro
OLD_FILES+=usr/share/terminfo/a/aixterm
OLD_FILES+=usr/share/terminfo/a/aixterm-16color
OLD_FILES+=usr/share/terminfo/a/aixterm-m
OLD_FILES+=usr/share/terminfo/a/aixterm-m-old
OLD_FILES+=usr/share/terminfo/a/aj
OLD_FILES+=usr/share/terminfo/a/aj510
OLD_FILES+=usr/share/terminfo/a/aj830
OLD_FILES+=usr/share/terminfo/a/aj832
OLD_FILES+=usr/share/terminfo/a/alacritty
OLD_FILES+=usr/share/terminfo/a/alacritty+common
OLD_FILES+=usr/share/terminfo/a/alacritty-direct
OLD_FILES+=usr/share/terminfo/a/alt2
OLD_FILES+=usr/share/terminfo/a/alt3
OLD_FILES+=usr/share/terminfo/a/alt4
OLD_FILES+=usr/share/terminfo/a/alt5
OLD_FILES+=usr/share/terminfo/a/alt7
OLD_FILES+=usr/share/terminfo/a/alt7pc
OLD_FILES+=usr/share/terminfo/a/alto-h19
OLD_FILES+=usr/share/terminfo/a/alto-heath
OLD_FILES+=usr/share/terminfo/a/altoh19
OLD_FILES+=usr/share/terminfo/a/altoheath
OLD_FILES+=usr/share/terminfo/a/altos-2
OLD_FILES+=usr/share/terminfo/a/altos-3
OLD_FILES+=usr/share/terminfo/a/altos-4
OLD_FILES+=usr/share/terminfo/a/altos-5
OLD_FILES+=usr/share/terminfo/a/altos2
OLD_FILES+=usr/share/terminfo/a/altos3
OLD_FILES+=usr/share/terminfo/a/altos4
OLD_FILES+=usr/share/terminfo/a/altos5
OLD_FILES+=usr/share/terminfo/a/altos7
OLD_FILES+=usr/share/terminfo/a/altos7pc
OLD_FILES+=usr/share/terminfo/a/ambas
OLD_FILES+=usr/share/terminfo/a/ambassador
OLD_FILES+=usr/share/terminfo/a/amiga
OLD_FILES+=usr/share/terminfo/a/amiga-8bit
OLD_FILES+=usr/share/terminfo/a/amiga-h
OLD_FILES+=usr/share/terminfo/a/amiga-vnc
OLD_FILES+=usr/share/terminfo/a/amp219
OLD_FILES+=usr/share/terminfo/a/amp219w
OLD_FILES+=usr/share/terminfo/a/ampex-219
OLD_FILES+=usr/share/terminfo/a/ampex-219w
OLD_FILES+=usr/share/terminfo/a/ampex-232
OLD_FILES+=usr/share/terminfo/a/ampex175
OLD_FILES+=usr/share/terminfo/a/ampex175-b
OLD_FILES+=usr/share/terminfo/a/ampex210
OLD_FILES+=usr/share/terminfo/a/ampex219
OLD_FILES+=usr/share/terminfo/a/ampex219w
OLD_FILES+=usr/share/terminfo/a/ampex232
OLD_FILES+=usr/share/terminfo/a/ampex232w
OLD_FILES+=usr/share/terminfo/a/ampex80
OLD_FILES+=usr/share/terminfo/a/annarbor4080
OLD_FILES+=usr/share/terminfo/a/ansi
OLD_FILES+=usr/share/terminfo/a/ansi+arrows
OLD_FILES+=usr/share/terminfo/a/ansi+csr
OLD_FILES+=usr/share/terminfo/a/ansi+cup
OLD_FILES+=usr/share/terminfo/a/ansi+enq
OLD_FILES+=usr/share/terminfo/a/ansi+erase
OLD_FILES+=usr/share/terminfo/a/ansi+idc
OLD_FILES+=usr/share/terminfo/a/ansi+idc1
OLD_FILES+=usr/share/terminfo/a/ansi+idl
OLD_FILES+=usr/share/terminfo/a/ansi+idl1
OLD_FILES+=usr/share/terminfo/a/ansi+inittabs
OLD_FILES+=usr/share/terminfo/a/ansi+local
OLD_FILES+=usr/share/terminfo/a/ansi+local1
OLD_FILES+=usr/share/terminfo/a/ansi+pp
OLD_FILES+=usr/share/terminfo/a/ansi+rca
OLD_FILES+=usr/share/terminfo/a/ansi+rep
OLD_FILES+=usr/share/terminfo/a/ansi+sgr
OLD_FILES+=usr/share/terminfo/a/ansi+sgrbold
OLD_FILES+=usr/share/terminfo/a/ansi+sgrdim
OLD_FILES+=usr/share/terminfo/a/ansi+sgrso
OLD_FILES+=usr/share/terminfo/a/ansi+sgrul
OLD_FILES+=usr/share/terminfo/a/ansi+tabs
OLD_FILES+=usr/share/terminfo/a/ansi-color-2-emx
OLD_FILES+=usr/share/terminfo/a/ansi-color-3-emx
OLD_FILES+=usr/share/terminfo/a/ansi-emx
OLD_FILES+=usr/share/terminfo/a/ansi-generic
OLD_FILES+=usr/share/terminfo/a/ansi-m
OLD_FILES+=usr/share/terminfo/a/ansi-mini
OLD_FILES+=usr/share/terminfo/a/ansi-mono
OLD_FILES+=usr/share/terminfo/a/ansi-mr
OLD_FILES+=usr/share/terminfo/a/ansi-mtabs
OLD_FILES+=usr/share/terminfo/a/ansi-nt
OLD_FILES+=usr/share/terminfo/a/ansi.sys
OLD_FILES+=usr/share/terminfo/a/ansi.sys-old
OLD_FILES+=usr/share/terminfo/a/ansi.sysk
OLD_FILES+=usr/share/terminfo/a/ansi43m
OLD_FILES+=usr/share/terminfo/a/ansi77
OLD_FILES+=usr/share/terminfo/a/ansi80x25
OLD_FILES+=usr/share/terminfo/a/ansi80x25-mono
OLD_FILES+=usr/share/terminfo/a/ansi80x25-raw
OLD_FILES+=usr/share/terminfo/a/ansi80x30
OLD_FILES+=usr/share/terminfo/a/ansi80x30-mono
OLD_FILES+=usr/share/terminfo/a/ansi80x43
OLD_FILES+=usr/share/terminfo/a/ansi80x43-mono
OLD_FILES+=usr/share/terminfo/a/ansi80x50
OLD_FILES+=usr/share/terminfo/a/ansi80x50-mono
OLD_FILES+=usr/share/terminfo/a/ansi80x60
OLD_FILES+=usr/share/terminfo/a/ansi80x60-mono
OLD_FILES+=usr/share/terminfo/a/ansil
OLD_FILES+=usr/share/terminfo/a/ansil-mono
OLD_FILES+=usr/share/terminfo/a/ansis
OLD_FILES+=usr/share/terminfo/a/ansis-mono
OLD_FILES+=usr/share/terminfo/a/ansisysk
OLD_FILES+=usr/share/terminfo/a/ansiterm
OLD_FILES+=usr/share/terminfo/a/ansiw
OLD_FILES+=usr/share/terminfo/a/ap-vm80
OLD_FILES+=usr/share/terminfo/a/apl
OLD_FILES+=usr/share/terminfo/a/apollo
OLD_FILES+=usr/share/terminfo/a/apollo_15P
OLD_FILES+=usr/share/terminfo/a/apollo_19L
OLD_FILES+=usr/share/terminfo/a/apollo_color
OLD_FILES+=usr/share/terminfo/a/apple-80
OLD_FILES+=usr/share/terminfo/a/apple-ae
OLD_FILES+=usr/share/terminfo/a/apple-soroc
OLD_FILES+=usr/share/terminfo/a/apple-uterm
OLD_FILES+=usr/share/terminfo/a/apple-uterm-vb
OLD_FILES+=usr/share/terminfo/a/apple-videx
OLD_FILES+=usr/share/terminfo/a/apple-videx2
OLD_FILES+=usr/share/terminfo/a/apple-videx3
OLD_FILES+=usr/share/terminfo/a/apple-vm80
OLD_FILES+=usr/share/terminfo/a/apple2e
OLD_FILES+=usr/share/terminfo/a/apple2e-p
OLD_FILES+=usr/share/terminfo/a/apple80p
OLD_FILES+=usr/share/terminfo/a/appleII
OLD_FILES+=usr/share/terminfo/a/appleIIc
OLD_FILES+=usr/share/terminfo/a/appleIIe
OLD_FILES+=usr/share/terminfo/a/appleIIgs
OLD_FILES+=usr/share/terminfo/a/arm100
OLD_FILES+=usr/share/terminfo/a/arm100-am
OLD_FILES+=usr/share/terminfo/a/arm100-w
OLD_FILES+=usr/share/terminfo/a/arm100-wam
OLD_FILES+=usr/share/terminfo/a/at
OLD_FILES+=usr/share/terminfo/a/at-color
OLD_FILES+=usr/share/terminfo/a/at-m
OLD_FILES+=usr/share/terminfo/a/at386
OLD_FILES+=usr/share/terminfo/a/atari
OLD_FILES+=usr/share/terminfo/a/atari-color
OLD_FILES+=usr/share/terminfo/a/atari-m
OLD_FILES+=usr/share/terminfo/a/atari-old
OLD_FILES+=usr/share/terminfo/a/atari_st
OLD_FILES+=usr/share/terminfo/a/atari_st-color
OLD_FILES+=usr/share/terminfo/a/atarist-m
OLD_FILES+=usr/share/terminfo/a/aterm
OLD_FILES+=usr/share/terminfo/a/att2300
OLD_FILES+=usr/share/terminfo/a/att2350
OLD_FILES+=usr/share/terminfo/a/att4410
OLD_FILES+=usr/share/terminfo/a/att4410-w
OLD_FILES+=usr/share/terminfo/a/att4410v1
OLD_FILES+=usr/share/terminfo/a/att4410v1-w
OLD_FILES+=usr/share/terminfo/a/att4415
OLD_FILES+=usr/share/terminfo/a/att4415+nl
OLD_FILES+=usr/share/terminfo/a/att4415-nl
OLD_FILES+=usr/share/terminfo/a/att4415-rv
OLD_FILES+=usr/share/terminfo/a/att4415-rv-nl
OLD_FILES+=usr/share/terminfo/a/att4415-w
OLD_FILES+=usr/share/terminfo/a/att4415-w-nl
OLD_FILES+=usr/share/terminfo/a/att4415-w-rv
OLD_FILES+=usr/share/terminfo/a/att4415-w-rv-n
OLD_FILES+=usr/share/terminfo/a/att4418
OLD_FILES+=usr/share/terminfo/a/att4418-w
OLD_FILES+=usr/share/terminfo/a/att4420
OLD_FILES+=usr/share/terminfo/a/att4424
OLD_FILES+=usr/share/terminfo/a/att4424-1
OLD_FILES+=usr/share/terminfo/a/att4424m
OLD_FILES+=usr/share/terminfo/a/att4425
OLD_FILES+=usr/share/terminfo/a/att4425-nl
OLD_FILES+=usr/share/terminfo/a/att4425-w
OLD_FILES+=usr/share/terminfo/a/att4426
OLD_FILES+=usr/share/terminfo/a/att500
OLD_FILES+=usr/share/terminfo/a/att505
OLD_FILES+=usr/share/terminfo/a/att505-24
OLD_FILES+=usr/share/terminfo/a/att510a
OLD_FILES+=usr/share/terminfo/a/att510d
OLD_FILES+=usr/share/terminfo/a/att513
OLD_FILES+=usr/share/terminfo/a/att5310
OLD_FILES+=usr/share/terminfo/a/att5320
OLD_FILES+=usr/share/terminfo/a/att5410
OLD_FILES+=usr/share/terminfo/a/att5410-w
OLD_FILES+=usr/share/terminfo/a/att5410v1
OLD_FILES+=usr/share/terminfo/a/att5410v1-w
OLD_FILES+=usr/share/terminfo/a/att5418
OLD_FILES+=usr/share/terminfo/a/att5418-w
OLD_FILES+=usr/share/terminfo/a/att5420
OLD_FILES+=usr/share/terminfo/a/att5420+nl
OLD_FILES+=usr/share/terminfo/a/att5420-nl
OLD_FILES+=usr/share/terminfo/a/att5420-rv
OLD_FILES+=usr/share/terminfo/a/att5420-rv-nl
OLD_FILES+=usr/share/terminfo/a/att5420-w
OLD_FILES+=usr/share/terminfo/a/att5420-w-nl
OLD_FILES+=usr/share/terminfo/a/att5420-w-rv
OLD_FILES+=usr/share/terminfo/a/att5420-w-rv-n
OLD_FILES+=usr/share/terminfo/a/att5420_2
OLD_FILES+=usr/share/terminfo/a/att5420_2-w
OLD_FILES+=usr/share/terminfo/a/att5425
OLD_FILES+=usr/share/terminfo/a/att5425-nl
OLD_FILES+=usr/share/terminfo/a/att5425-w
OLD_FILES+=usr/share/terminfo/a/att5430
OLD_FILES+=usr/share/terminfo/a/att5620
OLD_FILES+=usr/share/terminfo/a/att5620-1
OLD_FILES+=usr/share/terminfo/a/att5620-24
OLD_FILES+=usr/share/terminfo/a/att5620-34
OLD_FILES+=usr/share/terminfo/a/att5620-s
OLD_FILES+=usr/share/terminfo/a/att605
OLD_FILES+=usr/share/terminfo/a/att605-pc
OLD_FILES+=usr/share/terminfo/a/att605-w
OLD_FILES+=usr/share/terminfo/a/att610
OLD_FILES+=usr/share/terminfo/a/att610+cvis
OLD_FILES+=usr/share/terminfo/a/att610+cvis0
OLD_FILES+=usr/share/terminfo/a/att610-103k
OLD_FILES+=usr/share/terminfo/a/att610-103k-w
OLD_FILES+=usr/share/terminfo/a/att610-w
OLD_FILES+=usr/share/terminfo/a/att615
OLD_FILES+=usr/share/terminfo/a/att615-103k
OLD_FILES+=usr/share/terminfo/a/att615-103k-w
OLD_FILES+=usr/share/terminfo/a/att615-w
OLD_FILES+=usr/share/terminfo/a/att620
OLD_FILES+=usr/share/terminfo/a/att620-103k
OLD_FILES+=usr/share/terminfo/a/att620-103k-w
OLD_FILES+=usr/share/terminfo/a/att620-w
OLD_FILES+=usr/share/terminfo/a/att630
OLD_FILES+=usr/share/terminfo/a/att630-24
OLD_FILES+=usr/share/terminfo/a/att6386
OLD_FILES+=usr/share/terminfo/a/att700
OLD_FILES+=usr/share/terminfo/a/att730
OLD_FILES+=usr/share/terminfo/a/att730-24
OLD_FILES+=usr/share/terminfo/a/att730-41
OLD_FILES+=usr/share/terminfo/a/att7300
OLD_FILES+=usr/share/terminfo/a/att730r
OLD_FILES+=usr/share/terminfo/a/att730r-24
OLD_FILES+=usr/share/terminfo/a/att730r-41
OLD_FILES+=usr/share/terminfo/a/avatar
OLD_FILES+=usr/share/terminfo/a/avatar0
OLD_FILES+=usr/share/terminfo/a/avatar0+
OLD_FILES+=usr/share/terminfo/a/avatar1
OLD_FILES+=usr/share/terminfo/a/avt
OLD_FILES+=usr/share/terminfo/a/avt+s
OLD_FILES+=usr/share/terminfo/a/avt-ns
OLD_FILES+=usr/share/terminfo/a/avt-rv
OLD_FILES+=usr/share/terminfo/a/avt-rv-ns
OLD_FILES+=usr/share/terminfo/a/avt-rv-s
OLD_FILES+=usr/share/terminfo/a/avt-s
OLD_FILES+=usr/share/terminfo/a/avt-w
OLD_FILES+=usr/share/terminfo/a/avt-w-ns
OLD_FILES+=usr/share/terminfo/a/avt-w-rv
OLD_FILES+=usr/share/terminfo/a/avt-w-rv-ns
OLD_FILES+=usr/share/terminfo/a/avt-w-rv-s
OLD_FILES+=usr/share/terminfo/a/avt-w-s
OLD_FILES+=usr/share/terminfo/a/aws
OLD_FILES+=usr/share/terminfo/a/awsc
OLD_DIRS+=usr/share/terminfo/a/
OLD_FILES+=usr/share/terminfo/b/b-128
OLD_FILES+=usr/share/terminfo/b/bantam
OLD_FILES+=usr/share/terminfo/b/basic4
OLD_FILES+=usr/share/terminfo/b/basis
OLD_FILES+=usr/share/terminfo/b/bct510a
OLD_FILES+=usr/share/terminfo/b/bct510d
OLD_FILES+=usr/share/terminfo/b/beacon
OLD_FILES+=usr/share/terminfo/b/bee
OLD_FILES+=usr/share/terminfo/b/beehive
OLD_FILES+=usr/share/terminfo/b/beehive3
OLD_FILES+=usr/share/terminfo/b/beehive4
OLD_FILES+=usr/share/terminfo/b/beehiveIIIm
OLD_FILES+=usr/share/terminfo/b/beterm
OLD_FILES+=usr/share/terminfo/b/bg1.25
OLD_FILES+=usr/share/terminfo/b/bg1.25nv
OLD_FILES+=usr/share/terminfo/b/bg1.25rv
OLD_FILES+=usr/share/terminfo/b/bg2.0
OLD_FILES+=usr/share/terminfo/b/bg2.0nv
OLD_FILES+=usr/share/terminfo/b/bg2.0rv
OLD_FILES+=usr/share/terminfo/b/bg3.10
OLD_FILES+=usr/share/terminfo/b/bg3.10nv
OLD_FILES+=usr/share/terminfo/b/bg3.10rv
OLD_FILES+=usr/share/terminfo/b/bh3m
OLD_FILES+=usr/share/terminfo/b/bh4
OLD_FILES+=usr/share/terminfo/b/bitgraph
OLD_FILES+=usr/share/terminfo/b/blit
OLD_FILES+=usr/share/terminfo/b/bobcat
OLD_FILES+=usr/share/terminfo/b/bq300
OLD_FILES+=usr/share/terminfo/b/bq300-8
OLD_FILES+=usr/share/terminfo/b/bq300-8-pc
OLD_FILES+=usr/share/terminfo/b/bq300-8-pc-rv
OLD_FILES+=usr/share/terminfo/b/bq300-8-pc-w
OLD_FILES+=usr/share/terminfo/b/bq300-8-pc-w-rv
OLD_FILES+=usr/share/terminfo/b/bq300-8rv
OLD_FILES+=usr/share/terminfo/b/bq300-8w
OLD_FILES+=usr/share/terminfo/b/bq300-pc
OLD_FILES+=usr/share/terminfo/b/bq300-pc-rv
OLD_FILES+=usr/share/terminfo/b/bq300-pc-w
OLD_FILES+=usr/share/terminfo/b/bq300-pc-w-rv
OLD_FILES+=usr/share/terminfo/b/bq300-rv
OLD_FILES+=usr/share/terminfo/b/bq300-w
OLD_FILES+=usr/share/terminfo/b/bq300-w-8rv
OLD_FILES+=usr/share/terminfo/b/bq300-w-rv
OLD_FILES+=usr/share/terminfo/b/bsdos-pc
OLD_FILES+=usr/share/terminfo/b/bsdos-pc-m
OLD_FILES+=usr/share/terminfo/b/bsdos-pc-mono
OLD_FILES+=usr/share/terminfo/b/bsdos-pc-nobold
OLD_FILES+=usr/share/terminfo/b/bsdos-ppc
OLD_FILES+=usr/share/terminfo/b/bsdos-sparc
OLD_FILES+=usr/share/terminfo/b/bterm
OLD_DIRS+=usr/share/terminfo/b/
OLD_FILES+=usr/share/terminfo/c/c100
OLD_FILES+=usr/share/terminfo/c/c100-1p
OLD_FILES+=usr/share/terminfo/c/c100-4p
OLD_FILES+=usr/share/terminfo/c/c100-rv
OLD_FILES+=usr/share/terminfo/c/c100-rv-4p
OLD_FILES+=usr/share/terminfo/c/c104
OLD_FILES+=usr/share/terminfo/c/c108
OLD_FILES+=usr/share/terminfo/c/c108-4p
OLD_FILES+=usr/share/terminfo/c/c108-8p
OLD_FILES+=usr/share/terminfo/c/c108-rv
OLD_FILES+=usr/share/terminfo/c/c108-rv-4p
OLD_FILES+=usr/share/terminfo/c/c108-rv-8p
OLD_FILES+=usr/share/terminfo/c/c108-w
OLD_FILES+=usr/share/terminfo/c/c108-w-8p
OLD_FILES+=usr/share/terminfo/c/c300
OLD_FILES+=usr/share/terminfo/c/c301
OLD_FILES+=usr/share/terminfo/c/c321
OLD_FILES+=usr/share/terminfo/c/ca22851
OLD_FILES+=usr/share/terminfo/c/cad68-2
OLD_FILES+=usr/share/terminfo/c/cad68-3
OLD_FILES+=usr/share/terminfo/c/cbblit
OLD_FILES+=usr/share/terminfo/c/cbunix
OLD_FILES+=usr/share/terminfo/c/cci
OLD_FILES+=usr/share/terminfo/c/cci1
OLD_FILES+=usr/share/terminfo/c/cdc456
OLD_FILES+=usr/share/terminfo/c/cdc721
OLD_FILES+=usr/share/terminfo/c/cdc721-esc
OLD_FILES+=usr/share/terminfo/c/cdc721ll
OLD_FILES+=usr/share/terminfo/c/cdc752
OLD_FILES+=usr/share/terminfo/c/cdc756
OLD_FILES+=usr/share/terminfo/c/cg7900
OLD_FILES+=usr/share/terminfo/c/cgc2
OLD_FILES+=usr/share/terminfo/c/cgc3
OLD_FILES+=usr/share/terminfo/c/chromatics
OLD_FILES+=usr/share/terminfo/c/ci8510
OLD_FILES+=usr/share/terminfo/c/cit-80
OLD_FILES+=usr/share/terminfo/c/cit101
OLD_FILES+=usr/share/terminfo/c/cit101e
OLD_FILES+=usr/share/terminfo/c/cit101e-132
OLD_FILES+=usr/share/terminfo/c/cit101e-n
OLD_FILES+=usr/share/terminfo/c/cit101e-n132
OLD_FILES+=usr/share/terminfo/c/cit101e-rv
OLD_FILES+=usr/share/terminfo/c/cit500
OLD_FILES+=usr/share/terminfo/c/cit80
OLD_FILES+=usr/share/terminfo/c/citc
OLD_FILES+=usr/share/terminfo/c/citoh
OLD_FILES+=usr/share/terminfo/c/citoh-6lpi
OLD_FILES+=usr/share/terminfo/c/citoh-8lpi
OLD_FILES+=usr/share/terminfo/c/citoh-comp
OLD_FILES+=usr/share/terminfo/c/citoh-elite
OLD_FILES+=usr/share/terminfo/c/citoh-pica
OLD_FILES+=usr/share/terminfo/c/citoh-prop
OLD_FILES+=usr/share/terminfo/c/citoh-ps
OLD_FILES+=usr/share/terminfo/c/coco3
OLD_FILES+=usr/share/terminfo/c/coherent
OLD_FILES+=usr/share/terminfo/c/color_xterm
OLD_FILES+=usr/share/terminfo/c/colorscan
OLD_FILES+=usr/share/terminfo/c/commodore
OLD_FILES+=usr/share/terminfo/c/concept
OLD_FILES+=usr/share/terminfo/c/concept-avt
OLD_FILES+=usr/share/terminfo/c/concept100
OLD_FILES+=usr/share/terminfo/c/concept100-rv
OLD_FILES+=usr/share/terminfo/c/concept108
OLD_FILES+=usr/share/terminfo/c/concept108-4p
OLD_FILES+=usr/share/terminfo/c/concept108-8p
OLD_FILES+=usr/share/terminfo/c/concept108-w-8
OLD_FILES+=usr/share/terminfo/c/concept108-w8p
OLD_FILES+=usr/share/terminfo/c/concept108rv4p
OLD_FILES+=usr/share/terminfo/c/cons25
OLD_FILES+=usr/share/terminfo/c/cons25-debian
OLD_FILES+=usr/share/terminfo/c/cons25-iso-m
OLD_FILES+=usr/share/terminfo/c/cons25-iso8859
OLD_FILES+=usr/share/terminfo/c/cons25-koi8-r
OLD_FILES+=usr/share/terminfo/c/cons25-koi8r-m
OLD_FILES+=usr/share/terminfo/c/cons25-m
OLD_FILES+=usr/share/terminfo/c/cons25l1
OLD_FILES+=usr/share/terminfo/c/cons25l1-m
OLD_FILES+=usr/share/terminfo/c/cons25r
OLD_FILES+=usr/share/terminfo/c/cons25r-m
OLD_FILES+=usr/share/terminfo/c/cons25w
OLD_FILES+=usr/share/terminfo/c/cons30
OLD_FILES+=usr/share/terminfo/c/cons30-m
OLD_FILES+=usr/share/terminfo/c/cons43
OLD_FILES+=usr/share/terminfo/c/cons43-m
OLD_FILES+=usr/share/terminfo/c/cons50
OLD_FILES+=usr/share/terminfo/c/cons50-iso-m
OLD_FILES+=usr/share/terminfo/c/cons50-iso8859
OLD_FILES+=usr/share/terminfo/c/cons50-koi8r
OLD_FILES+=usr/share/terminfo/c/cons50-koi8r-m
OLD_FILES+=usr/share/terminfo/c/cons50-m
OLD_FILES+=usr/share/terminfo/c/cons50l1
OLD_FILES+=usr/share/terminfo/c/cons50l1-m
OLD_FILES+=usr/share/terminfo/c/cons50r
OLD_FILES+=usr/share/terminfo/c/cons50r-m
OLD_FILES+=usr/share/terminfo/c/cons60
OLD_FILES+=usr/share/terminfo/c/cons60-iso
OLD_FILES+=usr/share/terminfo/c/cons60-iso-m
OLD_FILES+=usr/share/terminfo/c/cons60-koi8r
OLD_FILES+=usr/share/terminfo/c/cons60-koi8r-m
OLD_FILES+=usr/share/terminfo/c/cons60-m
OLD_FILES+=usr/share/terminfo/c/cons60l1
OLD_FILES+=usr/share/terminfo/c/cons60l1-m
OLD_FILES+=usr/share/terminfo/c/cons60r
OLD_FILES+=usr/share/terminfo/c/cons60r-m
OLD_FILES+=usr/share/terminfo/c/contel300
OLD_FILES+=usr/share/terminfo/c/contel301
OLD_FILES+=usr/share/terminfo/c/contel320
OLD_FILES+=usr/share/terminfo/c/contel321
OLD_FILES+=usr/share/terminfo/c/cops
OLD_FILES+=usr/share/terminfo/c/cops-10
OLD_FILES+=usr/share/terminfo/c/cops10
OLD_FILES+=usr/share/terminfo/c/crt
OLD_FILES+=usr/share/terminfo/c/crt-vt220
OLD_FILES+=usr/share/terminfo/c/cs10
OLD_FILES+=usr/share/terminfo/c/cs10-w
OLD_FILES+=usr/share/terminfo/c/ct82
OLD_FILES+=usr/share/terminfo/c/ct8500
OLD_FILES+=usr/share/terminfo/c/ctrm
OLD_FILES+=usr/share/terminfo/c/cx
OLD_FILES+=usr/share/terminfo/c/cx100
OLD_FILES+=usr/share/terminfo/c/cyb110
OLD_FILES+=usr/share/terminfo/c/cyb83
OLD_FILES+=usr/share/terminfo/c/cygwin
OLD_FILES+=usr/share/terminfo/c/cygwinB19
OLD_FILES+=usr/share/terminfo/c/cygwinDBG
OLD_DIRS+=usr/share/terminfo/c/
OLD_FILES+=usr/share/terminfo/d/d132
OLD_FILES+=usr/share/terminfo/d/d2
OLD_FILES+=usr/share/terminfo/d/d2-dg
OLD_FILES+=usr/share/terminfo/d/d200
OLD_FILES+=usr/share/terminfo/d/d200-dg
OLD_FILES+=usr/share/terminfo/d/d210
OLD_FILES+=usr/share/terminfo/d/d210-dg
OLD_FILES+=usr/share/terminfo/d/d211
OLD_FILES+=usr/share/terminfo/d/d211-7b
OLD_FILES+=usr/share/terminfo/d/d211-dg
OLD_FILES+=usr/share/terminfo/d/d214
OLD_FILES+=usr/share/terminfo/d/d214-dg
OLD_FILES+=usr/share/terminfo/d/d215
OLD_FILES+=usr/share/terminfo/d/d215-7b
OLD_FILES+=usr/share/terminfo/d/d215-dg
OLD_FILES+=usr/share/terminfo/d/d216+
OLD_FILES+=usr/share/terminfo/d/d216+25
OLD_FILES+=usr/share/terminfo/d/d216+dg
OLD_FILES+=usr/share/terminfo/d/d216-dg
OLD_FILES+=usr/share/terminfo/d/d216-unix
OLD_FILES+=usr/share/terminfo/d/d216-unix-25
OLD_FILES+=usr/share/terminfo/d/d216e+
OLD_FILES+=usr/share/terminfo/d/d216e+dg
OLD_FILES+=usr/share/terminfo/d/d216e-dg
OLD_FILES+=usr/share/terminfo/d/d216e-unix
OLD_FILES+=usr/share/terminfo/d/d217-dg
OLD_FILES+=usr/share/terminfo/d/d217-unix
OLD_FILES+=usr/share/terminfo/d/d217-unix-25
OLD_FILES+=usr/share/terminfo/d/d220
OLD_FILES+=usr/share/terminfo/d/d220-7b
OLD_FILES+=usr/share/terminfo/d/d220-dg
OLD_FILES+=usr/share/terminfo/d/d230
OLD_FILES+=usr/share/terminfo/d/d230-dg
OLD_FILES+=usr/share/terminfo/d/d230c
OLD_FILES+=usr/share/terminfo/d/d230c-dg
OLD_FILES+=usr/share/terminfo/d/d400
OLD_FILES+=usr/share/terminfo/d/d400-dg
OLD_FILES+=usr/share/terminfo/d/d410
OLD_FILES+=usr/share/terminfo/d/d410-7b
OLD_FILES+=usr/share/terminfo/d/d410-7b-w
OLD_FILES+=usr/share/terminfo/d/d410-dg
OLD_FILES+=usr/share/terminfo/d/d410-w
OLD_FILES+=usr/share/terminfo/d/d411
OLD_FILES+=usr/share/terminfo/d/d411-7b
OLD_FILES+=usr/share/terminfo/d/d411-7b-w
OLD_FILES+=usr/share/terminfo/d/d411-dg
OLD_FILES+=usr/share/terminfo/d/d411-w
OLD_FILES+=usr/share/terminfo/d/d412+
OLD_FILES+=usr/share/terminfo/d/d412+25
OLD_FILES+=usr/share/terminfo/d/d412+dg
OLD_FILES+=usr/share/terminfo/d/d412+s
OLD_FILES+=usr/share/terminfo/d/d412+sr
OLD_FILES+=usr/share/terminfo/d/d412+w
OLD_FILES+=usr/share/terminfo/d/d412-dg
OLD_FILES+=usr/share/terminfo/d/d412-unix
OLD_FILES+=usr/share/terminfo/d/d412-unix-25
OLD_FILES+=usr/share/terminfo/d/d412-unix-s
OLD_FILES+=usr/share/terminfo/d/d412-unix-sr
OLD_FILES+=usr/share/terminfo/d/d412-unix-w
OLD_FILES+=usr/share/terminfo/d/d413-dg
OLD_FILES+=usr/share/terminfo/d/d413-unix
OLD_FILES+=usr/share/terminfo/d/d413-unix-25
OLD_FILES+=usr/share/terminfo/d/d413-unix-s
OLD_FILES+=usr/share/terminfo/d/d413-unix-sr
OLD_FILES+=usr/share/terminfo/d/d413-unix-w
OLD_FILES+=usr/share/terminfo/d/d414-unix
OLD_FILES+=usr/share/terminfo/d/d414-unix-25
OLD_FILES+=usr/share/terminfo/d/d414-unix-s
OLD_FILES+=usr/share/terminfo/d/d414-unix-sr
OLD_FILES+=usr/share/terminfo/d/d414-unix-w
OLD_FILES+=usr/share/terminfo/d/d430-dg
OLD_FILES+=usr/share/terminfo/d/d430-dg-ccc
OLD_FILES+=usr/share/terminfo/d/d430-unix
OLD_FILES+=usr/share/terminfo/d/d430-unix-25
OLD_FILES+=usr/share/terminfo/d/d430-unix-25-ccc
OLD_FILES+=usr/share/terminfo/d/d430-unix-ccc
OLD_FILES+=usr/share/terminfo/d/d430-unix-s
OLD_FILES+=usr/share/terminfo/d/d430-unix-s-ccc
OLD_FILES+=usr/share/terminfo/d/d430-unix-sr
OLD_FILES+=usr/share/terminfo/d/d430-unix-sr-ccc
OLD_FILES+=usr/share/terminfo/d/d430-unix-w
OLD_FILES+=usr/share/terminfo/d/d430-unix-w-ccc
OLD_FILES+=usr/share/terminfo/d/d430c-dg
OLD_FILES+=usr/share/terminfo/d/d430c-dg-ccc
OLD_FILES+=usr/share/terminfo/d/d430c-unix
OLD_FILES+=usr/share/terminfo/d/d430c-unix-25
OLD_FILES+=usr/share/terminfo/d/d430c-unix-25-ccc
OLD_FILES+=usr/share/terminfo/d/d430c-unix-ccc
OLD_FILES+=usr/share/terminfo/d/d430c-unix-s
OLD_FILES+=usr/share/terminfo/d/d430c-unix-s-ccc
OLD_FILES+=usr/share/terminfo/d/d430c-unix-sr
OLD_FILES+=usr/share/terminfo/d/d430c-unix-sr-ccc
OLD_FILES+=usr/share/terminfo/d/d430c-unix-w
OLD_FILES+=usr/share/terminfo/d/d430c-unix-w-ccc
OLD_FILES+=usr/share/terminfo/d/d450
OLD_FILES+=usr/share/terminfo/d/d450-dg
OLD_FILES+=usr/share/terminfo/d/d460
OLD_FILES+=usr/share/terminfo/d/d460-7b
OLD_FILES+=usr/share/terminfo/d/d460-7b-w
OLD_FILES+=usr/share/terminfo/d/d460-dg
OLD_FILES+=usr/share/terminfo/d/d460-w
OLD_FILES+=usr/share/terminfo/d/d461
OLD_FILES+=usr/share/terminfo/d/d461-7b
OLD_FILES+=usr/share/terminfo/d/d461-7b-w
OLD_FILES+=usr/share/terminfo/d/d461-dg
OLD_FILES+=usr/share/terminfo/d/d461-w
OLD_FILES+=usr/share/terminfo/d/d462+
OLD_FILES+=usr/share/terminfo/d/d462+25
OLD_FILES+=usr/share/terminfo/d/d462+dg
OLD_FILES+=usr/share/terminfo/d/d462+s
OLD_FILES+=usr/share/terminfo/d/d462+sr
OLD_FILES+=usr/share/terminfo/d/d462+w
OLD_FILES+=usr/share/terminfo/d/d462-dg
OLD_FILES+=usr/share/terminfo/d/d462-unix
OLD_FILES+=usr/share/terminfo/d/d462-unix-25
OLD_FILES+=usr/share/terminfo/d/d462-unix-s
OLD_FILES+=usr/share/terminfo/d/d462-unix-sr
OLD_FILES+=usr/share/terminfo/d/d462-unix-w
OLD_FILES+=usr/share/terminfo/d/d462e-dg
OLD_FILES+=usr/share/terminfo/d/d463-dg
OLD_FILES+=usr/share/terminfo/d/d463-unix
OLD_FILES+=usr/share/terminfo/d/d463-unix-25
OLD_FILES+=usr/share/terminfo/d/d463-unix-s
OLD_FILES+=usr/share/terminfo/d/d463-unix-sr
OLD_FILES+=usr/share/terminfo/d/d463-unix-w
OLD_FILES+=usr/share/terminfo/d/d464-unix
OLD_FILES+=usr/share/terminfo/d/d464-unix-25
OLD_FILES+=usr/share/terminfo/d/d464-unix-s
OLD_FILES+=usr/share/terminfo/d/d464-unix-sr
OLD_FILES+=usr/share/terminfo/d/d464-unix-w
OLD_FILES+=usr/share/terminfo/d/d470
OLD_FILES+=usr/share/terminfo/d/d470-7b
OLD_FILES+=usr/share/terminfo/d/d470-dg
OLD_FILES+=usr/share/terminfo/d/d470c
OLD_FILES+=usr/share/terminfo/d/d470c-7b
OLD_FILES+=usr/share/terminfo/d/d470c-dg
OLD_FILES+=usr/share/terminfo/d/d555
OLD_FILES+=usr/share/terminfo/d/d555-7b
OLD_FILES+=usr/share/terminfo/d/d555-7b-w
OLD_FILES+=usr/share/terminfo/d/d555-dg
OLD_FILES+=usr/share/terminfo/d/d555-w
OLD_FILES+=usr/share/terminfo/d/d577
OLD_FILES+=usr/share/terminfo/d/d577-7b
OLD_FILES+=usr/share/terminfo/d/d577-7b-w
OLD_FILES+=usr/share/terminfo/d/d577-dg
OLD_FILES+=usr/share/terminfo/d/d577-w
OLD_FILES+=usr/share/terminfo/d/d578
OLD_FILES+=usr/share/terminfo/d/d578-7b
OLD_FILES+=usr/share/terminfo/d/d578-dg
OLD_FILES+=usr/share/terminfo/d/d80
OLD_FILES+=usr/share/terminfo/d/d800
OLD_FILES+=usr/share/terminfo/d/darwin
OLD_FILES+=usr/share/terminfo/d/darwin-100x37
OLD_FILES+=usr/share/terminfo/d/darwin-100x37-m
OLD_FILES+=usr/share/terminfo/d/darwin-112x37
OLD_FILES+=usr/share/terminfo/d/darwin-112x37-m
OLD_FILES+=usr/share/terminfo/d/darwin-128x40
OLD_FILES+=usr/share/terminfo/d/darwin-128x40-m
OLD_FILES+=usr/share/terminfo/d/darwin-128x48
OLD_FILES+=usr/share/terminfo/d/darwin-128x48-m
OLD_FILES+=usr/share/terminfo/d/darwin-144x48
OLD_FILES+=usr/share/terminfo/d/darwin-144x48-m
OLD_FILES+=usr/share/terminfo/d/darwin-160x64
OLD_FILES+=usr/share/terminfo/d/darwin-160x64-m
OLD_FILES+=usr/share/terminfo/d/darwin-200x64
OLD_FILES+=usr/share/terminfo/d/darwin-200x64-m
OLD_FILES+=usr/share/terminfo/d/darwin-200x75
OLD_FILES+=usr/share/terminfo/d/darwin-200x75-m
OLD_FILES+=usr/share/terminfo/d/darwin-256x96
OLD_FILES+=usr/share/terminfo/d/darwin-256x96-m
OLD_FILES+=usr/share/terminfo/d/darwin-80x25
OLD_FILES+=usr/share/terminfo/d/darwin-80x25-m
OLD_FILES+=usr/share/terminfo/d/darwin-80x30
OLD_FILES+=usr/share/terminfo/d/darwin-80x30-m
OLD_FILES+=usr/share/terminfo/d/darwin-90x30
OLD_FILES+=usr/share/terminfo/d/darwin-90x30-m
OLD_FILES+=usr/share/terminfo/d/darwin-b
OLD_FILES+=usr/share/terminfo/d/darwin-f
OLD_FILES+=usr/share/terminfo/d/darwin-f2
OLD_FILES+=usr/share/terminfo/d/darwin-m
OLD_FILES+=usr/share/terminfo/d/darwin-m-b
OLD_FILES+=usr/share/terminfo/d/darwin-m-f
OLD_FILES+=usr/share/terminfo/d/darwin-m-f2
OLD_FILES+=usr/share/terminfo/d/datagraphix
OLD_FILES+=usr/share/terminfo/d/datamedia2500
OLD_FILES+=usr/share/terminfo/d/datapoint
OLD_FILES+=usr/share/terminfo/d/dataspeed40
OLD_FILES+=usr/share/terminfo/d/dd5000
OLD_FILES+=usr/share/terminfo/d/ddr
OLD_FILES+=usr/share/terminfo/d/ddr3180
OLD_FILES+=usr/share/terminfo/d/dec+pp
OLD_FILES+=usr/share/terminfo/d/dec+sl
OLD_FILES+=usr/share/terminfo/d/dec-vt100
OLD_FILES+=usr/share/terminfo/d/dec-vt220
OLD_FILES+=usr/share/terminfo/d/dec-vt330
OLD_FILES+=usr/share/terminfo/d/dec-vt340
OLD_FILES+=usr/share/terminfo/d/dec-vt400
OLD_FILES+=usr/share/terminfo/d/decansi
OLD_FILES+=usr/share/terminfo/d/decpro
OLD_FILES+=usr/share/terminfo/d/decwriter
OLD_FILES+=usr/share/terminfo/d/delta
OLD_FILES+=usr/share/terminfo/d/dg+ccc
OLD_FILES+=usr/share/terminfo/d/dg+color
OLD_FILES+=usr/share/terminfo/d/dg+color8
OLD_FILES+=usr/share/terminfo/d/dg+fixed
OLD_FILES+=usr/share/terminfo/d/dg-ansi
OLD_FILES+=usr/share/terminfo/d/dg-generic
OLD_FILES+=usr/share/terminfo/d/dg100
OLD_FILES+=usr/share/terminfo/d/dg200
OLD_FILES+=usr/share/terminfo/d/dg210
OLD_FILES+=usr/share/terminfo/d/dg211
OLD_FILES+=usr/share/terminfo/d/dg450
OLD_FILES+=usr/share/terminfo/d/dg460-ansi
OLD_FILES+=usr/share/terminfo/d/dg6053
OLD_FILES+=usr/share/terminfo/d/dg6053-old
OLD_FILES+=usr/share/terminfo/d/dg605x
OLD_FILES+=usr/share/terminfo/d/dg6134
OLD_FILES+=usr/share/terminfo/d/dgkeys+11
OLD_FILES+=usr/share/terminfo/d/dgkeys+15
OLD_FILES+=usr/share/terminfo/d/dgkeys+7b
OLD_FILES+=usr/share/terminfo/d/dgkeys+8b
OLD_FILES+=usr/share/terminfo/d/dgmode+color
OLD_FILES+=usr/share/terminfo/d/dgmode+color8
OLD_FILES+=usr/share/terminfo/d/dgunix+ccc
OLD_FILES+=usr/share/terminfo/d/dgunix+fixed
OLD_FILES+=usr/share/terminfo/d/diablo
OLD_FILES+=usr/share/terminfo/d/diablo-lm
OLD_FILES+=usr/share/terminfo/d/diablo1620
OLD_FILES+=usr/share/terminfo/d/diablo1620-m8
OLD_FILES+=usr/share/terminfo/d/diablo1640
OLD_FILES+=usr/share/terminfo/d/diablo1640-lm
OLD_FILES+=usr/share/terminfo/d/diablo1640-m8
OLD_FILES+=usr/share/terminfo/d/diablo1720
OLD_FILES+=usr/share/terminfo/d/diablo1730
OLD_FILES+=usr/share/terminfo/d/diablo1740
OLD_FILES+=usr/share/terminfo/d/diablo1740-lm
OLD_FILES+=usr/share/terminfo/d/diablo450
OLD_FILES+=usr/share/terminfo/d/diablo630
OLD_FILES+=usr/share/terminfo/d/dialogue
OLD_FILES+=usr/share/terminfo/d/dialogue80
OLD_FILES+=usr/share/terminfo/d/digilog
OLD_FILES+=usr/share/terminfo/d/djgpp
OLD_FILES+=usr/share/terminfo/d/djgpp203
OLD_FILES+=usr/share/terminfo/d/djgpp204
OLD_FILES+=usr/share/terminfo/d/dku7003
OLD_FILES+=usr/share/terminfo/d/dku7003-dumb
OLD_FILES+=usr/share/terminfo/d/dku7102
OLD_FILES+=usr/share/terminfo/d/dku7102-old
OLD_FILES+=usr/share/terminfo/d/dku7102-sna
OLD_FILES+=usr/share/terminfo/d/dku7103-sna
OLD_FILES+=usr/share/terminfo/d/dku7202
OLD_FILES+=usr/share/terminfo/d/dm1520
OLD_FILES+=usr/share/terminfo/d/dm1521
OLD_FILES+=usr/share/terminfo/d/dm2500
OLD_FILES+=usr/share/terminfo/d/dm3025
OLD_FILES+=usr/share/terminfo/d/dm3045
OLD_FILES+=usr/share/terminfo/d/dm80
OLD_FILES+=usr/share/terminfo/d/dm80w
OLD_FILES+=usr/share/terminfo/d/dmchat
OLD_FILES+=usr/share/terminfo/d/dmd
OLD_FILES+=usr/share/terminfo/d/dmd-24
OLD_FILES+=usr/share/terminfo/d/dmd-34
OLD_FILES+=usr/share/terminfo/d/dmd1
OLD_FILES+=usr/share/terminfo/d/dmdt80
OLD_FILES+=usr/share/terminfo/d/dmdt80w
OLD_FILES+=usr/share/terminfo/d/dmterm
OLD_FILES+=usr/share/terminfo/d/domterm
OLD_FILES+=usr/share/terminfo/d/dp3360
OLD_FILES+=usr/share/terminfo/d/dp8242
OLD_FILES+=usr/share/terminfo/d/ds40
OLD_FILES+=usr/share/terminfo/d/ds40-2
OLD_FILES+=usr/share/terminfo/d/dt-100
OLD_FILES+=usr/share/terminfo/d/dt-100w
OLD_FILES+=usr/share/terminfo/d/dt100
OLD_FILES+=usr/share/terminfo/d/dt100w
OLD_FILES+=usr/share/terminfo/d/dt110
OLD_FILES+=usr/share/terminfo/d/dt80
OLD_FILES+=usr/share/terminfo/d/dt80-sas
OLD_FILES+=usr/share/terminfo/d/dt80w
OLD_FILES+=usr/share/terminfo/d/dtc300s
OLD_FILES+=usr/share/terminfo/d/dtc382
OLD_FILES+=usr/share/terminfo/d/dtterm
OLD_FILES+=usr/share/terminfo/d/dumb
OLD_FILES+=usr/share/terminfo/d/dumb-emacs-ansi
OLD_FILES+=usr/share/terminfo/d/dvtm
OLD_FILES+=usr/share/terminfo/d/dvtm-256color
OLD_FILES+=usr/share/terminfo/d/dw
OLD_FILES+=usr/share/terminfo/d/dw1
OLD_FILES+=usr/share/terminfo/d/dw2
OLD_FILES+=usr/share/terminfo/d/dw3
OLD_FILES+=usr/share/terminfo/d/dw4
OLD_FILES+=usr/share/terminfo/d/dwk
OLD_FILES+=usr/share/terminfo/d/dwk-vt
OLD_DIRS+=usr/share/terminfo/d/
OLD_FILES+=usr/share/terminfo/e/ecma+color
OLD_FILES+=usr/share/terminfo/e/ecma+index
OLD_FILES+=usr/share/terminfo/e/ecma+italics
OLD_FILES+=usr/share/terminfo/e/ecma+sgr
OLD_FILES+=usr/share/terminfo/e/ecma+strikeout
OLD_FILES+=usr/share/terminfo/e/elks
OLD_FILES+=usr/share/terminfo/e/elks-ansi
OLD_FILES+=usr/share/terminfo/e/elks-glasstty
OLD_FILES+=usr/share/terminfo/e/elks-vt52
OLD_FILES+=usr/share/terminfo/e/emots
OLD_FILES+=usr/share/terminfo/e/emu
OLD_FILES+=usr/share/terminfo/e/emu-220
OLD_FILES+=usr/share/terminfo/e/emx-base
OLD_FILES+=usr/share/terminfo/e/env230
OLD_FILES+=usr/share/terminfo/e/envision230
OLD_FILES+=usr/share/terminfo/e/ep40
OLD_FILES+=usr/share/terminfo/e/ep4000
OLD_FILES+=usr/share/terminfo/e/ep4080
OLD_FILES+=usr/share/terminfo/e/ep48
OLD_FILES+=usr/share/terminfo/e/ergo4000
OLD_FILES+=usr/share/terminfo/e/esprit
OLD_FILES+=usr/share/terminfo/e/esprit-am
OLD_FILES+=usr/share/terminfo/e/eterm
OLD_FILES+=usr/share/terminfo/e/eterm-color
OLD_FILES+=usr/share/terminfo/e/ex155
OLD_FILES+=usr/share/terminfo/e/excel62
OLD_FILES+=usr/share/terminfo/e/excel62-rv
OLD_FILES+=usr/share/terminfo/e/excel62-w
OLD_FILES+=usr/share/terminfo/e/excel64
OLD_FILES+=usr/share/terminfo/e/excel64-rv
OLD_FILES+=usr/share/terminfo/e/excel64-w
OLD_FILES+=usr/share/terminfo/e/exec80
OLD_DIRS+=usr/share/terminfo/e/
OLD_FILES+=usr/share/terminfo/f/f100
OLD_FILES+=usr/share/terminfo/f/f100-rv
OLD_FILES+=usr/share/terminfo/f/f110
OLD_FILES+=usr/share/terminfo/f/f110-14
OLD_FILES+=usr/share/terminfo/f/f110-14w
OLD_FILES+=usr/share/terminfo/f/f110-w
OLD_FILES+=usr/share/terminfo/f/f1720
OLD_FILES+=usr/share/terminfo/f/f1720a
OLD_FILES+=usr/share/terminfo/f/f200
OLD_FILES+=usr/share/terminfo/f/f200-w
OLD_FILES+=usr/share/terminfo/f/f200vi
OLD_FILES+=usr/share/terminfo/f/f200vi-w
OLD_FILES+=usr/share/terminfo/f/falco
OLD_FILES+=usr/share/terminfo/f/falco-p
OLD_FILES+=usr/share/terminfo/f/fbterm
OLD_FILES+=usr/share/terminfo/f/fenix
OLD_FILES+=usr/share/terminfo/f/fenixw
OLD_FILES+=usr/share/terminfo/f/fixterm
OLD_FILES+=usr/share/terminfo/f/fortune
OLD_FILES+=usr/share/terminfo/f/fos
OLD_FILES+=usr/share/terminfo/f/fox
OLD_FILES+=usr/share/terminfo/f/freedom
OLD_FILES+=usr/share/terminfo/f/freedom-rv
OLD_FILES+=usr/share/terminfo/f/freedom100
OLD_FILES+=usr/share/terminfo/f/freedom110
OLD_FILES+=usr/share/terminfo/f/freedom200
OLD_DIRS+=usr/share/terminfo/f/
OLD_FILES+=usr/share/terminfo/g/gator
OLD_FILES+=usr/share/terminfo/g/gator-52
OLD_FILES+=usr/share/terminfo/g/gator-52t
OLD_FILES+=usr/share/terminfo/g/gator-t
OLD_FILES+=usr/share/terminfo/g/gigi
OLD_FILES+=usr/share/terminfo/g/glasstty
OLD_FILES+=usr/share/terminfo/g/gnome
OLD_FILES+=usr/share/terminfo/g/gnome+pcfkeys
OLD_FILES+=usr/share/terminfo/g/gnome-2007
OLD_FILES+=usr/share/terminfo/g/gnome-2008
OLD_FILES+=usr/share/terminfo/g/gnome-2012
OLD_FILES+=usr/share/terminfo/g/gnome-256color
OLD_FILES+=usr/share/terminfo/g/gnome-fc5
OLD_FILES+=usr/share/terminfo/g/gnome-rh62
OLD_FILES+=usr/share/terminfo/g/gnome-rh72
OLD_FILES+=usr/share/terminfo/g/gnome-rh80
OLD_FILES+=usr/share/terminfo/g/gnome-rh90
OLD_FILES+=usr/share/terminfo/g/go-225
OLD_FILES+=usr/share/terminfo/g/go140
OLD_FILES+=usr/share/terminfo/g/go140w
OLD_FILES+=usr/share/terminfo/g/go225
OLD_FILES+=usr/share/terminfo/g/graphos
OLD_FILES+=usr/share/terminfo/g/graphos-30
OLD_FILES+=usr/share/terminfo/g/gs5430
OLD_FILES+=usr/share/terminfo/g/gs5430-22
OLD_FILES+=usr/share/terminfo/g/gs5430-24
OLD_FILES+=usr/share/terminfo/g/gs6300
OLD_FILES+=usr/share/terminfo/g/gsi
OLD_FILES+=usr/share/terminfo/g/gt100
OLD_FILES+=usr/share/terminfo/g/gt100a
OLD_FILES+=usr/share/terminfo/g/gt40
OLD_FILES+=usr/share/terminfo/g/gt42
OLD_FILES+=usr/share/terminfo/g/guru
OLD_FILES+=usr/share/terminfo/g/guru+rv
OLD_FILES+=usr/share/terminfo/g/guru+s
OLD_FILES+=usr/share/terminfo/g/guru+unk
OLD_FILES+=usr/share/terminfo/g/guru-24
OLD_FILES+=usr/share/terminfo/g/guru-33
OLD_FILES+=usr/share/terminfo/g/guru-33-rv
OLD_FILES+=usr/share/terminfo/g/guru-33-s
OLD_FILES+=usr/share/terminfo/g/guru-44
OLD_FILES+=usr/share/terminfo/g/guru-44-s
OLD_FILES+=usr/share/terminfo/g/guru-76
OLD_FILES+=usr/share/terminfo/g/guru-76-lp
OLD_FILES+=usr/share/terminfo/g/guru-76-s
OLD_FILES+=usr/share/terminfo/g/guru-76-w
OLD_FILES+=usr/share/terminfo/g/guru-76-w-s
OLD_FILES+=usr/share/terminfo/g/guru-76-wm
OLD_FILES+=usr/share/terminfo/g/guru-lp
OLD_FILES+=usr/share/terminfo/g/guru-nctxt
OLD_FILES+=usr/share/terminfo/g/guru-rv
OLD_FILES+=usr/share/terminfo/g/guru-s
OLD_DIRS+=usr/share/terminfo/g/
OLD_FILES+=usr/share/terminfo/h/h-100
OLD_FILES+=usr/share/terminfo/h/h-100bw
OLD_FILES+=usr/share/terminfo/h/h100
OLD_FILES+=usr/share/terminfo/h/h100bw
OLD_FILES+=usr/share/terminfo/h/h19
OLD_FILES+=usr/share/terminfo/h/h19-a
OLD_FILES+=usr/share/terminfo/h/h19-b
OLD_FILES+=usr/share/terminfo/h/h19-bs
OLD_FILES+=usr/share/terminfo/h/h19-g
OLD_FILES+=usr/share/terminfo/h/h19-smul
OLD_FILES+=usr/share/terminfo/h/h19-u
OLD_FILES+=usr/share/terminfo/h/h19-us
OLD_FILES+=usr/share/terminfo/h/h19a
OLD_FILES+=usr/share/terminfo/h/h19g
OLD_FILES+=usr/share/terminfo/h/h19k
OLD_FILES+=usr/share/terminfo/h/h19kermit
OLD_FILES+=usr/share/terminfo/h/h19us
OLD_FILES+=usr/share/terminfo/h/h29a-kc-bc
OLD_FILES+=usr/share/terminfo/h/h29a-kc-uc
OLD_FILES+=usr/share/terminfo/h/h29a-nkc-bc
OLD_FILES+=usr/share/terminfo/h/h29a-nkc-uc
OLD_FILES+=usr/share/terminfo/h/h80
OLD_FILES+=usr/share/terminfo/h/ha8675
OLD_FILES+=usr/share/terminfo/h/ha8686
OLD_FILES+=usr/share/terminfo/h/hazel
OLD_FILES+=usr/share/terminfo/h/hds200
OLD_FILES+=usr/share/terminfo/h/he80
OLD_FILES+=usr/share/terminfo/h/heath
OLD_FILES+=usr/share/terminfo/h/heath-19
OLD_FILES+=usr/share/terminfo/h/heath-ansi
OLD_FILES+=usr/share/terminfo/h/heathkit
OLD_FILES+=usr/share/terminfo/h/heathkit-a
OLD_FILES+=usr/share/terminfo/h/hft
OLD_FILES+=usr/share/terminfo/h/hft-c
OLD_FILES+=usr/share/terminfo/h/hft-c-old
OLD_FILES+=usr/share/terminfo/h/hft-old
OLD_FILES+=usr/share/terminfo/h/hirez100
OLD_FILES+=usr/share/terminfo/h/hirez100-w
OLD_FILES+=usr/share/terminfo/h/hmod1
OLD_FILES+=usr/share/terminfo/h/hp
OLD_FILES+=usr/share/terminfo/h/hp+arrows
OLD_FILES+=usr/share/terminfo/h/hp+color
OLD_FILES+=usr/share/terminfo/h/hp+labels
OLD_FILES+=usr/share/terminfo/h/hp+pfk+arrows
OLD_FILES+=usr/share/terminfo/h/hp+pfk+cr
OLD_FILES+=usr/share/terminfo/h/hp+pfk-cr
OLD_FILES+=usr/share/terminfo/h/hp+printer
OLD_FILES+=usr/share/terminfo/h/hp110
OLD_FILES+=usr/share/terminfo/h/hp150
OLD_FILES+=usr/share/terminfo/h/hp2
OLD_FILES+=usr/share/terminfo/h/hp236
OLD_FILES+=usr/share/terminfo/h/hp2382
OLD_FILES+=usr/share/terminfo/h/hp2382a
OLD_FILES+=usr/share/terminfo/h/hp2392
OLD_FILES+=usr/share/terminfo/h/hp2397
OLD_FILES+=usr/share/terminfo/h/hp2397a
OLD_FILES+=usr/share/terminfo/h/hp2621
OLD_FILES+=usr/share/terminfo/h/hp2621-48
OLD_FILES+=usr/share/terminfo/h/hp2621-a
OLD_FILES+=usr/share/terminfo/h/hp2621-ba
OLD_FILES+=usr/share/terminfo/h/hp2621-fl
OLD_FILES+=usr/share/terminfo/h/hp2621-k45
OLD_FILES+=usr/share/terminfo/h/hp2621-nl
OLD_FILES+=usr/share/terminfo/h/hp2621-nt
OLD_FILES+=usr/share/terminfo/h/hp2621-wl
OLD_FILES+=usr/share/terminfo/h/hp2621A
OLD_FILES+=usr/share/terminfo/h/hp2621a
OLD_FILES+=usr/share/terminfo/h/hp2621a-a
OLD_FILES+=usr/share/terminfo/h/hp2621b
OLD_FILES+=usr/share/terminfo/h/hp2621b-kx
OLD_FILES+=usr/share/terminfo/h/hp2621b-kx-p
OLD_FILES+=usr/share/terminfo/h/hp2621b-p
OLD_FILES+=usr/share/terminfo/h/hp2621k45
OLD_FILES+=usr/share/terminfo/h/hp2621p
OLD_FILES+=usr/share/terminfo/h/hp2621p-a
OLD_FILES+=usr/share/terminfo/h/hp2622
OLD_FILES+=usr/share/terminfo/h/hp2622a
OLD_FILES+=usr/share/terminfo/h/hp2623
OLD_FILES+=usr/share/terminfo/h/hp2623a
OLD_FILES+=usr/share/terminfo/h/hp2624
OLD_FILES+=usr/share/terminfo/h/hp2624-10p
OLD_FILES+=usr/share/terminfo/h/hp2624a
OLD_FILES+=usr/share/terminfo/h/hp2624a-10p
OLD_FILES+=usr/share/terminfo/h/hp2624b
OLD_FILES+=usr/share/terminfo/h/hp2624b-10p
OLD_FILES+=usr/share/terminfo/h/hp2624b-10p-p
OLD_FILES+=usr/share/terminfo/h/hp2624b-4p
OLD_FILES+=usr/share/terminfo/h/hp2624b-4p-p
OLD_FILES+=usr/share/terminfo/h/hp2624b-p
OLD_FILES+=usr/share/terminfo/h/hp2626
OLD_FILES+=usr/share/terminfo/h/hp2626-12
OLD_FILES+=usr/share/terminfo/h/hp2626-12-s
OLD_FILES+=usr/share/terminfo/h/hp2626-12x40
OLD_FILES+=usr/share/terminfo/h/hp2626-ns
OLD_FILES+=usr/share/terminfo/h/hp2626-s
OLD_FILES+=usr/share/terminfo/h/hp2626-x40
OLD_FILES+=usr/share/terminfo/h/hp2626a
OLD_FILES+=usr/share/terminfo/h/hp2626p
OLD_FILES+=usr/share/terminfo/h/hp2627a
OLD_FILES+=usr/share/terminfo/h/hp2627a-rev
OLD_FILES+=usr/share/terminfo/h/hp2627c
OLD_FILES+=usr/share/terminfo/h/hp262x
OLD_FILES+=usr/share/terminfo/h/hp2640a
OLD_FILES+=usr/share/terminfo/h/hp2640b
OLD_FILES+=usr/share/terminfo/h/hp2641a
OLD_FILES+=usr/share/terminfo/h/hp2644a
OLD_FILES+=usr/share/terminfo/h/hp2645
OLD_FILES+=usr/share/terminfo/h/hp2645a
OLD_FILES+=usr/share/terminfo/h/hp2647a
OLD_FILES+=usr/share/terminfo/h/hp2648
OLD_FILES+=usr/share/terminfo/h/hp2648a
OLD_FILES+=usr/share/terminfo/h/hp300h
OLD_FILES+=usr/share/terminfo/h/hp45
OLD_FILES+=usr/share/terminfo/h/hp700
OLD_FILES+=usr/share/terminfo/h/hp700-wy
OLD_FILES+=usr/share/terminfo/h/hp70092
OLD_FILES+=usr/share/terminfo/h/hp70092A
OLD_FILES+=usr/share/terminfo/h/hp70092a
OLD_FILES+=usr/share/terminfo/h/hp9837
OLD_FILES+=usr/share/terminfo/h/hp9845
OLD_FILES+=usr/share/terminfo/h/hp98550
OLD_FILES+=usr/share/terminfo/h/hp98550a
OLD_FILES+=usr/share/terminfo/h/hp98720
OLD_FILES+=usr/share/terminfo/h/hp98721
OLD_FILES+=usr/share/terminfo/h/hpansi
OLD_FILES+=usr/share/terminfo/h/hpex
OLD_FILES+=usr/share/terminfo/h/hpex2
OLD_FILES+=usr/share/terminfo/h/hpgeneric
OLD_FILES+=usr/share/terminfo/h/hpsub
OLD_FILES+=usr/share/terminfo/h/hpterm
OLD_FILES+=usr/share/terminfo/h/hpterm-color
OLD_FILES+=usr/share/terminfo/h/htx11
OLD_FILES+=usr/share/terminfo/h/hurd
OLD_FILES+=usr/share/terminfo/h/hz1000
OLD_FILES+=usr/share/terminfo/h/hz1420
OLD_FILES+=usr/share/terminfo/h/hz1500
OLD_FILES+=usr/share/terminfo/h/hz1510
OLD_FILES+=usr/share/terminfo/h/hz1520
OLD_FILES+=usr/share/terminfo/h/hz1520-noesc
OLD_FILES+=usr/share/terminfo/h/hz1552
OLD_FILES+=usr/share/terminfo/h/hz1552-rv
OLD_FILES+=usr/share/terminfo/h/hz2000
OLD_DIRS+=usr/share/terminfo/h/
OLD_FILES+=usr/share/terminfo/i/i100
OLD_FILES+=usr/share/terminfo/i/i3101
OLD_FILES+=usr/share/terminfo/i/i3164
OLD_FILES+=usr/share/terminfo/i/i400
OLD_FILES+=usr/share/terminfo/i/iTerm.app
OLD_FILES+=usr/share/terminfo/i/iTerm2.app
OLD_FILES+=usr/share/terminfo/i/ibcs2
OLD_FILES+=usr/share/terminfo/i/ibm+16color
OLD_FILES+=usr/share/terminfo/i/ibm+color
OLD_FILES+=usr/share/terminfo/i/ibm-apl
OLD_FILES+=usr/share/terminfo/i/ibm-pc
OLD_FILES+=usr/share/terminfo/i/ibm-system1
OLD_FILES+=usr/share/terminfo/i/ibm3101
OLD_FILES+=usr/share/terminfo/i/ibm3151
OLD_FILES+=usr/share/terminfo/i/ibm3161
OLD_FILES+=usr/share/terminfo/i/ibm3161-C
OLD_FILES+=usr/share/terminfo/i/ibm3162
OLD_FILES+=usr/share/terminfo/i/ibm3163
OLD_FILES+=usr/share/terminfo/i/ibm3164
OLD_FILES+=usr/share/terminfo/i/ibm327x
OLD_FILES+=usr/share/terminfo/i/ibm5051
OLD_FILES+=usr/share/terminfo/i/ibm5081
OLD_FILES+=usr/share/terminfo/i/ibm5081-c
OLD_FILES+=usr/share/terminfo/i/ibm5151
OLD_FILES+=usr/share/terminfo/i/ibm5154
OLD_FILES+=usr/share/terminfo/i/ibm5154-c
OLD_FILES+=usr/share/terminfo/i/ibm6153
OLD_FILES+=usr/share/terminfo/i/ibm6153-40
OLD_FILES+=usr/share/terminfo/i/ibm6153-90
OLD_FILES+=usr/share/terminfo/i/ibm6154
OLD_FILES+=usr/share/terminfo/i/ibm6154-c
OLD_FILES+=usr/share/terminfo/i/ibm6155
OLD_FILES+=usr/share/terminfo/i/ibm8503
OLD_FILES+=usr/share/terminfo/i/ibm8507
OLD_FILES+=usr/share/terminfo/i/ibm8512
OLD_FILES+=usr/share/terminfo/i/ibm8513
OLD_FILES+=usr/share/terminfo/i/ibm8514
OLD_FILES+=usr/share/terminfo/i/ibm8514-c
OLD_FILES+=usr/share/terminfo/i/ibm8604
OLD_FILES+=usr/share/terminfo/i/ibmaed
OLD_FILES+=usr/share/terminfo/i/ibmapa16
OLD_FILES+=usr/share/terminfo/i/ibmapa8
OLD_FILES+=usr/share/terminfo/i/ibmapa8c
OLD_FILES+=usr/share/terminfo/i/ibmapa8c-c
OLD_FILES+=usr/share/terminfo/i/ibmega
OLD_FILES+=usr/share/terminfo/i/ibmega-c
OLD_FILES+=usr/share/terminfo/i/ibmmono
OLD_FILES+=usr/share/terminfo/i/ibmmpel-c
OLD_FILES+=usr/share/terminfo/i/ibmpc
OLD_FILES+=usr/share/terminfo/i/ibmpc3
OLD_FILES+=usr/share/terminfo/i/ibmpc3r
OLD_FILES+=usr/share/terminfo/i/ibmpc3r-mono
OLD_FILES+=usr/share/terminfo/i/ibmpcx
OLD_FILES+=usr/share/terminfo/i/ibmvga
OLD_FILES+=usr/share/terminfo/i/ibmvga-c
OLD_FILES+=usr/share/terminfo/i/ibmx
OLD_FILES+=usr/share/terminfo/i/icl6402
OLD_FILES+=usr/share/terminfo/i/icl6404
OLD_FILES+=usr/share/terminfo/i/icl6404-w
OLD_FILES+=usr/share/terminfo/i/ifmr
OLD_FILES+=usr/share/terminfo/i/ims-ansi
OLD_FILES+=usr/share/terminfo/i/ims950
OLD_FILES+=usr/share/terminfo/i/ims950-b
OLD_FILES+=usr/share/terminfo/i/ims950-rv
OLD_FILES+=usr/share/terminfo/i/infoton
OLD_FILES+=usr/share/terminfo/i/interix
OLD_FILES+=usr/share/terminfo/i/interix-nti
OLD_FILES+=usr/share/terminfo/i/intertec
OLD_FILES+=usr/share/terminfo/i/intertube
OLD_FILES+=usr/share/terminfo/i/intertube2
OLD_FILES+=usr/share/terminfo/i/intext
OLD_FILES+=usr/share/terminfo/i/intext2
OLD_FILES+=usr/share/terminfo/i/intextii
OLD_FILES+=usr/share/terminfo/i/ips
OLD_FILES+=usr/share/terminfo/i/ipsi
OLD_FILES+=usr/share/terminfo/i/iq120
OLD_FILES+=usr/share/terminfo/i/iq140
OLD_FILES+=usr/share/terminfo/i/iris-ansi
OLD_FILES+=usr/share/terminfo/i/iris-ansi-ap
OLD_FILES+=usr/share/terminfo/i/iris-ansi-net
OLD_FILES+=usr/share/terminfo/i/iris-color
OLD_FILES+=usr/share/terminfo/i/iris40
OLD_FILES+=usr/share/terminfo/i/iterm
OLD_FILES+=usr/share/terminfo/i/iterm2
OLD_FILES+=usr/share/terminfo/i/iterm2-direct
OLD_DIRS+=usr/share/terminfo/i/
OLD_FILES+=usr/share/terminfo/j/jaixterm
OLD_FILES+=usr/share/terminfo/j/jaixterm-m
OLD_FILES+=usr/share/terminfo/j/jerq
OLD_FILES+=usr/share/terminfo/j/jfbterm
OLD_DIRS+=usr/share/terminfo/j/
OLD_FILES+=usr/share/terminfo/k/k45
OLD_FILES+=usr/share/terminfo/k/kaypro
OLD_FILES+=usr/share/terminfo/k/kaypro2
OLD_FILES+=usr/share/terminfo/k/kds6402
OLD_FILES+=usr/share/terminfo/k/kds7372
OLD_FILES+=usr/share/terminfo/k/kds7372-w
OLD_FILES+=usr/share/terminfo/k/kermit
OLD_FILES+=usr/share/terminfo/k/kermit-am
OLD_FILES+=usr/share/terminfo/k/kitty
OLD_FILES+=usr/share/terminfo/k/kitty+common
OLD_FILES+=usr/share/terminfo/k/kitty-direct
OLD_FILES+=usr/share/terminfo/k/klone+acs
OLD_FILES+=usr/share/terminfo/k/klone+color
OLD_FILES+=usr/share/terminfo/k/klone+koi8acs
OLD_FILES+=usr/share/terminfo/k/klone+sgr
OLD_FILES+=usr/share/terminfo/k/klone+sgr-dumb
OLD_FILES+=usr/share/terminfo/k/klone+sgr8
OLD_FILES+=usr/share/terminfo/k/kon
OLD_FILES+=usr/share/terminfo/k/kon2
OLD_FILES+=usr/share/terminfo/k/konsole
OLD_FILES+=usr/share/terminfo/k/konsole+pcfkeys
OLD_FILES+=usr/share/terminfo/k/konsole-16color
OLD_FILES+=usr/share/terminfo/k/konsole-256color
OLD_FILES+=usr/share/terminfo/k/konsole-base
OLD_FILES+=usr/share/terminfo/k/konsole-direct
OLD_FILES+=usr/share/terminfo/k/konsole-linux
OLD_FILES+=usr/share/terminfo/k/konsole-solaris
OLD_FILES+=usr/share/terminfo/k/konsole-vt100
OLD_FILES+=usr/share/terminfo/k/konsole-vt420pc
OLD_FILES+=usr/share/terminfo/k/konsole-xf3x
OLD_FILES+=usr/share/terminfo/k/konsole-xf4x
OLD_FILES+=usr/share/terminfo/k/kt7
OLD_FILES+=usr/share/terminfo/k/kt7ix
OLD_FILES+=usr/share/terminfo/k/kterm
OLD_FILES+=usr/share/terminfo/k/kterm-co
OLD_FILES+=usr/share/terminfo/k/kterm-color
OLD_FILES+=usr/share/terminfo/k/ktm
OLD_FILES+=usr/share/terminfo/k/kvt
OLD_DIRS+=usr/share/terminfo/k/
OLD_FILES+=usr/share/terminfo/l/la120
OLD_FILES+=usr/share/terminfo/l/layer
OLD_FILES+=usr/share/terminfo/l/lft
OLD_FILES+=usr/share/terminfo/l/lft-pc850
OLD_FILES+=usr/share/terminfo/l/linux
OLD_FILES+=usr/share/terminfo/l/linux+decid
OLD_FILES+=usr/share/terminfo/l/linux+sfkeys
OLD_FILES+=usr/share/terminfo/l/linux-16color
OLD_FILES+=usr/share/terminfo/l/linux-basic
OLD_FILES+=usr/share/terminfo/l/linux-c
OLD_FILES+=usr/share/terminfo/l/linux-c-nc
OLD_FILES+=usr/share/terminfo/l/linux-koi8
OLD_FILES+=usr/share/terminfo/l/linux-koi8r
OLD_FILES+=usr/share/terminfo/l/linux-lat
OLD_FILES+=usr/share/terminfo/l/linux-m
OLD_FILES+=usr/share/terminfo/l/linux-m1
OLD_FILES+=usr/share/terminfo/l/linux-m1b
OLD_FILES+=usr/share/terminfo/l/linux-m2
OLD_FILES+=usr/share/terminfo/l/linux-nic
OLD_FILES+=usr/share/terminfo/l/linux-s
OLD_FILES+=usr/share/terminfo/l/linux-vt
OLD_FILES+=usr/share/terminfo/l/linux2.2
OLD_FILES+=usr/share/terminfo/l/linux2.6
OLD_FILES+=usr/share/terminfo/l/linux2.6.26
OLD_FILES+=usr/share/terminfo/l/linux3.0
OLD_FILES+=usr/share/terminfo/l/lisa
OLD_FILES+=usr/share/terminfo/l/lisaterm
OLD_FILES+=usr/share/terminfo/l/lisaterm-w
OLD_FILES+=usr/share/terminfo/l/liswb
OLD_FILES+=usr/share/terminfo/l/ln03
OLD_FILES+=usr/share/terminfo/l/ln03-w
OLD_FILES+=usr/share/terminfo/l/lpr
OLD_FILES+=usr/share/terminfo/l/luna
OLD_FILES+=usr/share/terminfo/l/luna68k
OLD_DIRS+=usr/share/terminfo/l/
OLD_FILES+=usr/share/terminfo/m/m2-nam
OLD_FILES+=usr/share/terminfo/m/mac
OLD_FILES+=usr/share/terminfo/m/mac-w
OLD_FILES+=usr/share/terminfo/m/mach
OLD_FILES+=usr/share/terminfo/m/mach-bold
OLD_FILES+=usr/share/terminfo/m/mach-color
OLD_FILES+=usr/share/terminfo/m/mach-gnu
OLD_FILES+=usr/share/terminfo/m/mach-gnu-color
OLD_FILES+=usr/share/terminfo/m/macintosh
OLD_FILES+=usr/share/terminfo/m/macterminal-w
OLD_FILES+=usr/share/terminfo/m/mai
OLD_FILES+=usr/share/terminfo/m/masscomp
OLD_FILES+=usr/share/terminfo/m/masscomp1
OLD_FILES+=usr/share/terminfo/m/masscomp2
OLD_FILES+=usr/share/terminfo/m/mdl110
OLD_FILES+=usr/share/terminfo/m/megatek
OLD_FILES+=usr/share/terminfo/m/memhp
OLD_FILES+=usr/share/terminfo/m/mgr
OLD_FILES+=usr/share/terminfo/m/mgr-linux
OLD_FILES+=usr/share/terminfo/m/mgr-sun
OLD_FILES+=usr/share/terminfo/m/mgt
OLD_FILES+=usr/share/terminfo/m/mgterm
OLD_FILES+=usr/share/terminfo/m/microb
OLD_FILES+=usr/share/terminfo/m/microbee
OLD_FILES+=usr/share/terminfo/m/microterm
OLD_FILES+=usr/share/terminfo/m/microterm5
OLD_FILES+=usr/share/terminfo/m/mime
OLD_FILES+=usr/share/terminfo/m/mime-3ax
OLD_FILES+=usr/share/terminfo/m/mime-fb
OLD_FILES+=usr/share/terminfo/m/mime-hb
OLD_FILES+=usr/share/terminfo/m/mime1
OLD_FILES+=usr/share/terminfo/m/mime2
OLD_FILES+=usr/share/terminfo/m/mime2a
OLD_FILES+=usr/share/terminfo/m/mime2a-s
OLD_FILES+=usr/share/terminfo/m/mime2a-v
OLD_FILES+=usr/share/terminfo/m/mime314
OLD_FILES+=usr/share/terminfo/m/mime340
OLD_FILES+=usr/share/terminfo/m/mime3a
OLD_FILES+=usr/share/terminfo/m/mime3ax
OLD_FILES+=usr/share/terminfo/m/mimei
OLD_FILES+=usr/share/terminfo/m/mimeii
OLD_FILES+=usr/share/terminfo/m/minitel
OLD_FILES+=usr/share/terminfo/m/minitel-2
OLD_FILES+=usr/share/terminfo/m/minitel-2-nam
OLD_FILES+=usr/share/terminfo/m/minitel1
OLD_FILES+=usr/share/terminfo/m/minitel1-nb
OLD_FILES+=usr/share/terminfo/m/minitel12-80
OLD_FILES+=usr/share/terminfo/m/minitel1b
OLD_FILES+=usr/share/terminfo/m/minitel1b-80
OLD_FILES+=usr/share/terminfo/m/minitel1b-nb
OLD_FILES+=usr/share/terminfo/m/minitel2-80
OLD_FILES+=usr/share/terminfo/m/minix
OLD_FILES+=usr/share/terminfo/m/minix-1.5
OLD_FILES+=usr/share/terminfo/m/minix-1.7
OLD_FILES+=usr/share/terminfo/m/minix-3.0
OLD_FILES+=usr/share/terminfo/m/minix-old
OLD_FILES+=usr/share/terminfo/m/minix-old-am
OLD_FILES+=usr/share/terminfo/m/mintty
OLD_FILES+=usr/share/terminfo/m/mintty+common
OLD_FILES+=usr/share/terminfo/m/mintty-direct
OLD_FILES+=usr/share/terminfo/m/mlterm
OLD_FILES+=usr/share/terminfo/m/mlterm+pcfkeys
OLD_FILES+=usr/share/terminfo/m/mlterm-256color
OLD_FILES+=usr/share/terminfo/m/mlterm-direct
OLD_FILES+=usr/share/terminfo/m/mlterm2
OLD_FILES+=usr/share/terminfo/m/mlterm3
OLD_FILES+=usr/share/terminfo/m/mm314
OLD_FILES+=usr/share/terminfo/m/mm340
OLD_FILES+=usr/share/terminfo/m/mod
OLD_FILES+=usr/share/terminfo/m/mod24
OLD_FILES+=usr/share/terminfo/m/modgraph
OLD_FILES+=usr/share/terminfo/m/modgraph2
OLD_FILES+=usr/share/terminfo/m/modgraph48
OLD_FILES+=usr/share/terminfo/m/mono-emx
OLD_FILES+=usr/share/terminfo/m/morphos
OLD_FILES+=usr/share/terminfo/m/mouse-sun
OLD_FILES+=usr/share/terminfo/m/mrxvt
OLD_FILES+=usr/share/terminfo/m/mrxvt-256color
OLD_FILES+=usr/share/terminfo/m/ms-terminal
OLD_FILES+=usr/share/terminfo/m/ms-vt-utf8
OLD_FILES+=usr/share/terminfo/m/ms-vt100
OLD_FILES+=usr/share/terminfo/m/ms-vt100+
OLD_FILES+=usr/share/terminfo/m/ms-vt100-color
OLD_FILES+=usr/share/terminfo/m/msk227
OLD_FILES+=usr/share/terminfo/m/msk22714
OLD_FILES+=usr/share/terminfo/m/msk227am
OLD_FILES+=usr/share/terminfo/m/mskermit227
OLD_FILES+=usr/share/terminfo/m/mskermit22714
OLD_FILES+=usr/share/terminfo/m/mskermit227am
OLD_FILES+=usr/share/terminfo/m/mt-70
OLD_FILES+=usr/share/terminfo/m/mt4520-rv
OLD_FILES+=usr/share/terminfo/m/mt70
OLD_FILES+=usr/share/terminfo/m/mterm
OLD_FILES+=usr/share/terminfo/m/mterm-ansi
OLD_FILES+=usr/share/terminfo/m/mvterm
OLD_DIRS+=usr/share/terminfo/m/
OLD_FILES+=usr/share/terminfo/n/n7900
OLD_FILES+=usr/share/terminfo/n/nansi.sys
OLD_FILES+=usr/share/terminfo/n/nansi.sysk
OLD_FILES+=usr/share/terminfo/n/nansisys
OLD_FILES+=usr/share/terminfo/n/nansisysk
OLD_FILES+=usr/share/terminfo/n/ncr160vppp
OLD_FILES+=usr/share/terminfo/n/ncr160vpwpp
OLD_FILES+=usr/share/terminfo/n/ncr160vt100an
OLD_FILES+=usr/share/terminfo/n/ncr160vt100pp
OLD_FILES+=usr/share/terminfo/n/ncr160vt100wan
OLD_FILES+=usr/share/terminfo/n/ncr160vt100wpp
OLD_FILES+=usr/share/terminfo/n/ncr160vt200an
OLD_FILES+=usr/share/terminfo/n/ncr160vt200pp
OLD_FILES+=usr/share/terminfo/n/ncr160vt200wan
OLD_FILES+=usr/share/terminfo/n/ncr160vt200wpp
OLD_FILES+=usr/share/terminfo/n/ncr160vt300an
OLD_FILES+=usr/share/terminfo/n/ncr160vt300pp
OLD_FILES+=usr/share/terminfo/n/ncr160vt300wan
OLD_FILES+=usr/share/terminfo/n/ncr160vt300wpp
OLD_FILES+=usr/share/terminfo/n/ncr160wy50+pp
OLD_FILES+=usr/share/terminfo/n/ncr160wy50+wpp
OLD_FILES+=usr/share/terminfo/n/ncr160wy60pp
OLD_FILES+=usr/share/terminfo/n/ncr160wy60wpp
OLD_FILES+=usr/share/terminfo/n/ncr260intan
OLD_FILES+=usr/share/terminfo/n/ncr260intpp
OLD_FILES+=usr/share/terminfo/n/ncr260intwan
OLD_FILES+=usr/share/terminfo/n/ncr260intwpp
OLD_FILES+=usr/share/terminfo/n/ncr260vppp
OLD_FILES+=usr/share/terminfo/n/ncr260vpwpp
OLD_FILES+=usr/share/terminfo/n/ncr260vt100an
OLD_FILES+=usr/share/terminfo/n/ncr260vt100pp
OLD_FILES+=usr/share/terminfo/n/ncr260vt100wan
OLD_FILES+=usr/share/terminfo/n/ncr260vt100wpp
OLD_FILES+=usr/share/terminfo/n/ncr260vt200an
OLD_FILES+=usr/share/terminfo/n/ncr260vt200pp
OLD_FILES+=usr/share/terminfo/n/ncr260vt200wan
OLD_FILES+=usr/share/terminfo/n/ncr260vt200wpp
OLD_FILES+=usr/share/terminfo/n/ncr260vt300an
OLD_FILES+=usr/share/terminfo/n/ncr260vt300pp
OLD_FILES+=usr/share/terminfo/n/ncr260vt300wan
OLD_FILES+=usr/share/terminfo/n/ncr260vt300wpp
OLD_FILES+=usr/share/terminfo/n/ncr260wy325pp
OLD_FILES+=usr/share/terminfo/n/ncr260wy325wpp
OLD_FILES+=usr/share/terminfo/n/ncr260wy350pp
OLD_FILES+=usr/share/terminfo/n/ncr260wy350wpp
OLD_FILES+=usr/share/terminfo/n/ncr260wy50+pp
OLD_FILES+=usr/share/terminfo/n/ncr260wy50+wpp
OLD_FILES+=usr/share/terminfo/n/ncr260wy60pp
OLD_FILES+=usr/share/terminfo/n/ncr260wy60wpp
OLD_FILES+=usr/share/terminfo/n/ncr7900
OLD_FILES+=usr/share/terminfo/n/ncr7900i
OLD_FILES+=usr/share/terminfo/n/ncr7900iv
OLD_FILES+=usr/share/terminfo/n/ncr7901
OLD_FILES+=usr/share/terminfo/n/ncrvt100an
OLD_FILES+=usr/share/terminfo/n/ncrvt100pp
OLD_FILES+=usr/share/terminfo/n/ncrvt100wan
OLD_FILES+=usr/share/terminfo/n/ncrvt100wpp
OLD_FILES+=usr/share/terminfo/n/ncsa
OLD_FILES+=usr/share/terminfo/n/ncsa-m
OLD_FILES+=usr/share/terminfo/n/ncsa-m-ns
OLD_FILES+=usr/share/terminfo/n/ncsa-ns
OLD_FILES+=usr/share/terminfo/n/ncsa-vt220
OLD_FILES+=usr/share/terminfo/n/ncsa-vt220-8
OLD_FILES+=usr/share/terminfo/n/nd9500
OLD_FILES+=usr/share/terminfo/n/ndr9500
OLD_FILES+=usr/share/terminfo/n/ndr9500-25
OLD_FILES+=usr/share/terminfo/n/ndr9500-25-mc
OLD_FILES+=usr/share/terminfo/n/ndr9500-25-mc-nl
OLD_FILES+=usr/share/terminfo/n/ndr9500-25-nl
OLD_FILES+=usr/share/terminfo/n/ndr9500-mc
OLD_FILES+=usr/share/terminfo/n/ndr9500-mc-nl
OLD_FILES+=usr/share/terminfo/n/ndr9500-nl
OLD_FILES+=usr/share/terminfo/n/nec
OLD_FILES+=usr/share/terminfo/n/nec5520
OLD_FILES+=usr/share/terminfo/n/netbsd6
OLD_FILES+=usr/share/terminfo/n/newhp
OLD_FILES+=usr/share/terminfo/n/newhpkeyboard
OLD_FILES+=usr/share/terminfo/n/news
OLD_FILES+=usr/share/terminfo/n/news-29
OLD_FILES+=usr/share/terminfo/n/news-29-euc
OLD_FILES+=usr/share/terminfo/n/news-29-sjis
OLD_FILES+=usr/share/terminfo/n/news-33
OLD_FILES+=usr/share/terminfo/n/news-33-euc
OLD_FILES+=usr/share/terminfo/n/news-33-sjis
OLD_FILES+=usr/share/terminfo/n/news-42
OLD_FILES+=usr/share/terminfo/n/news-42-euc
OLD_FILES+=usr/share/terminfo/n/news-42-sjis
OLD_FILES+=usr/share/terminfo/n/news-a
OLD_FILES+=usr/share/terminfo/n/news-o
OLD_FILES+=usr/share/terminfo/n/news-old-unk
OLD_FILES+=usr/share/terminfo/n/news-unk
OLD_FILES+=usr/share/terminfo/n/news28
OLD_FILES+=usr/share/terminfo/n/news28-a
OLD_FILES+=usr/share/terminfo/n/news29
OLD_FILES+=usr/share/terminfo/n/news31
OLD_FILES+=usr/share/terminfo/n/news31-a
OLD_FILES+=usr/share/terminfo/n/news31-o
OLD_FILES+=usr/share/terminfo/n/news33
OLD_FILES+=usr/share/terminfo/n/news40
OLD_FILES+=usr/share/terminfo/n/news40-a
OLD_FILES+=usr/share/terminfo/n/news40-o
OLD_FILES+=usr/share/terminfo/n/news42
OLD_FILES+=usr/share/terminfo/n/newscbm
OLD_FILES+=usr/share/terminfo/n/newscbm-a
OLD_FILES+=usr/share/terminfo/n/newscbm-o
OLD_FILES+=usr/share/terminfo/n/newscbm33
OLD_FILES+=usr/share/terminfo/n/next
OLD_FILES+=usr/share/terminfo/n/nextshell
OLD_FILES+=usr/share/terminfo/n/northstar
OLD_FILES+=usr/share/terminfo/n/nsterm
OLD_FILES+=usr/share/terminfo/n/nsterm+7
OLD_FILES+=usr/share/terminfo/n/nsterm+acs
OLD_FILES+=usr/share/terminfo/n/nsterm+c
OLD_FILES+=usr/share/terminfo/n/nsterm+c41
OLD_FILES+=usr/share/terminfo/n/nsterm+mac
OLD_FILES+=usr/share/terminfo/n/nsterm+s
OLD_FILES+=usr/share/terminfo/n/nsterm-16color
OLD_FILES+=usr/share/terminfo/n/nsterm-256color
OLD_FILES+=usr/share/terminfo/n/nsterm-7
OLD_FILES+=usr/share/terminfo/n/nsterm-7-c
OLD_FILES+=usr/share/terminfo/n/nsterm-7-c-s
OLD_FILES+=usr/share/terminfo/n/nsterm-7-m
OLD_FILES+=usr/share/terminfo/n/nsterm-7-m-s
OLD_FILES+=usr/share/terminfo/n/nsterm-7-s
OLD_FILES+=usr/share/terminfo/n/nsterm-acs
OLD_FILES+=usr/share/terminfo/n/nsterm-acs-c
OLD_FILES+=usr/share/terminfo/n/nsterm-acs-c-s
OLD_FILES+=usr/share/terminfo/n/nsterm-acs-m
OLD_FILES+=usr/share/terminfo/n/nsterm-acs-m-s
OLD_FILES+=usr/share/terminfo/n/nsterm-acs-s
OLD_FILES+=usr/share/terminfo/n/nsterm-bce
OLD_FILES+=usr/share/terminfo/n/nsterm-build309
OLD_FILES+=usr/share/terminfo/n/nsterm-build326
OLD_FILES+=usr/share/terminfo/n/nsterm-build343
OLD_FILES+=usr/share/terminfo/n/nsterm-build361
OLD_FILES+=usr/share/terminfo/n/nsterm-build400
OLD_FILES+=usr/share/terminfo/n/nsterm-c
OLD_FILES+=usr/share/terminfo/n/nsterm-c-7
OLD_FILES+=usr/share/terminfo/n/nsterm-c-acs
OLD_FILES+=usr/share/terminfo/n/nsterm-c-s
OLD_FILES+=usr/share/terminfo/n/nsterm-c-s-7
OLD_FILES+=usr/share/terminfo/n/nsterm-c-s-acs
OLD_FILES+=usr/share/terminfo/n/nsterm-direct
OLD_FILES+=usr/share/terminfo/n/nsterm-m
OLD_FILES+=usr/share/terminfo/n/nsterm-m-7
OLD_FILES+=usr/share/terminfo/n/nsterm-m-acs
OLD_FILES+=usr/share/terminfo/n/nsterm-m-s
OLD_FILES+=usr/share/terminfo/n/nsterm-m-s-7
OLD_FILES+=usr/share/terminfo/n/nsterm-m-s-acs
OLD_FILES+=usr/share/terminfo/n/nsterm-old
OLD_FILES+=usr/share/terminfo/n/nsterm-s
OLD_FILES+=usr/share/terminfo/n/nsterm-s-7
OLD_FILES+=usr/share/terminfo/n/nsterm-s-acs
OLD_FILES+=usr/share/terminfo/n/ntconsole
OLD_FILES+=usr/share/terminfo/n/ntconsole-100
OLD_FILES+=usr/share/terminfo/n/ntconsole-100-nti
OLD_FILES+=usr/share/terminfo/n/ntconsole-25
OLD_FILES+=usr/share/terminfo/n/ntconsole-25-nti
OLD_FILES+=usr/share/terminfo/n/ntconsole-25-w
OLD_FILES+=usr/share/terminfo/n/ntconsole-25-w-vt
OLD_FILES+=usr/share/terminfo/n/ntconsole-35
OLD_FILES+=usr/share/terminfo/n/ntconsole-35-nti
OLD_FILES+=usr/share/terminfo/n/ntconsole-35-w
OLD_FILES+=usr/share/terminfo/n/ntconsole-50
OLD_FILES+=usr/share/terminfo/n/ntconsole-50-nti
OLD_FILES+=usr/share/terminfo/n/ntconsole-50-w
OLD_FILES+=usr/share/terminfo/n/ntconsole-60
OLD_FILES+=usr/share/terminfo/n/ntconsole-60-nti
OLD_FILES+=usr/share/terminfo/n/ntconsole-60-w
OLD_FILES+=usr/share/terminfo/n/ntconsole-w
OLD_FILES+=usr/share/terminfo/n/ntconsole-w-vt
OLD_FILES+=usr/share/terminfo/n/nwe501
OLD_FILES+=usr/share/terminfo/n/nwe501-a
OLD_FILES+=usr/share/terminfo/n/nwe501-o
OLD_FILES+=usr/share/terminfo/n/nwp-511
OLD_FILES+=usr/share/terminfo/n/nwp-517
OLD_FILES+=usr/share/terminfo/n/nwp-517-w
OLD_FILES+=usr/share/terminfo/n/nwp251-a
OLD_FILES+=usr/share/terminfo/n/nwp251-o
OLD_FILES+=usr/share/terminfo/n/nwp511
OLD_FILES+=usr/share/terminfo/n/nwp512
OLD_FILES+=usr/share/terminfo/n/nwp512-a
OLD_FILES+=usr/share/terminfo/n/nwp512-o
OLD_FILES+=usr/share/terminfo/n/nwp513
OLD_FILES+=usr/share/terminfo/n/nwp513-a
OLD_FILES+=usr/share/terminfo/n/nwp513-o
OLD_FILES+=usr/share/terminfo/n/nwp514
OLD_FILES+=usr/share/terminfo/n/nwp514-a
OLD_FILES+=usr/share/terminfo/n/nwp514-o
OLD_FILES+=usr/share/terminfo/n/nwp517
OLD_FILES+=usr/share/terminfo/n/nwp517-w
OLD_FILES+=usr/share/terminfo/n/nwp518
OLD_FILES+=usr/share/terminfo/n/nwp518-a
OLD_FILES+=usr/share/terminfo/n/nwp518-o
OLD_FILES+=usr/share/terminfo/n/nxterm
OLD_DIRS+=usr/share/terminfo/n/
OLD_FILES+=usr/share/terminfo/o/o31
OLD_FILES+=usr/share/terminfo/o/o4112-nd
OLD_FILES+=usr/share/terminfo/o/o85h
OLD_FILES+=usr/share/terminfo/o/oabm85h
OLD_FILES+=usr/share/terminfo/o/oblit
OLD_FILES+=usr/share/terminfo/o/oc100
OLD_FILES+=usr/share/terminfo/o/oconcept
OLD_FILES+=usr/share/terminfo/o/ofcons
OLD_FILES+=usr/share/terminfo/o/ojerq
OLD_FILES+=usr/share/terminfo/o/old-st
OLD_FILES+=usr/share/terminfo/o/oldibmpc3
OLD_FILES+=usr/share/terminfo/o/oldpc3
OLD_FILES+=usr/share/terminfo/o/oldsun
OLD_FILES+=usr/share/terminfo/o/omron
OLD_FILES+=usr/share/terminfo/o/opennt
OLD_FILES+=usr/share/terminfo/o/opennt-100
OLD_FILES+=usr/share/terminfo/o/opennt-100-nti
OLD_FILES+=usr/share/terminfo/o/opennt-25
OLD_FILES+=usr/share/terminfo/o/opennt-25-nti
OLD_FILES+=usr/share/terminfo/o/opennt-25-w
OLD_FILES+=usr/share/terminfo/o/opennt-25-w-vt
OLD_FILES+=usr/share/terminfo/o/opennt-35
OLD_FILES+=usr/share/terminfo/o/opennt-35-nti
OLD_FILES+=usr/share/terminfo/o/opennt-35-w
OLD_FILES+=usr/share/terminfo/o/opennt-50
OLD_FILES+=usr/share/terminfo/o/opennt-50-nti
OLD_FILES+=usr/share/terminfo/o/opennt-50-w
OLD_FILES+=usr/share/terminfo/o/opennt-60
OLD_FILES+=usr/share/terminfo/o/opennt-60-nti
OLD_FILES+=usr/share/terminfo/o/opennt-60-w
OLD_FILES+=usr/share/terminfo/o/opennt-nti
OLD_FILES+=usr/share/terminfo/o/opennt-w
OLD_FILES+=usr/share/terminfo/o/opennt-w-vt
OLD_FILES+=usr/share/terminfo/o/opus3n1+
OLD_FILES+=usr/share/terminfo/o/origibmpc3
OLD_FILES+=usr/share/terminfo/o/origpc3
OLD_FILES+=usr/share/terminfo/o/os9LII
OLD_FILES+=usr/share/terminfo/o/osborne
OLD_FILES+=usr/share/terminfo/o/osborne-w
OLD_FILES+=usr/share/terminfo/o/osborne1
OLD_FILES+=usr/share/terminfo/o/osborne1-w
OLD_FILES+=usr/share/terminfo/o/osexec
OLD_FILES+=usr/share/terminfo/o/otek4112
OLD_FILES+=usr/share/terminfo/o/otek4113
OLD_FILES+=usr/share/terminfo/o/otek4114
OLD_FILES+=usr/share/terminfo/o/otek4115
OLD_FILES+=usr/share/terminfo/o/owl
OLD_DIRS+=usr/share/terminfo/o/
OLD_FILES+=usr/share/terminfo/p/p12
OLD_FILES+=usr/share/terminfo/p/p12-m
OLD_FILES+=usr/share/terminfo/p/p12-m-w
OLD_FILES+=usr/share/terminfo/p/p12-w
OLD_FILES+=usr/share/terminfo/p/p14
OLD_FILES+=usr/share/terminfo/p/p14-m
OLD_FILES+=usr/share/terminfo/p/p14-m-w
OLD_FILES+=usr/share/terminfo/p/p14-w
OLD_FILES+=usr/share/terminfo/p/p19
OLD_FILES+=usr/share/terminfo/p/p4
OLD_FILES+=usr/share/terminfo/p/p5
OLD_FILES+=usr/share/terminfo/p/p7
OLD_FILES+=usr/share/terminfo/p/p8
OLD_FILES+=usr/share/terminfo/p/p8-w
OLD_FILES+=usr/share/terminfo/p/p8gl
OLD_FILES+=usr/share/terminfo/p/p9
OLD_FILES+=usr/share/terminfo/p/p9-8
OLD_FILES+=usr/share/terminfo/p/p9-8-w
OLD_FILES+=usr/share/terminfo/p/p9-w
OLD_FILES+=usr/share/terminfo/p/pc-coherent
OLD_FILES+=usr/share/terminfo/p/pc-minix
OLD_FILES+=usr/share/terminfo/p/pc-venix
OLD_FILES+=usr/share/terminfo/p/pc3
OLD_FILES+=usr/share/terminfo/p/pc3-bold
OLD_FILES+=usr/share/terminfo/p/pc3r
OLD_FILES+=usr/share/terminfo/p/pc3r-m
OLD_FILES+=usr/share/terminfo/p/pc6300plus
OLD_FILES+=usr/share/terminfo/p/pc7300
OLD_FILES+=usr/share/terminfo/p/pcansi
OLD_FILES+=usr/share/terminfo/p/pcansi-25
OLD_FILES+=usr/share/terminfo/p/pcansi-25-m
OLD_FILES+=usr/share/terminfo/p/pcansi-33
OLD_FILES+=usr/share/terminfo/p/pcansi-33-m
OLD_FILES+=usr/share/terminfo/p/pcansi-43
OLD_FILES+=usr/share/terminfo/p/pcansi-43-m
OLD_FILES+=usr/share/terminfo/p/pcansi-m
OLD_FILES+=usr/share/terminfo/p/pcansi-mono
OLD_FILES+=usr/share/terminfo/p/pcansi25
OLD_FILES+=usr/share/terminfo/p/pcansi25m
OLD_FILES+=usr/share/terminfo/p/pcansi33
OLD_FILES+=usr/share/terminfo/p/pcansi33m
OLD_FILES+=usr/share/terminfo/p/pcansi43
OLD_FILES+=usr/share/terminfo/p/pccon
OLD_FILES+=usr/share/terminfo/p/pccon+base
OLD_FILES+=usr/share/terminfo/p/pccon+colors
OLD_FILES+=usr/share/terminfo/p/pccon+keys
OLD_FILES+=usr/share/terminfo/p/pccon+sgr+acs
OLD_FILES+=usr/share/terminfo/p/pccon+sgr+acs0
OLD_FILES+=usr/share/terminfo/p/pccon-m
OLD_FILES+=usr/share/terminfo/p/pccon0
OLD_FILES+=usr/share/terminfo/p/pccon0-m
OLD_FILES+=usr/share/terminfo/p/pccons
OLD_FILES+=usr/share/terminfo/p/pcconsole
OLD_FILES+=usr/share/terminfo/p/pcix
OLD_FILES+=usr/share/terminfo/p/pckermit
OLD_FILES+=usr/share/terminfo/p/pckermit12
OLD_FILES+=usr/share/terminfo/p/pckermit120
OLD_FILES+=usr/share/terminfo/p/pcmw
OLD_FILES+=usr/share/terminfo/p/pcplot
OLD_FILES+=usr/share/terminfo/p/pcvt25
OLD_FILES+=usr/share/terminfo/p/pcvt25-color
OLD_FILES+=usr/share/terminfo/p/pcvt25w
OLD_FILES+=usr/share/terminfo/p/pcvt28
OLD_FILES+=usr/share/terminfo/p/pcvt28w
OLD_FILES+=usr/share/terminfo/p/pcvt35
OLD_FILES+=usr/share/terminfo/p/pcvt35w
OLD_FILES+=usr/share/terminfo/p/pcvt40
OLD_FILES+=usr/share/terminfo/p/pcvt40w
OLD_FILES+=usr/share/terminfo/p/pcvt43
OLD_FILES+=usr/share/terminfo/p/pcvt43w
OLD_FILES+=usr/share/terminfo/p/pcvt50
OLD_FILES+=usr/share/terminfo/p/pcvt50w
OLD_FILES+=usr/share/terminfo/p/pcvtXX
OLD_FILES+=usr/share/terminfo/p/pcz19
OLD_FILES+=usr/share/terminfo/p/pe1100
OLD_FILES+=usr/share/terminfo/p/pe1200
OLD_FILES+=usr/share/terminfo/p/pe1251
OLD_FILES+=usr/share/terminfo/p/pe550
OLD_FILES+=usr/share/terminfo/p/pe6100
OLD_FILES+=usr/share/terminfo/p/pe6300
OLD_FILES+=usr/share/terminfo/p/pe6312
OLD_FILES+=usr/share/terminfo/p/pe7000c
OLD_FILES+=usr/share/terminfo/p/pe7000m
OLD_FILES+=usr/share/terminfo/p/pilot
OLD_FILES+=usr/share/terminfo/p/pmcons
OLD_FILES+=usr/share/terminfo/p/pmconsole
OLD_FILES+=usr/share/terminfo/p/printer
OLD_FILES+=usr/share/terminfo/p/prism12
OLD_FILES+=usr/share/terminfo/p/prism12-m
OLD_FILES+=usr/share/terminfo/p/prism12-m-w
OLD_FILES+=usr/share/terminfo/p/prism12-w
OLD_FILES+=usr/share/terminfo/p/prism14
OLD_FILES+=usr/share/terminfo/p/prism14-m
OLD_FILES+=usr/share/terminfo/p/prism14-m-w
OLD_FILES+=usr/share/terminfo/p/prism14-w
OLD_FILES+=usr/share/terminfo/p/prism2
OLD_FILES+=usr/share/terminfo/p/prism4
OLD_FILES+=usr/share/terminfo/p/prism5
OLD_FILES+=usr/share/terminfo/p/prism7
OLD_FILES+=usr/share/terminfo/p/prism8
OLD_FILES+=usr/share/terminfo/p/prism8-w
OLD_FILES+=usr/share/terminfo/p/prism8gl
OLD_FILES+=usr/share/terminfo/p/prism9
OLD_FILES+=usr/share/terminfo/p/prism9-8
OLD_FILES+=usr/share/terminfo/p/prism9-8-w
OLD_FILES+=usr/share/terminfo/p/prism9-w
OLD_FILES+=usr/share/terminfo/p/pro350
OLD_FILES+=usr/share/terminfo/p/ps300
OLD_FILES+=usr/share/terminfo/p/psterm
OLD_FILES+=usr/share/terminfo/p/psterm-80x24
OLD_FILES+=usr/share/terminfo/p/psterm-90x28
OLD_FILES+=usr/share/terminfo/p/psterm-96x48
OLD_FILES+=usr/share/terminfo/p/psterm-basic
OLD_FILES+=usr/share/terminfo/p/psterm-fast
OLD_FILES+=usr/share/terminfo/p/psx_ansi
OLD_FILES+=usr/share/terminfo/p/pt100
OLD_FILES+=usr/share/terminfo/p/pt100w
OLD_FILES+=usr/share/terminfo/p/pt200
OLD_FILES+=usr/share/terminfo/p/pt200w
OLD_FILES+=usr/share/terminfo/p/pt210
OLD_FILES+=usr/share/terminfo/p/pt250
OLD_FILES+=usr/share/terminfo/p/pt250w
OLD_FILES+=usr/share/terminfo/p/pt505
OLD_FILES+=usr/share/terminfo/p/pt505-22
OLD_FILES+=usr/share/terminfo/p/pt505-24
OLD_FILES+=usr/share/terminfo/p/pty
OLD_FILES+=usr/share/terminfo/p/putty
OLD_FILES+=usr/share/terminfo/p/putty+fnkeys
OLD_FILES+=usr/share/terminfo/p/putty+fnkeys+esc
OLD_FILES+=usr/share/terminfo/p/putty+fnkeys+linux
OLD_FILES+=usr/share/terminfo/p/putty+fnkeys+sco
OLD_FILES+=usr/share/terminfo/p/putty+fnkeys+vt100
OLD_FILES+=usr/share/terminfo/p/putty+fnkeys+vt400
OLD_FILES+=usr/share/terminfo/p/putty+fnkeys+xterm
OLD_FILES+=usr/share/terminfo/p/putty+keypad
OLD_FILES+=usr/share/terminfo/p/putty+screen
OLD_FILES+=usr/share/terminfo/p/putty-256color
OLD_FILES+=usr/share/terminfo/p/putty-m1
OLD_FILES+=usr/share/terminfo/p/putty-m1b
OLD_FILES+=usr/share/terminfo/p/putty-m2
OLD_FILES+=usr/share/terminfo/p/putty-noapp
OLD_FILES+=usr/share/terminfo/p/putty-sco
OLD_FILES+=usr/share/terminfo/p/putty-screen
OLD_FILES+=usr/share/terminfo/p/putty-vt100
OLD_DIRS+=usr/share/terminfo/p/
OLD_FILES+=usr/share/terminfo/q/qansi
OLD_FILES+=usr/share/terminfo/q/qansi-g
OLD_FILES+=usr/share/terminfo/q/qansi-m
OLD_FILES+=usr/share/terminfo/q/qansi-t
OLD_FILES+=usr/share/terminfo/q/qansi-w
OLD_FILES+=usr/share/terminfo/q/qdcons
OLD_FILES+=usr/share/terminfo/q/qdss
OLD_FILES+=usr/share/terminfo/q/qnx
OLD_FILES+=usr/share/terminfo/q/qnx4
OLD_FILES+=usr/share/terminfo/q/qnxm
OLD_FILES+=usr/share/terminfo/q/qnxt
OLD_FILES+=usr/share/terminfo/q/qnxt2
OLD_FILES+=usr/share/terminfo/q/qnxt4
OLD_FILES+=usr/share/terminfo/q/qnxtmono
OLD_FILES+=usr/share/terminfo/q/qnxw
OLD_FILES+=usr/share/terminfo/q/qume
OLD_FILES+=usr/share/terminfo/q/qume5
OLD_FILES+=usr/share/terminfo/q/qvt101
OLD_FILES+=usr/share/terminfo/q/qvt101+
OLD_FILES+=usr/share/terminfo/q/qvt101p
OLD_FILES+=usr/share/terminfo/q/qvt102
OLD_FILES+=usr/share/terminfo/q/qvt103
OLD_FILES+=usr/share/terminfo/q/qvt103-w
OLD_FILES+=usr/share/terminfo/q/qvt108
OLD_FILES+=usr/share/terminfo/q/qvt119
OLD_FILES+=usr/share/terminfo/q/qvt119+
OLD_FILES+=usr/share/terminfo/q/qvt119+-25
OLD_FILES+=usr/share/terminfo/q/qvt119+-25-w
OLD_FILES+=usr/share/terminfo/q/qvt119+-w
OLD_FILES+=usr/share/terminfo/q/qvt119-25-w
OLD_FILES+=usr/share/terminfo/q/qvt119-w
OLD_FILES+=usr/share/terminfo/q/qvt119p
OLD_FILES+=usr/share/terminfo/q/qvt119p-25
OLD_FILES+=usr/share/terminfo/q/qvt119p-25-w
OLD_FILES+=usr/share/terminfo/q/qvt119p-w
OLD_FILES+=usr/share/terminfo/q/qvt203
OLD_FILES+=usr/share/terminfo/q/qvt203+
OLD_FILES+=usr/share/terminfo/q/qvt203-25
OLD_FILES+=usr/share/terminfo/q/qvt203-25-w
OLD_FILES+=usr/share/terminfo/q/qvt203-w
OLD_FILES+=usr/share/terminfo/q/qvt203-w-am
OLD_DIRS+=usr/share/terminfo/q/
OLD_FILES+=usr/share/terminfo/r/rbcomm
OLD_FILES+=usr/share/terminfo/r/rbcomm-nam
OLD_FILES+=usr/share/terminfo/r/rbcomm-w
OLD_FILES+=usr/share/terminfo/r/rca
OLD_FILES+=usr/share/terminfo/r/rcons
OLD_FILES+=usr/share/terminfo/r/rcons-color
OLD_FILES+=usr/share/terminfo/r/rebus3180
OLD_FILES+=usr/share/terminfo/r/regent
OLD_FILES+=usr/share/terminfo/r/regent100
OLD_FILES+=usr/share/terminfo/r/regent20
OLD_FILES+=usr/share/terminfo/r/regent200
OLD_FILES+=usr/share/terminfo/r/regent25
OLD_FILES+=usr/share/terminfo/r/regent40
OLD_FILES+=usr/share/terminfo/r/regent40+
OLD_FILES+=usr/share/terminfo/r/regent60
OLD_FILES+=usr/share/terminfo/r/rt6221
OLD_FILES+=usr/share/terminfo/r/rt6221-w
OLD_FILES+=usr/share/terminfo/r/rtpc
OLD_FILES+=usr/share/terminfo/r/rxvt
OLD_FILES+=usr/share/terminfo/r/rxvt+pcfkeys
OLD_FILES+=usr/share/terminfo/r/rxvt-16color
OLD_FILES+=usr/share/terminfo/r/rxvt-256color
OLD_FILES+=usr/share/terminfo/r/rxvt-88color
OLD_FILES+=usr/share/terminfo/r/rxvt-basic
OLD_FILES+=usr/share/terminfo/r/rxvt-color
OLD_FILES+=usr/share/terminfo/r/rxvt-cygwin
OLD_FILES+=usr/share/terminfo/r/rxvt-cygwin-native
OLD_FILES+=usr/share/terminfo/r/rxvt-xpm
OLD_DIRS+=usr/share/terminfo/r/
OLD_FILES+=usr/share/terminfo/s/s4
OLD_FILES+=usr/share/terminfo/s/sb1
OLD_FILES+=usr/share/terminfo/s/sb2
OLD_FILES+=usr/share/terminfo/s/sb3
OLD_FILES+=usr/share/terminfo/s/sbi
OLD_FILES+=usr/share/terminfo/s/sbobcat
OLD_FILES+=usr/share/terminfo/s/sc410
OLD_FILES+=usr/share/terminfo/s/sc415
OLD_FILES+=usr/share/terminfo/s/scanset
OLD_FILES+=usr/share/terminfo/s/scoansi
OLD_FILES+=usr/share/terminfo/s/scoansi-new
OLD_FILES+=usr/share/terminfo/s/scoansi-old
OLD_FILES+=usr/share/terminfo/s/screen
OLD_FILES+=usr/share/terminfo/s/screen+fkeys
OLD_FILES+=usr/share/terminfo/s/screen+italics
OLD_FILES+=usr/share/terminfo/s/screen-16color
OLD_FILES+=usr/share/terminfo/s/screen-16color-bce
OLD_FILES+=usr/share/terminfo/s/screen-16color-bce-s
OLD_FILES+=usr/share/terminfo/s/screen-16color-s
OLD_FILES+=usr/share/terminfo/s/screen-256color
OLD_FILES+=usr/share/terminfo/s/screen-256color-bce
OLD_FILES+=usr/share/terminfo/s/screen-256color-bce-s
OLD_FILES+=usr/share/terminfo/s/screen-256color-s
OLD_FILES+=usr/share/terminfo/s/screen-bce
OLD_FILES+=usr/share/terminfo/s/screen-bce.Eterm
OLD_FILES+=usr/share/terminfo/s/screen-bce.gnome
OLD_FILES+=usr/share/terminfo/s/screen-bce.konsole
OLD_FILES+=usr/share/terminfo/s/screen-bce.linux
OLD_FILES+=usr/share/terminfo/s/screen-bce.mrxvt
OLD_FILES+=usr/share/terminfo/s/screen-bce.rxvt
OLD_FILES+=usr/share/terminfo/s/screen-bce.xterm-new
OLD_FILES+=usr/share/terminfo/s/screen-s
OLD_FILES+=usr/share/terminfo/s/screen-w
OLD_FILES+=usr/share/terminfo/s/screen.Eterm
OLD_FILES+=usr/share/terminfo/s/screen.gnome
OLD_FILES+=usr/share/terminfo/s/screen.konsole
OLD_FILES+=usr/share/terminfo/s/screen.konsole-256color
OLD_FILES+=usr/share/terminfo/s/screen.linux
OLD_FILES+=usr/share/terminfo/s/screen.linux-m1
OLD_FILES+=usr/share/terminfo/s/screen.linux-m1b
OLD_FILES+=usr/share/terminfo/s/screen.linux-m2
OLD_FILES+=usr/share/terminfo/s/screen.linux-s
OLD_FILES+=usr/share/terminfo/s/screen.minitel1
OLD_FILES+=usr/share/terminfo/s/screen.minitel1-nb
OLD_FILES+=usr/share/terminfo/s/screen.minitel12-80
OLD_FILES+=usr/share/terminfo/s/screen.minitel1b
OLD_FILES+=usr/share/terminfo/s/screen.minitel1b-80
OLD_FILES+=usr/share/terminfo/s/screen.minitel1b-nb
OLD_FILES+=usr/share/terminfo/s/screen.minitel2-80
OLD_FILES+=usr/share/terminfo/s/screen.mlterm
OLD_FILES+=usr/share/terminfo/s/screen.mlterm-256color
OLD_FILES+=usr/share/terminfo/s/screen.mrxvt
OLD_FILES+=usr/share/terminfo/s/screen.putty
OLD_FILES+=usr/share/terminfo/s/screen.putty-256color
OLD_FILES+=usr/share/terminfo/s/screen.putty-m1
OLD_FILES+=usr/share/terminfo/s/screen.putty-m1b
OLD_FILES+=usr/share/terminfo/s/screen.putty-m2
OLD_FILES+=usr/share/terminfo/s/screen.rxvt
OLD_FILES+=usr/share/terminfo/s/screen.teraterm
OLD_FILES+=usr/share/terminfo/s/screen.vte
OLD_FILES+=usr/share/terminfo/s/screen.vte-256color
OLD_FILES+=usr/share/terminfo/s/screen.xterm-256color
OLD_FILES+=usr/share/terminfo/s/screen.xterm-new
OLD_FILES+=usr/share/terminfo/s/screen.xterm-r6
OLD_FILES+=usr/share/terminfo/s/screen.xterm-xfree86
OLD_FILES+=usr/share/terminfo/s/screen2
OLD_FILES+=usr/share/terminfo/s/screen3
OLD_FILES+=usr/share/terminfo/s/screen4
OLD_FILES+=usr/share/terminfo/s/screen5
OLD_FILES+=usr/share/terminfo/s/screwpoint
OLD_FILES+=usr/share/terminfo/s/scrhp
OLD_FILES+=usr/share/terminfo/s/scrt
OLD_FILES+=usr/share/terminfo/s/securecrt
OLD_FILES+=usr/share/terminfo/s/sibo
OLD_FILES+=usr/share/terminfo/s/simpleterm
OLD_FILES+=usr/share/terminfo/s/simterm
OLD_FILES+=usr/share/terminfo/s/soroc
OLD_FILES+=usr/share/terminfo/s/soroc120
OLD_FILES+=usr/share/terminfo/s/soroc140
OLD_FILES+=usr/share/terminfo/s/spinwriter
OLD_FILES+=usr/share/terminfo/s/st
OLD_FILES+=usr/share/terminfo/s/st-0.6
OLD_FILES+=usr/share/terminfo/s/st-0.7
OLD_FILES+=usr/share/terminfo/s/st-0.8
OLD_FILES+=usr/share/terminfo/s/st-16color
OLD_FILES+=usr/share/terminfo/s/st-256color
OLD_FILES+=usr/share/terminfo/s/st-direct
OLD_FILES+=usr/share/terminfo/s/st52
OLD_FILES+=usr/share/terminfo/s/st52-color
OLD_FILES+=usr/share/terminfo/s/st52-m
OLD_FILES+=usr/share/terminfo/s/st52-old
OLD_FILES+=usr/share/terminfo/s/stterm
OLD_FILES+=usr/share/terminfo/s/stterm-16color
OLD_FILES+=usr/share/terminfo/s/stterm-256color
OLD_FILES+=usr/share/terminfo/s/stv52
OLD_FILES+=usr/share/terminfo/s/stv52pc
OLD_FILES+=usr/share/terminfo/s/sun
OLD_FILES+=usr/share/terminfo/s/sun+sl
OLD_FILES+=usr/share/terminfo/s/sun-1
OLD_FILES+=usr/share/terminfo/s/sun-12
OLD_FILES+=usr/share/terminfo/s/sun-17
OLD_FILES+=usr/share/terminfo/s/sun-24
OLD_FILES+=usr/share/terminfo/s/sun-34
OLD_FILES+=usr/share/terminfo/s/sun-48
OLD_FILES+=usr/share/terminfo/s/sun-c
OLD_FILES+=usr/share/terminfo/s/sun-cgsix
OLD_FILES+=usr/share/terminfo/s/sun-cmd
OLD_FILES+=usr/share/terminfo/s/sun-color
OLD_FILES+=usr/share/terminfo/s/sun-e
OLD_FILES+=usr/share/terminfo/s/sun-e-s
OLD_FILES+=usr/share/terminfo/s/sun-il
OLD_FILES+=usr/share/terminfo/s/sun-nic
OLD_FILES+=usr/share/terminfo/s/sun-s
OLD_FILES+=usr/share/terminfo/s/sun-s-e
OLD_FILES+=usr/share/terminfo/s/sun-ss5
OLD_FILES+=usr/share/terminfo/s/sun-type4
OLD_FILES+=usr/share/terminfo/s/sun1
OLD_FILES+=usr/share/terminfo/s/sun2
OLD_FILES+=usr/share/terminfo/s/sune
OLD_FILES+=usr/share/terminfo/s/superbee
OLD_FILES+=usr/share/terminfo/s/superbee-xsb
OLD_FILES+=usr/share/terminfo/s/superbeeic
OLD_FILES+=usr/share/terminfo/s/superbrain
OLD_FILES+=usr/share/terminfo/s/sv80
OLD_FILES+=usr/share/terminfo/s/swtp
OLD_FILES+=usr/share/terminfo/s/synertek
OLD_FILES+=usr/share/terminfo/s/synertek380
OLD_FILES+=usr/share/terminfo/s/system1
OLD_DIRS+=usr/share/terminfo/s/

OLD_FILES+=usr/share/terminfo/t/t10
OLD_FILES+=usr/share/terminfo/t/t1061
OLD_FILES+=usr/share/terminfo/t/t1061f
OLD_FILES+=usr/share/terminfo/t/t16
OLD_FILES+=usr/share/terminfo/t/t3700
OLD_FILES+=usr/share/terminfo/t/t3800
OLD_FILES+=usr/share/terminfo/t/t653x
OLD_FILES+=usr/share/terminfo/t/tab
OLD_FILES+=usr/share/terminfo/t/tab132
OLD_FILES+=usr/share/terminfo/t/tab132-15
OLD_FILES+=usr/share/terminfo/t/tab132-rv
OLD_FILES+=usr/share/terminfo/t/tab132-w
OLD_FILES+=usr/share/terminfo/t/tab132-w-rv
OLD_FILES+=usr/share/terminfo/t/tandem6510
OLD_FILES+=usr/share/terminfo/t/tandem653
OLD_FILES+=usr/share/terminfo/t/tek
OLD_FILES+=usr/share/terminfo/t/tek4012
OLD_FILES+=usr/share/terminfo/t/tek4013
OLD_FILES+=usr/share/terminfo/t/tek4014
OLD_FILES+=usr/share/terminfo/t/tek4014-sm
OLD_FILES+=usr/share/terminfo/t/tek4015
OLD_FILES+=usr/share/terminfo/t/tek4015-sm
OLD_FILES+=usr/share/terminfo/t/tek4023
OLD_FILES+=usr/share/terminfo/t/tek4024
OLD_FILES+=usr/share/terminfo/t/tek4025
OLD_FILES+=usr/share/terminfo/t/tek4025-17
OLD_FILES+=usr/share/terminfo/t/tek4025-17-ws
OLD_FILES+=usr/share/terminfo/t/tek4025-cr
OLD_FILES+=usr/share/terminfo/t/tek4025-ex
OLD_FILES+=usr/share/terminfo/t/tek4025a
OLD_FILES+=usr/share/terminfo/t/tek4025ex
OLD_FILES+=usr/share/terminfo/t/tek4027
OLD_FILES+=usr/share/terminfo/t/tek4027-ex
OLD_FILES+=usr/share/terminfo/t/tek4105
OLD_FILES+=usr/share/terminfo/t/tek4105-30
OLD_FILES+=usr/share/terminfo/t/tek4105a
OLD_FILES+=usr/share/terminfo/t/tek4106brl
OLD_FILES+=usr/share/terminfo/t/tek4107
OLD_FILES+=usr/share/terminfo/t/tek4107brl
OLD_FILES+=usr/share/terminfo/t/tek4109
OLD_FILES+=usr/share/terminfo/t/tek4109brl
OLD_FILES+=usr/share/terminfo/t/tek4112
OLD_FILES+=usr/share/terminfo/t/tek4112-5
OLD_FILES+=usr/share/terminfo/t/tek4112-nd
OLD_FILES+=usr/share/terminfo/t/tek4113
OLD_FILES+=usr/share/terminfo/t/tek4113-34
OLD_FILES+=usr/share/terminfo/t/tek4113-nd
OLD_FILES+=usr/share/terminfo/t/tek4114
OLD_FILES+=usr/share/terminfo/t/tek4115
OLD_FILES+=usr/share/terminfo/t/tek4125
OLD_FILES+=usr/share/terminfo/t/tek4205
OLD_FILES+=usr/share/terminfo/t/tek4207
OLD_FILES+=usr/share/terminfo/t/tek4207-s
OLD_FILES+=usr/share/terminfo/t/tek4404
OLD_FILES+=usr/share/terminfo/t/teken
OLD_FILES+=usr/share/terminfo/t/teleray
OLD_FILES+=usr/share/terminfo/t/teletec
OLD_FILES+=usr/share/terminfo/t/teraterm
OLD_FILES+=usr/share/terminfo/t/teraterm-256color
OLD_FILES+=usr/share/terminfo/t/teraterm2.3
OLD_FILES+=usr/share/terminfo/t/teraterm4.59
OLD_FILES+=usr/share/terminfo/t/teraterm4.97
OLD_FILES+=usr/share/terminfo/t/terminator
OLD_FILES+=usr/share/terminfo/t/terminet
OLD_FILES+=usr/share/terminfo/t/terminet1200
OLD_FILES+=usr/share/terminfo/t/terminet300
OLD_FILES+=usr/share/terminfo/t/terminology
OLD_FILES+=usr/share/terminfo/t/terminology-0.6.1
OLD_FILES+=usr/share/terminfo/t/terminology-1.0.0
OLD_FILES+=usr/share/terminfo/t/terminology-1.8.1
OLD_FILES+=usr/share/terminfo/t/termite
OLD_FILES+=usr/share/terminfo/t/tgtelnet
OLD_FILES+=usr/share/terminfo/t/ti700
OLD_FILES+=usr/share/terminfo/t/ti703
OLD_FILES+=usr/share/terminfo/t/ti703-w
OLD_FILES+=usr/share/terminfo/t/ti707
OLD_FILES+=usr/share/terminfo/t/ti707-w
OLD_FILES+=usr/share/terminfo/t/ti733
OLD_FILES+=usr/share/terminfo/t/ti735
OLD_FILES+=usr/share/terminfo/t/ti745
OLD_FILES+=usr/share/terminfo/t/ti800
OLD_FILES+=usr/share/terminfo/t/ti916
OLD_FILES+=usr/share/terminfo/t/ti916-132
OLD_FILES+=usr/share/terminfo/t/ti916-220-7
OLD_FILES+=usr/share/terminfo/t/ti916-220-8
OLD_FILES+=usr/share/terminfo/t/ti916-8
OLD_FILES+=usr/share/terminfo/t/ti916-8-132
OLD_FILES+=usr/share/terminfo/t/ti924
OLD_FILES+=usr/share/terminfo/t/ti924-8
OLD_FILES+=usr/share/terminfo/t/ti924-8w
OLD_FILES+=usr/share/terminfo/t/ti924w
OLD_FILES+=usr/share/terminfo/t/ti926
OLD_FILES+=usr/share/terminfo/t/ti926-8
OLD_FILES+=usr/share/terminfo/t/ti928
OLD_FILES+=usr/share/terminfo/t/ti928-8
OLD_FILES+=usr/share/terminfo/t/ti931
OLD_FILES+=usr/share/terminfo/t/ti_ansi
OLD_FILES+=usr/share/terminfo/t/tkterm
OLD_FILES+=usr/share/terminfo/t/tmux
OLD_FILES+=usr/share/terminfo/t/tmux-256color
OLD_FILES+=usr/share/terminfo/t/tmux-direct
OLD_FILES+=usr/share/terminfo/t/tn1200
OLD_FILES+=usr/share/terminfo/t/tn300
OLD_FILES+=usr/share/terminfo/t/trs16
OLD_FILES+=usr/share/terminfo/t/trs2
OLD_FILES+=usr/share/terminfo/t/trs80II
OLD_FILES+=usr/share/terminfo/t/trsII
OLD_FILES+=usr/share/terminfo/t/ts-1
OLD_FILES+=usr/share/terminfo/t/ts-1p
OLD_FILES+=usr/share/terminfo/t/ts1
OLD_FILES+=usr/share/terminfo/t/ts100
OLD_FILES+=usr/share/terminfo/t/ts100-ctxt
OLD_FILES+=usr/share/terminfo/t/ts100-sp
OLD_FILES+=usr/share/terminfo/t/ts1p
OLD_FILES+=usr/share/terminfo/t/tt
OLD_FILES+=usr/share/terminfo/t/tt505-22
OLD_FILES+=usr/share/terminfo/t/tt52
OLD_FILES+=usr/share/terminfo/t/tty33
OLD_FILES+=usr/share/terminfo/t/tty35
OLD_FILES+=usr/share/terminfo/t/tty37
OLD_FILES+=usr/share/terminfo/t/tty40
OLD_FILES+=usr/share/terminfo/t/tty43
OLD_FILES+=usr/share/terminfo/t/tty4420
OLD_FILES+=usr/share/terminfo/t/tty4424
OLD_FILES+=usr/share/terminfo/t/tty4424-1
OLD_FILES+=usr/share/terminfo/t/tty4424m
OLD_FILES+=usr/share/terminfo/t/tty4426
OLD_FILES+=usr/share/terminfo/t/tty5410
OLD_FILES+=usr/share/terminfo/t/tty5410-w
OLD_FILES+=usr/share/terminfo/t/tty5410v1
OLD_FILES+=usr/share/terminfo/t/tty5410v1-w
OLD_FILES+=usr/share/terminfo/t/tty5420
OLD_FILES+=usr/share/terminfo/t/tty5420+nl
OLD_FILES+=usr/share/terminfo/t/tty5420-nl
OLD_FILES+=usr/share/terminfo/t/tty5420-rv
OLD_FILES+=usr/share/terminfo/t/tty5420-rv-nl
OLD_FILES+=usr/share/terminfo/t/tty5420-w
OLD_FILES+=usr/share/terminfo/t/tty5420-w-nl
OLD_FILES+=usr/share/terminfo/t/tty5420-w-rv
OLD_FILES+=usr/share/terminfo/t/tty5420-w-rv-n
OLD_FILES+=usr/share/terminfo/t/tty5425
OLD_FILES+=usr/share/terminfo/t/tty5425-nl
OLD_FILES+=usr/share/terminfo/t/tty5425-w
OLD_FILES+=usr/share/terminfo/t/tty5620
OLD_FILES+=usr/share/terminfo/t/tty5620-1
OLD_FILES+=usr/share/terminfo/t/tty5620-24
OLD_FILES+=usr/share/terminfo/t/tty5620-34
OLD_FILES+=usr/share/terminfo/t/tty5620-s
OLD_FILES+=usr/share/terminfo/t/ttydmd
OLD_FILES+=usr/share/terminfo/t/tvi803
OLD_FILES+=usr/share/terminfo/t/tvi9065
OLD_FILES+=usr/share/terminfo/t/tvi910
OLD_FILES+=usr/share/terminfo/t/tvi910+
OLD_FILES+=usr/share/terminfo/t/tvi912
OLD_FILES+=usr/share/terminfo/t/tvi912b
OLD_FILES+=usr/share/terminfo/t/tvi912b+2p
OLD_FILES+=usr/share/terminfo/t/tvi912b+dim
OLD_FILES+=usr/share/terminfo/t/tvi912b+mc
OLD_FILES+=usr/share/terminfo/t/tvi912b+printer
OLD_FILES+=usr/share/terminfo/t/tvi912b+vb
OLD_FILES+=usr/share/terminfo/t/tvi912b-2p
OLD_FILES+=usr/share/terminfo/t/tvi912b-2p-mc
OLD_FILES+=usr/share/terminfo/t/tvi912b-2p-p
OLD_FILES+=usr/share/terminfo/t/tvi912b-2p-unk
OLD_FILES+=usr/share/terminfo/t/tvi912b-mc
OLD_FILES+=usr/share/terminfo/t/tvi912b-mc-2p
OLD_FILES+=usr/share/terminfo/t/tvi912b-mc-vb
OLD_FILES+=usr/share/terminfo/t/tvi912b-p
OLD_FILES+=usr/share/terminfo/t/tvi912b-p-2p
OLD_FILES+=usr/share/terminfo/t/tvi912b-p-vb
OLD_FILES+=usr/share/terminfo/t/tvi912b-unk
OLD_FILES+=usr/share/terminfo/t/tvi912b-unk-2p
OLD_FILES+=usr/share/terminfo/t/tvi912b-unk-vb
OLD_FILES+=usr/share/terminfo/t/tvi912b-vb
OLD_FILES+=usr/share/terminfo/t/tvi912b-vb-mc
OLD_FILES+=usr/share/terminfo/t/tvi912b-vb-p
OLD_FILES+=usr/share/terminfo/t/tvi912b-vb-unk
OLD_FILES+=usr/share/terminfo/t/tvi912c
OLD_FILES+=usr/share/terminfo/t/tvi912c-2p
OLD_FILES+=usr/share/terminfo/t/tvi912c-2p-mc
OLD_FILES+=usr/share/terminfo/t/tvi912c-2p-p
OLD_FILES+=usr/share/terminfo/t/tvi912c-2p-unk
OLD_FILES+=usr/share/terminfo/t/tvi912c-mc
OLD_FILES+=usr/share/terminfo/t/tvi912c-mc-2p
OLD_FILES+=usr/share/terminfo/t/tvi912c-mc-vb
OLD_FILES+=usr/share/terminfo/t/tvi912c-p
OLD_FILES+=usr/share/terminfo/t/tvi912c-p-2p
OLD_FILES+=usr/share/terminfo/t/tvi912c-p-vb
OLD_FILES+=usr/share/terminfo/t/tvi912c-unk
OLD_FILES+=usr/share/terminfo/t/tvi912c-unk-2p
OLD_FILES+=usr/share/terminfo/t/tvi912c-unk-vb
OLD_FILES+=usr/share/terminfo/t/tvi912c-vb
OLD_FILES+=usr/share/terminfo/t/tvi912c-vb-mc
OLD_FILES+=usr/share/terminfo/t/tvi912c-vb-p
OLD_FILES+=usr/share/terminfo/t/tvi912c-vb-unk
OLD_FILES+=usr/share/terminfo/t/tvi912cc
OLD_FILES+=usr/share/terminfo/t/tvi914
OLD_FILES+=usr/share/terminfo/t/tvi920
OLD_FILES+=usr/share/terminfo/t/tvi920b
OLD_FILES+=usr/share/terminfo/t/tvi920b+fn
OLD_FILES+=usr/share/terminfo/t/tvi920b-2p
OLD_FILES+=usr/share/terminfo/t/tvi920b-2p-mc
OLD_FILES+=usr/share/terminfo/t/tvi920b-2p-p
OLD_FILES+=usr/share/terminfo/t/tvi920b-2p-unk
OLD_FILES+=usr/share/terminfo/t/tvi920b-mc
OLD_FILES+=usr/share/terminfo/t/tvi920b-mc-2p
OLD_FILES+=usr/share/terminfo/t/tvi920b-mc-vb
OLD_FILES+=usr/share/terminfo/t/tvi920b-p
OLD_FILES+=usr/share/terminfo/t/tvi920b-p-2p
OLD_FILES+=usr/share/terminfo/t/tvi920b-p-vb
OLD_FILES+=usr/share/terminfo/t/tvi920b-unk
OLD_FILES+=usr/share/terminfo/t/tvi920b-unk-2p
OLD_FILES+=usr/share/terminfo/t/tvi920b-unk-vb
OLD_FILES+=usr/share/terminfo/t/tvi920b-vb
OLD_FILES+=usr/share/terminfo/t/tvi920b-vb-mc
OLD_FILES+=usr/share/terminfo/t/tvi920b-vb-p
OLD_FILES+=usr/share/terminfo/t/tvi920b-vb-unk
OLD_FILES+=usr/share/terminfo/t/tvi920c
OLD_FILES+=usr/share/terminfo/t/tvi920c-2p
OLD_FILES+=usr/share/terminfo/t/tvi920c-2p-mc
OLD_FILES+=usr/share/terminfo/t/tvi920c-2p-p
OLD_FILES+=usr/share/terminfo/t/tvi920c-2p-unk
OLD_FILES+=usr/share/terminfo/t/tvi920c-mc
OLD_FILES+=usr/share/terminfo/t/tvi920c-mc-2p
OLD_FILES+=usr/share/terminfo/t/tvi920c-mc-vb
OLD_FILES+=usr/share/terminfo/t/tvi920c-p
OLD_FILES+=usr/share/terminfo/t/tvi920c-p-2p
OLD_FILES+=usr/share/terminfo/t/tvi920c-p-vb
OLD_FILES+=usr/share/terminfo/t/tvi920c-unk
OLD_FILES+=usr/share/terminfo/t/tvi920c-unk-2p
OLD_FILES+=usr/share/terminfo/t/tvi920c-unk-vb
OLD_FILES+=usr/share/terminfo/t/tvi920c-vb
OLD_FILES+=usr/share/terminfo/t/tvi920c-vb-mc
OLD_FILES+=usr/share/terminfo/t/tvi920c-vb-p
OLD_FILES+=usr/share/terminfo/t/tvi920c-vb-unk
OLD_FILES+=usr/share/terminfo/t/tvi921
OLD_FILES+=usr/share/terminfo/t/tvi924
OLD_FILES+=usr/share/terminfo/t/tvi925
OLD_FILES+=usr/share/terminfo/t/tvi925-hi
OLD_FILES+=usr/share/terminfo/t/tvi92B
OLD_FILES+=usr/share/terminfo/t/tvi92D
OLD_FILES+=usr/share/terminfo/t/tvi950
OLD_FILES+=usr/share/terminfo/t/tvi950-2p
OLD_FILES+=usr/share/terminfo/t/tvi950-4p
OLD_FILES+=usr/share/terminfo/t/tvi950-rv
OLD_FILES+=usr/share/terminfo/t/tvi950-rv-2p
OLD_FILES+=usr/share/terminfo/t/tvi950-rv-4p
OLD_FILES+=usr/share/terminfo/t/tvi955
OLD_FILES+=usr/share/terminfo/t/tvi955-hb
OLD_FILES+=usr/share/terminfo/t/tvi955-w
OLD_FILES+=usr/share/terminfo/t/tvi970
OLD_FILES+=usr/share/terminfo/t/tvi970-2p
OLD_FILES+=usr/share/terminfo/t/tvi970-vb
OLD_FILES+=usr/share/terminfo/t/tvipt
OLD_FILES+=usr/share/terminfo/t/tw100
OLD_FILES+=usr/share/terminfo/t/tw52
OLD_FILES+=usr/share/terminfo/t/tw52-color
OLD_FILES+=usr/share/terminfo/t/tw52-m
OLD_FILES+=usr/share/terminfo/t/tws-generic
OLD_FILES+=usr/share/terminfo/t/tws2102-sna
OLD_FILES+=usr/share/terminfo/t/tws2103
OLD_FILES+=usr/share/terminfo/t/tws2103-sna
OLD_DIRS+=usr/share/terminfo/t/
OLD_FILES+=usr/share/terminfo/u/ultima2
OLD_FILES+=usr/share/terminfo/u/ultimaII
OLD_FILES+=usr/share/terminfo/u/uniterm
OLD_FILES+=usr/share/terminfo/u/uniterm49
OLD_FILES+=usr/share/terminfo/u/unixpc
OLD_FILES+=usr/share/terminfo/u/unknown
OLD_FILES+=usr/share/terminfo/u/uts30
OLD_FILES+=usr/share/terminfo/u/uwin
OLD_DIRS+=usr/share/terminfo/u/
OLD_FILES+=usr/share/terminfo/v/v200-nam
OLD_FILES+=usr/share/terminfo/v/v320n
OLD_FILES+=usr/share/terminfo/v/v3220
OLD_FILES+=usr/share/terminfo/v/v5410
OLD_FILES+=usr/share/terminfo/v/vanilla
OLD_FILES+=usr/share/terminfo/v/vapple
OLD_FILES+=usr/share/terminfo/v/vc103
OLD_FILES+=usr/share/terminfo/v/vc203
OLD_FILES+=usr/share/terminfo/v/vc303
OLD_FILES+=usr/share/terminfo/v/vc303a
OLD_FILES+=usr/share/terminfo/v/vc403a
OLD_FILES+=usr/share/terminfo/v/vc404
OLD_FILES+=usr/share/terminfo/v/vc404-s
OLD_FILES+=usr/share/terminfo/v/vc414
OLD_FILES+=usr/share/terminfo/v/vc414h
OLD_FILES+=usr/share/terminfo/v/vc415
OLD_FILES+=usr/share/terminfo/v/venix
OLD_FILES+=usr/share/terminfo/v/versaterm
OLD_FILES+=usr/share/terminfo/v/vi200
OLD_FILES+=usr/share/terminfo/v/vi200-f
OLD_FILES+=usr/share/terminfo/v/vi200-rv
OLD_FILES+=usr/share/terminfo/v/vi300
OLD_FILES+=usr/share/terminfo/v/vi300-old
OLD_FILES+=usr/share/terminfo/v/vi50
OLD_FILES+=usr/share/terminfo/v/vi500
OLD_FILES+=usr/share/terminfo/v/vi50adm
OLD_FILES+=usr/share/terminfo/v/vi55
OLD_FILES+=usr/share/terminfo/v/vi550
OLD_FILES+=usr/share/terminfo/v/vi603
OLD_FILES+=usr/share/terminfo/v/viewdata
OLD_FILES+=usr/share/terminfo/v/viewdata-o
OLD_FILES+=usr/share/terminfo/v/viewdata-rv
OLD_FILES+=usr/share/terminfo/v/viewpoint
OLD_FILES+=usr/share/terminfo/v/viewpoint3a+
OLD_FILES+=usr/share/terminfo/v/viewpoint60
OLD_FILES+=usr/share/terminfo/v/viewpoint90
OLD_FILES+=usr/share/terminfo/v/vip
OLD_FILES+=usr/share/terminfo/v/vip-H
OLD_FILES+=usr/share/terminfo/v/vip-Hw
OLD_FILES+=usr/share/terminfo/v/vip-w
OLD_FILES+=usr/share/terminfo/v/vip7800-H
OLD_FILES+=usr/share/terminfo/v/vip7800-Hw
OLD_FILES+=usr/share/terminfo/v/vip7800-w
OLD_FILES+=usr/share/terminfo/v/visa50
OLD_FILES+=usr/share/terminfo/v/visual603
OLD_FILES+=usr/share/terminfo/v/vitty
OLD_FILES+=usr/share/terminfo/v/vk100
OLD_FILES+=usr/share/terminfo/v/vp3a+
OLD_FILES+=usr/share/terminfo/v/vp60
OLD_FILES+=usr/share/terminfo/v/vp90
OLD_FILES+=usr/share/terminfo/v/vremote
OLD_FILES+=usr/share/terminfo/v/vs100
OLD_FILES+=usr/share/terminfo/v/vs100-x10
OLD_FILES+=usr/share/terminfo/v/vsc
OLD_FILES+=usr/share/terminfo/v/vscode
OLD_FILES+=usr/share/terminfo/v/vscode-direct
OLD_FILES+=usr/share/terminfo/v/vt-61
OLD_FILES+=usr/share/terminfo/v/vt-utf8
OLD_FILES+=usr/share/terminfo/v/vt100
OLD_FILES+=usr/share/terminfo/v/vt100+
OLD_FILES+=usr/share/terminfo/v/vt100+4bsd
OLD_FILES+=usr/share/terminfo/v/vt100+enq
OLD_FILES+=usr/share/terminfo/v/vt100+fnkeys
OLD_FILES+=usr/share/terminfo/v/vt100+keypad
OLD_FILES+=usr/share/terminfo/v/vt100+pfkeys
OLD_FILES+=usr/share/terminfo/v/vt100-am
OLD_FILES+=usr/share/terminfo/v/vt100-bm
OLD_FILES+=usr/share/terminfo/v/vt100-bm-o
OLD_FILES+=usr/share/terminfo/v/vt100-bot-s
OLD_FILES+=usr/share/terminfo/v/vt100-nam
OLD_FILES+=usr/share/terminfo/v/vt100-nam-w
OLD_FILES+=usr/share/terminfo/v/vt100-nav
OLD_FILES+=usr/share/terminfo/v/vt100-nav-w
OLD_FILES+=usr/share/terminfo/v/vt100-putty
OLD_FILES+=usr/share/terminfo/v/vt100-s
OLD_FILES+=usr/share/terminfo/v/vt100-s-bot
OLD_FILES+=usr/share/terminfo/v/vt100-s-top
OLD_FILES+=usr/share/terminfo/v/vt100-top-s
OLD_FILES+=usr/share/terminfo/v/vt100-vb
OLD_FILES+=usr/share/terminfo/v/vt100-w
OLD_FILES+=usr/share/terminfo/v/vt100-w-am
OLD_FILES+=usr/share/terminfo/v/vt100-w-nam
OLD_FILES+=usr/share/terminfo/v/vt100-w-nav
OLD_FILES+=usr/share/terminfo/v/vt100nam
OLD_FILES+=usr/share/terminfo/v/vt102
OLD_FILES+=usr/share/terminfo/v/vt102+enq
OLD_FILES+=usr/share/terminfo/v/vt102-nsgr
OLD_FILES+=usr/share/terminfo/v/vt102-w
OLD_FILES+=usr/share/terminfo/v/vt125
OLD_FILES+=usr/share/terminfo/v/vt131
OLD_FILES+=usr/share/terminfo/v/vt132
OLD_FILES+=usr/share/terminfo/v/vt200
OLD_FILES+=usr/share/terminfo/v/vt200-8
OLD_FILES+=usr/share/terminfo/v/vt200-8bit
OLD_FILES+=usr/share/terminfo/v/vt200-js
OLD_FILES+=usr/share/terminfo/v/vt200-old
OLD_FILES+=usr/share/terminfo/v/vt200-w
OLD_FILES+=usr/share/terminfo/v/vt220
OLD_FILES+=usr/share/terminfo/v/vt220+cvis
OLD_FILES+=usr/share/terminfo/v/vt220+cvis8
OLD_FILES+=usr/share/terminfo/v/vt220+keypad
OLD_FILES+=usr/share/terminfo/v/vt220+pcedit
OLD_FILES+=usr/share/terminfo/v/vt220+vtedit
OLD_FILES+=usr/share/terminfo/v/vt220-8
OLD_FILES+=usr/share/terminfo/v/vt220-8bit
OLD_FILES+=usr/share/terminfo/v/vt220-base
OLD_FILES+=usr/share/terminfo/v/vt220-js
OLD_FILES+=usr/share/terminfo/v/vt220-nam
OLD_FILES+=usr/share/terminfo/v/vt220-old
OLD_FILES+=usr/share/terminfo/v/vt220-w
OLD_FILES+=usr/share/terminfo/v/vt220d
OLD_FILES+=usr/share/terminfo/v/vt300
OLD_FILES+=usr/share/terminfo/v/vt300-nam
OLD_FILES+=usr/share/terminfo/v/vt300-w
OLD_FILES+=usr/share/terminfo/v/vt300-w-nam
OLD_FILES+=usr/share/terminfo/v/vt320
OLD_FILES+=usr/share/terminfo/v/vt320-k3
OLD_FILES+=usr/share/terminfo/v/vt320-k311
OLD_FILES+=usr/share/terminfo/v/vt320-nam
OLD_FILES+=usr/share/terminfo/v/vt320-w
OLD_FILES+=usr/share/terminfo/v/vt320-w-nam
OLD_FILES+=usr/share/terminfo/v/vt320nam
OLD_FILES+=usr/share/terminfo/v/vt330
OLD_FILES+=usr/share/terminfo/v/vt340
OLD_FILES+=usr/share/terminfo/v/vt400
OLD_FILES+=usr/share/terminfo/v/vt400-24
OLD_FILES+=usr/share/terminfo/v/vt420
OLD_FILES+=usr/share/terminfo/v/vt420+lrmm
OLD_FILES+=usr/share/terminfo/v/vt420f
OLD_FILES+=usr/share/terminfo/v/vt420pc
OLD_FILES+=usr/share/terminfo/v/vt420pcdos
OLD_FILES+=usr/share/terminfo/v/vt50
OLD_FILES+=usr/share/terminfo/v/vt50h
OLD_FILES+=usr/share/terminfo/v/vt510
OLD_FILES+=usr/share/terminfo/v/vt510pc
OLD_FILES+=usr/share/terminfo/v/vt510pcdos
OLD_FILES+=usr/share/terminfo/v/vt52
OLD_FILES+=usr/share/terminfo/v/vt52+keypad
OLD_FILES+=usr/share/terminfo/v/vt52-basic
OLD_FILES+=usr/share/terminfo/v/vt520
OLD_FILES+=usr/share/terminfo/v/vt520ansi
OLD_FILES+=usr/share/terminfo/v/vt525
OLD_FILES+=usr/share/terminfo/v/vt61
OLD_FILES+=usr/share/terminfo/v/vt61.5
OLD_FILES+=usr/share/terminfo/v/vte
OLD_FILES+=usr/share/terminfo/v/vte+pcfkeys
OLD_FILES+=usr/share/terminfo/v/vte-2007
OLD_FILES+=usr/share/terminfo/v/vte-2008
OLD_FILES+=usr/share/terminfo/v/vte-2012
OLD_FILES+=usr/share/terminfo/v/vte-2014
OLD_FILES+=usr/share/terminfo/v/vte-2017
OLD_FILES+=usr/share/terminfo/v/vte-2018
OLD_FILES+=usr/share/terminfo/v/vte-256color
OLD_FILES+=usr/share/terminfo/v/vte-direct
OLD_FILES+=usr/share/terminfo/v/vtnt
OLD_FILES+=usr/share/terminfo/v/vv100
OLD_FILES+=usr/share/terminfo/v/vwmterm
OLD_DIRS+=usr/share/terminfo/v/
OLD_FILES+=usr/share/terminfo/w/wren
OLD_FILES+=usr/share/terminfo/w/wrenw
OLD_FILES+=usr/share/terminfo/w/wsiris
OLD_FILES+=usr/share/terminfo/w/wsvt25
OLD_FILES+=usr/share/terminfo/w/wsvt25m
OLD_FILES+=usr/share/terminfo/w/wy-75ap
OLD_FILES+=usr/share/terminfo/w/wy-99fgt
OLD_FILES+=usr/share/terminfo/w/wy-99fgta
OLD_FILES+=usr/share/terminfo/w/wy100
OLD_FILES+=usr/share/terminfo/w/wy100q
OLD_FILES+=usr/share/terminfo/w/wy120
OLD_FILES+=usr/share/terminfo/w/wy120-25
OLD_FILES+=usr/share/terminfo/w/wy120-25-w
OLD_FILES+=usr/share/terminfo/w/wy120-vb
OLD_FILES+=usr/share/terminfo/w/wy120-w
OLD_FILES+=usr/share/terminfo/w/wy120-w-vb
OLD_FILES+=usr/share/terminfo/w/wy120-wvb
OLD_FILES+=usr/share/terminfo/w/wy150
OLD_FILES+=usr/share/terminfo/w/wy150-25
OLD_FILES+=usr/share/terminfo/w/wy150-25-w
OLD_FILES+=usr/share/terminfo/w/wy150-vb
OLD_FILES+=usr/share/terminfo/w/wy150-w
OLD_FILES+=usr/share/terminfo/w/wy150-w-vb
OLD_FILES+=usr/share/terminfo/w/wy160
OLD_FILES+=usr/share/terminfo/w/wy160-25
OLD_FILES+=usr/share/terminfo/w/wy160-25-w
OLD_FILES+=usr/share/terminfo/w/wy160-42
OLD_FILES+=usr/share/terminfo/w/wy160-42-w
OLD_FILES+=usr/share/terminfo/w/wy160-43
OLD_FILES+=usr/share/terminfo/w/wy160-43-w
OLD_FILES+=usr/share/terminfo/w/wy160-tek
OLD_FILES+=usr/share/terminfo/w/wy160-vb
OLD_FILES+=usr/share/terminfo/w/wy160-w
OLD_FILES+=usr/share/terminfo/w/wy160-w-vb
OLD_FILES+=usr/share/terminfo/w/wy160-wvb
OLD_FILES+=usr/share/terminfo/w/wy185
OLD_FILES+=usr/share/terminfo/w/wy185-24
OLD_FILES+=usr/share/terminfo/w/wy185-vb
OLD_FILES+=usr/share/terminfo/w/wy185-w
OLD_FILES+=usr/share/terminfo/w/wy185-wvb
OLD_FILES+=usr/share/terminfo/w/wy30
OLD_FILES+=usr/share/terminfo/w/wy30-mc
OLD_FILES+=usr/share/terminfo/w/wy30-vb
OLD_FILES+=usr/share/terminfo/w/wy325
OLD_FILES+=usr/share/terminfo/w/wy325-25
OLD_FILES+=usr/share/terminfo/w/wy325-25w
OLD_FILES+=usr/share/terminfo/w/wy325-42
OLD_FILES+=usr/share/terminfo/w/wy325-42w
OLD_FILES+=usr/share/terminfo/w/wy325-42w-vb
OLD_FILES+=usr/share/terminfo/w/wy325-42wvb
OLD_FILES+=usr/share/terminfo/w/wy325-43
OLD_FILES+=usr/share/terminfo/w/wy325-43w
OLD_FILES+=usr/share/terminfo/w/wy325-43w-vb
OLD_FILES+=usr/share/terminfo/w/wy325-43wvb
OLD_FILES+=usr/share/terminfo/w/wy325-80
OLD_FILES+=usr/share/terminfo/w/wy325-vb
OLD_FILES+=usr/share/terminfo/w/wy325-w
OLD_FILES+=usr/share/terminfo/w/wy325-w-vb
OLD_FILES+=usr/share/terminfo/w/wy325-wvb
OLD_FILES+=usr/share/terminfo/w/wy325w-24
OLD_FILES+=usr/share/terminfo/w/wy350
OLD_FILES+=usr/share/terminfo/w/wy350-vb
OLD_FILES+=usr/share/terminfo/w/wy350-w
OLD_FILES+=usr/share/terminfo/w/wy350-wvb
OLD_FILES+=usr/share/terminfo/w/wy370
OLD_FILES+=usr/share/terminfo/w/wy370-101k
OLD_FILES+=usr/share/terminfo/w/wy370-105k
OLD_FILES+=usr/share/terminfo/w/wy370-EPC
OLD_FILES+=usr/share/terminfo/w/wy370-nk
OLD_FILES+=usr/share/terminfo/w/wy370-rv
OLD_FILES+=usr/share/terminfo/w/wy370-tek
OLD_FILES+=usr/share/terminfo/w/wy370-vb
OLD_FILES+=usr/share/terminfo/w/wy370-w
OLD_FILES+=usr/share/terminfo/w/wy370-wvb
OLD_FILES+=usr/share/terminfo/w/wy50
OLD_FILES+=usr/share/terminfo/w/wy50-mc
OLD_FILES+=usr/share/terminfo/w/wy50-vb
OLD_FILES+=usr/share/terminfo/w/wy50-w
OLD_FILES+=usr/share/terminfo/w/wy50-wvb
OLD_FILES+=usr/share/terminfo/w/wy520
OLD_FILES+=usr/share/terminfo/w/wy520-24
OLD_FILES+=usr/share/terminfo/w/wy520-36
OLD_FILES+=usr/share/terminfo/w/wy520-36pc
OLD_FILES+=usr/share/terminfo/w/wy520-36w
OLD_FILES+=usr/share/terminfo/w/wy520-36wpc
OLD_FILES+=usr/share/terminfo/w/wy520-48
OLD_FILES+=usr/share/terminfo/w/wy520-48pc
OLD_FILES+=usr/share/terminfo/w/wy520-48w
OLD_FILES+=usr/share/terminfo/w/wy520-48wpc
OLD_FILES+=usr/share/terminfo/w/wy520-epc
OLD_FILES+=usr/share/terminfo/w/wy520-epc-24
OLD_FILES+=usr/share/terminfo/w/wy520-epc-vb
OLD_FILES+=usr/share/terminfo/w/wy520-epc-w
OLD_FILES+=usr/share/terminfo/w/wy520-epc-wvb
OLD_FILES+=usr/share/terminfo/w/wy520-vb
OLD_FILES+=usr/share/terminfo/w/wy520-w
OLD_FILES+=usr/share/terminfo/w/wy520-wvb
OLD_FILES+=usr/share/terminfo/w/wy60
OLD_FILES+=usr/share/terminfo/w/wy60-25
OLD_FILES+=usr/share/terminfo/w/wy60-25-w
OLD_FILES+=usr/share/terminfo/w/wy60-316X
OLD_FILES+=usr/share/terminfo/w/wy60-42
OLD_FILES+=usr/share/terminfo/w/wy60-42-w
OLD_FILES+=usr/share/terminfo/w/wy60-43
OLD_FILES+=usr/share/terminfo/w/wy60-43-w
OLD_FILES+=usr/share/terminfo/w/wy60-AT
OLD_FILES+=usr/share/terminfo/w/wy60-PC
OLD_FILES+=usr/share/terminfo/w/wy60-vb
OLD_FILES+=usr/share/terminfo/w/wy60-w
OLD_FILES+=usr/share/terminfo/w/wy60-w-vb
OLD_FILES+=usr/share/terminfo/w/wy60-wvb
OLD_FILES+=usr/share/terminfo/w/wy75
OLD_FILES+=usr/share/terminfo/w/wy75-mc
OLD_FILES+=usr/share/terminfo/w/wy75-vb
OLD_FILES+=usr/share/terminfo/w/wy75-w
OLD_FILES+=usr/share/terminfo/w/wy75-wvb
OLD_FILES+=usr/share/terminfo/w/wy75ap
OLD_FILES+=usr/share/terminfo/w/wy85
OLD_FILES+=usr/share/terminfo/w/wy85-8bit
OLD_FILES+=usr/share/terminfo/w/wy85-vb
OLD_FILES+=usr/share/terminfo/w/wy85-w
OLD_FILES+=usr/share/terminfo/w/wy85-wvb
OLD_FILES+=usr/share/terminfo/w/wy99-ansi
OLD_FILES+=usr/share/terminfo/w/wy99a-ansi
OLD_FILES+=usr/share/terminfo/w/wy99f
OLD_FILES+=usr/share/terminfo/w/wy99fa
OLD_FILES+=usr/share/terminfo/w/wy99fgt
OLD_FILES+=usr/share/terminfo/w/wy99fgta
OLD_FILES+=usr/share/terminfo/w/wy99gt
OLD_FILES+=usr/share/terminfo/w/wy99gt-25
OLD_FILES+=usr/share/terminfo/w/wy99gt-25-w
OLD_FILES+=usr/share/terminfo/w/wy99gt-tek
OLD_FILES+=usr/share/terminfo/w/wy99gt-vb
OLD_FILES+=usr/share/terminfo/w/wy99gt-w
OLD_FILES+=usr/share/terminfo/w/wy99gt-w-vb
OLD_FILES+=usr/share/terminfo/w/wy99gt-wvb
OLD_FILES+=usr/share/terminfo/w/wyse-325
OLD_FILES+=usr/share/terminfo/w/wyse-75ap
OLD_FILES+=usr/share/terminfo/w/wyse-vp
OLD_FILES+=usr/share/terminfo/w/wyse120
OLD_FILES+=usr/share/terminfo/w/wyse120-25
OLD_FILES+=usr/share/terminfo/w/wyse120-25-w
OLD_FILES+=usr/share/terminfo/w/wyse120-vb
OLD_FILES+=usr/share/terminfo/w/wyse120-w
OLD_FILES+=usr/share/terminfo/w/wyse120-wvb
OLD_FILES+=usr/share/terminfo/w/wyse150
OLD_FILES+=usr/share/terminfo/w/wyse150-25
OLD_FILES+=usr/share/terminfo/w/wyse150-25-w
OLD_FILES+=usr/share/terminfo/w/wyse150-vb
OLD_FILES+=usr/share/terminfo/w/wyse150-w
OLD_FILES+=usr/share/terminfo/w/wyse150-w-vb
OLD_FILES+=usr/share/terminfo/w/wyse160
OLD_FILES+=usr/share/terminfo/w/wyse160-25
OLD_FILES+=usr/share/terminfo/w/wyse160-25-w
OLD_FILES+=usr/share/terminfo/w/wyse160-42
OLD_FILES+=usr/share/terminfo/w/wyse160-42-w
OLD_FILES+=usr/share/terminfo/w/wyse160-43
OLD_FILES+=usr/share/terminfo/w/wyse160-43-w
OLD_FILES+=usr/share/terminfo/w/wyse160-vb
OLD_FILES+=usr/share/terminfo/w/wyse160-w
OLD_FILES+=usr/share/terminfo/w/wyse160-wvb
OLD_FILES+=usr/share/terminfo/w/wyse185
OLD_FILES+=usr/share/terminfo/w/wyse185-24
OLD_FILES+=usr/share/terminfo/w/wyse185-vb
OLD_FILES+=usr/share/terminfo/w/wyse185-w
OLD_FILES+=usr/share/terminfo/w/wyse185-wvb
OLD_FILES+=usr/share/terminfo/w/wyse30
OLD_FILES+=usr/share/terminfo/w/wyse30-mc
OLD_FILES+=usr/share/terminfo/w/wyse30-vb
OLD_FILES+=usr/share/terminfo/w/wyse325
OLD_FILES+=usr/share/terminfo/w/wyse325-25
OLD_FILES+=usr/share/terminfo/w/wyse325-25w
OLD_FILES+=usr/share/terminfo/w/wyse325-42
OLD_FILES+=usr/share/terminfo/w/wyse325-42w
OLD_FILES+=usr/share/terminfo/w/wyse325-43
OLD_FILES+=usr/share/terminfo/w/wyse325-43w
OLD_FILES+=usr/share/terminfo/w/wyse325-vb
OLD_FILES+=usr/share/terminfo/w/wyse325-w
OLD_FILES+=usr/share/terminfo/w/wyse325-wvb
OLD_FILES+=usr/share/terminfo/w/wyse350
OLD_FILES+=usr/share/terminfo/w/wyse350-vb
OLD_FILES+=usr/share/terminfo/w/wyse350-w
OLD_FILES+=usr/share/terminfo/w/wyse350-wvb
OLD_FILES+=usr/share/terminfo/w/wyse370
OLD_FILES+=usr/share/terminfo/w/wyse50
OLD_FILES+=usr/share/terminfo/w/wyse50-mc
OLD_FILES+=usr/share/terminfo/w/wyse50-vb
OLD_FILES+=usr/share/terminfo/w/wyse50-w
OLD_FILES+=usr/share/terminfo/w/wyse50-wvb
OLD_FILES+=usr/share/terminfo/w/wyse520
OLD_FILES+=usr/share/terminfo/w/wyse520-24
OLD_FILES+=usr/share/terminfo/w/wyse520-36
OLD_FILES+=usr/share/terminfo/w/wyse520-36pc
OLD_FILES+=usr/share/terminfo/w/wyse520-36w
OLD_FILES+=usr/share/terminfo/w/wyse520-36wpc
OLD_FILES+=usr/share/terminfo/w/wyse520-48
OLD_FILES+=usr/share/terminfo/w/wyse520-48pc
OLD_FILES+=usr/share/terminfo/w/wyse520-48w
OLD_FILES+=usr/share/terminfo/w/wyse520-48wpc
OLD_FILES+=usr/share/terminfo/w/wyse520-epc
OLD_FILES+=usr/share/terminfo/w/wyse520-epc-w
OLD_FILES+=usr/share/terminfo/w/wyse520-p-wvb
OLD_FILES+=usr/share/terminfo/w/wyse520-pc-24
OLD_FILES+=usr/share/terminfo/w/wyse520-pc-vb
OLD_FILES+=usr/share/terminfo/w/wyse520-vb
OLD_FILES+=usr/share/terminfo/w/wyse520-w
OLD_FILES+=usr/share/terminfo/w/wyse520-wvb
OLD_FILES+=usr/share/terminfo/w/wyse60
OLD_FILES+=usr/share/terminfo/w/wyse60-25
OLD_FILES+=usr/share/terminfo/w/wyse60-25-w
OLD_FILES+=usr/share/terminfo/w/wyse60-316X
OLD_FILES+=usr/share/terminfo/w/wyse60-42
OLD_FILES+=usr/share/terminfo/w/wyse60-42-w
OLD_FILES+=usr/share/terminfo/w/wyse60-43
OLD_FILES+=usr/share/terminfo/w/wyse60-43-w
OLD_FILES+=usr/share/terminfo/w/wyse60-AT
OLD_FILES+=usr/share/terminfo/w/wyse60-PC
OLD_FILES+=usr/share/terminfo/w/wyse60-vb
OLD_FILES+=usr/share/terminfo/w/wyse60-w
OLD_FILES+=usr/share/terminfo/w/wyse60-wvb
OLD_FILES+=usr/share/terminfo/w/wyse75
OLD_FILES+=usr/share/terminfo/w/wyse75-mc
OLD_FILES+=usr/share/terminfo/w/wyse75-vb
OLD_FILES+=usr/share/terminfo/w/wyse75-w
OLD_FILES+=usr/share/terminfo/w/wyse75-wvb
OLD_FILES+=usr/share/terminfo/w/wyse75ap
OLD_FILES+=usr/share/terminfo/w/wyse85
OLD_FILES+=usr/share/terminfo/w/wyse85-8bit
OLD_FILES+=usr/share/terminfo/w/wyse85-vb
OLD_FILES+=usr/share/terminfo/w/wyse85-w
OLD_FILES+=usr/share/terminfo/w/wyse85-wvb
OLD_FILES+=usr/share/terminfo/w/wyse99gt
OLD_FILES+=usr/share/terminfo/w/wyse99gt-25
OLD_FILES+=usr/share/terminfo/w/wyse99gt-25-w
OLD_FILES+=usr/share/terminfo/w/wyse99gt-vb
OLD_FILES+=usr/share/terminfo/w/wyse99gt-w
OLD_FILES+=usr/share/terminfo/w/wyse99gt-wvb
OLD_DIRS+=usr/share/terminfo/w/
OLD_FILES+=usr/share/terminfo/x/x10term
OLD_FILES+=usr/share/terminfo/x/x1700
OLD_FILES+=usr/share/terminfo/x/x1700-lm
OLD_FILES+=usr/share/terminfo/x/x1720
OLD_FILES+=usr/share/terminfo/x/x1750
OLD_FILES+=usr/share/terminfo/x/x68k
OLD_FILES+=usr/share/terminfo/x/x68k-ite
OLD_FILES+=usr/share/terminfo/x/x820
OLD_FILES+=usr/share/terminfo/x/xdku
OLD_FILES+=usr/share/terminfo/x/xenix
OLD_FILES+=usr/share/terminfo/x/xerox
OLD_FILES+=usr/share/terminfo/x/xerox-lm
OLD_FILES+=usr/share/terminfo/x/xerox1720
OLD_FILES+=usr/share/terminfo/x/xerox820
OLD_FILES+=usr/share/terminfo/x/xfce
OLD_FILES+=usr/share/terminfo/x/xiterm
OLD_FILES+=usr/share/terminfo/x/xl83
OLD_FILES+=usr/share/terminfo/x/xnuppc
OLD_FILES+=usr/share/terminfo/x/xnuppc+100x37
OLD_FILES+=usr/share/terminfo/x/xnuppc+112x37
OLD_FILES+=usr/share/terminfo/x/xnuppc+128x40
OLD_FILES+=usr/share/terminfo/x/xnuppc+128x48
OLD_FILES+=usr/share/terminfo/x/xnuppc+144x48
OLD_FILES+=usr/share/terminfo/x/xnuppc+160x64
OLD_FILES+=usr/share/terminfo/x/xnuppc+200x64
OLD_FILES+=usr/share/terminfo/x/xnuppc+200x75
OLD_FILES+=usr/share/terminfo/x/xnuppc+256x96
OLD_FILES+=usr/share/terminfo/x/xnuppc+80x25
OLD_FILES+=usr/share/terminfo/x/xnuppc+80x30
OLD_FILES+=usr/share/terminfo/x/xnuppc+90x30
OLD_FILES+=usr/share/terminfo/x/xnuppc+b
OLD_FILES+=usr/share/terminfo/x/xnuppc+basic
OLD_FILES+=usr/share/terminfo/x/xnuppc+c
OLD_FILES+=usr/share/terminfo/x/xnuppc+f
OLD_FILES+=usr/share/terminfo/x/xnuppc+f2
OLD_FILES+=usr/share/terminfo/x/xnuppc-100x37
OLD_FILES+=usr/share/terminfo/x/xnuppc-100x37-m
OLD_FILES+=usr/share/terminfo/x/xnuppc-112x37
OLD_FILES+=usr/share/terminfo/x/xnuppc-112x37-m
OLD_FILES+=usr/share/terminfo/x/xnuppc-128x40
OLD_FILES+=usr/share/terminfo/x/xnuppc-128x40-m
OLD_FILES+=usr/share/terminfo/x/xnuppc-128x48
OLD_FILES+=usr/share/terminfo/x/xnuppc-128x48-m
OLD_FILES+=usr/share/terminfo/x/xnuppc-144x48
OLD_FILES+=usr/share/terminfo/x/xnuppc-144x48-m
OLD_FILES+=usr/share/terminfo/x/xnuppc-160x64
OLD_FILES+=usr/share/terminfo/x/xnuppc-160x64-m
OLD_FILES+=usr/share/terminfo/x/xnuppc-200x64
OLD_FILES+=usr/share/terminfo/x/xnuppc-200x64-m
OLD_FILES+=usr/share/terminfo/x/xnuppc-200x75
OLD_FILES+=usr/share/terminfo/x/xnuppc-200x75-m
OLD_FILES+=usr/share/terminfo/x/xnuppc-256x96
OLD_FILES+=usr/share/terminfo/x/xnuppc-256x96-m
OLD_FILES+=usr/share/terminfo/x/xnuppc-80x25
OLD_FILES+=usr/share/terminfo/x/xnuppc-80x25-m
OLD_FILES+=usr/share/terminfo/x/xnuppc-80x30
OLD_FILES+=usr/share/terminfo/x/xnuppc-80x30-m
OLD_FILES+=usr/share/terminfo/x/xnuppc-90x30
OLD_FILES+=usr/share/terminfo/x/xnuppc-90x30-m
OLD_FILES+=usr/share/terminfo/x/xnuppc-b
OLD_FILES+=usr/share/terminfo/x/xnuppc-f
OLD_FILES+=usr/share/terminfo/x/xnuppc-f2
OLD_FILES+=usr/share/terminfo/x/xnuppc-m
OLD_FILES+=usr/share/terminfo/x/xnuppc-m-b
OLD_FILES+=usr/share/terminfo/x/xnuppc-m-f
OLD_FILES+=usr/share/terminfo/x/xnuppc-m-f2
OLD_FILES+=usr/share/terminfo/x/xtalk
OLD_FILES+=usr/share/terminfo/x/xterm
OLD_FILES+=usr/share/terminfo/x/xterm+256color
OLD_FILES+=usr/share/terminfo/x/xterm+256color2
OLD_FILES+=usr/share/terminfo/x/xterm+256setaf
OLD_FILES+=usr/share/terminfo/x/xterm+88color
OLD_FILES+=usr/share/terminfo/x/xterm+88color2
OLD_FILES+=usr/share/terminfo/x/xterm+alt+title
OLD_FILES+=usr/share/terminfo/x/xterm+alt1049
OLD_FILES+=usr/share/terminfo/x/xterm+app
OLD_FILES+=usr/share/terminfo/x/xterm+direct
OLD_FILES+=usr/share/terminfo/x/xterm+direct16
OLD_FILES+=usr/share/terminfo/x/xterm+direct2
OLD_FILES+=usr/share/terminfo/x/xterm+direct256
OLD_FILES+=usr/share/terminfo/x/xterm+edit
OLD_FILES+=usr/share/terminfo/x/xterm+indirect
OLD_FILES+=usr/share/terminfo/x/xterm+kbs
OLD_FILES+=usr/share/terminfo/x/xterm+keypad
OLD_FILES+=usr/share/terminfo/x/xterm+meta
OLD_FILES+=usr/share/terminfo/x/xterm+noalt
OLD_FILES+=usr/share/terminfo/x/xterm+noapp
OLD_FILES+=usr/share/terminfo/x/xterm+nofkeys
OLD_FILES+=usr/share/terminfo/x/xterm+osc104
OLD_FILES+=usr/share/terminfo/x/xterm+pc+edit
OLD_FILES+=usr/share/terminfo/x/xterm+pcc0
OLD_FILES+=usr/share/terminfo/x/xterm+pcc1
OLD_FILES+=usr/share/terminfo/x/xterm+pcc2
OLD_FILES+=usr/share/terminfo/x/xterm+pcc3
OLD_FILES+=usr/share/terminfo/x/xterm+pce2
OLD_FILES+=usr/share/terminfo/x/xterm+pcf0
OLD_FILES+=usr/share/terminfo/x/xterm+pcf2
OLD_FILES+=usr/share/terminfo/x/xterm+pcfkeys
OLD_FILES+=usr/share/terminfo/x/xterm+r6f2
OLD_FILES+=usr/share/terminfo/x/xterm+sl
OLD_FILES+=usr/share/terminfo/x/xterm+sl-twm
OLD_FILES+=usr/share/terminfo/x/xterm+sm+1002
OLD_FILES+=usr/share/terminfo/x/xterm+sm+1003
OLD_FILES+=usr/share/terminfo/x/xterm+sm+1005
OLD_FILES+=usr/share/terminfo/x/xterm+sm+1006
OLD_FILES+=usr/share/terminfo/x/xterm+titlestack
OLD_FILES+=usr/share/terminfo/x/xterm+tmux
OLD_FILES+=usr/share/terminfo/x/xterm+vt+edit
OLD_FILES+=usr/share/terminfo/x/xterm+x10mouse
OLD_FILES+=usr/share/terminfo/x/xterm+x11hilite
OLD_FILES+=usr/share/terminfo/x/xterm+x11mouse
OLD_FILES+=usr/share/terminfo/x/xterm-1002
OLD_FILES+=usr/share/terminfo/x/xterm-1003
OLD_FILES+=usr/share/terminfo/x/xterm-1005
OLD_FILES+=usr/share/terminfo/x/xterm-1006
OLD_FILES+=usr/share/terminfo/x/xterm-16color
OLD_FILES+=usr/share/terminfo/x/xterm-24
OLD_FILES+=usr/share/terminfo/x/xterm-256color
OLD_FILES+=usr/share/terminfo/x/xterm-88color
OLD_FILES+=usr/share/terminfo/x/xterm-8bit
OLD_FILES+=usr/share/terminfo/x/xterm-basic
OLD_FILES+=usr/share/terminfo/x/xterm-bold
OLD_FILES+=usr/share/terminfo/x/xterm-color
OLD_FILES+=usr/share/terminfo/x/xterm-direct
OLD_FILES+=usr/share/terminfo/x/xterm-direct16
OLD_FILES+=usr/share/terminfo/x/xterm-direct2
OLD_FILES+=usr/share/terminfo/x/xterm-direct256
OLD_FILES+=usr/share/terminfo/x/xterm-hp
OLD_FILES+=usr/share/terminfo/x/xterm-mono
OLD_FILES+=usr/share/terminfo/x/xterm-new
OLD_FILES+=usr/share/terminfo/x/xterm-nic
OLD_FILES+=usr/share/terminfo/x/xterm-noapp
OLD_FILES+=usr/share/terminfo/x/xterm-old
OLD_FILES+=usr/share/terminfo/x/xterm-pcolor
OLD_FILES+=usr/share/terminfo/x/xterm-r5
OLD_FILES+=usr/share/terminfo/x/xterm-r6
OLD_FILES+=usr/share/terminfo/x/xterm-sco
OLD_FILES+=usr/share/terminfo/x/xterm-sun
OLD_FILES+=usr/share/terminfo/x/xterm-utf8
OLD_FILES+=usr/share/terminfo/x/xterm-vt220
OLD_FILES+=usr/share/terminfo/x/xterm-vt52
OLD_FILES+=usr/share/terminfo/x/xterm-x10mouse
OLD_FILES+=usr/share/terminfo/x/xterm-x11hilite
OLD_FILES+=usr/share/terminfo/x/xterm-x11mouse
OLD_FILES+=usr/share/terminfo/x/xterm-xf86-v32
OLD_FILES+=usr/share/terminfo/x/xterm-xf86-v33
OLD_FILES+=usr/share/terminfo/x/xterm-xf86-v333
OLD_FILES+=usr/share/terminfo/x/xterm-xf86-v40
OLD_FILES+=usr/share/terminfo/x/xterm-xf86-v43
OLD_FILES+=usr/share/terminfo/x/xterm-xf86-v44
OLD_FILES+=usr/share/terminfo/x/xterm-xfree86
OLD_FILES+=usr/share/terminfo/x/xterm-xi
OLD_FILES+=usr/share/terminfo/x/xterm.js
OLD_FILES+=usr/share/terminfo/x/xterm1
OLD_FILES+=usr/share/terminfo/x/xtermc
OLD_FILES+=usr/share/terminfo/x/xtermm
OLD_FILES+=usr/share/terminfo/x/xterms
OLD_FILES+=usr/share/terminfo/x/xterms-sun
OLD_FILES+=usr/share/terminfo/x/xwsh
OLD_DIRS+=usr/share/terminfo/x/
OLD_FILES+=usr/share/terminfo/z/z-100
OLD_FILES+=usr/share/terminfo/z/z-100bw
OLD_FILES+=usr/share/terminfo/z/z100
OLD_FILES+=usr/share/terminfo/z/z100bw
OLD_FILES+=usr/share/terminfo/z/z110
OLD_FILES+=usr/share/terminfo/z/z110bw
OLD_FILES+=usr/share/terminfo/z/z19
OLD_FILES+=usr/share/terminfo/z/z29
OLD_FILES+=usr/share/terminfo/z/z29a
OLD_FILES+=usr/share/terminfo/z/z29a-kc-bc
OLD_FILES+=usr/share/terminfo/z/z29a-kc-uc
OLD_FILES+=usr/share/terminfo/z/z29a-nkc-bc
OLD_FILES+=usr/share/terminfo/z/z29a-nkc-uc
OLD_FILES+=usr/share/terminfo/z/z29b
OLD_FILES+=usr/share/terminfo/z/z30
OLD_FILES+=usr/share/terminfo/z/z340
OLD_FILES+=usr/share/terminfo/z/z340-nam
OLD_FILES+=usr/share/terminfo/z/z39-a
OLD_FILES+=usr/share/terminfo/z/z39a
OLD_FILES+=usr/share/terminfo/z/z50
OLD_FILES+=usr/share/terminfo/z/z8001
OLD_FILES+=usr/share/terminfo/z/zen30
OLD_FILES+=usr/share/terminfo/z/zen50
OLD_FILES+=usr/share/terminfo/z/zen8001
OLD_FILES+=usr/share/terminfo/z/zenith
OLD_FILES+=usr/share/terminfo/z/zenith29
OLD_FILES+=usr/share/terminfo/z/zenith39-a
OLD_FILES+=usr/share/terminfo/z/zenith39-ansi
OLD_FILES+=usr/share/terminfo/z/zt-1
OLD_FILES+=usr/share/terminfo/z/ztx
OLD_FILES+=usr/share/terminfo/z/ztx-1-a
OLD_FILES+=usr/share/terminfo/z/ztx11
OLD_DIRS+=usr/share/terminfo/z/
OLD_DIRS+=usr/share/terminfo/

# 20210316: remove obsolete NFS headers
OLD_FILES+=usr/include/nfs/nfs_common.h
OLD_FILES+=usr/include/nfsclient/nfsm_subs.h
OLD_FILES+=usr/include/nfsclient/nlminfo.h
OLD_FILES+=usr/include/nfsserver/nfs_fha_old.h
OLD_FILES+=usr/include/nfsserver/nfsm_subs.h
OLD_FILES+=usr/include/nfsserver/nfsrvcache.h

# 20210315: Remove kernel-only crypto headers from /usr/include
OLD_FILES+=usr/include/crypto/_cryptodev.h
OLD_FILES+=usr/include/crypto/cbc_mac.h
OLD_FILES+=usr/include/crypto/deflate.h
OLD_FILES+=usr/include/crypto/gfmult.h
OLD_FILES+=usr/include/crypto/gmac.h
OLD_FILES+=usr/include/crypto/rijndael.h
OLD_FILES+=usr/include/crypto/rmd160.h
OLD_FILES+=usr/include/crypto/xform.h
OLD_FILES+=usr/include/crypto/xform_auth.h
OLD_FILES+=usr/include/crypto/xform_comp.h
OLD_FILES+=usr/include/crypto/xform_enc.h

# 20210305: removed Poly1305_* symbols
OLD_FILES+=usr/include/crypto/xform_poly1305.h

# 20210302: fmtree removed
OLD_FILES+=usr/sbin/fmtree
OLD_FILES+=usr/share/man/man8/fmtree.8.gz

# 20210201: bump shared libraries which link against ncurses
OLD_LIBS+=lib/libedit.so.7
OLD_LIBS+=usr/lib/libdialog.so.8
OLD_LIBS+=usr/lib/libdpv.so.1
OLD_LIBS+=usr/lib/libform.so.5
OLD_LIBS+=usr/lib/libformw.so.5
OLD_LIBS+=usr/lib/libmenu.so.5
OLD_LIBS+=usr/lib/libmenuw.so.5
OLD_LIBS+=usr/lib/libpanel.so.5
OLD_LIBS+=usr/lib/libpanelw.so.5

# 20210125: ndis driver support removed
OLD_FILES+=usr/sbin/ndis_events
OLD_FILES+=usr/sbin/ndiscvt
OLD_FILES+=usr/sbin/ndisgen
OLD_FILES+=usr/share/man/man4/ndis.4.gz
OLD_FILES+=usr/share/man/man4/if_ndis.4.gz
OLD_FILES+=usr/share/man/man8/ndis_events.8.gz
OLD_FILES+=usr/share/man/man8/ndiscvt.8.gz
OLD_FILES+=usr/share/man/man8/ndisgen.8.gz
OLD_FILES+=usr/share/misc/windrv_stub.c

# 20210116: openpromio(4) removed
OLD_FILES+=usr/include/dev/ofw/openpromio.h

# 20210116: if_wl_wavelan.h removed
.if ${TARGET_ARCH} == "i386"
OLD_FILES+=usr/include/machine/if_wl_wavelan.h
.endif

# 20210108: retire cmx, ng_bt3c, wi drivers
OLD_FILES+=usr/include/dev/wi/if_wireg.h
OLD_FILES+=usr/include/dev/wi/if_wavelan_ieee.h
OLD_FILES+=usr/include/dev/wi/if_wivar.h
OLD_FILES+=usr/include/netgraph/bluetooth/include/ng_bt3c.h
OLD_FILES+=usr/sbin/bt3cfw
OLD_FILES+=usr/share/man/man4/cmw.4.gz
OLD_FILES+=usr/share/man/man4/if_wi.4.gz
OLD_FILES+=usr/share/man/man4/ng_bt3c.4.gz
OLD_FILES+=usr/share/man/man4/wi.4.gz
OLD_FILES+=usr/share/man/man8/bt3cfw.8.gz

# 20210107: retire a.out support
OLD_DIRS+=usr/lib/aout
OLD_DIRS+=usr/lib/compat/aout

# 20210107: remove cmx(4)
OLD_FILES+=usr/share/man/man4/cmx.4.gz

# 20210105: remove non widechar version of ncurses
OLD_LIBS+=lib/libncurses.so.9

# 20210103: new clang import which bumps version from 11.0.0 to 11.0.1
OLD_FILES+=usr/lib/clang/11.0.0/include/cuda_wrappers/algorithm
OLD_FILES+=usr/lib/clang/11.0.0/include/cuda_wrappers/complex
OLD_FILES+=usr/lib/clang/11.0.0/include/cuda_wrappers/new
OLD_DIRS+=usr/lib/clang/11.0.0/include/cuda_wrappers
OLD_FILES+=usr/lib/clang/11.0.0/include/fuzzer/FuzzedDataProvider.h
OLD_DIRS+=usr/lib/clang/11.0.0/include/fuzzer
OLD_FILES+=usr/lib/clang/11.0.0/include/openmp_wrappers/__clang_openmp_device_functions.h
OLD_FILES+=usr/lib/clang/11.0.0/include/openmp_wrappers/cmath
OLD_FILES+=usr/lib/clang/11.0.0/include/openmp_wrappers/complex
OLD_FILES+=usr/lib/clang/11.0.0/include/openmp_wrappers/complex.h
OLD_FILES+=usr/lib/clang/11.0.0/include/openmp_wrappers/math.h
OLD_FILES+=usr/lib/clang/11.0.0/include/openmp_wrappers/new
OLD_DIRS+=usr/lib/clang/11.0.0/include/openmp_wrappers
OLD_FILES+=usr/lib/clang/11.0.0/include/ppc_wrappers/emmintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/ppc_wrappers/mm_malloc.h
OLD_FILES+=usr/lib/clang/11.0.0/include/ppc_wrappers/mmintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/ppc_wrappers/pmmintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/ppc_wrappers/smmintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/ppc_wrappers/tmmintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/ppc_wrappers/xmmintrin.h
OLD_DIRS+=usr/lib/clang/11.0.0/include/ppc_wrappers
OLD_FILES+=usr/lib/clang/11.0.0/include/profile/InstrProfData.inc
OLD_DIRS+=usr/lib/clang/11.0.0/include/profile
OLD_FILES+=usr/lib/clang/11.0.0/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/11.0.0/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/11.0.0/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/11.0.0/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/11.0.0/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/11.0.0/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/11.0.0/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/11.0.0/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/11.0.0/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/11.0.0/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/11.0.0/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/11.0.0/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/11.0.0/include/sanitizer/tsan_interface_atomic.h
OLD_FILES+=usr/lib/clang/11.0.0/include/sanitizer/ubsan_interface.h
OLD_DIRS+=usr/lib/clang/11.0.0/include/sanitizer
OLD_FILES+=usr/lib/clang/11.0.0/include/xray/xray_interface.h
OLD_FILES+=usr/lib/clang/11.0.0/include/xray/xray_log_interface.h
OLD_FILES+=usr/lib/clang/11.0.0/include/xray/xray_records.h
OLD_DIRS+=usr/lib/clang/11.0.0/include/xray
OLD_FILES+=usr/lib/clang/11.0.0/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/11.0.0/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/11.0.0/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/11.0.0/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/11.0.0/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/11.0.0/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/11.0.0/include/__clang_cuda_math.h
OLD_FILES+=usr/lib/clang/11.0.0/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/11.0.0/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/11.0.0/include/__clang_hip_libdevice_declares.h
OLD_FILES+=usr/lib/clang/11.0.0/include/__clang_hip_math.h
OLD_FILES+=usr/lib/clang/11.0.0/include/__clang_hip_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/11.0.0/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/11.0.0/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/11.0.0/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/11.0.0/include/adxintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/altivec.h
OLD_FILES+=usr/lib/clang/11.0.0/include/ammintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/amxintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/arm64intr.h
OLD_FILES+=usr/lib/clang/11.0.0/include/arm_acle.h
OLD_FILES+=usr/lib/clang/11.0.0/include/arm_bf16.h
OLD_FILES+=usr/lib/clang/11.0.0/include/arm_cde.h
OLD_FILES+=usr/lib/clang/11.0.0/include/arm_cmse.h
OLD_FILES+=usr/lib/clang/11.0.0/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/11.0.0/include/arm_mve.h
OLD_FILES+=usr/lib/clang/11.0.0/include/arm_neon.h
OLD_FILES+=usr/lib/clang/11.0.0/include/arm_sve.h
OLD_FILES+=usr/lib/clang/11.0.0/include/armintr.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512bf16intrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512vlbf16intrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512vlvp2intersectintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512vp2intersectintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/avxintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/cet.h
OLD_FILES+=usr/lib/clang/11.0.0/include/cetintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/cpuid.h
OLD_FILES+=usr/lib/clang/11.0.0/include/emmintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/enqcmdintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/htmintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/immintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/11.0.0/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/11.0.0/include/mmintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/module.modulemap
OLD_FILES+=usr/lib/clang/11.0.0/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/msa.h
OLD_FILES+=usr/lib/clang/11.0.0/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/opencl-c-base.h
OLD_FILES+=usr/lib/clang/11.0.0/include/opencl-c.h
OLD_FILES+=usr/lib/clang/11.0.0/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/s390intrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/serializeintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/shaintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/smmintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/tsxldtrkintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/vadefs.h
OLD_FILES+=usr/lib/clang/11.0.0/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/vecintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/wasm_simd128.h
OLD_FILES+=usr/lib/clang/11.0.0/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/x86intrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/xopintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/11.0.0/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/11.0.0/include
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan-aarch64.so
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan-arm.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan-arm.so
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan-armhf.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan-armhf.so
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan-preinit-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan-preinit-arm.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan-preinit-armhf.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan_cxx-arm.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan_cxx-armhf.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.cfi-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.cfi-arm.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.cfi-armhf.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.cfi-i386.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.cfi-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.cfi_diag-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.cfi_diag-arm.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.cfi_diag-armhf.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.cfi_diag-i386.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.cfi_diag-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.dd-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.dd-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.fuzzer-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.fuzzer-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.fuzzer_no_main-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.fuzzer_no_main-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.msan-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.msan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.profile-powerpc.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.profile-powerpc64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.profile-powerpc64le.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.safestack-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.stats-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.stats-arm.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.stats-armhf.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.stats_client-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.stats_client-arm.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.stats_client-armhf.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.tsan-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.tsan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.ubsan_minimal-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.ubsan_minimal-arm.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.ubsan_minimal-armhf.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.ubsan_standalone-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.ubsan_standalone-arm.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.ubsan_standalone-armhf.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-arm.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-armhf.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.xray-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.xray-arm.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.xray-armhf.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.xray-basic-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.xray-basic-arm.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.xray-basic-armhf.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.xray-basic-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.xray-fdr-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.xray-fdr-arm.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.xray-fdr-armhf.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.xray-fdr-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.xray-profiling-aarch64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.xray-profiling-arm.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.xray-profiling-armhf.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.xray-profiling-x86_64.a
OLD_FILES+=usr/lib/clang/11.0.0/lib/freebsd/libclang_rt.xray-x86_64.a
OLD_DIRS+=usr/lib/clang/11.0.0/lib/freebsd
OLD_DIRS+=usr/lib/clang/11.0.0/lib
OLD_DIRS+=usr/lib/clang/11.0.0

# 20201226: Siemens SAB 82532 support removed
OLD_FILES+=usr/include/dev/ic/sab82532.h

# 20201225: PMC for Xscale removed
OLD_FILES+=usr/include/dev/hwpmc/hwpmc_xscale.h
OLD_FILES+=usr/share/man/man3/pmc.xscale.3.gz

# 20201225: libregex removed
OLD_FILES+=usr/include/gnu/posix/regex.h
OLD_DIRS+=usr/include/gnu/posix
OLD_FILES+=usr/include/gnu/regex.h
OLD_DIRS+=usr/include/gnu
OLD_FILES+=usr/include/gnuregex.h
OLD_FILES+=usr/lib/libgnuregex.a
OLD_FILES+=usr/lib/libgnuregex.so
OLD_LIBS+=usr/lib/libgnuregex.so.5
OLD_FILES+=usr/lib/libgnuregex_p.a

# 20201225: gnugrep removed
OLD_FILES+=usr/bin/bsdgrep
OLD_FILES+=usr/bin/gnugrep
OLD_FILES+=usr/share/man/man1/bsdgrep.1.gz
OLD_FILES+=usr/share/man/man1/gnugrep.1.gz

# 20201224: mk48txx(4) removed
OLD_FILES+=usr/share/man/man4/mk48txx.4.gz

# 20201215: in-tree gdb removed
OLD_FILES+=usr/libexec/gdb
OLD_FILES+=usr/libexec/kgdb

# 20201211: hme(4) removed
OLD_FILES+=usr/share/man/man4/hme.4.gz
OLD_FILES+=usr/share/man/man4/if_hme.4.gz

# 20201129: RADIX_MPATH removed
OLD_FILES+=usr/include/net/radix_mpath.h

# 20201124: ping6(8) was merged into ping(8)
OLD_FILES+=usr/tests/sbin/ping6/Kyuafile
OLD_FILES+=usr/tests/sbin/ping6/ping6_c1_s8_t1.out
OLD_FILES+=usr/tests/sbin/ping6/ping6_test
OLD_DIRS+=usr/tests/sbin/ping6

# 20201025: Remove cal data files
OLD_FILES+=usr/share/calendar/calendar.all
OLD_FILES+=usr/share/calendar/calendar.australia
OLD_FILES+=usr/share/calendar/calendar.birthday
OLD_FILES+=usr/share/calendar/calendar.brazilian
OLD_FILES+=usr/share/calendar/calendar.christian
OLD_FILES+=usr/share/calendar/calendar.computer
OLD_FILES+=usr/share/calendar/calendar.croatian
OLD_FILES+=usr/share/calendar/calendar.dutch
OLD_FILES+=usr/share/calendar/calendar.french
OLD_FILES+=usr/share/calendar/calendar.german
OLD_FILES+=usr/share/calendar/calendar.history
OLD_FILES+=usr/share/calendar/calendar.holiday
OLD_FILES+=usr/share/calendar/calendar.hungarian
OLD_FILES+=usr/share/calendar/calendar.judaic
OLD_FILES+=usr/share/calendar/calendar.lotr
OLD_FILES+=usr/share/calendar/calendar.music
OLD_FILES+=usr/share/calendar/calendar.newzealand
OLD_FILES+=usr/share/calendar/calendar.russian
OLD_FILES+=usr/share/calendar/calendar.southafrica
OLD_FILES+=usr/share/calendar/calendar.ukrainian
OLD_FILES+=usr/share/calendar/calendar.usholiday
OLD_FILES+=usr/share/calendar/calendar.world
OLD_FILES+=usr/share/calendar/de_AT.ISO_8859-15/calendar.feiertag
OLD_FILES+=usr/share/calendar/de_DE.ISO8859-1/calendar.all
OLD_FILES+=usr/share/calendar/de_DE.ISO8859-1/calendar.feiertag
OLD_FILES+=usr/share/calendar/de_DE.ISO8859-1/calendar.geschichte
OLD_FILES+=usr/share/calendar/de_DE.ISO8859-1/calendar.kirche
OLD_FILES+=usr/share/calendar/de_DE.ISO8859-1/calendar.literatur
OLD_FILES+=usr/share/calendar/de_DE.ISO8859-1/calendar.musik
OLD_FILES+=usr/share/calendar/de_DE.ISO8859-1/calendar.wissenschaft
OLD_FILES+=usr/share/calendar/fr_FR.ISO8859-1/calendar.all
OLD_FILES+=usr/share/calendar/fr_FR.ISO8859-1/calendar.fetes
OLD_FILES+=usr/share/calendar/fr_FR.ISO8859-1/calendar.french
OLD_FILES+=usr/share/calendar/fr_FR.ISO8859-1/calendar.jferies
OLD_FILES+=usr/share/calendar/fr_FR.ISO8859-1/calendar.proverbes
OLD_FILES+=usr/share/calendar/hr_HR.ISO8859-2/calendar.all
OLD_FILES+=usr/share/calendar/hr_HR.ISO8859-2/calendar.praznici
OLD_FILES+=usr/share/calendar/hu_HU.ISO8859-2/calendar.all
OLD_FILES+=usr/share/calendar/hu_HU.ISO8859-2/calendar.nevnapok
OLD_FILES+=usr/share/calendar/hu_HU.ISO8859-2/calendar.unnepek
OLD_FILES+=usr/share/calendar/pt_BR.ISO8859-1/calendar.all
OLD_FILES+=usr/share/calendar/pt_BR.ISO8859-1/calendar.commemorative
OLD_FILES+=usr/share/calendar/pt_BR.ISO8859-1/calendar.holidays
OLD_FILES+=usr/share/calendar/pt_BR.ISO8859-1/calendar.mcommemorative
OLD_FILES+=usr/share/calendar/pt_BR.UTF-8/calendar.all
OLD_FILES+=usr/share/calendar/pt_BR.UTF-8/calendar.commemorative
OLD_FILES+=usr/share/calendar/pt_BR.UTF-8/calendar.holidays
OLD_FILES+=usr/share/calendar/pt_BR.UTF-8/calendar.mcommemorative
OLD_FILES+=usr/share/calendar/ru_RU.KOI8-R/calendar.all
OLD_FILES+=usr/share/calendar/ru_RU.KOI8-R/calendar.common
OLD_FILES+=usr/share/calendar/ru_RU.KOI8-R/calendar.holiday
OLD_FILES+=usr/share/calendar/ru_RU.KOI8-R/calendar.military
OLD_FILES+=usr/share/calendar/ru_RU.KOI8-R/calendar.orthodox
OLD_FILES+=usr/share/calendar/ru_RU.KOI8-R/calendar.pagan
OLD_FILES+=usr/share/calendar/ru_RU.UTF-8/calendar.all
OLD_FILES+=usr/share/calendar/ru_RU.UTF-8/calendar.common
OLD_FILES+=usr/share/calendar/ru_RU.UTF-8/calendar.holiday
OLD_FILES+=usr/share/calendar/ru_RU.UTF-8/calendar.military
OLD_FILES+=usr/share/calendar/ru_RU.UTF-8/calendar.orthodox
OLD_FILES+=usr/share/calendar/ru_RU.UTF-8/calendar.pagan
OLD_FILES+=usr/share/calendar/uk_UA.KOI8-U/calendar.all
OLD_FILES+=usr/share/calendar/uk_UA.KOI8-U/calendar.holiday
OLD_FILES+=usr/share/calendar/uk_UA.KOI8-U/calendar.misc
OLD_FILES+=usr/share/calendar/uk_UA.KOI8-U/calendar.orthodox
OLD_DIRS+=usr/share/calendar/de_AT.ISO_8859-15
OLD_DIRS+=usr/share/calendar/de_DE.ISO8859-1
OLD_FILES+=usr/share/calendar/de_DE.ISO8859-15
OLD_DIRS+=usr/share/calendar/fr_FR.ISO8859-1
OLD_FILES+=usr/share/calendar/fr_FR.ISO8859-15
OLD_DIRS+=usr/share/calendar/hr_HR.ISO8859-2
OLD_DIRS+=usr/share/calendar/hu_HU.ISO8859-2
OLD_DIRS+=usr/share/calendar/pt_BR.ISO8859-1
OLD_DIRS+=usr/share/calendar/pt_BR.UTF-8
OLD_DIRS+=usr/share/calendar/ru_RU.KOI8-R
OLD_DIRS+=usr/share/calendar/ru_RU.UTF-8
OLD_DIRS+=usr/share/calendar/uk_UA.KOI8-U

# 20201004: logo files renamed to type-agnostic gfx-*.lua
OLD_FILES+=boot/lua/logo-beastie.lua
OLD_FILES+=boot/lua/logo-beastiebw.lua
OLD_FILES+=boot/lua/logo-fbsdbw.lua
OLD_FILES+=boot/lua/logo-orb.lua
OLD_FILES+=boot/lua/logo-orbbw.lua

# 20200828: net/route/shared.h moved to net/route/route_var.h
OLD_FILES+=usr/include/net/route/shared.h

# 20200825: merged OpenZFS support
OLD_LIBS+=lib/libzfs.so.3
OLD_FILES+=usr/share/man/man1/zstreamdump.1.gz
#OLD_FILES+=usr/share/man/man7/zpool-features.7.gz

# 20200923: memfd_test moved to /usr/tests/sys/posixshm
OLD_FILES+=usr/tests/sys/kern/memfd_test

# 20200910: remove vm_map_create(9) to sync with the code
OLD_FILES+=usr/share/man/man9/vm_map_create.9.gz

# 20200820: Removal of the ufm driver
OLD_FILES+=usr/share/man/man4/ufm.4.gz

# 20200816: new clang import which bumps version from 10.0.1 to 11.0.0
OLD_FILES+=usr/lib/clang/10.0.1/include/cuda_wrappers/algorithm
OLD_FILES+=usr/lib/clang/10.0.1/include/cuda_wrappers/complex
OLD_FILES+=usr/lib/clang/10.0.1/include/cuda_wrappers/new
OLD_DIRS+=usr/lib/clang/10.0.1/include/cuda_wrappers
OLD_FILES+=usr/lib/clang/10.0.1/include/fuzzer/FuzzedDataProvider.h
OLD_DIRS+=usr/lib/clang/10.0.1/include/fuzzer
OLD_FILES+=usr/lib/clang/10.0.1/include/openmp_wrappers/__clang_openmp_math.h
OLD_FILES+=usr/lib/clang/10.0.1/include/openmp_wrappers/__clang_openmp_math_declares.h
OLD_FILES+=usr/lib/clang/10.0.1/include/openmp_wrappers/cmath
OLD_FILES+=usr/lib/clang/10.0.1/include/openmp_wrappers/math.h
OLD_DIRS+=usr/lib/clang/10.0.1/include/openmp_wrappers
OLD_FILES+=usr/lib/clang/10.0.1/include/ppc_wrappers/emmintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/ppc_wrappers/mm_malloc.h
OLD_FILES+=usr/lib/clang/10.0.1/include/ppc_wrappers/mmintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/ppc_wrappers/pmmintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/ppc_wrappers/smmintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/ppc_wrappers/tmmintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/ppc_wrappers/xmmintrin.h
OLD_DIRS+=usr/lib/clang/10.0.1/include/ppc_wrappers
OLD_FILES+=usr/lib/clang/10.0.1/include/profile/InstrProfData.inc
OLD_DIRS+=usr/lib/clang/10.0.1/include/profile
OLD_FILES+=usr/lib/clang/10.0.1/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/10.0.1/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/10.0.1/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/10.0.1/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/10.0.1/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/10.0.1/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/10.0.1/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/10.0.1/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/10.0.1/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/10.0.1/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/10.0.1/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/10.0.1/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/10.0.1/include/sanitizer/tsan_interface_atomic.h
OLD_FILES+=usr/lib/clang/10.0.1/include/sanitizer/ubsan_interface.h
OLD_DIRS+=usr/lib/clang/10.0.1/include/sanitizer
OLD_FILES+=usr/lib/clang/10.0.1/include/xray/xray_interface.h
OLD_FILES+=usr/lib/clang/10.0.1/include/xray/xray_log_interface.h
OLD_FILES+=usr/lib/clang/10.0.1/include/xray/xray_records.h
OLD_DIRS+=usr/lib/clang/10.0.1/include/xray
OLD_FILES+=usr/lib/clang/10.0.1/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/10.0.1/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/10.0.1/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/10.0.1/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/10.0.1/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/10.0.1/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/10.0.1/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/10.0.1/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/10.0.1/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/10.0.1/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/10.0.1/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/10.0.1/include/adxintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/altivec.h
OLD_FILES+=usr/lib/clang/10.0.1/include/ammintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/arm64intr.h
OLD_FILES+=usr/lib/clang/10.0.1/include/arm_acle.h
OLD_FILES+=usr/lib/clang/10.0.1/include/arm_cmse.h
OLD_FILES+=usr/lib/clang/10.0.1/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/10.0.1/include/arm_mve.h
OLD_FILES+=usr/lib/clang/10.0.1/include/arm_neon.h
OLD_FILES+=usr/lib/clang/10.0.1/include/armintr.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512bf16intrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512vlbf16intrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512vlvp2intersectintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512vp2intersectintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/avxintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/cetintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/cpuid.h
OLD_FILES+=usr/lib/clang/10.0.1/include/emmintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/enqcmdintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/htmintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/immintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/10.0.1/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/10.0.1/include/mmintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/module.modulemap
OLD_FILES+=usr/lib/clang/10.0.1/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/msa.h
OLD_FILES+=usr/lib/clang/10.0.1/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/opencl-c-base.h
OLD_FILES+=usr/lib/clang/10.0.1/include/opencl-c.h
OLD_FILES+=usr/lib/clang/10.0.1/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/s390intrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/shaintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/smmintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/vadefs.h
OLD_FILES+=usr/lib/clang/10.0.1/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/vecintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/x86intrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/xopintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/10.0.1/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/10.0.1/include
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan-aarch64.so
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan-arm.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan-arm.so
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan-armhf.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan-armhf.so
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan-preinit-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan-preinit-arm.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan-preinit-armhf.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan_cxx-arm.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan_cxx-armhf.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.cfi-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.cfi-arm.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.cfi-armhf.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.cfi-i386.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.cfi-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.cfi_diag-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.cfi_diag-arm.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.cfi_diag-armhf.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.cfi_diag-i386.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.cfi_diag-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.dd-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.dd-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.fuzzer-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.fuzzer-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.fuzzer_no_main-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.fuzzer_no_main-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.msan-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.msan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.profile-powerpc.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.profile-powerpc64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.safestack-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.stats-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.stats-arm.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.stats-armhf.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.stats_client-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.stats_client-arm.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.stats_client-armhf.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.tsan-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.tsan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.ubsan_minimal-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.ubsan_minimal-arm.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.ubsan_minimal-armhf.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.ubsan_standalone-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.ubsan_standalone-arm.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.ubsan_standalone-armhf.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-arm.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-armhf.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.xray-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.xray-arm.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.xray-armhf.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.xray-basic-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.xray-basic-arm.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.xray-basic-armhf.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.xray-basic-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.xray-fdr-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.xray-fdr-arm.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.xray-fdr-armhf.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.xray-fdr-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.xray-profiling-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.xray-profiling-arm.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.xray-profiling-armhf.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.xray-profiling-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.1/lib/freebsd/libclang_rt.xray-x86_64.a
OLD_DIRS+=usr/lib/clang/10.0.1/lib/freebsd
OLD_DIRS+=usr/lib/clang/10.0.1/lib
OLD_DIRS+=usr/lib/clang/10.0.1

# 20200803: remove free_domain(9) and uma_zfree_domain(9)
OLD_FILES+=usr/share/man/man9/free_domain.9.gz
OLD_FILES+=usr/share/man/man9/uma_zfree_domain.9.gz

# 20200729: remove long expired serial drivers
OLD_FILES+=usr/share/man/man4/cy.4.gz
OLD_FILES+=usr/share/man/man4/rc.4.gz
OLD_FILES+=usr/share/man/man4/rp.4.gz

# 20200721: sys/iommu.h moved to dev/iommu/
OLD_FILES+=usr/include/sys/iommu.h

# 20200715: rework of devstat(9) man page
OLD_FILES+=usr/share/man/man9/devstat_add_entry.9.gz

# 20200714: update byacc to 20200330
OLD_FILES+=usr/tests/usr.bin/yacc/btyacc_calc1.y
OLD_FILES+=usr/tests/usr.bin/yacc/btyacc_demo.y
OLD_FILES+=usr/tests/usr.bin/yacc/btyacc_destroy1.y
OLD_FILES+=usr/tests/usr.bin/yacc/btyacc_destroy2.y
OLD_FILES+=usr/tests/usr.bin/yacc/btyacc_destroy3.y
OLD_FILES+=usr/tests/usr.bin/yacc/err_inherit1.y
OLD_FILES+=usr/tests/usr.bin/yacc/err_inherit2.y
OLD_FILES+=usr/tests/usr.bin/yacc/err_inherit3.y
OLD_FILES+=usr/tests/usr.bin/yacc/err_inherit4.y
OLD_FILES+=usr/tests/usr.bin/yacc/err_inherit5.y
OLD_FILES+=usr/tests/usr.bin/yacc/inherit0.y
OLD_FILES+=usr/tests/usr.bin/yacc/inherit1.y
OLD_FILES+=usr/tests/usr.bin/yacc/inherit2.y

# 20200706: update of sglist(9), r360574
OLD_FILES+=usr/share/man/man9/sglist_append_ext_pgs.9.gz
OLD_FILES+=usr/share/man/man9/sglist_append_mb_ext_pgs.9.gz
OLD_FILES+=usr/share/man/man9/sglist_count_ext_pgs.9.gz
OLD_FILES+=usr/share/man/man9/sglist_count_mb_ext_pgs.9.gz

# 20200617: update opencsd to 0.14.2
OLD_FILES+=usr/include/opencsd/etmv4/trc_pkt_elem_etmv4d.h

# 20200606: retire binutils build infrastructure
OLD_FILES+=usr/bin/as
OLD_FILES+=usr/bin/ld.bfd
OLD_FILES+=usr/share/man/man1/as.1.gz
OLD_FILES+=usr/share/man/man1/ld.bfd.1.gz
OLD_FILES+=usr/share/man/man7/as.7.gz
OLD_FILES+=usr/share/man/man7/ld.7.gz
OLD_FILES+=usr/share/man/man7/ldint.7.gz
OLD_FILES+=usr/share/man/man7/binutils.7.gz
OLD_FILES+=usr/libdata/ldscripts/armelf_fbsd.x
OLD_FILES+=usr/libdata/ldscripts/armelf_fbsd.xbn
OLD_FILES+=usr/libdata/ldscripts/armelf_fbsd.xc
OLD_FILES+=usr/libdata/ldscripts/armelf_fbsd.xd
OLD_FILES+=usr/libdata/ldscripts/armelf_fbsd.xdc
OLD_FILES+=usr/libdata/ldscripts/armelf_fbsd.xdw
OLD_FILES+=usr/libdata/ldscripts/armelf_fbsd.xn
OLD_FILES+=usr/libdata/ldscripts/armelf_fbsd.xr
OLD_FILES+=usr/libdata/ldscripts/armelf_fbsd.xs
OLD_FILES+=usr/libdata/ldscripts/armelf_fbsd.xsc
OLD_FILES+=usr/libdata/ldscripts/armelf_fbsd.xsw
OLD_FILES+=usr/libdata/ldscripts/armelf_fbsd.xu
OLD_FILES+=usr/libdata/ldscripts/armelf_fbsd.xw
OLD_FILES+=usr/libdata/ldscripts/armelfb_fbsd.x
OLD_FILES+=usr/libdata/ldscripts/armelfb_fbsd.xbn
OLD_FILES+=usr/libdata/ldscripts/armelfb_fbsd.xc
OLD_FILES+=usr/libdata/ldscripts/armelfb_fbsd.xd
OLD_FILES+=usr/libdata/ldscripts/armelfb_fbsd.xdc
OLD_FILES+=usr/libdata/ldscripts/armelfb_fbsd.xdw
OLD_FILES+=usr/libdata/ldscripts/armelfb_fbsd.xn
OLD_FILES+=usr/libdata/ldscripts/armelfb_fbsd.xr
OLD_FILES+=usr/libdata/ldscripts/armelfb_fbsd.xs
OLD_FILES+=usr/libdata/ldscripts/armelfb_fbsd.xsc
OLD_FILES+=usr/libdata/ldscripts/armelfb_fbsd.xsw
OLD_FILES+=usr/libdata/ldscripts/armelfb_fbsd.xu
OLD_FILES+=usr/libdata/ldscripts/armelfb_fbsd.xw
OLD_FILES+=usr/libdata/ldscripts/elf32_sparc.x
OLD_FILES+=usr/libdata/ldscripts/elf32_sparc.xbn
OLD_FILES+=usr/libdata/ldscripts/elf32_sparc.xc
OLD_FILES+=usr/libdata/ldscripts/elf32_sparc.xd
OLD_FILES+=usr/libdata/ldscripts/elf32_sparc.xdc
OLD_FILES+=usr/libdata/ldscripts/elf32_sparc.xdw
OLD_FILES+=usr/libdata/ldscripts/elf32_sparc.xn
OLD_FILES+=usr/libdata/ldscripts/elf32_sparc.xr
OLD_FILES+=usr/libdata/ldscripts/elf32_sparc.xs
OLD_FILES+=usr/libdata/ldscripts/elf32_sparc.xsc
OLD_FILES+=usr/libdata/ldscripts/elf32_sparc.xsw
OLD_FILES+=usr/libdata/ldscripts/elf32_sparc.xu
OLD_FILES+=usr/libdata/ldscripts/elf32_sparc.xw
OLD_FILES+=usr/libdata/ldscripts/elf32btsmip_fbsd.x
OLD_FILES+=usr/libdata/ldscripts/elf32btsmip_fbsd.xbn
OLD_FILES+=usr/libdata/ldscripts/elf32btsmip_fbsd.xc
OLD_FILES+=usr/libdata/ldscripts/elf32btsmip_fbsd.xd
OLD_FILES+=usr/libdata/ldscripts/elf32btsmip_fbsd.xdc
OLD_FILES+=usr/libdata/ldscripts/elf32btsmip_fbsd.xdw
OLD_FILES+=usr/libdata/ldscripts/elf32btsmip_fbsd.xn
OLD_FILES+=usr/libdata/ldscripts/elf32btsmip_fbsd.xr
OLD_FILES+=usr/libdata/ldscripts/elf32btsmip_fbsd.xs
OLD_FILES+=usr/libdata/ldscripts/elf32btsmip_fbsd.xsc
OLD_FILES+=usr/libdata/ldscripts/elf32btsmip_fbsd.xsw
OLD_FILES+=usr/libdata/ldscripts/elf32btsmip_fbsd.xu
OLD_FILES+=usr/libdata/ldscripts/elf32btsmip_fbsd.xw
OLD_FILES+=usr/libdata/ldscripts/elf32btsmipn32_fbsd.x
OLD_FILES+=usr/libdata/ldscripts/elf32btsmipn32_fbsd.xbn
OLD_FILES+=usr/libdata/ldscripts/elf32btsmipn32_fbsd.xc
OLD_FILES+=usr/libdata/ldscripts/elf32btsmipn32_fbsd.xd
OLD_FILES+=usr/libdata/ldscripts/elf32btsmipn32_fbsd.xdc
OLD_FILES+=usr/libdata/ldscripts/elf32btsmipn32_fbsd.xdw
OLD_FILES+=usr/libdata/ldscripts/elf32btsmipn32_fbsd.xn
OLD_FILES+=usr/libdata/ldscripts/elf32btsmipn32_fbsd.xr
OLD_FILES+=usr/libdata/ldscripts/elf32btsmipn32_fbsd.xs
OLD_FILES+=usr/libdata/ldscripts/elf32btsmipn32_fbsd.xsc
OLD_FILES+=usr/libdata/ldscripts/elf32btsmipn32_fbsd.xsw
OLD_FILES+=usr/libdata/ldscripts/elf32btsmipn32_fbsd.xu
OLD_FILES+=usr/libdata/ldscripts/elf32btsmipn32_fbsd.xw
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmip_fbsd.x
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmip_fbsd.xbn
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmip_fbsd.xc
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmip_fbsd.xd
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmip_fbsd.xdc
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmip_fbsd.xdw
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmip_fbsd.xn
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmip_fbsd.xr
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmip_fbsd.xs
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmip_fbsd.xsc
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmip_fbsd.xsw
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmip_fbsd.xu
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmip_fbsd.xw
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmipn32_fbsd.x
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmipn32_fbsd.xbn
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmipn32_fbsd.xc
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmipn32_fbsd.xd
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmipn32_fbsd.xdc
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmipn32_fbsd.xdw
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmipn32_fbsd.xn
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmipn32_fbsd.xr
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmipn32_fbsd.xs
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmipn32_fbsd.xsc
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmipn32_fbsd.xsw
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmipn32_fbsd.xu
OLD_FILES+=usr/libdata/ldscripts/elf32ltsmipn32_fbsd.xw
OLD_FILES+=usr/libdata/ldscripts/elf32ppc_fbsd.x
OLD_FILES+=usr/libdata/ldscripts/elf32ppc_fbsd.xbn
OLD_FILES+=usr/libdata/ldscripts/elf32ppc_fbsd.xc
OLD_FILES+=usr/libdata/ldscripts/elf32ppc_fbsd.xd
OLD_FILES+=usr/libdata/ldscripts/elf32ppc_fbsd.xdc
OLD_FILES+=usr/libdata/ldscripts/elf32ppc_fbsd.xdw
OLD_FILES+=usr/libdata/ldscripts/elf32ppc_fbsd.xn
OLD_FILES+=usr/libdata/ldscripts/elf32ppc_fbsd.xr
OLD_FILES+=usr/libdata/ldscripts/elf32ppc_fbsd.xs
OLD_FILES+=usr/libdata/ldscripts/elf32ppc_fbsd.xsc
OLD_FILES+=usr/libdata/ldscripts/elf32ppc_fbsd.xsw
OLD_FILES+=usr/libdata/ldscripts/elf32ppc_fbsd.xu
OLD_FILES+=usr/libdata/ldscripts/elf32ppc_fbsd.xw
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc.x
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc.xbn
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc.xc
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc.xd
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc.xdc
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc.xdw
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc.xn
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc.xr
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc.xs
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc.xsc
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc.xsw
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc.xu
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc.xw
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc_fbsd.x
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc_fbsd.xbn
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc_fbsd.xc
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc_fbsd.xd
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc_fbsd.xdc
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc_fbsd.xdw
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc_fbsd.xn
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc_fbsd.xr
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc_fbsd.xs
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc_fbsd.xsc
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc_fbsd.xsw
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc_fbsd.xu
OLD_FILES+=usr/libdata/ldscripts/elf64_sparc_fbsd.xw
OLD_FILES+=usr/libdata/ldscripts/elf64btsmip_fbsd.x
OLD_FILES+=usr/libdata/ldscripts/elf64btsmip_fbsd.xbn
OLD_FILES+=usr/libdata/ldscripts/elf64btsmip_fbsd.xc
OLD_FILES+=usr/libdata/ldscripts/elf64btsmip_fbsd.xd
OLD_FILES+=usr/libdata/ldscripts/elf64btsmip_fbsd.xdc
OLD_FILES+=usr/libdata/ldscripts/elf64btsmip_fbsd.xdw
OLD_FILES+=usr/libdata/ldscripts/elf64btsmip_fbsd.xn
OLD_FILES+=usr/libdata/ldscripts/elf64btsmip_fbsd.xr
OLD_FILES+=usr/libdata/ldscripts/elf64btsmip_fbsd.xs
OLD_FILES+=usr/libdata/ldscripts/elf64btsmip_fbsd.xsc
OLD_FILES+=usr/libdata/ldscripts/elf64btsmip_fbsd.xsw
OLD_FILES+=usr/libdata/ldscripts/elf64btsmip_fbsd.xu
OLD_FILES+=usr/libdata/ldscripts/elf64btsmip_fbsd.xw
OLD_FILES+=usr/libdata/ldscripts/elf64ltsmip_fbsd.x
OLD_FILES+=usr/libdata/ldscripts/elf64ltsmip_fbsd.xbn
OLD_FILES+=usr/libdata/ldscripts/elf64ltsmip_fbsd.xc
OLD_FILES+=usr/libdata/ldscripts/elf64ltsmip_fbsd.xd
OLD_FILES+=usr/libdata/ldscripts/elf64ltsmip_fbsd.xdc
OLD_FILES+=usr/libdata/ldscripts/elf64ltsmip_fbsd.xdw
OLD_FILES+=usr/libdata/ldscripts/elf64ltsmip_fbsd.xn
OLD_FILES+=usr/libdata/ldscripts/elf64ltsmip_fbsd.xr
OLD_FILES+=usr/libdata/ldscripts/elf64ltsmip_fbsd.xs
OLD_FILES+=usr/libdata/ldscripts/elf64ltsmip_fbsd.xsc
OLD_FILES+=usr/libdata/ldscripts/elf64ltsmip_fbsd.xsw
OLD_FILES+=usr/libdata/ldscripts/elf64ltsmip_fbsd.xu
OLD_FILES+=usr/libdata/ldscripts/elf64ltsmip_fbsd.xw
OLD_FILES+=usr/libdata/ldscripts/elf64ppc_fbsd.x
OLD_FILES+=usr/libdata/ldscripts/elf64ppc_fbsd.xbn
OLD_FILES+=usr/libdata/ldscripts/elf64ppc_fbsd.xc
OLD_FILES+=usr/libdata/ldscripts/elf64ppc_fbsd.xd
OLD_FILES+=usr/libdata/ldscripts/elf64ppc_fbsd.xdc
OLD_FILES+=usr/libdata/ldscripts/elf64ppc_fbsd.xdw
OLD_FILES+=usr/libdata/ldscripts/elf64ppc_fbsd.xn
OLD_FILES+=usr/libdata/ldscripts/elf64ppc_fbsd.xr
OLD_FILES+=usr/libdata/ldscripts/elf64ppc_fbsd.xs
OLD_FILES+=usr/libdata/ldscripts/elf64ppc_fbsd.xsc
OLD_FILES+=usr/libdata/ldscripts/elf64ppc_fbsd.xsw
OLD_FILES+=usr/libdata/ldscripts/elf64ppc_fbsd.xu
OLD_FILES+=usr/libdata/ldscripts/elf64ppc_fbsd.xw
OLD_FILES+=usr/libdata/ldscripts/elf_i386_fbsd.x
OLD_FILES+=usr/libdata/ldscripts/elf_i386_fbsd.xbn
OLD_FILES+=usr/libdata/ldscripts/elf_i386_fbsd.xc
OLD_FILES+=usr/libdata/ldscripts/elf_i386_fbsd.xd
OLD_FILES+=usr/libdata/ldscripts/elf_i386_fbsd.xdc
OLD_FILES+=usr/libdata/ldscripts/elf_i386_fbsd.xdw
OLD_FILES+=usr/libdata/ldscripts/elf_i386_fbsd.xn
OLD_FILES+=usr/libdata/ldscripts/elf_i386_fbsd.xr
OLD_FILES+=usr/libdata/ldscripts/elf_i386_fbsd.xs
OLD_FILES+=usr/libdata/ldscripts/elf_i386_fbsd.xsc
OLD_FILES+=usr/libdata/ldscripts/elf_i386_fbsd.xsw
OLD_FILES+=usr/libdata/ldscripts/elf_i386_fbsd.xu
OLD_FILES+=usr/libdata/ldscripts/elf_i386_fbsd.xw
OLD_FILES+=usr/libdata/ldscripts/elf_x86_64_fbsd.x
OLD_FILES+=usr/libdata/ldscripts/elf_x86_64_fbsd.xbn
OLD_FILES+=usr/libdata/ldscripts/elf_x86_64_fbsd.xc
OLD_FILES+=usr/libdata/ldscripts/elf_x86_64_fbsd.xd
OLD_FILES+=usr/libdata/ldscripts/elf_x86_64_fbsd.xdc
OLD_FILES+=usr/libdata/ldscripts/elf_x86_64_fbsd.xdw
OLD_FILES+=usr/libdata/ldscripts/elf_x86_64_fbsd.xn
OLD_FILES+=usr/libdata/ldscripts/elf_x86_64_fbsd.xr
OLD_FILES+=usr/libdata/ldscripts/elf_x86_64_fbsd.xs
OLD_FILES+=usr/libdata/ldscripts/elf_x86_64_fbsd.xsc
OLD_FILES+=usr/libdata/ldscripts/elf_x86_64_fbsd.xsw
OLD_FILES+=usr/libdata/ldscripts/elf_x86_64_fbsd.xu
OLD_FILES+=usr/libdata/ldscripts/elf_x86_64_fbsd.xw

# 20200601: OpenSSL 32-bit compat engines moved to /usr/lib32/engines
OLD_LIBS+=usr/lib32/capi.so
OLD_LIBS+=usr/lib32/padlock.so

# 20200528: libevent renamed libevent1
OLD_FILES+=usr/include/private/event/event.h
OLD_DIRS+=usr/include/private/event
OLD_FILES+=usr/lib/libprivateevent.a
OLD_FILES+=usr/lib/libprivateevent.so
OLD_LIBS+=usr/lib/libprivateevent.so.1
OLD_FILES+=usr/lib/libprivateevent_p.a

# 20200523: new clang import which bumps version from 10.0.0 to 10.0.1
OLD_FILES+=usr/lib/clang/10.0.0/include/cuda_wrappers/algorithm
OLD_FILES+=usr/lib/clang/10.0.0/include/cuda_wrappers/complex
OLD_FILES+=usr/lib/clang/10.0.0/include/cuda_wrappers/new
OLD_DIRS+=usr/lib/clang/10.0.0/include/cuda_wrappers
OLD_FILES+=usr/lib/clang/10.0.0/include/fuzzer/FuzzedDataProvider.h
OLD_DIRS+=usr/lib/clang/10.0.0/include/fuzzer
OLD_FILES+=usr/lib/clang/10.0.0/include/openmp_wrappers/__clang_openmp_math.h
OLD_FILES+=usr/lib/clang/10.0.0/include/openmp_wrappers/__clang_openmp_math_declares.h
OLD_FILES+=usr/lib/clang/10.0.0/include/openmp_wrappers/cmath
OLD_FILES+=usr/lib/clang/10.0.0/include/openmp_wrappers/math.h
OLD_DIRS+=usr/lib/clang/10.0.0/include/openmp_wrappers
OLD_FILES+=usr/lib/clang/10.0.0/include/ppc_wrappers/emmintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/ppc_wrappers/mm_malloc.h
OLD_FILES+=usr/lib/clang/10.0.0/include/ppc_wrappers/mmintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/ppc_wrappers/pmmintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/ppc_wrappers/smmintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/ppc_wrappers/tmmintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/ppc_wrappers/xmmintrin.h
OLD_DIRS+=usr/lib/clang/10.0.0/include/ppc_wrappers
OLD_FILES+=usr/lib/clang/10.0.0/include/profile/InstrProfData.inc
OLD_DIRS+=usr/lib/clang/10.0.0/include/profile
OLD_FILES+=usr/lib/clang/10.0.0/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/10.0.0/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/10.0.0/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/10.0.0/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/10.0.0/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/10.0.0/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/10.0.0/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/10.0.0/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/10.0.0/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/10.0.0/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/10.0.0/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/10.0.0/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/10.0.0/include/sanitizer/tsan_interface_atomic.h
OLD_FILES+=usr/lib/clang/10.0.0/include/sanitizer/ubsan_interface.h
OLD_DIRS+=usr/lib/clang/10.0.0/include/sanitizer
OLD_FILES+=usr/lib/clang/10.0.0/include/xray/xray_interface.h
OLD_FILES+=usr/lib/clang/10.0.0/include/xray/xray_log_interface.h
OLD_FILES+=usr/lib/clang/10.0.0/include/xray/xray_records.h
OLD_DIRS+=usr/lib/clang/10.0.0/include/xray
OLD_FILES+=usr/lib/clang/10.0.0/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/10.0.0/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/10.0.0/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/10.0.0/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/10.0.0/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/10.0.0/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/10.0.0/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/10.0.0/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/10.0.0/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/10.0.0/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/10.0.0/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/10.0.0/include/adxintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/altivec.h
OLD_FILES+=usr/lib/clang/10.0.0/include/ammintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/arm64intr.h
OLD_FILES+=usr/lib/clang/10.0.0/include/arm_acle.h
OLD_FILES+=usr/lib/clang/10.0.0/include/arm_cmse.h
OLD_FILES+=usr/lib/clang/10.0.0/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/10.0.0/include/arm_mve.h
OLD_FILES+=usr/lib/clang/10.0.0/include/arm_neon.h
OLD_FILES+=usr/lib/clang/10.0.0/include/armintr.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512bf16intrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512vlbf16intrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512vlvp2intersectintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512vp2intersectintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/avxintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/cetintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/cpuid.h
OLD_FILES+=usr/lib/clang/10.0.0/include/emmintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/enqcmdintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/htmintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/immintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/10.0.0/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/10.0.0/include/mmintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/module.modulemap
OLD_FILES+=usr/lib/clang/10.0.0/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/msa.h
OLD_FILES+=usr/lib/clang/10.0.0/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/opencl-c-base.h
OLD_FILES+=usr/lib/clang/10.0.0/include/opencl-c.h
OLD_FILES+=usr/lib/clang/10.0.0/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/s390intrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/shaintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/smmintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/vadefs.h
OLD_FILES+=usr/lib/clang/10.0.0/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/vecintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/x86intrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/xopintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/10.0.0/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/10.0.0/include
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan-aarch64.so
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan-arm.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan-arm.so
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan-armhf.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan-armhf.so
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan-preinit-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan-preinit-arm.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan-preinit-armhf.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan_cxx-arm.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan_cxx-armhf.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.cfi-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.cfi-arm.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.cfi-armhf.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.cfi-i386.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.cfi-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.cfi_diag-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.cfi_diag-arm.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.cfi_diag-armhf.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.cfi_diag-i386.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.cfi_diag-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.dd-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.dd-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.fuzzer-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.fuzzer-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.fuzzer_no_main-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.fuzzer_no_main-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.msan-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.msan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.profile-powerpc.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.profile-powerpc64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.safestack-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.stats-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.stats-arm.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.stats-armhf.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.stats_client-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.stats_client-arm.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.stats_client-armhf.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.tsan-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.tsan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.ubsan_minimal-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.ubsan_minimal-arm.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.ubsan_minimal-armhf.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.ubsan_standalone-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.ubsan_standalone-arm.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.ubsan_standalone-armhf.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-arm.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-armhf.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.xray-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.xray-arm.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.xray-armhf.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.xray-basic-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.xray-basic-arm.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.xray-basic-armhf.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.xray-basic-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.xray-fdr-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.xray-fdr-arm.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.xray-fdr-armhf.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.xray-fdr-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.xray-profiling-aarch64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.xray-profiling-arm.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.xray-profiling-armhf.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.xray-profiling-x86_64.a
OLD_FILES+=usr/lib/clang/10.0.0/lib/freebsd/libclang_rt.xray-x86_64.a
OLD_DIRS+=usr/lib/clang/10.0.0/lib/freebsd
OLD_DIRS+=usr/lib/clang/10.0.0/lib
OLD_DIRS+=usr/lib/clang/10.0.0

# 20200520: xform_userland.h removed
OLD_FILES+=usr/include/crypto/xform_userland.h

# 20200515: libalias cuseeme protocol support retired
OLD_LIBS+=lib/libalias_cuseeme.so
OLD_FILES+=usr/lib/libalias_cuseeme.a
OLD_FILES+=usr/lib/libalias_cuseeme_p.a

# 20200511: Remove deprecated crypto algorithms
OLD_FILES+=usr/include/crypto/cast.h
OLD_FILES+=usr/include/crypto/castsb.h
OLD_FILES+=usr/include/crypto/skipjack.h

# 20200511: Remove ubsec(4)
OLD_FILES+=usr/share/man/man4/ubsec.4.gz

# 20200428: route_var.h moved to net/route
OLD_FILES+=usr/include/net/route_var.h

# 20200418: Make libauditd private
OLD_FILES+=usr/lib/libauditd.a
OLD_FILES+=usr/lib/libauditd.so
OLD_LIBS+=usr/lib/libauditd.so.5
OLD_FILES+=usr/lib/libauditd_p.a

# 20200418: Remove bogus man links
OLD_FILES+=usr/share/man/man3/getauusernam_R.3.gz
OLD_FILES+=usr/share/man/man3/getauclassnam_3.3.gz

# 20200414: NFS file handle affinity code for the NFS server re-organized
OLD_FILES+=usr/include/nfs/nfs_fha.h

# 20200401: Remove procfs-based process debugging
OLD_FILES+=usr/include/sys/pioctl.h

# 20200330: GDB_LIBEXEC option retired (always true)
OLD_FILES+=usr/bin/gdb
OLD_FILES+=usr/bin/gdbserver
OLD_FILES+=usr/bin/kgdb
OLD_FILES+=usr/share/man/man1/gdb.1.gz
OLD_FILES+=usr/share/man/man1/gdbserver.1.gz
OLD_FILES+=usr/share/man/man1/kgdb.1.gz

# 20200327: OCF refactoring
OLD_FILES+=usr/include/crypto/cryptosoft.h
OLD_FILES+=usr/share/man/man9/crypto_find_driver.9.gz
OLD_FILES+=usr/share/man/man9/crypto_register.9.gz
OLD_FILES+=usr/share/man/man9/crypto_unregister.9.gz

# 20200326: compat libs for libl are no longer built
OLD_FILES+=usr/lib32/libfl.a
OLD_FILES+=usr/lib32/libl.a
OLD_FILES+=usr/lib32/libln.a

# 20200323: INTERNALLIB don't install headers anymore
OLD_FILES+=usr/include/libelftc.h
OLD_FILES+=usr/include/libifconfig.h
OLD_FILES+=usr/include/libpmcstat.h

# 20200320: cx and ctau drivers retired
OLD_FILES+=usr/share/man/man4/ctau.4.gz
OLD_FILES+=usr/share/man/man4/cx.4.gz

# 20200318: host.conf was deprecated a long time ago
OLD_FILES+=etc/host.conf
OLD_FILES+=etc/rc.d/nsswitch

# 20200310: new clang import which bumps version from 9.0.1 to 10.0.0
OLD_FILES+=usr/lib/clang/9.0.1/include/cuda_wrappers/algorithm
OLD_FILES+=usr/lib/clang/9.0.1/include/cuda_wrappers/complex
OLD_FILES+=usr/lib/clang/9.0.1/include/cuda_wrappers/new
OLD_DIRS+=usr/lib/clang/9.0.1/include/cuda_wrappers
OLD_FILES+=usr/lib/clang/9.0.1/include/openmp_wrappers/__clang_openmp_math.h
OLD_FILES+=usr/lib/clang/9.0.1/include/openmp_wrappers/__clang_openmp_math_declares.h
OLD_FILES+=usr/lib/clang/9.0.1/include/openmp_wrappers/cmath
OLD_FILES+=usr/lib/clang/9.0.1/include/openmp_wrappers/math.h
OLD_DIRS+=usr/lib/clang/9.0.1/include/openmp_wrappers
OLD_FILES+=usr/lib/clang/9.0.1/include/ppc_wrappers/emmintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/ppc_wrappers/mm_malloc.h
OLD_FILES+=usr/lib/clang/9.0.1/include/ppc_wrappers/mmintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/ppc_wrappers/xmmintrin.h
OLD_DIRS+=usr/lib/clang/9.0.1/include/ppc_wrappers
OLD_FILES+=usr/lib/clang/9.0.1/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/9.0.1/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/9.0.1/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/9.0.1/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/9.0.1/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/9.0.1/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/9.0.1/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/9.0.1/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/9.0.1/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/9.0.1/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/9.0.1/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/9.0.1/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/9.0.1/include/sanitizer/tsan_interface_atomic.h
OLD_DIRS+=usr/lib/clang/9.0.1/include/sanitizer
OLD_FILES+=usr/lib/clang/9.0.1/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/9.0.1/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/9.0.1/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/9.0.1/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/9.0.1/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/9.0.1/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/9.0.1/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/9.0.1/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/9.0.1/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/9.0.1/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/9.0.1/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/9.0.1/include/adxintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/altivec.h
OLD_FILES+=usr/lib/clang/9.0.1/include/ammintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/arm64intr.h
OLD_FILES+=usr/lib/clang/9.0.1/include/arm_acle.h
OLD_FILES+=usr/lib/clang/9.0.1/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/9.0.1/include/arm_neon.h
OLD_FILES+=usr/lib/clang/9.0.1/include/armintr.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512bf16intrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512vlbf16intrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512vlvp2intersectintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512vp2intersectintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/avxintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/cetintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/cpuid.h
OLD_FILES+=usr/lib/clang/9.0.1/include/emmintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/enqcmdintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/htmintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/immintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/9.0.1/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/9.0.1/include/mmintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/module.modulemap
OLD_FILES+=usr/lib/clang/9.0.1/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/msa.h
OLD_FILES+=usr/lib/clang/9.0.1/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/opencl-c-base.h
OLD_FILES+=usr/lib/clang/9.0.1/include/opencl-c.h
OLD_FILES+=usr/lib/clang/9.0.1/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/s390intrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/shaintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/smmintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/vadefs.h
OLD_FILES+=usr/lib/clang/9.0.1/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/vecintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/x86intrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/xopintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/9.0.1/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/9.0.1/include
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan-aarch64.so
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan-arm.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan-arm.so
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan-armhf.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan-armhf.so
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan-preinit-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan-preinit-arm.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan-preinit-armhf.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan_cxx-arm.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan_cxx-armhf.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.cfi-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.cfi-arm.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.cfi-armhf.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.cfi-i386.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.cfi-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.cfi_diag-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.cfi_diag-arm.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.cfi_diag-armhf.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.cfi_diag-i386.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.cfi_diag-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.dd-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.dd-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.fuzzer-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.fuzzer-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.fuzzer_no_main-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.fuzzer_no_main-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.msan-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.msan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.profile-powerpc.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.profile-powerpc64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.safestack-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.stats-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.stats-arm.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.stats-armhf.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.stats_client-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.stats_client-arm.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.stats_client-armhf.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.tsan-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.tsan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.ubsan_minimal-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.ubsan_minimal-arm.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.ubsan_minimal-armhf.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.ubsan_standalone-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.ubsan_standalone-arm.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.ubsan_standalone-armhf.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-arm.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-armhf.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.xray-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.xray-arm.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.xray-armhf.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.xray-basic-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.xray-basic-arm.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.xray-basic-armhf.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.xray-basic-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.xray-fdr-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.xray-fdr-arm.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.xray-fdr-armhf.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.xray-fdr-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.xray-profiling-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.xray-profiling-arm.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.xray-profiling-armhf.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.xray-profiling-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.1/lib/freebsd/libclang_rt.xray-x86_64.a
OLD_DIRS+=usr/lib/clang/9.0.1/lib/freebsd
OLD_DIRS+=usr/lib/clang/9.0.1/lib
OLD_DIRS+=usr/lib/clang/9.0.1

# 20200309: amd(8) retired
OLD_FILES+=etc/amd.map
OLD_FILES+=etc/newsyslog.conf.d/amd.conf
OLD_FILES+=etc/rc.d/amd
OLD_FILES+=usr/bin/pawd
OLD_FILES+=usr/sbin/amd
OLD_FILES+=usr/sbin/amq
OLD_FILES+=usr/sbin/fixmount
OLD_FILES+=usr/sbin/fsinfo
OLD_FILES+=usr/sbin/hlfsd
OLD_FILES+=usr/sbin/mk-amd-map
OLD_FILES+=usr/sbin/wire-test
OLD_FILES+=usr/share/examples/etc/amd.map
OLD_FILES+=usr/share/man/man1/pawd.1.gz
OLD_FILES+=usr/share/man/man5/amd.conf.5.gz
OLD_FILES+=usr/share/man/man8/amd.8.gz
OLD_FILES+=usr/share/man/man8/amq.8.gz
OLD_FILES+=usr/share/man/man8/fixmount.8.gz
OLD_FILES+=usr/share/man/man8/fsinfo.8.gz
OLD_FILES+=usr/share/man/man8/hlfsd.8.gz
OLD_FILES+=usr/share/man/man8/mk-amd-map.8.gz
OLD_FILES+=usr/share/man/man8/wire-test.8.gz

# 20200301: bktr removed
OLD_DIRS+=usr/include/dev/bktr
OLD_FILES+=usr/include/dev/bktr/ioctl_bktr.h
OLD_FILES+=usr/include/dev/bktr/ioctl_bt848.h
OLD_FILES+=usr/include/dev/bktr/ioctl_meteor.h
.if ${TARGET_ARCH} == "i386"
OLD_FILES+=usr/include/machine/ioctl_bktr.h
OLD_FILES+=usr/include/machine/ioctl_meteor.h
.endif
OLD_FILES+=usr/share/man/man4/bktr.4.gz
OLD_FILES+=usr/share/man/man4/brooktree.4.gz

# 20200229: GCC 4.2.1 removed
OLD_FILES+=usr/bin/g++
OLD_FILES+=usr/bin/gcc
OLD_FILES+=usr/share/man/man1/g++.1.gz
OLD_FILES+=usr/share/man/man1/gcc.1.gz
OLD_FILES+=usr/bin/gcpp
OLD_FILES+=usr/bin/gperf
OLD_FILES+=usr/include/c++/4.2/algorithm
OLD_FILES+=usr/include/c++/4.2/backward/algo.h
OLD_FILES+=usr/include/c++/4.2/backward/algobase.h
OLD_FILES+=usr/include/c++/4.2/backward/alloc.h
OLD_FILES+=usr/include/c++/4.2/backward/backward_warning.h
OLD_FILES+=usr/include/c++/4.2/backward/bvector.h
OLD_FILES+=usr/include/c++/4.2/backward/complex.h
OLD_FILES+=usr/include/c++/4.2/backward/defalloc.h
OLD_FILES+=usr/include/c++/4.2/backward/deque.h
OLD_FILES+=usr/include/c++/4.2/backward/fstream.h
OLD_FILES+=usr/include/c++/4.2/backward/function.h
OLD_FILES+=usr/include/c++/4.2/backward/hash_map.h
OLD_FILES+=usr/include/c++/4.2/backward/hash_set.h
OLD_FILES+=usr/include/c++/4.2/backward/hashtable.h
OLD_FILES+=usr/include/c++/4.2/backward/heap.h
OLD_FILES+=usr/include/c++/4.2/backward/iomanip.h
OLD_FILES+=usr/include/c++/4.2/backward/iostream.h
OLD_FILES+=usr/include/c++/4.2/backward/istream.h
OLD_FILES+=usr/include/c++/4.2/backward/iterator.h
OLD_FILES+=usr/include/c++/4.2/backward/list.h
OLD_FILES+=usr/include/c++/4.2/backward/map.h
OLD_FILES+=usr/include/c++/4.2/backward/multimap.h
OLD_FILES+=usr/include/c++/4.2/backward/multiset.h
OLD_FILES+=usr/include/c++/4.2/backward/new.h
OLD_FILES+=usr/include/c++/4.2/backward/ostream.h
OLD_FILES+=usr/include/c++/4.2/backward/pair.h
OLD_FILES+=usr/include/c++/4.2/backward/queue.h
OLD_FILES+=usr/include/c++/4.2/backward/rope.h
OLD_FILES+=usr/include/c++/4.2/backward/set.h
OLD_FILES+=usr/include/c++/4.2/backward/slist.h
OLD_FILES+=usr/include/c++/4.2/backward/stack.h
OLD_FILES+=usr/include/c++/4.2/backward/stream.h
OLD_FILES+=usr/include/c++/4.2/backward/streambuf.h
OLD_FILES+=usr/include/c++/4.2/backward/strstream
OLD_FILES+=usr/include/c++/4.2/backward/tempbuf.h
OLD_FILES+=usr/include/c++/4.2/backward/tree.h
OLD_FILES+=usr/include/c++/4.2/backward/vector.h
OLD_FILES+=usr/include/c++/4.2/bits/allocator.h
OLD_FILES+=usr/include/c++/4.2/bits/atomic_word.h
OLD_FILES+=usr/include/c++/4.2/bits/basic_file.h
OLD_FILES+=usr/include/c++/4.2/bits/basic_ios.h
OLD_FILES+=usr/include/c++/4.2/bits/basic_ios.tcc
OLD_FILES+=usr/include/c++/4.2/bits/basic_string.h
OLD_FILES+=usr/include/c++/4.2/bits/basic_string.tcc
OLD_FILES+=usr/include/c++/4.2/bits/boost_concept_check.h
OLD_FILES+=usr/include/c++/4.2/bits/c++allocator.h
OLD_FILES+=usr/include/c++/4.2/bits/c++config.h
OLD_FILES+=usr/include/c++/4.2/bits/c++io.h
OLD_FILES+=usr/include/c++/4.2/bits/c++locale.h
OLD_FILES+=usr/include/c++/4.2/bits/c++locale_internal.h
OLD_FILES+=usr/include/c++/4.2/bits/char_traits.h
OLD_FILES+=usr/include/c++/4.2/bits/cmath.tcc
OLD_FILES+=usr/include/c++/4.2/bits/codecvt.h
OLD_FILES+=usr/include/c++/4.2/bits/compatibility.h
OLD_FILES+=usr/include/c++/4.2/bits/concept_check.h
OLD_FILES+=usr/include/c++/4.2/bits/cpp_type_traits.h
OLD_FILES+=usr/include/c++/4.2/bits/cpu_defines.h
OLD_FILES+=usr/include/c++/4.2/bits/ctype_base.h
OLD_FILES+=usr/include/c++/4.2/bits/ctype_inline.h
OLD_FILES+=usr/include/c++/4.2/bits/ctype_noninline.h
OLD_FILES+=usr/include/c++/4.2/bits/cxxabi_tweaks.h
OLD_FILES+=usr/include/c++/4.2/bits/deque.tcc
OLD_FILES+=usr/include/c++/4.2/bits/fstream.tcc
OLD_FILES+=usr/include/c++/4.2/bits/functexcept.h
OLD_FILES+=usr/include/c++/4.2/bits/gslice.h
OLD_FILES+=usr/include/c++/4.2/bits/gslice_array.h
OLD_FILES+=usr/include/c++/4.2/bits/gthr-default.h
OLD_FILES+=usr/include/c++/4.2/bits/gthr-posix.h
OLD_FILES+=usr/include/c++/4.2/bits/gthr-single.h
OLD_FILES+=usr/include/c++/4.2/bits/gthr-tpf.h
OLD_FILES+=usr/include/c++/4.2/bits/gthr.h
OLD_FILES+=usr/include/c++/4.2/bits/indirect_array.h
OLD_FILES+=usr/include/c++/4.2/bits/ios_base.h
OLD_FILES+=usr/include/c++/4.2/bits/istream.tcc
OLD_FILES+=usr/include/c++/4.2/bits/list.tcc
OLD_FILES+=usr/include/c++/4.2/bits/locale_classes.h
OLD_FILES+=usr/include/c++/4.2/bits/locale_facets.h
OLD_FILES+=usr/include/c++/4.2/bits/locale_facets.tcc
OLD_FILES+=usr/include/c++/4.2/bits/localefwd.h
OLD_FILES+=usr/include/c++/4.2/bits/mask_array.h
OLD_FILES+=usr/include/c++/4.2/bits/messages_members.h
OLD_FILES+=usr/include/c++/4.2/bits/os_defines.h
OLD_FILES+=usr/include/c++/4.2/bits/ostream.tcc
OLD_FILES+=usr/include/c++/4.2/bits/ostream_insert.h
OLD_FILES+=usr/include/c++/4.2/bits/postypes.h
OLD_FILES+=usr/include/c++/4.2/bits/slice_array.h
OLD_FILES+=usr/include/c++/4.2/bits/sstream.tcc
OLD_FILES+=usr/include/c++/4.2/bits/stl_algo.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_algobase.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_bvector.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_construct.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_deque.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_function.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_heap.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_iterator.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_iterator_base_funcs.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_iterator_base_types.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_list.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_map.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_multimap.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_multiset.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_numeric.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_pair.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_queue.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_raw_storage_iter.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_relops.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_set.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_stack.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_tempbuf.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_tree.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_uninitialized.h
OLD_FILES+=usr/include/c++/4.2/bits/stl_vector.h
OLD_FILES+=usr/include/c++/4.2/bits/stream_iterator.h
OLD_FILES+=usr/include/c++/4.2/bits/streambuf.tcc
OLD_FILES+=usr/include/c++/4.2/bits/streambuf_iterator.h
OLD_FILES+=usr/include/c++/4.2/bits/stringfwd.h
OLD_FILES+=usr/include/c++/4.2/bits/time_members.h
OLD_FILES+=usr/include/c++/4.2/bits/valarray_after.h
OLD_FILES+=usr/include/c++/4.2/bits/valarray_array.h
OLD_FILES+=usr/include/c++/4.2/bits/valarray_array.tcc
OLD_FILES+=usr/include/c++/4.2/bits/valarray_before.h
OLD_FILES+=usr/include/c++/4.2/bits/vector.tcc
OLD_FILES+=usr/include/c++/4.2/bitset
OLD_FILES+=usr/include/c++/4.2/cassert
OLD_FILES+=usr/include/c++/4.2/cctype
OLD_FILES+=usr/include/c++/4.2/cerrno
OLD_FILES+=usr/include/c++/4.2/cfloat
OLD_FILES+=usr/include/c++/4.2/ciso646
OLD_FILES+=usr/include/c++/4.2/climits
OLD_FILES+=usr/include/c++/4.2/clocale
OLD_FILES+=usr/include/c++/4.2/cmath
OLD_FILES+=usr/include/c++/4.2/complex
OLD_FILES+=usr/include/c++/4.2/csetjmp
OLD_FILES+=usr/include/c++/4.2/csignal
OLD_FILES+=usr/include/c++/4.2/cstdarg
OLD_FILES+=usr/include/c++/4.2/cstddef
OLD_FILES+=usr/include/c++/4.2/cstdio
OLD_FILES+=usr/include/c++/4.2/cstdlib
OLD_FILES+=usr/include/c++/4.2/cstring
OLD_FILES+=usr/include/c++/4.2/ctime
OLD_FILES+=usr/include/c++/4.2/cwchar
OLD_FILES+=usr/include/c++/4.2/cwctype
OLD_FILES+=usr/include/c++/4.2/cxxabi.h
OLD_FILES+=usr/include/c++/4.2/debug/bitset
OLD_FILES+=usr/include/c++/4.2/debug/debug.h
OLD_FILES+=usr/include/c++/4.2/debug/deque
OLD_FILES+=usr/include/c++/4.2/debug/formatter.h
OLD_FILES+=usr/include/c++/4.2/debug/functions.h
OLD_FILES+=usr/include/c++/4.2/debug/hash_map
OLD_FILES+=usr/include/c++/4.2/debug/hash_map.h
OLD_FILES+=usr/include/c++/4.2/debug/hash_multimap.h
OLD_FILES+=usr/include/c++/4.2/debug/hash_multiset.h
OLD_FILES+=usr/include/c++/4.2/debug/hash_set
OLD_FILES+=usr/include/c++/4.2/debug/hash_set.h
OLD_FILES+=usr/include/c++/4.2/debug/list
OLD_FILES+=usr/include/c++/4.2/debug/macros.h
OLD_FILES+=usr/include/c++/4.2/debug/map
OLD_FILES+=usr/include/c++/4.2/debug/map.h
OLD_FILES+=usr/include/c++/4.2/debug/multimap.h
OLD_FILES+=usr/include/c++/4.2/debug/multiset.h
OLD_FILES+=usr/include/c++/4.2/debug/safe_base.h
OLD_FILES+=usr/include/c++/4.2/debug/safe_iterator.h
OLD_FILES+=usr/include/c++/4.2/debug/safe_iterator.tcc
OLD_FILES+=usr/include/c++/4.2/debug/safe_sequence.h
OLD_FILES+=usr/include/c++/4.2/debug/set
OLD_FILES+=usr/include/c++/4.2/debug/set.h
OLD_FILES+=usr/include/c++/4.2/debug/string
OLD_FILES+=usr/include/c++/4.2/debug/vector
OLD_FILES+=usr/include/c++/4.2/deque
OLD_FILES+=usr/include/c++/4.2/exception
OLD_FILES+=usr/include/c++/4.2/exception_defines.h
OLD_FILES+=usr/include/c++/4.2/ext/algorithm
OLD_FILES+=usr/include/c++/4.2/ext/array_allocator.h
OLD_FILES+=usr/include/c++/4.2/ext/atomicity.h
OLD_FILES+=usr/include/c++/4.2/ext/bitmap_allocator.h
OLD_FILES+=usr/include/c++/4.2/ext/codecvt_specializations.h
OLD_FILES+=usr/include/c++/4.2/ext/concurrence.h
OLD_FILES+=usr/include/c++/4.2/ext/debug_allocator.h
OLD_FILES+=usr/include/c++/4.2/ext/functional
OLD_FILES+=usr/include/c++/4.2/ext/hash_fun.h
OLD_FILES+=usr/include/c++/4.2/ext/hash_map
OLD_FILES+=usr/include/c++/4.2/ext/hash_set
OLD_FILES+=usr/include/c++/4.2/ext/hashtable.h
OLD_FILES+=usr/include/c++/4.2/ext/iterator
OLD_FILES+=usr/include/c++/4.2/ext/malloc_allocator.h
OLD_FILES+=usr/include/c++/4.2/ext/memory
OLD_FILES+=usr/include/c++/4.2/ext/mt_allocator.h
OLD_FILES+=usr/include/c++/4.2/ext/new_allocator.h
OLD_FILES+=usr/include/c++/4.2/ext/numeric
OLD_FILES+=usr/include/c++/4.2/ext/numeric_traits.h
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/assoc_container.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/basic_tree_policy/basic_tree_policy_base.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/basic_tree_policy/null_node_metadata.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/basic_tree_policy/traits.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/basic_types.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/bin_search_tree_.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/cond_dtor_entry_dealtor.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/cond_key_dtor_entry_dealtor.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/constructors_destructor_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/debug_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/erase_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/find_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/info_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/insert_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/iterators_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/node_iterators.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/point_iterators.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/policy_access_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/r_erase_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/rotate_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/split_join_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_/traits.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_/binary_heap_.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_/const_iterator.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_/const_point_iterator.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_/constructors_destructor_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_/debug_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_/entry_cmp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_/entry_pred.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_/erase_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_/find_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_/info_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_/insert_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_/iterators_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_/policy_access_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_/resize_policy.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_/split_join_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_/trace_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binomial_heap_/binomial_heap_.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binomial_heap_/constructors_destructor_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binomial_heap_/debug_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binomial_heap_base_/binomial_heap_base_.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binomial_heap_base_/constructors_destructor_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binomial_heap_base_/debug_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binomial_heap_base_/erase_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binomial_heap_base_/find_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binomial_heap_base_/insert_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/binomial_heap_base_/split_join_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/cc_ht_map_.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/cmp_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/cond_key_dtor_entry_dealtor.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/constructor_destructor_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/constructor_destructor_no_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/constructor_destructor_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/debug_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/debug_no_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/debug_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/entry_list_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/erase_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/erase_no_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/erase_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/find_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/find_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/info_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/insert_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/insert_no_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/insert_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/iterators_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/policy_access_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/resize_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/resize_no_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/resize_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/size_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/standard_policies.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_/trace_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/cond_dealtor.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/constructors_destructor_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/container_base_dispatch.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/eq_fn/eq_by_less.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/eq_fn/hash_eq_fn.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/constructor_destructor_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/constructor_destructor_no_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/constructor_destructor_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/debug_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/debug_no_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/debug_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/erase_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/erase_no_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/erase_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/find_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/find_no_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/find_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/gp_ht_map_.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/info_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/insert_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/insert_no_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/insert_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/iterator_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/policy_access_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/resize_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/resize_no_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/resize_store_hash_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/standard_policies.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_/trace_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/hash_fn/direct_mask_range_hashing_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/hash_fn/direct_mod_range_hashing_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/hash_fn/linear_probe_fn_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/hash_fn/mask_based_range_hashing.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/hash_fn/mod_based_range_hashing.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/hash_fn/probe_fn_base.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/hash_fn/quadratic_probe_fn_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/hash_fn/ranged_hash_fn.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/hash_fn/ranged_probe_fn.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/hash_fn/sample_probe_fn.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/hash_fn/sample_range_hashing.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/hash_fn/sample_ranged_hash_fn.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/hash_fn/sample_ranged_probe_fn.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/left_child_next_sibling_heap_/const_iterator.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/left_child_next_sibling_heap_/const_point_iterator.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/left_child_next_sibling_heap_/constructors_destructor_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/left_child_next_sibling_heap_/debug_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/left_child_next_sibling_heap_/erase_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/left_child_next_sibling_heap_/info_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/left_child_next_sibling_heap_/insert_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/left_child_next_sibling_heap_/iterators_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/left_child_next_sibling_heap_/left_child_next_sibling_heap_.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/left_child_next_sibling_heap_/node.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/left_child_next_sibling_heap_/null_metadata.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/left_child_next_sibling_heap_/policy_access_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/left_child_next_sibling_heap_/trace_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/list_update_map_/constructor_destructor_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/list_update_map_/debug_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/list_update_map_/entry_metadata_base.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/list_update_map_/erase_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/list_update_map_/find_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/list_update_map_/info_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/list_update_map_/insert_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/list_update_map_/iterators_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/list_update_map_/lu_map_.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/list_update_map_/trace_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/list_update_policy/counter_lu_metadata.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/list_update_policy/counter_lu_policy_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/list_update_policy/mtf_lu_policy_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/list_update_policy/sample_update_policy.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/map_debug_base.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/ov_tree_map_/cond_dtor.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/ov_tree_map_/constructors_destructor_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/ov_tree_map_/debug_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/ov_tree_map_/erase_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/ov_tree_map_/info_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/ov_tree_map_/insert_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/ov_tree_map_/iterators_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/ov_tree_map_/node_iterators.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/ov_tree_map_/ov_tree_map_.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/ov_tree_map_/policy_access_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/ov_tree_map_/split_join_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/ov_tree_map_/traits.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pairing_heap_/constructors_destructor_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pairing_heap_/debug_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pairing_heap_/erase_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pairing_heap_/find_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pairing_heap_/insert_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pairing_heap_/pairing_heap_.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pairing_heap_/split_join_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/child_iterator.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/cond_dtor_entry_dealtor.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/const_child_iterator.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/constructors_destructor_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/debug_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/erase_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/find_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/head.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/info_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/insert_join_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/internal_node.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/iterators_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/leaf.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/node_base.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/node_iterators.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/node_metadata_base.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/pat_trie_.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/point_iterators.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/policy_access_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/r_erase_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/rotate_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/split_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/split_join_branch_bag.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/synth_e_access_traits.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/trace_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/traits.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_/update_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/priority_queue_base_dispatch.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rb_tree_map_/constructors_destructor_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rb_tree_map_/debug_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rb_tree_map_/erase_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rb_tree_map_/find_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rb_tree_map_/info_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rb_tree_map_/insert_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rb_tree_map_/node.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rb_tree_map_/rb_tree_.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rb_tree_map_/split_join_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rb_tree_map_/traits.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rc_binomial_heap_/constructors_destructor_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rc_binomial_heap_/debug_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rc_binomial_heap_/erase_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rc_binomial_heap_/insert_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rc_binomial_heap_/rc.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rc_binomial_heap_/rc_binomial_heap_.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rc_binomial_heap_/split_join_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/rc_binomial_heap_/trace_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/resize_policy/cc_hash_max_collision_check_resize_trigger_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/resize_policy/hash_exponential_size_policy_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/resize_policy/hash_load_check_resize_trigger_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/resize_policy/hash_load_check_resize_trigger_size_base.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/resize_policy/hash_prime_size_policy_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/resize_policy/hash_standard_resize_policy_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/resize_policy/sample_resize_policy.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/resize_policy/sample_resize_trigger.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/resize_policy/sample_size_policy.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/splay_tree_/constructors_destructor_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/splay_tree_/debug_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/splay_tree_/erase_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/splay_tree_/find_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/splay_tree_/info_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/splay_tree_/insert_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/splay_tree_/node.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/splay_tree_/splay_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/splay_tree_/splay_tree_.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/splay_tree_/split_join_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/splay_tree_/traits.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/standard_policies.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/thin_heap_/constructors_destructor_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/thin_heap_/debug_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/thin_heap_/erase_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/thin_heap_/find_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/thin_heap_/insert_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/thin_heap_/split_join_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/thin_heap_/thin_heap_.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/thin_heap_/trace_fn_imps.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/tree_policy/node_metadata_selector.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/tree_policy/null_node_update_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/tree_policy/order_statistics_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/tree_policy/sample_tree_node_update.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/tree_trace_base.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/trie_policy/node_metadata_selector.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/trie_policy/null_node_update_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/trie_policy/order_statistics_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/trie_policy/prefix_search_node_update_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/trie_policy/sample_trie_e_access_traits.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/trie_policy/sample_trie_node_update.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/trie_policy/string_trie_e_access_traits_imp.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/trie_policy/trie_policy_base.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/type_utils.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/types_traits.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/unordered_iterator/const_iterator.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/unordered_iterator/const_point_iterator.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/unordered_iterator/iterator.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/detail/unordered_iterator/point_iterator.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/exception.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/hash_policy.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/list_update_policy.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/priority_queue.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/tag_and_trait.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/tree_policy.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pb_ds/trie_policy.hpp
OLD_FILES+=usr/include/c++/4.2/ext/pod_char_traits.h
OLD_FILES+=usr/include/c++/4.2/ext/pool_allocator.h
OLD_FILES+=usr/include/c++/4.2/ext/rb_tree
OLD_FILES+=usr/include/c++/4.2/ext/rc_string_base.h
OLD_FILES+=usr/include/c++/4.2/ext/rope
OLD_FILES+=usr/include/c++/4.2/ext/ropeimpl.h
OLD_FILES+=usr/include/c++/4.2/ext/slist
OLD_FILES+=usr/include/c++/4.2/ext/sso_string_base.h
OLD_FILES+=usr/include/c++/4.2/ext/stdio_filebuf.h
OLD_FILES+=usr/include/c++/4.2/ext/stdio_sync_filebuf.h
OLD_FILES+=usr/include/c++/4.2/ext/throw_allocator.h
OLD_FILES+=usr/include/c++/4.2/ext/type_traits.h
OLD_FILES+=usr/include/c++/4.2/ext/typelist.h
OLD_FILES+=usr/include/c++/4.2/ext/vstring.h
OLD_FILES+=usr/include/c++/4.2/ext/vstring.tcc
OLD_FILES+=usr/include/c++/4.2/ext/vstring_fwd.h
OLD_FILES+=usr/include/c++/4.2/ext/vstring_util.h
OLD_FILES+=usr/include/c++/4.2/fstream
OLD_FILES+=usr/include/c++/4.2/functional
OLD_FILES+=usr/include/c++/4.2/iomanip
OLD_FILES+=usr/include/c++/4.2/ios
OLD_FILES+=usr/include/c++/4.2/iosfwd
OLD_FILES+=usr/include/c++/4.2/iostream
OLD_FILES+=usr/include/c++/4.2/istream
OLD_FILES+=usr/include/c++/4.2/iterator
OLD_FILES+=usr/include/c++/4.2/limits
OLD_FILES+=usr/include/c++/4.2/list
OLD_FILES+=usr/include/c++/4.2/locale
OLD_FILES+=usr/include/c++/4.2/map
OLD_FILES+=usr/include/c++/4.2/memory
OLD_FILES+=usr/include/c++/4.2/new
OLD_FILES+=usr/include/c++/4.2/numeric
OLD_FILES+=usr/include/c++/4.2/ostream
OLD_FILES+=usr/include/c++/4.2/queue
OLD_FILES+=usr/include/c++/4.2/set
OLD_FILES+=usr/include/c++/4.2/sstream
OLD_FILES+=usr/include/c++/4.2/stack
OLD_FILES+=usr/include/c++/4.2/stdexcept
OLD_FILES+=usr/include/c++/4.2/streambuf
OLD_FILES+=usr/include/c++/4.2/string
OLD_FILES+=usr/include/c++/4.2/tr1/array
OLD_FILES+=usr/include/c++/4.2/tr1/bind_iterate.h
OLD_FILES+=usr/include/c++/4.2/tr1/bind_repeat.h
OLD_FILES+=usr/include/c++/4.2/tr1/boost_shared_ptr.h
OLD_FILES+=usr/include/c++/4.2/tr1/cctype
OLD_FILES+=usr/include/c++/4.2/tr1/cfenv
OLD_FILES+=usr/include/c++/4.2/tr1/cfloat
OLD_FILES+=usr/include/c++/4.2/tr1/cinttypes
OLD_FILES+=usr/include/c++/4.2/tr1/climits
OLD_FILES+=usr/include/c++/4.2/tr1/cmath
OLD_FILES+=usr/include/c++/4.2/tr1/common.h
OLD_FILES+=usr/include/c++/4.2/tr1/complex
OLD_FILES+=usr/include/c++/4.2/tr1/cstdarg
OLD_FILES+=usr/include/c++/4.2/tr1/cstdbool
OLD_FILES+=usr/include/c++/4.2/tr1/cstdint
OLD_FILES+=usr/include/c++/4.2/tr1/cstdio
OLD_FILES+=usr/include/c++/4.2/tr1/cstdlib
OLD_FILES+=usr/include/c++/4.2/tr1/ctgmath
OLD_FILES+=usr/include/c++/4.2/tr1/ctime
OLD_FILES+=usr/include/c++/4.2/tr1/ctype.h
OLD_FILES+=usr/include/c++/4.2/tr1/cwchar
OLD_FILES+=usr/include/c++/4.2/tr1/cwctype
OLD_FILES+=usr/include/c++/4.2/tr1/fenv.h
OLD_FILES+=usr/include/c++/4.2/tr1/float.h
OLD_FILES+=usr/include/c++/4.2/tr1/functional
OLD_FILES+=usr/include/c++/4.2/tr1/functional_hash.h
OLD_FILES+=usr/include/c++/4.2/tr1/functional_iterate.h
OLD_FILES+=usr/include/c++/4.2/tr1/hashtable
OLD_FILES+=usr/include/c++/4.2/tr1/hashtable_policy.h
OLD_FILES+=usr/include/c++/4.2/tr1/inttypes.h
OLD_FILES+=usr/include/c++/4.2/tr1/limits.h
OLD_FILES+=usr/include/c++/4.2/tr1/math.h
OLD_FILES+=usr/include/c++/4.2/tr1/memory
OLD_FILES+=usr/include/c++/4.2/tr1/mu_iterate.h
OLD_FILES+=usr/include/c++/4.2/tr1/random
OLD_FILES+=usr/include/c++/4.2/tr1/random.tcc
OLD_FILES+=usr/include/c++/4.2/tr1/ref_fwd.h
OLD_FILES+=usr/include/c++/4.2/tr1/ref_wrap_iterate.h
OLD_FILES+=usr/include/c++/4.2/tr1/repeat.h
OLD_FILES+=usr/include/c++/4.2/tr1/stdarg.h
OLD_FILES+=usr/include/c++/4.2/tr1/stdbool.h
OLD_FILES+=usr/include/c++/4.2/tr1/stdint.h
OLD_FILES+=usr/include/c++/4.2/tr1/stdio.h
OLD_FILES+=usr/include/c++/4.2/tr1/stdlib.h
OLD_FILES+=usr/include/c++/4.2/tr1/tgmath.h
OLD_FILES+=usr/include/c++/4.2/tr1/tuple
OLD_FILES+=usr/include/c++/4.2/tr1/tuple_defs.h
OLD_FILES+=usr/include/c++/4.2/tr1/tuple_iterate.h
OLD_FILES+=usr/include/c++/4.2/tr1/type_traits
OLD_FILES+=usr/include/c++/4.2/tr1/type_traits_fwd.h
OLD_FILES+=usr/include/c++/4.2/tr1/unordered_map
OLD_FILES+=usr/include/c++/4.2/tr1/unordered_set
OLD_FILES+=usr/include/c++/4.2/tr1/utility
OLD_FILES+=usr/include/c++/4.2/tr1/wchar.h
OLD_FILES+=usr/include/c++/4.2/tr1/wctype.h
OLD_FILES+=usr/include/c++/4.2/typeinfo
OLD_FILES+=usr/include/c++/4.2/utility
OLD_FILES+=usr/include/c++/4.2/valarray
OLD_FILES+=usr/include/c++/4.2/vector
.if ${TARGET_ARCH} == "amd64" || ${TARGET_ARCH} == "i386"
OLD_FILES+=usr/include/gcc/4.2/__wmmintrin_aes.h
OLD_FILES+=usr/include/gcc/4.2/__wmmintrin_pclmul.h
OLD_FILES+=usr/include/gcc/4.2/ammintrin.h
OLD_FILES+=usr/include/gcc/4.2/emmintrin.h
OLD_FILES+=usr/include/gcc/4.2/mm3dnow.h
OLD_FILES+=usr/include/gcc/4.2/mm_malloc.h
OLD_FILES+=usr/include/gcc/4.2/mmintrin.h
OLD_FILES+=usr/include/gcc/4.2/pmmintrin.h
OLD_FILES+=usr/include/gcc/4.2/tmmintrin.h
OLD_FILES+=usr/include/gcc/4.2/wmmintrin.h
OLD_FILES+=usr/include/gcc/4.2/xmmintrin.h
.elif ${TARGET_ARCH} == "arm"
OLD_FILES+=usr/include/gcc/4.2/mmintrin.h
.elif ${TARGET_ARCH} == "powerpc" || ${TARGET_ARCH} == "powerpc64"
OLD_FILES+=usr/include/gcc/4.2/altivec.h
OLD_FILES+=usr/include/gcc/4.2/ppc-asm.h
OLD_FILES+=usr/include/gcc/4.2/spe.h
.endif
OLD_FILES+=usr/lib/libgcov.a
OLD_FILES+=usr/lib/libgomp.a
OLD_FILES+=usr/lib/libstdc++.a
OLD_FILES+=usr/lib/libstdc++.so
OLD_LIBS+=usr/lib/libstdc++.so.6
OLD_FILES+=usr/lib/libstdc++_p.a
OLD_FILES+=usr/lib/libsupc++.a
OLD_FILES+=usr/lib/libsupc++.so
OLD_LIBS+=usr/lib/libsupc++.so.1
OLD_FILES+=usr/lib/libsupc++_p.a
OLD_LIBS+=usr/lib/libgomp.so.1
OLD_FILES+=usr/lib/libgomp_p.a
OLD_FILES+=usr/libexec/cc1
OLD_FILES+=usr/libexec/cc1plus
OLD_FILES+=usr/share/man/man1/gcpp.1.gz
OLD_FILES+=usr/share/man/man1/gperf.1.gz
OLD_FILES+=usr/share/man/man7/gperf.7.gz
OLD_DIRS+=usr/include/c++/4.2/tr1
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/unordered_iterator
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/trie_policy
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/tree_policy
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/thin_heap_
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/splay_tree_
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/resize_policy
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/rc_binomial_heap_
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/rb_tree_map_
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/pat_trie_
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/pairing_heap_
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/ov_tree_map_
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/list_update_policy
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/list_update_map_
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/left_child_next_sibling_heap_
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/hash_fn
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/gp_hash_table_map_
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/eq_fn
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/cc_hash_table_map_
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/binomial_heap_base_
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/binomial_heap_
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/binary_heap_
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/bin_search_tree_
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail/basic_tree_policy
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds/detail
OLD_DIRS+=usr/include/c++/4.2/ext/pb_ds
OLD_DIRS+=usr/include/c++/4.2/ext
OLD_DIRS+=usr/include/c++/4.2/debug
OLD_DIRS+=usr/include/c++/4.2/bits
OLD_DIRS+=usr/include/c++/4.2/backward
OLD_DIRS+=usr/include/c++/4.2
OLD_DIRS+=usr/include/gcc/4.2
OLD_DIRS+=usr/include/gcc

# 20200220: Upgrade of ncurses, shlib bumped to version 9
OLD_LIBS+=lib/libncurses.so.8
OLD_LIBS+=lib/libncursesw.so.8

# 20200206: Remove elf2aout
OLD_FILES+=usr/bin/elf2aout
OLD_FILES+=usr/share/man/man1/elf2aout.1.gz

# 20200204: simple_httpd removed
OLD_FILES+=usr/sbin/simple_httpd

# 20200127: vpo removed
OLD_FILES+=usr/include/dev/ppbus/vpoio.h
OLD_FILES+=usr/share/man/man4/imm.4.gz
OLD_FILES+=usr/share/man/man4/vpo.4.gz

# 20200104: gcc libssp removed
OLD_FILES+=usr/lib/libssp.a

# 20191229: GEOM_SCHED class and gsched tool removed
OLD_LIBS+=lib/geom/geom_sched.so
OLD_FILES+=sbin/gsched
OLD_FILES+=usr/share/man/man8/gsched.8.gz

# 20191222: new clang import which bumps version from 9.0.0 to 9.0.1
OLD_FILES+=usr/lib/clang/9.0.0/include/cuda_wrappers/algorithm
OLD_FILES+=usr/lib/clang/9.0.0/include/cuda_wrappers/complex
OLD_FILES+=usr/lib/clang/9.0.0/include/cuda_wrappers/new
OLD_DIRS+=usr/lib/clang/9.0.0/include/cuda_wrappers
OLD_FILES+=usr/lib/clang/9.0.0/include/openmp_wrappers/__clang_openmp_math.h
OLD_FILES+=usr/lib/clang/9.0.0/include/openmp_wrappers/__clang_openmp_math_declares.h
OLD_FILES+=usr/lib/clang/9.0.0/include/openmp_wrappers/cmath
OLD_FILES+=usr/lib/clang/9.0.0/include/openmp_wrappers/math.h
OLD_DIRS+=usr/lib/clang/9.0.0/include/openmp_wrappers
OLD_FILES+=usr/lib/clang/9.0.0/include/ppc_wrappers/emmintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/ppc_wrappers/mm_malloc.h
OLD_FILES+=usr/lib/clang/9.0.0/include/ppc_wrappers/mmintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/ppc_wrappers/xmmintrin.h
OLD_DIRS+=usr/lib/clang/9.0.0/include/ppc_wrappers
OLD_FILES+=usr/lib/clang/9.0.0/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/9.0.0/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/9.0.0/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/9.0.0/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/9.0.0/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/9.0.0/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/9.0.0/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/9.0.0/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/9.0.0/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/9.0.0/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/9.0.0/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/9.0.0/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/9.0.0/include/sanitizer/tsan_interface_atomic.h
OLD_DIRS+=usr/lib/clang/9.0.0/include/sanitizer
OLD_FILES+=usr/lib/clang/9.0.0/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/9.0.0/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/9.0.0/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/9.0.0/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/9.0.0/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/9.0.0/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/9.0.0/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/9.0.0/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/9.0.0/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/9.0.0/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/9.0.0/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/9.0.0/include/adxintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/altivec.h
OLD_FILES+=usr/lib/clang/9.0.0/include/ammintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/arm64intr.h
OLD_FILES+=usr/lib/clang/9.0.0/include/arm_acle.h
OLD_FILES+=usr/lib/clang/9.0.0/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/9.0.0/include/arm_neon.h
OLD_FILES+=usr/lib/clang/9.0.0/include/armintr.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512bf16intrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512vlbf16intrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512vlvp2intersectintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512vp2intersectintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/avxintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/cetintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/cpuid.h
OLD_FILES+=usr/lib/clang/9.0.0/include/emmintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/enqcmdintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/htmintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/immintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/9.0.0/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/9.0.0/include/mmintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/module.modulemap
OLD_FILES+=usr/lib/clang/9.0.0/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/msa.h
OLD_FILES+=usr/lib/clang/9.0.0/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/opencl-c-base.h
OLD_FILES+=usr/lib/clang/9.0.0/include/opencl-c.h
OLD_FILES+=usr/lib/clang/9.0.0/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/s390intrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/shaintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/smmintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/vadefs.h
OLD_FILES+=usr/lib/clang/9.0.0/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/vecintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/x86intrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/xopintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/9.0.0/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/9.0.0/include
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan-aarch64.so
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan-arm.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan-arm.so
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan-armhf.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan-armhf.so
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan-preinit-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan-preinit-arm.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan-preinit-armhf.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan_cxx-arm.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan_cxx-armhf.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.cfi-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.cfi-arm.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.cfi-armhf.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.cfi-i386.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.cfi-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.cfi_diag-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.cfi_diag-arm.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.cfi_diag-armhf.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.cfi_diag-i386.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.cfi_diag-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.dd-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.dd-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.fuzzer-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.fuzzer-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.fuzzer_no_main-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.fuzzer_no_main-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.msan-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.msan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.profile-powerpc.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.profile-powerpc64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.safestack-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.stats-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.stats-arm.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.stats-armhf.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.stats_client-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.stats_client-arm.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.stats_client-armhf.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.tsan-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.tsan_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.ubsan_minimal-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.ubsan_minimal-arm.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.ubsan_minimal-armhf.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.ubsan_standalone-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.ubsan_standalone-arm.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.ubsan_standalone-armhf.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-arm.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-armhf.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.xray-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.xray-arm.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.xray-armhf.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.xray-basic-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.xray-basic-arm.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.xray-basic-armhf.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.xray-basic-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.xray-fdr-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.xray-fdr-arm.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.xray-fdr-armhf.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.xray-fdr-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.xray-profiling-aarch64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.xray-profiling-arm.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.xray-profiling-armhf.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.xray-profiling-x86_64.a
OLD_FILES+=usr/lib/clang/9.0.0/lib/freebsd/libclang_rt.xray-x86_64.a
OLD_DIRS+=usr/lib/clang/9.0.0/lib/freebsd
OLD_DIRS+=usr/lib/clang/9.0.0/lib
OLD_DIRS+=usr/lib/clang/9.0.0
# 20191221: Update libpcap from 1.9.0 to 1.9.1
OLD_FILES+=usr/share/man/man3/pcap_set_immediate_mode.3.gz
OLD_FILES+=usr/share/man/man3/pcap_set_protocol.3.gz
# 20191214: Removal of sranddev(3)
OLD_FILES+=usr/share/man/man3/sranddev.3.gz
# 20191213: Renamed (BIT|CPU)_NAND to (BIT|CPU)_ANDNOT
OLD_FILES+=usr/share/man/man9/BIT_NAND.9.gz
OLD_FILES+=usr/share/man/man9/CPU_NAND.9.gz
# 20191213: remove timeout(9)
OLD_FILES+=usr/share/man/man9/callout_handle_init.9.gz
OLD_FILES+=usr/share/man/man9/timeout.9.gz
OLD_FILES+=usr/share/man/man9/untimeout.9.gz
# 20191128: Removal of trm(4)
OLD_FILES+=usr/share/man/man4/trm.4.gz
# 20191121: Removal of sio(4)
OLD_FILES+=usr/share/man/man4/sio.4.gz
# 20191105: picobsd(8), et al, removed
OLD_FILES+=usr/share/man/man8/picobsd.8.gz
# 20191017: taskqueue_start_threads_pinned became taskqueue_start_threads_cpuset
OLD_FILES+=usr/share/man/man9/taskqueue_start_threads_pinned.9.gz
# 20191009: new clang import which bumps version from 8.0.1 to 9.0.0
OLD_FILES+=usr/lib/clang/8.0.1/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/8.0.1/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/8.0.1/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/8.0.1/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/8.0.1/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/8.0.1/include/sanitizer/esan_interface.h
OLD_FILES+=usr/lib/clang/8.0.1/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/8.0.1/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/8.0.1/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/8.0.1/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/8.0.1/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/8.0.1/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/8.0.1/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/8.0.1/include/sanitizer/tsan_interface_atomic.h
OLD_DIRS+=usr/lib/clang/8.0.1/include/sanitizer
OLD_FILES+=usr/lib/clang/8.0.1/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/8.0.1/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/8.0.1/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/8.0.1/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/8.0.1/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/8.0.1/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/8.0.1/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/8.0.1/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/8.0.1/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/8.0.1/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/8.0.1/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/8.0.1/include/adxintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/altivec.h
OLD_FILES+=usr/lib/clang/8.0.1/include/ammintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/arm64intr.h
OLD_FILES+=usr/lib/clang/8.0.1/include/arm_acle.h
OLD_FILES+=usr/lib/clang/8.0.1/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/8.0.1/include/arm_neon.h
OLD_FILES+=usr/lib/clang/8.0.1/include/armintr.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/avxintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/cetintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/cpuid.h
OLD_FILES+=usr/lib/clang/8.0.1/include/emmintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/htmintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/immintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/8.0.1/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/8.0.1/include/mmintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/module.modulemap
OLD_FILES+=usr/lib/clang/8.0.1/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/msa.h
OLD_FILES+=usr/lib/clang/8.0.1/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/opencl-c.h
OLD_FILES+=usr/lib/clang/8.0.1/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/s390intrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/shaintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/smmintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/vadefs.h
OLD_FILES+=usr/lib/clang/8.0.1/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/vecintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/x86intrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/xopintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/8.0.1/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/8.0.1/include
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.profile-aarch64.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/8.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_DIRS+=usr/lib/clang/8.0.1/lib/freebsd
OLD_DIRS+=usr/lib/clang/8.0.1/lib
OLD_DIRS+=usr/lib/clang/8.0.1
# 20191009: libc++ 9.0.0 removed some experimental files
OLD_FILES+=usr/include/c++/v1/experimental/any
OLD_FILES+=usr/include/c++/v1/experimental/chrono
OLD_FILES+=usr/include/c++/v1/experimental/numeric
OLD_FILES+=usr/include/c++/v1/experimental/optional
OLD_FILES+=usr/include/c++/v1/experimental/ratio
OLD_FILES+=usr/include/c++/v1/experimental/string_view
OLD_FILES+=usr/include/c++/v1/experimental/system_error
OLD_FILES+=usr/include/c++/v1/experimental/tuple
OLD_FILES+=usr/lib/libc++fs.a
# 20191003: Remove useless ZFS tests
OLD_FILES+=usr/tests/sys/cddl/zfs/tests/cli_root/zpool_create/zpool_create_013_neg.ksh
OLD_FILES+=usr/tests/sys/cddl/zfs/tests/cli_root/zpool_create/zpool_create_014_neg.ksh
OLD_FILES+=usr/tests/sys/cddl/zfs/tests/cli_root/zpool_create/zpool_create_016_pos.ksh
# 20190910: mklocale(1) and colldef(1) removed
OLD_FILES+=usr/bin/mklocale
OLD_FILES+=usr/share/man/man1/mklocale.1.gz
OLD_FILES+=usr/bin/colldef
OLD_FILES+=usr/share/man/man1/colldef.1.gz
# 20190904: Remove boot1.efifat and gptboot.efifat (which never should have been)
OLD_FILES+=boot/boot1.efifat
OLD_FILES+=boot/gptboot.efifat
# 20190903: pc-sysinstall(8) removed
OLD_FILES+=usr/share/examples/pc-sysinstall/README
OLD_FILES+=usr/share/examples/pc-sysinstall/pc-autoinstall.conf
OLD_FILES+=usr/share/examples/pc-sysinstall/pcinstall.cfg.fbsd-netinstall
OLD_FILES+=usr/share/examples/pc-sysinstall/pcinstall.cfg.geli
OLD_FILES+=usr/share/examples/pc-sysinstall/pcinstall.cfg.gmirror
OLD_FILES+=usr/share/examples/pc-sysinstall/pcinstall.cfg.netinstall
OLD_FILES+=usr/share/examples/pc-sysinstall/pcinstall.cfg.restore
OLD_FILES+=usr/share/examples/pc-sysinstall/pcinstall.cfg.rsync
OLD_FILES+=usr/share/examples/pc-sysinstall/pcinstall.cfg.upgrade
OLD_FILES+=usr/share/examples/pc-sysinstall/pcinstall.cfg.zfs
OLD_FILES+=usr/share/man/man8/pc-sysinstall.8.gz
OLD_FILES+=usr/share/pc-sysinstall/backend-partmanager/create-part.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-partmanager/delete-part.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/detect-emulation.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/detect-laptop.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/detect-nics.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/disk-info.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/disk-list.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/disk-part.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/enable-net.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/get-packages.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/list-components.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/list-config.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/list-mirrors.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/list-packages.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/list-rsync-backups.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/list-tzones.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/query-langs.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/send-logs.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/setup-ssh-keys.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/set-mirror.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/sys-mem.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/test-live.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/test-netup.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/update-part-list.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/xkeyboard-layouts.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/xkeyboard-models.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/xkeyboard-variants.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-bsdlabel.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-cleanup.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-disk.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-extractimage.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-ftp.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-installcomponents.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-installpackages.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-localize.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-mountdisk.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-mountoptical.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-networking.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-newfs.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-parse.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-packages.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-runcommands.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-unmount.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-upgrade.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions-users.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/functions.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/installimage.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/parseconfig.sh
OLD_FILES+=usr/share/pc-sysinstall/backend/startautoinstall.sh
OLD_FILES+=usr/share/pc-sysinstall/conf/avail-langs
OLD_FILES+=usr/share/pc-sysinstall/conf/exclude-from-upgrade
OLD_FILES+=usr/share/pc-sysinstall/conf/license/bsd-en.txt
OLD_FILES+=usr/share/pc-sysinstall/conf/license/intel-en.txt
OLD_FILES+=usr/share/pc-sysinstall/conf/license/nvidia-en.txt
OLD_FILES+=usr/share/pc-sysinstall/conf/pc-sysinstall.conf
OLD_FILES+=usr/share/pc-sysinstall/doc/help-disk-list
OLD_FILES+=usr/share/pc-sysinstall/doc/help-disk-size
OLD_FILES+=usr/share/pc-sysinstall/doc/help-index
OLD_FILES+=usr/share/pc-sysinstall/doc/help-start-autoinstall
OLD_FILES+=usr/sbin/pc-sysinstall
OLD_DIRS+=usr/share/examples/pc-sysinstall
OLD_DIRS+=usr/share/pc-sysinstall/backend
OLD_DIRS+=usr/share/pc-sysinstall/backend-partmanager
OLD_DIRS+=usr/share/pc-sysinstall/backend-query
OLD_DIRS+=usr/share/pc-sysinstall/conf/license
OLD_DIRS+=usr/share/pc-sysinstall/conf
OLD_DIRS+=usr/share/pc-sysinstall/doc
OLD_DIRS+=usr/share/pc-sysinstall
# 20190825: zlib 1.0.4 removed from kernel
OLD_FILES+=usr/include/sys/zlib.h
OLD_FILES+=usr/include/sys/zutil.h
# 20190817: pft_ping.py and sniffer.py moved to /usr/tests/sys/netpfil/common
OLD_FILES+=usr/tests/sys/netpfil/pf/sniffer.py
OLD_FILES+=usr/tests/sys/netpfil/pf/pft_ping.py
# 20190816: dir.h removed from POSIX
OLD_FILES+=usr/include/sys/dir.h
# 20190813: deprecated GEOM classes removed
OLD_FILES+=usr/share/man/man4/geom_fox.4.gz
# 20190729: gzip'ed a.out support removed
OLD_FILES+=usr/include/sys/inflate.h
# 20190722: cap_random(3) removed
OLD_LIBS+=lib/casper/libcap_random.so.1
OLD_FILES+=usr/include/casper/cap_random.h
OLD_LIBS+=usr/lib/libcap_random.so
OLD_FILES+=usr/share/man/man3/libcap_random.3.gz
OLD_FILES+=usr/share/man/man3/cap_random.3.gz
OLD_FILES+=usr/share/man/man3/cap_random_buf.3.gz
# 20190708: vm_page_hold() and _unhold() removed
OLD_FILES+=usr/share/man/man9/vm_page_hold.9.gz
OLD_FILES+=usr/share/man/man9/vm_page_unhold.9.gz
# 20190625: Remove NAND and NANDFS support
OLD_FILES+=usr/share/man/man4/nand.4.gz
OLD_FILES+=usr/share/man/man4/nandsim.4.gz
# 20190618: sys/capability.h removed (sys/capsicum.h is the one to use)
OLD_FILES+=usr/include/sys/capability.h
# 20190615: sys/pwm.h renamed to dev/pwmc.h
OLD_FILES+=usr/include/sys/pwm.h
# 20190612: new clang import which bumps version from 8.0.0 to 8.0.1
OLD_FILES+=usr/lib/clang/8.0.0/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/8.0.0/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/8.0.0/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/8.0.0/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/8.0.0/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/8.0.0/include/sanitizer/esan_interface.h
OLD_FILES+=usr/lib/clang/8.0.0/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/8.0.0/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/8.0.0/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/8.0.0/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/8.0.0/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/8.0.0/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/8.0.0/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/8.0.0/include/sanitizer/tsan_interface_atomic.h
OLD_DIRS+=usr/lib/clang/8.0.0/include/sanitizer
OLD_FILES+=usr/lib/clang/8.0.0/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/8.0.0/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/8.0.0/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/8.0.0/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/8.0.0/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/8.0.0/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/8.0.0/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/8.0.0/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/8.0.0/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/8.0.0/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/8.0.0/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/8.0.0/include/adxintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/altivec.h
OLD_FILES+=usr/lib/clang/8.0.0/include/ammintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/arm64intr.h
OLD_FILES+=usr/lib/clang/8.0.0/include/arm_acle.h
OLD_FILES+=usr/lib/clang/8.0.0/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/8.0.0/include/arm_neon.h
OLD_FILES+=usr/lib/clang/8.0.0/include/armintr.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/avxintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/cetintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/cpuid.h
OLD_FILES+=usr/lib/clang/8.0.0/include/emmintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/htmintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/immintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/8.0.0/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/8.0.0/include/mmintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/module.modulemap
OLD_FILES+=usr/lib/clang/8.0.0/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/msa.h
OLD_FILES+=usr/lib/clang/8.0.0/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/opencl-c.h
OLD_FILES+=usr/lib/clang/8.0.0/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/s390intrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/shaintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/smmintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/vadefs.h
OLD_FILES+=usr/lib/clang/8.0.0/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/vecintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/x86intrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/xopintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/8.0.0/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/8.0.0/include
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/8.0.0/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_DIRS+=usr/lib/clang/8.0.0/lib/freebsd
OLD_DIRS+=usr/lib/clang/8.0.0/lib
OLD_DIRS+=usr/lib/clang/8.0.0
# 20190523: Remove obsolete kgzip and support files
OLD_FILES+=usr/sbin/kgzip
OLD_FILES+=usr/lib/kgzldr.o
OLD_FILES+=usr/share/man/man8/kgzip.8.gz
# 20190517: Remove obsolete 10 and 10/100 ethernet drivers
OLD_FILES+=usr/share/man/man4/bm.4.gz
OLD_FILES+=usr/share/man/man4/cs.4.gz
OLD_FILES+=usr/share/man/man4/de.4.gz
OLD_FILES+=usr/share/man/man4/if_de.4.gz
OLD_FILES+=usr/share/man/man4/ed.4.gz
OLD_FILES+=usr/share/man/man4/if_ed.4.gz
OLD_FILES+=usr/share/man/man4/ep.4.gz
OLD_FILES+=usr/share/man/man4/ex.4.gz
OLD_FILES+=usr/share/man/man4/fe.4.gz
OLD_FILES+=usr/share/man/man4/pcn.4.gz
OLD_FILES+=usr/share/man/man4/if_pcn.4.gz
OLD_FILES+=usr/share/man/man4/sf.4.gz
OLD_FILES+=usr/share/man/man4/if_sf.4.gz
OLD_FILES+=usr/share/man/man4/sn.4.gz
OLD_FILES+=usr/share/man/man4/if_sn.4.gz
OLD_FILES+=usr/share/man/man4/tl.4.gz
OLD_FILES+=usr/share/man/man4/if_tl.4.gz
OLD_FILES+=usr/share/man/man4/tx.4.gz
OLD_FILES+=usr/share/man/man4/if_tx.4.gz
OLD_FILES+=usr/share/man/man4/txp.4.gz
OLD_FILES+=usr/share/man/man4/if_txp.4.gz
OLD_FILES+=usr/share/man/man4/vx.4.gz
OLD_FILES+=usr/share/man/man4/wb.4.gz
OLD_FILES+=usr/share/man/man4/if_wb.4.gz
OLD_FILES+=usr/share/man/man4/xe.4.gz
OLD_FILES+=usr/share/man/man4/if_xe.4.gz
# 20190513: libcap_sysctl interface change
OLD_LIBS+=lib/casper/libcap_sysctl.so.1
# 20190509: tests/sys/opencrypto requires the net/py-dpkt package
OLD_FILES+=usr/tests/sys/opencrypto/dpkt.py
OLD_FILES+=usr/tests/sys/opencrypto/dpkt.pyc
# 20190304: new libc++ import which bumps version from 7.0.1 to 8.0.0
OLD_FILES+=usr/include/c++/v1/experimental/dynarray
# 20190304: new clang import which bumps version from 7.0.1 to 8.0.0
OLD_FILES+=usr/lib/clang/7.0.1/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/7.0.1/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/7.0.1/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/7.0.1/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/7.0.1/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/7.0.1/include/sanitizer/esan_interface.h
OLD_FILES+=usr/lib/clang/7.0.1/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/7.0.1/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/7.0.1/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/7.0.1/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/7.0.1/include/sanitizer/netbsd_syscall_hooks.h
OLD_FILES+=usr/lib/clang/7.0.1/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/7.0.1/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/7.0.1/include/sanitizer/tsan_interface_atomic.h
OLD_DIRS+=usr/lib/clang/7.0.1/include/sanitizer
OLD_FILES+=usr/lib/clang/7.0.1/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/7.0.1/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/7.0.1/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/7.0.1/include/__clang_cuda_device_functions.h
OLD_FILES+=usr/lib/clang/7.0.1/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/7.0.1/include/__clang_cuda_libdevice_declares.h
OLD_FILES+=usr/lib/clang/7.0.1/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/7.0.1/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/7.0.1/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/7.0.1/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/7.0.1/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/7.0.1/include/adxintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/altivec.h
OLD_FILES+=usr/lib/clang/7.0.1/include/ammintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/arm64intr.h
OLD_FILES+=usr/lib/clang/7.0.1/include/arm_acle.h
OLD_FILES+=usr/lib/clang/7.0.1/include/arm_fp16.h
OLD_FILES+=usr/lib/clang/7.0.1/include/arm_neon.h
OLD_FILES+=usr/lib/clang/7.0.1/include/armintr.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/avxintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/cetintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/cldemoteintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/cpuid.h
OLD_FILES+=usr/lib/clang/7.0.1/include/emmintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/htmintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/immintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/invpcidintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/7.0.1/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/7.0.1/include/mmintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/module.modulemap
OLD_FILES+=usr/lib/clang/7.0.1/include/movdirintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/msa.h
OLD_FILES+=usr/lib/clang/7.0.1/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/opencl-c.h
OLD_FILES+=usr/lib/clang/7.0.1/include/pconfigintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/ptwriteintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/s390intrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/sgxintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/shaintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/smmintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/vadefs.h
OLD_FILES+=usr/lib/clang/7.0.1/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/vecintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/waitpkgintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/wbnoinvdintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/x86intrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/xopintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/7.0.1/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/7.0.1/include
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.msan-x86_64.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.msan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/7.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_DIRS+=usr/lib/clang/7.0.1/lib/freebsd
OLD_DIRS+=usr/lib/clang/7.0.1/lib
OLD_DIRS+=usr/lib/clang/7.0.1
# 20190227: rename seq.h to seqc.h
OLD_FILES+=usr/include/sys/seq.h
# 20190222: libifconfig made INTERNALLIB
OLD_FILES+=usr/lib/libprivateifconfig.a
OLD_FILES+=usr/lib/libprivateifconfig_p.a
# 20190131: pfil(9) changed
OLD_FILES+=usr/share/man/man9/pfil_hook_get.9.gz
OLD_FILES+=usr/share/man/man9/pfil_rlock.9.gz
OLD_FILES+=usr/share/man/man9/pfil_runlock.9.gz
OLD_FILES+=usr/share/man/man9/pfil_wlock.9.gz
OLD_FILES+=usr/share/man/man9/pfil_wunlock.9.gz
# 20190126: adv(4) / adw(4) removal
OLD_FILES+=usr/share/man/man4/adv.4.gz
OLD_FILES+=usr/share/man/man4/adw.4.gz
# 20190123: nonexistant cred_update_thread(9) removed
OLD_FILES+=usr/share/man/man9/cred_update_thread.9.gz
# 20190114: old pbuf allocator removed
OLD_FILES+=usr/share/man/man9/getpbuf.9.gz
OLD_FILES+=usr/share/man/man9/pbuf.9.gz
OLD_FILES+=usr/share/man/man9/relpbuf.9.gz
OLD_FILES+=usr/share/man/man9/trypbuf.9.gz
# 20181219: ibcs removal
OLD_FILES+=usr/share/examples/ibcs2/hello.uu
OLD_FILES+=usr/share/examples/ibcs2/README
OLD_DIRS+=usr/share/examples/ibcs2
# 20181215: Migration of CTM to ports
OLD_FILES+=usr/sbin/ctm
OLD_FILES+=usr/sbin/ctm_dequeue
OLD_FILES+=usr/sbin/ctm_rmail
OLD_FILES+=usr/sbin/ctm_smail
OLD_FILES+=usr/share/man/man1/ctm.1.gz
OLD_FILES+=usr/share/man/man1/ctm_dequeue.1.gz
OLD_FILES+=usr/share/man/man1/ctm_rmail.1.gz
OLD_FILES+=usr/share/man/man1/ctm_smail.1.gz
OLD_FILES+=usr/share/man/man5/ctm.5.gz
# 20181214: Remove timed files
OLD_FILES+=etc/rc.d/timed
OLD_FILES+=usr/sbin/timed
OLD_FILES+=usr/sbin/timedc
OLD_FILES+=usr/share/man/man8/timed.8.gz
OLD_FILES+=usr/share/man/man8/timedc.8.gz
# 20181211: new clang import which bumps version from 6.0.1 to 7.0.1
OLD_FILES+=usr/lib/clang/6.0.1/include/sanitizer/allocator_interface.h
OLD_FILES+=usr/lib/clang/6.0.1/include/sanitizer/asan_interface.h
OLD_FILES+=usr/lib/clang/6.0.1/include/sanitizer/common_interface_defs.h
OLD_FILES+=usr/lib/clang/6.0.1/include/sanitizer/coverage_interface.h
OLD_FILES+=usr/lib/clang/6.0.1/include/sanitizer/dfsan_interface.h
OLD_FILES+=usr/lib/clang/6.0.1/include/sanitizer/esan_interface.h
OLD_FILES+=usr/lib/clang/6.0.1/include/sanitizer/hwasan_interface.h
OLD_FILES+=usr/lib/clang/6.0.1/include/sanitizer/linux_syscall_hooks.h
OLD_FILES+=usr/lib/clang/6.0.1/include/sanitizer/lsan_interface.h
OLD_FILES+=usr/lib/clang/6.0.1/include/sanitizer/msan_interface.h
OLD_FILES+=usr/lib/clang/6.0.1/include/sanitizer/scudo_interface.h
OLD_FILES+=usr/lib/clang/6.0.1/include/sanitizer/tsan_interface.h
OLD_FILES+=usr/lib/clang/6.0.1/include/sanitizer/tsan_interface_atomic.h
OLD_DIRS+=usr/lib/clang/6.0.1/include/sanitizer
OLD_FILES+=usr/lib/clang/6.0.1/include/__clang_cuda_builtin_vars.h
OLD_FILES+=usr/lib/clang/6.0.1/include/__clang_cuda_cmath.h
OLD_FILES+=usr/lib/clang/6.0.1/include/__clang_cuda_complex_builtins.h
OLD_FILES+=usr/lib/clang/6.0.1/include/__clang_cuda_intrinsics.h
OLD_FILES+=usr/lib/clang/6.0.1/include/__clang_cuda_math_forward_declares.h
OLD_FILES+=usr/lib/clang/6.0.1/include/__clang_cuda_runtime_wrapper.h
OLD_FILES+=usr/lib/clang/6.0.1/include/__stddef_max_align_t.h
OLD_FILES+=usr/lib/clang/6.0.1/include/__wmmintrin_aes.h
OLD_FILES+=usr/lib/clang/6.0.1/include/__wmmintrin_pclmul.h
OLD_FILES+=usr/lib/clang/6.0.1/include/adxintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/altivec.h
OLD_FILES+=usr/lib/clang/6.0.1/include/ammintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/arm64intr.h
OLD_FILES+=usr/lib/clang/6.0.1/include/arm_acle.h
OLD_FILES+=usr/lib/clang/6.0.1/include/arm_neon.h
OLD_FILES+=usr/lib/clang/6.0.1/include/armintr.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx2intrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512bitalgintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512bwintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512cdintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512dqintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512erintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512fintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512ifmaintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512ifmavlintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512pfintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512vbmi2intrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512vbmiintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512vbmivlintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512vlbitalgintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512vlbwintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512vlcdintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512vldqintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512vlintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512vlvbmi2intrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512vlvnniintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512vnniintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512vpopcntdqintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avx512vpopcntdqvlintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/avxintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/bmi2intrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/bmiintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/cetintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/clflushoptintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/clwbintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/clzerointrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/cpuid.h
OLD_FILES+=usr/lib/clang/6.0.1/include/emmintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/f16cintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/fma4intrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/fmaintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/fxsrintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/gfniintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/htmintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/htmxlintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/ia32intrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/immintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/lwpintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/lzcntintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/mm3dnow.h
OLD_FILES+=usr/lib/clang/6.0.1/include/mm_malloc.h
OLD_FILES+=usr/lib/clang/6.0.1/include/mmintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/module.modulemap
OLD_FILES+=usr/lib/clang/6.0.1/include/msa.h
OLD_FILES+=usr/lib/clang/6.0.1/include/mwaitxintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/nmmintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/opencl-c.h
OLD_FILES+=usr/lib/clang/6.0.1/include/pkuintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/pmmintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/popcntintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/prfchwintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/rdseedintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/rtmintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/s390intrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/shaintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/smmintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/tbmintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/tmmintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/vadefs.h
OLD_FILES+=usr/lib/clang/6.0.1/include/vaesintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/vecintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/vpclmulqdqintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/wmmintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/x86intrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/xmmintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/xopintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/xsavecintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/xsaveintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/xsaveoptintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/xsavesintrin.h
OLD_FILES+=usr/lib/clang/6.0.1/include/xtestintrin.h
OLD_DIRS+=usr/lib/clang/6.0.1/include
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.asan-i386.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.asan-i386.so
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.asan-preinit-i386.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.asan-preinit-x86_64.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.asan-x86_64.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.asan-x86_64.so
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.asan_cxx-i386.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.asan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.profile-arm.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.profile-armhf.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.profile-i386.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.profile-x86_64.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.safestack-i386.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.safestack-x86_64.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.stats-i386.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.stats-x86_64.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.stats_client-i386.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.stats_client-x86_64.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.tsan-x86_64.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.tsan_cxx-x86_64.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.ubsan_minimal-i386.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.ubsan_minimal-x86_64.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.ubsan_standalone-i386.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.ubsan_standalone-x86_64.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-i386.a
OLD_FILES+=usr/lib/clang/6.0.1/lib/freebsd/libclang_rt.ubsan_standalone_cxx-x86_64.a
OLD_DIRS+=usr/lib/clang/6.0.1/lib/freebsd
OLD_DIRS+=usr/lib/clang/6.0.1/lib
OLD_DIRS+=usr/lib/clang/6.0.1
# 20181116: Rename test file
OLD_FILES+=usr/tests/sys/netinet/reuseport_lb
# 20181113: libufs version bumped to 7
OLD_LIBS+=lib/libufs.so.6
# 20181112: Cleanup old libcap_dns
OLD_LIBS+=lib/casper/libcap_dns.so.1
# 20181030: malloc_domain(9) KPI change
OLD_FILES+=usr/share/man/man9/malloc_domain.9.gz
# 20181026: joy(4) removal
OLD_FILES+=usr/share/man/man4/joy.4.gz
# 20181025: OpenSSL libraries version bump to avoid conflict with ports
OLD_LIBS+=lib/libcrypto.so.9
OLD_LIBS+=usr/lib/libssl.so.9
# 20181022: aha(4) removal
OLD_FILES+=usr/share/man/man4/aha.4.gz
# 20181022: dpt(4) removal
OLD_FILES+=usr/share/man/man4/dpt.4.gz
# 20181022: ncr(4) removal
OLD_FILES+=usr/share/man/man4/ncr.4.gz
# 20181022: ncv(4) removal
OLD_FILES+=usr/share/man/man4/ncv.4.gz
# 20181022: nsp(4) removal
OLD_FILES+=usr/share/man/man4/nsp.4.gz
# 20181022: stg(4) removal
OLD_FILES+=usr/share/man/man4/stg.4.gz
# 20181021: mse(4) removal
OLD_FILES+=usr/share/man/man4/mse.4.gz

.include "tools/build/mk/OptionalObsoleteFiles.inc"
