/* @generated by `generate-fortify-tests.lua "unistd"` */

#define	_FORTIFY_SOURCE	2
#define	TMPFILE_SIZE	(1024 * 32)

#include <sys/param.h>
#include <sys/jail.h>
#include <sys/random.h>
#include <sys/resource.h>
#include <sys/select.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/wait.h>
#include <dirent.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <poll.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <sysexits.h>
#include <unistd.h>
#include <wchar.h>
#include <atf-c.h>

static FILE * __unused
new_fp(size_t __len)
{
	static char fpbuf[LINE_MAX];
	FILE *fp;

	ATF_REQUIRE(__len <= sizeof(fpbuf));

	memset(fpbuf, 'A', sizeof(fpbuf) - 1);
	fpbuf[sizeof(fpbuf) - 1] = '\0';

	fp = fmemopen(fpbuf, sizeof(fpbuf), "rb");
	ATF_REQUIRE(fp != NULL);

	return (fp);
}

/*
 * Create a new symlink to use for readlink(2) style tests, we'll just use a
 * random target name to have something interesting to look at.
 */
static const char * __unused
new_symlink(size_t __len)
{
	static const char linkname[] = "link";
	char target[MAXNAMLEN];
	int error;

	ATF_REQUIRE(__len <= sizeof(target));

	arc4random_buf(target, sizeof(target));

	error = unlink(linkname);
	ATF_REQUIRE(error == 0 || errno == ENOENT);

	error = symlink(target, linkname);
	ATF_REQUIRE(error == 0);

	return (linkname);
}

/*
 * For our purposes, first descriptor will be the reader; we'll send both
 * raw data and a control message over it so that the result can be used for
 * any of our recv*() tests.
 */
static void __unused
new_socket(int sock[2])
{
	unsigned char ctrl[CMSG_SPACE(sizeof(int))] = { 0 };
	static char sockbuf[256];
	ssize_t rv;
	size_t total = 0;
	struct msghdr hdr = { 0 };
	struct cmsghdr *cmsg;
	int error, fd;

	error = socketpair(AF_UNIX, SOCK_STREAM, 0, sock);
	ATF_REQUIRE(error == 0);

	while (total != sizeof(sockbuf)) {
		rv = send(sock[1], &sockbuf[total], sizeof(sockbuf) - total, 0);

		ATF_REQUIRE_MSG(rv > 0,
		    "expected bytes sent, got %zd with %zu left (size %zu, total %zu)",
		    rv, sizeof(sockbuf) - total, sizeof(sockbuf), total);
		ATF_REQUIRE_MSG(total + (size_t)rv <= sizeof(sockbuf),
		    "%zd exceeds total %zu", rv, sizeof(sockbuf));
		total += rv;
	}

	hdr.msg_control = ctrl;
	hdr.msg_controllen = sizeof(ctrl);

	cmsg = CMSG_FIRSTHDR(&hdr);
	cmsg->cmsg_level = SOL_SOCKET;
	cmsg->cmsg_type = SCM_RIGHTS;
	cmsg->cmsg_len = CMSG_LEN(sizeof(fd));
	fd = STDIN_FILENO;
	memcpy(CMSG_DATA(cmsg), &fd, sizeof(fd));

	error = sendmsg(sock[1], &hdr, 0);
	ATF_REQUIRE(error != -1);
}

/*
 * Constructs a tmpfile that we can use for testing read(2) and friends.
 */
static int __unused
new_tmpfile(void)
{
	char buf[1024];
	ssize_t rv;
	size_t written;
	int fd;

	fd = open("tmpfile", O_RDWR | O_CREAT | O_TRUNC, 0644);
	ATF_REQUIRE(fd >= 0);

	written = 0;
	while (written < TMPFILE_SIZE) {
		rv = write(fd, buf, sizeof(buf));
		ATF_REQUIRE(rv > 0);

		written += rv;
	}

	ATF_REQUIRE_EQ(0, lseek(fd, 0, SEEK_SET));
	return (fd);
}

static void
disable_coredumps(void)
{
	struct rlimit rl = { 0 };

	if (setrlimit(RLIMIT_CORE, &rl) == -1)
		_exit(EX_OSERR);
}

/*
 * Replaces stdin with a file that we can actually read from, for tests where
 * we want a FILE * or fd that we can get data from.
 */
static void __unused
replace_stdin(void)
{
	int fd;

	fd = new_tmpfile();

	(void)dup2(fd, STDIN_FILENO);
	if (fd != STDIN_FILENO)
		close(fd);
}

#define	JAIL_HOSTNAME	"host.example.com"
#define	JAIL_DOMAINNAME	"example.com"
static void
dhost_jail(void)
{
	struct iovec iov[4];
	int jid;

	iov[0].iov_base = __DECONST(char *, "host.hostname");
	iov[0].iov_len = sizeof("host.hostname");
	iov[1].iov_base = __DECONST(char *, JAIL_HOSTNAME);
	iov[1].iov_len = sizeof(JAIL_HOSTNAME);
	iov[2].iov_base = __DECONST(char *, "host.domainname");
	iov[2].iov_len = sizeof("host.domainname");
	iov[3].iov_base = __DECONST(char *, JAIL_DOMAINNAME);
	iov[3].iov_len = sizeof(JAIL_DOMAINNAME);

	jid = jail_set(iov, nitems(iov), JAIL_CREATE | JAIL_ATTACH);
	ATF_REQUIRE_MSG(jid > 0, "Jail creation failed: %s", strerror(errno));
}

ATF_TC(getcwd_before_end);
ATF_TC_HEAD(getcwd_before_end, tc)
{
}
ATF_TC_BODY(getcwd_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[8];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 8 - 1;
	const size_t __idx __unused = __len - 1;

	getcwd(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getcwd_end);
ATF_TC_HEAD(getcwd_end, tc)
{
}
ATF_TC_BODY(getcwd_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[8];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 8;
	const size_t __idx __unused = __len - 1;

	getcwd(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getcwd_heap_before_end);
ATF_TC_HEAD(getcwd_heap_before_end, tc)
{
}
ATF_TC_BODY(getcwd_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (8);
	const size_t __len = 8 - 1;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);

	getcwd(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getcwd_heap_end);
ATF_TC_HEAD(getcwd_heap_end, tc)
{
}
ATF_TC_BODY(getcwd_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (8);
	const size_t __len = 8;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);

	getcwd(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getcwd_heap_after_end);
ATF_TC_HEAD(getcwd_heap_after_end, tc)
{
}
ATF_TC_BODY(getcwd_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (8);
	const size_t __len = 8 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);

	getcwd(__stack.__buf, __len);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(getgrouplist_before_end);
ATF_TC_HEAD(getgrouplist_before_end, tc)
{
}
ATF_TC_BODY(getgrouplist_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		gid_t __buf[4];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 4 - 1;
	const size_t __idx __unused = __len - 1;
	int intlen = (int)__len;

	getgrouplist("root", 0, __stack.__buf, &intlen);
#undef BUF

}

ATF_TC(getgrouplist_end);
ATF_TC_HEAD(getgrouplist_end, tc)
{
}
ATF_TC_BODY(getgrouplist_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		gid_t __buf[4];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 4;
	const size_t __idx __unused = __len - 1;
	int intlen = (int)__len;

	getgrouplist("root", 0, __stack.__buf, &intlen);
#undef BUF

}

ATF_TC(getgrouplist_heap_before_end);
ATF_TC_HEAD(getgrouplist_heap_before_end, tc)
{
}
ATF_TC_BODY(getgrouplist_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		gid_t * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (4);
	const size_t __len = 4 - 1;
	const size_t __idx __unused = __len - 1;
	int intlen = (int)__len;

	__stack.__buf = malloc(__bufsz);

	getgrouplist("root", 0, __stack.__buf, &intlen);
#undef BUF

}

ATF_TC(getgrouplist_heap_end);
ATF_TC_HEAD(getgrouplist_heap_end, tc)
{
}
ATF_TC_BODY(getgrouplist_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		gid_t * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (4);
	const size_t __len = 4;
	const size_t __idx __unused = __len - 1;
	int intlen = (int)__len;

	__stack.__buf = malloc(__bufsz);

	getgrouplist("root", 0, __stack.__buf, &intlen);
#undef BUF

}

ATF_TC(getgrouplist_heap_after_end);
ATF_TC_HEAD(getgrouplist_heap_after_end, tc)
{
}
ATF_TC_BODY(getgrouplist_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		gid_t * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (4);
	const size_t __len = 4 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	int intlen = (int)__len;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);

	getgrouplist("root", 0, __stack.__buf, &intlen);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(getgroups_before_end);
ATF_TC_HEAD(getgroups_before_end, tc)
{
}
ATF_TC_BODY(getgroups_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		gid_t __buf[4];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 4 - 1;
	const size_t __idx __unused = __len - 1;

	getgroups(__len, __stack.__buf);
#undef BUF

}

ATF_TC(getgroups_end);
ATF_TC_HEAD(getgroups_end, tc)
{
}
ATF_TC_BODY(getgroups_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		gid_t __buf[4];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 4;
	const size_t __idx __unused = __len - 1;

	getgroups(__len, __stack.__buf);
#undef BUF

}

ATF_TC(getgroups_heap_before_end);
ATF_TC_HEAD(getgroups_heap_before_end, tc)
{
}
ATF_TC_BODY(getgroups_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		gid_t * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (4);
	const size_t __len = 4 - 1;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);

	getgroups(__len, __stack.__buf);
#undef BUF

}

ATF_TC(getgroups_heap_end);
ATF_TC_HEAD(getgroups_heap_end, tc)
{
}
ATF_TC_BODY(getgroups_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		gid_t * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (4);
	const size_t __len = 4;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);

	getgroups(__len, __stack.__buf);
#undef BUF

}

ATF_TC(getgroups_heap_after_end);
ATF_TC_HEAD(getgroups_heap_after_end, tc)
{
}
ATF_TC_BODY(getgroups_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		gid_t * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (4);
	const size_t __len = 4 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);

	getgroups(__len, __stack.__buf);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(getloginclass_before_end);
ATF_TC_HEAD(getloginclass_before_end, tc)
{
}
ATF_TC_BODY(getloginclass_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;

	getloginclass(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getloginclass_end);
ATF_TC_HEAD(getloginclass_end, tc)
{
}
ATF_TC_BODY(getloginclass_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;

	getloginclass(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getloginclass_heap_before_end);
ATF_TC_HEAD(getloginclass_heap_before_end, tc)
{
}
ATF_TC_BODY(getloginclass_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);

	getloginclass(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getloginclass_heap_end);
ATF_TC_HEAD(getloginclass_heap_end, tc)
{
}
ATF_TC_BODY(getloginclass_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);

	getloginclass(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getloginclass_heap_after_end);
ATF_TC_HEAD(getloginclass_heap_after_end, tc)
{
}
ATF_TC_BODY(getloginclass_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);

	getloginclass(__stack.__buf, __len);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(pread_before_end);
ATF_TC_HEAD(pread_before_end, tc)
{
}
ATF_TC_BODY(pread_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[41];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 41 - 1;
	const size_t __idx __unused = __len - 1;
	int fd;

	fd = new_tmpfile();	/* Cannot fail */

	pread(fd, __stack.__buf, __len, 0);
#undef BUF

}

ATF_TC(pread_end);
ATF_TC_HEAD(pread_end, tc)
{
}
ATF_TC_BODY(pread_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[41];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 41;
	const size_t __idx __unused = __len - 1;
	int fd;

	fd = new_tmpfile();	/* Cannot fail */

	pread(fd, __stack.__buf, __len, 0);
#undef BUF

}

ATF_TC(pread_heap_before_end);
ATF_TC_HEAD(pread_heap_before_end, tc)
{
}
ATF_TC_BODY(pread_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (41);
	const size_t __len = 41 - 1;
	const size_t __idx __unused = __len - 1;
	int fd;

	__stack.__buf = malloc(__bufsz);
	fd = new_tmpfile();	/* Cannot fail */

	pread(fd, __stack.__buf, __len, 0);
#undef BUF

}

ATF_TC(pread_heap_end);
ATF_TC_HEAD(pread_heap_end, tc)
{
}
ATF_TC_BODY(pread_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (41);
	const size_t __len = 41;
	const size_t __idx __unused = __len - 1;
	int fd;

	__stack.__buf = malloc(__bufsz);
	fd = new_tmpfile();	/* Cannot fail */

	pread(fd, __stack.__buf, __len, 0);
#undef BUF

}

ATF_TC(pread_heap_after_end);
ATF_TC_HEAD(pread_heap_after_end, tc)
{
}
ATF_TC_BODY(pread_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (41);
	const size_t __len = 41 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	int fd;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	fd = new_tmpfile();	/* Cannot fail */

	pread(fd, __stack.__buf, __len, 0);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(read_before_end);
ATF_TC_HEAD(read_before_end, tc)
{
}
ATF_TC_BODY(read_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[41];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 41 - 1;
	const size_t __idx __unused = __len - 1;
	int fd;

	fd = new_tmpfile();	/* Cannot fail */

	read(fd, __stack.__buf, __len);
#undef BUF

}

ATF_TC(read_end);
ATF_TC_HEAD(read_end, tc)
{
}
ATF_TC_BODY(read_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[41];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 41;
	const size_t __idx __unused = __len - 1;
	int fd;

	fd = new_tmpfile();	/* Cannot fail */

	read(fd, __stack.__buf, __len);
#undef BUF

}

ATF_TC(read_heap_before_end);
ATF_TC_HEAD(read_heap_before_end, tc)
{
}
ATF_TC_BODY(read_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (41);
	const size_t __len = 41 - 1;
	const size_t __idx __unused = __len - 1;
	int fd;

	__stack.__buf = malloc(__bufsz);
	fd = new_tmpfile();	/* Cannot fail */

	read(fd, __stack.__buf, __len);
#undef BUF

}

ATF_TC(read_heap_end);
ATF_TC_HEAD(read_heap_end, tc)
{
}
ATF_TC_BODY(read_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (41);
	const size_t __len = 41;
	const size_t __idx __unused = __len - 1;
	int fd;

	__stack.__buf = malloc(__bufsz);
	fd = new_tmpfile();	/* Cannot fail */

	read(fd, __stack.__buf, __len);
#undef BUF

}

ATF_TC(read_heap_after_end);
ATF_TC_HEAD(read_heap_after_end, tc)
{
}
ATF_TC_BODY(read_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (41);
	const size_t __len = 41 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	int fd;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	fd = new_tmpfile();	/* Cannot fail */

	read(fd, __stack.__buf, __len);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(readlink_before_end);
ATF_TC_HEAD(readlink_before_end, tc)
{
}
ATF_TC_BODY(readlink_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	const char *path;

	path = new_symlink(__len);		/* Cannot fail */

	readlink(path, __stack.__buf, __len);
#undef BUF

}

ATF_TC(readlink_end);
ATF_TC_HEAD(readlink_end, tc)
{
}
ATF_TC_BODY(readlink_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	const char *path;

	path = new_symlink(__len);		/* Cannot fail */

	readlink(path, __stack.__buf, __len);
#undef BUF

}

ATF_TC(readlink_heap_before_end);
ATF_TC_HEAD(readlink_heap_before_end, tc)
{
}
ATF_TC_BODY(readlink_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	const char *path;

	__stack.__buf = malloc(__bufsz);
	path = new_symlink(__len);		/* Cannot fail */

	readlink(path, __stack.__buf, __len);
#undef BUF

}

ATF_TC(readlink_heap_end);
ATF_TC_HEAD(readlink_heap_end, tc)
{
}
ATF_TC_BODY(readlink_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	const char *path;

	__stack.__buf = malloc(__bufsz);
	path = new_symlink(__len);		/* Cannot fail */

	readlink(path, __stack.__buf, __len);
#undef BUF

}

ATF_TC(readlink_heap_after_end);
ATF_TC_HEAD(readlink_heap_after_end, tc)
{
}
ATF_TC_BODY(readlink_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	const char *path;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	path = new_symlink(__len);		/* Cannot fail */

	readlink(path, __stack.__buf, __len);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(readlinkat_before_end);
ATF_TC_HEAD(readlinkat_before_end, tc)
{
}
ATF_TC_BODY(readlinkat_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	const char *path;

	path = new_symlink(__len);		/* Cannot fail */

	readlinkat(AT_FDCWD, path, __stack.__buf, __len);
#undef BUF

}

ATF_TC(readlinkat_end);
ATF_TC_HEAD(readlinkat_end, tc)
{
}
ATF_TC_BODY(readlinkat_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	const char *path;

	path = new_symlink(__len);		/* Cannot fail */

	readlinkat(AT_FDCWD, path, __stack.__buf, __len);
#undef BUF

}

ATF_TC(readlinkat_heap_before_end);
ATF_TC_HEAD(readlinkat_heap_before_end, tc)
{
}
ATF_TC_BODY(readlinkat_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	const char *path;

	__stack.__buf = malloc(__bufsz);
	path = new_symlink(__len);		/* Cannot fail */

	readlinkat(AT_FDCWD, path, __stack.__buf, __len);
#undef BUF

}

ATF_TC(readlinkat_heap_end);
ATF_TC_HEAD(readlinkat_heap_end, tc)
{
}
ATF_TC_BODY(readlinkat_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	const char *path;

	__stack.__buf = malloc(__bufsz);
	path = new_symlink(__len);		/* Cannot fail */

	readlinkat(AT_FDCWD, path, __stack.__buf, __len);
#undef BUF

}

ATF_TC(readlinkat_heap_after_end);
ATF_TC_HEAD(readlinkat_heap_after_end, tc)
{
}
ATF_TC_BODY(readlinkat_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	const char *path;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	path = new_symlink(__len);		/* Cannot fail */

	readlinkat(AT_FDCWD, path, __stack.__buf, __len);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(getdomainname_before_end);
ATF_TC_HEAD(getdomainname_before_end, tc)
{
	atf_tc_set_md_var(tc, "require.user", "root");
}
ATF_TC_BODY(getdomainname_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[12];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 12 - 1;
	const size_t __idx __unused = __len - 1;

	dhost_jail();
	getdomainname(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getdomainname_end);
ATF_TC_HEAD(getdomainname_end, tc)
{
	atf_tc_set_md_var(tc, "require.user", "root");
}
ATF_TC_BODY(getdomainname_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[12];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 12;
	const size_t __idx __unused = __len - 1;

	dhost_jail();
	getdomainname(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getdomainname_heap_before_end);
ATF_TC_HEAD(getdomainname_heap_before_end, tc)
{
	atf_tc_set_md_var(tc, "require.user", "root");
}
ATF_TC_BODY(getdomainname_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (12);
	const size_t __len = 12 - 1;
	const size_t __idx __unused = __len - 1;

	dhost_jail();
	__stack.__buf = malloc(__bufsz);

	getdomainname(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getdomainname_heap_end);
ATF_TC_HEAD(getdomainname_heap_end, tc)
{
	atf_tc_set_md_var(tc, "require.user", "root");
}
ATF_TC_BODY(getdomainname_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (12);
	const size_t __len = 12;
	const size_t __idx __unused = __len - 1;

	dhost_jail();
	__stack.__buf = malloc(__bufsz);

	getdomainname(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getdomainname_heap_after_end);
ATF_TC_HEAD(getdomainname_heap_after_end, tc)
{
	atf_tc_set_md_var(tc, "require.user", "root");
}
ATF_TC_BODY(getdomainname_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (12);
	const size_t __len = 12 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;

	dhost_jail();
	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);

	getdomainname(__stack.__buf, __len);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(getentropy_before_end);
ATF_TC_HEAD(getentropy_before_end, tc)
{
}
ATF_TC_BODY(getentropy_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;

	getentropy(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getentropy_end);
ATF_TC_HEAD(getentropy_end, tc)
{
}
ATF_TC_BODY(getentropy_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;

	getentropy(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getentropy_heap_before_end);
ATF_TC_HEAD(getentropy_heap_before_end, tc)
{
}
ATF_TC_BODY(getentropy_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);

	getentropy(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getentropy_heap_end);
ATF_TC_HEAD(getentropy_heap_end, tc)
{
}
ATF_TC_BODY(getentropy_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);

	getentropy(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getentropy_heap_after_end);
ATF_TC_HEAD(getentropy_heap_after_end, tc)
{
}
ATF_TC_BODY(getentropy_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);

	getentropy(__stack.__buf, __len);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(gethostname_before_end);
ATF_TC_HEAD(gethostname_before_end, tc)
{
	atf_tc_set_md_var(tc, "require.user", "root");
}
ATF_TC_BODY(gethostname_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[17];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 17 - 1;
	const size_t __idx __unused = __len - 1;

	dhost_jail();
	gethostname(__stack.__buf, __len);
#undef BUF

}

ATF_TC(gethostname_end);
ATF_TC_HEAD(gethostname_end, tc)
{
	atf_tc_set_md_var(tc, "require.user", "root");
}
ATF_TC_BODY(gethostname_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[17];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 17;
	const size_t __idx __unused = __len - 1;

	dhost_jail();
	gethostname(__stack.__buf, __len);
#undef BUF

}

ATF_TC(gethostname_heap_before_end);
ATF_TC_HEAD(gethostname_heap_before_end, tc)
{
	atf_tc_set_md_var(tc, "require.user", "root");
}
ATF_TC_BODY(gethostname_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (17);
	const size_t __len = 17 - 1;
	const size_t __idx __unused = __len - 1;

	dhost_jail();
	__stack.__buf = malloc(__bufsz);

	gethostname(__stack.__buf, __len);
#undef BUF

}

ATF_TC(gethostname_heap_end);
ATF_TC_HEAD(gethostname_heap_end, tc)
{
	atf_tc_set_md_var(tc, "require.user", "root");
}
ATF_TC_BODY(gethostname_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (17);
	const size_t __len = 17;
	const size_t __idx __unused = __len - 1;

	dhost_jail();
	__stack.__buf = malloc(__bufsz);

	gethostname(__stack.__buf, __len);
#undef BUF

}

ATF_TC(gethostname_heap_after_end);
ATF_TC_HEAD(gethostname_heap_after_end, tc)
{
	atf_tc_set_md_var(tc, "require.user", "root");
}
ATF_TC_BODY(gethostname_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (17);
	const size_t __len = 17 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;

	dhost_jail();
	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);

	gethostname(__stack.__buf, __len);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(getlogin_r_before_end);
ATF_TC_HEAD(getlogin_r_before_end, tc)
{
}
ATF_TC_BODY(getlogin_r_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[MAXLOGNAME + 1];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = MAXLOGNAME + 1 - 1;
	const size_t __idx __unused = __len - 1;

	getlogin_r(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getlogin_r_end);
ATF_TC_HEAD(getlogin_r_end, tc)
{
}
ATF_TC_BODY(getlogin_r_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[MAXLOGNAME + 1];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = MAXLOGNAME + 1;
	const size_t __idx __unused = __len - 1;

	getlogin_r(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getlogin_r_heap_before_end);
ATF_TC_HEAD(getlogin_r_heap_before_end, tc)
{
}
ATF_TC_BODY(getlogin_r_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (MAXLOGNAME + 1);
	const size_t __len = MAXLOGNAME + 1 - 1;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);

	getlogin_r(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getlogin_r_heap_end);
ATF_TC_HEAD(getlogin_r_heap_end, tc)
{
}
ATF_TC_BODY(getlogin_r_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (MAXLOGNAME + 1);
	const size_t __len = MAXLOGNAME + 1;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);

	getlogin_r(__stack.__buf, __len);
#undef BUF

}

ATF_TC(getlogin_r_heap_after_end);
ATF_TC_HEAD(getlogin_r_heap_after_end, tc)
{
}
ATF_TC_BODY(getlogin_r_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (MAXLOGNAME + 1);
	const size_t __len = MAXLOGNAME + 1 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);

	getlogin_r(__stack.__buf, __len);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(ttyname_r_before_end);
ATF_TC_HEAD(ttyname_r_before_end, tc)
{
}
ATF_TC_BODY(ttyname_r_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	int fd;

	fd = STDIN_FILENO;
	if (!isatty(fd))
		atf_tc_skip("stdin is not an fd");

	ttyname_r(fd, __stack.__buf, __len);
#undef BUF

}

ATF_TC(ttyname_r_end);
ATF_TC_HEAD(ttyname_r_end, tc)
{
}
ATF_TC_BODY(ttyname_r_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	int fd;

	fd = STDIN_FILENO;
	if (!isatty(fd))
		atf_tc_skip("stdin is not an fd");

	ttyname_r(fd, __stack.__buf, __len);
#undef BUF

}

ATF_TC(ttyname_r_heap_before_end);
ATF_TC_HEAD(ttyname_r_heap_before_end, tc)
{
}
ATF_TC_BODY(ttyname_r_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	int fd;

	fd = STDIN_FILENO;
	if (!isatty(fd))
		atf_tc_skip("stdin is not an fd");

	__stack.__buf = malloc(__bufsz);

	ttyname_r(fd, __stack.__buf, __len);
#undef BUF

}

ATF_TC(ttyname_r_heap_end);
ATF_TC_HEAD(ttyname_r_heap_end, tc)
{
}
ATF_TC_BODY(ttyname_r_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	int fd;

	fd = STDIN_FILENO;
	if (!isatty(fd))
		atf_tc_skip("stdin is not an fd");

	__stack.__buf = malloc(__bufsz);

	ttyname_r(fd, __stack.__buf, __len);
#undef BUF

}

ATF_TC(ttyname_r_heap_after_end);
ATF_TC_HEAD(ttyname_r_heap_after_end, tc)
{
}
ATF_TC_BODY(ttyname_r_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	int fd;

	fd = STDIN_FILENO;
	if (!isatty(fd))
		atf_tc_skip("stdin is not an fd");

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);

	ttyname_r(fd, __stack.__buf, __len);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TP_ADD_TCS(tp)
{
	ATF_TP_ADD_TC(tp, getcwd_before_end);
	ATF_TP_ADD_TC(tp, getcwd_end);
	ATF_TP_ADD_TC(tp, getcwd_heap_before_end);
	ATF_TP_ADD_TC(tp, getcwd_heap_end);
	ATF_TP_ADD_TC(tp, getcwd_heap_after_end);
	ATF_TP_ADD_TC(tp, getgrouplist_before_end);
	ATF_TP_ADD_TC(tp, getgrouplist_end);
	ATF_TP_ADD_TC(tp, getgrouplist_heap_before_end);
	ATF_TP_ADD_TC(tp, getgrouplist_heap_end);
	ATF_TP_ADD_TC(tp, getgrouplist_heap_after_end);
	ATF_TP_ADD_TC(tp, getgroups_before_end);
	ATF_TP_ADD_TC(tp, getgroups_end);
	ATF_TP_ADD_TC(tp, getgroups_heap_before_end);
	ATF_TP_ADD_TC(tp, getgroups_heap_end);
	ATF_TP_ADD_TC(tp, getgroups_heap_after_end);
	ATF_TP_ADD_TC(tp, getloginclass_before_end);
	ATF_TP_ADD_TC(tp, getloginclass_end);
	ATF_TP_ADD_TC(tp, getloginclass_heap_before_end);
	ATF_TP_ADD_TC(tp, getloginclass_heap_end);
	ATF_TP_ADD_TC(tp, getloginclass_heap_after_end);
	ATF_TP_ADD_TC(tp, pread_before_end);
	ATF_TP_ADD_TC(tp, pread_end);
	ATF_TP_ADD_TC(tp, pread_heap_before_end);
	ATF_TP_ADD_TC(tp, pread_heap_end);
	ATF_TP_ADD_TC(tp, pread_heap_after_end);
	ATF_TP_ADD_TC(tp, read_before_end);
	ATF_TP_ADD_TC(tp, read_end);
	ATF_TP_ADD_TC(tp, read_heap_before_end);
	ATF_TP_ADD_TC(tp, read_heap_end);
	ATF_TP_ADD_TC(tp, read_heap_after_end);
	ATF_TP_ADD_TC(tp, readlink_before_end);
	ATF_TP_ADD_TC(tp, readlink_end);
	ATF_TP_ADD_TC(tp, readlink_heap_before_end);
	ATF_TP_ADD_TC(tp, readlink_heap_end);
	ATF_TP_ADD_TC(tp, readlink_heap_after_end);
	ATF_TP_ADD_TC(tp, readlinkat_before_end);
	ATF_TP_ADD_TC(tp, readlinkat_end);
	ATF_TP_ADD_TC(tp, readlinkat_heap_before_end);
	ATF_TP_ADD_TC(tp, readlinkat_heap_end);
	ATF_TP_ADD_TC(tp, readlinkat_heap_after_end);
	ATF_TP_ADD_TC(tp, getdomainname_before_end);
	ATF_TP_ADD_TC(tp, getdomainname_end);
	ATF_TP_ADD_TC(tp, getdomainname_heap_before_end);
	ATF_TP_ADD_TC(tp, getdomainname_heap_end);
	ATF_TP_ADD_TC(tp, getdomainname_heap_after_end);
	ATF_TP_ADD_TC(tp, getentropy_before_end);
	ATF_TP_ADD_TC(tp, getentropy_end);
	ATF_TP_ADD_TC(tp, getentropy_heap_before_end);
	ATF_TP_ADD_TC(tp, getentropy_heap_end);
	ATF_TP_ADD_TC(tp, getentropy_heap_after_end);
	ATF_TP_ADD_TC(tp, gethostname_before_end);
	ATF_TP_ADD_TC(tp, gethostname_end);
	ATF_TP_ADD_TC(tp, gethostname_heap_before_end);
	ATF_TP_ADD_TC(tp, gethostname_heap_end);
	ATF_TP_ADD_TC(tp, gethostname_heap_after_end);
	ATF_TP_ADD_TC(tp, getlogin_r_before_end);
	ATF_TP_ADD_TC(tp, getlogin_r_end);
	ATF_TP_ADD_TC(tp, getlogin_r_heap_before_end);
	ATF_TP_ADD_TC(tp, getlogin_r_heap_end);
	ATF_TP_ADD_TC(tp, getlogin_r_heap_after_end);
	ATF_TP_ADD_TC(tp, ttyname_r_before_end);
	ATF_TP_ADD_TC(tp, ttyname_r_end);
	ATF_TP_ADD_TC(tp, ttyname_r_heap_before_end);
	ATF_TP_ADD_TC(tp, ttyname_r_heap_end);
	ATF_TP_ADD_TC(tp, ttyname_r_heap_after_end);
	return (atf_no_error());
}
