/****************************************************************
Copyright (C) Lucent Technologies 1997
All Rights Reserved

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby
granted, provided that the above copyright notice appear in all
copies and that both that the copyright notice and this
permission notice and warranty disclaimer appear in supporting
documentation, and that the name Lucent Technologies or any of
its entities not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.

LUCENT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
IN NO EVENT SHALL LUCENT OR ANY OF ITS ENTITIES BE LIABLE FOR ANY
SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.
****************************************************************/

static const char	*version = "version 20070501";
static const char	*embedversion = "embedded version 20081120";

#define DEBUG
#include <stdio.h>
#include <ctype.h>
#include <getopt.h>
#include <locale.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <locale.h>

#include "awklib.h"
#include "awkgram.h"
#include "proto.h"

/* options descriptor */
static struct option longopts[] = {
	{ "FS",		required_argument,	NULL,		'F' },
	{ "version",	no_argument,		NULL,		'V' },
	{ "debug",	no_argument,		NULL,		'd' },
	{ "file",	required_argument,	NULL,		'f' },
	{ "safe",	no_argument,		NULL,		's' },
	{ "value",	required_argument,	NULL,		'v' },
	{ NULL,         0,                      NULL,           0 }
};

int
main(int argc, char **argv)
{
	const char	 *fs = NULL;
	extern char	**environ;
	awk_t		  awk;
	int		  i;

	(void) memset(&awk, 0x0, sizeof(awk));
	awklib_setvar(&awk, "stage", AWKLIB_ERROR_PRINTING, NULL);

	awklib_setdefaults(&awk);

	setlocale(LC_CTYPE, "");
	setlocale(LC_NUMERIC, "C"); /* for parsing cmdline & prog */
	awklib_setvar(&awk, "cmdname", 0, argv[0]);
	if (argc == 1) {
		(void) fprintf(stderr, 
		  "usage: %s [-F fs] [-v var=value] [-f progfile | 'prog'] [file ...]\n", 
		  *argv);
		exit(EXIT_FAILURE);
	}

	(void) setlocale(LC_ALL, "");

	signal(SIGFPE, awklib_fpecatch);
	awklib_setvar(&awk, "symtab", 0, awklib_makesymtab(&awk, NSYMTAB/NSYMTAB));
	while ((i = getopt_long(argc, argv, "F:Vdf:sv:", longopts, NULL)) != -1) {
		switch(i) {
		case 'V':
			printf("awk %s\n", version);
			printf("embedded awk: %s\n", embedversion);
			exit(EXIT_SUCCESS);
			break;
		case 's':
			awklib_setvar(&awk, "safe", 1, NULL);
			break;
		case 'f':	/* next argument is program filename */
			awklib_setvar(&awk, "script", 0, optarg);
			break;
		case 'F':
			/* set field separator */
			fs = optarg;
			break;
		case 'v':
			/* -v a=1 to be done NOW.  one -v for each */
			if (awklib_isclvar(optarg)) {
				awklib_setclvar(&awk, optarg);
			}
			break;
		case 'd':
			awklib_setvar(&awk, "debug", 1, NULL);
			printf("awk %s\n", version);
			printf("embedded awk: %s\n", embedversion);
			break;
		default:
			WARNING(&awk, "unknown option %s ignored", argv[1]);
			break;
		}
	}
	argc -= (optind - 1);
	argv += (optind - 1);
	/* argv[1] is now the first argument */
	if (awklib_getvarint(&awk, "script count") == 0) {
		/* no -f; first argument is program */
		if (argc <= 1) {
			if (awklib_getvarint(&awk, "debug")) {
				exit(EXIT_SUCCESS);
			}
			FATAL(&awk, "no program given");
		}
		DPRINTF(&awk, ("program = |%s|\n", argv[1]) );
		awklib_setvar(&awk, "lexprog", 0, argv[1]);
		argc--;
		argv++;
	}
	awklib_recinit(&awk, awklib_getvarint(&awk, "current record size"));
	awklib_syminit(&awk);
	awklib_setvar(&awk, "stage", AWKLIB_COMPILING, NULL);
	/* put prog name at front of arglist */
	argv[0] = awklib_getvarptr(&awk, "cmdname");
	DPRINTF(&awk, ("argc=%d, argv[0]=%s\n", argc, argv[0]) );
	/* copy and initialise arguments */
	awklib_arginit(&awk, argc, argv);
	awklib_envinit(&awk, environ);
	/* parse the awk scripts */
	awklib_parse(&awk);
	/* set locale back to whatever it is locally */
	setlocale(LC_NUMERIC, "");
	if (fs) {
		awklib_setvar(&awk, "FS", 0, awklib_qstring(&awk, fs, '\0'));
	}
	DPRINTF(&awk, ("errorflag=%d\n", awklib_getvarint(&awk, "error flag") ));
	if (awklib_getvarint(&awk, "error flag") == 0) {
		awklib_setvar(&awk, "stage", AWKLIB_RUNNING, NULL);
		awklib_run(&awk, awklib_getvarptr(&awk, "winner"));
	} else {
		awklib_bracecheck(&awk);
	}
	return awklib_getvarint(&awk, "error flag");
}
