/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.eventadmin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jitsi.eventadmin.Event;
import org.jitsi.eventadmin.EventAdmin;
import org.jitsi.eventadmin.EventHandler;
import org.jitsi.utils.StringUtils;
import org.jitsi.utils.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class EventAdminImpl
implements EventAdmin,
ServiceListener {
    private static final Logger logger = Logger.getLogger(EventAdminImpl.class);
    private BundleContext bundleContext;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Map<ServiceReference<EventHandler>, HandlerRef> handlers = new HashMap<ServiceReference<EventHandler>, HandlerRef>();
    private List<HandlerRef> handlerRefListCache = Collections.emptyList();

    private static Pattern createTopicsPattern(String[] topics) {
        StringBuilder combined = new StringBuilder();
        for (int i = 0; i < topics.length; ++i) {
            String topic = topics[i].replace("*", ".*");
            combined.append("(").append(topic).append(")");
            if (i >= topics.length - 1) continue;
            combined.append("|");
        }
        try {
            String patternStr = combined.toString();
            logger.debug((Object)("Created: " + patternStr + " from: " + Arrays.toString(topics)));
            return Pattern.compile(patternStr);
        }
        catch (PatternSyntaxException exc) {
            logger.error((Object)("Failed to parse: " + combined));
            return null;
        }
    }

    public void start(BundleContext ctx) throws InvalidSyntaxException {
        ctx.addServiceListener((ServiceListener)this, "(objectclass=" + EventHandler.class.getName() + ")");
        this.bundleContext = ctx;
    }

    public void stop(BundleContext ctx) {
        ctx.removeServiceListener((ServiceListener)this);
        this.executor.shutdown();
    }

    private boolean hasTopic(HandlerRef handlerRef, String topic) {
        return handlerRef.topicsPattern.matcher(topic).matches();
    }

    @Override
    public void postEvent(Event event) {
        this.eventImpl(event, false);
    }

    @Override
    public void sendEvent(Event event) {
        this.eventImpl(event, true);
    }

    private void eventImpl(final Event event, boolean synchronous) {
        String eventTopic = event.getTopic();
        if (StringUtils.isNullOrEmpty((String)eventTopic)) {
            logger.warn((Object)("Some trash event without correct topic: " + eventTopic));
            return;
        }
        List<HandlerRef> handlerRefs = this.getCurrentHandlerList();
        for (final HandlerRef handlerRef : handlerRefs) {
            if (!this.hasTopic(handlerRef, eventTopic)) continue;
            if (synchronous) {
                this.callEventHandler(handlerRef, event);
                continue;
            }
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    EventAdminImpl.this.callEventHandler(handlerRef, event);
                }
            });
        }
    }

    private void callEventHandler(HandlerRef handlerRef, Event event) {
        EventHandler handler = handlerRef.handler;
        if (handler == null) {
            return;
        }
        try {
            handler.handleEvent(event);
        }
        catch (Exception e) {
            logger.error((Object)"EventHandler exception", (Throwable)e);
        }
    }

    private HandlerRef newHandlerRef(ServiceReference<EventHandler> handlerRef) {
        Object topicsObj = handlerRef.getProperty("event.topics");
        if (!(topicsObj instanceof String[])) {
            return null;
        }
        String[] topics = (String[])topicsObj;
        if (topics.length == 0) {
            return null;
        }
        EventHandler handler = (EventHandler)this.bundleContext.getService(handlerRef);
        if (handler == null) {
            return null;
        }
        Pattern pattern = EventAdminImpl.createTopicsPattern(topics);
        if (pattern == null) {
            return null;
        }
        return new HandlerRef(handler, pattern);
    }

    private List<HandlerRef> getCurrentHandlerList() {
        return this.handlerRefListCache;
    }

    public synchronized void serviceChanged(ServiceEvent serviceEvent) {
        ServiceReference svcHandlerRef = serviceEvent.getServiceReference();
        switch (serviceEvent.getType()) {
            case 1: {
                HandlerRef newHandlerRef = this.newHandlerRef((ServiceReference<EventHandler>)svcHandlerRef);
                if (newHandlerRef == null) break;
                this.handlers.put((ServiceReference<EventHandler>)svcHandlerRef, newHandlerRef);
                this.handlerRefListCache = new ArrayList<HandlerRef>(this.handlers.values());
                break;
            }
            case 4: {
                HandlerRef ref = this.handlers.remove(svcHandlerRef);
                if (ref == null) break;
                this.handlerRefListCache = new ArrayList<HandlerRef>(this.handlers.values());
                ref.handler = null;
            }
        }
    }

    private static class HandlerRef {
        EventHandler handler;
        final Pattern topicsPattern;

        HandlerRef(EventHandler handler, Pattern topicsRegExpr) {
            this.handler = handler;
            this.topicsPattern = topicsRegExpr;
        }
    }
}

