/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.xmlpull.v1.XmlPullParser;

public class DefaultPacketExtensionProvider<C extends AbstractPacketExtension>
extends ExtensionElementProvider<C> {
    private static final Logger logger = Logger.getLogger(DefaultPacketExtensionProvider.class.getName());
    private final Class<C> packetClass;

    public DefaultPacketExtensionProvider(Class<C> c) {
        this.packetClass = c;
    }

    public C parse(XmlPullParser parser, int depth) throws Exception {
        AbstractPacketExtension packetExtension = (AbstractPacketExtension)this.packetClass.newInstance();
        int attrCount = parser.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            packetExtension.setAttribute(parser.getAttributeName(i), parser.getAttributeValue(i));
        }
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            String elementName = parser.getName();
            String namespace = parser.getNamespace();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Will parse " + elementName + " ns=" + namespace + " class=" + packetExtension.getClass().getSimpleName());
            }
            if (eventType == 2) {
                ExtensionElementProvider provider = ProviderManager.getExtensionProvider((String)elementName, (String)namespace);
                if (provider == null) {
                    logger.fine("Could not add a provider for element " + elementName + " from namespace " + namespace);
                } else {
                    ExtensionElement childExtension = (ExtensionElement)provider.parse(parser);
                    if (namespace != null && childExtension instanceof AbstractPacketExtension) {
                        ((AbstractPacketExtension)childExtension).setNamespace(namespace);
                    }
                    packetExtension.addChildExtension(childExtension);
                }
            }
            if (eventType == 3 && parser.getName().equals(packetExtension.getElementName())) {
                done = true;
            }
            if (eventType == 4) {
                String text = parser.getText();
                packetExtension.setText(text);
            }
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.finest("Done parsing " + elementName);
        }
        return (C)packetExtension;
    }
}

