/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jitsimeet;

import java.io.IOException;
import org.jitsi.utils.logging.Logger;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class IdentityPacketExtension
implements ExtensionElement {
    public static final Logger logger = Logger.getLogger(IdentityPacketExtension.class);
    public static final String NAME_SPACE = "jabber:client";
    public static final String ELEMENT_NAME = "identity";
    public static final String USER_ELEMENT_NAME = "user";
    public static final String GROUP_ELEMENT_NAME = "group";
    public static final String USER_ID_ELEMENT_NAME = "id";
    public static final String USER_AVATAR_URL_ELEMENT_NAME = "avatar";
    public static final String USER_NAME_ELEMENT_NAME = "name";
    private String userId;
    private String userName;
    private String userAvatarUrl;
    private String groupId;

    public IdentityPacketExtension(String userId, String userName, String userAvatarUrl, String groupId) {
        this.userId = userId;
        this.userName = userName;
        this.userAvatarUrl = userAvatarUrl;
        this.groupId = groupId;
    }

    public String getNamespace() {
        return NAME_SPACE;
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public CharSequence toXML() {
        XmlStringBuilder xml = new XmlStringBuilder();
        xml.openElement(ELEMENT_NAME);
        xml.openElement(USER_ELEMENT_NAME);
        xml.element(USER_ID_ELEMENT_NAME, this.getUserId());
        xml.element(USER_NAME_ELEMENT_NAME, this.getUserName());
        xml.element(USER_AVATAR_URL_ELEMENT_NAME, this.getUserAvatarUrl());
        xml.closeElement(USER_ELEMENT_NAME);
        xml.element(GROUP_ELEMENT_NAME, this.getGroupId());
        xml.closeElement(ELEMENT_NAME);
        return xml.toString();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserAvatarUrl() {
        return this.userAvatarUrl;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public static class Provider
    extends ExtensionElementProvider<IdentityPacketExtension> {
        public IdentityPacketExtension parse(XmlPullParser parser, int depth) {
            String groupId;
            String userAvatarUrl;
            String userName;
            String userId;
            block20: {
                String currentTag = parser.getName();
                if (!IdentityPacketExtension.NAME_SPACE.equals(parser.getNamespace())) {
                    return null;
                }
                if (!IdentityPacketExtension.ELEMENT_NAME.equals(currentTag)) {
                    return null;
                }
                userId = null;
                userName = null;
                userAvatarUrl = null;
                groupId = null;
                try {
                    do {
                        parser.next();
                        if (parser.getEventType() == 2) {
                            currentTag = parser.getName();
                            continue;
                        }
                        if (parser.getEventType() == 4) {
                            switch (currentTag) {
                                case "avatar": {
                                    userAvatarUrl = parser.getText();
                                    break;
                                }
                                case "id": {
                                    userId = parser.getText();
                                    break;
                                }
                                case "name": {
                                    userName = parser.getText();
                                    break;
                                }
                                case "group": {
                                    groupId = parser.getText();
                                    break;
                                }
                            }
                            continue;
                        }
                        if (parser.getEventType() != 3) continue;
                        currentTag = parser.getName();
                    } while (!IdentityPacketExtension.ELEMENT_NAME.equals(currentTag));
                }
                catch (IOException | XmlPullParserException e) {
                    if (!logger.isDebugEnabled()) break block20;
                    logger.debug((Object)"failed to parse IdentityExtension", e);
                }
            }
            if (userAvatarUrl != null && userId != null && userName != null && groupId != null) {
                return new IdentityPacketExtension(userId, userName, userAvatarUrl, groupId);
            }
            return null;
        }
    }
}

