/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackDesc;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.event.PropertyChangeNotifier;
import org.jitsi.videobridge.AbstractEndpointMessageTransport;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.RtpChannel;

public abstract class AbstractEndpoint
extends PropertyChangeNotifier {
    private final String id;
    private final String loggingId;
    private final Conference conference;
    private final List<WeakReference<RtpChannel>> channels = new LinkedList<WeakReference<RtpChannel>>();
    private String displayName;
    private String statsId;
    private boolean expired = false;

    protected AbstractEndpoint(Conference conference, String id) {
        this.conference = Objects.requireNonNull(conference, "conference");
        this.id = Objects.requireNonNull(id, "id");
        this.loggingId = conference.getLoggingId() + ",endp_id=" + id;
    }

    public AbstractEndpointMessageTransport getMessageTransport() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChannel(RtpChannel channel) {
        Objects.requireNonNull(channel, "channel");
        if (channel.isExpired()) {
            return false;
        }
        boolean added = false;
        boolean removed = false;
        List<WeakReference<RtpChannel>> list = this.channels;
        synchronized (list) {
            boolean add = true;
            Iterator<WeakReference<RtpChannel>> i = this.channels.iterator();
            while (i.hasNext()) {
                RtpChannel c = (RtpChannel)i.next().get();
                if (c == null) {
                    i.remove();
                    removed = true;
                    continue;
                }
                if (c.equals(channel)) {
                    add = false;
                    continue;
                }
                if (!c.isExpired()) continue;
                i.remove();
                removed = true;
            }
            if (add) {
                this.channels.add(new WeakReference<RtpChannel>(channel));
                added = true;
            }
        }
        if (removed) {
            this.maybeExpire();
        }
        return added;
    }

    int getChannelCount(MediaType mediaType) {
        return this.getChannels(mediaType).size();
    }

    public List<RtpChannel> getChannels() {
        return this.getChannels(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RtpChannel> getChannels(MediaType mediaType) {
        boolean removed = false;
        LinkedList<RtpChannel> channels = new LinkedList<RtpChannel>();
        List<WeakReference<RtpChannel>> list = this.channels;
        synchronized (list) {
            Iterator<WeakReference<RtpChannel>> i = this.channels.iterator();
            while (i.hasNext()) {
                RtpChannel c = (RtpChannel)i.next().get();
                if (c == null || c.isExpired()) {
                    i.remove();
                    removed = true;
                    continue;
                }
                if (mediaType != null && !mediaType.equals((Object)c.getContent().getMediaType())) continue;
                channels.add(c);
            }
        }
        if (removed) {
            this.maybeExpire();
        }
        return channels;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getStatsId() {
        return this.statsId;
    }

    public final String getID() {
        return this.id;
    }

    public Conference getConference() {
        return this.conference;
    }

    public boolean isExpired() {
        return this.expired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChannel(RtpChannel channel) {
        boolean removed;
        if (channel == null) {
            return false;
        }
        List<WeakReference<RtpChannel>> list = this.channels;
        synchronized (list) {
            removed = this.channels.removeIf(w -> {
                Channel c = (Channel)w.get();
                return c == null || c.equals(channel) || c.isExpired();
            });
        }
        if (removed) {
            this.maybeExpire();
        }
        return removed;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setStatsId(String value) {
        this.statsId = value;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " " + this.getID();
    }

    public void expire() {
        this.expired = true;
        this.getConference().endpointExpired(this);
    }

    public String getLoggingId() {
        return this.loggingId;
    }

    protected void maybeExpire() {
    }

    public Set<String> getSelectedEndpoints() {
        return Collections.EMPTY_SET;
    }

    public Set<String> getPinnedEndpoints() {
        return Collections.EMPTY_SET;
    }

    public MediaStreamTrackDesc[] getMediaStreamTracks(MediaType mediaType) {
        return this.getAllMediaStreamTracks(mediaType).toArray(new MediaStreamTrackDesc[0]);
    }

    protected List<MediaStreamTrackDesc> getAllMediaStreamTracks(MediaType mediaType) {
        List<RtpChannel> channels = this.getChannels(mediaType);
        if (channels == null || channels.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<MediaStreamTrackDesc> allTracks = new LinkedList<MediaStreamTrackDesc>();
        channels.stream().map(channel -> channel.getStream().getMediaStreamTrackReceiver()).filter(Objects::nonNull).forEach(trackReceiver -> allTracks.addAll(Arrays.asList(trackReceiver.getMediaStreamTracks())));
        return allTracks;
    }

    public abstract void sendMessage(String var1) throws IOException;

    public void incrementSelectedCount() {
    }

    public void decrementSelectedCount() {
    }
}

