/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.List;
import org.jitsi.service.neomedia.AudioMediaStream;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.event.CsrcAudioLevelListener;
import org.jitsi.utils.MediaType;
import org.jitsi.videobridge.AudioChannelAudioLevelListener;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.xmpp.extensions.colibri.RTPLevelRelayType;

public class AudioChannel
extends RtpChannel {
    public AudioChannel(Content content, String id, String channelBundleId, String transportNamespace, Boolean initiator) {
        super(content, id, channelBundleId, transportNamespace, initiator);
    }

    @Override
    protected void removeStreamListeners() {
        block4: {
            super.removeStreamListeners();
            try {
                MediaStream stream = this.getStream();
                if (stream instanceof AudioMediaStream) {
                    ((AudioMediaStream)stream).setCsrcAudioLevelListener(null);
                }
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (!(t instanceof ThreadDeath)) break block4;
                throw (ThreadDeath)t;
            }
        }
    }

    @Override
    protected void rtpLevelRelayTypeChanged(RTPLevelRelayType oldValue, RTPLevelRelayType newValue) {
        Content content;
        super.rtpLevelRelayTypeChanged(oldValue, newValue);
        if (RTPLevelRelayType.MIXER.equals((Object)newValue) && MediaType.AUDIO.equals((Object)(content = this.getContent()).getMediaType())) {
            MediaStream stream = this.getStream();
            MediaDevice device = content.getMixer();
            List rtpExtensions = device.getSupportedExtensions();
            if (rtpExtensions.size() == 1) {
                stream.addRTPExtension((byte)1, (RTPExtension)rtpExtensions.get(0));
            }
        }
    }

    @Override
    protected void configureStream(MediaStream stream) {
        if (stream instanceof AudioMediaStream) {
            ((AudioMediaStream)stream).setCsrcAudioLevelListener((CsrcAudioLevelListener)new AudioChannelAudioLevelListener(this));
        }
    }
}

