/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.SessionAddress;
import net.java.sip.communicator.impl.protocol.jabber.jinglesdp.JingleUtils;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.eventadmin.EventAdmin;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RTPConnectorInputStream;
import org.jitsi.impl.neomedia.SSRCFactoryImpl;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackDesc;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackReceiver;
import org.jitsi.impl.neomedia.rtp.TransportCCEngine;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.zrtp.ZrtpRawPacket;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.RetransmissionRequester;
import org.jitsi.service.neomedia.SSRCFactory;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.service.neomedia.recording.Recorder;
import org.jitsi.service.neomedia.recording.Synchronizer;
import org.jitsi.service.neomedia.stats.MediaStreamStats2;
import org.jitsi.service.neomedia.stats.SendTrackStats;
import org.jitsi.util.RTPUtils;
import org.jitsi.utils.DatagramPacketFilter;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.event.WeakReferencePropertyChangeListener;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.ConferenceSpeechActivity;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.EventFactory;
import org.jitsi.videobridge.RtpChannelDatagramFilter;
import org.jitsi.videobridge.TransformChainManipulator;
import org.jitsi.videobridge.TransportManager;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.transform.RtpChannelTransformEngine;
import org.jitsi.videobridge.xmpp.ComponentImpl;
import org.jitsi.videobridge.xmpp.MediaStreamTrackFactory;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.colibri.RTPLevelRelayType;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jivesoftware.smack.packet.IQ;
import org.jxmpp.jid.Jid;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class RtpChannel
extends Channel
implements PropertyChangeListener {
    private static final String DISABLE_ABS_SEND_TIME_PNAME = "org.jitsi.videobridge.DISABLE_ABS_SEND_TIME";
    private static final Logger classLogger = Logger.getLogger(RtpChannel.class);
    private static final long[] NO_RECEIVE_SSRCS = new long[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final int MAX_RECEIVE_SSRCS = 50;
    protected final ConferenceSpeechActivity conferenceSpeechActivity;
    private final RtpChannelDatagramFilter[] datagramFilters = new RtpChannelDatagramFilter[2];
    private final long initialLocalSSRC;
    private final PropertyChangeListener propertyChangeListener = new WeakReferencePropertyChangeListener((PropertyChangeListener)this);
    private int[] receivePTs = new int[0];
    private long[] receiveSSRCs = NO_RECEIVE_SSRCS;
    private final Object receiveSSRCsSyncRoot = new Object();
    private RTPLevelRelayType rtpLevelRelayType;
    private MediaStream stream;
    private final Object streamSyncRoot = new Object();
    private boolean streamClosed = false;
    private final PropertyChangeListener streamPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            RtpChannel.this.streamPropertyChange(ev);
        }
    };
    private final SessionAddress streamTarget = new SessionAddress();
    RtpChannelTransformEngine transformEngine = null;
    private final Logger logger;
    private boolean verifyRemoteAddress = true;
    protected final Statistics statistics = new Statistics();
    private Set<Integer> signaledSSRCs = new HashSet<Integer>();

    static RtpChannel getChannel(MediaStream stream) {
        return (RtpChannel)stream.getProperty(RtpChannel.class.getName());
    }

    public RtpChannel(Content content, String id, String channelBundleId, String transportNamespace, Boolean initiator) {
        super(content, id, channelBundleId, transportNamespace, initiator);
        this.logger = Logger.getLogger((Logger)classLogger, (Logger)content.getConference().getLogger());
        this.initialLocalSSRC = Videobridge.RANDOM.nextLong() & 0xFFFFFFFFL;
        Conference conference = content.getConference();
        conference.addPropertyChangeListener(this.propertyChangeListener);
        this.conferenceSpeechActivity = conference.getSpeechActivity();
        if (this.conferenceSpeechActivity != null) {
            this.conferenceSpeechActivity.addPropertyChangeListener(this.propertyChangeListener);
        }
        content.addPropertyChangeListener(this.propertyChangeListener);
        if ("urn:xmpp:jingle:transports:ice-udp:1".equals(this.transportNamespace)) {
            this.verifyRemoteAddress = false;
        }
        this.touch();
    }

    protected boolean acceptControlInputStreamDatagramPacket(DatagramPacket p) {
        boolean accept;
        InetAddress ctrlAddr = this.streamTarget.getControlAddress();
        int ctrlPort = this.streamTarget.getControlPort();
        if (ctrlAddr == null) {
            this.streamTarget.setControlHostAddress(p.getAddress());
            this.streamTarget.setControlPort(p.getPort());
            InetAddress dataAddr = this.streamTarget.getDataAddress();
            int dataPort = this.streamTarget.getDataPort();
            if (dataAddr != null) {
                ctrlAddr = this.streamTarget.getControlAddress();
                ctrlPort = this.streamTarget.getControlPort();
                this.stream.setTarget(new MediaStreamTarget(dataAddr, dataPort, ctrlAddr, ctrlPort));
            }
            accept = true;
        } else {
            boolean bl = accept = !this.verifyRemoteAddress || ctrlAddr.equals(p.getAddress()) && ctrlPort == p.getPort();
        }
        if (accept) {
            int ssrc;
            int sc;
            int offset;
            byte[] data;
            byte b0;
            this.touch(Channel.ActivityType.PAYLOAD);
            if (p.getLength() > 8 && ((b0 = (data = p.getData())[offset = p.getOffset()]) & 0xC0) >>> 6 == 2 && (data[offset + 1] & 0xFF) == 203 && (sc = b0 & 0x1F) > 0 && this.removeReceiveSSRC(ssrc = RTPUtils.readInt((byte[])data, (int)(offset + 4)))) {
                this.notifyFocus();
            }
        }
        return accept;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean acceptDataInputStreamDatagramPacket(DatagramPacket p) {
        boolean accept;
        InetAddress dataAddr = this.streamTarget.getDataAddress();
        int dataPort = this.streamTarget.getDataPort();
        if (dataAddr == null) {
            this.streamTarget.setDataHostAddress(p.getAddress());
            this.streamTarget.setDataPort(p.getPort());
            dataAddr = this.streamTarget.getDataAddress();
            dataPort = this.streamTarget.getDataPort();
            InetAddress ctrlAddr = this.streamTarget.getControlAddress();
            int ctrlPort = this.streamTarget.getControlPort();
            MediaStreamTarget newStreamTarget = ctrlAddr == null ? new MediaStreamTarget(new InetSocketAddress(dataAddr, dataPort), null) : new MediaStreamTarget(dataAddr, dataPort, ctrlAddr, ctrlPort);
            this.stream.setTarget(newStreamTarget);
            accept = true;
        } else {
            boolean bl = accept = !this.verifyRemoteAddress || dataAddr.equals(p.getAddress()) && dataPort == p.getPort();
        }
        if (accept) {
            this.touch(Channel.ActivityType.PAYLOAD);
            if (p.getLength() >= 12) {
                int off;
                byte[] data = p.getData();
                int v = (data[off = p.getOffset()] & 0xC0) >>> 6;
                if (v == 0) {
                    byte[] zrtpMagicCookie;
                    if ((data[off] & 0x10) == 16 && data[off + 4] == (zrtpMagicCookie = ZrtpRawPacket.ZRTP_MAGIC)[0] && data[off + 5] == zrtpMagicCookie[1] && data[off + 6] == zrtpMagicCookie[2] && data[off + 7] == zrtpMagicCookie[3]) {
                        accept = false;
                    }
                } else if (v == 2) {
                    int pt;
                    MediaFormat format;
                    Map payloadTypes;
                    Synchronizer synchronizer;
                    AbstractEndpoint endpoint;
                    Recorder recorder;
                    boolean notify;
                    int ssrc = RTPUtils.readInt((byte[])data, (int)(off + 8));
                    try {
                        notify = this.addReceiveSSRC(ssrc, true);
                    }
                    catch (SizeExceededException see) {
                        accept = false;
                        notify = false;
                    }
                    if (notify && this.getContent().isRecording() && (recorder = this.getContent().getRecorder()) != null && (endpoint = this.getEndpoint()) != null && (synchronizer = recorder.getSynchronizer()) != null) {
                        synchronizer.setEndpoint((long)ssrc & 0xFFFFFFFFL, endpoint.getID());
                    }
                    if (RTPLevelRelayType.MIXER.equals((Object)this.getRTPLevelRelayType()) && (payloadTypes = this.stream.getDynamicRTPPayloadTypes()) != null && (format = (MediaFormat)payloadTypes.get((byte)(pt = data[off + 1] & 0x7F))) != null && !format.equals((Object)this.stream.getFormat())) {
                        this.stream.setFormat(format);
                        Object object = this.streamSyncRoot;
                        synchronized (object) {
                            this.stream.setDirection(MediaDirection.SENDRECV);
                        }
                        notify = true;
                    }
                    if (notify) {
                        this.notifyFocus();
                    }
                }
            }
        }
        return accept;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addReceiveSSRC(int receiveSSRC, boolean checkLimit) throws SizeExceededException {
        Object object = this.receiveSSRCsSyncRoot;
        synchronized (object) {
            long now = System.currentTimeMillis();
            int length = this.receiveSSRCs.length;
            for (int i = 0; i < length; i += 2) {
                if ((int)this.receiveSSRCs[i] != receiveSSRC) continue;
                this.receiveSSRCs[i + 1] = now;
                return false;
            }
            if (checkLimit && length >= 25) {
                throw new SizeExceededException();
            }
            long[] newReceiveSSRCs = new long[length + 2];
            System.arraycopy(this.receiveSSRCs, 0, newReceiveSSRCs, 0, length);
            newReceiveSSRCs[length] = 0xFFFFFFFFL & (long)receiveSSRC;
            newReceiveSSRCs[length + 1] = now;
            this.receiveSSRCs = newReceiveSSRCs;
            return true;
        }
    }

    @Override
    protected void closeStream() {
        if (!this.streamClosed && this.stream != null) {
            MediaStreamStats2 mss = this.stream.getMediaStreamStats();
            this.statistics.bytesReceived = mss.getReceiveStats().getBytes();
            this.statistics.bytesSent = mss.getSendStats().getBytes();
            this.statistics.packetsReceived = mss.getReceiveStats().getPackets();
            this.statistics.packetsSent = mss.getSendStats().getPackets();
            this.stream.setProperty(RtpChannel.class.getName(), null);
            this.removeStreamListeners();
            this.stream.close();
            this.streamClosed = true;
        }
    }

    @Override
    public void describe(ColibriConferenceIQ.ChannelCommon commonIq) {
        ColibriConferenceIQ.Channel iq = (ColibriConferenceIQ.Channel)commonIq;
        iq.setRTPLevelRelayType(this.getRTPLevelRelayType());
        super.describe((ColibriConferenceIQ.ChannelCommon)iq);
        iq.setDirection(this.stream.getDirection() != null ? this.stream.getDirection().toString() : null);
        iq.setLastN(null);
        long initialLocalSSRC = this.getInitialLocalSSRC();
        if (initialLocalSSRC != -1L) {
            SourcePacketExtension source = new SourcePacketExtension();
            source.setSSRC(initialLocalSSRC);
            iq.addSource(source);
        }
        iq.setSSRCs(this.getReceiveSSRCs());
    }

    protected void dominantSpeakerChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtpChannelDatagramFilter getDatagramFilter(boolean rtcp) {
        int index = rtcp ? 1 : 0;
        RtpChannelDatagramFilter[] rtpChannelDatagramFilterArray = this.datagramFilters;
        synchronized (this.datagramFilters) {
            RtpChannelDatagramFilter datagramFilter = this.datagramFilters[index];
            if (datagramFilter == null) {
                this.datagramFilters[index] = datagramFilter = new RtpChannelDatagramFilter(this, rtcp);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return datagramFilter;
        }
    }

    private long getInitialLocalSSRC() {
        switch (this.getRTPLevelRelayType()) {
            case MIXER: {
                return this.initialLocalSSRC;
            }
            case TRANSLATOR: {
                return this.getContent().getInitialLocalSSRC();
            }
        }
        return -1L;
    }

    private MediaService getMediaService() {
        return this.getContent().getMediaService();
    }

    public int[] getDefaultReceiveSSRCs() {
        return EMPTY_INT_ARRAY;
    }

    public int[] getReceiveSSRCs() {
        long[] receiveSSRCsField = this.receiveSSRCs;
        int length = receiveSSRCsField.length;
        if (length == 0) {
            return ColibriConferenceIQ.NO_SSRCS;
        }
        int[] receiveSSRCs = new int[length / 2];
        int src = 0;
        int dst = 0;
        while (src < length) {
            receiveSSRCs[dst] = (int)receiveSSRCsField[src];
            src += 2;
            ++dst;
        }
        return receiveSSRCs;
    }

    public RTPLevelRelayType getRTPLevelRelayType() {
        if (this.rtpLevelRelayType == null) {
            this.setRTPLevelRelayType(RTPLevelRelayType.TRANSLATOR);
        }
        return this.rtpLevelRelayType;
    }

    public MediaStream getStream() {
        return this.stream;
    }

    public SessionAddress getStreamTarget() {
        return this.streamTarget;
    }

    @Override
    public void initialize() throws IOException {
        this.initialize(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(RTPLevelRelayType rtpLevelRelayType) throws IOException {
        super.initialize();
        MediaService mediaService = this.getMediaService();
        MediaType mediaType = this.getContent().getMediaType();
        Object object = this.streamSyncRoot;
        synchronized (object) {
            TransportManager transportManager = this.getTransportManager();
            TransportCCEngine transportCCEngine = transportManager.getTransportCCEngine();
            this.stream = mediaService.createMediaStream(null, mediaType, this.getSrtpControl());
            this.stream.addPropertyChangeListener(this.streamPropertyChangeListener);
            this.stream.setName(this.getID());
            this.stream.setProperty(RtpChannel.class.getName(), (Object)this);
            if (this.stream instanceof MediaStreamImpl) {
                MediaStreamImpl streamImpl = (MediaStreamImpl)this.stream;
                DiagnosticContext diagnosticContext = streamImpl.getDiagnosticContext();
                this.getContent().getConference().appendDiagnosticInformation(diagnosticContext);
            }
            if (this.transformEngine != null) {
                this.stream.setExternalTransformer((TransformEngine)this.transformEngine);
            }
            if (transportCCEngine != null) {
                this.stream.setTransportCCEngine(transportCCEngine);
            }
            this.logger.info(Logger.Category.STATISTICS, "create_stream," + this.getLoggingId());
            if (rtpLevelRelayType != null) {
                this.setRTPLevelRelayType(rtpLevelRelayType);
            }
            if (transportManager.isConnected()) {
                this.transportConnected();
            }
        }
    }

    private Iterable<TransformChainManipulator> getTransformChainManipulators() {
        try {
            ArrayList<TransformChainManipulator> manipulators = new ArrayList<TransformChainManipulator>();
            BundleContext bundleContext = this.getBundleContext();
            Collection serviceReferences = bundleContext.getServiceReferences(TransformChainManipulator.class, null);
            for (ServiceReference serviceReference : serviceReferences) {
                TransformChainManipulator transformChainManipulators = (TransformChainManipulator)bundleContext.getService(serviceReference);
                if (transformChainManipulators == null) continue;
                manipulators.add(transformChainManipulators);
            }
            return manipulators;
        }
        catch (InvalidSyntaxException e) {
            this.logger.warn((Object)"Cannot fetch TransformChainManipulators", (Throwable)e);
            return null;
        }
    }

    RtpChannelTransformEngine initializeTransformerEngine() {
        Iterable<TransformChainManipulator> manipulators = this.getTransformChainManipulators();
        this.transformEngine = new RtpChannelTransformEngine(this, manipulators);
        if (this.stream != null) {
            this.stream.setExternalTransformer((TransformEngine)this.transformEngine);
        }
        return this.transformEngine;
    }

    protected void configureStream(MediaStream stream) {
        RetransmissionRequester retransmissionRequester = stream.getRetransmissionRequester();
        if (retransmissionRequester != null) {
            retransmissionRequester.setSenderSsrc(this.getContent().getInitialLocalSSRC());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void maybeStartStream() throws IOException {
        Object object = this.streamSyncRoot;
        synchronized (object) {
            if (this.stream == null) {
                return;
            }
        }
        this.configureStream(this.stream);
        MediaStreamTarget streamTarget = this.createStreamTarget();
        StreamConnector connector = this.getStreamConnector();
        if (connector == null) {
            this.logger.info((Object)"Not starting stream, connector is null");
            return;
        }
        if (streamTarget != null) {
            InetSocketAddress dataAddr = streamTarget.getDataAddress();
            if (dataAddr == null) {
                this.logger.info((Object)"Not starting stream, the target's data address is null");
                return;
            }
            this.streamTarget.setDataHostAddress(dataAddr.getAddress());
            this.streamTarget.setDataPort(dataAddr.getPort());
            InetSocketAddress ctrlAddr = streamTarget.getControlAddress();
            if (ctrlAddr != null) {
                this.streamTarget.setControlHostAddress(ctrlAddr.getAddress());
                this.streamTarget.setControlPort(ctrlAddr.getPort());
            }
            this.stream.setTarget(streamTarget);
        }
        this.stream.setConnector(connector);
        Content content = this.getContent();
        Conference conference = content.getConference();
        if (!this.stream.isStarted()) {
            if (RTPLevelRelayType.MIXER.equals((Object)this.getRTPLevelRelayType())) {
                this.stream.setSSRCFactory((SSRCFactory)new SSRCFactoryImpl(this.initialLocalSSRC));
            }
            Object object2 = this.streamSyncRoot;
            synchronized (object2) {
                this.stream.start();
            }
            EventAdmin eventAdmin = conference.getEventAdmin();
            if (eventAdmin != null) {
                eventAdmin.sendEvent(EventFactory.streamStarted(this));
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.debug(Logger.Category.STATISTICS, "ch_direction," + this.getLoggingId() + " direction=" + this.stream.getDirection());
        }
    }

    private void notifyFocus() {
        block6: {
            Content content = this.getContent();
            Conference conference = content.getConference();
            Jid focus = conference.getFocus();
            if (focus == null) {
                return;
            }
            Collection<ComponentImpl> components = conference.getVideobridge().getComponents();
            if (!components.isEmpty()) {
                try {
                    ColibriConferenceIQ conferenceIQ = new ColibriConferenceIQ();
                    conference.describeShallow(conferenceIQ);
                    ColibriConferenceIQ.Content contentIQ = conferenceIQ.getOrCreateContent(content.getName());
                    ColibriConferenceIQ.Channel channelIQ = new ColibriConferenceIQ.Channel();
                    this.describe((ColibriConferenceIQ.ChannelCommon)channelIQ);
                    contentIQ.addChannel(channelIQ);
                    conferenceIQ.setTo(focus);
                    conferenceIQ.setType(IQ.Type.set);
                    for (ComponentImpl component : components) {
                        component.send((IQ)conferenceIQ);
                    }
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(t instanceof ThreadDeath)) break block6;
                    throw (ThreadDeath)t;
                }
            }
        }
    }

    @Override
    protected void onEndpointChanged(AbstractEndpoint oldValue, AbstractEndpoint newValue) {
        super.onEndpointChanged(oldValue, newValue);
        if (oldValue != null) {
            oldValue.removeChannel(this);
            oldValue.removePropertyChangeListener(this);
        }
        if (newValue != null) {
            newValue.addChannel(this);
            newValue.addPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String propertyName;
        Object source = ev.getSource();
        if (this.conferenceSpeechActivity == source && this.conferenceSpeechActivity != null && ConferenceSpeechActivity.DOMINANT_ENDPOINT_PROPERTY_NAME.equals(propertyName = ev.getPropertyName())) {
            this.dominantSpeakerChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeReceiveSSRC(int receiveSSRC) {
        boolean removed;
        block7: {
            removed = false;
            Object object = this.receiveSSRCsSyncRoot;
            synchronized (object) {
                int length;
                block6: {
                    length = this.receiveSSRCs.length;
                    if (length != 2) break block6;
                    if ((int)this.receiveSSRCs[0] != receiveSSRC) break block7;
                    this.receiveSSRCs = NO_RECEIVE_SSRCS;
                    removed = true;
                    break block7;
                }
                for (int i = 0; i < length; i += 2) {
                    if ((int)this.receiveSSRCs[i] != receiveSSRC) continue;
                    long[] newReceiveSSRCs = new long[length - 2];
                    if (i != 0) {
                        System.arraycopy(this.receiveSSRCs, 0, newReceiveSSRCs, 0, i);
                    }
                    if (i != newReceiveSSRCs.length) {
                        System.arraycopy(this.receiveSSRCs, i + 2, newReceiveSSRCs, i, newReceiveSSRCs.length - i);
                    }
                    this.receiveSSRCs = newReceiveSSRCs;
                    removed = true;
                    break;
                }
            }
        }
        return removed;
    }

    protected void removeStreamListeners() {
        block3: {
            try {
                this.stream.removePropertyChangeListener(this.streamPropertyChangeListener);
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (!(t instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)t;
            }
        }
    }

    protected void rtpLevelRelayTypeChanged(RTPLevelRelayType oldValue, RTPLevelRelayType newValue) {
    }

    boolean rtpTranslatorWillWrite(boolean data, RawPacket pkt, RtpChannel source) {
        return true;
    }

    void endpointMessageTransportConnected() {
    }

    public void setDirection(MediaDirection direction) {
        if (this.streamTarget.getDataAddress() != null) {
            this.stream.setDirection(direction);
        }
        this.touch();
    }

    public void setLastN(int lastN) {
    }

    public void setPayloadTypes(List<PayloadTypePacketExtension> payloadTypes) {
        MediaService mediaService;
        if (payloadTypes != null && !payloadTypes.isEmpty() && (mediaService = this.getMediaService()) != null) {
            int payloadTypeCount = payloadTypes.size();
            this.receivePTs = new int[payloadTypeCount];
            this.stream.clearDynamicRTPPayloadTypes();
            for (int i = 0; i < payloadTypeCount; ++i) {
                PayloadTypePacketExtension payloadType = payloadTypes.get(i);
                this.receivePTs[i] = payloadType.getID();
                MediaFormat mediaFormat = JingleUtils.payloadTypeToMediaFormat((PayloadTypePacketExtension)payloadType, (MediaService)mediaService, null);
                if (mediaFormat == null) continue;
                this.stream.addDynamicRTPPayloadType((byte)payloadType.getID(), mediaFormat);
            }
            TransportManager transportManager = this.getTransportManager();
            if (transportManager != null) {
                transportManager.payloadTypesChanged(this);
            }
        }
        this.touch();
    }

    public void setRtpHeaderExtensions(Collection<RTPHdrExtPacketExtension> rtpHeaderExtensions) {
        if (rtpHeaderExtensions != null && rtpHeaderExtensions.size() > 0) {
            this.stream.clearRTPExtensions();
            for (RTPHdrExtPacketExtension rtpHdrExtPacketExtension : rtpHeaderExtensions) {
                this.addRtpHeaderExtension(rtpHdrExtPacketExtension);
            }
        }
    }

    protected void addRtpHeaderExtension(RTPHdrExtPacketExtension rtpHdrExtPacketExtension) {
        ConfigurationService cfg;
        URI uri = rtpHdrExtPacketExtension.getURI();
        if (uri == null) {
            this.logger.warn((Object)("Failed to add an RTP header extension with an invalid URI: " + rtpHdrExtPacketExtension.getAttribute("uri")));
            return;
        }
        Byte id = Byte.valueOf(rtpHdrExtPacketExtension.getID());
        if (id == null) {
            this.logger.warn((Object)("Failed to add an RTP header extension with an invalid ID: " + rtpHdrExtPacketExtension.getID()));
            return;
        }
        if ("http://www.webrtc.org/experiments/rtp-hdrext/abs-send-time".equals(uri.toString()) && (cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)this.getBundleContext(), ConfigurationService.class)) != null && cfg.getBoolean(DISABLE_ABS_SEND_TIME_PNAME, false)) {
            return;
        }
        MediaStream stream = this.getStream();
        if (stream != null) {
            stream.addRTPExtension(id.byteValue(), new RTPExtension(uri));
        }
    }

    public void setRTPLevelRelayType(RTPLevelRelayType rtpLevelRelayType) {
        if (rtpLevelRelayType == null) {
            throw new NullPointerException("rtpLevelRelayType");
        }
        if (this.rtpLevelRelayType == null) {
            RTPLevelRelayType oldValue = null;
            this.rtpLevelRelayType = rtpLevelRelayType;
            RTPLevelRelayType newValue = this.getRTPLevelRelayType();
            switch (newValue) {
                case MIXER: {
                    MediaDevice device = this.getContent().getMixer();
                    this.stream.setDevice(device);
                    if (this.stream.getFormat() != null) break;
                    this.stream.setDirection(MediaDirection.RECVONLY);
                    break;
                }
                case TRANSLATOR: {
                    this.stream.setRTPTranslator(this.getContent().getRTPTranslator());
                    break;
                }
                default: {
                    throw new IllegalStateException("rtpLevelRelayType");
                }
            }
            this.rtpLevelRelayTypeChanged(oldValue, newValue);
        } else if (!this.rtpLevelRelayType.equals((Object)rtpLevelRelayType)) {
            // empty if block
        }
        this.touch();
    }

    void speechActivityEndpointsChanged(List<AbstractEndpoint> endpoints) {
    }

    private void streamPropertyChange(PropertyChangeEvent ev) {
        String prefix;
        String propertyName = ev.getPropertyName();
        if (propertyName.startsWith(prefix = MediaStreamImpl.class.getName() + ".rtpConnector")) {
            Object datagramPacketFilter;
            String rtpConnectorPropertyName = propertyName.substring(prefix.length());
            Object newValue = ev.getNewValue();
            if (rtpConnectorPropertyName.equals("")) {
                if (newValue instanceof RTPConnector) {
                    this.streamRTPConnectorChanged((RTPConnector)ev.getOldValue(), (RTPConnector)newValue);
                }
            } else if (newValue instanceof RTPConnectorInputStream && (datagramPacketFilter = rtpConnectorPropertyName.equals(".controlInputStream") ? new DatagramPacketFilter(){

                public boolean accept(DatagramPacket p) {
                    return RtpChannel.this.acceptControlInputStreamDatagramPacket(p);
                }
            } : (rtpConnectorPropertyName.equals(".dataInputStream") ? new DatagramPacketFilter(){

                public boolean accept(DatagramPacket p) {
                    return RtpChannel.this.acceptDataInputStreamDatagramPacket(p);
                }
            } : null)) != null) {
                ((RTPConnectorInputStream)newValue).addDatagramPacketFilter(datagramPacketFilter);
            }
        }
    }

    protected void streamRTPConnectorChanged(RTPConnector oldValue, RTPConnector newValue) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSources(List<SourcePacketExtension> sources) {
        if (sources == null || sources.isEmpty()) {
            return;
        }
        Object object = this.receiveSSRCsSyncRoot;
        synchronized (object) {
            HashSet<Integer> oldSignaledSSRCs = new HashSet<Integer>(this.signaledSSRCs);
            HashSet<Integer> newSignaledSSRCs = new HashSet<Integer>();
            for (SourcePacketExtension source : sources) {
                long ssrc = source.getSSRC();
                if (ssrc == -1L) continue;
                newSignaledSSRCs.add((int)ssrc);
            }
            HashSet addedSSRCs = new HashSet(newSignaledSSRCs);
            addedSSRCs.removeAll(oldSignaledSSRCs);
            if (!addedSSRCs.isEmpty()) {
                Recorder recorder = null;
                Synchronizer synchronizer = null;
                AbstractEndpoint endpoint = null;
                if (this.getContent().isRecording()) {
                    recorder = this.getContent().getRecorder();
                    synchronizer = recorder.getSynchronizer();
                    endpoint = this.getEndpoint();
                }
                for (Integer addedSSRC : addedSSRCs) {
                    try {
                        this.addReceiveSSRC(addedSSRC, false);
                        if (recorder == null || endpoint == null || synchronizer == null) continue;
                        synchronizer.setEndpoint((long)addedSSRC.intValue() & 0xFFFFFFFFL, endpoint.getID());
                    }
                    catch (SizeExceededException see) {
                        this.logger.error((Object)"An unexpected exception occurred.", (Throwable)see);
                    }
                }
            }
            oldSignaledSSRCs.removeAll(newSignaledSSRCs);
            if (!oldSignaledSSRCs.isEmpty()) {
                for (Integer removedSSRC : oldSignaledSSRCs) {
                    this.removeReceiveSSRC(removedSSRC);
                }
            }
            this.signaledSSRCs = newSignaledSSRCs;
        }
        this.touch();
    }

    public void setSourceGroups(List<SourceGroupPacketExtension> sourceGroups) {
    }

    public int[] getReceivePTs() {
        return this.receivePTs;
    }

    @Override
    public boolean expire() {
        if (!super.expire()) {
            return false;
        }
        this.updateStatisticsOnExpire();
        RtpChannelTransformEngine transformEngine = this.transformEngine;
        if (transformEngine != null) {
            PacketTransformer t = transformEngine.getRTPTransformer();
            if (t != null) {
                t.close();
            }
            if ((t = transformEngine.getRTCPTransformer()) != null) {
                t.close();
            }
        }
        return true;
    }

    private void updateStatisticsOnExpire() {
        Conference conference = this.getContent().getConference();
        if (conference != null && conference.includeInStatistics()) {
            SendTrackStats streamStats;
            Conference.Statistics conferenceStatistics = conference.getStatistics();
            conferenceStatistics.totalChannels.incrementAndGet();
            long lastPayloadActivityTime = this.getLastPayloadActivityTime();
            long lastTransportActivityTime = this.getLastTransportActivityTime();
            if (lastTransportActivityTime == 0L) {
                conferenceStatistics.totalNoTransportChannels.incrementAndGet();
            }
            if (lastPayloadActivityTime == 0L) {
                conferenceStatistics.totalNoPayloadChannels.incrementAndGet();
            }
            this.updatePacketsAndBytes(conferenceStatistics);
            MediaStream stream = this.stream;
            if (stream != null && (streamStats = stream.getMediaStreamStats().getSendStats()) != null) {
                this.logger.info(Logger.Category.STATISTICS, "expire_ch_stats," + this.getLoggingId() + " bRecv=" + this.statistics.bytesReceived + ",bSent=" + this.statistics.bytesSent + ",pRecv=" + this.statistics.packetsReceived + ",pSent=" + this.statistics.packetsSent + ",bRetr=" + streamStats.getBytesRetransmitted() + ",bNotRetr=" + streamStats.getBytesNotRetransmitted() + ",pRetr=" + streamStats.getPacketsRetransmitted() + ",pNotRetr=" + streamStats.getPacketsNotRetransmitted() + ",pMiss=" + streamStats.getPacketsMissingFromCache());
            }
        }
    }

    protected void updatePacketsAndBytes(Conference.Statistics conferenceStatistics) {
        if (conferenceStatistics != null) {
            conferenceStatistics.totalBytesReceived.addAndGet(this.statistics.bytesReceived);
            conferenceStatistics.totalBytesSent.addAndGet(this.statistics.bytesSent);
            conferenceStatistics.totalPacketsReceived.addAndGet(this.statistics.packetsReceived);
            conferenceStatistics.totalPacketsSent.addAndGet(this.statistics.packetsSent);
        }
    }

    public ConferenceSpeechActivity getConferenceSpeechActivity() {
        return this.conferenceSpeechActivity;
    }

    public boolean setPacketDelay(int packetDelay) {
        RtpChannelTransformEngine engine = this.transformEngine;
        if (engine == null) {
            engine = this.initializeTransformerEngine();
        }
        return engine.setPacketDelay(packetDelay);
    }

    public RtpChannelTransformEngine getTransformEngine() {
        return this.transformEngine;
    }

    public boolean setRtpEncodingParameters(List<SourcePacketExtension> sources, List<SourceGroupPacketExtension> sourceGroups) {
        boolean changed = false;
        if (sources == null) {
            sources = Collections.emptyList();
        }
        if (sourceGroups == null) {
            sourceGroups = Collections.emptyList();
        }
        if (sources.isEmpty() && sourceGroups.isEmpty()) {
            return false;
        }
        this.setSources(sources);
        this.setSourceGroups(sourceGroups);
        MediaStreamTrackReceiver mediaStreamTrackReceiver = this.stream.getMediaStreamTrackReceiver();
        if (mediaStreamTrackReceiver != null) {
            MediaStreamTrackDesc[] newTracks = MediaStreamTrackFactory.createMediaStreamTracks(mediaStreamTrackReceiver, sources, sourceGroups);
            changed = mediaStreamTrackReceiver.setMediaStreamTracks(newTracks);
        }
        if (changed) {
            this.getContent().getChannels().stream().filter(c -> c != this && c instanceof RtpChannel).forEach(c -> ((RtpChannel)c).updateBitrateController());
        }
        return changed;
    }

    protected void updateBitrateController() {
    }

    @Override
    public String getLoggingId() {
        return RtpChannel.getLoggingId(this);
    }

    public static String getLoggingId(RtpChannel rtpChannel) {
        String channelId = Channel.getLoggingId(rtpChannel);
        MediaStream stream = rtpChannel == null ? null : rtpChannel.getStream();
        return channelId + ",stream=" + (stream == null ? "null" : Integer.valueOf(stream.hashCode()));
    }

    protected class Statistics {
        public long bytesSent = -1L;
        public long bytesReceived = -1L;
        public long packetsSent = -1L;
        public long packetsReceived = -1L;

        protected Statistics() {
        }
    }

    private static class SizeExceededException
    extends Exception {
        private SizeExceededException() {
        }
    }
}

