/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc;

import org.jetbrains.annotations.NotNull;
import org.jitsi.impl.neomedia.codec.video.vp9.DePacketizer;
import org.jitsi.impl.neomedia.rtcp.RTCPSenderInfoUtils;
import org.jitsi.impl.neomedia.rtp.RawPacketCache;
import org.jitsi.service.neomedia.ByteArrayBuffer;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.RTCPUtils;
import org.jitsi.util.RTPUtils;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.cc.AdaptiveTrackProjectionContext;
import org.jitsi.videobridge.cc.RtpState;

class GenericAdaptiveTrackProjectionContext
implements AdaptiveTrackProjectionContext {
    private static final Logger logger = Logger.getLogger(GenericAdaptiveTrackProjectionContext.class);
    private final long ssrc;
    private boolean needsKeyframe = true;
    private final MediaFormat format;
    private int maxDestinationSequenceNumber;
    private long timestampDelta;
    private boolean timestampDeltaInitialized = false;
    private long maxDestinationTimestamp;
    private int sequenceNumberDelta;
    private final Object transmittedSyncRoot = new Object();
    private long transmittedBytes;
    private long transmittedPackets;

    GenericAdaptiveTrackProjectionContext(@NotNull MediaFormat format, @NotNull RtpState rtpState) {
        this.format = format;
        this.ssrc = rtpState.ssrc;
        this.transmittedBytes = rtpState.transmittedBytes;
        this.transmittedPackets = rtpState.transmittedPackets;
        this.maxDestinationSequenceNumber = rtpState.maxSequenceNumber;
        this.maxDestinationTimestamp = rtpState.maxTimestamp;
    }

    @Override
    public synchronized boolean accept(@NotNull RawPacket rtpPacket, int incomingIndex, int targetIndex) {
        boolean accept;
        int destinationSequenceNumber;
        if (targetIndex == -1) {
            this.needsKeyframe = true;
            return false;
        }
        int sourceSequenceNumber = rtpPacket.getSequenceNumber();
        if (this.needsKeyframe) {
            if (GenericAdaptiveTrackProjectionContext.isKeyframe(rtpPacket, this.format)) {
                this.needsKeyframe = false;
                destinationSequenceNumber = this.maxDestinationSequenceNumber + 1;
                this.sequenceNumberDelta = RTPUtils.getSequenceNumberDelta((int)destinationSequenceNumber, (int)sourceSequenceNumber);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("delta ssrc=" + rtpPacket.getSSRCAsLong() + ",src_sequence=" + sourceSequenceNumber + ",dst_sequence=" + destinationSequenceNumber + ",max_sequence=" + this.maxDestinationSequenceNumber + ",delta=" + this.sequenceNumberDelta));
                }
                accept = true;
            } else {
                accept = false;
            }
        } else {
            accept = true;
        }
        if (accept) {
            this.maybeInitializeTimestampDelta(rtpPacket.getTimestamp());
            destinationSequenceNumber = this.computeDestinationSequenceNumber(sourceSequenceNumber);
            long destinationTimestamp = this.computeDestinationTimestamp(rtpPacket.getTimestamp());
            if (RTPUtils.isOlderSequenceNumberThan((int)this.maxDestinationSequenceNumber, (int)destinationSequenceNumber)) {
                this.maxDestinationSequenceNumber = destinationSequenceNumber;
            }
            if (RTPUtils.isNewerTimestampThan((long)destinationSequenceNumber, (long)this.maxDestinationTimestamp)) {
                this.maxDestinationTimestamp = destinationTimestamp;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("accept ssrc=" + rtpPacket.getSSRCAsLong() + ",src_sequence=" + sourceSequenceNumber + ",dst_sequence=" + destinationSequenceNumber + ",max_sequence=" + this.maxDestinationSequenceNumber));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("reject ssrc=" + rtpPacket.getSSRCAsLong() + ",src_sequence=" + sourceSequenceNumber));
        }
        return accept;
    }

    private void maybeInitializeTimestampDelta(long sourceTimestamp) {
        if (this.timestampDeltaInitialized) {
            return;
        }
        if (RTPUtils.isNewerTimestampThan((long)this.maxDestinationSequenceNumber, (long)sourceTimestamp)) {
            long destinationTimestamp = this.maxDestinationTimestamp + 3000L & 0xFFFFFFFFL;
            this.timestampDelta = RTPUtils.rtpTimestampDiff((long)destinationTimestamp, (long)sourceTimestamp);
        }
        this.timestampDeltaInitialized = true;
    }

    private static boolean isKeyframe(@NotNull RawPacket rtpPacket, @NotNull MediaFormat format) {
        byte[] buf = rtpPacket.getBuffer();
        int payloadOff = rtpPacket.getPayloadOffset();
        int payloadLen = rtpPacket.getPayloadLength();
        if ("VP8".equalsIgnoreCase(format.getEncoding())) {
            return org.jitsi.impl.neomedia.codec.video.vp8.DePacketizer.isKeyFrame((byte[])buf, (int)payloadOff, (int)payloadLen);
        }
        if ("h264".equalsIgnoreCase(format.getEncoding())) {
            return org.jitsi.impl.neomedia.codec.video.h264.DePacketizer.isKeyFrame((byte[])buf, (int)payloadOff, (int)payloadLen);
        }
        if ("VP9".equalsIgnoreCase(format.getEncoding())) {
            return DePacketizer.isKeyFrame((byte[])buf, (int)payloadOff, (int)payloadLen);
        }
        return false;
    }

    @Override
    public boolean needsKeyframe() {
        return this.needsKeyframe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawPacket[] rewriteRtp(@NotNull RawPacket rtpPacket, RawPacketCache incomingRawPacketCache) {
        long destinationTimestamp;
        long sourceTimestamp;
        int destinationSequenceNumber;
        int sourceSequenceNumber = rtpPacket.getSequenceNumber();
        if (sourceSequenceNumber != (destinationSequenceNumber = this.computeDestinationSequenceNumber(sourceSequenceNumber))) {
            rtpPacket.setSequenceNumber(destinationSequenceNumber);
        }
        if ((sourceTimestamp = rtpPacket.getTimestamp()) != (destinationTimestamp = this.computeDestinationTimestamp(sourceTimestamp))) {
            rtpPacket.setTimestamp(destinationTimestamp);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("rewrite ssrc=" + rtpPacket.getSSRCAsLong() + ",src_sequence=" + sourceSequenceNumber + ",dst_sequence=" + destinationSequenceNumber + ",max_sequence=" + this.maxDestinationSequenceNumber));
        }
        Object object = this.transmittedSyncRoot;
        synchronized (object) {
            this.transmittedBytes += (long)rtpPacket.getLength();
            ++this.transmittedPackets;
        }
        return EMPTY_PACKET_ARR;
    }

    private int computeDestinationSequenceNumber(int sourceSequenceNumber) {
        return this.sequenceNumberDelta != 0 ? sourceSequenceNumber + this.sequenceNumberDelta & 0xFFFF : sourceSequenceNumber;
    }

    private long computeDestinationTimestamp(long sourceTimestamp) {
        return this.timestampDelta != 0L ? sourceTimestamp + this.timestampDelta & 0xFFFFFFFFL : sourceTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rewriteRtcp(@NotNull RawPacket rtcpPacket) {
        if (RTCPUtils.getPacketType((ByteArrayBuffer)rtcpPacket) == 200) {
            Object object = this.transmittedSyncRoot;
            synchronized (object) {
                RTCPSenderInfoUtils.setOctetCount((ByteArrayBuffer)rtcpPacket, (int)((int)this.transmittedBytes));
                RTCPSenderInfoUtils.setPacketCount((ByteArrayBuffer)rtcpPacket, (int)((int)this.transmittedPackets));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtpState getRtpState() {
        Object object = this.transmittedSyncRoot;
        synchronized (object) {
            return new RtpState(this.transmittedBytes, this.transmittedPackets, this.ssrc, this.maxDestinationSequenceNumber, this.maxDestinationTimestamp);
        }
    }

    @Override
    public MediaFormat getFormat() {
        return this.format;
    }
}

