/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.transform;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jitsi.impl.neomedia.transform.REDFilterTransformEngine;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.TransformEngineChain;
import org.jitsi.impl.neomedia.transform.delay.DelayingTransformEngine;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.TransformChainManipulator;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.cc.BitrateController;

public class RtpChannelTransformEngine
extends TransformEngineChain {
    private static final Logger classLogger = Logger.getLogger(RtpChannelTransformEngine.class);
    private static final byte RED_PAYLOAD_TYPE = 116;
    private final RtpChannel channel;
    private REDFilterTransformEngine redFilter;
    private final Logger logger;

    public RtpChannelTransformEngine(RtpChannel channel, Iterable<TransformChainManipulator> manipulators) {
        this.channel = channel;
        this.logger = Logger.getLogger((Logger)classLogger, (Logger)channel.getContent().getConference().getLogger());
        TransformEngine[] chain = this.createChain();
        if (manipulators != null) {
            for (TransformChainManipulator manipulator : manipulators) {
                chain = manipulator.manipulate(chain, channel);
            }
        }
        this.engineChain = chain;
    }

    private TransformEngine[] createChain() {
        List<TransformEngine> transformerList;
        boolean video = this.channel instanceof VideoChannel;
        if (video) {
            VideoChannel videoChannel = (VideoChannel)this.channel;
            transformerList = new LinkedList();
            BitrateController bitrateController = videoChannel.getBitrateController();
            if (bitrateController != null) {
                transformerList.add(bitrateController);
            }
            this.redFilter = new REDFilterTransformEngine(116);
            transformerList.add((TransformEngine)this.redFilter);
        } else {
            transformerList = Collections.emptyList();
        }
        return transformerList.toArray(new TransformEngine[transformerList.size()]);
    }

    public void enableREDFilter(boolean enabled) {
        if (this.redFilter != null) {
            this.redFilter.setEnabled(enabled);
        }
    }

    public boolean setPacketDelay(int packetDelay) {
        if (packetDelay > 0) {
            for (TransformEngine engine : this.engineChain) {
                if (!(engine instanceof DelayingTransformEngine)) continue;
                this.logger.warn((Object)"Can not modify packet-delay once it has been set.");
                return false;
            }
            if (this.addEngine((TransformEngine)new DelayingTransformEngine(packetDelay))) {
                this.logger.info((Object)("Adding delaying packet transformer to " + this.channel.getID() + ", packet delay: " + packetDelay));
                return true;
            }
            this.logger.warn((Object)"Failed to add delaying packet transformer");
            return false;
        }
        return false;
    }
}

