/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.usability;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.usability.diagnostics.DiagnosisUtils;
import org.apache.maven.usability.diagnostics.ErrorDiagnoser;

public class MojoExecutionExceptionDiagnoser
implements ErrorDiagnoser {
    public boolean canDiagnose(Throwable error) {
        return DiagnosisUtils.containsInCausality((Throwable)error, MojoExecutionException.class);
    }

    public String diagnose(Throwable error) {
        Throwable directCause;
        String longMessage;
        String shortMessage;
        MojoExecutionException mee = (MojoExecutionException)DiagnosisUtils.getFromCausality((Throwable)error, MojoExecutionException.class);
        StringBuffer message = new StringBuffer();
        Object source = mee.getSource();
        if (source != null) {
            message.append(": ").append(mee.getSource()).append("\n");
        }
        if ((shortMessage = mee.getMessage()) != null) {
            message.append(shortMessage);
        }
        if ((longMessage = mee.getLongMessage()) != null && !longMessage.equals(shortMessage) && shortMessage.indexOf(longMessage) < 0) {
            message.append("\n\n").append(longMessage);
        }
        if ((directCause = mee.getCause()) != null) {
            message.append("\n");
            String directCauseMessage = directCause.getMessage();
            String meeMessage = mee.getMessage();
            if (directCauseMessage != null && meeMessage != null && meeMessage.indexOf(directCauseMessage) < 0) {
                message.append("\nEmbedded error: ").append(directCauseMessage);
            }
            DiagnosisUtils.appendRootCauseIfPresentAndUnique((Throwable)directCause, (StringBuffer)message, (boolean)false);
        }
        return message.toString();
    }
}

