/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.validation.validators;

import java.util.Collection;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.validation.ConstraintValidator;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.status.StatusLogger;

public class RequiredValidator
implements ConstraintValidator<Required> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private Required annotation;

    @Override
    public void initialize(Required annotation) {
        this.annotation = annotation;
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return this.err();
        }
        if (value instanceof CharSequence) {
            CharSequence sequence = (CharSequence)value;
            return sequence.length() != 0 || this.err();
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            Object[] array = (Object[])value;
            return array.length != 0 || this.err();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection collection = (Collection)value;
            return collection.size() != 0 || this.err();
        }
        if (Map.class.isAssignableFrom(clazz)) {
            Map map = (Map)value;
            return map.size() != 0 || this.err();
        }
        LOGGER.debug("Encountered type [{}] which can only be checked for null.", new Object[]{clazz.getName()});
        return true;
    }

    private boolean err() {
        LOGGER.error(this.annotation.message());
        return false;
    }
}

