/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.neomedia;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.MediaException;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.java.sip.communicator.impl.neomedia.DeviceConfigurationComboBoxModel;
import net.java.sip.communicator.impl.neomedia.EncodingConfigurationTableModel;
import net.java.sip.communicator.impl.neomedia.NeomediaActivator;
import net.java.sip.communicator.impl.neomedia.codec.video.h264.OpenH264Retriever;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTabbedPane;
import net.java.sip.communicator.plugin.desktoputil.SoundLevelIndicator;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.util.Logger;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.impl.neomedia.device.AudioMediaDeviceImpl;
import org.jitsi.impl.neomedia.device.AudioMediaDeviceSession;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.device.DeviceConfiguration;
import org.jitsi.impl.neomedia.device.MediaDeviceImpl;
import org.jitsi.impl.neomedia.device.MediaDeviceSession;
import org.jitsi.service.audionotifier.AudioNotifierService;
import org.jitsi.service.audionotifier.SCAudioClip;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.MediaConfigurationService;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.service.neomedia.codec.EncodingConfiguration;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.event.SimpleAudioLevelListener;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;
import org.jitsi.util.swing.VideoContainer;
import org.jitsi.utils.MediaType;

public class MediaConfigurationImpl
implements ActionListener,
MediaConfigurationService {
    private static final String DEVICES_DISABLED_PROP = "net.java.sip.communicator.impl.neomedia.devicesconfig.DISABLED";
    private static final String ENCODINGS_DISABLED_PROP = "net.java.sip.communicator.impl.neomedia.encodingsconfig.DISABLED";
    private static final Logger logger = Logger.getLogger(MediaConfigurationImpl.class);
    private static final MediaServiceImpl mediaService = NeomediaActivator.getMediaServiceImpl();
    private static final String TEST_SOUND_FILENAME_PROP = "net.java.sip.communicator.impl.neomedia.TestSoundFilename";
    private static final String VIDEO_MORE_SETTINGS_DISABLED_PROP = "net.java.sip.communicator.impl.neomedia.videomoresettingsconfig.DISABLED";
    private static final int WIDTH = 350;
    private AudioLevelListenerThread audioLevelListenerThread = null;
    private JButton notificationPlaySoundButton;
    private JComboBox notifyCombo;
    private JComboBox playbackCombo;
    private JButton playbackPlaySoundButton;

    private static Component createVideoAdvancedSettings() {
        ResourceManagementService resources = NeomediaActivator.getResources();
        final DeviceConfiguration deviceConfig = mediaService.getDeviceConfiguration();
        TransparentPanel centerPanel = new TransparentPanel((LayoutManager)new GridBagLayout());
        centerPanel.setMaximumSize(new Dimension(350, 150));
        JButton resetDefaultsButton = new JButton(resources.getI18NString("impl.media.configform.VIDEO_RESET"));
        TransparentPanel resetButtonPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
        resetButtonPanel.add(resetDefaultsButton);
        TransparentPanel centerAdvancedPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        centerAdvancedPanel.add((Component)centerPanel, "North");
        centerAdvancedPanel.add((Component)resetButtonPanel, "South");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 0, 0);
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridy = 0;
        centerPanel.add((Component)new JLabel(resources.getI18NString("impl.media.configform.VIDEO_RESOLUTION")), (Object)constraints);
        constraints.gridy = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        SIPCommCheckBox frameRateCheck = new SIPCommCheckBox(resources.getI18NString("impl.media.configform.VIDEO_FRAME_RATE"));
        centerPanel.add((Component)frameRateCheck, (Object)constraints);
        constraints.gridy = 2;
        constraints.insets = new Insets(5, 5, 0, 0);
        centerPanel.add((Component)new JLabel(resources.getI18NString("impl.media.configform.VIDEO_PACKETS_POLICY")), (Object)constraints);
        constraints.gridy = 3;
        centerPanel.add((Component)new JLabel(resources.getI18NString("impl.media.configform.VIDEO_BITRATE")), (Object)constraints);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 0, 0, 5);
        Object[] resolutionValues = new Object[DeviceConfiguration.SUPPORTED_RESOLUTIONS.length + 1];
        System.arraycopy(DeviceConfiguration.SUPPORTED_RESOLUTIONS, 0, resolutionValues, 1, DeviceConfiguration.SUPPORTED_RESOLUTIONS.length);
        final JComboBox<Object> sizeCombo = new JComboBox<Object>(resolutionValues);
        sizeCombo.setRenderer(new ResolutionCellRenderer());
        sizeCombo.setEditable(false);
        centerPanel.add(sizeCombo, (Object)constraints);
        final JSpinner frameRate = new JSpinner(new SpinnerNumberModel(20, 5, 30, 1));
        frameRate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                deviceConfig.setFrameRate(((SpinnerNumberModel)frameRate.getModel()).getNumber().intValue());
            }
        });
        constraints.gridy = 1;
        constraints.insets = new Insets(0, 0, 0, 5);
        centerPanel.add((Component)frameRate, (Object)constraints);
        frameRateCheck.addActionListener(new ActionListener((JCheckBox)frameRateCheck, deviceConfig, frameRate){
            final /* synthetic */ JCheckBox val$frameRateCheck;
            final /* synthetic */ DeviceConfiguration val$deviceConfig;
            final /* synthetic */ JSpinner val$frameRate;
            {
                this.val$frameRateCheck = jCheckBox;
                this.val$deviceConfig = deviceConfiguration;
                this.val$frameRate = jSpinner;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.val$frameRateCheck.isSelected()) {
                    this.val$deviceConfig.setFrameRate(((SpinnerNumberModel)this.val$frameRate.getModel()).getNumber().intValue());
                } else {
                    this.val$deviceConfig.setFrameRate(-1);
                }
                this.val$frameRate.setEnabled(this.val$frameRateCheck.isSelected());
            }
        });
        int videoMaxBandwith = deviceConfig.getVideoRTPPacingThreshold();
        videoMaxBandwith = videoMaxBandwith > 999 ? 999 : videoMaxBandwith;
        final JSpinner videoMaxBandwidth = new JSpinner(new SpinnerNumberModel(videoMaxBandwith, 1, 999, 1));
        videoMaxBandwidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                deviceConfig.setVideoRTPPacingThreshold(((SpinnerNumberModel)videoMaxBandwidth.getModel()).getNumber().intValue());
            }
        });
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.insets = new Insets(0, 0, 5, 5);
        centerPanel.add((Component)videoMaxBandwidth, (Object)constraints);
        final JSpinner videoBitrate = new JSpinner(new SpinnerNumberModel(deviceConfig.getVideoBitrate(), 1, Integer.MAX_VALUE, 1));
        videoBitrate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                deviceConfig.setVideoBitrate(((SpinnerNumberModel)videoBitrate.getModel()).getNumber().intValue());
            }
        });
        constraints.gridy = 3;
        centerPanel.add((Component)videoBitrate, (Object)constraints);
        resetDefaultsButton.addActionListener(new ActionListener((JCheckBox)frameRateCheck, frameRate, deviceConfig, videoMaxBandwidth, videoBitrate){
            final /* synthetic */ JCheckBox val$frameRateCheck;
            final /* synthetic */ JSpinner val$frameRate;
            final /* synthetic */ DeviceConfiguration val$deviceConfig;
            final /* synthetic */ JSpinner val$videoMaxBandwidth;
            final /* synthetic */ JSpinner val$videoBitrate;
            {
                this.val$frameRateCheck = jCheckBox;
                this.val$frameRate = jSpinner;
                this.val$deviceConfig = deviceConfiguration;
                this.val$videoMaxBandwidth = jSpinner2;
                this.val$videoBitrate = jSpinner3;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                sizeCombo.setSelectedIndex(0);
                this.val$frameRateCheck.setSelected(false);
                this.val$frameRate.setEnabled(false);
                this.val$frameRate.setValue(20);
                this.val$deviceConfig.setFrameRate(-1);
                this.val$videoMaxBandwidth.setValue(256);
                this.val$videoBitrate.setValue(128);
            }
        });
        Dimension videoSize = deviceConfig.getVideoSize();
        if (videoSize.getHeight() != 480.0 && videoSize.getWidth() != 640.0) {
            sizeCombo.setSelectedItem(deviceConfig.getVideoSize());
        } else {
            sizeCombo.setSelectedIndex(0);
        }
        sizeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dimension selectedVideoSize = (Dimension)sizeCombo.getSelectedItem();
                if (selectedVideoSize == null) {
                    selectedVideoSize = new Dimension(640, 480);
                }
                deviceConfig.setVideoSize(selectedVideoSize);
            }
        });
        frameRateCheck.setSelected(deviceConfig.getFrameRate() != -1);
        frameRate.setEnabled(frameRateCheck.isSelected());
        if (frameRate.isEnabled()) {
            frameRate.setValue(deviceConfig.getFrameRate());
        }
        return centerAdvancedPanel;
    }

    private static JComponent createVideoContainer(Component noVideoComponent) {
        return new VideoContainer(noVideoComponent, false);
    }

    private static void createVideoPreview(CaptureDeviceInfo device, JComponent videoContainer) throws IOException, MediaException {
        videoContainer.removeAll();
        videoContainer.revalidate();
        videoContainer.repaint();
        if (device == null) {
            return;
        }
        for (MediaDevice mediaDevice : mediaService.getDevices(MediaType.VIDEO, MediaUseCase.ANY)) {
            if (!((MediaDeviceImpl)mediaDevice).getCaptureDeviceInfo().equals((Object)device)) continue;
            Dimension videoContainerSize = videoContainer.getPreferredSize();
            Component preview = (Component)mediaService.getVideoPreviewComponent(mediaDevice, videoContainerSize.width, videoContainerSize.height);
            if (preview == null) break;
            videoContainer.add(preview);
            break;
        }
    }

    private static char getDisplayedMnemonic(int type) {
        switch (type) {
            case 1: {
                return NeomediaActivator.getResources().getI18nMnemonic("impl.media.configform.AUDIO");
            }
            case 2: {
                return NeomediaActivator.getResources().getI18nMnemonic("impl.media.configform.VIDEO");
            }
        }
        throw new IllegalArgumentException("type");
    }

    private static String getLabelText(int type) {
        switch (type) {
            case 1: {
                return NeomediaActivator.getResources().getI18NString("impl.media.configform.AUDIO");
            }
            case 3: {
                return NeomediaActivator.getResources().getI18NString("impl.media.configform.AUDIO_IN");
            }
            case 5: {
                return NeomediaActivator.getResources().getI18NString("impl.media.configform.AUDIO_NOTIFY");
            }
            case 4: {
                return NeomediaActivator.getResources().getI18NString("impl.media.configform.AUDIO_OUT");
            }
            case 2: {
                return NeomediaActivator.getResources().getI18NString("impl.media.configform.VIDEO");
            }
        }
        throw new IllegalArgumentException("type");
    }

    private static void move(JTable table, boolean up) {
        int index = ((EncodingConfigurationTableModel)((Object)table.getModel())).move(table.getSelectedRow(), up);
        table.getSelectionModel().setSelectionInterval(index, index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean isPlaybackEvent;
        boolean bl = isPlaybackEvent = e.getSource() == this.playbackPlaySoundButton;
        if (isPlaybackEvent || e.getSource() == this.notificationPlaySoundButton) {
            AudioNotifierService audioNotifServ = NeomediaActivator.getAudioNotifierService();
            String testSoundFilename = NeomediaActivator.getConfigurationService().getString(TEST_SOUND_FILENAME_PROP, NeomediaActivator.getResources().getSoundPath("TEST_SOUND"));
            SCAudioClip sound = audioNotifServ.createAudio(testSoundFilename, isPlaybackEvent);
            sound.play();
        } else if (e.getSource() == this.playbackCombo || e.getSource() == this.notifyCombo) {
            boolean isEnabled;
            DeviceConfigurationComboBoxModel.CaptureDevice device = (DeviceConfigurationComboBoxModel.CaptureDevice)((JComboBox)e.getSource()).getSelectedItem();
            boolean bl2 = isEnabled = device.info != null;
            if (e.getSource() == this.playbackCombo) {
                this.playbackPlaySoundButton.setEnabled(isEnabled);
            } else {
                this.notificationPlaySoundButton.setEnabled(isEnabled);
            }
        }
    }

    public Component createAudioConfigPanel() {
        return this.createControls(1);
    }

    public void createAudioSystemControls(final AudioSystem audioSystem, JComponent container) {
        GridBagConstraints cnstrnts = new GridBagConstraints();
        cnstrnts.anchor = 18;
        cnstrnts.fill = 2;
        cnstrnts.weighty = 0.0;
        int audioSystemFeatures = audioSystem.getFeatures();
        boolean featureNotifyAndPlaybackDevices = (audioSystemFeatures & 8) != 0;
        cnstrnts.gridx = 0;
        cnstrnts.insets = new Insets(3, 0, 3, 3);
        cnstrnts.weightx = 0.0;
        cnstrnts.gridy = 0;
        container.add((Component)new JLabel(MediaConfigurationImpl.getLabelText(3)), cnstrnts);
        if (featureNotifyAndPlaybackDevices) {
            cnstrnts.gridy = 2;
            container.add((Component)new JLabel(MediaConfigurationImpl.getLabelText(4)), cnstrnts);
            cnstrnts.gridy = 3;
            container.add((Component)new JLabel(MediaConfigurationImpl.getLabelText(5)), cnstrnts);
        }
        cnstrnts.gridx = 1;
        cnstrnts.insets = new Insets(3, 3, 3, 0);
        cnstrnts.weightx = 1.0;
        JComboBox captureCombo = null;
        if (featureNotifyAndPlaybackDevices) {
            captureCombo = new JComboBox();
            captureCombo.setEditable(false);
            captureCombo.setModel(new DeviceConfigurationComboBoxModel(mediaService.getDeviceConfiguration(), 3));
            cnstrnts.gridy = 0;
            container.add(captureCombo, cnstrnts);
        }
        int anchor = cnstrnts.anchor;
        SoundLevelIndicator capturePreview = new SoundLevelIndicator(0, 127);
        cnstrnts.anchor = 10;
        cnstrnts.gridy = captureCombo == null ? 0 : 1;
        container.add((Component)capturePreview, cnstrnts);
        cnstrnts.anchor = anchor;
        cnstrnts.gridy = -1;
        if (featureNotifyAndPlaybackDevices) {
            this.playbackCombo = new JComboBox();
            this.playbackCombo.setEditable(false);
            this.playbackCombo.setModel(new DeviceConfigurationComboBoxModel(mediaService.getDeviceConfiguration(), 4));
            this.playbackCombo.addActionListener(this);
            container.add((Component)this.playbackCombo, cnstrnts);
            this.notifyCombo = new JComboBox();
            this.notifyCombo.setEditable(false);
            this.notifyCombo.setModel(new DeviceConfigurationComboBoxModel(mediaService.getDeviceConfiguration(), 5));
            this.notifyCombo.addActionListener(this);
            container.add((Component)this.notifyCombo, cnstrnts);
        }
        int[] checkBoxAudioSystemFeatures = new int[]{4, 2, 16};
        block5: for (int i = 0; i < checkBoxAudioSystemFeatures.length; ++i) {
            boolean selected;
            String textKey;
            final int f = checkBoxAudioSystemFeatures[i];
            if ((f & audioSystemFeatures) == 0) continue;
            switch (f) {
                case 16: {
                    textKey = "impl.media.configform.AUTOMATICGAINCONTROL";
                    selected = audioSystem.isAutomaticGainControl();
                    break;
                }
                case 2: {
                    textKey = "impl.media.configform.DENOISE";
                    selected = audioSystem.isDenoise();
                    break;
                }
                case 4: {
                    textKey = "impl.media.configform.ECHOCANCEL";
                    selected = audioSystem.isEchoCancel();
                    break;
                }
                default: {
                    continue block5;
                }
            }
            final SIPCommCheckBox checkBox = new SIPCommCheckBox(NeomediaActivator.getResources().getI18NString(textKey));
            checkBox.setSelected(selected);
            checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean b = checkBox.isSelected();
                    switch (f) {
                        case 16: {
                            audioSystem.setAutomaticGainControl(b);
                            break;
                        }
                        case 2: {
                            audioSystem.setDenoise(b);
                            break;
                        }
                        case 4: {
                            audioSystem.setEchoCancel(b);
                        }
                    }
                }
            });
            container.add((Component)checkBox, cnstrnts);
        }
        cnstrnts.gridx = 2;
        cnstrnts.insets = new Insets(3, 3, 3, 0);
        cnstrnts.weightx = 0.0;
        if (featureNotifyAndPlaybackDevices) {
            cnstrnts.gridy = 2;
            this.playbackPlaySoundButton = new JButton(new ImageIcon(NeomediaActivator.getResources().getImageInBytes("plugin.notificationconfig.PLAY_ICON")));
            this.playbackPlaySoundButton.setMinimumSize(new Dimension(30, 30));
            this.playbackPlaySoundButton.setPreferredSize(new Dimension(30, 30));
            if (((DeviceConfigurationComboBoxModel.CaptureDevice)this.playbackCombo.getSelectedItem()).info == null) {
                this.playbackPlaySoundButton.setEnabled(false);
            }
            this.playbackPlaySoundButton.setOpaque(false);
            this.playbackPlaySoundButton.addActionListener(this);
            container.add((Component)this.playbackPlaySoundButton, cnstrnts);
            cnstrnts.gridy = 3;
            this.notificationPlaySoundButton = new JButton(new ImageIcon(NeomediaActivator.getResources().getImageInBytes("plugin.notificationconfig.PLAY_ICON")));
            this.notificationPlaySoundButton.setMinimumSize(new Dimension(30, 30));
            this.notificationPlaySoundButton.setPreferredSize(new Dimension(30, 30));
            if (((DeviceConfigurationComboBoxModel.CaptureDevice)this.notifyCombo.getSelectedItem()).info == null) {
                this.notificationPlaySoundButton.setEnabled(false);
            }
            this.notificationPlaySoundButton.setOpaque(false);
            this.notificationPlaySoundButton.addActionListener(this);
            container.add((Component)this.notificationPlaySoundButton, cnstrnts);
        }
        if (this.audioLevelListenerThread == null) {
            this.audioLevelListenerThread = new AudioLevelListenerThread(audioSystem, captureCombo, capturePreview);
        } else {
            this.audioLevelListenerThread.init(audioSystem, captureCombo, capturePreview);
        }
    }

    private Component createBasicControls(int type) {
        int preferredDeviceAndPreviewPanelHeight;
        TransparentPanel devicePanel;
        DeviceComboBoxField deviceComboBox;
        boolean setAudioSystemIsDisabled;
        boolean bl = setAudioSystemIsDisabled = type == 1 && NeomediaActivator.getConfigurationService().getBoolean("net.java.sip.communicator.impl.neomedia.audiosystem.DISABLED", false);
        if (setAudioSystemIsDisabled) {
            deviceComboBox = null;
            devicePanel = null;
        } else {
            JLabel deviceLabel = new JLabel(MediaConfigurationImpl.getLabelText(type));
            deviceLabel.setDisplayedMnemonic(MediaConfigurationImpl.getDisplayedMnemonic(type));
            devicePanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
            devicePanel.setMaximumSize(new Dimension(350, 25));
            devicePanel.add(deviceLabel);
            deviceComboBox = new DeviceComboBoxField(type, (Container)devicePanel);
            deviceLabel.setLabelFor(deviceComboBox.getComponent());
        }
        TransparentPanel deviceAndPreviewPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        switch (type) {
            case 1: {
                preferredDeviceAndPreviewPanelHeight = devicePanel == null ? 200 : 245;
                break;
            }
            case 2: {
                preferredDeviceAndPreviewPanelHeight = 305;
                break;
            }
            default: {
                preferredDeviceAndPreviewPanelHeight = 0;
            }
        }
        if (preferredDeviceAndPreviewPanelHeight > 0) {
            deviceAndPreviewPanel.setPreferredSize(new Dimension(350, preferredDeviceAndPreviewPanelHeight));
        }
        if (devicePanel != null) {
            deviceAndPreviewPanel.add((Component)devicePanel, "North");
        }
        final DeviceComboBoxField.Listener deviceComboBoxActionListener = new DeviceComboBoxField.Listener((JPanel)deviceAndPreviewPanel, (Container)devicePanel, deviceComboBox, type){
            final /* synthetic */ JPanel val$deviceAndPreviewPanel;
            final /* synthetic */ Container val$devicePanel;
            final /* synthetic */ DeviceComboBoxField val$deviceComboBox;
            final /* synthetic */ int val$type;
            {
                this.val$deviceAndPreviewPanel = jPanel;
                this.val$devicePanel = container;
                this.val$deviceComboBox = deviceComboBoxField;
                this.val$type = n;
            }

            @Override
            public void onAction() {
                boolean revalidateAndRepaint = false;
                for (int i = this.val$deviceAndPreviewPanel.getComponentCount() - 1; i >= 0; --i) {
                    Component c = this.val$deviceAndPreviewPanel.getComponent(i);
                    if (c == this.val$devicePanel) continue;
                    this.val$deviceAndPreviewPanel.remove(i);
                    revalidateAndRepaint = true;
                }
                Component preview = null;
                if (this.val$deviceComboBox == null || this.val$deviceComboBox.getSelectedItem() != null && this.val$deviceComboBox.getComponent().isShowing()) {
                    preview = MediaConfigurationImpl.this.createPreview(this.val$type, this.val$deviceComboBox, this.val$deviceAndPreviewPanel.getPreferredSize());
                }
                if (preview != null) {
                    this.val$deviceAndPreviewPanel.add(preview, "Center");
                    revalidateAndRepaint = true;
                }
                if (revalidateAndRepaint) {
                    this.val$deviceAndPreviewPanel.revalidate();
                    this.val$deviceAndPreviewPanel.repaint();
                }
            }
        };
        if (deviceComboBox != null) {
            deviceComboBox.addListener(deviceComboBoxActionListener);
        }
        deviceAndPreviewPanel.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent event) {
                if ((event.getChangeFlags() & 4L) != 0L) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            deviceComboBoxActionListener.onAction();
                        }
                    });
                }
            }
        });
        return deviceAndPreviewPanel;
    }

    private Component createControls(int type) {
        SIPCommTabbedPane container;
        ConfigurationService cfg = NeomediaActivator.getConfigurationService();
        Component devicesComponent = null;
        Component encodingsComponent = null;
        Component videoComponent = null;
        int compCount = 0;
        if (cfg == null || !cfg.getBoolean(DEVICES_DISABLED_PROP, false)) {
            ++compCount;
            devicesComponent = this.createBasicControls(type);
        }
        if (cfg == null || !cfg.getBoolean(ENCODINGS_DISABLED_PROP, false)) {
            ++compCount;
            encodingsComponent = this.createEncodingControls(type, null);
        }
        if (!(type != 2 || cfg != null && cfg.getBoolean(VIDEO_MORE_SETTINGS_DISABLED_PROP, false))) {
            ++compCount;
            videoComponent = MediaConfigurationImpl.createVideoAdvancedSettings();
        }
        ResourceManagementService res = NeomediaActivator.getResources();
        if (compCount < 2) {
            container = new TransparentPanel((LayoutManager)new BorderLayout());
            if (devicesComponent != null) {
                container.add(devicesComponent);
            } else if (encodingsComponent != null) {
                container.add(encodingsComponent);
            } else if (videoComponent != null) {
                container.add(videoComponent);
            }
        } else {
            SIPCommTabbedPane tabbedPane = container = new SIPCommTabbedPane();
            int index = 0;
            if (devicesComponent != null) {
                tabbedPane.insertTab(res.getI18NString("impl.media.configform.DEVICES"), null, devicesComponent, null, index);
                index = 1;
            }
            if (encodingsComponent != null) {
                if (tabbedPane.getTabCount() >= 1) {
                    index = 1;
                }
                tabbedPane.insertTab(res.getI18NString("impl.media.configform.ENCODINGS"), null, encodingsComponent, null, index);
            }
            if (videoComponent != null) {
                if (tabbedPane.getTabCount() >= 2) {
                    index = 2;
                }
                tabbedPane.insertTab(res.getI18NString("impl.media.configform.VIDEO_MORE_SETTINGS"), null, videoComponent, null, index);
            }
        }
        return container;
    }

    private Component createEncodingControls(int type, EncodingConfiguration encodingConfiguration) {
        boolean isEncodingConfigurationNull = false;
        if (encodingConfiguration == null) {
            isEncodingConfigurationNull = true;
            encodingConfiguration = mediaService.getCurrentEncodingConfiguration();
        }
        ResourceManagementService resources = NeomediaActivator.getResources();
        final JTable table = new JTable();
        table.setShowGrid(false);
        table.setTableHeader(null);
        table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable rtable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(rtable, value, isSelected, hasFocus, row, column);
                component.setEnabled(rtable != null && rtable.isEnabled());
                return component;
            }
        });
        String key = "impl.media.configform.UP";
        final JButton upButton = new JButton(resources.getI18NString(key));
        upButton.setMnemonic(resources.getI18nMnemonic(key));
        upButton.setOpaque(false);
        key = "impl.media.configform.DOWN";
        final JButton downButton = new JButton(resources.getI18NString(key));
        downButton.setMnemonic(resources.getI18nMnemonic(key));
        downButton.setOpaque(false);
        TransparentPanel buttonBar = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
        buttonBar.add(upButton);
        buttonBar.add(downButton);
        TransparentPanel parentButtonBar = new TransparentPanel((LayoutManager)new BorderLayout());
        parentButtonBar.add((Component)buttonBar, "North");
        table.setModel((TableModel)((Object)new EncodingConfigurationTableModel(type, encodingConfiguration)));
        TableColumnModel tableColumnModel = table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setMaxWidth(tableColumn.getMinWidth());
        final ListSelectionListener tableSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                int selectedRow;
                if (table.getSelectedRowCount() == 1 && (selectedRow = table.getSelectedRow()) > -1) {
                    upButton.setEnabled(selectedRow > 0);
                    downButton.setEnabled(selectedRow < table.getRowCount() - 1);
                    return;
                }
                upButton.setEnabled(false);
                downButton.setEnabled(false);
            }
        };
        table.getSelectionModel().addListSelectionListener(tableSelectionListener);
        tableSelectionListener.valueChanged(null);
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean up;
                Object source = event.getSource();
                if (source == upButton) {
                    up = true;
                } else if (source == downButton) {
                    up = false;
                } else {
                    return;
                }
                MediaConfigurationImpl.move(table, up);
            }
        };
        upButton.addActionListener(buttonListener);
        downButton.addActionListener(buttonListener);
        TransparentPanel container = new TransparentPanel(new BorderLayout()){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                table.setEnabled(enabled);
                if (enabled) {
                    tableSelectionListener.valueChanged(null);
                } else {
                    upButton.setEnabled(false);
                    downButton.setEnabled(false);
                }
            }
        };
        container.setPreferredSize(new Dimension(350, 100));
        container.setMaximumSize(new Dimension(350, 100));
        container.add((Component)new JScrollPane(table), "Center");
        container.add((Component)parentButtonBar, "East");
        if (type == 2 && isEncodingConfigurationNull && (OSUtils.IS_MAC || OSUtils.IS_WINDOWS)) {
            container.add((Component)OpenH264Retriever.getConfigPanel(), "South");
        }
        return container;
    }

    public Component createEncodingControls(MediaType mediaType, EncodingConfiguration encodingConfiguration) {
        int deviceConfigurationComboBoxModelType;
        if (encodingConfiguration == null) {
            encodingConfiguration = mediaService.getCurrentEncodingConfiguration();
        }
        switch (mediaType) {
            case AUDIO: {
                deviceConfigurationComboBoxModelType = 1;
                break;
            }
            case VIDEO: {
                deviceConfigurationComboBoxModelType = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("mediaType");
            }
        }
        return this.createEncodingControls(deviceConfigurationComboBoxModelType, encodingConfiguration);
    }

    private Component createPreview(int type, DeviceComboBoxField comboBox, Dimension prefSize) {
        JComponent preview = null;
        if (type == 1) {
            AudioSystem audioSystem = null;
            if (comboBox == null || !comboBox.getComponent().isEnabled()) {
                audioSystem = mediaService.getDeviceConfiguration().getAudioSystem();
            } else {
                AudioSystem mediaServiceDeviceConfigurationAudioSystem;
                Object selectedItem = comboBox.getSelectedItem();
                if (selectedItem instanceof AudioSystem && (audioSystem = (AudioSystem)selectedItem) != (mediaServiceDeviceConfigurationAudioSystem = mediaService.getDeviceConfiguration().getAudioSystem())) {
                    logger.warn((Object)"JComboBox.selectedItem is not identical to MediaService.deviceConfiguration.audioSystem!");
                }
            }
            if (audioSystem != null && !"none".equalsIgnoreCase(audioSystem.getLocatorProtocol())) {
                preview = new TransparentPanel((LayoutManager)new GridBagLayout());
                this.createAudioSystemControls(audioSystem, preview);
            } else {
                AudioSystem[] availableAudioSystems;
                AudioSystem[] audioSystems = AudioSystem.getAudioSystems();
                if (audioSystems != null && audioSystems.length != 1 && (availableAudioSystems = mediaService.getDeviceConfiguration().getAvailableAudioSystems()) != null && availableAudioSystems.length == 1) {
                    String noAvailableAudioDevice = NeomediaActivator.getResources().getI18NString("impl.media.configform.NO_AVAILABLE_AUDIO_DEVICE");
                    preview = new TransparentPanel((LayoutManager)new GridBagLayout());
                    preview.add(new JLabel(noAvailableAudioDevice));
                }
            }
        } else if (type == 2) {
            Throwable exception;
            JLabel noPreview = new JLabel(NeomediaActivator.getResources().getI18NString("impl.media.configform.NO_PREVIEW"));
            noPreview.setHorizontalAlignment(0);
            noPreview.setVerticalAlignment(0);
            preview = MediaConfigurationImpl.createVideoContainer(noPreview);
            preview.setPreferredSize(prefSize);
            Object selectedItem = comboBox.getSelectedItem();
            CaptureDeviceInfo device = null;
            if (selectedItem instanceof DeviceConfigurationComboBoxModel.CaptureDevice) {
                device = ((DeviceConfigurationComboBoxModel.CaptureDevice)selectedItem).info;
            }
            try {
                MediaConfigurationImpl.createVideoPreview(device, preview);
                exception = null;
            }
            catch (IOException ex) {
                exception = ex;
            }
            catch (MediaException ex) {
                exception = ex;
            }
            if (exception != null) {
                logger.error((Object)("Failed to create preview for device " + device), exception);
            }
        }
        return preview;
    }

    public Component createVideoConfigPanel() {
        return this.createControls(2);
    }

    public MediaService getMediaService() {
        return mediaService;
    }

    private static class DeviceComboBoxField {
        private JComboBox deviceComboBox = null;
        private JList deviceList = null;
        private Component deviceComponent;
        private Listener listener;
        final DeviceConfigurationComboBoxModel model;

        public DeviceComboBoxField(int type, Container devicePanel) {
            this.model = new DeviceConfigurationComboBoxModel(mediaService.getDeviceConfiguration(), type);
            if (!OSUtils.IS_WINDOWS || type != 2) {
                this.deviceComboBox = new JComboBox();
                this.deviceComboBox.setEditable(false);
                this.deviceComboBox.setModel(this.model);
                devicePanel.add(this.deviceComboBox);
                this.deviceComponent = this.deviceComboBox;
            } else {
                this.deviceList = new JList();
                this.deviceList.setModel(this.model);
                JScrollPane listScroller = new JScrollPane(this.deviceList);
                listScroller.setPreferredSize(new Dimension(200, 38));
                this.deviceList.setSelectionMode(1);
                this.deviceList.setLayoutOrientation(0);
                this.deviceList.setVisibleRowCount(-1);
                this.deviceList.setSelectedValue(this.model.getSelectedItem(), true);
                devicePanel.add(listScroller);
                this.deviceComponent = this.deviceList;
            }
        }

        public Component getComponent() {
            return this.deviceComponent;
        }

        public Object getSelectedItem() {
            return this.deviceComboBox != null ? this.deviceComboBox.getSelectedItem() : this.deviceList.getSelectedValue();
        }

        public void addListener(final Listener listener) {
            this.listener = listener;
            if (this.deviceComboBox != null) {
                this.deviceComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        listener.onAction();
                    }
                });
            } else {
                this.deviceList.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        model.setSelectedItem(deviceList.getSelectedValue());
                        if (e.getValueIsAdjusting()) {
                            return;
                        }
                        listener.onAction();
                    }
                });
            }
        }

        public static interface Listener {
            public void onAction();
        }
    }

    private static class ResolutionCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 0L;

        private ResolutionCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("Auto");
            } else if (value instanceof Dimension) {
                Dimension d = (Dimension)value;
                this.setText((int)d.getWidth() + "x" + (int)d.getHeight());
            }
            return this;
        }
    }

    private class AudioLevelListenerThread
    implements ActionListener,
    HierarchyListener {
        private final SimpleAudioLevelListener audioLevelListener = new SimpleAudioLevelListener(){

            public void audioLevelChanged(int level) {
                AudioLevelListenerThread.this.soundLevelIndicator.updateSoundLevel(level);
            }
        };
        private AudioSystem audioSystem;
        private JComboBox comboBox;
        private AudioMediaDeviceSession deviceSession;
        private AudioMediaDeviceSession deviceSessionToSet;
        private boolean deviceSessionToSetIsNull;
        private final ExecutorService setDeviceSessionExecutor = Executors.newSingleThreadExecutor();
        private final Runnable setDeviceSessionTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AudioMediaDeviceSession deviceSession = null;
                boolean deviceSessionIsNull = false;
                AudioLevelListenerThread audioLevelListenerThread = AudioLevelListenerThread.this;
                synchronized (audioLevelListenerThread) {
                    if (AudioLevelListenerThread.this.deviceSessionToSet != null || AudioLevelListenerThread.this.deviceSessionToSetIsNull) {
                        deviceSession = AudioLevelListenerThread.this.deviceSessionToSet;
                        deviceSessionIsNull = AudioLevelListenerThread.this.deviceSessionToSetIsNull;
                        AudioLevelListenerThread.this.deviceSessionToSet = null;
                        AudioLevelListenerThread.this.deviceSessionToSetIsNull = false;
                    }
                }
                if (deviceSession != null || deviceSessionIsNull) {
                    AudioLevelListenerThread.this.setDeviceSession(deviceSession);
                }
            }
        };
        private SoundLevelIndicator soundLevelIndicator;
        private final BufferTransferHandler transferHandler = new BufferTransferHandler(){

            public void transferData(PushBufferStream stream) {
                try {
                    stream.read(AudioLevelListenerThread.this.transferHandlerBuffer);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        private final Buffer transferHandlerBuffer = new Buffer();

        public AudioLevelListenerThread(AudioSystem audioSystem, JComboBox comboBox, SoundLevelIndicator soundLevelIndicator) {
            this.init(audioSystem, comboBox, soundLevelIndicator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ev) {
            CaptureDeviceInfo2 cdi;
            AudioLevelListenerThread audioLevelListenerThread = this;
            synchronized (audioLevelListenerThread) {
                this.deviceSessionToSet = null;
                this.deviceSessionToSetIsNull = true;
                this.setDeviceSessionExecutor.execute(this.setDeviceSessionTask);
            }
            if (this.comboBox == null) {
                cdi = this.soundLevelIndicator.isShowing() ? this.audioSystem.getSelectedDevice(AudioSystem.DataFlow.CAPTURE) : null;
            } else {
                Object selectedItem = this.soundLevelIndicator.isShowing() ? this.comboBox.getSelectedItem() : null;
                CaptureDeviceInfo captureDeviceInfo = cdi = selectedItem instanceof DeviceConfigurationComboBoxModel.CaptureDevice ? ((DeviceConfigurationComboBoxModel.CaptureDevice)selectedItem).info : null;
            }
            if (cdi != null) {
                for (MediaDevice md : mediaService.getDevices(MediaType.AUDIO, MediaUseCase.ANY)) {
                    AudioMediaDeviceImpl amd;
                    if (!(md instanceof AudioMediaDeviceImpl) || !cdi.equals((Object)(amd = (AudioMediaDeviceImpl)md).getCaptureDeviceInfo())) continue;
                    try {
                        MediaDeviceSession deviceSession = amd.createSession();
                        boolean deviceSessionIsSet = false;
                        try {
                            if (!(deviceSession instanceof AudioMediaDeviceSession)) break;
                            AudioLevelListenerThread audioLevelListenerThread2 = this;
                            synchronized (audioLevelListenerThread2) {
                                this.deviceSessionToSet = (AudioMediaDeviceSession)deviceSession;
                                this.deviceSessionToSetIsNull = this.deviceSessionToSet == null;
                                this.setDeviceSessionExecutor.execute(this.setDeviceSessionTask);
                            }
                            deviceSessionIsSet = true;
                            break;
                        }
                        finally {
                            if (!deviceSessionIsSet) {
                                deviceSession.close();
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (!(t instanceof ThreadDeath)) break;
                        throw (ThreadDeath)t;
                    }
                }
            }
        }

        @Override
        public void hierarchyChanged(HierarchyEvent ev) {
            if ((ev.getChangeFlags() & 4L) != 0L) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AudioLevelListenerThread.this.actionPerformed(null);
                    }
                });
            }
        }

        public void init(AudioSystem audioSystem, JComboBox comboBox, SoundLevelIndicator soundLevelIndicator) {
            this.audioSystem = audioSystem;
            if (this.comboBox != comboBox) {
                if (this.comboBox != null) {
                    this.comboBox.removeActionListener(this);
                }
                this.comboBox = comboBox;
                if (comboBox != null) {
                    comboBox.addActionListener(this);
                }
            }
            if (this.soundLevelIndicator != soundLevelIndicator) {
                if (this.soundLevelIndicator != null) {
                    this.soundLevelIndicator.removeHierarchyListener((HierarchyListener)this);
                }
                this.soundLevelIndicator = soundLevelIndicator;
                if (soundLevelIndicator != null) {
                    soundLevelIndicator.addHierarchyListener((HierarchyListener)this);
                }
            }
        }

        private void setDeviceSession(AudioMediaDeviceSession deviceSession) {
            block10: {
                if (this.deviceSession == deviceSession) {
                    return;
                }
                if (this.deviceSession != null) {
                    try {
                        this.deviceSession.close();
                    }
                    finally {
                        this.deviceSession.setLocalUserAudioLevelListener(null);
                        this.soundLevelIndicator.resetSoundLevel();
                    }
                }
                this.deviceSession = deviceSession;
                if (deviceSession != null) {
                    deviceSession.setContentDescriptor(new ContentDescriptor("raw"));
                    deviceSession.setLocalUserAudioLevelListener(this.audioLevelListener);
                    deviceSession.start(MediaDirection.SENDONLY);
                    try {
                        PushBufferStream[] streams;
                        DataSource dataSource = deviceSession.getOutputDataSource();
                        dataSource.connect();
                        for (PushBufferStream stream : streams = ((PushBufferDataSource)dataSource).getStreams()) {
                            stream.setTransferHandler(this.transferHandler);
                        }
                        dataSource.start();
                    }
                    catch (Throwable t) {
                        if (!(t instanceof ThreadDeath)) break block10;
                        throw (ThreadDeath)t;
                    }
                }
            }
        }
    }
}

