/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.neomedia.codec.video.h264;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.java.sip.communicator.impl.neomedia.NeomediaActivator;
import net.java.sip.communicator.plugin.desktoputil.FileUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommFrame;
import net.java.sip.communicator.plugin.desktoputil.StyledHTMLEditorPane;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.browserlauncher.BrowserLauncherService;
import net.java.sip.communicator.util.Logger;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;
import org.osgi.framework.ServiceReference;

public class OpenH264Retriever {
    private static final Logger logger = Logger.getLogger(OpenH264Retriever.class);
    private static final String OPENH264_CURRENT_VERSION = "1.7.0";
    private static final String OPENH264_CURRENT_VERSION_URL_MAC = "http://ciscobinary.openh264.org/libopenh264-1.7.0-osx64.4.dylib.bz2";
    private static final String OPENH264_CURRENT_VERSION_URL_WINDOWS_32 = "http://ciscobinary.openh264.org/openh264-1.7.0-win32.dll.bz2";
    private static final String OPENH264_CURRENT_VERSION_URL_WINDOWS_64 = "http://ciscobinary.openh264.org/openh264-1.7.0-win64.dll.bz2";
    private static final String OPENH264_INSTALL_DIR_MAC = "/Users/Shared/Library/Application Support/Jitsi/native";
    private static final String OPENH264_INSTALL_DIR_WINDOWS = "%ALLUSERSPROFILE%\\Jitsi\\native";
    private static final String ACTION_DOWNLOAD = "DOWNLOAD_OPENH264";
    private static final String ACTION_DISABLE = "DISABLE_OPENH264";
    private static final String OPENH264_INSTALLED_VERSION_PROP = OpenH264Retriever.class.getPackage().getName() + ".OPENH264_INSTALLED_VERSION";

    public static Container getConfigPanel() {
        JButton actionButton;
        ResourceManagementService resources = NeomediaActivator.getResources();
        TransparentPanel container = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
        JLabel needRestart = new JLabel(resources.getI18NString("impl.neomedia.configform.video.NEED_RESTART"));
        needRestart.setForeground(Color.RED);
        container.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        ConfigurationService cfg = NeomediaActivator.getConfigurationService();
        if (OpenH264Retriever.isOpenH264Installed(cfg)) {
            actionButton = new JButton(resources.getI18NString("impl.neomedia.configform.video.DISABLE_OPENH264"));
            actionButton.setActionCommand(ACTION_DISABLE);
        } else {
            actionButton = new JButton(resources.getI18NString("plugin.updatechecker.BUTTON_DOWNLOAD"));
            actionButton.setActionCommand(ACTION_DOWNLOAD);
        }
        container.add((Component)actionButton, "West");
        actionButton.addActionListener(new ButtonActionListener());
        StyledHTMLEditorPane licenseText = new StyledHTMLEditorPane();
        licenseText.appendToEnd("<html><div>OpenH264 Video Codec provided by Cisco Systems, Inc. <a href=\"http://www.openh264.org/BINARY_LICENSE.txt\">Show License</a></div></html>");
        licenseText.setOpaque(false);
        licenseText.setEditable(false);
        licenseText.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                ServiceReference serviceReference;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (serviceReference = NeomediaActivator.getBundleContext().getServiceReference(BrowserLauncherService.class)) != null) {
                    BrowserLauncherService browserLauncherService = (BrowserLauncherService)NeomediaActivator.getBundleContext().getService(serviceReference);
                    browserLauncherService.openURL(e.getDescription());
                }
            }
        });
        container.add((Component)licenseText, "North");
        container.add((Component)needRestart, "South");
        return container;
    }

    private static boolean isOpenH264Installed(ConfigurationService cfg) {
        return cfg.getString(OPENH264_INSTALLED_VERSION_PROP) != null;
    }

    public static void checkForUpdateAndDownload() {
        ConfigurationService cfg = NeomediaActivator.getConfigurationService();
        String installedVersion = cfg.getString(OPENH264_INSTALLED_VERSION_PROP);
        if (installedVersion == null || installedVersion.equals(OPENH264_CURRENT_VERSION)) {
            return;
        }
        SIPCommDialog dialog = new SIPCommDialog();
        ResourceManagementService r = NeomediaActivator.getResources();
        dialog.setTitle(r.getI18NString("impl.neomedia.configform.video.OPENH264_DIALOG_TITLE"));
        JEditorPane contentMessage = new JEditorPane();
        contentMessage.setContentType("text/html");
        contentMessage.setOpaque(false);
        contentMessage.setEditable(false);
        contentMessage.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        String dialogMsg = r.getI18NString(installedVersion != null ? "impl.neomedia.configform.video.OPENH264_UPDATE_AVAILABLE" : "impl.neomedia.configform.video.OPENH264_WILL_BE_DOWNLOADED");
        contentMessage.setText(dialogMsg);
        SIPCommFrame.MainContentPane contentPane = new SIPCommFrame.MainContentPane();
        contentMessage.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        contentPane.add((Component)contentMessage, "North");
        TransparentPanel buttonPanel = new TransparentPanel((LayoutManager)new FlowLayout(1, 10, 10));
        final JButton closeButton = new JButton(r.getI18NString("plugin.updatechecker.BUTTON_CLOSE"));
        closeButton.addActionListener(new ActionListener((JDialog)dialog){
            final /* synthetic */ JDialog val$dialog;
            {
                this.val$dialog = jDialog;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$dialog.dispose();
            }
        });
        JButton downloadButton = new JButton(r.getI18NString("plugin.updatechecker.BUTTON_DOWNLOAD"));
        downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    closeButton.doClick();
                }
                finally {
                    OpenH264Retriever.downloadInNewThread();
                }
            }
        });
        buttonPanel.add(downloadButton);
        buttonPanel.add(closeButton);
        contentPane.add((Component)buttonPanel, "South");
        dialog.setContentPane((Container)contentPane);
        dialog.setMinimumSize(new Dimension(500, 100));
        dialog.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setLocation(screenSize.width / 2 - dialog.getWidth() / 2, screenSize.height / 2 - dialog.getHeight() / 2);
        dialog.setVisible(true);
    }

    private static void downloadInNewThread() {
        new Thread(){

            @Override
            public void run() {
                try {
                    String url = OpenH264Retriever.chooseOpenH264URL();
                    if (url == null) {
                        logger.error((Object)"Unsupported OS!");
                        return;
                    }
                    File f = FileUtils.download((String)url, (String)"libopenh264", (String)".bz2");
                    if (f != null) {
                        OpenH264Retriever.install(f);
                    } else {
                        logger.error((Object)"Error downloading openh264 binary!");
                    }
                }
                catch (IOException e1) {
                    logger.error((Object)"Error downloading openh264 binary!", (Throwable)e1);
                }
            }
        }.start();
    }

    private static void install(File file) {
        File destFile = null;
        if (OSUtils.IS_WINDOWS) {
            destFile = new File(OPENH264_INSTALL_DIR_WINDOWS.replace("%ALLUSERSPROFILE%", System.getenv("ALLUSERSPROFILE")), "libopenh264.dll");
        } else if (OSUtils.IS_MAC) {
            destFile = new File(OPENH264_INSTALL_DIR_MAC, "libopenh264.4.dylib");
        }
        if (destFile == null) {
            logger.warn((Object)"Fail to install openh264");
            return;
        }
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        try {
            BZip2CompressorInputStream bzIn = new BZip2CompressorInputStream((InputStream)new FileInputStream(file));
            Files.copy((InputStream)bzIn, destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            NeomediaActivator.getConfigurationService().setProperty(OPENH264_INSTALLED_VERSION_PROP, (Object)OPENH264_CURRENT_VERSION);
        }
        catch (IOException e) {
            logger.error((Object)"Fail to install openh264 file", (Throwable)e);
        }
    }

    private static void removeFile() {
        if (OSUtils.IS_WINDOWS) {
            new File(OPENH264_INSTALL_DIR_WINDOWS.replace("%ALLUSERSPROFILE%", System.getenv("ALLUSERSPROFILE")), "openh264.dll").delete();
        } else if (OSUtils.IS_MAC) {
            new File(OPENH264_INSTALL_DIR_MAC, "libopenh264.4.dylib").delete();
        }
    }

    private static String chooseOpenH264URL() {
        if (OSUtils.IS_MAC) {
            return OPENH264_CURRENT_VERSION_URL_MAC;
        }
        if (OSUtils.IS_WINDOWS32) {
            return OPENH264_CURRENT_VERSION_URL_WINDOWS_32;
        }
        if (OSUtils.IS_WINDOWS64) {
            return OPENH264_CURRENT_VERSION_URL_WINDOWS_64;
        }
        return null;
    }

    private static class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final JButton button = (JButton)e.getSource();
            final ResourceManagementService resources = NeomediaActivator.getResources();
            if (e.getActionCommand().equals(OpenH264Retriever.ACTION_DOWNLOAD)) {
                OpenH264Retriever.downloadInNewThread();
                NeomediaActivator.getConfigurationService().addPropertyChangeListener(OPENH264_INSTALLED_VERSION_PROP, new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getNewValue() != null) {
                            button.setText(resources.getI18NString("impl.neomedia.configform.video.DISABLE_OPENH264"));
                            button.setActionCommand(OpenH264Retriever.ACTION_DISABLE);
                        }
                    }
                });
            } else if (e.getActionCommand().equals(OpenH264Retriever.ACTION_DISABLE)) {
                OpenH264Retriever.removeFile();
                NeomediaActivator.getConfigurationService().removeProperty(OPENH264_INSTALLED_VERSION_PROP);
                button.setText(resources.getI18NString("plugin.updatechecker.BUTTON_DOWNLOAD"));
                button.setActionCommand(OpenH264Retriever.ACTION_DOWNLOAD);
            }
        }
    }
}

