/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import net.java.sip.communicator.util.ServiceUtils;
import org.jetbrains.annotations.NotNull;
import org.jitsi.eventadmin.EventAdmin;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.recording.Recorder;
import org.jitsi.service.neomedia.recording.RecorderEventHandler;
import org.jitsi.service.neomedia.recording.Synchronizer;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.StringUtils;
import org.jitsi.utils.event.PropertyChangeNotifier;
import org.jitsi.utils.event.WeakReferencePropertyChangeListener;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.ConferenceSpeechActivity;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.EndpointMessageBuilder;
import org.jitsi.videobridge.EndpointRecorder;
import org.jitsi.videobridge.EventFactory;
import org.jitsi.videobridge.IceUdpTransportManager;
import org.jitsi.videobridge.RecorderEventHandlerImpl;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.SctpConnection;
import org.jitsi.videobridge.TransportManager;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.octo.OctoEndpoints;
import org.jitsi.videobridge.util.Expireable;
import org.jitsi.videobridge.util.ExpireableImpl;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Localpart;
import org.osgi.framework.BundleContext;

public class Conference
extends PropertyChangeNotifier
implements PropertyChangeListener,
Expireable {
    public static final String ENDPOINTS_PROPERTY_NAME = Conference.class.getName() + ".endpoints";
    private static final Logger classLogger = Logger.getLogger(Conference.class);
    private final List<Content> contents = new LinkedList<Content>();
    private EndpointRecorder endpointRecorder = null;
    private final List<AbstractEndpoint> endpoints = new LinkedList<AbstractEndpoint>();
    private OctoEndpoints octoEndpoints = null;
    private final EventAdmin eventAdmin;
    private boolean expired = false;
    private final Jid focus;
    private final String id;
    private final String gid;
    private final String loggingId;
    private Localpart name;
    private long lastActivityTime;
    private Jid lastKnownFocus;
    private final PropertyChangeListener propertyChangeListener = new WeakReferencePropertyChangeListener((PropertyChangeListener)this);
    private RecorderEventHandlerImpl recorderEventHandler = null;
    private boolean recording = false;
    private String recordingDirectory = null;
    private String recordingPath = null;
    private final ConferenceSpeechActivity speechActivity;
    private final Map<String, IceUdpTransportManager> transportManagers = new HashMap<String, IceUdpTransportManager>();
    private final Videobridge videobridge;
    private final Statistics statistics = new Statistics();
    private final Logger logger = Logger.getLogger((Logger)classLogger, null);
    private final boolean includeInStatistics;
    private final long creationTime = System.currentTimeMillis();
    private final ExpireableImpl expireableImpl;

    public static String getLoggingId(Conference conference) {
        return conference == null ? "conf_id=null" : conference.getLoggingId();
    }

    public Conference(Videobridge videobridge, String id, Jid focus, Localpart name, boolean enableLogging, String gid) {
        this.videobridge = Objects.requireNonNull(videobridge, "videobridge");
        this.id = Objects.requireNonNull(id, "id");
        this.gid = gid;
        this.loggingId = "conf_id=" + id;
        this.focus = focus;
        this.eventAdmin = enableLogging ? videobridge.getEventAdmin() : null;
        this.includeInStatistics = enableLogging;
        this.name = name;
        if (!enableLogging) {
            this.logger.setLevel(Level.WARNING);
        }
        this.lastKnownFocus = focus;
        this.speechActivity = new ConferenceSpeechActivity(this);
        this.speechActivity.addPropertyChangeListener(this.propertyChangeListener);
        this.expireableImpl = new ExpireableImpl(this.loggingId, this::expire);
        if (enableLogging) {
            this.eventAdmin.sendEvent(EventFactory.conferenceCreated(this));
            Videobridge.Statistics videobridgeStatistics = videobridge.getStatistics();
            videobridgeStatistics.totalConferencesCreated.incrementAndGet();
        }
        this.touch();
    }

    public void appendDiagnosticInformation(DiagnosticContext diagnosticContext) {
        Objects.requireNonNull(diagnosticContext);
        if (this.name != null) {
            diagnosticContext.put((Object)"conf_name", (Object)this.name.toString());
        }
        diagnosticContext.put((Object)"conf_creation_time_ms", (Object)this.creationTime);
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public boolean includeInStatistics() {
        return this.includeInStatistics;
    }

    public void sendMessage(String msg, List<AbstractEndpoint> endpoints, boolean sendToOcto) {
        for (AbstractEndpoint endpoint : endpoints) {
            try {
                endpoint.sendMessage(msg);
            }
            catch (IOException e) {
                this.logger.error((Object)("Failed to send message on data channel to: " + endpoint.getID() + ", msg: " + msg), (Throwable)e);
            }
        }
        OctoEndpoints octoEndpoints = this.octoEndpoints;
        if (sendToOcto && octoEndpoints != null) {
            octoEndpoints.sendMessage(msg);
        }
    }

    public void sendMessage(String msg, List<AbstractEndpoint> endpoints) {
        this.sendMessage(msg, endpoints, false);
    }

    public void broadcastMessage(String msg, boolean sendToOcto) {
        this.sendMessage(msg, this.getEndpoints(), sendToOcto);
    }

    public void broadcastMessage(String msg) {
        this.broadcastMessage(msg, false);
    }

    @Deprecated
    private boolean checkRecordingDirectory(String path) {
        if (StringUtils.isNullOrEmpty((String)path)) {
            return false;
        }
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdir();
            if (!dir.exists()) {
                return false;
            }
        }
        return dir.isDirectory() && dir.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeTransportManager(TransportManager transportManager) {
        Map<String, IceUdpTransportManager> map = this.transportManagers;
        synchronized (map) {
            block6: {
                this.transportManagers.values().removeIf(tm -> tm == transportManager);
                try {
                    transportManager.close();
                }
                catch (Throwable t) {
                    this.logger.warn((Object)("Failed to close an IceUdpTransportManager of conference " + this.getID() + "!"), t);
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(t instanceof ThreadDeath)) break block6;
                    throw (ThreadDeath)t;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTransportManagers() {
        Map<String, IceUdpTransportManager> map = this.transportManagers;
        synchronized (map) {
            LinkedList<IceUdpTransportManager> transportManagers = new LinkedList<IceUdpTransportManager>(this.transportManagers.values());
            transportManagers.forEach(this::closeTransportManager);
            this.transportManagers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void describeChannelBundles(ColibriConferenceIQ iq, Set<String> channelBundleIdsToDescribe) {
        Map<String, IceUdpTransportManager> map = this.transportManagers;
        synchronized (map) {
            for (Map.Entry<String, IceUdpTransportManager> entry : this.transportManagers.entrySet()) {
                String id = entry.getKey();
                if (channelBundleIdsToDescribe != null && !channelBundleIdsToDescribe.contains(id)) continue;
                ColibriConferenceIQ.ChannelBundle responseBundleIQ = new ColibriConferenceIQ.ChannelBundle(id);
                entry.getValue().describe(responseBundleIQ);
                iq.addChannelBundle(responseBundleIQ);
            }
        }
    }

    void describeEndpoints(ColibriConferenceIQ iq) {
        this.getEndpoints().forEach(en -> iq.addEndpoint(new ColibriConferenceIQ.Endpoint(en.getID(), en.getStatsId(), en.getDisplayName())));
    }

    public void describeDeep(ColibriConferenceIQ iq) {
        this.describeShallow(iq);
        if (this.isRecording()) {
            ColibriConferenceIQ.Recording recordingIQ = new ColibriConferenceIQ.Recording(ColibriConferenceIQ.Recording.State.ON.toString());
            recordingIQ.setDirectory(this.getRecordingDirectory());
            iq.setRecording(recordingIQ);
        }
        for (Content content : this.getContents()) {
            ColibriConferenceIQ.Content contentIQ = iq.getOrCreateContent(content.getName());
            for (Channel channel : content.getChannels()) {
                if (channel instanceof SctpConnection) {
                    ColibriConferenceIQ.SctpConnection sctpConnectionIQ = new ColibriConferenceIQ.SctpConnection();
                    channel.describe((ColibriConferenceIQ.ChannelCommon)sctpConnectionIQ);
                    contentIQ.addSctpConnection(sctpConnectionIQ);
                    continue;
                }
                ColibriConferenceIQ.Channel channelIQ = new ColibriConferenceIQ.Channel();
                channel.describe((ColibriConferenceIQ.ChannelCommon)channelIQ);
                contentIQ.addChannel(channelIQ);
            }
        }
    }

    public void describeShallow(ColibriConferenceIQ iq) {
        iq.setID(this.getID());
        iq.setName(this.getName());
    }

    private void dominantSpeakerChanged() {
        AbstractEndpoint dominantSpeaker = this.speechActivity.getDominantEndpoint();
        if (this.logger.isInfoEnabled()) {
            String id = dominantSpeaker == null ? "null" : dominantSpeaker.getID();
            this.logger.info(Logger.Category.STATISTICS, "ds_change," + this.getLoggingId() + " ds_id=" + id);
        }
        if (dominantSpeaker != null) {
            this.broadcastMessage(EndpointMessageBuilder.createDominantSpeakerEndpointChangeEvent(dominantSpeaker.getID()));
            if (this.isRecording() && this.recorderEventHandler != null) {
                this.recorderEventHandler.dominantSpeakerChanged(dominantSpeaker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        Conference conference = this;
        synchronized (conference) {
            if (this.expired) {
                return;
            }
            this.expired = true;
        }
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin != null) {
            eventAdmin.sendEvent(EventFactory.conferenceExpired(this));
        }
        this.setRecording(false);
        if (this.recorderEventHandler != null) {
            this.recorderEventHandler.close();
            this.recorderEventHandler = null;
        }
        Videobridge videobridge = this.getVideobridge();
        try {
            videobridge.expireConference(this);
        }
        finally {
            for (Content content : this.getContents()) {
                try {
                    content.expire();
                }
                catch (Throwable t) {
                    this.logger.warn((Object)("Failed to expire content " + content.getName() + " of conference " + this.getID() + "!"), t);
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    if (!(t instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)t;
                }
            }
            this.closeTransportManagers();
            if (this.includeInStatistics) {
                this.updateStatisticsOnExpire();
            }
        }
    }

    private void updateStatisticsOnExpire() {
        boolean hasPartiallyFailed;
        long durationSeconds = Math.round((double)(System.currentTimeMillis() - this.creationTime) / 1000.0);
        Videobridge.Statistics videobridgeStatistics = this.getVideobridge().getStatistics();
        videobridgeStatistics.totalConferencesCompleted.incrementAndGet();
        videobridgeStatistics.totalConferenceSeconds.addAndGet(durationSeconds);
        videobridgeStatistics.totalUdpTransportManagers.addAndGet(this.statistics.totalUdpTransportManagers.get());
        videobridgeStatistics.totalTcpTransportManagers.addAndGet(this.statistics.totalTcpTransportManagers.get());
        videobridgeStatistics.totalNoPayloadChannels.addAndGet(this.statistics.totalNoPayloadChannels.get());
        videobridgeStatistics.totalNoTransportChannels.addAndGet(this.statistics.totalNoTransportChannels.get());
        videobridgeStatistics.totalChannels.addAndGet(this.statistics.totalChannels.get());
        videobridgeStatistics.totalBytesReceived.addAndGet(this.statistics.totalBytesReceived.get());
        videobridgeStatistics.totalBytesSent.addAndGet(this.statistics.totalBytesSent.get());
        videobridgeStatistics.totalPacketsReceived.addAndGet(this.statistics.totalPacketsReceived.get());
        videobridgeStatistics.totalPacketsSent.addAndGet(this.statistics.totalPacketsSent.get());
        videobridgeStatistics.totalBytesReceivedOcto.addAndGet(this.statistics.totalBytesReceivedOcto.get());
        videobridgeStatistics.totalBytesSentOcto.addAndGet(this.statistics.totalBytesSentOcto.get());
        videobridgeStatistics.totalPacketsReceivedOcto.addAndGet(this.statistics.totalPacketsReceivedOcto.get());
        videobridgeStatistics.totalPacketsSentOcto.addAndGet(this.statistics.totalPacketsSentOcto.get());
        boolean hasFailed = this.statistics.totalNoPayloadChannels.get() >= this.statistics.totalChannels.get();
        boolean bl = hasPartiallyFailed = this.statistics.totalNoPayloadChannels.get() != 0;
        if (hasPartiallyFailed) {
            videobridgeStatistics.totalPartiallyFailedConferences.incrementAndGet();
        }
        if (hasFailed) {
            videobridgeStatistics.totalFailedConferences.incrementAndGet();
        }
        if (this.logger.isInfoEnabled()) {
            int[] metrics = this.videobridge.getConferenceChannelAndStreamCount();
            StringBuilder sb = new StringBuilder("expire_conf,");
            sb.append(this.getLoggingId()).append(" duration=").append(durationSeconds).append(",conf_count=").append(metrics[0]).append(",ch_count=").append(metrics[1]).append(",v_streams=").append(metrics[2]).append(",conf_completed=").append(videobridgeStatistics.totalConferencesCompleted).append(",no_payload_ch=").append(videobridgeStatistics.totalNoPayloadChannels).append(",no_transport_ch=").append(videobridgeStatistics.totalNoTransportChannels).append(",total_ch=").append(videobridgeStatistics.totalChannels).append(",has_failed=").append(hasFailed).append(",has_partially_failed=").append(hasPartiallyFailed);
            this.logger.info(Logger.Category.STATISTICS, sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireContent(Content content) {
        boolean expireContent;
        List<Content> list = this.contents;
        synchronized (list) {
            expireContent = this.contents.contains(content);
            if (expireContent) {
                this.contents.remove(content);
            }
        }
        if (expireContent) {
            content.expire();
        }
    }

    public Channel findChannelByReceiveSSRC(long receiveSSRC, MediaType mediaType) {
        for (Content content : this.getContents()) {
            Channel channel;
            if (!mediaType.equals((Object)content.getMediaType()) || (channel = content.findChannelByReceiveSSRC(receiveSSRC)) == null) continue;
            return channel;
        }
        return null;
    }

    AbstractEndpoint findEndpointByReceiveSSRC(long receiveSSRC, MediaType mediaType) {
        Channel channel = this.findChannelByReceiveSSRC(receiveSSRC, mediaType);
        return channel == null ? null : channel.getEndpoint(receiveSSRC);
    }

    public BundleContext getBundleContext() {
        return this.getVideobridge().getBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Content[] getContents() {
        List<Content> list = this.contents;
        synchronized (list) {
            return this.contents.toArray(new Content[this.contents.size()]);
        }
    }

    public AbstractEndpoint getEndpoint(String id) {
        return this.getEndpoint(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractEndpoint getEndpoint(String id, boolean create) {
        AbstractEndpoint endpoint;
        boolean changed;
        List<AbstractEndpoint> list = this.endpoints;
        synchronized (list) {
            changed = this.endpoints.removeIf(AbstractEndpoint::isExpired);
            endpoint = this.endpoints.stream().filter(e -> e.getID().equals(id)).findFirst().orElse(null);
            if (create && endpoint == null) {
                endpoint = new Endpoint(id, this);
                endpoint.addPropertyChangeListener(this.propertyChangeListener);
                this.endpoints.add(endpoint);
                changed = true;
                EventAdmin eventAdmin = this.getEventAdmin();
                if (eventAdmin != null) {
                    eventAdmin.sendEvent(EventFactory.endpointCreated(endpoint));
                }
            }
        }
        if (changed) {
            this.firePropertyChange(ENDPOINTS_PROPERTY_NAME, null, null);
        }
        return endpoint;
    }

    public int getEndpointCount() {
        return this.getEndpoints().size();
    }

    @Deprecated
    private EndpointRecorder getEndpointRecorder() {
        if (this.endpointRecorder == null) {
            try {
                this.endpointRecorder = new EndpointRecorder(this.getRecordingPath() + "/endpoints.json");
            }
            catch (IOException ioe) {
                this.logger.warn((Object)("Could not create EndpointRecorder. " + ioe));
            }
        }
        return this.endpointRecorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractEndpoint> getEndpoints() {
        ArrayList<AbstractEndpoint> copy;
        boolean changed;
        List<AbstractEndpoint> list = this.endpoints;
        synchronized (list) {
            changed = this.endpoints.removeIf(AbstractEndpoint::isExpired);
            copy = new ArrayList<AbstractEndpoint>(this.endpoints);
        }
        if (changed) {
            this.firePropertyChange(ENDPOINTS_PROPERTY_NAME, null, null);
        }
        return copy;
    }

    public final Jid getFocus() {
        return this.focus;
    }

    public final String getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastActivityTime() {
        Conference conference = this;
        synchronized (conference) {
            return this.lastActivityTime;
        }
    }

    public Jid getLastKnowFocus() {
        return this.lastKnownFocus;
    }

    MediaService getMediaService() {
        MediaService mediaService = (MediaService)ServiceUtils.getService((BundleContext)this.getBundleContext(), MediaService.class);
        if (mediaService == null) {
            mediaService = LibJitsi.getMediaService();
        }
        return mediaService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Content getOrCreateContent(String name) {
        Content content;
        List<Content> list = this.contents;
        synchronized (list) {
            content = this.contents.stream().filter(c -> c.getName().equals(name)).findFirst().orElse(null);
            if (content != null) {
                content.touch();
                return content;
            }
            content = new Content(this, name);
            if (this.isRecording()) {
                content.setRecording(true, this.getRecordingPath());
            }
            this.contents.add(content);
        }
        if (this.logger.isInfoEnabled()) {
            Videobridge videobridge = this.getVideobridge();
            this.logger.info(Logger.Category.STATISTICS, "create_content," + content.getLoggingId() + " " + videobridge.getConferenceCountString());
        }
        return content;
    }

    public AbstractEndpoint getOrCreateEndpoint(String id) {
        return this.getEndpoint(id, true);
    }

    @Deprecated
    RecorderEventHandler getRecorderEventHandler() {
        if (this.recorderEventHandler == null) {
            Exception t;
            try {
                this.recorderEventHandler = new RecorderEventHandlerImpl(this, this.getMediaService().createRecorderEventHandlerJson(this.getRecordingPath() + "/metadata.json"));
                t = null;
            }
            catch (IOException | IllegalArgumentException e) {
                t = e;
            }
            if (t != null) {
                this.logger.warn((Object)("Could not create RecorderEventHandler. " + t));
            }
        }
        return this.recorderEventHandler;
    }

    @Deprecated
    String getRecordingDirectory() {
        if (this.recordingDirectory == null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss.");
            this.recordingDirectory = dateFormat.format(new Date()) + this.getID() + (this.name != null ? "_" + this.name : "");
        }
        return this.recordingDirectory;
    }

    @Deprecated
    private String getRecordingPath() {
        String path;
        boolean recordingIsEnabled;
        ConfigurationService cfg;
        if (this.recordingPath == null && (cfg = this.getVideobridge().getConfigurationService()) != null && (recordingIsEnabled = cfg.getBoolean("org.jitsi.videobridge.ENABLE_MEDIA_RECORDING", false)) && (path = cfg.getString("org.jitsi.videobridge.MEDIA_RECORDING_PATH", null)) != null) {
            this.recordingPath = path + "/" + this.getRecordingDirectory();
        }
        return this.recordingPath;
    }

    public ConferenceSpeechActivity getSpeechActivity() {
        return this.speechActivity;
    }

    TransportManager getTransportManager(String channelBundleId) {
        return this.getTransportManager(channelBundleId, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IceUdpTransportManager getTransportManager(String channelBundleId, boolean create, boolean initiator) {
        IceUdpTransportManager transportManager;
        Map<String, IceUdpTransportManager> map = this.transportManagers;
        synchronized (map) {
            transportManager = this.transportManagers.get(channelBundleId);
            if (transportManager == null && create && !this.isExpired()) {
                try {
                    transportManager = new IceUdpTransportManager(this, initiator, 1, channelBundleId);
                }
                catch (IOException ioe) {
                    throw new UndeclaredThrowableException(ioe);
                }
                this.transportManagers.put(channelBundleId, transportManager);
                this.logger.info(Logger.Category.STATISTICS, "create_ice_tm," + this.getLoggingId() + " ufrag=" + transportManager.getLocalUfrag() + ",bundle=" + channelBundleId + ",initiator=" + initiator);
            }
        }
        return transportManager;
    }

    public final Videobridge getVideobridge() {
        return this.videobridge;
    }

    public boolean isExpired() {
        return this.expired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean isRecording() {
        boolean recording = this.recording;
        if (recording) {
            List<Content> list = this.contents;
            synchronized (list) {
                for (Content content : this.contents) {
                    MediaType mediaType = content.getMediaType();
                    if (!MediaType.VIDEO.equals((Object)mediaType) && !MediaType.AUDIO.equals((Object)mediaType) || content.isRecording()) continue;
                    recording = false;
                }
            }
        }
        if (this.recording != recording) {
            this.setRecording(recording);
        }
        return this.recording;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        Object source = ev.getSource();
        if (this.isExpired()) {
            if (source instanceof PropertyChangeNotifier) {
                ((PropertyChangeNotifier)source).removePropertyChangeListener(this.propertyChangeListener);
            }
        } else if (source == this.speechActivity) {
            this.speechActivityPropertyChange(ev);
        } else if (Endpoint.SELECTED_ENDPOINTS_PROPERTY_NAME.equals(ev.getPropertyName())) {
            Set oldSelectedEndpoints = (Set)ev.getOldValue();
            Set newSelectedEndpoints = (Set)ev.getNewValue();
            oldSelectedEndpoints.stream().filter(oldSelectedEp -> !newSelectedEndpoints.contains(oldSelectedEp)).map(this::getEndpoint).filter(Objects::nonNull).forEach(AbstractEndpoint::decrementSelectedCount);
            newSelectedEndpoints.stream().filter(newSelectedEp -> !oldSelectedEndpoints.contains(newSelectedEp)).map(this::getEndpoint).filter(Objects::nonNull).forEach(AbstractEndpoint::incrementSelectedCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endpointExpired(AbstractEndpoint endpoint) {
        boolean removed;
        List<AbstractEndpoint> list = this.endpoints;
        synchronized (list) {
            removed = this.endpoints.removeIf(AbstractEndpoint::isExpired);
        }
        if (removed) {
            this.firePropertyChange(ENDPOINTS_PROPERTY_NAME, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEndpoint(AbstractEndpoint endpoint) {
        List<AbstractEndpoint> list = this.endpoints;
        synchronized (list) {
            this.endpoints.add(endpoint);
        }
        this.firePropertyChange(ENDPOINTS_PROPERTY_NAME, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OctoEndpoints getOctoEndpoints() {
        List<AbstractEndpoint> list = this.endpoints;
        synchronized (list) {
            if (this.octoEndpoints == null) {
                this.octoEndpoints = new OctoEndpoints(this);
            }
            return this.octoEndpoints;
        }
    }

    void endpointMessageTransportConnected(@NotNull AbstractEndpoint endpoint) {
        AbstractEndpoint dominantSpeaker;
        if (!this.isExpired() && (dominantSpeaker = this.speechActivity.getDominantEndpoint()) != null) {
            try {
                endpoint.sendMessage(EndpointMessageBuilder.createDominantSpeakerEndpointChangeEvent(dominantSpeaker.getID()));
            }
            catch (IOException e) {
                this.logger.error((Object)("Failed to send dominant speaker update on data channel to " + endpoint.getID()), (Throwable)e);
            }
        }
    }

    public void setLastKnownFocus(Jid jid) {
        this.lastKnownFocus = jid;
    }

    @Deprecated
    boolean setRecording(boolean recording) {
        if (recording != this.recording) {
            if (recording) {
                RecorderEventHandler handler;
                String path;
                boolean failedToStart;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Starting recording for conference with id=" + this.getID()));
                }
                boolean bl = failedToStart = !this.checkRecordingDirectory(path = this.getRecordingPath());
                if (!failedToStart && (handler = this.getRecorderEventHandler()) == null) {
                    failedToStart = true;
                }
                if (!failedToStart) {
                    EndpointRecorder endpointRecorder = this.getEndpointRecorder();
                    if (endpointRecorder == null) {
                        failedToStart = true;
                    } else {
                        for (AbstractEndpoint endpoint : this.getEndpoints()) {
                            endpointRecorder.updateEndpoint(endpoint);
                        }
                    }
                }
                boolean first = true;
                Synchronizer synchronizer = null;
                for (Content content : this.contents) {
                    MediaType mediaType = content.getMediaType();
                    if (!MediaType.VIDEO.equals((Object)mediaType) && !MediaType.AUDIO.equals((Object)mediaType)) continue;
                    if (!failedToStart) {
                        boolean bl2 = failedToStart = !content.setRecording(true, path);
                    }
                    if (failedToStart) break;
                    if (first) {
                        first = false;
                        synchronizer = content.getRecorder().getSynchronizer();
                    } else {
                        Recorder recorder = content.getRecorder();
                        if (recorder != null) {
                            recorder.setSynchronizer(synchronizer);
                        }
                    }
                    content.feedKnownSsrcsToSynchronizer();
                }
                if (failedToStart) {
                    recording = false;
                    this.logger.warn((Object)("Failed to start media recording for conference " + this.getID()));
                }
            }
            if (!recording) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Stopping recording for conference with id=" + this.getID()));
                }
                for (Content content : this.contents) {
                    MediaType mediaType = content.getMediaType();
                    if (!MediaType.AUDIO.equals((Object)mediaType) && !MediaType.VIDEO.equals((Object)mediaType)) continue;
                    content.setRecording(false, null);
                }
                if (this.recorderEventHandler != null) {
                    this.recorderEventHandler.close();
                }
                this.recorderEventHandler = null;
                this.recordingPath = null;
                this.recordingDirectory = null;
                if (this.endpointRecorder != null) {
                    this.endpointRecorder.close();
                }
                this.endpointRecorder = null;
            }
            this.recording = recording;
        }
        return this.recording;
    }

    private void speechActivityEndpointsChanged() {
        for (Content content : this.getContents()) {
            if (!MediaType.VIDEO.equals((Object)content.getMediaType())) continue;
            List<AbstractEndpoint> endpoints = Collections.unmodifiableList(this.speechActivity.getEndpoints());
            content.getChannels().stream().filter(c -> c instanceof RtpChannel).forEach(c -> ((RtpChannel)c).speechActivityEndpointsChanged(endpoints));
        }
    }

    private void speechActivityPropertyChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        if (ConferenceSpeechActivity.DOMINANT_ENDPOINT_PROPERTY_NAME.equals(propertyName)) {
            this.dominantSpeakerChanged();
            this.speechActivityEndpointsChanged();
        } else if (ConferenceSpeechActivity.ENDPOINTS_PROPERTY_NAME.equals(propertyName)) {
            this.speechActivityEndpointsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch() {
        long now = System.currentTimeMillis();
        Conference conference = this;
        synchronized (conference) {
            if (this.getLastActivityTime() < now) {
                this.lastActivityTime = now;
            }
        }
    }

    void updateEndpoint(ColibriConferenceIQ.Endpoint colibriEndpoint) {
        AbstractEndpoint endpoint;
        String id = colibriEndpoint.getId();
        if (id != null && (endpoint = this.getEndpoint(id)) != null) {
            String oldDisplayName = endpoint.getDisplayName();
            String newDisplayName = colibriEndpoint.getDisplayName();
            if (oldDisplayName == null && newDisplayName != null || oldDisplayName != null && !oldDisplayName.equals(newDisplayName)) {
                EventAdmin eventAdmin;
                endpoint.setDisplayName(newDisplayName);
                if (this.isRecording() && this.endpointRecorder != null) {
                    this.endpointRecorder.updateEndpoint(endpoint);
                }
                if ((eventAdmin = this.getEventAdmin()) != null) {
                    eventAdmin.sendEvent(EventFactory.endpointDisplayNameChanged(endpoint));
                }
            }
            endpoint.setStatsId(colibriEndpoint.getStatsId());
        }
    }

    public Localpart getName() {
        return this.name;
    }

    public EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getLoggingId() {
        return this.loggingId;
    }

    public String getGid() {
        return this.gid;
    }

    @Override
    public boolean shouldExpire() {
        return this.getContents().length == 0 && this.getLastActivityTime() + 60000L < System.currentTimeMillis();
    }

    @Override
    public void safeExpire() {
        this.expireableImpl.safeExpire();
    }

    public class Statistics {
        AtomicInteger totalNoTransportChannels = new AtomicInteger(0);
        AtomicInteger totalNoPayloadChannels = new AtomicInteger(0);
        AtomicInteger totalChannels = new AtomicInteger(0);
        AtomicInteger totalUdpTransportManagers = new AtomicInteger();
        AtomicInteger totalTcpTransportManagers = new AtomicInteger();
        AtomicLong totalBytesReceived = new AtomicLong();
        AtomicLong totalBytesSent = new AtomicLong();
        AtomicLong totalPacketsReceived = new AtomicLong();
        AtomicLong totalPacketsSent = new AtomicLong();
        public AtomicLong totalBytesReceivedOcto = new AtomicLong();
        public AtomicLong totalBytesSentOcto = new AtomicLong();
        public AtomicLong totalPacketsReceivedOcto = new AtomicLong();
        public AtomicLong totalPacketsSentOcto = new AtomicLong();
    }
}

