/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jitsi.eventadmin.EventAdmin;
import org.jitsi.impl.neomedia.device.AudioSilenceMediaDevice;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.service.neomedia.MediaException;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.recording.Recorder;
import org.jitsi.service.neomedia.recording.Synchronizer;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.event.PropertyChangeNotifier;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.AudioChannel;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.EventFactory;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.SctpConnection;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.octo.OctoChannel;
import org.jitsi.videobridge.util.Expireable;
import org.jitsi.videobridge.util.ExpireableImpl;
import org.jitsi.xmpp.extensions.colibri.RTPLevelRelayType;
import org.osgi.framework.BundleContext;

public class Content
extends PropertyChangeNotifier
implements RTPTranslator.WriteFilter,
Expireable {
    private static final Logger classLogger = Logger.getLogger(Content.class);
    public static final String CHANNEL_MODIFIED_PROPERTY_NAME = "org.jitsi.videobridge.VideoChannel.mod";
    private final Map<String, Channel> channels = new HashMap<String, Channel>();
    private final Conference conference;
    private boolean expired = false;
    private long initialLocalSSRC = -1L;
    private long lastActivityTime;
    private final MediaType mediaType;
    private MediaDevice mixer;
    private final String name;
    private final String loggingId;
    private Recorder recorder = null;
    @Deprecated
    private boolean recording = false;
    @Deprecated
    private String recordingPath = null;
    private final Object rtpLevelRelaySyncRoot = new Object();
    private RTPTranslator rtpTranslator;
    private final Logger logger;
    private final ExpireableImpl expireableImpl;

    static String getLoggingId(Content content) {
        if (content == null) {
            return Conference.getLoggingId(null) + ",content=null";
        }
        return content.getLoggingId();
    }

    public Content(Conference conference, String name) {
        this.conference = Objects.requireNonNull(conference, "conference");
        this.name = Objects.requireNonNull(name, "name");
        this.loggingId = conference.getLoggingId() + ",content=" + name;
        this.logger = Logger.getLogger((Logger)classLogger, (Logger)conference.getLogger());
        this.mediaType = MediaType.parseString((String)this.name);
        this.expireableImpl = new ExpireableImpl(this.getLoggingId(), this::expire);
        EventAdmin eventAdmin = conference.getEventAdmin();
        if (eventAdmin != null) {
            eventAdmin.sendEvent(EventFactory.contentCreated(this));
        }
        this.touch();
    }

    public boolean accept(MediaStream source, RawPacket pkt, MediaStream destination, boolean data) {
        RtpChannel dst;
        boolean accept = true;
        if (destination != null && (dst = RtpChannel.getChannel(destination)) != null) {
            RtpChannel src = source == null ? null : RtpChannel.getChannel(source);
            accept = dst.rtpTranslatorWillWrite(data, pkt, src);
        }
        return accept;
    }

    public RtpChannel createRtpChannel(String channelBundleId, String transportNamespace, Boolean initiator, RTPLevelRelayType rtpLevelRelayType) throws Exception {
        return this.createRtpChannel(channelBundleId, transportNamespace, initiator, rtpLevelRelayType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtpChannel createRtpChannel(String channelBundleId, String transportNamespace, Boolean initiator, RTPLevelRelayType rtpLevelRelayType, boolean octo) throws IOException {
        RtpChannel channel;
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            String id = this.generateUniqueChannelID();
            if (octo) {
                channel = new OctoChannel(this, id);
            } else {
                switch (this.getMediaType()) {
                    case AUDIO: {
                        channel = new AudioChannel(this, id, channelBundleId, transportNamespace, initiator);
                        break;
                    }
                    case DATA: {
                        throw new IllegalStateException("mediaType");
                    }
                    case VIDEO: {
                        channel = new VideoChannel(this, id, channelBundleId, transportNamespace, initiator);
                        break;
                    }
                    default: {
                        channel = new RtpChannel(this, id, channelBundleId, transportNamespace, initiator);
                    }
                }
            }
            this.channels.put(id, channel);
        }
        channel.initialize(rtpLevelRelayType);
        if (this.logger.isInfoEnabled()) {
            String transport = "unknown";
            if (octo) {
                transport = "octo";
            } else if (transportNamespace == null) {
                transport = "default";
            } else if ("urn:xmpp:jingle:transports:ice-udp:1".equals(transportNamespace)) {
                transport = "ice";
            } else if ("urn:xmpp:jingle:transports:raw-udp:1".equals(transportNamespace)) {
                transport = "rawudp";
            }
            this.logger.info(Logger.Category.STATISTICS, "create_channel," + channel.getLoggingId() + " transport=" + transport + ",bundle=" + channelBundleId + ",initiator=" + initiator + ",media_type=" + this.getMediaType() + ",relay_type=" + rtpLevelRelayType);
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SctpConnection createSctpConnection(AbstractEndpoint endpoint, int sctpPort, String channelBundleId, Boolean initiator) throws IOException {
        SctpConnection sctpConnection;
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            String id = this.generateChannelID();
            sctpConnection = new SctpConnection(id, this, endpoint, sctpPort, channelBundleId, initiator);
            this.channels.put(sctpConnection.getID(), sctpConnection);
        }
        sctpConnection.initialize();
        return sctpConnection;
    }

    public boolean isExpired() {
        return this.expired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        Content content = this;
        synchronized (content) {
            if (this.expired) {
                return;
            }
            this.expired = true;
        }
        this.setRecording(false, null);
        Conference conference = this.getConference();
        EventAdmin eventAdmin = conference.getEventAdmin();
        if (eventAdmin != null) {
            eventAdmin.sendEvent(EventFactory.contentExpired(this));
        }
        try {
            conference.expireContent(this);
        }
        finally {
            for (Channel channel : this.getChannels()) {
                try {
                    channel.expire();
                }
                catch (Throwable t) {
                    this.logger.warn((Object)("Failed to expire channel " + channel.getLoggingId()), t);
                    if (!(t instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)t;
                }
            }
            Object object = this.rtpLevelRelaySyncRoot;
            synchronized (object) {
                if (this.rtpTranslator != null) {
                    this.rtpTranslator.dispose();
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("expire_content," + this.getLoggingId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireChannel(Channel channel) {
        boolean expireChannel;
        String id = channel.getID();
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            if (channel.equals(this.channels.get(id))) {
                this.channels.remove(id);
                expireChannel = true;
            } else {
                expireChannel = false;
            }
        }
        if (expireChannel) {
            channel.expire();
        }
    }

    @Deprecated
    void feedKnownSsrcsToSynchronizer() {
        Recorder recorder;
        if (this.isRecording() && (recorder = this.getRecorder()) != null) {
            Synchronizer synchronizer = recorder.getSynchronizer();
            for (Channel channel : this.getChannels()) {
                AbstractEndpoint endpoint;
                if (!(channel instanceof RtpChannel) || (endpoint = channel.getEndpoint()) == null) continue;
                for (int s : ((RtpChannel)channel).getReceiveSSRCs()) {
                    long ssrc = (long)s & 0xFFFFFFFFL;
                    synchronizer.setEndpoint(ssrc, endpoint.getID());
                }
            }
        }
    }

    Channel findChannelByReceiveSSRC(long receiveSSRC) {
        for (Channel channel : this.getChannels()) {
            if (!(channel instanceof RtpChannel)) continue;
            RtpChannel rtpChannel = (RtpChannel)channel;
            for (int channelReceiveSSRC : rtpChannel.getReceiveSSRCs()) {
                if (receiveSSRC != (0xFFFFFFFFL & (long)channelReceiveSSRC)) continue;
                return channel;
            }
        }
        return null;
    }

    private String generateChannelID() {
        return Long.toHexString(System.currentTimeMillis() + Videobridge.RANDOM.nextLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateUniqueChannelID() {
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            String id;
            while (this.channels.containsKey(id = this.generateChannelID())) {
            }
            return id;
        }
    }

    public BundleContext getBundleContext() {
        return this.getConference().getBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel(String id) {
        Channel channel;
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            channel = this.channels.get(id);
        }
        if (channel != null) {
            channel.touch();
        }
        return channel;
    }

    public int getChannelCount() {
        return (int)this.getChannels().stream().filter(c -> c != null && !c.isExpired()).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Channel> getChannels() {
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            return new LinkedList<Channel>(this.channels.values());
        }
    }

    public final Conference getConference() {
        return this.conference;
    }

    public long getInitialLocalSSRC() {
        return this.initialLocalSSRC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastActivityTime() {
        Content content = this;
        synchronized (content) {
            return this.lastActivityTime;
        }
    }

    MediaService getMediaService() {
        return this.getConference().getMediaService();
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public MediaDevice getMixer() {
        if (this.mixer == null) {
            AudioSilenceMediaDevice device;
            MediaType mediaType = this.getMediaType();
            AudioSilenceMediaDevice audioSilenceMediaDevice = device = MediaType.AUDIO.equals((Object)mediaType) ? new AudioSilenceMediaDevice() : null;
            if (device == null) {
                throw new UnsupportedOperationException("The mixer type of RTP-level relay is not supported for " + mediaType);
            }
            this.mixer = this.getMediaService().createMixer((MediaDevice)device);
        }
        return this.mixer;
    }

    public final String getName() {
        return this.name;
    }

    @Deprecated
    public Recorder getRecorder() {
        MediaType mediaType;
        if (this.recorder == null && (MediaType.AUDIO.equals((Object)(mediaType = this.getMediaType())) || MediaType.VIDEO.equals((Object)mediaType))) {
            this.recorder = this.getMediaService().createRecorder(this.getRTPTranslator());
            this.recorder.setEventHandler(this.getConference().getRecorderEventHandler());
        }
        return this.recorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTranslator getRTPTranslator() {
        Object object = this.rtpLevelRelaySyncRoot;
        synchronized (object) {
            if (this.rtpTranslator == null && !this.expired) {
                this.rtpTranslator = this.getMediaService().createRTPTranslator();
                if (this.rtpTranslator != null) {
                    new RTPTranslatorWriteFilter(this.rtpTranslator, this);
                    if (this.rtpTranslator instanceof RTPTranslatorImpl) {
                        RTPTranslatorImpl rtpTranslatorImpl = (RTPTranslatorImpl)this.rtpTranslator;
                        this.initialLocalSSRC = Videobridge.RANDOM.nextLong() & 0xFFFFFFFFL;
                        rtpTranslatorImpl.setLocalSSRC(this.initialLocalSSRC);
                    }
                }
            }
            return this.rtpTranslator;
        }
    }

    public SctpConnection getSctpConnection(String id) {
        return (SctpConnection)this.getChannel(id);
    }

    @Deprecated
    public boolean isRecording() {
        return this.recording;
    }

    @Deprecated
    public boolean setRecording(boolean recording, String path) {
        this.recordingPath = path;
        if (this.recording != recording) {
            Recorder recorder = this.getRecorder();
            if (recording) {
                recording = recorder != null ? this.startRecorder(recorder) : false;
            } else {
                if (recorder != null) {
                    recorder.stop();
                    this.recorder = null;
                }
                recording = false;
            }
        }
        this.recording = recording;
        return this.recording;
    }

    @Deprecated
    private boolean startRecorder(Recorder recorder) {
        boolean started = false;
        String format = MediaType.AUDIO.equals((Object)this.getMediaType()) ? "mp3" : null;
        try {
            recorder.start(format, this.recordingPath);
            started = true;
        }
        catch (IOException | MediaException ioe) {
            this.logger.error((Object)("Failed to start recorder: " + ioe));
            started = false;
        }
        return started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch() {
        long now = System.currentTimeMillis();
        Content content = this;
        synchronized (content) {
            if (this.getLastActivityTime() < now) {
                this.lastActivityTime = now;
            }
        }
    }

    public void fireChannelChanged(RtpChannel channel) {
        this.firePropertyChange(CHANNEL_MODIFIED_PROPERTY_NAME, channel, channel);
    }

    String getLoggingId() {
        return this.loggingId;
    }

    @Override
    public boolean shouldExpire() {
        return this.getChannels().isEmpty() && this.getLastActivityTime() + 60000L < System.currentTimeMillis();
    }

    @Override
    public void safeExpire() {
        this.expireableImpl.safeExpire();
    }

    private static class RTPTranslatorWriteFilter
    implements RTPTranslator.WriteFilter {
        private final WeakReference<RTPTranslator> rtpTranslator;
        private final WeakReference<RTPTranslator.WriteFilter> writeFilter;

        public RTPTranslatorWriteFilter(RTPTranslator rtpTranslator, RTPTranslator.WriteFilter writeFilter) {
            this.rtpTranslator = new WeakReference<RTPTranslator>(rtpTranslator);
            this.writeFilter = new WeakReference<RTPTranslator.WriteFilter>(writeFilter);
            rtpTranslator.addWriteFilter((RTPTranslator.WriteFilter)this);
        }

        public boolean accept(MediaStream source, RawPacket pkt, MediaStream destination, boolean data) {
            RTPTranslator.WriteFilter writeFilter = (RTPTranslator.WriteFilter)this.writeFilter.get();
            boolean accept = true;
            if (writeFilter == null) {
                RTPTranslator rtpTranslator = (RTPTranslator)this.rtpTranslator.get();
                if (rtpTranslator != null) {
                    rtpTranslator.removeWriteFilter((RTPTranslator.WriteFilter)this);
                }
            } else {
                accept = writeFilter.accept(source, pkt, destination, data);
            }
            return accept;
        }
    }
}

