/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.Dictionary;
import java.util.Hashtable;
import org.ice4j.ice.IceProcessingState;
import org.jitsi.eventadmin.AbstractEventFactory;
import org.jitsi.eventadmin.Event;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.IceUdpTransportManager;
import org.jitsi.videobridge.RtpChannel;

public class EventFactory
extends AbstractEventFactory {
    public static final String CHANNEL_CREATED_TOPIC = "org/jitsi/videobridge/Channel/CREATED";
    public static final String CHANNEL_EXPIRED_TOPIC = "org/jitsi/videobridge/Channel/EXPIRED";
    public static final String CONFERENCE_CREATED_TOPIC = "org/jitsi/videobridge/Conference/CREATED";
    public static final String CONFERENCE_EXPIRED_TOPIC = "org/jitsi/videobridge/Conference/EXPIRED";
    public static final String CONTENT_CREATED_TOPIC = "org/jitsi/videobridge/Content/CREATED";
    public static final String CONTENT_EXPIRED_TOPIC = "org/jitsi/videobridge/Content/EXPIRED";
    public static final String ENDPOINT_CREATED_TOPIC = "org/jitsi/videobridge/Endpoint/CREATED";
    public static final String MSG_TRANSPORT_READY_TOPIC = "org/jitsi/videobridge/Endpoint/MSG_TRANSPORT_READY_TOPIC";
    public static final String STREAM_STARTED_TOPIC = "org/jitsi/videobridge/Endpoint/STREAM_STARTED";
    public static final String TRANSPORT_CHANNEL_ADDED_TOPIC = "org/jitsi/videobridge/IceUdpTransportManager/TRANSPORT_CHANNEL_ADDED";
    public static final String TRANSPORT_CHANNEL_REMOVED_TOPIC = "org/jitsi/videobridge/IceUdpTransportManager/TRANSPORT_CHANNEL_REMOVED";
    public static final String TRANSPORT_CONNECTED_TOPIC = "org/jitsi/videobridge/IceUdpTransportManager/TRANSPORT_CHANNEL_CONNECTED";
    public static final String TRANSPORT_CREATED_TOPIC = "org/jitsi/videobridge/IceUdpTransportManager/CREATED";
    public static final String TRANSPORT_STATE_CHANGED_TOPIC = "org/jitsi/videobridge/IceUdpTransportManager/TRANSPORT_CHANGED";

    public static Event channelCreated(Channel channel) {
        return new Event(CHANNEL_CREATED_TOPIC, EventFactory.makeProperties((Object)channel));
    }

    public static Event channelExpired(Channel channel) {
        return new Event(CHANNEL_EXPIRED_TOPIC, EventFactory.makeProperties((Object)channel));
    }

    public static Event conferenceCreated(Conference conference) {
        return new Event(CONFERENCE_CREATED_TOPIC, EventFactory.makeProperties((Object)conference));
    }

    public static Event conferenceExpired(Conference conference) {
        return new Event(CONFERENCE_EXPIRED_TOPIC, EventFactory.makeProperties((Object)conference));
    }

    public static Event contentCreated(Content content) {
        return new Event(CONTENT_CREATED_TOPIC, EventFactory.makeProperties((Object)content));
    }

    public static Event contentExpired(Content content) {
        return new Event(CONTENT_EXPIRED_TOPIC, EventFactory.makeProperties((Object)content));
    }

    public static Event endpointCreated(AbstractEndpoint endpoint) {
        return new Event(ENDPOINT_CREATED_TOPIC, EventFactory.makeProperties((Object)((Object)endpoint)));
    }

    public static Event endpointDisplayNameChanged(AbstractEndpoint endpoint) {
        return new Event("org/jitsi/videobridge/Endpoint/NAME_CHANGED", EventFactory.makeProperties((Object)((Object)endpoint)));
    }

    public static Event endpointMessageTransportReady(AbstractEndpoint endpoint) {
        Hashtable<String, AbstractEndpoint> properties = new Hashtable<String, AbstractEndpoint>(1);
        ((Dictionary)properties).put("event.source", endpoint);
        return new Event(MSG_TRANSPORT_READY_TOPIC, properties);
    }

    public static Event streamStarted(RtpChannel rtpChannel) {
        return new Event(STREAM_STARTED_TOPIC, EventFactory.makeProperties((Object)rtpChannel));
    }

    public static Event transportChannelAdded(Channel channel) {
        return new Event(TRANSPORT_CHANNEL_ADDED_TOPIC, EventFactory.makeProperties((Object)channel));
    }

    public static Event transportChannelRemoved(Channel channel) {
        return new Event(TRANSPORT_CHANNEL_REMOVED_TOPIC, EventFactory.makeProperties((Object)channel));
    }

    public static Event transportConnected(IceUdpTransportManager transportManager) {
        return new Event(TRANSPORT_CONNECTED_TOPIC, EventFactory.makeProperties((Object)transportManager));
    }

    public static Event transportCreated(IceUdpTransportManager transportManager) {
        return new Event(TRANSPORT_CREATED_TOPIC, EventFactory.makeProperties((Object)transportManager));
    }

    public static Event transportStateChanged(IceUdpTransportManager transportManager, IceProcessingState oldState, IceProcessingState newState) {
        Hashtable<String, IceUdpTransportManager> properties = new Hashtable<String, IceUdpTransportManager>(3);
        ((Dictionary)properties).put("event.source", transportManager);
        ((Dictionary)properties).put("oldState", (IceUdpTransportManager)oldState);
        ((Dictionary)properties).put("newState", (IceUdpTransportManager)newState);
        return new Event(TRANSPORT_STATE_CHANGED_TOPIC, properties);
    }
}

