/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp8;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jitsi.impl.neomedia.codec.video.vp8.DePacketizer;
import org.jitsi.impl.neomedia.rtcp.RTCPIterator;
import org.jitsi.impl.neomedia.rtcp.RTCPSenderInfoUtils;
import org.jitsi.impl.neomedia.rtp.RawPacketCache;
import org.jitsi.service.neomedia.ByteArrayBuffer;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.RTCPUtils;
import org.jitsi.util.RTPUtils;
import org.jitsi.utils.ArrayUtils;
import org.jitsi.utils.LRUCache;
import org.jitsi.videobridge.cc.AdaptiveTrackProjectionContext;
import org.jitsi.videobridge.cc.RewriteException;
import org.jitsi.videobridge.cc.RtpState;
import org.jitsi.videobridge.cc.vp8.VP8Frame;
import org.jitsi.videobridge.cc.vp8.VP8FrameProjection;
import org.jitsi.videobridge.cc.vp8.VP8QualityFilter;

public class VP8AdaptiveTrackProjectionContext
implements AdaptiveTrackProjectionContext {
    private final Map<Long, VP8FrameProjection> vp8FrameProjectionMap = new ConcurrentHashMap<Long, VP8FrameProjection>();
    private final Map<Long, LRUCache<Long, Integer>> ssrcToFrameToMaxSequenceNumberMap = new HashMap<Long, LRUCache<Long, Integer>>();
    private final VP8QualityFilter vp8QualityFilter = new VP8QualityFilter();
    private VP8FrameProjection lastVP8FrameProjection;
    private final Object transmittedSyncRoot = new Object();
    private long transmittedBytes = 0L;
    private long transmittedPackets = 0L;
    private final MediaFormat format;

    public VP8AdaptiveTrackProjectionContext(@NotNull MediaFormat format, @NotNull RtpState rtpState) {
        this.format = format;
        int startingSequenceNumber = rtpState.maxSequenceNumber + 1 & 0xFFFF;
        long timestamp = rtpState.maxTimestamp + 3000L & 0xFFFFFFFFL;
        this.lastVP8FrameProjection = new VP8FrameProjection(rtpState.ssrc, startingSequenceNumber, timestamp);
    }

    private VP8FrameProjection lookupVP8FrameProjection(@NotNull RawPacket rtpPacket) {
        VP8Frame cachedVP8Frame;
        VP8FrameProjection lastVP8FrameProjectionCopy = this.lastVP8FrameProjection;
        VP8Frame lastVP8Frame = lastVP8FrameProjectionCopy.getVP8Frame();
        if (lastVP8Frame != null && lastVP8Frame.matchesFrame(rtpPacket)) {
            return lastVP8FrameProjectionCopy;
        }
        VP8FrameProjection cachedVP8FrameProjection = this.vp8FrameProjectionMap.get(rtpPacket.getTimestamp());
        if (cachedVP8FrameProjection != null && (cachedVP8Frame = cachedVP8FrameProjection.getVP8Frame()) != null && cachedVP8Frame.matchesFrame(rtpPacket)) {
            return cachedVP8FrameProjection;
        }
        return null;
    }

    private synchronized VP8FrameProjection createVP8FrameProjection(@NotNull RawPacket rtpPacket, int incomingIndex, int targetIndex) {
        int payloadOff;
        VP8Frame lastVP8Frame = this.lastVP8FrameProjection.getVP8Frame();
        if (lastVP8Frame != null && lastVP8Frame.matchesOlderFrame(rtpPacket)) {
            return null;
        }
        byte[] buf = rtpPacket.getBuffer();
        if (!DePacketizer.VP8PayloadDescriptor.isStartOfFrame((byte[])buf, (int)(payloadOff = rtpPacket.getPayloadOffset()))) {
            this.maybeUpdateMaxSequenceNumberOfFrame(rtpPacket.getSSRCAsLong(), rtpPacket.getTimestamp(), rtpPacket.getSequenceNumber());
            return null;
        }
        long nowMs = System.currentTimeMillis();
        if (!this.vp8QualityFilter.acceptFrame(rtpPacket, incomingIndex, targetIndex, nowMs)) {
            return null;
        }
        int maxSequenceNumberSeenBeforeFirstPacket = this.getMaxSequenceNumberOfFrame(rtpPacket.getSSRCAsLong(), rtpPacket.getTimestamp());
        VP8FrameProjection nextVP8FrameProjection = this.lastVP8FrameProjection.makeNext(rtpPacket, maxSequenceNumberSeenBeforeFirstPacket, nowMs);
        if (nextVP8FrameProjection == null) {
            return null;
        }
        this.vp8FrameProjectionMap.put(rtpPacket.getTimestamp(), nextVP8FrameProjection);
        this.lastVP8FrameProjection = nextVP8FrameProjection;
        this.vp8FrameProjectionMap.entrySet().removeIf(e -> ((VP8FrameProjection)e.getValue()).isFullyProjected(nowMs));
        return nextVP8FrameProjection;
    }

    private int getMaxSequenceNumberOfFrame(long ssrc, long timestamp) {
        Map frameToMaxSequenceNumberMap = (Map)this.ssrcToFrameToMaxSequenceNumberMap.get(ssrc);
        if (frameToMaxSequenceNumberMap == null) {
            return -1;
        }
        return frameToMaxSequenceNumberMap.getOrDefault(timestamp, -1);
    }

    private void maybeUpdateMaxSequenceNumberOfFrame(long ssrc, long timestamp, int sequenceNumber) {
        Map frameToMaxSequenceNumberMap = (Map)this.ssrcToFrameToMaxSequenceNumberMap.computeIfAbsent(ssrc, k -> new LRUCache(5));
        if (frameToMaxSequenceNumberMap.containsKey(timestamp)) {
            int previousMaxSequenceNumber = this.getMaxSequenceNumberOfFrame(ssrc, timestamp);
            if (previousMaxSequenceNumber != -1 && RTPUtils.isOlderSequenceNumberThan((int)previousMaxSequenceNumber, (int)sequenceNumber)) {
                frameToMaxSequenceNumberMap.put(timestamp, sequenceNumber);
            }
        } else {
            frameToMaxSequenceNumberMap.put(timestamp, sequenceNumber);
        }
    }

    @Override
    public boolean needsKeyframe() {
        if (this.vp8QualityFilter.needsKeyframe()) {
            return true;
        }
        VP8Frame lastVP8Frame = this.lastVP8FrameProjection.getVP8Frame();
        return lastVP8Frame == null || lastVP8Frame.needsKeyframe();
    }

    @Override
    public boolean accept(@NotNull RawPacket rtpPacket, int incomingIndex, int targetIndex) {
        VP8FrameProjection vp8FrameProjection = this.lookupVP8FrameProjection(rtpPacket);
        if (vp8FrameProjection == null) {
            vp8FrameProjection = this.createVP8FrameProjection(rtpPacket, incomingIndex, targetIndex);
        }
        return vp8FrameProjection != null && vp8FrameProjection.accept(rtpPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rewriteRtcp(@NotNull RawPacket rtcpPacket) {
        boolean removed = false;
        RTCPIterator it = new RTCPIterator((ByteArrayBuffer)rtcpPacket);
        while (it.hasNext()) {
            ByteArrayBuffer baf = it.next();
            switch (RTCPUtils.getPacketType((ByteArrayBuffer)baf)) {
                case 202: {
                    if (!removed) break;
                    it.remove();
                    break;
                }
                case 200: {
                    long delta;
                    long dstTs;
                    VP8FrameProjection lastVP8FrameProjectionCopy = this.lastVP8FrameProjection;
                    if (lastVP8FrameProjectionCopy.getVP8Frame() == null || RawPacket.getRTCPSSRC((ByteArrayBuffer)baf) != lastVP8FrameProjectionCopy.getSSRC()) {
                        removed = true;
                        it.remove();
                        break;
                    }
                    long srcTs = RTCPSenderInfoUtils.getTimestamp((ByteArrayBuffer)baf);
                    if (srcTs != (dstTs = RTPUtils.as32Bits((long)(srcTs + (delta = RTPUtils.rtpTimestampDiff((long)lastVP8FrameProjectionCopy.getTimestamp(), (long)lastVP8FrameProjectionCopy.getVP8Frame().getTimestamp())))))) {
                        RTCPSenderInfoUtils.setTimestamp((ByteArrayBuffer)baf, (int)((int)dstTs));
                    }
                    Object object = this.transmittedSyncRoot;
                    synchronized (object) {
                        RTCPSenderInfoUtils.setOctetCount((ByteArrayBuffer)baf, (int)((int)this.transmittedBytes));
                        RTCPSenderInfoUtils.setPacketCount((ByteArrayBuffer)baf, (int)((int)this.transmittedPackets));
                        break;
                    }
                }
            }
        }
        return rtcpPacket.getLength() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtpState getRtpState() {
        VP8AdaptiveTrackProjectionContext vP8AdaptiveTrackProjectionContext = this;
        synchronized (vP8AdaptiveTrackProjectionContext) {
            this.lastVP8FrameProjection.close();
        }
        return new RtpState(this.transmittedBytes, this.transmittedPackets, this.lastVP8FrameProjection.getSSRC(), this.lastVP8FrameProjection.maxSequenceNumber(), this.lastVP8FrameProjection.getTimestamp());
    }

    @Override
    public MediaFormat getFormat() {
        return this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawPacket[] rewriteRtp(@NotNull RawPacket rtpPacket, RawPacketCache incomingRawPacketCache) throws RewriteException {
        VP8FrameProjection vp8FrameProjection = this.lookupVP8FrameProjection(rtpPacket);
        if (vp8FrameProjection == null) {
            throw new RewriteException();
        }
        Object[] ret = vp8FrameProjection.rewriteRtp(rtpPacket, incomingRawPacketCache);
        Object object = this.transmittedSyncRoot;
        synchronized (object) {
            this.transmittedBytes += (long)rtpPacket.getLength();
            ++this.transmittedPackets;
            if (!ArrayUtils.isNullOrEmpty((Object[])ret)) {
                for (int i = 0; i < ret.length; ++i) {
                    this.transmittedBytes += (long)ret[i].getLength();
                    ++this.transmittedPackets;
                }
            }
        }
        return ret;
    }
}

