/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.locks.Lock;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.stats.MediaStreamStats2;
import org.jitsi.service.neomedia.stats.ReceiveTrackStats;
import org.jitsi.service.neomedia.stats.SendTrackStats;
import org.jitsi.utils.MediaType;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.octo.OctoRelayService;
import org.jitsi.videobridge.stats.OsStatistics;
import org.jitsi.videobridge.stats.Statistics;
import org.jitsi.videobridge.stats.StatsManagerBundleActivator;
import org.json.simple.JSONArray;
import org.osgi.framework.BundleContext;

public class VideobridgeStatistics
extends Statistics {
    public static final String AUDIOCHANNELS = "audiochannels";
    public static final String BITRATE_DOWNLOAD = "bit_rate_download";
    public static final String BITRATE_UPLOAD = "bit_rate_upload";
    public static final String PACKET_RATE_DOWNLOAD = "packet_rate_download";
    public static final String PACKET_RATE_UPLOAD = "packet_rate_upload";
    public static final String CONFERENCES = "conferences";
    public static final String CPU_USAGE = "cpu_usage";
    private static final DateFormat dateFormat;
    public static final String NUMBEROFPARTICIPANTS = "participants";
    public static final String NUMBEROFTHREADS = "threads";
    public static final String RTP_LOSS = "rtp_loss";
    public static final String LOSS_RATE_DOWNLOAD = "loss_rate_download";
    public static final String LOSS_RATE_UPLOAD = "loss_rate_upload";
    public static final String JITTER_AGGREGATE = "jitter_aggregate";
    public static final String RTT_AGGREGATE = "rtt_aggregate";
    public static final String LARGEST_CONFERENCE = "largest_conference";
    public static final String CONFERENCE_SIZES = "conference_sizes";
    private static final int CONFERENCE_SIZE_BUCKETS = 22;
    public static final String SHUTDOWN_IN_PROGRESS = "graceful_shutdown";
    public static final String TIMESTAMP = "current_timestamp";
    public static final String TOTAL_MEMORY = "total_memory";
    private static final String TOTAL_NO_PAYLOAD_CHANNELS = "total_no_payload_channels";
    private static final String TOTAL_NO_TRANSPORT_CHANNELS = "total_no_transport_channels";
    private static final String TOTAL_CHANNELS = "total_channels";
    private static final String TOTAL_FAILED_CONFERENCES = "total_failed_conferences";
    private static final String TOTAL_PARTIALLY_FAILED_CONFERENCES = "total_partially_failed_conferences";
    private static final String TOTAL_CONFERENCES_COMPLETED = "total_conferences_completed";
    private static final String TOTAL_CONFERENCES_CREATED = "total_conferences_created";
    private static final String TOTAL_CONFERENCE_SECONDS = "total_conference_seconds";
    private static final String TOTAL_LOSS_CONTROLLED_PARTICIPANT_SECONDS = "total_loss_controlled_participant_seconds";
    private static final String TOTAL_LOSS_LIMITED_PARTICIPANT_SECONDS = "total_loss_limited_participant_seconds";
    private static final String TOTAL_LOSS_DEGRADED_PARTICIPANT_SECONDS = "total_loss_degraded_participant_seconds";
    private static final String TOTAL_UDP_CONNECTIONS = "total_udp_connections";
    private static final String TOTAL_TCP_CONNECTIONS = "total_tcp_connections";
    private static final String TOTAL_DATA_CHANNEL_MESSAGES_RECEIVED = "total_data_channel_messages_received";
    private static final String TOTAL_DATA_CHANNEL_MESSAGES_SENT = "total_data_channel_messages_sent";
    private static final String TOTAL_COLIBRI_WEB_SOCKET_MESSAGES_RECEIVED = "total_colibri_web_socket_messages_received";
    private static final String TOTAL_COLIBRI_WEB_SOCKET_MESSAGES_SENT = "total_colibri_web_socket_messages_sent";
    private static final String TOTAL_BYTES_RECEIVED = "total_bytes_received";
    private static final String TOTAL_BYTES_SENT = "total_bytes_sent";
    private static final String TOTAL_PACKETS_RECEIVED = "total_packets_received";
    private static final String TOTAL_PACKETS_SENT = "total_packets_sent";
    private static final String TOTAL_BYTES_RECEIVED_OCTO = "total_bytes_received_octo";
    private static final String TOTAL_BYTES_SENT_OCTO = "total_bytes_sent_octo";
    private static final String TOTAL_PACKETS_RECEIVED_OCTO = "total_packets_received_octo";
    private static final String TOTAL_PACKETS_SENT_OCTO = "total_packets_sent_octo";
    public static final String USED_MEMORY = "used_memory";
    public static final String VIDEOCHANNELS = "videochannels";
    public static final String VIDEOSTREAMS = "videostreams";
    public static final String RELAY_ID = "relay_id";
    public static final String REGION = "region";
    public static String region;
    public static final String REGION_PNAME = "org.jitsi.videobridge.REGION";
    private boolean inGenerate = false;

    public static String currentTimeMillis() {
        return dateFormat.format(new Date());
    }

    public VideobridgeStatistics() {
        BundleContext bundleContext = StatsManagerBundleActivator.getBundleContext();
        ConfigurationService cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        if (cfg != null) {
            region = cfg.getString(REGION_PNAME, region);
        }
        this.unlockedSetStat(AUDIOCHANNELS, 0);
        this.unlockedSetStat(BITRATE_DOWNLOAD, 0.0);
        this.unlockedSetStat(BITRATE_UPLOAD, 0.0);
        this.unlockedSetStat(CONFERENCES, 0);
        this.unlockedSetStat(CPU_USAGE, 0.0);
        this.unlockedSetStat(NUMBEROFPARTICIPANTS, 0);
        this.unlockedSetStat(NUMBEROFTHREADS, 0);
        this.unlockedSetStat(RTP_LOSS, 0.0);
        this.unlockedSetStat(TOTAL_MEMORY, 0);
        this.unlockedSetStat(USED_MEMORY, 0);
        this.unlockedSetStat(VIDEOCHANNELS, 0);
        this.unlockedSetStat(VIDEOSTREAMS, 0);
        this.unlockedSetStat(LOSS_RATE_DOWNLOAD, 0.0);
        this.unlockedSetStat(LOSS_RATE_UPLOAD, 0.0);
        this.unlockedSetStat(JITTER_AGGREGATE, 0.0);
        this.unlockedSetStat(RTT_AGGREGATE, 0.0);
        this.unlockedSetStat(LARGEST_CONFERENCE, 0);
        this.unlockedSetStat(CONFERENCE_SIZES, "[]");
        this.unlockedSetStat(TIMESTAMP, VideobridgeStatistics.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate() {
        boolean inGenerate;
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            if (this.inGenerate) {
                inGenerate = true;
            } else {
                inGenerate = false;
                this.inGenerate = true;
            }
        }
        finally {
            lock.unlock();
        }
        if (!inGenerate) {
            try {
                this.generate0();
            }
            finally {
                lock.lock();
                try {
                    this.inGenerate = false;
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generate0() {
        int audioChannels = 0;
        int videoChannels = 0;
        int conferences = 0;
        int endpoints = 0;
        int videoStreams = 0;
        double fractionLostSum = 0.0;
        int fractionLostCount = 0;
        long packetsReceived = 0L;
        long packetsReceivedLost = 0L;
        long bitrateDownloadBps = 0L;
        long bitrateUploadBps = 0L;
        double jitterSumMs = 0.0;
        long rttSumMs = 0L;
        int jitterCount = 0;
        int rttCount = 0;
        int largestConferenceSize = 0;
        int[] conferenceSizes = new int[22];
        int packetRateUpload = 0;
        int packetRateDownload = 0;
        boolean shutdownInProgress = false;
        int totalConferencesCreated = 0;
        int totalConferencesCompleted = 0;
        int totalFailedConferences = 0;
        int totalPartiallyFailedConferences = 0;
        int totalNoTransportChannels = 0;
        int totalNoPayloadChannels = 0;
        int totalChannels = 0;
        long totalConferenceSeconds = 0L;
        long totalLossControlledParticipantSeconds = 0L;
        long totalLossLimitedParticipantSeconds = 0L;
        long totalLossDegradedParticipantSeconds = 0L;
        int totalUdpConnections = 0;
        int totalTcpConnections = 0;
        long totalDataChannelMessagesReceived = 0L;
        long totalDataChannelMessagesSent = 0L;
        long totalColibriWebSocketMessagesReceived = 0L;
        long totalColibriWebSocketMessagesSent = 0L;
        long totalBytesReceived = 0L;
        long totalBytesSent = 0L;
        long totalPacketsReceived = 0L;
        long totalPacketsSent = 0L;
        long totalBytesReceivedOcto = 0L;
        long totalBytesSentOcto = 0L;
        long totalPacketsReceivedOcto = 0L;
        long totalPacketsSentOcto = 0L;
        BundleContext bundleContext = StatsManagerBundleActivator.getBundleContext();
        OctoRelayService relayService = (OctoRelayService)ServiceUtils.getService((BundleContext)bundleContext, OctoRelayService.class);
        String relayId = relayService == null ? null : relayService.getRelayId();
        for (Videobridge videobridge : Videobridge.getVideobridges(bundleContext)) {
            Videobridge.Statistics jvbStats = videobridge.getStatistics();
            totalConferencesCreated += jvbStats.totalConferencesCreated.get();
            totalConferencesCompleted += jvbStats.totalConferencesCompleted.get();
            totalConferenceSeconds += jvbStats.totalConferenceSeconds.get();
            totalLossControlledParticipantSeconds += jvbStats.totalLossControlledParticipantMs.get() / 1000L;
            totalLossLimitedParticipantSeconds += jvbStats.totalLossLimitedParticipantMs.get() / 1000L;
            totalLossDegradedParticipantSeconds += jvbStats.totalLossDegradedParticipantMs.get() / 1000L;
            totalFailedConferences += jvbStats.totalFailedConferences.get();
            totalPartiallyFailedConferences += jvbStats.totalPartiallyFailedConferences.get();
            totalNoTransportChannels += jvbStats.totalNoTransportChannels.get();
            totalNoPayloadChannels += jvbStats.totalNoPayloadChannels.get();
            totalChannels += jvbStats.totalChannels.get();
            totalUdpConnections += jvbStats.totalUdpTransportManagers.get();
            totalTcpConnections += jvbStats.totalTcpTransportManagers.get();
            totalDataChannelMessagesReceived += jvbStats.totalDataChannelMessagesReceived.get();
            totalDataChannelMessagesSent += jvbStats.totalDataChannelMessagesSent.get();
            totalColibriWebSocketMessagesReceived += jvbStats.totalColibriWebSocketMessagesReceived.get();
            totalColibriWebSocketMessagesSent += jvbStats.totalColibriWebSocketMessagesSent.get();
            totalBytesReceived += jvbStats.totalBytesReceived.get();
            totalBytesSent += jvbStats.totalBytesSent.get();
            totalPacketsReceived += jvbStats.totalPacketsReceived.get();
            totalPacketsSent += jvbStats.totalPacketsSent.get();
            totalBytesReceivedOcto += jvbStats.totalBytesReceivedOcto.get();
            totalBytesSentOcto += jvbStats.totalBytesSentOcto.get();
            totalPacketsReceivedOcto += jvbStats.totalPacketsReceivedOcto.get();
            totalPacketsSentOcto += jvbStats.totalPacketsSentOcto.get();
            for (Conference conference : videobridge.getConferences()) {
                int idx;
                if (!conference.includeInStatistics()) continue;
                ++conferences;
                int conferenceEndpoints = conference.getEndpointCount();
                endpoints += conference.getEndpointCount();
                if (conferenceEndpoints > largestConferenceSize) {
                    largestConferenceSize = conferenceEndpoints;
                }
                int n = idx = conferenceEndpoints < conferenceSizes.length ? conferenceEndpoints : conferenceSizes.length - 1;
                conferenceSizes[n] = conferenceSizes[n] + 1;
                for (Content content : conference.getContents()) {
                    MediaType mediaType = content.getMediaType();
                    int contentChannelCount = content.getChannelCount();
                    if (MediaType.AUDIO.equals((Object)mediaType)) {
                        audioChannels += contentChannelCount;
                    } else if (MediaType.VIDEO.equals((Object)mediaType)) {
                        videoChannels += content.getChannelCount();
                    }
                    for (Channel channel : content.getChannels()) {
                        long rtt;
                        RtpChannel rtpChannel;
                        MediaStream stream;
                        if (!(channel instanceof RtpChannel) || (stream = (rtpChannel = (RtpChannel)channel).getStream()) == null) continue;
                        MediaStreamStats2 stats = stream.getMediaStreamStats();
                        ReceiveTrackStats receiveStats = stats.getReceiveStats();
                        SendTrackStats sendStats = stats.getSendStats();
                        packetsReceived += receiveStats.getCurrentPackets();
                        packetsReceivedLost += receiveStats.getCurrentPacketsLost();
                        ++fractionLostCount;
                        fractionLostSum += sendStats.getLossRate();
                        packetRateDownload = (int)((long)packetRateDownload + receiveStats.getPacketRate());
                        packetRateUpload = (int)((long)packetRateUpload + sendStats.getPacketRate());
                        bitrateDownloadBps += receiveStats.getBitrate();
                        bitrateUploadBps += sendStats.getBitrate();
                        double jitter = sendStats.getJitter();
                        if (jitter != Double.MIN_VALUE) {
                            jitterSumMs += Math.abs(jitter);
                            ++jitterCount;
                        }
                        if ((jitter = receiveStats.getJitter()) != Double.MIN_VALUE) {
                            jitterSumMs += Math.abs(jitter);
                            ++jitterCount;
                        }
                        if ((rtt = sendStats.getRtt()) > 0L) {
                            rttSumMs += rtt;
                            ++rttCount;
                        }
                        if (!(channel instanceof VideoChannel)) continue;
                        VideoChannel videoChannel = (VideoChannel)channel;
                        int channelStreams = 1;
                        int lastN = videoChannel.getLastN();
                        videoStreams += (channelStreams += lastN == -1 ? contentChannelCount - 1 : Math.min(lastN, contentChannelCount - 1));
                    }
                }
            }
            if (!videobridge.isShutdownInProgress()) continue;
            shutdownInProgress = true;
        }
        double lossRateDownload = packetsReceived + packetsReceivedLost > 0L ? (double)packetsReceivedLost / (double)(packetsReceived + packetsReceivedLost) : 0.0;
        double lossRateUpload = fractionLostCount > 0 ? fractionLostSum / (double)fractionLostCount : 0.0;
        double jitterAggregate = jitterCount > 0 ? jitterSumMs / (double)jitterCount : 0.0;
        double rttAggregate = rttCount > 0 ? (double)rttSumMs / (double)rttCount : 0.0;
        JSONArray conferenceSizesJson = new JSONArray();
        for (int size : conferenceSizes) {
            conferenceSizesJson.add((Object)size);
        }
        int n = ManagementFactory.getThreadMXBean().getThreadCount();
        OsStatistics osStatistics = OsStatistics.getOsStatistics();
        double cpuUsage = osStatistics.getCPUUsage();
        int totalMemory = osStatistics.getTotalMemory();
        int usedMemory = osStatistics.getUsedMemory();
        String timestamp = VideobridgeStatistics.currentTimeMillis();
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            this.unlockedSetStat(BITRATE_DOWNLOAD, bitrateDownloadBps / 1000L);
            this.unlockedSetStat(BITRATE_UPLOAD, bitrateUploadBps / 1000L);
            this.unlockedSetStat(PACKET_RATE_DOWNLOAD, packetRateDownload);
            this.unlockedSetStat(PACKET_RATE_UPLOAD, packetRateUpload);
            this.unlockedSetStat(RTP_LOSS, lossRateDownload + lossRateUpload);
            this.unlockedSetStat(LOSS_RATE_DOWNLOAD, lossRateDownload);
            this.unlockedSetStat(LOSS_RATE_UPLOAD, lossRateUpload);
            this.unlockedSetStat(JITTER_AGGREGATE, jitterAggregate);
            this.unlockedSetStat(RTT_AGGREGATE, rttAggregate);
            this.unlockedSetStat(AUDIOCHANNELS, audioChannels);
            this.unlockedSetStat(TOTAL_FAILED_CONFERENCES, totalFailedConferences);
            this.unlockedSetStat(TOTAL_PARTIALLY_FAILED_CONFERENCES, totalPartiallyFailedConferences);
            this.unlockedSetStat(TOTAL_NO_PAYLOAD_CHANNELS, totalNoPayloadChannels);
            this.unlockedSetStat(TOTAL_NO_TRANSPORT_CHANNELS, totalNoTransportChannels);
            this.unlockedSetStat(TOTAL_CONFERENCES_CREATED, totalConferencesCreated);
            this.unlockedSetStat(TOTAL_CONFERENCES_COMPLETED, totalConferencesCompleted);
            this.unlockedSetStat(TOTAL_UDP_CONNECTIONS, totalUdpConnections);
            this.unlockedSetStat(TOTAL_TCP_CONNECTIONS, totalTcpConnections);
            this.unlockedSetStat(TOTAL_CONFERENCE_SECONDS, totalConferenceSeconds);
            this.unlockedSetStat(TOTAL_LOSS_CONTROLLED_PARTICIPANT_SECONDS, totalLossControlledParticipantSeconds);
            this.unlockedSetStat(TOTAL_LOSS_LIMITED_PARTICIPANT_SECONDS, totalLossLimitedParticipantSeconds);
            this.unlockedSetStat(TOTAL_LOSS_DEGRADED_PARTICIPANT_SECONDS, totalLossDegradedParticipantSeconds);
            this.unlockedSetStat(TOTAL_CHANNELS, totalChannels);
            this.unlockedSetStat(CONFERENCES, conferences);
            this.unlockedSetStat(NUMBEROFPARTICIPANTS, endpoints);
            this.unlockedSetStat(VIDEOCHANNELS, videoChannels);
            this.unlockedSetStat(VIDEOSTREAMS, videoStreams);
            this.unlockedSetStat(LARGEST_CONFERENCE, largestConferenceSize);
            this.unlockedSetStat(CONFERENCE_SIZES, conferenceSizesJson);
            this.unlockedSetStat(NUMBEROFTHREADS, n);
            this.unlockedSetStat(CPU_USAGE, Math.max(cpuUsage, 0.0));
            this.unlockedSetStat(TOTAL_MEMORY, Math.max(totalMemory, 0));
            this.unlockedSetStat(USED_MEMORY, Math.max(usedMemory, 0));
            this.unlockedSetStat(SHUTDOWN_IN_PROGRESS, shutdownInProgress);
            this.unlockedSetStat(TOTAL_DATA_CHANNEL_MESSAGES_RECEIVED, totalDataChannelMessagesReceived);
            this.unlockedSetStat(TOTAL_DATA_CHANNEL_MESSAGES_SENT, totalDataChannelMessagesSent);
            this.unlockedSetStat(TOTAL_COLIBRI_WEB_SOCKET_MESSAGES_RECEIVED, totalColibriWebSocketMessagesReceived);
            this.unlockedSetStat(TOTAL_COLIBRI_WEB_SOCKET_MESSAGES_SENT, totalColibriWebSocketMessagesSent);
            this.unlockedSetStat(TOTAL_BYTES_RECEIVED, totalBytesReceived);
            this.unlockedSetStat(TOTAL_BYTES_SENT, totalBytesSent);
            this.unlockedSetStat(TOTAL_PACKETS_RECEIVED, totalPacketsReceived);
            this.unlockedSetStat(TOTAL_PACKETS_SENT, totalPacketsSent);
            this.unlockedSetStat(TOTAL_BYTES_RECEIVED_OCTO, totalBytesReceivedOcto);
            this.unlockedSetStat(TOTAL_BYTES_SENT_OCTO, totalBytesSentOcto);
            this.unlockedSetStat(TOTAL_PACKETS_RECEIVED_OCTO, totalPacketsReceivedOcto);
            this.unlockedSetStat(TOTAL_PACKETS_SENT_OCTO, totalPacketsSentOcto);
            this.unlockedSetStat(TIMESTAMP, timestamp);
            if (relayId != null) {
                this.unlockedSetStat(RELAY_ID, relayId);
            }
            if (region != null) {
                this.unlockedSetStat(REGION, region);
            }
        }
        finally {
            lock.unlock();
        }
    }

    static {
        region = null;
        dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

