/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.xmpp;

import org.jitsi.osgi.ServiceUtils2;
import org.jitsi.service.version.VersionService;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.colibri.ShutdownIQ;
import org.jitsi.xmpp.extensions.health.HealthCheckIQ;
import org.jitsi.xmpp.util.IQUtils;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.iqversion.packet.Version;
import org.osgi.framework.BundleContext;

class XmppCommon {
    private static final Logger logger = Logger.getLogger(XmppCommon.class);
    static final String[] FEATURES = new String[]{"http://jitsi.org/protocol/colibri", "http://jitsi.org/protocol/healthcheck", "urn:xmpp:jingle:apps:dtls:0", "urn:xmpp:jingle:transports:ice-udp:1", "urn:xmpp:jingle:transports:raw-udp:1", "jabber:iq:version"};
    private BundleContext bundleContext;

    XmppCommon() {
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    void start(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    void stop(BundleContext bundleContext) {
        this.bundleContext = null;
    }

    Videobridge getVideobridge() {
        BundleContext bundleContext = this.getBundleContext();
        return bundleContext != null ? (Videobridge)ServiceUtils2.getService((BundleContext)bundleContext, Videobridge.class) : null;
    }

    private VersionService getVersionService() {
        BundleContext bundleContext = this.getBundleContext();
        return bundleContext != null ? (VersionService)ServiceUtils2.getService((BundleContext)bundleContext, VersionService.class) : null;
    }

    IQ handleIQ(IQ requestIQ) {
        if (logger.isDebugEnabled() && requestIQ != null) {
            logger.debug((Object)("RECV: " + requestIQ.toXML()));
        }
        IQ replyIQ = this.handleIQInternal(requestIQ);
        if (logger.isDebugEnabled() && replyIQ != null) {
            logger.debug((Object)("SENT: " + replyIQ.toXML()));
        }
        return replyIQ;
    }

    private IQ handleIQInternal(IQ iq) {
        IQ responseIQ = null;
        if (iq != null) {
            IQ.Type type = iq.getType();
            if (IQ.Type.get.equals((Object)type) || IQ.Type.set.equals((Object)type)) {
                responseIQ = this.handleIQRequest(iq);
                if (responseIQ != null) {
                    responseIQ.setFrom(iq.getTo());
                    responseIQ.setStanzaId(iq.getStanzaId());
                    responseIQ.setTo(iq.getFrom());
                }
            } else if (IQ.Type.error.equals((Object)type) || IQ.Type.result.equals((Object)type)) {
                this.handleIQResponse(iq);
            }
        }
        return responseIQ;
    }

    private IQ handleIQRequest(IQ request) {
        if (request instanceof Version) {
            return this.handleVersionIQ((Version)request);
        }
        Videobridge videobridge = this.getVideobridge();
        if (videobridge == null) {
            return IQUtils.createError((IQ)request, (XMPPError.Condition)XMPPError.Condition.internal_server_error, (String)"No Videobridge service is running");
        }
        Object response = request instanceof ColibriConferenceIQ ? videobridge.handleColibriConferenceIQ((ColibriConferenceIQ)request) : (request instanceof HealthCheckIQ ? videobridge.handleHealthCheckIQ((HealthCheckIQ)request) : (request instanceof ShutdownIQ ? videobridge.handleShutdownIQ((ShutdownIQ)request) : null));
        return response;
    }

    private IQ handleVersionIQ(Version versionRequest) {
        VersionService versionService = this.getVersionService();
        if (versionService == null) {
            return IQ.createErrorResponse((IQ)versionRequest, (XMPPError.Builder)XMPPError.getBuilder((XMPPError.Condition)XMPPError.Condition.service_unavailable));
        }
        org.jitsi.service.version.Version currentVersion = versionService.getCurrentVersion();
        if (currentVersion == null) {
            return IQ.createErrorResponse((IQ)versionRequest, (XMPPError.Builder)XMPPError.getBuilder((XMPPError.Condition)XMPPError.Condition.internal_server_error));
        }
        Version versionResult = new Version(currentVersion.getApplicationName(), currentVersion.toString(), System.getProperty("os.name"));
        versionResult.setType(IQ.Type.result);
        return versionResult;
    }

    private void handleIQResponse(IQ response) {
        Videobridge videobridge = this.getVideobridge();
        if (videobridge != null) {
            videobridge.handleIQResponse(response);
        }
    }
}

