/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.queue;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jitsi.utils.concurrent.CustomizableThreadFactory;
import org.jitsi.utils.logging.Logger;

final class AsyncQueueHandler<T> {
    private static final Logger logger = Logger.getLogger(AsyncQueueHandler.class.getName());
    private static final ExecutorService sharedExecutor = Executors.newCachedThreadPool(new CustomizableThreadFactory(AsyncQueueHandler.class.getName() + "-executor-", true));
    private final ExecutorService executor;
    private final BlockingQueue<T> queue;
    private final Handler<T> handler;
    private final String id;
    private final long maxSequentiallyHandledItems;
    private final AtomicBoolean running = new AtomicBoolean();
    private final Object syncRoot = new Object();
    private Future<?> readerFuture;
    private final Runnable reader = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long sequentiallyHandledItems = 0L;
            while (AsyncQueueHandler.this.running.get()) {
                Object item;
                if (AsyncQueueHandler.this.maxSequentiallyHandledItems > 0L && sequentiallyHandledItems >= AsyncQueueHandler.this.maxSequentiallyHandledItems) {
                    AsyncQueueHandler.this.onYield();
                    return;
                }
                Object object = AsyncQueueHandler.this.syncRoot;
                synchronized (object) {
                    item = AsyncQueueHandler.this.queue.poll();
                    if (item == null) {
                        AsyncQueueHandler.this.cancel(false);
                        return;
                    }
                }
                ++sequentiallyHandledItems;
                try {
                    AsyncQueueHandler.this.handler.handleItem(item);
                }
                catch (Throwable e) {
                    logger.warn("Failed to handle item: ", e);
                }
            }
        }
    };

    AsyncQueueHandler(BlockingQueue<T> queue, Handler<T> handler, String id, ExecutorService executor) {
        this(queue, handler, id, executor, -1L);
    }

    AsyncQueueHandler(BlockingQueue<T> queue, Handler<T> handler, String id, ExecutorService executor, long maxSequentiallyHandledItems) {
        if (queue == null) {
            throw new IllegalArgumentException("queue is null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler is null");
        }
        this.executor = executor != null ? executor : sharedExecutor;
        this.queue = queue;
        this.handler = handler;
        this.id = id;
        this.maxSequentiallyHandledItems = maxSequentiallyHandledItems;
    }

    void cancel() {
        this.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleQueueItemsUntilEmpty() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.readerFuture == null || this.readerFuture.isDone()) {
                this.rescheduleReader();
            }
        }
    }

    private void onYield() {
        if (logger.isDebugEnabled()) {
            logger.debug("Yielding AsyncQueueHandler with ID = " + this.id);
        }
        this.rescheduleReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(boolean mayInterruptIfRunning) {
        Object object = this.syncRoot;
        synchronized (object) {
            this.running.set(false);
            if (this.readerFuture != null) {
                this.readerFuture.cancel(mayInterruptIfRunning);
                this.readerFuture = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleReader() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.running.set(true);
            this.readerFuture = this.executor.submit(this.reader);
        }
    }

    static interface Handler<T> {
        public void handleItem(T var1);
    }
}

