/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.eclipse.aether.resolution.ArtifactRequest;

@Mojo(name="lock-snapshots", threadSafe=true)
public class LockSnapshotsMojo
extends AbstractVersionsDependencyUpdaterMojo {
    private static final Pattern TIMESTAMPED_SNAPSHOT_REGEX = Pattern.compile("-SNAPSHOT");

    @Inject
    public LockSnapshotsMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            DependencyManagement dependencyManagement;
            if (this.isProcessingDependencyManagement() && (dependencyManagement = PomHelper.getRawModel((MavenProject)this.getProject()).getDependencyManagement()) != null) {
                this.lockSnapshots(pom, dependencyManagement.getDependencies());
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.lockSnapshots(pom, this.getProject().getDependencies());
            }
            if (this.getProject().getParent() != null && this.isProcessingParent()) {
                this.lockParentSnapshot(pom, this.getProject().getParent());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void lockSnapshots(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException {
        for (Dependency dep : dependencies) {
            String lockedVersion;
            String version;
            Matcher versionMatcher;
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            if (!this.isIncluded(this.toArtifact(dep)) || !(versionMatcher = TIMESTAMPED_SNAPSHOT_REGEX.matcher(version = dep.getVersion())).find() || versionMatcher.end() != version.length() || version.equals(lockedVersion = this.resolveSnapshotVersion(dep)) || !PomHelper.setDependencyVersion((ModifiedPomXMLEventReader)pom, (String)dep.getGroupId(), (String)dep.getArtifactId(), (String)version, (String)lockedVersion, (Model)this.getProject().getModel())) continue;
            this.getLog().info((CharSequence)("Locked " + this.toString(dep) + " to version " + lockedVersion));
        }
    }

    private void lockParentSnapshot(ModifiedPomXMLEventReader pom, MavenProject parent) throws XMLStreamException, MojoExecutionException {
        String lockedParentVersion;
        if (parent == null) {
            this.getLog().info((CharSequence)"Project does not have a parent");
            return;
        }
        if (this.reactorProjects.contains(parent)) {
            this.getLog().info((CharSequence)"Project's parent is part of the reactor");
            return;
        }
        Artifact parentArtifact = parent.getArtifact();
        String parentVersion = parentArtifact.getVersion();
        Matcher versionMatcher = TIMESTAMPED_SNAPSHOT_REGEX.matcher(parentVersion);
        if (versionMatcher.find() && versionMatcher.end() == parentVersion.length() && !parentVersion.equals(lockedParentVersion = this.resolveSnapshotVersion(parentArtifact)) && PomHelper.setProjectParentVersion((ModifiedPomXMLEventReader)pom, (String)lockedParentVersion)) {
            this.getLog().info((CharSequence)("Locked parent " + parentArtifact + " to version " + lockedParentVersion));
        }
    }

    private String resolveSnapshotVersion(Artifact artifact) {
        this.getLog().debug((CharSequence)("Resolving snapshot version for artifact: " + artifact));
        String lockedVersion = artifact.getVersion();
        try {
            this.aetherRepositorySystem.resolveArtifact(this.session.getRepositorySession(), new ArtifactRequest(RepositoryUtils.toArtifact((Artifact)artifact), this.getProject().getRemoteProjectRepositories(), ((Object)((Object)this)).getClass().getName()));
            lockedVersion = artifact.getVersion();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
        return lockedVersion;
    }

    private String resolveSnapshotVersion(Dependency dep) {
        this.getLog().debug((CharSequence)("Resolving snapshot version for dependency: " + dep));
        String lockedVersion = dep.getVersion();
        try {
            Artifact depArtifact = this.getHelper().createDependencyArtifact(dep);
            this.aetherRepositorySystem.resolveArtifact(this.session.getRepositorySession(), new ArtifactRequest(RepositoryUtils.toArtifact((Artifact)depArtifact), this.getProject().getRemoteProjectRepositories(), ((Object)((Object)this)).getClass().getName()));
            lockedVersion = depArtifact.getVersion();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
        return lockedVersion;
    }
}

