/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.ProgressMonitorInputStream;
import net.java.sip.communicator.service.httputil.HttpUtils;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File download(String url, String preferredFileName, String preferredExtension) throws IOException {
        File[] tempFile;
        block21: {
            tempFile = new File[1];
            FileOutputStream tempFileOutputStream = null;
            boolean deleteTempFile = true;
            tempFileOutputStream = FileUtils.createTempFileOutputStream(new URL(url), null, false, tempFile, preferredFileName, preferredExtension);
            try {
                HttpUtils.HTTPResponseResult res = HttpUtils.openURLConnection((String)url);
                if (res == null) break block21;
                InputStream content = res.getContent();
                ProgressMonitorInputStream input = new ProgressMonitorInputStream(null, url, content);
                input.getProgressMonitor().setMaximum((int)res.getContentLength());
                try {
                    BufferedOutputStream output = new BufferedOutputStream(tempFileOutputStream);
                    try {
                        int read = -1;
                        byte[] buff = new byte[1024];
                        while ((read = input.read(buff)) != -1) {
                            output.write(buff, 0, read);
                        }
                    }
                    finally {
                        output.close();
                        tempFileOutputStream = null;
                    }
                    deleteTempFile = false;
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    if (tempFileOutputStream != null) {
                        tempFileOutputStream.close();
                    }
                }
                finally {
                    if (deleteTempFile && tempFile[0] != null) {
                        tempFile[0].delete();
                        tempFile[0] = null;
                    }
                }
            }
        }
        return tempFile[0];
    }

    public static FileOutputStream createTempFileOutputStream(URL url, String extension, boolean dryRun, File[] tempFile, String preferredFileName, String preferredExtension) throws IOException {
        String path = url.getPath();
        File tf = null;
        FileOutputStream tfos = null;
        if (path != null && path.length() != 0) {
            int nameLength;
            String name;
            int nameBeginIndex = path.lastIndexOf(47);
            if (nameBeginIndex > 0) {
                name = path.substring(nameBeginIndex + 1);
                if ((nameBeginIndex = name.lastIndexOf(92)) > 0) {
                    name = name.substring(nameBeginIndex + 1);
                }
            } else {
                name = path;
            }
            if ((nameLength = name.length()) != 0) {
                int baseNameEnd = name.lastIndexOf(46);
                if (extension == null) {
                    extension = preferredExtension;
                }
                if (baseNameEnd == -1) {
                    name = name + extension;
                } else if (baseNameEnd == 0) {
                    if (!extension.equalsIgnoreCase(name)) {
                        name = name + extension;
                    }
                } else {
                    name = name.substring(0, baseNameEnd) + extension;
                }
                try {
                    String tempDir = System.getProperty("java.io.tmpdir");
                    if (tempDir != null && tempDir.length() != 0) {
                        tf = new File(tempDir, name);
                        if (!dryRun) {
                            tfos = new FileOutputStream(tf);
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        if (tfos == null && !dryRun) {
            tf = File.createTempFile(preferredFileName, preferredExtension);
            tfos = new FileOutputStream(tf);
        }
        tempFile[0] = tf;
        return tfos;
    }
}

