/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.util.Logger;

public class ImageUtils {
    private static final Logger logger = Logger.getLogger(ImageUtils.class);

    public static Image scaleImageWithinBounds(Image image, int width, int height) {
        int initialWidth = image.getWidth(null);
        int initialHeight = image.getHeight(null);
        int scaleHint = 4;
        double originalRatio = (double)initialWidth / (double)initialHeight;
        double areaRatio = (double)width / (double)height;
        Image scaledImage = originalRatio > areaRatio ? image.getScaledInstance(width, -1, scaleHint) : image.getScaledInstance(-1, height, scaleHint);
        return scaledImage;
    }

    public static ImageIcon scaleIconWithinBounds(Image image, int width, int height) {
        return new ImageIcon(ImageUtils.scaleImageWithinBounds(image, width, height));
    }

    public static ImageIcon scaleImageWithinBounds(byte[] imageBytes, int width, int height) {
        Image imageIcon;
        block11: {
            if (imageBytes == null || imageBytes.length <= 0) {
                return null;
            }
            imageIcon = null;
            try {
                Image image;
                try {
                    image = ImageIO.read(new ByteArrayInputStream(imageBytes));
                }
                catch (Exception e) {
                    try {
                        image = Toolkit.getDefaultToolkit().createImage(imageBytes);
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                }
                if (image != null) {
                    imageIcon = ImageUtils.scaleImageWithinBounds(image, width, height);
                } else if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Unknown image format or error reading image");
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block11;
                logger.debug((Object)"Could not create image.", (Throwable)e);
            }
        }
        if (imageIcon != null) {
            return new ImageIcon(imageIcon);
        }
        return null;
    }

    public static Image getScaledRoundedImage(Image image, int width, int height) {
        return ImageUtils.getScaledImage(image, Shape.ROUNDED_RECTANGLE, width, height);
    }

    public static Image getScaledEllipticalImage(Image image, int width, int height) {
        return ImageUtils.getScaledImage(image, Shape.ELLIPSE, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image getScaledImage(Image image, Shape shape, int width, int height) {
        ImageIcon scaledImage = ImageUtils.scaleIconWithinBounds(image, width, height);
        int scaledImageWidth = scaledImage.getIconWidth();
        int scaledImageHeight = scaledImage.getIconHeight();
        if (scaledImageHeight <= 0 || scaledImageWidth <= 0) {
            return null;
        }
        BufferedImage destImage = new BufferedImage(scaledImageWidth, scaledImageHeight, 2);
        Graphics2D g = destImage.createGraphics();
        try {
            g.setComposite(AlphaComposite.Src);
            AntialiasingManager.activateAntialiasing(g);
            g.setColor(Color.WHITE);
            switch (shape) {
                case ELLIPSE: {
                    g.fillOval(0, 0, scaledImageWidth, scaledImageHeight);
                    break;
                }
                case ROUNDED_RECTANGLE: {
                    g.fillRoundRect(0, 0, scaledImageWidth, scaledImageHeight, 5, 5);
                }
            }
            g.setComposite(AlphaComposite.SrcAtop);
            g.drawImage(scaledImage.getImage(), 0, 0, null);
        }
        finally {
            g.dispose();
        }
        return destImage;
    }

    public static byte[] getScaledInstanceInBytes(Image image, int width, int height) {
        BufferedImage scaledImage = (BufferedImage)ImageUtils.getScaledRoundedImage(image, width, height);
        return ImageUtils.convertImageToBytes(scaledImage);
    }

    public static byte[] getScaledEllipticalInstanceInBytes(Image image, int width, int height) {
        BufferedImage scaledImage = (BufferedImage)ImageUtils.getScaledEllipticalImage(image, width, height);
        return ImageUtils.convertImageToBytes(scaledImage);
    }

    public static ImageIcon getScaledRoundedIcon(Image image, int width, int height) {
        Image scaledImage = ImageUtils.getScaledRoundedImage(image, width, height);
        if (scaledImage != null) {
            return new ImageIcon(scaledImage);
        }
        return null;
    }

    public static ImageIcon getScaledEllipticalIcon(Image image, int width, int height) {
        Image scaledImage = ImageUtils.getScaledEllipticalImage(image, width, height);
        if (scaledImage != null) {
            return new ImageIcon(scaledImage);
        }
        return null;
    }

    public static ImageIcon getScaledRoundedIcon(byte[] imageBytes, int width, int height) {
        return ImageUtils.getScaledIcon(imageBytes, Shape.ROUNDED_RECTANGLE, width, height);
    }

    public static ImageIcon getScaledEllipticalIcon(byte[] imageBytes, int width, int height) {
        return ImageUtils.getScaledIcon(imageBytes, Shape.ELLIPSE, width, height);
    }

    private static ImageIcon getScaledIcon(byte[] imageBytes, Shape shape, int width, int height) {
        ImageIcon imageIcon;
        block14: {
            if (imageBytes == null || imageBytes.length <= 0) {
                return null;
            }
            imageIcon = null;
            try {
                Image image;
                try {
                    image = ImageIO.read(new ByteArrayInputStream(imageBytes));
                }
                catch (Exception e) {
                    try {
                        image = Toolkit.getDefaultToolkit().createImage(imageBytes);
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                }
                if (image != null) {
                    switch (shape) {
                        case ELLIPSE: {
                            imageIcon = ImageUtils.getScaledEllipticalIcon(image, width, height);
                            break;
                        }
                        case ROUNDED_RECTANGLE: {
                            imageIcon = ImageUtils.getScaledRoundedIcon(image, width, height);
                        }
                    }
                } else if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Unknown image format or error reading image");
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block14;
                logger.debug((Object)"Could not create image.", (Throwable)e);
            }
        }
        return imageIcon;
    }

    public static BufferedImage getBufferedImage(URL imagePath) {
        BufferedImage image;
        block3: {
            image = null;
            if (imagePath != null) {
                try {
                    image = ImageIO.read(imagePath);
                }
                catch (IOException ex) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)("Failed to load image:" + imagePath), (Throwable)ex);
                }
            }
        }
        return image;
    }

    public static BufferedImage getBufferedImage(Image source) {
        if (source == null) {
            return null;
        }
        if (source instanceof BufferedImage) {
            return (BufferedImage)source;
        }
        int width = source.getWidth(null);
        int height = source.getHeight(null);
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.drawImage(source, 0, 0, null);
        graphics.dispose();
        return image;
    }

    public static byte[] toByteArray(BufferedImage image) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", out);
        }
        catch (IOException e) {
            logger.debug((Object)"Cannot convert buffered image to byte[]", (Throwable)e);
            return null;
        }
        return out.toByteArray();
    }

    public static Image getBytesInImage(byte[] imageBytes) {
        if (imageBytes == null || imageBytes.length <= 0) {
            return null;
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new ByteArrayInputStream(imageBytes));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to convert bytes to image.", (Throwable)e);
        }
        return image;
    }

    public static Image getComposedImage(Image leftImage, Image rightImage, ImageObserver imageObserver) {
        int width;
        int leftWidth;
        int height;
        if (leftImage == null) {
            if (rightImage == null) {
                return null;
            }
            height = rightImage.getHeight(imageObserver);
            leftWidth = rightImage.getWidth(imageObserver);
            width = leftWidth * 2;
        } else if (rightImage == null) {
            height = leftImage.getHeight(imageObserver);
            leftWidth = leftImage.getWidth(imageObserver);
            width = leftWidth * 2;
        } else {
            height = Math.max(leftImage.getHeight(imageObserver), rightImage.getHeight(imageObserver));
            leftWidth = leftImage.getWidth(imageObserver);
            width = leftWidth + rightImage.getWidth(imageObserver);
        }
        BufferedImage buffImage = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)buffImage.getGraphics();
        AntialiasingManager.activateAntialiasing(g);
        g.setComposite(AlphaComposite.getInstance(3));
        if (leftImage != null) {
            g.drawImage(leftImage, 0, 0, null);
        }
        if (rightImage != null) {
            g.drawImage(rightImage, leftWidth + 1, 0, null);
        }
        return buffImage;
    }

    private static byte[] convertImageToBytes(BufferedImage scaledImage) {
        byte[] scaledBytes;
        block3: {
            scaledBytes = null;
            if (scaledImage != null) {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)scaledImage, "png", outStream);
                    scaledBytes = outStream.toByteArray();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)"Could not scale image in bytes.", (Throwable)e);
                }
            }
        }
        return scaledBytes;
    }

    public static void setScaledLabelImage(final JLabel label, final byte[] image, final int width, final int height) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageUtils.setScaledLabelImage(label, image, width, height);
                }
            });
            return;
        }
        label.setIcon(ImageUtils.getScaledRoundedIcon(image, width, height));
        label.repaint();
    }

    private static enum Shape {
        ELLIPSE,
        ROUNDED_RECTANGLE;

    }
}

