/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTabbedPane;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.util.skin.Skinnable;

public class SIPCommTabbedPaneUI
extends BasicTabbedPaneUI
implements Skinnable {
    private static final String CLOSE_TAB_ICON = "service.gui.lookandfeel.CLOSE_TAB_ICON";
    private ContainerListener containerListener;
    private Vector<View> htmlViews;
    private Map<Integer, Integer> mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    protected ScrollableTabSupport tabScroller;
    private int tabCount;
    protected MyMouseMotionListener motionListener;
    private static final int INACTIVE = 0;
    private static final int OVER = 1;
    private static final int PRESSED = 2;
    public static final int BUTTONSIZE = 15;
    public static final int WIDTHDELTA = 1;
    private static final Border PRESSEDBORDER = new SoftBevelBorder(1);
    private static final Border OVERBORDER = new SoftBevelBorder(0);
    private Image closeImgI;
    private BufferedImage maxImgI;
    private int overTabIndex = -1;
    private int closeIndexStatus = 0;
    private int maxIndexStatus = 0;
    private boolean mousePressed = false;
    private boolean isCloseButtonEnabled = false;
    private boolean isMaxButtonEnabled = false;
    protected JPopupMenu actionPopupMenu;
    protected JMenuItem maxItem;
    protected JMenuItem closeItem;

    public SIPCommTabbedPaneUI() {
        this.loadSkin();
        this.actionPopupMenu = new JPopupMenu();
        this.maxItem = new JMenuItem("Detach");
        this.closeItem = new JMenuItem("Close");
        this.maxItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((SIPCommTabbedPane)SIPCommTabbedPaneUI.this.tabPane).fireMaxTabEvent(null, SIPCommTabbedPaneUI.this.tabPane.getSelectedIndex());
            }
        });
        this.closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((SIPCommTabbedPane)SIPCommTabbedPaneUI.this.tabPane).fireCloseTabEvent(null, SIPCommTabbedPaneUI.this.tabPane.getSelectedIndex());
            }
        });
        this.setPopupMenu();
    }

    protected boolean isOneActionButtonEnabled() {
        return this.isCloseButtonEnabled || this.isMaxButtonEnabled;
    }

    public boolean isCloseEnabled() {
        return this.isCloseButtonEnabled;
    }

    public boolean isMaxEnabled() {
        return this.isMaxButtonEnabled;
    }

    public void setCloseIcon(boolean b) {
        this.isCloseButtonEnabled = b;
        this.setPopupMenu();
    }

    public void setMaxIcon(boolean b) {
        this.isMaxButtonEnabled = b;
        this.setPopupMenu();
    }

    private void setPopupMenu() {
        this.actionPopupMenu.removeAll();
        if (this.isMaxButtonEnabled) {
            this.actionPopupMenu.add(this.maxItem);
        }
        if (this.isMaxButtonEnabled && this.isCloseButtonEnabled) {
            this.actionPopupMenu.addSeparator();
        }
        if (this.isCloseButtonEnabled) {
            this.actionPopupMenu.add(this.closeItem);
        }
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int delta = 0;
        Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
        if (this.isOneActionButtonEnabled()) {
            tabInsets.right = 0;
            if (this.isCloseButtonEnabled) {
                delta += 15;
            }
            if (this.isMaxButtonEnabled) {
                delta += 15;
            }
        }
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics) + delta;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight + 4);
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 2, 0, 0, tabRect, iconRect, textRect, 0);
        this.tabPane.putClientProperty("html", null);
        if (icon != null) {
            iconRect.y += 2;
            iconRect.x = tabRect.x + 7;
        }
        textRect.y += 2;
        textRect.x = icon != null ? iconRect.x + iconRect.width + 5 : (textRect.x += 8);
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MyMouseHandler();
    }

    protected ScrollableTabButton createScrollableTabButton(int direction) {
        return new ScrollableTabButton(direction);
    }

    protected Rectangle newCloseRect(Rectangle rect) {
        int dx = rect.x + rect.width - 15 - 1;
        int dy = rect.y + (rect.height - 15) / 2 + 2;
        return new Rectangle(dx, dy, 15, 15);
    }

    protected Rectangle newMaxRect(Rectangle rect) {
        int dx = rect.x + rect.width - 15 - 1;
        int dy = rect.y + (rect.height - 15) / 2 + 2;
        if (this.isCloseButtonEnabled) {
            dx -= 15;
        }
        return new Rectangle(dx, dy, 15, 15);
    }

    protected void updateOverTab(int x, int y) {
        int overTabIndex = this.getTabAtLocation(x, y);
        if (this.overTabIndex != overTabIndex) {
            this.overTabIndex = overTabIndex;
            this.tabScroller.tabPanel.repaint();
        }
    }

    protected void updateCloseIcon(int x, int y) {
        if (this.overTabIndex != -1) {
            int newCloseIndexStatus = 0;
            Rectangle closeRect = this.newCloseRect(this.rects[this.overTabIndex]);
            if (closeRect.contains(x, y)) {
                int n = newCloseIndexStatus = this.mousePressed ? 2 : 1;
            }
            if (this.closeIndexStatus != newCloseIndexStatus) {
                this.closeIndexStatus = newCloseIndexStatus;
                this.tabScroller.tabPanel.repaint();
            }
        }
    }

    protected void updateMaxIcon(int x, int y) {
        if (this.overTabIndex != -1) {
            int newMaxIndexStatus = 0;
            Rectangle maxRect = this.newMaxRect(this.rects[this.overTabIndex]);
            if (maxRect.contains(x, y)) {
                int n = newMaxIndexStatus = this.mousePressed ? 2 : 1;
            }
            if (this.maxIndexStatus != newMaxIndexStatus) {
                this.maxIndexStatus = newMaxIndexStatus;
                this.tabScroller.tabPanel.repaint();
            }
        }
    }

    private void setTabIcons(int x, int y) {
        if (!this.mousePressed) {
            this.updateOverTab(x, y);
        }
        if (this.isCloseButtonEnabled) {
            this.updateCloseIcon(x, y);
        }
        if (this.isMaxButtonEnabled) {
            this.updateMaxIcon(x, y);
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new SIPCommTabbedPaneUI();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new TabbedPaneScrollLayout();
    }

    @Override
    protected void installComponents() {
        if (this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
            this.tabPane.add(this.tabScroller.scrollForwardButton);
            this.tabPane.add(this.tabScroller.scrollBackwardButton);
        }
    }

    @Override
    protected void uninstallComponents() {
        this.tabPane.remove(this.tabScroller.viewport);
        this.tabPane.remove(this.tabScroller.scrollForwardButton);
        this.tabPane.remove(this.tabScroller.scrollBackwardButton);
        this.tabScroller = null;
    }

    @Override
    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.tabScroller.tabPanel.addMouseListener(this.mouseListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        if ((this.containerListener = new ContainerHandler()) != null) {
            this.tabPane.addContainerListener(this.containerListener);
            if (this.tabPane.getTabCount() > 0) {
                this.htmlViews = this.createHTMLVector();
            }
        }
        if ((this.motionListener = new MyMouseMotionListener()) != null) {
            this.tabScroller.tabPanel.addMouseMotionListener(this.motionListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            this.tabScroller.tabPanel.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
        if (this.motionListener != null) {
            this.tabScroller.tabPanel.removeMouseMotionListener(this.motionListener);
            this.motionListener = null;
        }
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.containerListener != null) {
            this.tabPane.removeContainerListener(this.containerListener);
            this.containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    @Override
    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    @Override
    protected void installKeyboardActions() {
        InputMap km = this.getMyInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, km);
        km = this.getMyInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, km);
        ActionMap am = this.createMyActionMap();
        SwingUtilities.replaceUIActionMap(this.tabPane, am);
        this.tabScroller.scrollForwardButton.setAction(am.get("scrollTabsForwardAction"));
        this.tabScroller.scrollBackwardButton.setAction(am.get("scrollTabsBackwardAction"));
    }

    InputMap getMyInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("TabbedPane.ancestorInputMap");
        }
        if (condition == 0) {
            return (InputMap)UIManager.get("TabbedPane.focusInputMap");
        }
        return null;
    }

    ActionMap createMyActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("navigateNext", new DirectionAction(12));
        map.put("navigatePrevious", new DirectionAction(13));
        map.put("navigateRight", new DirectionAction(3));
        map.put("navigateLeft", new DirectionAction(7));
        map.put("navigateUp", new DirectionAction(1));
        map.put("navigateDown", new DirectionAction(5));
        map.put("navigatePageUp", new PageAction(true));
        map.put("navigatePageDown", new PageAction(false));
        map.put("requestFocus", new RequestFocusAction());
        map.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        map.put("setSelectedIndex", new SetSelectedIndexAction());
        map.put("scrollTabsForwardAction", new ScrollTabsForwardAction());
        map.put("scrollTabsBackwardAction", new ScrollTabsBackwardAction());
        return map;
    }

    @Override
    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
    }

    private void updateMnemonics() {
        this.resetMnemonics();
        for (int counter = this.tabPane.getTabCount() - 1; counter >= 0; --counter) {
            int mnemonic = this.tabPane.getMnemonicAt(counter);
            if (mnemonic <= 0) continue;
            this.addMnemonic(counter, mnemonic);
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int index, int mnemonic) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(mnemonic, index);
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable<Integer, Integer>();
        this.mnemonicInputMap = new InputMapUIResource();
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 1));
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, this.mnemonicInputMap);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int tc = this.tabPane.getTabCount();
        if (this.tabCount != tc) {
            this.tabCount = tc;
            this.updateMnemonics();
        }
        int selectedIndex = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        this.paintContentBorder(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        boolean isOver = this.overTabIndex == tabIndex;
        Graphics2D g2 = null;
        Shape save = null;
        boolean cropShape = false;
        int cropx = 0;
        int cropy = 0;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
            AntialiasingManager.activateAntialiasing(g2);
            Rectangle viewRect = this.tabScroller.viewport.getViewRect();
            int cropline = viewRect.x + viewRect.width;
            if (tabRect.x < cropline && tabRect.x + tabRect.width > cropline) {
                cropx = cropline - 1;
                cropy = tabRect.y;
                cropShape = true;
            }
            if (cropShape) {
                save = g2.getClip();
                g2.clipRect(tabRect.x, tabRect.y, tabRect.width, tabRect.height);
            }
        }
        this.paintTabBackground(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        this.paintTabBorder(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        String title = this.tabPane.getTitleAt(tabIndex);
        Font font = this.tabPane.getFont();
        FontMetrics metrics = g.getFontMetrics(font);
        Icon icon = this.getIconForTab(tabIndex);
        this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        this.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        this.paintFocusIndicator(g, tabPlacement, rects, tabIndex, iconRect, textRect, isSelected);
        if (cropShape) {
            this.paintCroppedTabEdge(g, tabPlacement, tabIndex, isSelected, cropx, cropy);
            g2.setClip(save);
        } else if (isOver || isSelected) {
            Rectangle closeRect = this.newCloseRect(tabRect);
            int dx = closeRect.x;
            int dy = closeRect.y;
            if (this.isCloseButtonEnabled) {
                this.paintCloseIcon(g2, dx, dy, isOver);
            }
            if (this.isMaxButtonEnabled) {
                this.paintMaxIcon(g2, dx, dy, isOver);
            }
        }
    }

    protected void paintCloseIcon(Graphics g, int dx, int dy, boolean isOver) {
        g.drawImage(this.closeImgI, dx, dy + 1, null);
    }

    protected void paintMaxIcon(Graphics g, int dx, int dy, boolean isOver) {
        if (this.isCloseButtonEnabled) {
            dx -= 15;
        }
        g.drawImage(this.maxImgI, dx, dy + 1, null);
    }

    protected void paintActionButton(Graphics g, int dx, int dy, int status, boolean isOver, JButton button, Image image) {
        button.setBorder(null);
        if (isOver) {
            switch (status) {
                case 1: {
                    button.setBorder(OVERBORDER);
                    break;
                }
                case 2: {
                    button.setBorder(PRESSEDBORDER);
                }
            }
        }
        button.setBackground(this.tabScroller.tabPanel.getBackground());
        button.paint(image.getGraphics());
        g.drawImage(image, dx, dy, null);
    }

    private void paintCroppedTabEdge(Graphics g, int tabPlacement, int tabIndex, boolean isSelected, int x, int y) {
        g.setColor(this.shadow);
        g.drawLine(x, y, x, y + this.rects[tabIndex].height);
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    @Override
    protected Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        dest.width = this.rects[tabIndex].width;
        dest.height = this.rects[tabIndex].height;
        Point vpp = this.tabScroller.viewport.getLocation();
        Point viewp = this.tabScroller.viewport.getViewPosition();
        dest.x = this.rects[tabIndex].x + vpp.x - viewp.x;
        dest.y = this.rects[tabIndex].y + vpp.y - viewp.y;
        return dest;
    }

    private int getTabAtLocation(int x, int y) {
        this.ensureCurrentLayout();
        int tabCount = this.tabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            if (!this.rects[i].contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    public int getOverTabIndex() {
        return this.overTabIndex;
    }

    protected int getClosestTab(int x, int y) {
        int want;
        int tabCount;
        int min = 0;
        int max = tabCount = Math.min(this.rects.length, this.tabPane.getTabCount());
        int tabPlacement = this.tabPane.getTabPlacement();
        boolean useX = tabPlacement == 1 || tabPlacement == 3;
        int n = want = useX ? x : y;
        while (min != max) {
            int maxLoc;
            int minLoc;
            int current = (max + min) / 2;
            if (useX) {
                minLoc = this.rects[current].x;
                maxLoc = minLoc + this.rects[current].width;
            } else {
                minLoc = this.rects[current].y;
                maxLoc = minLoc + this.rects[current].height;
            }
            if (want < minLoc) {
                max = current;
                if (min != max) continue;
                return Math.max(0, current - 1);
            }
            if (want >= maxLoc) {
                min = current;
                if (max - min > 1) continue;
                return Math.max(current + 1, tabCount - 1);
            }
            return current;
        }
        return min;
    }

    private Point translatePointToTabPanel(int srcx, int srcy, Point dest) {
        Point vpp = this.tabScroller.viewport.getLocation();
        Point viewp = this.tabScroller.viewport.getViewPosition();
        dest.x = srcx + vpp.x + viewp.x;
        dest.y = srcy + vpp.y + viewp.y;
        return dest;
    }

    boolean requestMyFocusForVisibleComponent() {
        Component visibleComponent = this.getVisibleComponent();
        if (visibleComponent.isFocusable()) {
            visibleComponent.requestFocus();
            return true;
        }
        return visibleComponent instanceof JComponent && visibleComponent.requestFocusInWindow();
    }

    private Vector<View> createHTMLVector() {
        Vector<View> htmlViews = new Vector<View>();
        int count = this.tabPane.getTabCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                String title = this.tabPane.getTitleAt(i);
                if (BasicHTML.isHTMLString(title)) {
                    htmlViews.addElement(BasicHTML.createHTMLView(this.tabPane, title));
                    continue;
                }
                htmlViews.addElement(null);
            }
        }
        return htmlViews;
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
    }

    public void loadSkin() {
        this.closeImgI = DesktopUtilActivator.getImage(CLOSE_TAB_ICON);
        this.maxImgI = new BufferedImage(15, 15, 6);
    }

    private class MyMouseMotionListener
    implements MouseMotionListener {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (SIPCommTabbedPaneUI.this.actionPopupMenu.isVisible()) {
                return;
            }
            SIPCommTabbedPaneUI.this.mousePressed = false;
            SIPCommTabbedPaneUI.this.setTabIcons(e.getX(), e.getY());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SIPCommTabbedPaneUI.this.actionPopupMenu.isVisible()) {
                return;
            }
            SIPCommTabbedPaneUI.this.mousePressed = true;
            SIPCommTabbedPaneUI.this.setTabIcons(e.getX(), e.getY());
        }
    }

    private class MyMouseHandler
    extends BasicTabbedPaneUI.MouseHandler {
        private MyMouseHandler() {
            super(SIPCommTabbedPaneUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SIPCommTabbedPaneUI.this.closeIndexStatus == 1) {
                SIPCommTabbedPaneUI.this.closeIndexStatus = 2;
                SIPCommTabbedPaneUI.this.tabScroller.tabPanel.repaint();
            } else if (SIPCommTabbedPaneUI.this.maxIndexStatus == 1) {
                SIPCommTabbedPaneUI.this.maxIndexStatus = 2;
                SIPCommTabbedPaneUI.this.tabScroller.tabPanel.repaint();
            } else {
                super.mousePressed(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1 && SIPCommTabbedPaneUI.this.overTabIndex != -1) {
                ((SIPCommTabbedPane)SIPCommTabbedPaneUI.this.tabPane).fireDoubleClickTabEvent(e, SIPCommTabbedPaneUI.this.overTabIndex);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SIPCommTabbedPaneUI.this.updateOverTab(e.getX(), e.getY());
            if (SIPCommTabbedPaneUI.this.overTabIndex == -1) {
                if (e.isPopupTrigger()) {
                    ((SIPCommTabbedPane)SIPCommTabbedPaneUI.this.tabPane).firePopupOutsideTabEvent(e);
                }
                return;
            }
            if (SIPCommTabbedPaneUI.this.isOneActionButtonEnabled() && e.isPopupTrigger()) {
                super.mousePressed(e);
                SIPCommTabbedPaneUI.this.closeIndexStatus = 0;
                SIPCommTabbedPaneUI.this.maxIndexStatus = 0;
                SIPCommTabbedPaneUI.this.actionPopupMenu.show((Component)((Object)SIPCommTabbedPaneUI.this.tabScroller.tabPanel), e.getX(), e.getY());
                return;
            }
            if (SIPCommTabbedPaneUI.this.closeIndexStatus == 2) {
                SIPCommTabbedPaneUI.this.closeIndexStatus = 1;
                SIPCommTabbedPaneUI.this.tabScroller.tabPanel.repaint();
                ((SIPCommTabbedPane)SIPCommTabbedPaneUI.this.tabPane).fireCloseTabEvent(e, SIPCommTabbedPaneUI.this.overTabIndex);
                return;
            }
            if (SIPCommTabbedPaneUI.this.maxIndexStatus == 2) {
                SIPCommTabbedPaneUI.this.maxIndexStatus = 1;
                SIPCommTabbedPaneUI.this.tabScroller.tabPanel.repaint();
                ((SIPCommTabbedPane)SIPCommTabbedPaneUI.this.tabPane).fireMaxTabEvent(e, SIPCommTabbedPaneUI.this.overTabIndex);
                return;
            }
            if (e.getButton() == 2) {
                ((SIPCommTabbedPane)SIPCommTabbedPaneUI.this.tabPane).fireCloseTabEvent(e, SIPCommTabbedPaneUI.this.overTabIndex);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!SIPCommTabbedPaneUI.this.mousePressed) {
                SIPCommTabbedPaneUI.this.overTabIndex = -1;
                SIPCommTabbedPaneUI.this.tabScroller.tabPanel.repaint();
            }
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            int index = tp.indexOfComponent(child);
            String title = tp.getTitleAt(index);
            boolean isHTML = BasicHTML.isHTMLString(title);
            if (isHTML) {
                if (SIPCommTabbedPaneUI.this.htmlViews == null) {
                    SIPCommTabbedPaneUI.this.htmlViews = SIPCommTabbedPaneUI.this.createHTMLVector();
                } else {
                    View v = BasicHTML.createHTMLView(tp, title);
                    SIPCommTabbedPaneUI.this.htmlViews.insertElementAt(v, index);
                }
            } else if (SIPCommTabbedPaneUI.this.htmlViews != null) {
                SIPCommTabbedPaneUI.this.htmlViews.insertElementAt(null, index);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            Integer indexObj = (Integer)tp.getClientProperty("__index_to_remove__");
            if (indexObj != null) {
                int index = indexObj;
                if (SIPCommTabbedPaneUI.this.htmlViews != null && SIPCommTabbedPaneUI.this.htmlViews.size() >= index) {
                    SIPCommTabbedPaneUI.this.htmlViews.removeElementAt(index);
                }
            }
        }
    }

    private class TabSelectionHandler
    implements ChangeListener {
        private TabSelectionHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int index;
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            tabPane.revalidate();
            tabPane.repaint();
            if (tabPane.getTabLayoutPolicy() == 1 && (index = tabPane.getSelectedIndex()) < SIPCommTabbedPaneUI.this.rects.length && index != -1) {
                SIPCommTabbedPaneUI.this.tabScroller.tabPanel.scrollRectToVisible(SIPCommTabbedPaneUI.this.rects[index]);
            }
        }
    }

    protected static class ScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        private static final long serialVersionUID = 0L;

        public ScrollableTabButton(int direction) {
            super(direction, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
        }

        public boolean scrollsForward() {
            return this.direction == 3 || this.direction == 5;
        }
    }

    private class ScrollableTabPanel
    extends TransparentPanel
    implements UIResource {
        private static final long serialVersionUID = 0L;

        public ScrollableTabPanel() {
            this.setLayout(null);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            SIPCommTabbedPaneUI.this.paintTabArea(g, SIPCommTabbedPaneUI.this.tabPane.getTabPlacement(), SIPCommTabbedPaneUI.this.tabPane.getSelectedIndex());
        }
    }

    protected static class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        private static final long serialVersionUID = 0L;

        public ScrollableTabViewport() {
            this.setOpaque(false);
            this.setScrollMode(0);
        }
    }

    protected class ScrollableTabSupport
    implements ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public ScrollableTabButton scrollForwardButton;
        public ScrollableTabButton scrollBackwardButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int tabPlacement) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView((Component)((Object)this.tabPanel));
            this.viewport.addChangeListener(this);
            this.scrollForwardButton = SIPCommTabbedPaneUI.this.createScrollableTabButton(3);
            this.scrollBackwardButton = SIPCommTabbedPaneUI.this.createScrollableTabButton(7);
        }

        public void scrollForward(int tabPlacement) {
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            if (tabPlacement == 1 || tabPlacement == 3 ? viewRect.width >= viewSize.width - viewRect.x : viewRect.height >= viewSize.height - viewRect.y) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int tabPlacement) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex - 1);
        }

        public void setLeadingTabIndex(int tabPlacement, int index) {
            this.leadingTabIndex = index;
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            int n = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : ((SIPCommTabbedPaneUI)SIPCommTabbedPaneUI.this).rects[this.leadingTabIndex].x;
            if (viewSize.width - this.tabViewPosition.x < viewRect.width) {
                Dimension extentSize = new Dimension(viewSize.width - this.tabViewPosition.x, viewRect.height);
                this.viewport.setExtentSize(extentSize);
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JViewport viewport = (JViewport)e.getSource();
            int tabPlacement = SIPCommTabbedPaneUI.this.tabPane.getTabPlacement();
            int tabCount = SIPCommTabbedPaneUI.this.tabPane.getTabCount();
            Rectangle vpRect = viewport.getBounds();
            Dimension viewSize = viewport.getViewSize();
            Rectangle viewRect = viewport.getViewRect();
            this.leadingTabIndex = SIPCommTabbedPaneUI.this.getClosestTab(viewRect.x, viewRect.y);
            if (this.leadingTabIndex + 1 < tabCount && ((SIPCommTabbedPaneUI)SIPCommTabbedPaneUI.this).rects[this.leadingTabIndex].x < viewRect.x) {
                ++this.leadingTabIndex;
            }
            Insets contentInsets = SIPCommTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            SIPCommTabbedPaneUI.this.tabPane.repaint(vpRect.x, vpRect.y + vpRect.height, vpRect.width, contentInsets.top);
            this.scrollBackwardButton.setEnabled(viewRect.x > 0);
            this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
        }

        public String toString() {
            return new String("viewport.viewSize=" + this.viewport.getViewSize() + "\nviewport.viewRectangle=" + this.viewport.getViewRect() + "\nleadingTabIndex=" + this.leadingTabIndex + "\ntabViewPosition=" + this.tabViewPosition);
        }
    }

    private class TabbedPaneScrollLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        private TabbedPaneScrollLayout() {
            super(SIPCommTabbedPaneUI.this);
        }

        @Override
        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            return SIPCommTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
        }

        @Override
        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            return SIPCommTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
        }

        @Override
        public void layoutContainer(Container parent) {
            int tabPlacement = SIPCommTabbedPaneUI.this.tabPane.getTabPlacement();
            int tabCount = SIPCommTabbedPaneUI.this.tabPane.getTabCount();
            Insets insets = SIPCommTabbedPaneUI.this.tabPane.getInsets();
            int selectedIndex = SIPCommTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component visibleComponent = SIPCommTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    SIPCommTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component selectedComponent = SIPCommTabbedPaneUI.this.tabPane.getComponentAt(selectedIndex);
                boolean shouldChangeFocus = false;
                if (selectedComponent != null) {
                    if (selectedComponent != visibleComponent && visibleComponent != null && KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() != null) {
                        shouldChangeFocus = true;
                    }
                    SIPCommTabbedPaneUI.this.setVisibleComponent(selectedComponent);
                }
                Insets contentInsets = SIPCommTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
                Rectangle bounds = SIPCommTabbedPaneUI.this.tabPane.getBounds();
                int numChildren = SIPCommTabbedPaneUI.this.tabPane.getComponentCount();
                if (numChildren > 0) {
                    int tw = bounds.width - insets.left - insets.right;
                    int th = SIPCommTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, SIPCommTabbedPaneUI.this.runCount, SIPCommTabbedPaneUI.this.maxTabHeight);
                    int tx = insets.left;
                    int ty = insets.top;
                    int cx = tx + contentInsets.left;
                    int cy = ty + th + contentInsets.top;
                    int cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                    int ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                    for (int i = 0; i < numChildren; ++i) {
                        Component child = SIPCommTabbedPaneUI.this.tabPane.getComponent(i);
                        if (child instanceof ScrollableTabViewport) {
                            JViewport viewport = (JViewport)child;
                            Rectangle viewRect = viewport.getViewRect();
                            int vw = tw;
                            int vh = th;
                            int totalTabWidth = ((SIPCommTabbedPaneUI)SIPCommTabbedPaneUI.this).rects[tabCount - 1].x + ((SIPCommTabbedPaneUI)SIPCommTabbedPaneUI.this).rects[tabCount - 1].width;
                            if (totalTabWidth > tw && totalTabWidth - viewRect.x <= (vw = Math.max(tw - 36, 36))) {
                                vw = totalTabWidth - viewRect.x;
                            }
                            child.setBounds(tx, ty, vw, vh);
                            continue;
                        }
                        if (child instanceof ScrollableTabButton) {
                            ScrollableTabButton scrollbutton = (ScrollableTabButton)child;
                            Dimension bsize = scrollbutton.getPreferredSize();
                            int bx = 0;
                            int by = 0;
                            int bw = bsize.width;
                            int bh = bsize.height;
                            boolean visible = false;
                            int totalTabWidth = ((SIPCommTabbedPaneUI)SIPCommTabbedPaneUI.this).rects[tabCount - 1].x + ((SIPCommTabbedPaneUI)SIPCommTabbedPaneUI.this).rects[tabCount - 1].width;
                            if (totalTabWidth > tw) {
                                int dir = scrollbutton.scrollsForward() ? 3 : 7;
                                scrollbutton.setDirection(dir);
                                visible = true;
                                bx = dir == 3 ? bounds.width - insets.left - bsize.width : bounds.width - insets.left - 2 * bsize.width;
                                by = tabPlacement == 1 ? ty + th - bsize.height : ty;
                            }
                            child.setVisible(visible);
                            if (!visible) continue;
                            child.setBounds(bx, by, bw, bh);
                            continue;
                        }
                        child.setBounds(cx, cy, cw, ch);
                    }
                    if (shouldChangeFocus && !SIPCommTabbedPaneUI.this.requestMyFocusForVisibleComponent()) {
                        SIPCommTabbedPaneUI.this.tabPane.requestFocus();
                    }
                }
            }
        }

        @Override
        protected void calculateTabRects(int tabPlacement, int tabCount) {
            FontMetrics metrics = SIPCommTabbedPaneUI.this.getFontMetrics();
            Insets tabAreaInsets = SIPCommTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            int x = tabAreaInsets.left - 2;
            int y = tabAreaInsets.top;
            int totalWidth = 0;
            int totalHeight = 0;
            SIPCommTabbedPaneUI.this.maxTabHeight = SIPCommTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
            SIPCommTabbedPaneUI.this.runCount = 0;
            SIPCommTabbedPaneUI.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            SIPCommTabbedPaneUI.this.selectedRun = 0;
            SIPCommTabbedPaneUI.this.runCount = 1;
            for (int i = 0; i < tabCount; ++i) {
                Rectangle rect = SIPCommTabbedPaneUI.this.rects[i];
                if (i > 0) {
                    rect.x = ((SIPCommTabbedPaneUI)SIPCommTabbedPaneUI.this).rects[i - 1].x + ((SIPCommTabbedPaneUI)SIPCommTabbedPaneUI.this).rects[i - 1].width - 1;
                } else {
                    ((SIPCommTabbedPaneUI)SIPCommTabbedPaneUI.this).tabRuns[0] = 0;
                    SIPCommTabbedPaneUI.this.maxTabWidth = 0;
                    totalHeight += SIPCommTabbedPaneUI.this.maxTabHeight;
                    rect.x = x;
                }
                rect.width = SIPCommTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                totalWidth = rect.x + rect.width;
                SIPCommTabbedPaneUI.this.maxTabWidth = Math.max(SIPCommTabbedPaneUI.this.maxTabWidth, rect.width);
                rect.y = y;
                rect.height = SIPCommTabbedPaneUI.this.maxTabHeight;
            }
            SIPCommTabbedPaneUI.this.tabScroller.tabPanel.setPreferredSize(new Dimension(totalWidth, totalHeight));
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        private static final long serialVersionUID = 0L;

        private ScrollTabsBackwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = null;
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                pane = (JTabbedPane)src;
            } else if (src instanceof ScrollableTabButton) {
                pane = (JTabbedPane)((ScrollableTabButton)src).getParent();
            } else {
                return;
            }
            SIPCommTabbedPaneUI ui = (SIPCommTabbedPaneUI)pane.getUI();
            ui.tabScroller.scrollBackward(pane.getTabPlacement());
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        private static final long serialVersionUID = 0L;

        private ScrollTabsForwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = null;
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                pane = (JTabbedPane)src;
            } else if (src instanceof ScrollableTabButton) {
                pane = (JTabbedPane)((ScrollableTabButton)src).getParent();
            } else {
                return;
            }
            SIPCommTabbedPaneUI ui = (SIPCommTabbedPaneUI)pane.getUI();
            ui.tabScroller.scrollForward(pane.getTabPlacement());
        }
    }

    private static class SetSelectedIndexAction
    extends AbstractAction {
        private static final long serialVersionUID = 0L;

        private SetSelectedIndexAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            if (pane != null && pane.getUI() instanceof SIPCommTabbedPaneUI) {
                SIPCommTabbedPaneUI ui = (SIPCommTabbedPaneUI)pane.getUI();
                String command = e.getActionCommand();
                if (command != null && command.length() > 0) {
                    Integer index;
                    int mnemonic = e.getActionCommand().charAt(0);
                    if (mnemonic >= 97 && mnemonic <= 122) {
                        mnemonic -= 32;
                    }
                    if ((index = (Integer)ui.mnemonicToIndexMap.get(mnemonic)) != null && pane.isEnabledAt(index)) {
                        pane.setSelectedIndex(index);
                    }
                }
            }
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        private static final long serialVersionUID = 0L;

        private RequestFocusForVisibleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            SIPCommTabbedPaneUI ui = (SIPCommTabbedPaneUI)pane.getUI();
            ui.requestMyFocusForVisibleComponent();
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        private static final long serialVersionUID = 0L;

        private RequestFocusAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            pane.requestFocus();
        }
    }

    private static class PageAction
    extends AbstractAction {
        private static final long serialVersionUID = 0L;
        private final boolean up;

        public PageAction(boolean up) {
            this.up = up;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            SIPCommTabbedPaneUI ui = (SIPCommTabbedPaneUI)pane.getUI();
            int tabPlacement = pane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                ui.navigateSelectedTab(this.up ? 7 : 3);
            } else {
                ui.navigateSelectedTab(this.up ? 1 : 5);
            }
        }
    }

    private static class DirectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 0L;
        private final int direction;

        public DirectionAction(int direction) {
            this.direction = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            SIPCommTabbedPaneUI ui = (SIPCommTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(this.direction);
        }
    }
}

