/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl.packet;

import java.util.Map;
import org.jivesoftware.smack.packet.AbstractError;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.sasl.SASLError;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class SaslStreamElements {
    public static final String NAMESPACE = "urn:ietf:params:xml:ns:xmpp-sasl";

    public static class SASLFailure
    extends AbstractError
    implements Nonza {
        public static final String ELEMENT = "failure";
        private final SASLError saslError;
        private final String saslErrorString;

        public SASLFailure(String saslError) {
            this(saslError, null);
        }

        public SASLFailure(String saslError, Map<String, String> descriptiveTexts) {
            super(descriptiveTexts);
            SASLError error = SASLError.fromString(saslError);
            this.saslError = error == null ? SASLError.not_authorized : error;
            this.saslErrorString = saslError;
        }

        public SASLError getSASLError() {
            return this.saslError;
        }

        public String getSASLErrorString() {
            return this.saslErrorString;
        }

        @Override
        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement(ELEMENT).xmlnsAttribute(SaslStreamElements.NAMESPACE).rightAngleBracket();
            xml.emptyElement(this.saslErrorString);
            this.addDescriptiveTextsAndExtensions(xml);
            xml.closeElement(ELEMENT);
            return xml;
        }

        public String toString() {
            return this.toXML().toString();
        }

        @Override
        public String getNamespace() {
            return SaslStreamElements.NAMESPACE;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Success
    implements Nonza {
        public static final String ELEMENT = "success";
        private final String data;

        public Success(String data) {
            this.data = StringUtils.returnIfNotEmptyTrimmed(data);
        }

        public String getData() {
            return this.data;
        }

        @Override
        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement(ELEMENT).xmlnsAttribute(SaslStreamElements.NAMESPACE).rightAngleBracket();
            xml.optAppend(this.data);
            xml.closeElement(ELEMENT);
            return xml;
        }

        @Override
        public String getNamespace() {
            return SaslStreamElements.NAMESPACE;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Response
    implements Nonza {
        public static final String ELEMENT = "response";
        private final String authenticationText;

        public Response() {
            this.authenticationText = null;
        }

        public Response(String authenticationText) {
            this.authenticationText = StringUtils.returnIfNotEmptyTrimmed(authenticationText);
        }

        @Override
        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement(ELEMENT).xmlnsAttribute(SaslStreamElements.NAMESPACE).rightAngleBracket();
            xml.optAppend(this.authenticationText);
            xml.closeElement(ELEMENT);
            return xml;
        }

        public String getAuthenticationText() {
            return this.authenticationText;
        }

        @Override
        public String getNamespace() {
            return SaslStreamElements.NAMESPACE;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Challenge
    implements Nonza {
        public static final String ELEMENT = "challenge";
        private final String data;

        public Challenge(String data) {
            this.data = StringUtils.returnIfNotEmptyTrimmed(data);
        }

        @Override
        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder().halfOpenElement(ELEMENT).xmlnsAttribute(SaslStreamElements.NAMESPACE).rightAngleBracket();
            xml.optAppend(this.data);
            xml.closeElement(ELEMENT);
            return xml;
        }

        @Override
        public String getNamespace() {
            return SaslStreamElements.NAMESPACE;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class AuthMechanism
    implements Nonza {
        public static final String ELEMENT = "auth";
        private final String mechanism;
        private final String authenticationText;

        public AuthMechanism(String mechanism, String authenticationText) {
            this.mechanism = Objects.requireNonNull(mechanism, "SASL mechanism shouldn't be null.");
            this.authenticationText = StringUtils.requireNotNullOrEmpty(authenticationText, "SASL authenticationText must not be null or empty (RFC6120 6.4.2)");
        }

        @Override
        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement(ELEMENT).xmlnsAttribute(SaslStreamElements.NAMESPACE).attribute("mechanism", this.mechanism).rightAngleBracket();
            xml.optAppend(this.authenticationText);
            xml.closeElement(ELEMENT);
            return xml;
        }

        public String getMechanism() {
            return this.mechanism;
        }

        public String getAuthenticationText() {
            return this.authenticationText;
        }

        @Override
        public String getNamespace() {
            return SaslStreamElements.NAMESPACE;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }
}

