/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.jivesoftware.smackx.iot.control.ThingControlRequest;
import org.jivesoftware.smackx.iot.data.ThingMomentaryReadOutRequest;
import org.jivesoftware.smackx.iot.discovery.element.Tag;
import org.jivesoftware.smackx.iot.element.NodeInfo;

public final class Thing {
    private final HashMap<String, Tag> metaTags;
    private final boolean selfOwned;
    private final NodeInfo nodeInfo;
    private final ThingMomentaryReadOutRequest momentaryReadOutRequestHandler;
    private final ThingControlRequest controlRequestHandler;
    private String toStringCache;

    private Thing(Builder builder) {
        this.metaTags = builder.metaTags;
        this.selfOwned = builder.selfOwned;
        this.nodeInfo = builder.nodeInfo;
        this.momentaryReadOutRequestHandler = builder.momentaryReadOutRequest;
        this.controlRequestHandler = builder.controlRequest;
    }

    public Collection<Tag> getMetaTags() {
        return this.metaTags.values();
    }

    public boolean isSelfOwened() {
        return this.selfOwned;
    }

    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public String getNodeId() {
        return this.nodeInfo.getNodeId();
    }

    public String getSourceId() {
        return this.nodeInfo.getSourceId();
    }

    public String getCacheType() {
        return this.nodeInfo.getCacheType();
    }

    public ThingMomentaryReadOutRequest getMomentaryReadOutRequestHandler() {
        return this.momentaryReadOutRequestHandler;
    }

    public ThingControlRequest getControlRequestHandler() {
        return this.controlRequestHandler;
    }

    public String toString() {
        if (this.toStringCache == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Thing " + this.nodeInfo + " [");
            Iterator<Tag> it = this.metaTags.values().iterator();
            while (it.hasNext()) {
                Tag tag = it.next();
                sb.append(tag);
                if (!it.hasNext()) continue;
                sb.append(' ');
            }
            sb.append(']');
            this.toStringCache = sb.toString();
        }
        return this.toStringCache;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private HashMap<String, Tag> metaTags = new HashMap();
        private boolean selfOwned;
        private NodeInfo nodeInfo = NodeInfo.EMPTY;
        private ThingMomentaryReadOutRequest momentaryReadOutRequest;
        private ThingControlRequest controlRequest;

        public Builder setSerialNumber(String sn) {
            String name = "SN";
            Tag tag = new Tag("SN", Tag.Type.str, sn);
            this.metaTags.put("SN", tag);
            return this;
        }

        public Builder setKey(String key) {
            String name = "KEY";
            Tag tag = new Tag("KEY", Tag.Type.str, key);
            this.metaTags.put("KEY", tag);
            return this;
        }

        public Builder setManufacturer(String manufacturer) {
            String name = "MAN";
            Tag tag = new Tag("MAN", Tag.Type.str, manufacturer);
            this.metaTags.put("MAN", tag);
            return this;
        }

        public Builder setModel(String model) {
            String name = "MODEL";
            Tag tag = new Tag("MODEL", Tag.Type.str, model);
            this.metaTags.put("MODEL", tag);
            return this;
        }

        public Builder setVersion(String version) {
            String name = "V";
            Tag tag = new Tag("V", Tag.Type.num, version);
            this.metaTags.put("V", tag);
            return this;
        }

        public Builder setMomentaryReadOutRequestHandler(ThingMomentaryReadOutRequest momentaryReadOutRequestHandler) {
            this.momentaryReadOutRequest = momentaryReadOutRequestHandler;
            return this;
        }

        public Builder setControlRequestHandler(ThingControlRequest controlRequest) {
            this.controlRequest = controlRequest;
            return this;
        }

        public Thing build() {
            return new Thing(this);
        }
    }
}

