/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot.discovery.element;

import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class Tag
implements NamedElement {
    private final String name;
    private final Type type;
    private final String value;

    public Tag(String name, Type type, String value) {
        this.name = (String)StringUtils.requireNotNullOrEmpty((CharSequence)name, (String)"name must not be null or empty");
        this.type = (Type)((Object)Objects.requireNonNull((Object)((Object)type)));
        this.value = (String)StringUtils.requireNotNullOrEmpty((CharSequence)value, (String)"value must not be null or empty");
        if (this.name.length() > 32) {
            throw new IllegalArgumentException("Meta Tag names must not be longer then 32 characters (XEP-0347 \u00a7 5.2");
        }
        if (this.type == Type.str && this.value.length() > 128) {
            throw new IllegalArgumentException("Meta Tag string values must not be longer then 128 characters (XEP-0347 \u00a7 5.2");
        }
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public XmlStringBuilder toXML() {
        XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
        xml.attribute("name", this.name);
        xml.attribute("value", this.value);
        xml.closeEmptyElement();
        return xml;
    }

    public String getElementName() {
        return this.getType().toString();
    }

    public String toString() {
        return this.name + '(' + (Object)((Object)this.type) + "):" + this.value;
    }

    public static enum Type {
        str,
        num;

    }
}

