/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muclight;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.IQReplyFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.muclight.MultiUserChatLight;
import org.jivesoftware.smackx.muclight.element.MUCLightBlockingIQ;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;

public final class MultiUserChatLightManager
extends Manager {
    private static final Map<XMPPConnection, MultiUserChatLightManager> INSTANCES = new WeakHashMap<XMPPConnection, MultiUserChatLightManager>();
    private final Map<EntityBareJid, WeakReference<MultiUserChatLight>> multiUserChatLights = new HashMap<EntityBareJid, WeakReference<MultiUserChatLight>>();

    public static synchronized MultiUserChatLightManager getInstanceFor(XMPPConnection connection) {
        MultiUserChatLightManager multiUserChatLightManager = INSTANCES.get(connection);
        if (multiUserChatLightManager == null) {
            multiUserChatLightManager = new MultiUserChatLightManager(connection);
            INSTANCES.put(connection, multiUserChatLightManager);
        }
        return multiUserChatLightManager;
    }

    private MultiUserChatLightManager(XMPPConnection connection) {
        super(connection);
    }

    public synchronized MultiUserChatLight getMultiUserChatLight(EntityBareJid jid) {
        WeakReference<MultiUserChatLight> weakRefMultiUserChat = this.multiUserChatLights.get(jid);
        if (weakRefMultiUserChat == null) {
            return this.createNewMucLightAndAddToMap(jid);
        }
        MultiUserChatLight multiUserChatLight = (MultiUserChatLight)weakRefMultiUserChat.get();
        if (multiUserChatLight == null) {
            return this.createNewMucLightAndAddToMap(jid);
        }
        return multiUserChatLight;
    }

    private MultiUserChatLight createNewMucLightAndAddToMap(EntityBareJid jid) {
        MultiUserChatLight multiUserChatLight = new MultiUserChatLight(this.connection(), (EntityJid)jid);
        this.multiUserChatLights.put(jid, new WeakReference<MultiUserChatLight>(multiUserChatLight));
        return multiUserChatLight;
    }

    public boolean isFeatureSupported(DomainBareJid mucLightService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection()).discoverInfo((Jid)mucLightService).containsFeature((CharSequence)"urn:xmpp:muclight:0");
    }

    public List<Jid> getOccupiedRooms(DomainBareJid mucLightService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverItems result = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection()).discoverItems((Jid)mucLightService);
        List items = result.getItems();
        ArrayList<Jid> answer = new ArrayList<Jid>(items.size());
        for (DiscoverItems.Item item : items) {
            Jid mucLight = item.getEntityID();
            answer.add(mucLight);
        }
        return answer;
    }

    public List<DomainBareJid> getLocalServices() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection());
        return sdm.findServices("urn:xmpp:muclight:0", false, false);
    }

    public List<Jid> getUsersAndRoomsBlocked(DomainBareJid mucLightService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightBlockingIQ muclIghtBlockingIQResult = this.getBlockingList(mucLightService);
        ArrayList<Jid> jids = new ArrayList<Jid>();
        if (muclIghtBlockingIQResult.getRooms() != null) {
            jids.addAll(muclIghtBlockingIQResult.getRooms().keySet());
        }
        if (muclIghtBlockingIQResult.getUsers() != null) {
            jids.addAll(muclIghtBlockingIQResult.getUsers().keySet());
        }
        return jids;
    }

    public List<Jid> getRoomsBlocked(DomainBareJid mucLightService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightBlockingIQ mucLightBlockingIQResult = this.getBlockingList(mucLightService);
        ArrayList<Jid> jids = new ArrayList<Jid>();
        if (mucLightBlockingIQResult.getRooms() != null) {
            jids.addAll(mucLightBlockingIQResult.getRooms().keySet());
        }
        return jids;
    }

    public List<Jid> getUsersBlocked(DomainBareJid mucLightService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightBlockingIQ mucLightBlockingIQResult = this.getBlockingList(mucLightService);
        ArrayList<Jid> jids = new ArrayList<Jid>();
        if (mucLightBlockingIQResult.getUsers() != null) {
            jids.addAll(mucLightBlockingIQResult.getUsers().keySet());
        }
        return jids;
    }

    private MUCLightBlockingIQ getBlockingList(DomainBareJid mucLightService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, SmackException.NotConnectedException {
        MUCLightBlockingIQ mucLightBlockingIQ = new MUCLightBlockingIQ(null, null);
        mucLightBlockingIQ.setType(IQ.Type.get);
        mucLightBlockingIQ.setTo((Jid)mucLightService);
        IQReplyFilter responseFilter = new IQReplyFilter((IQ)mucLightBlockingIQ, this.connection());
        IQ responseIq = (IQ)this.connection().createStanzaCollectorAndSend((StanzaFilter)responseFilter, (Stanza)mucLightBlockingIQ).nextResultOrThrow();
        MUCLightBlockingIQ mucLightBlockingIQResult = (MUCLightBlockingIQ)responseIq;
        return mucLightBlockingIQResult;
    }

    public void blockRoom(DomainBareJid mucLightService, Jid roomJid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        HashMap<Jid, Boolean> rooms = new HashMap<Jid, Boolean>();
        rooms.put(roomJid, false);
        this.sendBlockRooms(mucLightService, rooms);
    }

    public void blockRooms(DomainBareJid mucLightService, List<Jid> roomsJids) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        HashMap<Jid, Boolean> rooms = new HashMap<Jid, Boolean>();
        for (Jid jid : roomsJids) {
            rooms.put(jid, false);
        }
        this.sendBlockRooms(mucLightService, rooms);
    }

    private void sendBlockRooms(DomainBareJid mucLightService, HashMap<Jid, Boolean> rooms) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, SmackException.NotConnectedException {
        MUCLightBlockingIQ mucLightBlockingIQ = new MUCLightBlockingIQ(rooms, null);
        mucLightBlockingIQ.setType(IQ.Type.set);
        mucLightBlockingIQ.setTo((Jid)mucLightService);
        this.connection().createStanzaCollectorAndSend((IQ)mucLightBlockingIQ).nextResultOrThrow();
    }

    public void blockUser(DomainBareJid mucLightService, Jid userJid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        HashMap<Jid, Boolean> users = new HashMap<Jid, Boolean>();
        users.put(userJid, false);
        this.sendBlockUsers(mucLightService, users);
    }

    public void blockUsers(DomainBareJid mucLightService, List<Jid> usersJids) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        HashMap<Jid, Boolean> users = new HashMap<Jid, Boolean>();
        for (Jid jid : usersJids) {
            users.put(jid, false);
        }
        this.sendBlockUsers(mucLightService, users);
    }

    private void sendBlockUsers(DomainBareJid mucLightService, HashMap<Jid, Boolean> users) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, SmackException.NotConnectedException {
        MUCLightBlockingIQ mucLightBlockingIQ = new MUCLightBlockingIQ(null, users);
        mucLightBlockingIQ.setType(IQ.Type.set);
        mucLightBlockingIQ.setTo((Jid)mucLightService);
        this.connection().createStanzaCollectorAndSend((IQ)mucLightBlockingIQ).nextResultOrThrow();
    }

    public void unblockRoom(DomainBareJid mucLightService, Jid roomJid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        HashMap<Jid, Boolean> rooms = new HashMap<Jid, Boolean>();
        rooms.put(roomJid, true);
        this.sendUnblockRooms(mucLightService, rooms);
    }

    public void unblockRooms(DomainBareJid mucLightService, List<Jid> roomsJids) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        HashMap<Jid, Boolean> rooms = new HashMap<Jid, Boolean>();
        for (Jid jid : roomsJids) {
            rooms.put(jid, true);
        }
        this.sendUnblockRooms(mucLightService, rooms);
    }

    private void sendUnblockRooms(DomainBareJid mucLightService, HashMap<Jid, Boolean> rooms) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, SmackException.NotConnectedException {
        MUCLightBlockingIQ mucLightBlockingIQ = new MUCLightBlockingIQ(rooms, null);
        mucLightBlockingIQ.setType(IQ.Type.set);
        mucLightBlockingIQ.setTo((Jid)mucLightService);
        this.connection().createStanzaCollectorAndSend((IQ)mucLightBlockingIQ).nextResultOrThrow();
    }

    public void unblockUser(DomainBareJid mucLightService, Jid userJid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        HashMap<Jid, Boolean> users = new HashMap<Jid, Boolean>();
        users.put(userJid, true);
        this.sendUnblockUsers(mucLightService, users);
    }

    public void unblockUsers(DomainBareJid mucLightService, List<Jid> usersJids) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        HashMap<Jid, Boolean> users = new HashMap<Jid, Boolean>();
        for (Jid jid : usersJids) {
            users.put(jid, true);
        }
        this.sendUnblockUsers(mucLightService, users);
    }

    private void sendUnblockUsers(DomainBareJid mucLightService, HashMap<Jid, Boolean> users) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, SmackException.NotConnectedException {
        MUCLightBlockingIQ mucLightBlockingIQ = new MUCLightBlockingIQ(null, users);
        mucLightBlockingIQ.setType(IQ.Type.set);
        mucLightBlockingIQ.setTo((Jid)mucLightService);
        this.connection().createStanzaCollectorAndSend((IQ)mucLightBlockingIQ).nextResultOrThrow();
    }
}

