/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muclight.element;

import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.muclight.MUCLightAffiliation;
import org.jivesoftware.smackx.muclight.MUCLightRoomConfiguration;
import org.jxmpp.jid.Jid;

public abstract class MUCLightElements {

    public static class BlockingElement
    implements Element {
        private Jid jid;
        private Boolean allow;
        private Boolean isRoom;

        public BlockingElement(Jid jid, Boolean allow, Boolean isRoom) {
            this.jid = jid;
            this.allow = allow;
            this.isRoom = isRoom;
        }

        public CharSequence toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            String tag = this.isRoom != false ? "room" : "user";
            xml.halfOpenElement(tag);
            String action = this.allow != false ? "allow" : "deny";
            xml.attribute("action", action);
            xml.rightAngleBracket();
            xml.escape((CharSequence)this.jid);
            xml.closeElement(tag);
            return xml;
        }
    }

    public static class UserWithAffiliationElement
    implements Element {
        private Jid user;
        private MUCLightAffiliation affiliation;

        public UserWithAffiliationElement(Jid user, MUCLightAffiliation affiliation) {
            this.user = user;
            this.affiliation = affiliation;
        }

        public CharSequence toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement("user");
            xml.attribute("affiliation", (Enum)this.affiliation);
            xml.rightAngleBracket();
            xml.escape((CharSequence)this.user);
            xml.closeElement("user");
            return xml;
        }
    }

    public static class OccupantsElement
    implements Element {
        private HashMap<Jid, MUCLightAffiliation> occupants;

        public OccupantsElement(HashMap<Jid, MUCLightAffiliation> occupants) {
            this.occupants = occupants;
        }

        public CharSequence toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.openElement("occupants");
            for (Map.Entry<Jid, MUCLightAffiliation> pair : this.occupants.entrySet()) {
                xml.element((Element)new UserWithAffiliationElement(pair.getKey(), pair.getValue()));
            }
            xml.closeElement("occupants");
            return xml;
        }
    }

    public static class ConfigurationElement
    implements Element {
        private MUCLightRoomConfiguration configuration;

        public ConfigurationElement(MUCLightRoomConfiguration configuration) {
            this.configuration = configuration;
        }

        public CharSequence toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.openElement("configuration");
            xml.element("roomname", this.configuration.getRoomName());
            xml.optElement("subject", this.configuration.getSubject());
            if (this.configuration.getCustomConfigs() != null) {
                for (Map.Entry<String, String> pair : this.configuration.getCustomConfigs().entrySet()) {
                    xml.element(pair.getKey(), pair.getValue());
                }
            }
            xml.closeElement("configuration");
            return xml;
        }
    }

    public static class ConfigurationsChangeExtension
    implements ExtensionElement {
        public static final String ELEMENT = "x";
        public static final String NAMESPACE = "urn:xmpp:muclight:0#configuration";
        private final String prevVersion;
        private final String version;
        private final String roomName;
        private final String subject;
        private final HashMap<String, String> customConfigs;

        public ConfigurationsChangeExtension(String prevVersion, String version, String roomName, String subject, HashMap<String, String> customConfigs) {
            this.prevVersion = prevVersion;
            this.version = version;
            this.roomName = roomName;
            this.subject = subject;
            this.customConfigs = customConfigs;
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return NAMESPACE;
        }

        public String getPrevVersion() {
            return this.prevVersion;
        }

        public String getVersion() {
            return this.version;
        }

        public String getRoomName() {
            return this.roomName;
        }

        public String getSubject() {
            return this.subject;
        }

        public HashMap<String, String> getCustomConfigs() {
            return this.customConfigs;
        }

        public CharSequence toXML() {
            XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this);
            xml.rightAngleBracket();
            xml.optElement("prev-version", this.prevVersion);
            xml.optElement("version", this.version);
            xml.optElement("roomname", this.roomName);
            xml.optElement("subject", this.subject);
            if (this.customConfigs != null) {
                for (Map.Entry<String, String> pair : this.customConfigs.entrySet()) {
                    xml.element(pair.getKey(), pair.getValue());
                }
            }
            xml.closeElement((NamedElement)this);
            return xml;
        }

        public static ConfigurationsChangeExtension from(Message message) {
            return (ConfigurationsChangeExtension)message.getExtension(ELEMENT, NAMESPACE);
        }
    }

    public static class AffiliationsChangeExtension
    implements ExtensionElement {
        public static final String ELEMENT = "x";
        public static final String NAMESPACE = "urn:xmpp:muclight:0#affiliations";
        private final HashMap<Jid, MUCLightAffiliation> affiliations;
        private final String prevVersion;
        private final String version;

        public AffiliationsChangeExtension(HashMap<Jid, MUCLightAffiliation> affiliations, String prevVersion, String version) {
            this.affiliations = affiliations;
            this.prevVersion = prevVersion;
            this.version = version;
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return NAMESPACE;
        }

        public HashMap<Jid, MUCLightAffiliation> getAffiliations() {
            return this.affiliations;
        }

        public String getPrevVersion() {
            return this.prevVersion;
        }

        public String getVersion() {
            return this.version;
        }

        public CharSequence toXML() {
            XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this);
            xml.rightAngleBracket();
            xml.optElement("prev-version", this.prevVersion);
            xml.optElement("version", this.version);
            for (Map.Entry<Jid, MUCLightAffiliation> pair : this.affiliations.entrySet()) {
                xml.element((Element)new UserWithAffiliationElement(pair.getKey(), pair.getValue()));
            }
            xml.closeElement((NamedElement)this);
            return xml;
        }

        public static AffiliationsChangeExtension from(Message message) {
            return (AffiliationsChangeExtension)message.getExtension(ELEMENT, NAMESPACE);
        }
    }
}

