/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muclight.provider;

import java.io.IOException;
import java.util.HashMap;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.muclight.element.MUCLightBlockingIQ;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MUCLightBlockingIQProvider
extends IQProvider<MUCLightBlockingIQ> {
    public MUCLightBlockingIQ parse(XmlPullParser parser, int initialDepth) throws Exception {
        HashMap<Jid, Boolean> rooms = null;
        HashMap<Jid, Boolean> users = null;
        while (true) {
            int eventType;
            if ((eventType = parser.next()) == 2) {
                if (parser.getName().equals("room")) {
                    rooms = this.parseBlocking(parser, rooms);
                }
                if (!parser.getName().equals("user")) continue;
                users = this.parseBlocking(parser, users);
                continue;
            }
            if (eventType == 3 && parser.getDepth() == initialDepth) break;
        }
        MUCLightBlockingIQ mucLightBlockingIQ = new MUCLightBlockingIQ(rooms, users);
        mucLightBlockingIQ.setType(IQ.Type.result);
        return mucLightBlockingIQ;
    }

    private HashMap<Jid, Boolean> parseBlocking(XmlPullParser parser, HashMap<Jid, Boolean> map) throws XmppStringprepException, XmlPullParserException, IOException {
        String action;
        if (map == null) {
            map = new HashMap();
        }
        if ((action = parser.getAttributeValue("", "action")).equals("deny")) {
            map.put(JidCreate.from((String)parser.nextText()), false);
        } else if (action.equals("allow")) {
            map.put(JidCreate.from((String)parser.nextText()), true);
        }
        return map;
    }
}

