/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.ice4j.ice.Agent;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.CandidatePairState;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.CheckList;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.NominationStrategy;
import org.ice4j.ice.RelayedCandidate;

public class DefaultNominator
implements PropertyChangeListener {
    private static final Logger classLogger = Logger.getLogger(DefaultNominator.class.getName());
    private final Agent parentAgent;
    private NominationStrategy strategy = NominationStrategy.NOMINATE_FIRST_VALID;
    private final Map<String, TimerTask> validatedCandidates = new HashMap<String, TimerTask>();
    private org.ice4j.util.Logger logger;

    public DefaultNominator(Agent parentAgent) {
        this.parentAgent = parentAgent;
        this.logger = new org.ice4j.util.Logger(classLogger, parentAgent.getLogger());
        parentAgent.addStateChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        if ("IceProcessingState".equals(propertyName)) {
            if (ev.getNewValue() != IceProcessingState.RUNNING) {
                return;
            }
            for (IceMediaStream stream : this.parentAgent.getStreams()) {
                stream.addPairChangeListener(this);
                stream.getCheckList().addStateChangeListener(this);
            }
        }
        if (!this.parentAgent.isControlling() || this.strategy == NominationStrategy.NONE) {
            return;
        }
        if (ev.getSource() instanceof CandidatePair) {
            if ("PairConsentFreshnessChanged".equals(propertyName)) {
                return;
            }
            CandidatePair validPair = (CandidatePair)ev.getSource();
            if (validPair.getParentComponent().getSelectedPair() != null) {
                this.logger.fine("Keep-alive for pair: " + validPair.toShortString());
                return;
            }
        }
        if (this.strategy == NominationStrategy.NOMINATE_FIRST_VALID) {
            this.strategyNominateFirstValid(ev);
        } else if (this.strategy == NominationStrategy.NOMINATE_HIGHEST_PRIO) {
            this.strategyNominateHighestPrio(ev);
        } else if (this.strategy == NominationStrategy.NOMINATE_FIRST_HOST_OR_REFLEXIVE_VALID) {
            this.strategyNominateFirstHostOrReflexiveValid(ev);
        }
    }

    private void strategyNominateFirstValid(PropertyChangeEvent evt) {
        if ("PairValidated".equals(evt.getPropertyName())) {
            CandidatePair validPair = (CandidatePair)evt.getSource();
            this.logger.info("Nominate (first valid): " + validPair.toShortString() + ". Local ufrag " + this.parentAgent.getLocalUfrag());
            this.parentAgent.nominate(validPair);
        }
    }

    private void strategyNominateHighestPrio(PropertyChangeEvent ev) {
        String pname = ev.getPropertyName();
        if ("PairValidated".equals(pname) || "PairStateChanged".equals(pname) && ev.getNewValue() == CandidatePairState.FAILED) {
            CandidatePair validPair = (CandidatePair)ev.getSource();
            Component parentComponent = validPair.getParentComponent();
            IceMediaStream parentStream = parentComponent.getParentStream();
            CheckList parentCheckList = parentStream.getCheckList();
            if (!parentCheckList.allChecksCompleted()) {
                return;
            }
            for (Component component : parentStream.getComponents()) {
                CandidatePair pair = parentStream.getValidPair(component);
                if (pair == null) continue;
                this.logger.info("Nominate (highest priority): " + validPair.toShortString());
                this.parentAgent.nominate(pair);
            }
        }
    }

    public void setStrategy(NominationStrategy strategy) {
        this.strategy = strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void strategyNominateFirstHostOrReflexiveValid(PropertyChangeEvent evt) {
        if ("PairValidated".equals(evt.getPropertyName())) {
            CandidatePair validPair = (CandidatePair)evt.getSource();
            Component component = validPair.getParentComponent();
            LocalCandidate localCandidate = validPair.getLocalCandidate();
            boolean isRelayed = localCandidate instanceof RelayedCandidate || localCandidate.getType().equals((Object)CandidateType.RELAYED_CANDIDATE) || validPair.getRemoteCandidate().getType().equals((Object)CandidateType.RELAYED_CANDIDATE);
            boolean nominate = false;
            Map<String, TimerTask> map = this.validatedCandidates;
            synchronized (map) {
                TimerTask task = this.validatedCandidates.get(component.toShortString());
                if (isRelayed && task == null) {
                    Timer timer = new Timer();
                    task = new RelayedCandidateTask(validPair);
                    this.logger.info("Wait timeout to nominate relayed candidate");
                    timer.schedule(task, 0L);
                    this.validatedCandidates.put(component.toShortString(), task);
                } else if (!isRelayed) {
                    if (task != null) {
                        task.cancel();
                        this.logger.info("Found a better candidate pair to nominate for " + component.toShortString());
                    }
                    this.logger.info("Nominate (first highest valid): " + validPair.toShortString());
                    nominate = true;
                }
            }
            if (nominate) {
                this.parentAgent.nominate(validPair);
            }
        }
    }

    private class RelayedCandidateTask
    extends TimerTask
    implements PropertyChangeListener {
        private static final int WAIT_TIME = 800;
        private final CandidatePair pair;
        private boolean cancelled = false;

        public RelayedCandidateTask(CandidatePair pair) {
            this.pair = pair;
            pair.getParentComponent().getParentStream().getCheckList().addChecksListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"CheckListChecks".equals(evt.getPropertyName())) {
                return;
            }
            CheckList checkList = (CheckList)evt.getSource();
            boolean allFailed = true;
            CheckList checkList2 = checkList;
            synchronized (checkList2) {
                for (CandidatePair c : checkList) {
                    if (c == this.pair || c.getState() == CandidatePairState.FAILED) continue;
                    allFailed = false;
                    break;
                }
            }
            if (allFailed && !this.pair.isNominated()) {
                this.cancel();
                DefaultNominator.this.logger.info("Nominate (first highest valid): " + this.pair.toShortString());
                DefaultNominator.this.parentAgent.nominate(this.pair);
            }
        }

        @Override
        public boolean cancel() {
            this.cancelled = true;
            return super.cancel();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException e) {
                this.cancelled = true;
            }
            Component component = this.pair.getParentComponent();
            component.getParentStream().getCheckList().removeChecksListener(this);
            DefaultNominator.this.validatedCandidates.remove(component.toShortString());
            if (this.cancelled) {
                return;
            }
            DefaultNominator.this.logger.info("Nominate (first highest valid): " + this.pair.toShortString());
            DefaultNominator.this.parentAgent.nominate(this.pair);
        }
    }
}

