/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509ExtendedTrustManager;
import net.java.sip.communicator.impl.protocol.jabber.JabberLoginStrategy;
import net.java.sip.communicator.service.certificate.CertificateService;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.UserCredentials;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jxmpp.jid.EntityFullJid;

public class AnonymousLoginStrategy
implements JabberLoginStrategy {
    private final UserCredentials credentials;
    private ConnectionConfiguration.Builder ccBuilder;

    public AnonymousLoginStrategy(String login, ConnectionConfiguration.Builder ccBuilder) {
        this.ccBuilder = ccBuilder;
        this.credentials = new UserCredentials();
        this.credentials.setUserName(login);
        this.credentials.setPassword(new char[0]);
    }

    @Override
    public UserCredentials prepareLogin(SecurityAuthority authority, int reasonCode) {
        return this.credentials;
    }

    @Override
    public boolean loginPreparationSuccessful() {
        this.ccBuilder.performSaslAnonymousAuthentication();
        return true;
    }

    @Override
    public boolean login(AbstractXMPPConnection connection, EntityFullJid jid) throws XMPPException, InterruptedException, IOException, SmackException {
        connection.login();
        return true;
    }

    @Override
    public boolean isTlsRequired() {
        return false;
    }

    @Override
    public SSLContext createSslContext(CertificateService certificateService, X509ExtendedTrustManager trustManager) throws GeneralSecurityException {
        return certificateService.getSSLContext(trustManager);
    }

    @Override
    public ConnectionConfiguration.Builder getConnectionConfigurationBuilder() {
        return this.ccBuilder;
    }
}

