/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509ExtendedTrustManager;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.JabberLoginStrategy;
import net.java.sip.communicator.service.certificate.CertificateService;
import net.java.sip.communicator.service.protocol.AbstractProtocolProviderService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.UserCredentials;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jxmpp.jid.EntityFullJid;

public class LoginByPasswordStrategy
implements JabberLoginStrategy {
    private final AbstractProtocolProviderService protocolProvider;
    private final AccountID accountID;
    private ConnectionConfiguration.Builder ccBuilder;
    private String password;

    public LoginByPasswordStrategy(AbstractProtocolProviderService protocolProvider, AccountID accountID, ConnectionConfiguration.Builder ccBuilder) {
        this.protocolProvider = protocolProvider;
        this.accountID = accountID;
        this.ccBuilder = ccBuilder;
    }

    @Override
    public UserCredentials prepareLogin(SecurityAuthority authority, int reasonCode) {
        return this.loadPassword(authority, reasonCode);
    }

    @Override
    public boolean loginPreparationSuccessful() {
        return this.password != null;
    }

    @Override
    public boolean login(AbstractXMPPConnection connection, EntityFullJid jid) throws XMPPException, InterruptedException, IOException, SmackException {
        connection.login((CharSequence)jid.getLocalpart(), this.password, jid.getResourceOrEmpty());
        return true;
    }

    @Override
    public boolean isTlsRequired() {
        return !this.accountID.getAccountPropertyBoolean((Object)"ALLOW_NON_SECURE", false);
    }

    @Override
    public SSLContext createSslContext(CertificateService cs, X509ExtendedTrustManager trustManager) throws GeneralSecurityException {
        return cs.getSSLContext(trustManager);
    }

    private UserCredentials loadPassword(SecurityAuthority authority, int reasonCode) {
        UserCredentials cachedCredentials = null;
        this.password = JabberActivator.getProtocolProviderFactory().loadPassword(this.accountID);
        if (this.password == null) {
            UserCredentials credentials = new UserCredentials();
            credentials.setUserName(this.accountID.getUserID());
            credentials = authority.obtainCredentials(this.accountID.getDisplayName(), credentials, reasonCode);
            if (credentials == null) {
                this.protocolProvider.fireRegistrationStateChanged(this.protocolProvider.getRegistrationState(), RegistrationState.UNREGISTERED, 0, "No credentials provided");
                return null;
            }
            char[] pass = credentials.getPassword();
            if (pass == null) {
                this.protocolProvider.fireRegistrationStateChanged(this.protocolProvider.getRegistrationState(), RegistrationState.UNREGISTERED, 0, "No password entered");
                return null;
            }
            this.password = new String(pass);
            if (credentials.isPasswordPersistent()) {
                JabberActivator.getProtocolProviderFactory().storePassword(this.accountID, this.password);
            } else {
                cachedCredentials = credentials;
            }
        }
        return cachedCredentials;
    }

    @Override
    public ConnectionConfiguration.Builder getConnectionConfigurationBuilder() {
        return this.ccBuilder;
    }
}

