/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.io.File;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ThumbnailedFile;
import net.java.sip.communicator.service.protocol.AbstractFileTransfer;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.util.Logger;
import org.jitsi.xmpp.extensions.thumbnail.Thumbnail;
import org.jitsi.xmpp.extensions.thumbnail.ThumbnailFile;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.bob.BoBData;
import org.jivesoftware.smackx.bob.BoBHash;
import org.jivesoftware.smackx.bob.BoBInfo;
import org.jivesoftware.smackx.bob.BoBManager;
import org.jivesoftware.smackx.filetransfer.OutgoingFileTransfer;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jxmpp.stringprep.XmppStringprepException;

public class OutgoingFileTransferJabberImpl
extends AbstractFileTransfer
implements StanzaListener {
    private final Logger logger = Logger.getLogger(OutgoingFileTransferJabberImpl.class);
    private final String id;
    private final Contact receiver;
    private final File file;
    private Thumbnail thumbnailElement;
    private final OutgoingFileTransfer jabberTransfer;
    private final ProtocolProviderServiceJabberImpl protocolProvider;
    private BoBInfo bobInfo;

    public OutgoingFileTransferJabberImpl(Contact receiver, File file, OutgoingFileTransfer jabberTransfer, ProtocolProviderServiceJabberImpl protocolProvider) {
        this.receiver = receiver;
        this.file = file;
        this.jabberTransfer = jabberTransfer;
        this.protocolProvider = protocolProvider;
        this.id = String.valueOf(System.currentTimeMillis()) + String.valueOf(((Object)((Object)this)).hashCode());
        if (file instanceof ThumbnailedFile && ((ThumbnailedFile)file).getThumbnailData() != null && ((ThumbnailedFile)file).getThumbnailData().length > 0) {
            try {
                if (protocolProvider.isFeatureListSupported(protocolProvider.getFullJid(receiver), "urn:xmpp:thumbs:0", "urn:xmpp:bob")) {
                    protocolProvider.getConnection().addPacketInterceptor((StanzaListener)this, (StanzaFilter)new AndFilter(new StanzaFilter[]{IQTypeFilter.SET, new StanzaTypeFilter(StreamInitiation.class)}));
                }
            }
            catch (XmppStringprepException e) {
                e.printStackTrace();
            }
        }
    }

    public void cancel() {
        this.jabberTransfer.cancel();
    }

    public long getTransferedBytes() {
        return this.jabberTransfer.getBytesSent();
    }

    public int getDirection() {
        return 2;
    }

    public File getLocalFile() {
        return this.file;
    }

    public Contact getContact() {
        return this.receiver;
    }

    public String getID() {
        return this.id;
    }

    public void removeThumbnailHandler() {
        if (this.bobInfo == null) {
            return;
        }
        BoBManager bobManager = BoBManager.getInstanceFor((XMPPConnection)this.protocolProvider.getConnection());
        for (BoBHash hash : this.bobInfo.getHashes()) {
            bobManager.removeBoB(hash);
        }
    }

    public void processStanza(Stanza packet) {
        if (!(this.file instanceof ThumbnailedFile)) {
            return;
        }
        this.logger.debug((Object)"File transfer packet intercepted to add thumbnail");
        StreamInitiation fileTransferPacket = (StreamInitiation)packet;
        ThumbnailedFile thumbnailedFile = (ThumbnailedFile)this.file;
        if (this.jabberTransfer.getStreamID().equals(fileTransferPacket.getSessionID())) {
            StreamInitiation.File file = fileTransferPacket.getFile();
            BoBData bobData = new BoBData(thumbnailedFile.getThumbnailMimeType(), thumbnailedFile.getThumbnailData());
            BoBManager bobManager = BoBManager.getInstanceFor((XMPPConnection)this.protocolProvider.getConnection());
            this.bobInfo = bobManager.addBoB(bobData);
            this.thumbnailElement = new Thumbnail(thumbnailedFile.getThumbnailData(), thumbnailedFile.getThumbnailMimeType(), thumbnailedFile.getThumbnailWidth(), thumbnailedFile.getThumbnailHeight());
            ThumbnailFile fileElement = new ThumbnailFile(file, this.thumbnailElement);
            fileTransferPacket.setFile((StreamInitiation.File)fileElement);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("The file transfer packet with thumbnail: " + fileTransferPacket.toXML()));
            }
        }
        this.protocolProvider.getConnection().removePacketInterceptor((StanzaListener)this);
    }
}

