/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.Hashtable;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.JabberAccountIDImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.jabber.JabberAccountID;
import net.java.sip.communicator.util.Logger;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Domainpart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ProtocolProviderFactoryJabberImpl
extends ProtocolProviderFactory {
    private static final Logger logger = Logger.getLogger(ProtocolProviderFactoryJabberImpl.class);
    public static final String IS_USE_JINGLE_NODES = "JINGLE_NODES_ENABLED";

    protected ProtocolProviderFactoryJabberImpl() {
        super(JabberActivator.getBundleContext(), "Jabber");
    }

    protected void storeAccount(AccountID accountID) {
        super.storeAccount(accountID);
    }

    public AccountID installAccount(String userIDStr, Map<String, String> accountProperties) {
        Jid jid;
        BundleContext context = JabberActivator.getBundleContext();
        if (context == null) {
            throw new NullPointerException("The specified BundleContext was null");
        }
        if (userIDStr == null) {
            throw new NullPointerException("The specified AccountID was null");
        }
        if (accountProperties == null) {
            throw new NullPointerException("The specified property map was null");
        }
        try {
            jid = JidCreate.from((String)userIDStr);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException("User ID is not a valid JID");
        }
        accountProperties.put("USER_ID", userIDStr);
        if (accountProperties.get("SERVER_ADDRESS") == null) {
            Domainpart serverAddress = jid.getDomain();
            if (serverAddress != null) {
                accountProperties.put("SERVER_ADDRESS", serverAddress.toString());
            } else {
                throw new IllegalArgumentException("Should specify a server for user name " + userIDStr + ".");
            }
        }
        accountProperties.putIfAbsent("SERVER_PORT", "5222");
        JabberAccountIDImpl accountID = new JabberAccountIDImpl(userIDStr, accountProperties);
        if (this.registeredAccounts.containsKey((Object)accountID)) {
            throw new IllegalStateException("An account for id " + userIDStr + " was already installed!");
        }
        this.storeAccount((AccountID)accountID, false);
        accountID = this.loadAccount(accountProperties);
        return accountID;
    }

    protected AccountID createAccountID(String userID, Map<String, String> accountProperties) {
        return new JabberAccountIDImpl(userID, accountProperties);
    }

    protected ProtocolProviderService createService(String userID, AccountID accountID) {
        EntityBareJid jid;
        ProtocolProviderServiceJabberImpl service = new ProtocolProviderServiceJabberImpl();
        try {
            jid = JidCreate.entityBareFrom((String)userID);
        }
        catch (XmppStringprepException e) {
            logger.error((Object)(userID + " is not a valid JID"), (Throwable)e);
            return null;
        }
        service.initialize(jid, (JabberAccountID)accountID);
        return service;
    }

    public void modifyAccount(ProtocolProviderService protocolProvider, Map<String, String> accountProperties) throws NullPointerException {
        EntityBareJid jid;
        BundleContext context = JabberActivator.getBundleContext();
        if (context == null) {
            throw new NullPointerException("The specified BundleContext was null");
        }
        if (protocolProvider == null) {
            throw new NullPointerException("The specified Protocol Provider was null");
        }
        JabberAccountIDImpl accountID = (JabberAccountIDImpl)protocolProvider.getAccountID();
        if (!this.registeredAccounts.containsKey((Object)accountID)) {
            return;
        }
        ServiceRegistration registration = (ServiceRegistration)this.registeredAccounts.get((Object)accountID);
        if (registration != null) {
            try {
                if (protocolProvider.isRegistered()) {
                    protocolProvider.unregister();
                    protocolProvider.shutdown();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            registration.unregister();
        }
        if (accountProperties == null) {
            throw new NullPointerException("The specified property map was null");
        }
        accountProperties.put("USER_ID", accountID.getUserID());
        String serverAddress = accountProperties.get("SERVER_ADDRESS");
        if (serverAddress == null) {
            throw new NullPointerException("null is not a valid ServerAddress");
        }
        accountProperties.putIfAbsent("SERVER_PORT", "5222");
        if (!accountProperties.containsKey("PROTOCOL_NAME")) {
            accountProperties.put("PROTOCOL_NAME", "Jabber");
        }
        accountID.setAccountProperties(accountProperties);
        this.storeAccount((AccountID)accountID);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("PROTOCOL_NAME", "Jabber");
        properties.put("USER_ID", accountID.getUserID());
        try {
            jid = JidCreate.entityBareFrom((String)accountID.getUserID());
        }
        catch (XmppStringprepException e) {
            logger.error((Object)(accountID.getUserID() + " is not a valid JID"), (Throwable)e);
            throw new NullPointerException("UserID is not a valid JID");
        }
        ((ProtocolProviderServiceJabberImpl)protocolProvider).initialize(jid, accountID);
        this.storeAccount((AccountID)accountID);
        registration = context.registerService(ProtocolProviderService.class, (Object)protocolProvider, properties);
        this.registeredAccounts.put(accountID, registration);
    }
}

