/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec;

import java.util.Arrays;
import javax.media.Buffer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.utils.logging.Logger;

public class SilenceEffect
extends AbstractCodec2
implements Effect {
    private static final Logger logger = Logger.getLogger(SilenceEffect.class);
    private static final boolean COPY_DATA_FROM_INPUT_TO_OUTPUT = true;
    private static final String NAME = "Silence Effect";
    private static final int MAX_SAMPLES_PER_PACKET = 48000;
    private static final int sampleRate = 48000;
    private static final int sampleSizeInBits = 16;
    private static final int MAX_SAMPLES_SILENCE = 144000;
    public static final Format[] SUPPORTED_FORMATS = new Format[]{new AudioFormat("LINEAR", 48000.0, 16, 1, -1, -1)};
    private final boolean useRtpTimestamp;
    private final int clockRate;
    private int totalSamplesInserted = 0;
    private long lastOutputTimestamp = -1L;
    private Listener listener = null;

    public SilenceEffect() {
        super(NAME, AudioFormat.class, SUPPORTED_FORMATS);
        this.useRtpTimestamp = false;
        this.clockRate = 1000000000;
    }

    public SilenceEffect(int rtpClockRate) {
        super(NAME, AudioFormat.class, SUPPORTED_FORMATS);
        this.useRtpTimestamp = true;
        this.clockRate = rtpClockRate;
    }

    @Override
    protected void doClose() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Closing SilenceEffect, inserted a total of " + this.totalSamplesInserted + " samples of silence."));
        }
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
    }

    @Override
    protected int doProcess(Buffer inBuf, Buffer outBuf) {
        long timestamp;
        boolean useInput = true;
        long l = timestamp = this.useRtpTimestamp ? inBuf.getRtpTimeStamp() : inBuf.getTimeStamp();
        if (timestamp == -1L) {
            this.lastOutputTimestamp = -1L;
        } else if (this.lastOutputTimestamp == -1L) {
            this.lastOutputTimestamp = timestamp;
            if (this.listener != null) {
                this.listener.onSilenceNotInserted(timestamp);
            }
        } else {
            long diff = timestamp - this.lastOutputTimestamp;
            if (this.useRtpTimestamp && diff < Integer.MIN_VALUE) {
                diff += 0x100000000L;
            } else if (this.useRtpTimestamp && diff < 0L) {
                outBuf.setDiscard(true);
                return 0;
            }
            long diffSamples = Math.round((double)(diff * 48000L) / (double)this.clockRate);
            if (diffSamples > 144000L) {
                logger.info((Object)"More than the maximum of 144000 samples of silence need to be inserted.");
                if (this.listener != null) {
                    this.listener.onSilenceNotInserted(timestamp);
                }
                this.lastOutputTimestamp = timestamp;
                diffSamples = 0L;
            }
            if (diffSamples > 0L) {
                useInput = false;
                int samplesInserted = this.setSilence(outBuf, (int)diffSamples);
                this.totalSamplesInserted += samplesInserted;
                if (this.useRtpTimestamp) {
                    outBuf.setRtpTimeStamp(this.lastOutputTimestamp);
                } else {
                    outBuf.setTimeStamp(this.lastOutputTimestamp);
                }
                outBuf.setDuration(diffSamples * 1000L * 1000L * 1000L / 48000L);
                this.lastOutputTimestamp = this.calculateTimestamp(this.lastOutputTimestamp, samplesInserted);
            }
        }
        if (useInput) {
            int inLen = inBuf.getLength();
            byte[] outData = SilenceEffect.validateByteArraySize(outBuf, inLen, false);
            outBuf.setLength(inLen);
            outBuf.setOffset(0);
            System.arraycopy(inBuf.getData(), inBuf.getOffset(), outData, 0, inLen);
            outBuf.setFormat(inBuf.getFormat());
            outBuf.setHeader(inBuf.getHeader());
            outBuf.setSequenceNumber(inBuf.getSequenceNumber());
            outBuf.setTimeStamp(inBuf.getTimeStamp());
            outBuf.setRtpTimeStamp(inBuf.getRtpTimeStamp());
            outBuf.setFlags(inBuf.getFlags());
            outBuf.setDiscard(inBuf.isDiscard());
            outBuf.setEOM(inBuf.isEOM());
            outBuf.setDuration(inBuf.getDuration());
            this.lastOutputTimestamp = this.calculateTimestamp(this.lastOutputTimestamp, inLen * 8 / 16);
        }
        return useInput ? 0 : 2;
    }

    private long calculateTimestamp(long oldTimestamp, long samplesToAdd) {
        long duration = Math.round((double)((long)this.clockRate * samplesToAdd) / 48000.0);
        long timestamp = oldTimestamp + duration;
        if (this.useRtpTimestamp && timestamp > 0x100000000L) {
            timestamp -= 0x100000000L;
        }
        return timestamp;
    }

    private int setSilence(Buffer buf, int samples) {
        int samplesToFill = Math.min(samples, 48000);
        int len = samplesToFill * 16 / 8;
        byte[] data = SilenceEffect.validateByteArraySize(buf, len, false);
        Arrays.fill(data, (byte)0);
        buf.setOffset(0);
        buf.setLength(len);
        return samplesToFill;
    }

    public void resetSilence() {
        this.lastOutputTimestamp = -1L;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public static interface Listener {
        public void onSilenceNotInserted(long var1);
    }
}

