/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.stats;

import java.util.concurrent.atomic.AtomicLong;
import org.jitsi.service.neomedia.stats.TrackStats;
import org.jitsi.utils.stats.RateStatistics;

public abstract class AbstractTrackStats
implements TrackStats {
    private double jitter = Double.MIN_VALUE;
    private long rtt = -1L;
    protected final AtomicLong bytes = new AtomicLong();
    protected final AtomicLong packets = new AtomicLong();
    protected final AtomicLong bytesRetransmitted = new AtomicLong();
    protected final AtomicLong bytesNotRetransmitted = new AtomicLong();
    protected final AtomicLong packetsRetransmitted = new AtomicLong();
    protected final AtomicLong packetsNotRetransmitted = new AtomicLong();
    protected final AtomicLong packetsMissingFromCache = new AtomicLong();
    protected RateStatistics bitrate;
    protected RateStatistics packetRate;
    private int interval;
    private final long ssrc;

    AbstractTrackStats(int interval, long ssrc) {
        this.interval = interval;
        this.ssrc = ssrc;
        this.bitrate = new RateStatistics(interval);
        this.packetRate = new RateStatistics(interval, 1000.0f);
    }

    @Override
    public long getSSRC() {
        return this.ssrc;
    }

    protected void packetProcessed(int length, long now, boolean rtp) {
        this.bytes.addAndGet(length);
        this.bitrate.update(length, now);
        if (rtp) {
            this.packets.addAndGet(1L);
            this.packetRate.update(1, now);
        }
    }

    @Override
    public double getJitter() {
        return this.jitter;
    }

    @Override
    public long getRtt() {
        return this.rtt;
    }

    @Override
    public long getBytes() {
        return this.bytes.get();
    }

    @Override
    public long getPackets() {
        return this.packets.get();
    }

    @Override
    public long getBitrate() {
        return this.bitrate.getRate(System.currentTimeMillis());
    }

    @Override
    public long getPacketRate() {
        return this.packetRate.getRate(System.currentTimeMillis());
    }

    @Override
    public long getCurrentBytes() {
        return this.bitrate.getAccumulatedCount();
    }

    @Override
    public long getCurrentPackets() {
        return this.packetRate.getAccumulatedCount();
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    protected void setJitter(double jitter) {
        this.jitter = jitter;
    }

    protected void setRtt(long rtt) {
        this.rtt = rtt;
    }

    @Override
    public long getBytesRetransmitted() {
        return this.bytesRetransmitted.get();
    }

    @Override
    public long getBytesNotRetransmitted() {
        return this.bytesNotRetransmitted.get();
    }

    @Override
    public long getPacketsRetransmitted() {
        return this.packetsRetransmitted.get();
    }

    @Override
    public long getPacketsNotRetransmitted() {
        return this.packetsNotRetransmitted.get();
    }

    @Override
    public long getPacketsMissingFromCache() {
        return this.packetsMissingFromCache.get();
    }

    protected void rtpPacketRetransmitted(long length) {
        this.packetsRetransmitted.incrementAndGet();
        this.bytesRetransmitted.addAndGet(length);
    }

    protected void rtpPacketNotRetransmitted(long length) {
        this.packetsNotRetransmitted.incrementAndGet();
        this.bytesNotRetransmitted.addAndGet(length);
    }

    void rtpPacketCacheMiss() {
        this.packetsMissingFromCache.incrementAndGet();
    }
}

