/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.utils.ByteArrayBuffer;
import org.jitsi.utils.logging.Logger;

public abstract class SinglePacketTransformer
implements PacketTransformer {
    private static final int EXCEPTIONS_TO_LOG = 1000;
    private static final Logger logger = Logger.getLogger(SinglePacketTransformer.class);
    private AtomicInteger exceptionsInReverseTransform = new AtomicInteger();
    private AtomicInteger exceptionsInTransform = new AtomicInteger();
    private final Predicate<ByteArrayBuffer> packetPredicate;
    private final Function<RawPacket, RawPacket> cachedReverseTransform = pkt -> this.reverseTransform((RawPacket)pkt);
    private final Function<RawPacket, RawPacket> cachedTransform = pkt -> this.transform((RawPacket)pkt);

    public SinglePacketTransformer() {
        this(null);
    }

    public SinglePacketTransformer(Predicate<ByteArrayBuffer> packetPredicate) {
        this.packetPredicate = packetPredicate;
    }

    @Override
    public void close() {
    }

    public abstract RawPacket reverseTransform(RawPacket var1);

    @Override
    public RawPacket[] reverseTransform(RawPacket[] pkts) {
        return this.transformArray(pkts, this.cachedReverseTransform, this.exceptionsInReverseTransform, "reverseTransform");
    }

    public abstract RawPacket transform(RawPacket var1);

    @Override
    public RawPacket[] transform(RawPacket[] pkts) {
        return this.transformArray(pkts, this.cachedTransform, this.exceptionsInTransform, "transform");
    }

    private RawPacket[] transformArray(RawPacket[] pkts, Function<RawPacket, RawPacket> transformFunction, AtomicInteger exceptionCounter, String logMessage) {
        if (pkts != null) {
            for (int i = 0; i < pkts.length; ++i) {
                RawPacket pkt = pkts[i];
                if (pkt == null || this.packetPredicate != null && !this.packetPredicate.test(pkt)) continue;
                try {
                    pkts[i] = transformFunction.apply(pkt);
                    continue;
                }
                catch (Throwable t) {
                    exceptionCounter.incrementAndGet();
                    if (exceptionCounter.get() % 1000 == 0 || exceptionCounter.get() == 1) {
                        logger.error((Object)("Failed to " + logMessage + " RawPacket(s)!"), t);
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException(t);
                }
            }
        }
        return pkts;
    }
}

