/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.csrc;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jitsi.impl.neomedia.AudioMediaStreamImpl;
import org.jitsi.utils.concurrent.ExecutorUtils;

public class CsrcAudioLevelDispatcher {
    private static final ExecutorService threadPool = ExecutorUtils.newCachedThreadPool((boolean)true, (String)(CsrcAudioLevelDispatcher.class.getName() + "-"));
    private final AtomicReference<long[]> levels = new AtomicReference();
    private final AudioMediaStreamImpl mediaStream;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final Runnable deliverRunnable = () -> this.deliverAudioLevelsToMediaStream();

    public CsrcAudioLevelDispatcher(AudioMediaStreamImpl mediaStream) {
        if (mediaStream == null) {
            throw new IllegalArgumentException("mediaStream is null");
        }
        this.mediaStream = mediaStream;
    }

    public void addLevels(long[] levels, long rtpTime) {
        if (!this.running.get()) {
            return;
        }
        this.levels.set(levels);
        threadPool.execute(this.deliverRunnable);
    }

    public void close() {
        this.running.set(false);
        this.levels.set(null);
    }

    private void deliverAudioLevelsToMediaStream() {
        if (!this.running.get()) {
            return;
        }
        long[] latestAudioLevels = this.levels.getAndSet(null);
        if (latestAudioLevels != null) {
            this.mediaStream.audioLevelsReceived(latestAudioLevels);
        }
    }
}

