/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.stats.media;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.callstats.sdk.ICallStatsTokenGenerator;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64Encoder;
import org.jitsi.utils.logging.Logger;
import org.jose4j.jwk.EllipticCurveJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;

public class TokenGenerator
implements ICallStatsTokenGenerator {
    private static final Logger logger = Logger.getLogger(TokenGenerator.class);
    private final String appId;
    private final String keyId;
    private final String userId;
    private final String keyPath;

    TokenGenerator(String appId, String keyId, String userId, String keyPath) {
        this.appId = appId;
        this.keyId = keyId;
        this.userId = userId;
        this.keyPath = keyPath;
    }

    public String generateToken(boolean forcenew) {
        try {
            JwtClaims claims = new JwtClaims();
            claims.setClaim("appID", (Object)this.appId);
            claims.setClaim("keyID", (Object)this.keyId);
            claims.setClaim("userID", (Object)this.userId);
            claims.setExpirationTimeMinutesInTheFuture(10.0f);
            claims.setNotBeforeMinutesInThePast(10.0f);
            JsonWebSignature jws = new JsonWebSignature();
            jws.setKey((Key)TokenGenerator.readPrivateKey(this.keyPath));
            jws.setPayload(claims.toJson());
            jws.setAlgorithmHeaderValue("ES256");
            return jws.getCompactSerialization();
        }
        catch (Exception e) {
            logger.error((Object)"Error generating jwt token", (Throwable)e);
            return null;
        }
    }

    private static PrivateKey readPrivateKey(String keyPath) throws IOException, JoseException {
        Type mapType = new TypeToken<Map<String, String>>(){}.getType();
        Map son = (Map)new Gson().fromJson((Reader)new FileReader(keyPath), mapType);
        EllipticCurveJsonWebKey jwk = new EllipticCurveJsonWebKey(son);
        Base64Encoder enc = new Base64Encoder();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] encodedKey = jwk.getPrivateKey().getEncoded();
        enc.encode(encodedKey, 0, encodedKey.length, (OutputStream)os);
        return jwk.getPrivateKey();
    }
}

