/*-------------------------------------------------------------------------
 *
 * unicode_category_table.h
 *	  Category table for Unicode character classification.
 *
 * Portions Copyright (c) 1996-2024, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * src/include/common/unicode_category_table.h
 *
 *-------------------------------------------------------------------------
 */

#include "common/unicode_category.h"

/*
 * File auto-generated by src/common/unicode/generate-unicode_category_table.pl,
 * do not edit. There is deliberately not an #ifndef PG_UNICODE_CATEGORY_TABLE_H
 * here.
 */
typedef struct
{
	uint32		first;			/* Unicode codepoint */
	uint32		last;			/* Unicode codepoint */
	uint8		category;		/* General Category */
} pg_category_range;

typedef struct
{
	uint32		first;			/* Unicode codepoint */
	uint32		last;			/* Unicode codepoint */
} pg_unicode_range;

typedef struct
{
	uint8		category;
	uint8		properties;
} pg_unicode_properties;

/*
 * The properties currently used, in no particular order. Fits in a uint8, but
 * if more properties are added, a wider integer will be needed.
 */
#define PG_U_PROP_ALPHABETIC		(1 << 0)
#define PG_U_PROP_LOWERCASE			(1 << 1)
#define PG_U_PROP_UPPERCASE			(1 << 2)
#define PG_U_PROP_CASED				(1 << 3)
#define PG_U_PROP_CASE_IGNORABLE	(1 << 4)
#define PG_U_PROP_WHITE_SPACE		(1 << 5)
#define PG_U_PROP_JOIN_CONTROL		(1 << 6)
#define PG_U_PROP_HEX_DIGIT			(1 << 7)

/* table for fast lookup of ASCII codepoints */
static const pg_unicode_properties unicode_opt_ascii[128] =
{
	{
		/* 0x000000 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000001 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000002 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000003 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000004 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000005 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000006 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000007 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000008 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000009 */
		.category = PG_U_CONTROL,
		.properties = PG_U_PROP_WHITE_SPACE
	},
	{
		/* 0x00000a */
		.category = PG_U_CONTROL,
		.properties = PG_U_PROP_WHITE_SPACE
	},
	{
		/* 0x00000b */
		.category = PG_U_CONTROL,
		.properties = PG_U_PROP_WHITE_SPACE
	},
	{
		/* 0x00000c */
		.category = PG_U_CONTROL,
		.properties = PG_U_PROP_WHITE_SPACE
	},
	{
		/* 0x00000d */
		.category = PG_U_CONTROL,
		.properties = PG_U_PROP_WHITE_SPACE
	},
	{
		/* 0x00000e */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x00000f */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000010 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000011 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000012 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000013 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000014 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000015 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000016 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000017 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000018 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000019 */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x00001a */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x00001b */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x00001c */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x00001d */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x00001e */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x00001f */
		.category = PG_U_CONTROL,
		.properties = 0
	},
	{
		/* 0x000020 */
		.category = PG_U_SPACE_SEPARATOR,
		.properties = PG_U_PROP_WHITE_SPACE
	},
	{
		/* 0x000021 */
		.category = PG_U_OTHER_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x000022 */
		.category = PG_U_OTHER_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x000023 */
		.category = PG_U_OTHER_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x000024 */
		.category = PG_U_CURRENCY_SYMBOL,
		.properties = 0
	},
	{
		/* 0x000025 */
		.category = PG_U_OTHER_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x000026 */
		.category = PG_U_OTHER_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x000027 */
		.category = PG_U_OTHER_PUNCTUATION,
		.properties = PG_U_PROP_CASE_IGNORABLE
	},
	{
		/* 0x000028 */
		.category = PG_U_OPEN_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x000029 */
		.category = PG_U_CLOSE_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x00002a */
		.category = PG_U_OTHER_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x00002b */
		.category = PG_U_MATH_SYMBOL,
		.properties = 0
	},
	{
		/* 0x00002c */
		.category = PG_U_OTHER_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x00002d */
		.category = PG_U_DASH_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x00002e */
		.category = PG_U_OTHER_PUNCTUATION,
		.properties = PG_U_PROP_CASE_IGNORABLE
	},
	{
		/* 0x00002f */
		.category = PG_U_OTHER_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x000030 */
		.category = PG_U_DECIMAL_NUMBER,
		.properties = PG_U_PROP_HEX_DIGIT
	},
	{
		/* 0x000031 */
		.category = PG_U_DECIMAL_NUMBER,
		.properties = PG_U_PROP_HEX_DIGIT
	},
	{
		/* 0x000032 */
		.category = PG_U_DECIMAL_NUMBER,
		.properties = PG_U_PROP_HEX_DIGIT
	},
	{
		/* 0x000033 */
		.category = PG_U_DECIMAL_NUMBER,
		.properties = PG_U_PROP_HEX_DIGIT
	},
	{
		/* 0x000034 */
		.category = PG_U_DECIMAL_NUMBER,
		.properties = PG_U_PROP_HEX_DIGIT
	},
	{
		/* 0x000035 */
		.category = PG_U_DECIMAL_NUMBER,
		.properties = PG_U_PROP_HEX_DIGIT
	},
	{
		/* 0x000036 */
		.category = PG_U_DECIMAL_NUMBER,
		.properties = PG_U_PROP_HEX_DIGIT
	},
	{
		/* 0x000037 */
		.category = PG_U_DECIMAL_NUMBER,
		.properties = PG_U_PROP_HEX_DIGIT
	},
	{
		/* 0x000038 */
		.category = PG_U_DECIMAL_NUMBER,
		.properties = PG_U_PROP_HEX_DIGIT
	},
	{
		/* 0x000039 */
		.category = PG_U_DECIMAL_NUMBER,
		.properties = PG_U_PROP_HEX_DIGIT
	},
	{
		/* 0x00003a */
		.category = PG_U_OTHER_PUNCTUATION,
		.properties = PG_U_PROP_CASE_IGNORABLE
	},
	{
		/* 0x00003b */
		.category = PG_U_OTHER_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x00003c */
		.category = PG_U_MATH_SYMBOL,
		.properties = 0
	},
	{
		/* 0x00003d */
		.category = PG_U_MATH_SYMBOL,
		.properties = 0
	},
	{
		/* 0x00003e */
		.category = PG_U_MATH_SYMBOL,
		.properties = 0
	},
	{
		/* 0x00003f */
		.category = PG_U_OTHER_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x000040 */
		.category = PG_U_OTHER_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x000041 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_HEX_DIGIT | PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000042 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_HEX_DIGIT | PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000043 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_HEX_DIGIT | PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000044 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_HEX_DIGIT | PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000045 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_HEX_DIGIT | PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000046 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_HEX_DIGIT | PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000047 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000048 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000049 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x00004a */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x00004b */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x00004c */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x00004d */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x00004e */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x00004f */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000050 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000051 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000052 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000053 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000054 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000055 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000056 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000057 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000058 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000059 */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x00005a */
		.category = PG_U_UPPERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_UPPERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x00005b */
		.category = PG_U_OPEN_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x00005c */
		.category = PG_U_OTHER_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x00005d */
		.category = PG_U_CLOSE_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x00005e */
		.category = PG_U_MODIFIER_SYMBOL,
		.properties = PG_U_PROP_CASE_IGNORABLE
	},
	{
		/* 0x00005f */
		.category = PG_U_CONNECTOR_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x000060 */
		.category = PG_U_MODIFIER_SYMBOL,
		.properties = PG_U_PROP_CASE_IGNORABLE
	},
	{
		/* 0x000061 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_HEX_DIGIT | PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000062 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_HEX_DIGIT | PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000063 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_HEX_DIGIT | PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000064 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_HEX_DIGIT | PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000065 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_HEX_DIGIT | PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000066 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_HEX_DIGIT | PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000067 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000068 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000069 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x00006a */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x00006b */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x00006c */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x00006d */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x00006e */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x00006f */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000070 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000071 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000072 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000073 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000074 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000075 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000076 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000077 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000078 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x000079 */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x00007a */
		.category = PG_U_LOWERCASE_LETTER,
		.properties = PG_U_PROP_ALPHABETIC | PG_U_PROP_LOWERCASE | PG_U_PROP_CASED
	},
	{
		/* 0x00007b */
		.category = PG_U_OPEN_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x00007c */
		.category = PG_U_MATH_SYMBOL,
		.properties = 0
	},
	{
		/* 0x00007d */
		.category = PG_U_CLOSE_PUNCTUATION,
		.properties = 0
	},
	{
		/* 0x00007e */
		.category = PG_U_MATH_SYMBOL,
		.properties = 0
	},
	{
		/* 0x00007f */
		.category = PG_U_CONTROL,
		.properties = 0
	},
};

/* table of Unicode codepoint ranges and their categories */
static const pg_category_range unicode_categories[3302] =
{
	{0x000000, 0x00001f, PG_U_CONTROL},
	{0x000020, 0x000020, PG_U_SPACE_SEPARATOR},
	{0x000021, 0x000023, PG_U_OTHER_PUNCTUATION},
	{0x000024, 0x000024, PG_U_CURRENCY_SYMBOL},
	{0x000025, 0x000027, PG_U_OTHER_PUNCTUATION},
	{0x000028, 0x000028, PG_U_OPEN_PUNCTUATION},
	{0x000029, 0x000029, PG_U_CLOSE_PUNCTUATION},
	{0x00002a, 0x00002a, PG_U_OTHER_PUNCTUATION},
	{0x00002b, 0x00002b, PG_U_MATH_SYMBOL},
	{0x00002c, 0x00002c, PG_U_OTHER_PUNCTUATION},
	{0x00002d, 0x00002d, PG_U_DASH_PUNCTUATION},
	{0x00002e, 0x00002f, PG_U_OTHER_PUNCTUATION},
	{0x000030, 0x000039, PG_U_DECIMAL_NUMBER},
	{0x00003a, 0x00003b, PG_U_OTHER_PUNCTUATION},
	{0x00003c, 0x00003e, PG_U_MATH_SYMBOL},
	{0x00003f, 0x000040, PG_U_OTHER_PUNCTUATION},
	{0x000041, 0x00005a, PG_U_UPPERCASE_LETTER},
	{0x00005b, 0x00005b, PG_U_OPEN_PUNCTUATION},
	{0x00005c, 0x00005c, PG_U_OTHER_PUNCTUATION},
	{0x00005d, 0x00005d, PG_U_CLOSE_PUNCTUATION},
	{0x00005e, 0x00005e, PG_U_MODIFIER_SYMBOL},
	{0x00005f, 0x00005f, PG_U_CONNECTOR_PUNCTUATION},
	{0x000060, 0x000060, PG_U_MODIFIER_SYMBOL},
	{0x000061, 0x00007a, PG_U_LOWERCASE_LETTER},
	{0x00007b, 0x00007b, PG_U_OPEN_PUNCTUATION},
	{0x00007c, 0x00007c, PG_U_MATH_SYMBOL},
	{0x00007d, 0x00007d, PG_U_CLOSE_PUNCTUATION},
	{0x00007e, 0x00007e, PG_U_MATH_SYMBOL},
	{0x00007f, 0x00009f, PG_U_CONTROL},
	{0x0000a0, 0x0000a0, PG_U_SPACE_SEPARATOR},
	{0x0000a1, 0x0000a1, PG_U_OTHER_PUNCTUATION},
	{0x0000a2, 0x0000a5, PG_U_CURRENCY_SYMBOL},
	{0x0000a6, 0x0000a6, PG_U_OTHER_SYMBOL},
	{0x0000a7, 0x0000a7, PG_U_OTHER_PUNCTUATION},
	{0x0000a8, 0x0000a8, PG_U_MODIFIER_SYMBOL},
	{0x0000a9, 0x0000a9, PG_U_OTHER_SYMBOL},
	{0x0000aa, 0x0000aa, PG_U_OTHER_LETTER},
	{0x0000ab, 0x0000ab, PG_U_INITIAL_PUNCTUATION},
	{0x0000ac, 0x0000ac, PG_U_MATH_SYMBOL},
	{0x0000ad, 0x0000ad, PG_U_FORMAT},
	{0x0000ae, 0x0000ae, PG_U_OTHER_SYMBOL},
	{0x0000af, 0x0000af, PG_U_MODIFIER_SYMBOL},
	{0x0000b0, 0x0000b0, PG_U_OTHER_SYMBOL},
	{0x0000b1, 0x0000b1, PG_U_MATH_SYMBOL},
	{0x0000b2, 0x0000b3, PG_U_OTHER_NUMBER},
	{0x0000b4, 0x0000b4, PG_U_MODIFIER_SYMBOL},
	{0x0000b5, 0x0000b5, PG_U_LOWERCASE_LETTER},
	{0x0000b6, 0x0000b7, PG_U_OTHER_PUNCTUATION},
	{0x0000b8, 0x0000b8, PG_U_MODIFIER_SYMBOL},
	{0x0000b9, 0x0000b9, PG_U_OTHER_NUMBER},
	{0x0000ba, 0x0000ba, PG_U_OTHER_LETTER},
	{0x0000bb, 0x0000bb, PG_U_FINAL_PUNCTUATION},
	{0x0000bc, 0x0000be, PG_U_OTHER_NUMBER},
	{0x0000bf, 0x0000bf, PG_U_OTHER_PUNCTUATION},
	{0x0000c0, 0x0000d6, PG_U_UPPERCASE_LETTER},
	{0x0000d7, 0x0000d7, PG_U_MATH_SYMBOL},
	{0x0000d8, 0x0000de, PG_U_UPPERCASE_LETTER},
	{0x0000df, 0x0000f6, PG_U_LOWERCASE_LETTER},
	{0x0000f7, 0x0000f7, PG_U_MATH_SYMBOL},
	{0x0000f8, 0x0000ff, PG_U_LOWERCASE_LETTER},
	{0x000100, 0x000100, PG_U_UPPERCASE_LETTER},
	{0x000101, 0x000101, PG_U_LOWERCASE_LETTER},
	{0x000102, 0x000102, PG_U_UPPERCASE_LETTER},
	{0x000103, 0x000103, PG_U_LOWERCASE_LETTER},
	{0x000104, 0x000104, PG_U_UPPERCASE_LETTER},
	{0x000105, 0x000105, PG_U_LOWERCASE_LETTER},
	{0x000106, 0x000106, PG_U_UPPERCASE_LETTER},
	{0x000107, 0x000107, PG_U_LOWERCASE_LETTER},
	{0x000108, 0x000108, PG_U_UPPERCASE_LETTER},
	{0x000109, 0x000109, PG_U_LOWERCASE_LETTER},
	{0x00010a, 0x00010a, PG_U_UPPERCASE_LETTER},
	{0x00010b, 0x00010b, PG_U_LOWERCASE_LETTER},
	{0x00010c, 0x00010c, PG_U_UPPERCASE_LETTER},
	{0x00010d, 0x00010d, PG_U_LOWERCASE_LETTER},
	{0x00010e, 0x00010e, PG_U_UPPERCASE_LETTER},
	{0x00010f, 0x00010f, PG_U_LOWERCASE_LETTER},
	{0x000110, 0x000110, PG_U_UPPERCASE_LETTER},
	{0x000111, 0x000111, PG_U_LOWERCASE_LETTER},
	{0x000112, 0x000112, PG_U_UPPERCASE_LETTER},
	{0x000113, 0x000113, PG_U_LOWERCASE_LETTER},
	{0x000114, 0x000114, PG_U_UPPERCASE_LETTER},
	{0x000115, 0x000115, PG_U_LOWERCASE_LETTER},
	{0x000116, 0x000116, PG_U_UPPERCASE_LETTER},
	{0x000117, 0x000117, PG_U_LOWERCASE_LETTER},
	{0x000118, 0x000118, PG_U_UPPERCASE_LETTER},
	{0x000119, 0x000119, PG_U_LOWERCASE_LETTER},
	{0x00011a, 0x00011a, PG_U_UPPERCASE_LETTER},
	{0x00011b, 0x00011b, PG_U_LOWERCASE_LETTER},
	{0x00011c, 0x00011c, PG_U_UPPERCASE_LETTER},
	{0x00011d, 0x00011d, PG_U_LOWERCASE_LETTER},
	{0x00011e, 0x00011e, PG_U_UPPERCASE_LETTER},
	{0x00011f, 0x00011f, PG_U_LOWERCASE_LETTER},
	{0x000120, 0x000120, PG_U_UPPERCASE_LETTER},
	{0x000121, 0x000121, PG_U_LOWERCASE_LETTER},
	{0x000122, 0x000122, PG_U_UPPERCASE_LETTER},
	{0x000123, 0x000123, PG_U_LOWERCASE_LETTER},
	{0x000124, 0x000124, PG_U_UPPERCASE_LETTER},
	{0x000125, 0x000125, PG_U_LOWERCASE_LETTER},
	{0x000126, 0x000126, PG_U_UPPERCASE_LETTER},
	{0x000127, 0x000127, PG_U_LOWERCASE_LETTER},
	{0x000128, 0x000128, PG_U_UPPERCASE_LETTER},
	{0x000129, 0x000129, PG_U_LOWERCASE_LETTER},
	{0x00012a, 0x00012a, PG_U_UPPERCASE_LETTER},
	{0x00012b, 0x00012b, PG_U_LOWERCASE_LETTER},
	{0x00012c, 0x00012c, PG_U_UPPERCASE_LETTER},
	{0x00012d, 0x00012d, PG_U_LOWERCASE_LETTER},
	{0x00012e, 0x00012e, PG_U_UPPERCASE_LETTER},
	{0x00012f, 0x00012f, PG_U_LOWERCASE_LETTER},
	{0x000130, 0x000130, PG_U_UPPERCASE_LETTER},
	{0x000131, 0x000131, PG_U_LOWERCASE_LETTER},
	{0x000132, 0x000132, PG_U_UPPERCASE_LETTER},
	{0x000133, 0x000133, PG_U_LOWERCASE_LETTER},
	{0x000134, 0x000134, PG_U_UPPERCASE_LETTER},
	{0x000135, 0x000135, PG_U_LOWERCASE_LETTER},
	{0x000136, 0x000136, PG_U_UPPERCASE_LETTER},
	{0x000137, 0x000138, PG_U_LOWERCASE_LETTER},
	{0x000139, 0x000139, PG_U_UPPERCASE_LETTER},
	{0x00013a, 0x00013a, PG_U_LOWERCASE_LETTER},
	{0x00013b, 0x00013b, PG_U_UPPERCASE_LETTER},
	{0x00013c, 0x00013c, PG_U_LOWERCASE_LETTER},
	{0x00013d, 0x00013d, PG_U_UPPERCASE_LETTER},
	{0x00013e, 0x00013e, PG_U_LOWERCASE_LETTER},
	{0x00013f, 0x00013f, PG_U_UPPERCASE_LETTER},
	{0x000140, 0x000140, PG_U_LOWERCASE_LETTER},
	{0x000141, 0x000141, PG_U_UPPERCASE_LETTER},
	{0x000142, 0x000142, PG_U_LOWERCASE_LETTER},
	{0x000143, 0x000143, PG_U_UPPERCASE_LETTER},
	{0x000144, 0x000144, PG_U_LOWERCASE_LETTER},
	{0x000145, 0x000145, PG_U_UPPERCASE_LETTER},
	{0x000146, 0x000146, PG_U_LOWERCASE_LETTER},
	{0x000147, 0x000147, PG_U_UPPERCASE_LETTER},
	{0x000148, 0x000149, PG_U_LOWERCASE_LETTER},
	{0x00014a, 0x00014a, PG_U_UPPERCASE_LETTER},
	{0x00014b, 0x00014b, PG_U_LOWERCASE_LETTER},
	{0x00014c, 0x00014c, PG_U_UPPERCASE_LETTER},
	{0x00014d, 0x00014d, PG_U_LOWERCASE_LETTER},
	{0x00014e, 0x00014e, PG_U_UPPERCASE_LETTER},
	{0x00014f, 0x00014f, PG_U_LOWERCASE_LETTER},
	{0x000150, 0x000150, PG_U_UPPERCASE_LETTER},
	{0x000151, 0x000151, PG_U_LOWERCASE_LETTER},
	{0x000152, 0x000152, PG_U_UPPERCASE_LETTER},
	{0x000153, 0x000153, PG_U_LOWERCASE_LETTER},
	{0x000154, 0x000154, PG_U_UPPERCASE_LETTER},
	{0x000155, 0x000155, PG_U_LOWERCASE_LETTER},
	{0x000156, 0x000156, PG_U_UPPERCASE_LETTER},
	{0x000157, 0x000157, PG_U_LOWERCASE_LETTER},
	{0x000158, 0x000158, PG_U_UPPERCASE_LETTER},
	{0x000159, 0x000159, PG_U_LOWERCASE_LETTER},
	{0x00015a, 0x00015a, PG_U_UPPERCASE_LETTER},
	{0x00015b, 0x00015b, PG_U_LOWERCASE_LETTER},
	{0x00015c, 0x00015c, PG_U_UPPERCASE_LETTER},
	{0x00015d, 0x00015d, PG_U_LOWERCASE_LETTER},
	{0x00015e, 0x00015e, PG_U_UPPERCASE_LETTER},
	{0x00015f, 0x00015f, PG_U_LOWERCASE_LETTER},
	{0x000160, 0x000160, PG_U_UPPERCASE_LETTER},
	{0x000161, 0x000161, PG_U_LOWERCASE_LETTER},
	{0x000162, 0x000162, PG_U_UPPERCASE_LETTER},
	{0x000163, 0x000163, PG_U_LOWERCASE_LETTER},
	{0x000164, 0x000164, PG_U_UPPERCASE_LETTER},
	{0x000165, 0x000165, PG_U_LOWERCASE_LETTER},
	{0x000166, 0x000166, PG_U_UPPERCASE_LETTER},
	{0x000167, 0x000167, PG_U_LOWERCASE_LETTER},
	{0x000168, 0x000168, PG_U_UPPERCASE_LETTER},
	{0x000169, 0x000169, PG_U_LOWERCASE_LETTER},
	{0x00016a, 0x00016a, PG_U_UPPERCASE_LETTER},
	{0x00016b, 0x00016b, PG_U_LOWERCASE_LETTER},
	{0x00016c, 0x00016c, PG_U_UPPERCASE_LETTER},
	{0x00016d, 0x00016d, PG_U_LOWERCASE_LETTER},
	{0x00016e, 0x00016e, PG_U_UPPERCASE_LETTER},
	{0x00016f, 0x00016f, PG_U_LOWERCASE_LETTER},
	{0x000170, 0x000170, PG_U_UPPERCASE_LETTER},
	{0x000171, 0x000171, PG_U_LOWERCASE_LETTER},
	{0x000172, 0x000172, PG_U_UPPERCASE_LETTER},
	{0x000173, 0x000173, PG_U_LOWERCASE_LETTER},
	{0x000174, 0x000174, PG_U_UPPERCASE_LETTER},
	{0x000175, 0x000175, PG_U_LOWERCASE_LETTER},
	{0x000176, 0x000176, PG_U_UPPERCASE_LETTER},
	{0x000177, 0x000177, PG_U_LOWERCASE_LETTER},
	{0x000178, 0x000179, PG_U_UPPERCASE_LETTER},
	{0x00017a, 0x00017a, PG_U_LOWERCASE_LETTER},
	{0x00017b, 0x00017b, PG_U_UPPERCASE_LETTER},
	{0x00017c, 0x00017c, PG_U_LOWERCASE_LETTER},
	{0x00017d, 0x00017d, PG_U_UPPERCASE_LETTER},
	{0x00017e, 0x000180, PG_U_LOWERCASE_LETTER},
	{0x000181, 0x000182, PG_U_UPPERCASE_LETTER},
	{0x000183, 0x000183, PG_U_LOWERCASE_LETTER},
	{0x000184, 0x000184, PG_U_UPPERCASE_LETTER},
	{0x000185, 0x000185, PG_U_LOWERCASE_LETTER},
	{0x000186, 0x000187, PG_U_UPPERCASE_LETTER},
	{0x000188, 0x000188, PG_U_LOWERCASE_LETTER},
	{0x000189, 0x00018b, PG_U_UPPERCASE_LETTER},
	{0x00018c, 0x00018d, PG_U_LOWERCASE_LETTER},
	{0x00018e, 0x000191, PG_U_UPPERCASE_LETTER},
	{0x000192, 0x000192, PG_U_LOWERCASE_LETTER},
	{0x000193, 0x000194, PG_U_UPPERCASE_LETTER},
	{0x000195, 0x000195, PG_U_LOWERCASE_LETTER},
	{0x000196, 0x000198, PG_U_UPPERCASE_LETTER},
	{0x000199, 0x00019b, PG_U_LOWERCASE_LETTER},
	{0x00019c, 0x00019d, PG_U_UPPERCASE_LETTER},
	{0x00019e, 0x00019e, PG_U_LOWERCASE_LETTER},
	{0x00019f, 0x0001a0, PG_U_UPPERCASE_LETTER},
	{0x0001a1, 0x0001a1, PG_U_LOWERCASE_LETTER},
	{0x0001a2, 0x0001a2, PG_U_UPPERCASE_LETTER},
	{0x0001a3, 0x0001a3, PG_U_LOWERCASE_LETTER},
	{0x0001a4, 0x0001a4, PG_U_UPPERCASE_LETTER},
	{0x0001a5, 0x0001a5, PG_U_LOWERCASE_LETTER},
	{0x0001a6, 0x0001a7, PG_U_UPPERCASE_LETTER},
	{0x0001a8, 0x0001a8, PG_U_LOWERCASE_LETTER},
	{0x0001a9, 0x0001a9, PG_U_UPPERCASE_LETTER},
	{0x0001aa, 0x0001ab, PG_U_LOWERCASE_LETTER},
	{0x0001ac, 0x0001ac, PG_U_UPPERCASE_LETTER},
	{0x0001ad, 0x0001ad, PG_U_LOWERCASE_LETTER},
	{0x0001ae, 0x0001af, PG_U_UPPERCASE_LETTER},
	{0x0001b0, 0x0001b0, PG_U_LOWERCASE_LETTER},
	{0x0001b1, 0x0001b3, PG_U_UPPERCASE_LETTER},
	{0x0001b4, 0x0001b4, PG_U_LOWERCASE_LETTER},
	{0x0001b5, 0x0001b5, PG_U_UPPERCASE_LETTER},
	{0x0001b6, 0x0001b6, PG_U_LOWERCASE_LETTER},
	{0x0001b7, 0x0001b8, PG_U_UPPERCASE_LETTER},
	{0x0001b9, 0x0001ba, PG_U_LOWERCASE_LETTER},
	{0x0001bb, 0x0001bb, PG_U_OTHER_LETTER},
	{0x0001bc, 0x0001bc, PG_U_UPPERCASE_LETTER},
	{0x0001bd, 0x0001bf, PG_U_LOWERCASE_LETTER},
	{0x0001c0, 0x0001c3, PG_U_OTHER_LETTER},
	{0x0001c4, 0x0001c4, PG_U_UPPERCASE_LETTER},
	{0x0001c5, 0x0001c5, PG_U_TITLECASE_LETTER},
	{0x0001c6, 0x0001c6, PG_U_LOWERCASE_LETTER},
	{0x0001c7, 0x0001c7, PG_U_UPPERCASE_LETTER},
	{0x0001c8, 0x0001c8, PG_U_TITLECASE_LETTER},
	{0x0001c9, 0x0001c9, PG_U_LOWERCASE_LETTER},
	{0x0001ca, 0x0001ca, PG_U_UPPERCASE_LETTER},
	{0x0001cb, 0x0001cb, PG_U_TITLECASE_LETTER},
	{0x0001cc, 0x0001cc, PG_U_LOWERCASE_LETTER},
	{0x0001cd, 0x0001cd, PG_U_UPPERCASE_LETTER},
	{0x0001ce, 0x0001ce, PG_U_LOWERCASE_LETTER},
	{0x0001cf, 0x0001cf, PG_U_UPPERCASE_LETTER},
	{0x0001d0, 0x0001d0, PG_U_LOWERCASE_LETTER},
	{0x0001d1, 0x0001d1, PG_U_UPPERCASE_LETTER},
	{0x0001d2, 0x0001d2, PG_U_LOWERCASE_LETTER},
	{0x0001d3, 0x0001d3, PG_U_UPPERCASE_LETTER},
	{0x0001d4, 0x0001d4, PG_U_LOWERCASE_LETTER},
	{0x0001d5, 0x0001d5, PG_U_UPPERCASE_LETTER},
	{0x0001d6, 0x0001d6, PG_U_LOWERCASE_LETTER},
	{0x0001d7, 0x0001d7, PG_U_UPPERCASE_LETTER},
	{0x0001d8, 0x0001d8, PG_U_LOWERCASE_LETTER},
	{0x0001d9, 0x0001d9, PG_U_UPPERCASE_LETTER},
	{0x0001da, 0x0001da, PG_U_LOWERCASE_LETTER},
	{0x0001db, 0x0001db, PG_U_UPPERCASE_LETTER},
	{0x0001dc, 0x0001dd, PG_U_LOWERCASE_LETTER},
	{0x0001de, 0x0001de, PG_U_UPPERCASE_LETTER},
	{0x0001df, 0x0001df, PG_U_LOWERCASE_LETTER},
	{0x0001e0, 0x0001e0, PG_U_UPPERCASE_LETTER},
	{0x0001e1, 0x0001e1, PG_U_LOWERCASE_LETTER},
	{0x0001e2, 0x0001e2, PG_U_UPPERCASE_LETTER},
	{0x0001e3, 0x0001e3, PG_U_LOWERCASE_LETTER},
	{0x0001e4, 0x0001e4, PG_U_UPPERCASE_LETTER},
	{0x0001e5, 0x0001e5, PG_U_LOWERCASE_LETTER},
	{0x0001e6, 0x0001e6, PG_U_UPPERCASE_LETTER},
	{0x0001e7, 0x0001e7, PG_U_LOWERCASE_LETTER},
	{0x0001e8, 0x0001e8, PG_U_UPPERCASE_LETTER},
	{0x0001e9, 0x0001e9, PG_U_LOWERCASE_LETTER},
	{0x0001ea, 0x0001ea, PG_U_UPPERCASE_LETTER},
	{0x0001eb, 0x0001eb, PG_U_LOWERCASE_LETTER},
	{0x0001ec, 0x0001ec, PG_U_UPPERCASE_LETTER},
	{0x0001ed, 0x0001ed, PG_U_LOWERCASE_LETTER},
	{0x0001ee, 0x0001ee, PG_U_UPPERCASE_LETTER},
	{0x0001ef, 0x0001f0, PG_U_LOWERCASE_LETTER},
	{0x0001f1, 0x0001f1, PG_U_UPPERCASE_LETTER},
	{0x0001f2, 0x0001f2, PG_U_TITLECASE_LETTER},
	{0x0001f3, 0x0001f3, PG_U_LOWERCASE_LETTER},
	{0x0001f4, 0x0001f4, PG_U_UPPERCASE_LETTER},
	{0x0001f5, 0x0001f5, PG_U_LOWERCASE_LETTER},
	{0x0001f6, 0x0001f8, PG_U_UPPERCASE_LETTER},
	{0x0001f9, 0x0001f9, PG_U_LOWERCASE_LETTER},
	{0x0001fa, 0x0001fa, PG_U_UPPERCASE_LETTER},
	{0x0001fb, 0x0001fb, PG_U_LOWERCASE_LETTER},
	{0x0001fc, 0x0001fc, PG_U_UPPERCASE_LETTER},
	{0x0001fd, 0x0001fd, PG_U_LOWERCASE_LETTER},
	{0x0001fe, 0x0001fe, PG_U_UPPERCASE_LETTER},
	{0x0001ff, 0x0001ff, PG_U_LOWERCASE_LETTER},
	{0x000200, 0x000200, PG_U_UPPERCASE_LETTER},
	{0x000201, 0x000201, PG_U_LOWERCASE_LETTER},
	{0x000202, 0x000202, PG_U_UPPERCASE_LETTER},
	{0x000203, 0x000203, PG_U_LOWERCASE_LETTER},
	{0x000204, 0x000204, PG_U_UPPERCASE_LETTER},
	{0x000205, 0x000205, PG_U_LOWERCASE_LETTER},
	{0x000206, 0x000206, PG_U_UPPERCASE_LETTER},
	{0x000207, 0x000207, PG_U_LOWERCASE_LETTER},
	{0x000208, 0x000208, PG_U_UPPERCASE_LETTER},
	{0x000209, 0x000209, PG_U_LOWERCASE_LETTER},
	{0x00020a, 0x00020a, PG_U_UPPERCASE_LETTER},
	{0x00020b, 0x00020b, PG_U_LOWERCASE_LETTER},
	{0x00020c, 0x00020c, PG_U_UPPERCASE_LETTER},
	{0x00020d, 0x00020d, PG_U_LOWERCASE_LETTER},
	{0x00020e, 0x00020e, PG_U_UPPERCASE_LETTER},
	{0x00020f, 0x00020f, PG_U_LOWERCASE_LETTER},
	{0x000210, 0x000210, PG_U_UPPERCASE_LETTER},
	{0x000211, 0x000211, PG_U_LOWERCASE_LETTER},
	{0x000212, 0x000212, PG_U_UPPERCASE_LETTER},
	{0x000213, 0x000213, PG_U_LOWERCASE_LETTER},
	{0x000214, 0x000214, PG_U_UPPERCASE_LETTER},
	{0x000215, 0x000215, PG_U_LOWERCASE_LETTER},
	{0x000216, 0x000216, PG_U_UPPERCASE_LETTER},
	{0x000217, 0x000217, PG_U_LOWERCASE_LETTER},
	{0x000218, 0x000218, PG_U_UPPERCASE_LETTER},
	{0x000219, 0x000219, PG_U_LOWERCASE_LETTER},
	{0x00021a, 0x00021a, PG_U_UPPERCASE_LETTER},
	{0x00021b, 0x00021b, PG_U_LOWERCASE_LETTER},
	{0x00021c, 0x00021c, PG_U_UPPERCASE_LETTER},
	{0x00021d, 0x00021d, PG_U_LOWERCASE_LETTER},
	{0x00021e, 0x00021e, PG_U_UPPERCASE_LETTER},
	{0x00021f, 0x00021f, PG_U_LOWERCASE_LETTER},
	{0x000220, 0x000220, PG_U_UPPERCASE_LETTER},
	{0x000221, 0x000221, PG_U_LOWERCASE_LETTER},
	{0x000222, 0x000222, PG_U_UPPERCASE_LETTER},
	{0x000223, 0x000223, PG_U_LOWERCASE_LETTER},
	{0x000224, 0x000224, PG_U_UPPERCASE_LETTER},
	{0x000225, 0x000225, PG_U_LOWERCASE_LETTER},
	{0x000226, 0x000226, PG_U_UPPERCASE_LETTER},
	{0x000227, 0x000227, PG_U_LOWERCASE_LETTER},
	{0x000228, 0x000228, PG_U_UPPERCASE_LETTER},
	{0x000229, 0x000229, PG_U_LOWERCASE_LETTER},
	{0x00022a, 0x00022a, PG_U_UPPERCASE_LETTER},
	{0x00022b, 0x00022b, PG_U_LOWERCASE_LETTER},
	{0x00022c, 0x00022c, PG_U_UPPERCASE_LETTER},
	{0x00022d, 0x00022d, PG_U_LOWERCASE_LETTER},
	{0x00022e, 0x00022e, PG_U_UPPERCASE_LETTER},
	{0x00022f, 0x00022f, PG_U_LOWERCASE_LETTER},
	{0x000230, 0x000230, PG_U_UPPERCASE_LETTER},
	{0x000231, 0x000231, PG_U_LOWERCASE_LETTER},
	{0x000232, 0x000232, PG_U_UPPERCASE_LETTER},
	{0x000233, 0x000239, PG_U_LOWERCASE_LETTER},
	{0x00023a, 0x00023b, PG_U_UPPERCASE_LETTER},
	{0x00023c, 0x00023c, PG_U_LOWERCASE_LETTER},
	{0x00023d, 0x00023e, PG_U_UPPERCASE_LETTER},
	{0x00023f, 0x000240, PG_U_LOWERCASE_LETTER},
	{0x000241, 0x000241, PG_U_UPPERCASE_LETTER},
	{0x000242, 0x000242, PG_U_LOWERCASE_LETTER},
	{0x000243, 0x000246, PG_U_UPPERCASE_LETTER},
	{0x000247, 0x000247, PG_U_LOWERCASE_LETTER},
	{0x000248, 0x000248, PG_U_UPPERCASE_LETTER},
	{0x000249, 0x000249, PG_U_LOWERCASE_LETTER},
	{0x00024a, 0x00024a, PG_U_UPPERCASE_LETTER},
	{0x00024b, 0x00024b, PG_U_LOWERCASE_LETTER},
	{0x00024c, 0x00024c, PG_U_UPPERCASE_LETTER},
	{0x00024d, 0x00024d, PG_U_LOWERCASE_LETTER},
	{0x00024e, 0x00024e, PG_U_UPPERCASE_LETTER},
	{0x00024f, 0x000293, PG_U_LOWERCASE_LETTER},
	{0x000294, 0x000294, PG_U_OTHER_LETTER},
	{0x000295, 0x0002af, PG_U_LOWERCASE_LETTER},
	{0x0002b0, 0x0002c1, PG_U_MODIFIER_LETTER},
	{0x0002c2, 0x0002c5, PG_U_MODIFIER_SYMBOL},
	{0x0002c6, 0x0002d1, PG_U_MODIFIER_LETTER},
	{0x0002d2, 0x0002df, PG_U_MODIFIER_SYMBOL},
	{0x0002e0, 0x0002e4, PG_U_MODIFIER_LETTER},
	{0x0002e5, 0x0002eb, PG_U_MODIFIER_SYMBOL},
	{0x0002ec, 0x0002ec, PG_U_MODIFIER_LETTER},
	{0x0002ed, 0x0002ed, PG_U_MODIFIER_SYMBOL},
	{0x0002ee, 0x0002ee, PG_U_MODIFIER_LETTER},
	{0x0002ef, 0x0002ff, PG_U_MODIFIER_SYMBOL},
	{0x000300, 0x00036f, PG_U_NONSPACING_MARK},
	{0x000370, 0x000370, PG_U_UPPERCASE_LETTER},
	{0x000371, 0x000371, PG_U_LOWERCASE_LETTER},
	{0x000372, 0x000372, PG_U_UPPERCASE_LETTER},
	{0x000373, 0x000373, PG_U_LOWERCASE_LETTER},
	{0x000374, 0x000374, PG_U_MODIFIER_LETTER},
	{0x000375, 0x000375, PG_U_MODIFIER_SYMBOL},
	{0x000376, 0x000376, PG_U_UPPERCASE_LETTER},
	{0x000377, 0x000377, PG_U_LOWERCASE_LETTER},
	{0x00037a, 0x00037a, PG_U_MODIFIER_LETTER},
	{0x00037b, 0x00037d, PG_U_LOWERCASE_LETTER},
	{0x00037e, 0x00037e, PG_U_OTHER_PUNCTUATION},
	{0x00037f, 0x00037f, PG_U_UPPERCASE_LETTER},
	{0x000384, 0x000385, PG_U_MODIFIER_SYMBOL},
	{0x000386, 0x000386, PG_U_UPPERCASE_LETTER},
	{0x000387, 0x000387, PG_U_OTHER_PUNCTUATION},
	{0x000388, 0x00038a, PG_U_UPPERCASE_LETTER},
	{0x00038c, 0x00038c, PG_U_UPPERCASE_LETTER},
	{0x00038e, 0x00038f, PG_U_UPPERCASE_LETTER},
	{0x000390, 0x000390, PG_U_LOWERCASE_LETTER},
	{0x000391, 0x0003a1, PG_U_UPPERCASE_LETTER},
	{0x0003a3, 0x0003ab, PG_U_UPPERCASE_LETTER},
	{0x0003ac, 0x0003ce, PG_U_LOWERCASE_LETTER},
	{0x0003cf, 0x0003cf, PG_U_UPPERCASE_LETTER},
	{0x0003d0, 0x0003d1, PG_U_LOWERCASE_LETTER},
	{0x0003d2, 0x0003d4, PG_U_UPPERCASE_LETTER},
	{0x0003d5, 0x0003d7, PG_U_LOWERCASE_LETTER},
	{0x0003d8, 0x0003d8, PG_U_UPPERCASE_LETTER},
	{0x0003d9, 0x0003d9, PG_U_LOWERCASE_LETTER},
	{0x0003da, 0x0003da, PG_U_UPPERCASE_LETTER},
	{0x0003db, 0x0003db, PG_U_LOWERCASE_LETTER},
	{0x0003dc, 0x0003dc, PG_U_UPPERCASE_LETTER},
	{0x0003dd, 0x0003dd, PG_U_LOWERCASE_LETTER},
	{0x0003de, 0x0003de, PG_U_UPPERCASE_LETTER},
	{0x0003df, 0x0003df, PG_U_LOWERCASE_LETTER},
	{0x0003e0, 0x0003e0, PG_U_UPPERCASE_LETTER},
	{0x0003e1, 0x0003e1, PG_U_LOWERCASE_LETTER},
	{0x0003e2, 0x0003e2, PG_U_UPPERCASE_LETTER},
	{0x0003e3, 0x0003e3, PG_U_LOWERCASE_LETTER},
	{0x0003e4, 0x0003e4, PG_U_UPPERCASE_LETTER},
	{0x0003e5, 0x0003e5, PG_U_LOWERCASE_LETTER},
	{0x0003e6, 0x0003e6, PG_U_UPPERCASE_LETTER},
	{0x0003e7, 0x0003e7, PG_U_LOWERCASE_LETTER},
	{0x0003e8, 0x0003e8, PG_U_UPPERCASE_LETTER},
	{0x0003e9, 0x0003e9, PG_U_LOWERCASE_LETTER},
	{0x0003ea, 0x0003ea, PG_U_UPPERCASE_LETTER},
	{0x0003eb, 0x0003eb, PG_U_LOWERCASE_LETTER},
	{0x0003ec, 0x0003ec, PG_U_UPPERCASE_LETTER},
	{0x0003ed, 0x0003ed, PG_U_LOWERCASE_LETTER},
	{0x0003ee, 0x0003ee, PG_U_UPPERCASE_LETTER},
	{0x0003ef, 0x0003f3, PG_U_LOWERCASE_LETTER},
	{0x0003f4, 0x0003f4, PG_U_UPPERCASE_LETTER},
	{0x0003f5, 0x0003f5, PG_U_LOWERCASE_LETTER},
	{0x0003f6, 0x0003f6, PG_U_MATH_SYMBOL},
	{0x0003f7, 0x0003f7, PG_U_UPPERCASE_LETTER},
	{0x0003f8, 0x0003f8, PG_U_LOWERCASE_LETTER},
	{0x0003f9, 0x0003fa, PG_U_UPPERCASE_LETTER},
	{0x0003fb, 0x0003fc, PG_U_LOWERCASE_LETTER},
	{0x0003fd, 0x00042f, PG_U_UPPERCASE_LETTER},
	{0x000430, 0x00045f, PG_U_LOWERCASE_LETTER},
	{0x000460, 0x000460, PG_U_UPPERCASE_LETTER},
	{0x000461, 0x000461, PG_U_LOWERCASE_LETTER},
	{0x000462, 0x000462, PG_U_UPPERCASE_LETTER},
	{0x000463, 0x000463, PG_U_LOWERCASE_LETTER},
	{0x000464, 0x000464, PG_U_UPPERCASE_LETTER},
	{0x000465, 0x000465, PG_U_LOWERCASE_LETTER},
	{0x000466, 0x000466, PG_U_UPPERCASE_LETTER},
	{0x000467, 0x000467, PG_U_LOWERCASE_LETTER},
	{0x000468, 0x000468, PG_U_UPPERCASE_LETTER},
	{0x000469, 0x000469, PG_U_LOWERCASE_LETTER},
	{0x00046a, 0x00046a, PG_U_UPPERCASE_LETTER},
	{0x00046b, 0x00046b, PG_U_LOWERCASE_LETTER},
	{0x00046c, 0x00046c, PG_U_UPPERCASE_LETTER},
	{0x00046d, 0x00046d, PG_U_LOWERCASE_LETTER},
	{0x00046e, 0x00046e, PG_U_UPPERCASE_LETTER},
	{0x00046f, 0x00046f, PG_U_LOWERCASE_LETTER},
	{0x000470, 0x000470, PG_U_UPPERCASE_LETTER},
	{0x000471, 0x000471, PG_U_LOWERCASE_LETTER},
	{0x000472, 0x000472, PG_U_UPPERCASE_LETTER},
	{0x000473, 0x000473, PG_U_LOWERCASE_LETTER},
	{0x000474, 0x000474, PG_U_UPPERCASE_LETTER},
	{0x000475, 0x000475, PG_U_LOWERCASE_LETTER},
	{0x000476, 0x000476, PG_U_UPPERCASE_LETTER},
	{0x000477, 0x000477, PG_U_LOWERCASE_LETTER},
	{0x000478, 0x000478, PG_U_UPPERCASE_LETTER},
	{0x000479, 0x000479, PG_U_LOWERCASE_LETTER},
	{0x00047a, 0x00047a, PG_U_UPPERCASE_LETTER},
	{0x00047b, 0x00047b, PG_U_LOWERCASE_LETTER},
	{0x00047c, 0x00047c, PG_U_UPPERCASE_LETTER},
	{0x00047d, 0x00047d, PG_U_LOWERCASE_LETTER},
	{0x00047e, 0x00047e, PG_U_UPPERCASE_LETTER},
	{0x00047f, 0x00047f, PG_U_LOWERCASE_LETTER},
	{0x000480, 0x000480, PG_U_UPPERCASE_LETTER},
	{0x000481, 0x000481, PG_U_LOWERCASE_LETTER},
	{0x000482, 0x000482, PG_U_OTHER_SYMBOL},
	{0x000483, 0x000487, PG_U_NONSPACING_MARK},
	{0x000488, 0x000489, PG_U_ENCLOSING_MARK},
	{0x00048a, 0x00048a, PG_U_UPPERCASE_LETTER},
	{0x00048b, 0x00048b, PG_U_LOWERCASE_LETTER},
	{0x00048c, 0x00048c, PG_U_UPPERCASE_LETTER},
	{0x00048d, 0x00048d, PG_U_LOWERCASE_LETTER},
	{0x00048e, 0x00048e, PG_U_UPPERCASE_LETTER},
	{0x00048f, 0x00048f, PG_U_LOWERCASE_LETTER},
	{0x000490, 0x000490, PG_U_UPPERCASE_LETTER},
	{0x000491, 0x000491, PG_U_LOWERCASE_LETTER},
	{0x000492, 0x000492, PG_U_UPPERCASE_LETTER},
	{0x000493, 0x000493, PG_U_LOWERCASE_LETTER},
	{0x000494, 0x000494, PG_U_UPPERCASE_LETTER},
	{0x000495, 0x000495, PG_U_LOWERCASE_LETTER},
	{0x000496, 0x000496, PG_U_UPPERCASE_LETTER},
	{0x000497, 0x000497, PG_U_LOWERCASE_LETTER},
	{0x000498, 0x000498, PG_U_UPPERCASE_LETTER},
	{0x000499, 0x000499, PG_U_LOWERCASE_LETTER},
	{0x00049a, 0x00049a, PG_U_UPPERCASE_LETTER},
	{0x00049b, 0x00049b, PG_U_LOWERCASE_LETTER},
	{0x00049c, 0x00049c, PG_U_UPPERCASE_LETTER},
	{0x00049d, 0x00049d, PG_U_LOWERCASE_LETTER},
	{0x00049e, 0x00049e, PG_U_UPPERCASE_LETTER},
	{0x00049f, 0x00049f, PG_U_LOWERCASE_LETTER},
	{0x0004a0, 0x0004a0, PG_U_UPPERCASE_LETTER},
	{0x0004a1, 0x0004a1, PG_U_LOWERCASE_LETTER},
	{0x0004a2, 0x0004a2, PG_U_UPPERCASE_LETTER},
	{0x0004a3, 0x0004a3, PG_U_LOWERCASE_LETTER},
	{0x0004a4, 0x0004a4, PG_U_UPPERCASE_LETTER},
	{0x0004a5, 0x0004a5, PG_U_LOWERCASE_LETTER},
	{0x0004a6, 0x0004a6, PG_U_UPPERCASE_LETTER},
	{0x0004a7, 0x0004a7, PG_U_LOWERCASE_LETTER},
	{0x0004a8, 0x0004a8, PG_U_UPPERCASE_LETTER},
	{0x0004a9, 0x0004a9, PG_U_LOWERCASE_LETTER},
	{0x0004aa, 0x0004aa, PG_U_UPPERCASE_LETTER},
	{0x0004ab, 0x0004ab, PG_U_LOWERCASE_LETTER},
	{0x0004ac, 0x0004ac, PG_U_UPPERCASE_LETTER},
	{0x0004ad, 0x0004ad, PG_U_LOWERCASE_LETTER},
	{0x0004ae, 0x0004ae, PG_U_UPPERCASE_LETTER},
	{0x0004af, 0x0004af, PG_U_LOWERCASE_LETTER},
	{0x0004b0, 0x0004b0, PG_U_UPPERCASE_LETTER},
	{0x0004b1, 0x0004b1, PG_U_LOWERCASE_LETTER},
	{0x0004b2, 0x0004b2, PG_U_UPPERCASE_LETTER},
	{0x0004b3, 0x0004b3, PG_U_LOWERCASE_LETTER},
	{0x0004b4, 0x0004b4, PG_U_UPPERCASE_LETTER},
	{0x0004b5, 0x0004b5, PG_U_LOWERCASE_LETTER},
	{0x0004b6, 0x0004b6, PG_U_UPPERCASE_LETTER},
	{0x0004b7, 0x0004b7, PG_U_LOWERCASE_LETTER},
	{0x0004b8, 0x0004b8, PG_U_UPPERCASE_LETTER},
	{0x0004b9, 0x0004b9, PG_U_LOWERCASE_LETTER},
	{0x0004ba, 0x0004ba, PG_U_UPPERCASE_LETTER},
	{0x0004bb, 0x0004bb, PG_U_LOWERCASE_LETTER},
	{0x0004bc, 0x0004bc, PG_U_UPPERCASE_LETTER},
	{0x0004bd, 0x0004bd, PG_U_LOWERCASE_LETTER},
	{0x0004be, 0x0004be, PG_U_UPPERCASE_LETTER},
	{0x0004bf, 0x0004bf, PG_U_LOWERCASE_LETTER},
	{0x0004c0, 0x0004c1, PG_U_UPPERCASE_LETTER},
	{0x0004c2, 0x0004c2, PG_U_LOWERCASE_LETTER},
	{0x0004c3, 0x0004c3, PG_U_UPPERCASE_LETTER},
	{0x0004c4, 0x0004c4, PG_U_LOWERCASE_LETTER},
	{0x0004c5, 0x0004c5, PG_U_UPPERCASE_LETTER},
	{0x0004c6, 0x0004c6, PG_U_LOWERCASE_LETTER},
	{0x0004c7, 0x0004c7, PG_U_UPPERCASE_LETTER},
	{0x0004c8, 0x0004c8, PG_U_LOWERCASE_LETTER},
	{0x0004c9, 0x0004c9, PG_U_UPPERCASE_LETTER},
	{0x0004ca, 0x0004ca, PG_U_LOWERCASE_LETTER},
	{0x0004cb, 0x0004cb, PG_U_UPPERCASE_LETTER},
	{0x0004cc, 0x0004cc, PG_U_LOWERCASE_LETTER},
	{0x0004cd, 0x0004cd, PG_U_UPPERCASE_LETTER},
	{0x0004ce, 0x0004cf, PG_U_LOWERCASE_LETTER},
	{0x0004d0, 0x0004d0, PG_U_UPPERCASE_LETTER},
	{0x0004d1, 0x0004d1, PG_U_LOWERCASE_LETTER},
	{0x0004d2, 0x0004d2, PG_U_UPPERCASE_LETTER},
	{0x0004d3, 0x0004d3, PG_U_LOWERCASE_LETTER},
	{0x0004d4, 0x0004d4, PG_U_UPPERCASE_LETTER},
	{0x0004d5, 0x0004d5, PG_U_LOWERCASE_LETTER},
	{0x0004d6, 0x0004d6, PG_U_UPPERCASE_LETTER},
	{0x0004d7, 0x0004d7, PG_U_LOWERCASE_LETTER},
	{0x0004d8, 0x0004d8, PG_U_UPPERCASE_LETTER},
	{0x0004d9, 0x0004d9, PG_U_LOWERCASE_LETTER},
	{0x0004da, 0x0004da, PG_U_UPPERCASE_LETTER},
	{0x0004db, 0x0004db, PG_U_LOWERCASE_LETTER},
	{0x0004dc, 0x0004dc, PG_U_UPPERCASE_LETTER},
	{0x0004dd, 0x0004dd, PG_U_LOWERCASE_LETTER},
	{0x0004de, 0x0004de, PG_U_UPPERCASE_LETTER},
	{0x0004df, 0x0004df, PG_U_LOWERCASE_LETTER},
	{0x0004e0, 0x0004e0, PG_U_UPPERCASE_LETTER},
	{0x0004e1, 0x0004e1, PG_U_LOWERCASE_LETTER},
	{0x0004e2, 0x0004e2, PG_U_UPPERCASE_LETTER},
	{0x0004e3, 0x0004e3, PG_U_LOWERCASE_LETTER},
	{0x0004e4, 0x0004e4, PG_U_UPPERCASE_LETTER},
	{0x0004e5, 0x0004e5, PG_U_LOWERCASE_LETTER},
	{0x0004e6, 0x0004e6, PG_U_UPPERCASE_LETTER},
	{0x0004e7, 0x0004e7, PG_U_LOWERCASE_LETTER},
	{0x0004e8, 0x0004e8, PG_U_UPPERCASE_LETTER},
	{0x0004e9, 0x0004e9, PG_U_LOWERCASE_LETTER},
	{0x0004ea, 0x0004ea, PG_U_UPPERCASE_LETTER},
	{0x0004eb, 0x0004eb, PG_U_LOWERCASE_LETTER},
	{0x0004ec, 0x0004ec, PG_U_UPPERCASE_LETTER},
	{0x0004ed, 0x0004ed, PG_U_LOWERCASE_LETTER},
	{0x0004ee, 0x0004ee, PG_U_UPPERCASE_LETTER},
	{0x0004ef, 0x0004ef, PG_U_LOWERCASE_LETTER},
	{0x0004f0, 0x0004f0, PG_U_UPPERCASE_LETTER},
	{0x0004f1, 0x0004f1, PG_U_LOWERCASE_LETTER},
	{0x0004f2, 0x0004f2, PG_U_UPPERCASE_LETTER},
	{0x0004f3, 0x0004f3, PG_U_LOWERCASE_LETTER},
	{0x0004f4, 0x0004f4, PG_U_UPPERCASE_LETTER},
	{0x0004f5, 0x0004f5, PG_U_LOWERCASE_LETTER},
	{0x0004f6, 0x0004f6, PG_U_UPPERCASE_LETTER},
	{0x0004f7, 0x0004f7, PG_U_LOWERCASE_LETTER},
	{0x0004f8, 0x0004f8, PG_U_UPPERCASE_LETTER},
	{0x0004f9, 0x0004f9, PG_U_LOWERCASE_LETTER},
	{0x0004fa, 0x0004fa, PG_U_UPPERCASE_LETTER},
	{0x0004fb, 0x0004fb, PG_U_LOWERCASE_LETTER},
	{0x0004fc, 0x0004fc, PG_U_UPPERCASE_LETTER},
	{0x0004fd, 0x0004fd, PG_U_LOWERCASE_LETTER},
	{0x0004fe, 0x0004fe, PG_U_UPPERCASE_LETTER},
	{0x0004ff, 0x0004ff, PG_U_LOWERCASE_LETTER},
	{0x000500, 0x000500, PG_U_UPPERCASE_LETTER},
	{0x000501, 0x000501, PG_U_LOWERCASE_LETTER},
	{0x000502, 0x000502, PG_U_UPPERCASE_LETTER},
	{0x000503, 0x000503, PG_U_LOWERCASE_LETTER},
	{0x000504, 0x000504, PG_U_UPPERCASE_LETTER},
	{0x000505, 0x000505, PG_U_LOWERCASE_LETTER},
	{0x000506, 0x000506, PG_U_UPPERCASE_LETTER},
	{0x000507, 0x000507, PG_U_LOWERCASE_LETTER},
	{0x000508, 0x000508, PG_U_UPPERCASE_LETTER},
	{0x000509, 0x000509, PG_U_LOWERCASE_LETTER},
	{0x00050a, 0x00050a, PG_U_UPPERCASE_LETTER},
	{0x00050b, 0x00050b, PG_U_LOWERCASE_LETTER},
	{0x00050c, 0x00050c, PG_U_UPPERCASE_LETTER},
	{0x00050d, 0x00050d, PG_U_LOWERCASE_LETTER},
	{0x00050e, 0x00050e, PG_U_UPPERCASE_LETTER},
	{0x00050f, 0x00050f, PG_U_LOWERCASE_LETTER},
	{0x000510, 0x000510, PG_U_UPPERCASE_LETTER},
	{0x000511, 0x000511, PG_U_LOWERCASE_LETTER},
	{0x000512, 0x000512, PG_U_UPPERCASE_LETTER},
	{0x000513, 0x000513, PG_U_LOWERCASE_LETTER},
	{0x000514, 0x000514, PG_U_UPPERCASE_LETTER},
	{0x000515, 0x000515, PG_U_LOWERCASE_LETTER},
	{0x000516, 0x000516, PG_U_UPPERCASE_LETTER},
	{0x000517, 0x000517, PG_U_LOWERCASE_LETTER},
	{0x000518, 0x000518, PG_U_UPPERCASE_LETTER},
	{0x000519, 0x000519, PG_U_LOWERCASE_LETTER},
	{0x00051a, 0x00051a, PG_U_UPPERCASE_LETTER},
	{0x00051b, 0x00051b, PG_U_LOWERCASE_LETTER},
	{0x00051c, 0x00051c, PG_U_UPPERCASE_LETTER},
	{0x00051d, 0x00051d, PG_U_LOWERCASE_LETTER},
	{0x00051e, 0x00051e, PG_U_UPPERCASE_LETTER},
	{0x00051f, 0x00051f, PG_U_LOWERCASE_LETTER},
	{0x000520, 0x000520, PG_U_UPPERCASE_LETTER},
	{0x000521, 0x000521, PG_U_LOWERCASE_LETTER},
	{0x000522, 0x000522, PG_U_UPPERCASE_LETTER},
	{0x000523, 0x000523, PG_U_LOWERCASE_LETTER},
	{0x000524, 0x000524, PG_U_UPPERCASE_LETTER},
	{0x000525, 0x000525, PG_U_LOWERCASE_LETTER},
	{0x000526, 0x000526, PG_U_UPPERCASE_LETTER},
	{0x000527, 0x000527, PG_U_LOWERCASE_LETTER},
	{0x000528, 0x000528, PG_U_UPPERCASE_LETTER},
	{0x000529, 0x000529, PG_U_LOWERCASE_LETTER},
	{0x00052a, 0x00052a, PG_U_UPPERCASE_LETTER},
	{0x00052b, 0x00052b, PG_U_LOWERCASE_LETTER},
	{0x00052c, 0x00052c, PG_U_UPPERCASE_LETTER},
	{0x00052d, 0x00052d, PG_U_LOWERCASE_LETTER},
	{0x00052e, 0x00052e, PG_U_UPPERCASE_LETTER},
	{0x00052f, 0x00052f, PG_U_LOWERCASE_LETTER},
	{0x000531, 0x000556, PG_U_UPPERCASE_LETTER},
	{0x000559, 0x000559, PG_U_MODIFIER_LETTER},
	{0x00055a, 0x00055f, PG_U_OTHER_PUNCTUATION},
	{0x000560, 0x000588, PG_U_LOWERCASE_LETTER},
	{0x000589, 0x000589, PG_U_OTHER_PUNCTUATION},
	{0x00058a, 0x00058a, PG_U_DASH_PUNCTUATION},
	{0x00058d, 0x00058e, PG_U_OTHER_SYMBOL},
	{0x00058f, 0x00058f, PG_U_CURRENCY_SYMBOL},
	{0x000591, 0x0005bd, PG_U_NONSPACING_MARK},
	{0x0005be, 0x0005be, PG_U_DASH_PUNCTUATION},
	{0x0005bf, 0x0005bf, PG_U_NONSPACING_MARK},
	{0x0005c0, 0x0005c0, PG_U_OTHER_PUNCTUATION},
	{0x0005c1, 0x0005c2, PG_U_NONSPACING_MARK},
	{0x0005c3, 0x0005c3, PG_U_OTHER_PUNCTUATION},
	{0x0005c4, 0x0005c5, PG_U_NONSPACING_MARK},
	{0x0005c6, 0x0005c6, PG_U_OTHER_PUNCTUATION},
	{0x0005c7, 0x0005c7, PG_U_NONSPACING_MARK},
	{0x0005d0, 0x0005ea, PG_U_OTHER_LETTER},
	{0x0005ef, 0x0005f2, PG_U_OTHER_LETTER},
	{0x0005f3, 0x0005f4, PG_U_OTHER_PUNCTUATION},
	{0x000600, 0x000605, PG_U_FORMAT},
	{0x000606, 0x000608, PG_U_MATH_SYMBOL},
	{0x000609, 0x00060a, PG_U_OTHER_PUNCTUATION},
	{0x00060b, 0x00060b, PG_U_CURRENCY_SYMBOL},
	{0x00060c, 0x00060d, PG_U_OTHER_PUNCTUATION},
	{0x00060e, 0x00060f, PG_U_OTHER_SYMBOL},
	{0x000610, 0x00061a, PG_U_NONSPACING_MARK},
	{0x00061b, 0x00061b, PG_U_OTHER_PUNCTUATION},
	{0x00061c, 0x00061c, PG_U_FORMAT},
	{0x00061d, 0x00061f, PG_U_OTHER_PUNCTUATION},
	{0x000620, 0x00063f, PG_U_OTHER_LETTER},
	{0x000640, 0x000640, PG_U_MODIFIER_LETTER},
	{0x000641, 0x00064a, PG_U_OTHER_LETTER},
	{0x00064b, 0x00065f, PG_U_NONSPACING_MARK},
	{0x000660, 0x000669, PG_U_DECIMAL_NUMBER},
	{0x00066a, 0x00066d, PG_U_OTHER_PUNCTUATION},
	{0x00066e, 0x00066f, PG_U_OTHER_LETTER},
	{0x000670, 0x000670, PG_U_NONSPACING_MARK},
	{0x000671, 0x0006d3, PG_U_OTHER_LETTER},
	{0x0006d4, 0x0006d4, PG_U_OTHER_PUNCTUATION},
	{0x0006d5, 0x0006d5, PG_U_OTHER_LETTER},
	{0x0006d6, 0x0006dc, PG_U_NONSPACING_MARK},
	{0x0006dd, 0x0006dd, PG_U_FORMAT},
	{0x0006de, 0x0006de, PG_U_OTHER_SYMBOL},
	{0x0006df, 0x0006e4, PG_U_NONSPACING_MARK},
	{0x0006e5, 0x0006e6, PG_U_MODIFIER_LETTER},
	{0x0006e7, 0x0006e8, PG_U_NONSPACING_MARK},
	{0x0006e9, 0x0006e9, PG_U_OTHER_SYMBOL},
	{0x0006ea, 0x0006ed, PG_U_NONSPACING_MARK},
	{0x0006ee, 0x0006ef, PG_U_OTHER_LETTER},
	{0x0006f0, 0x0006f9, PG_U_DECIMAL_NUMBER},
	{0x0006fa, 0x0006fc, PG_U_OTHER_LETTER},
	{0x0006fd, 0x0006fe, PG_U_OTHER_SYMBOL},
	{0x0006ff, 0x0006ff, PG_U_OTHER_LETTER},
	{0x000700, 0x00070d, PG_U_OTHER_PUNCTUATION},
	{0x00070f, 0x00070f, PG_U_FORMAT},
	{0x000710, 0x000710, PG_U_OTHER_LETTER},
	{0x000711, 0x000711, PG_U_NONSPACING_MARK},
	{0x000712, 0x00072f, PG_U_OTHER_LETTER},
	{0x000730, 0x00074a, PG_U_NONSPACING_MARK},
	{0x00074d, 0x0007a5, PG_U_OTHER_LETTER},
	{0x0007a6, 0x0007b0, PG_U_NONSPACING_MARK},
	{0x0007b1, 0x0007b1, PG_U_OTHER_LETTER},
	{0x0007c0, 0x0007c9, PG_U_DECIMAL_NUMBER},
	{0x0007ca, 0x0007ea, PG_U_OTHER_LETTER},
	{0x0007eb, 0x0007f3, PG_U_NONSPACING_MARK},
	{0x0007f4, 0x0007f5, PG_U_MODIFIER_LETTER},
	{0x0007f6, 0x0007f6, PG_U_OTHER_SYMBOL},
	{0x0007f7, 0x0007f9, PG_U_OTHER_PUNCTUATION},
	{0x0007fa, 0x0007fa, PG_U_MODIFIER_LETTER},
	{0x0007fd, 0x0007fd, PG_U_NONSPACING_MARK},
	{0x0007fe, 0x0007ff, PG_U_CURRENCY_SYMBOL},
	{0x000800, 0x000815, PG_U_OTHER_LETTER},
	{0x000816, 0x000819, PG_U_NONSPACING_MARK},
	{0x00081a, 0x00081a, PG_U_MODIFIER_LETTER},
	{0x00081b, 0x000823, PG_U_NONSPACING_MARK},
	{0x000824, 0x000824, PG_U_MODIFIER_LETTER},
	{0x000825, 0x000827, PG_U_NONSPACING_MARK},
	{0x000828, 0x000828, PG_U_MODIFIER_LETTER},
	{0x000829, 0x00082d, PG_U_NONSPACING_MARK},
	{0x000830, 0x00083e, PG_U_OTHER_PUNCTUATION},
	{0x000840, 0x000858, PG_U_OTHER_LETTER},
	{0x000859, 0x00085b, PG_U_NONSPACING_MARK},
	{0x00085e, 0x00085e, PG_U_OTHER_PUNCTUATION},
	{0x000860, 0x00086a, PG_U_OTHER_LETTER},
	{0x000870, 0x000887, PG_U_OTHER_LETTER},
	{0x000888, 0x000888, PG_U_MODIFIER_SYMBOL},
	{0x000889, 0x00088e, PG_U_OTHER_LETTER},
	{0x000890, 0x000891, PG_U_FORMAT},
	{0x000898, 0x00089f, PG_U_NONSPACING_MARK},
	{0x0008a0, 0x0008c8, PG_U_OTHER_LETTER},
	{0x0008c9, 0x0008c9, PG_U_MODIFIER_LETTER},
	{0x0008ca, 0x0008e1, PG_U_NONSPACING_MARK},
	{0x0008e2, 0x0008e2, PG_U_FORMAT},
	{0x0008e3, 0x000902, PG_U_NONSPACING_MARK},
	{0x000903, 0x000903, PG_U_SPACING_MARK},
	{0x000904, 0x000939, PG_U_OTHER_LETTER},
	{0x00093a, 0x00093a, PG_U_NONSPACING_MARK},
	{0x00093b, 0x00093b, PG_U_SPACING_MARK},
	{0x00093c, 0x00093c, PG_U_NONSPACING_MARK},
	{0x00093d, 0x00093d, PG_U_OTHER_LETTER},
	{0x00093e, 0x000940, PG_U_SPACING_MARK},
	{0x000941, 0x000948, PG_U_NONSPACING_MARK},
	{0x000949, 0x00094c, PG_U_SPACING_MARK},
	{0x00094d, 0x00094d, PG_U_NONSPACING_MARK},
	{0x00094e, 0x00094f, PG_U_SPACING_MARK},
	{0x000950, 0x000950, PG_U_OTHER_LETTER},
	{0x000951, 0x000957, PG_U_NONSPACING_MARK},
	{0x000958, 0x000961, PG_U_OTHER_LETTER},
	{0x000962, 0x000963, PG_U_NONSPACING_MARK},
	{0x000964, 0x000965, PG_U_OTHER_PUNCTUATION},
	{0x000966, 0x00096f, PG_U_DECIMAL_NUMBER},
	{0x000970, 0x000970, PG_U_OTHER_PUNCTUATION},
	{0x000971, 0x000971, PG_U_MODIFIER_LETTER},
	{0x000972, 0x000980, PG_U_OTHER_LETTER},
	{0x000981, 0x000981, PG_U_NONSPACING_MARK},
	{0x000982, 0x000983, PG_U_SPACING_MARK},
	{0x000985, 0x00098c, PG_U_OTHER_LETTER},
	{0x00098f, 0x000990, PG_U_OTHER_LETTER},
	{0x000993, 0x0009a8, PG_U_OTHER_LETTER},
	{0x0009aa, 0x0009b0, PG_U_OTHER_LETTER},
	{0x0009b2, 0x0009b2, PG_U_OTHER_LETTER},
	{0x0009b6, 0x0009b9, PG_U_OTHER_LETTER},
	{0x0009bc, 0x0009bc, PG_U_NONSPACING_MARK},
	{0x0009bd, 0x0009bd, PG_U_OTHER_LETTER},
	{0x0009be, 0x0009c0, PG_U_SPACING_MARK},
	{0x0009c1, 0x0009c4, PG_U_NONSPACING_MARK},
	{0x0009c7, 0x0009c8, PG_U_SPACING_MARK},
	{0x0009cb, 0x0009cc, PG_U_SPACING_MARK},
	{0x0009cd, 0x0009cd, PG_U_NONSPACING_MARK},
	{0x0009ce, 0x0009ce, PG_U_OTHER_LETTER},
	{0x0009d7, 0x0009d7, PG_U_SPACING_MARK},
	{0x0009dc, 0x0009dd, PG_U_OTHER_LETTER},
	{0x0009df, 0x0009e1, PG_U_OTHER_LETTER},
	{0x0009e2, 0x0009e3, PG_U_NONSPACING_MARK},
	{0x0009e6, 0x0009ef, PG_U_DECIMAL_NUMBER},
	{0x0009f0, 0x0009f1, PG_U_OTHER_LETTER},
	{0x0009f2, 0x0009f3, PG_U_CURRENCY_SYMBOL},
	{0x0009f4, 0x0009f9, PG_U_OTHER_NUMBER},
	{0x0009fa, 0x0009fa, PG_U_OTHER_SYMBOL},
	{0x0009fb, 0x0009fb, PG_U_CURRENCY_SYMBOL},
	{0x0009fc, 0x0009fc, PG_U_OTHER_LETTER},
	{0x0009fd, 0x0009fd, PG_U_OTHER_PUNCTUATION},
	{0x0009fe, 0x0009fe, PG_U_NONSPACING_MARK},
	{0x000a01, 0x000a02, PG_U_NONSPACING_MARK},
	{0x000a03, 0x000a03, PG_U_SPACING_MARK},
	{0x000a05, 0x000a0a, PG_U_OTHER_LETTER},
	{0x000a0f, 0x000a10, PG_U_OTHER_LETTER},
	{0x000a13, 0x000a28, PG_U_OTHER_LETTER},
	{0x000a2a, 0x000a30, PG_U_OTHER_LETTER},
	{0x000a32, 0x000a33, PG_U_OTHER_LETTER},
	{0x000a35, 0x000a36, PG_U_OTHER_LETTER},
	{0x000a38, 0x000a39, PG_U_OTHER_LETTER},
	{0x000a3c, 0x000a3c, PG_U_NONSPACING_MARK},
	{0x000a3e, 0x000a40, PG_U_SPACING_MARK},
	{0x000a41, 0x000a42, PG_U_NONSPACING_MARK},
	{0x000a47, 0x000a48, PG_U_NONSPACING_MARK},
	{0x000a4b, 0x000a4d, PG_U_NONSPACING_MARK},
	{0x000a51, 0x000a51, PG_U_NONSPACING_MARK},
	{0x000a59, 0x000a5c, PG_U_OTHER_LETTER},
	{0x000a5e, 0x000a5e, PG_U_OTHER_LETTER},
	{0x000a66, 0x000a6f, PG_U_DECIMAL_NUMBER},
	{0x000a70, 0x000a71, PG_U_NONSPACING_MARK},
	{0x000a72, 0x000a74, PG_U_OTHER_LETTER},
	{0x000a75, 0x000a75, PG_U_NONSPACING_MARK},
	{0x000a76, 0x000a76, PG_U_OTHER_PUNCTUATION},
	{0x000a81, 0x000a82, PG_U_NONSPACING_MARK},
	{0x000a83, 0x000a83, PG_U_SPACING_MARK},
	{0x000a85, 0x000a8d, PG_U_OTHER_LETTER},
	{0x000a8f, 0x000a91, PG_U_OTHER_LETTER},
	{0x000a93, 0x000aa8, PG_U_OTHER_LETTER},
	{0x000aaa, 0x000ab0, PG_U_OTHER_LETTER},
	{0x000ab2, 0x000ab3, PG_U_OTHER_LETTER},
	{0x000ab5, 0x000ab9, PG_U_OTHER_LETTER},
	{0x000abc, 0x000abc, PG_U_NONSPACING_MARK},
	{0x000abd, 0x000abd, PG_U_OTHER_LETTER},
	{0x000abe, 0x000ac0, PG_U_SPACING_MARK},
	{0x000ac1, 0x000ac5, PG_U_NONSPACING_MARK},
	{0x000ac7, 0x000ac8, PG_U_NONSPACING_MARK},
	{0x000ac9, 0x000ac9, PG_U_SPACING_MARK},
	{0x000acb, 0x000acc, PG_U_SPACING_MARK},
	{0x000acd, 0x000acd, PG_U_NONSPACING_MARK},
	{0x000ad0, 0x000ad0, PG_U_OTHER_LETTER},
	{0x000ae0, 0x000ae1, PG_U_OTHER_LETTER},
	{0x000ae2, 0x000ae3, PG_U_NONSPACING_MARK},
	{0x000ae6, 0x000aef, PG_U_DECIMAL_NUMBER},
	{0x000af0, 0x000af0, PG_U_OTHER_PUNCTUATION},
	{0x000af1, 0x000af1, PG_U_CURRENCY_SYMBOL},
	{0x000af9, 0x000af9, PG_U_OTHER_LETTER},
	{0x000afa, 0x000aff, PG_U_NONSPACING_MARK},
	{0x000b01, 0x000b01, PG_U_NONSPACING_MARK},
	{0x000b02, 0x000b03, PG_U_SPACING_MARK},
	{0x000b05, 0x000b0c, PG_U_OTHER_LETTER},
	{0x000b0f, 0x000b10, PG_U_OTHER_LETTER},
	{0x000b13, 0x000b28, PG_U_OTHER_LETTER},
	{0x000b2a, 0x000b30, PG_U_OTHER_LETTER},
	{0x000b32, 0x000b33, PG_U_OTHER_LETTER},
	{0x000b35, 0x000b39, PG_U_OTHER_LETTER},
	{0x000b3c, 0x000b3c, PG_U_NONSPACING_MARK},
	{0x000b3d, 0x000b3d, PG_U_OTHER_LETTER},
	{0x000b3e, 0x000b3e, PG_U_SPACING_MARK},
	{0x000b3f, 0x000b3f, PG_U_NONSPACING_MARK},
	{0x000b40, 0x000b40, PG_U_SPACING_MARK},
	{0x000b41, 0x000b44, PG_U_NONSPACING_MARK},
	{0x000b47, 0x000b48, PG_U_SPACING_MARK},
	{0x000b4b, 0x000b4c, PG_U_SPACING_MARK},
	{0x000b4d, 0x000b4d, PG_U_NONSPACING_MARK},
	{0x000b55, 0x000b56, PG_U_NONSPACING_MARK},
	{0x000b57, 0x000b57, PG_U_SPACING_MARK},
	{0x000b5c, 0x000b5d, PG_U_OTHER_LETTER},
	{0x000b5f, 0x000b61, PG_U_OTHER_LETTER},
	{0x000b62, 0x000b63, PG_U_NONSPACING_MARK},
	{0x000b66, 0x000b6f, PG_U_DECIMAL_NUMBER},
	{0x000b70, 0x000b70, PG_U_OTHER_SYMBOL},
	{0x000b71, 0x000b71, PG_U_OTHER_LETTER},
	{0x000b72, 0x000b77, PG_U_OTHER_NUMBER},
	{0x000b82, 0x000b82, PG_U_NONSPACING_MARK},
	{0x000b83, 0x000b83, PG_U_OTHER_LETTER},
	{0x000b85, 0x000b8a, PG_U_OTHER_LETTER},
	{0x000b8e, 0x000b90, PG_U_OTHER_LETTER},
	{0x000b92, 0x000b95, PG_U_OTHER_LETTER},
	{0x000b99, 0x000b9a, PG_U_OTHER_LETTER},
	{0x000b9c, 0x000b9c, PG_U_OTHER_LETTER},
	{0x000b9e, 0x000b9f, PG_U_OTHER_LETTER},
	{0x000ba3, 0x000ba4, PG_U_OTHER_LETTER},
	{0x000ba8, 0x000baa, PG_U_OTHER_LETTER},
	{0x000bae, 0x000bb9, PG_U_OTHER_LETTER},
	{0x000bbe, 0x000bbf, PG_U_SPACING_MARK},
	{0x000bc0, 0x000bc0, PG_U_NONSPACING_MARK},
	{0x000bc1, 0x000bc2, PG_U_SPACING_MARK},
	{0x000bc6, 0x000bc8, PG_U_SPACING_MARK},
	{0x000bca, 0x000bcc, PG_U_SPACING_MARK},
	{0x000bcd, 0x000bcd, PG_U_NONSPACING_MARK},
	{0x000bd0, 0x000bd0, PG_U_OTHER_LETTER},
	{0x000bd7, 0x000bd7, PG_U_SPACING_MARK},
	{0x000be6, 0x000bef, PG_U_DECIMAL_NUMBER},
	{0x000bf0, 0x000bf2, PG_U_OTHER_NUMBER},
	{0x000bf3, 0x000bf8, PG_U_OTHER_SYMBOL},
	{0x000bf9, 0x000bf9, PG_U_CURRENCY_SYMBOL},
	{0x000bfa, 0x000bfa, PG_U_OTHER_SYMBOL},
	{0x000c00, 0x000c00, PG_U_NONSPACING_MARK},
	{0x000c01, 0x000c03, PG_U_SPACING_MARK},
	{0x000c04, 0x000c04, PG_U_NONSPACING_MARK},
	{0x000c05, 0x000c0c, PG_U_OTHER_LETTER},
	{0x000c0e, 0x000c10, PG_U_OTHER_LETTER},
	{0x000c12, 0x000c28, PG_U_OTHER_LETTER},
	{0x000c2a, 0x000c39, PG_U_OTHER_LETTER},
	{0x000c3c, 0x000c3c, PG_U_NONSPACING_MARK},
	{0x000c3d, 0x000c3d, PG_U_OTHER_LETTER},
	{0x000c3e, 0x000c40, PG_U_NONSPACING_MARK},
	{0x000c41, 0x000c44, PG_U_SPACING_MARK},
	{0x000c46, 0x000c48, PG_U_NONSPACING_MARK},
	{0x000c4a, 0x000c4d, PG_U_NONSPACING_MARK},
	{0x000c55, 0x000c56, PG_U_NONSPACING_MARK},
	{0x000c58, 0x000c5a, PG_U_OTHER_LETTER},
	{0x000c5d, 0x000c5d, PG_U_OTHER_LETTER},
	{0x000c60, 0x000c61, PG_U_OTHER_LETTER},
	{0x000c62, 0x000c63, PG_U_NONSPACING_MARK},
	{0x000c66, 0x000c6f, PG_U_DECIMAL_NUMBER},
	{0x000c77, 0x000c77, PG_U_OTHER_PUNCTUATION},
	{0x000c78, 0x000c7e, PG_U_OTHER_NUMBER},
	{0x000c7f, 0x000c7f, PG_U_OTHER_SYMBOL},
	{0x000c80, 0x000c80, PG_U_OTHER_LETTER},
	{0x000c81, 0x000c81, PG_U_NONSPACING_MARK},
	{0x000c82, 0x000c83, PG_U_SPACING_MARK},
	{0x000c84, 0x000c84, PG_U_OTHER_PUNCTUATION},
	{0x000c85, 0x000c8c, PG_U_OTHER_LETTER},
	{0x000c8e, 0x000c90, PG_U_OTHER_LETTER},
	{0x000c92, 0x000ca8, PG_U_OTHER_LETTER},
	{0x000caa, 0x000cb3, PG_U_OTHER_LETTER},
	{0x000cb5, 0x000cb9, PG_U_OTHER_LETTER},
	{0x000cbc, 0x000cbc, PG_U_NONSPACING_MARK},
	{0x000cbd, 0x000cbd, PG_U_OTHER_LETTER},
	{0x000cbe, 0x000cbe, PG_U_SPACING_MARK},
	{0x000cbf, 0x000cbf, PG_U_NONSPACING_MARK},
	{0x000cc0, 0x000cc4, PG_U_SPACING_MARK},
	{0x000cc6, 0x000cc6, PG_U_NONSPACING_MARK},
	{0x000cc7, 0x000cc8, PG_U_SPACING_MARK},
	{0x000cca, 0x000ccb, PG_U_SPACING_MARK},
	{0x000ccc, 0x000ccd, PG_U_NONSPACING_MARK},
	{0x000cd5, 0x000cd6, PG_U_SPACING_MARK},
	{0x000cdd, 0x000cde, PG_U_OTHER_LETTER},
	{0x000ce0, 0x000ce1, PG_U_OTHER_LETTER},
	{0x000ce2, 0x000ce3, PG_U_NONSPACING_MARK},
	{0x000ce6, 0x000cef, PG_U_DECIMAL_NUMBER},
	{0x000cf1, 0x000cf2, PG_U_OTHER_LETTER},
	{0x000cf3, 0x000cf3, PG_U_SPACING_MARK},
	{0x000d00, 0x000d01, PG_U_NONSPACING_MARK},
	{0x000d02, 0x000d03, PG_U_SPACING_MARK},
	{0x000d04, 0x000d0c, PG_U_OTHER_LETTER},
	{0x000d0e, 0x000d10, PG_U_OTHER_LETTER},
	{0x000d12, 0x000d3a, PG_U_OTHER_LETTER},
	{0x000d3b, 0x000d3c, PG_U_NONSPACING_MARK},
	{0x000d3d, 0x000d3d, PG_U_OTHER_LETTER},
	{0x000d3e, 0x000d40, PG_U_SPACING_MARK},
	{0x000d41, 0x000d44, PG_U_NONSPACING_MARK},
	{0x000d46, 0x000d48, PG_U_SPACING_MARK},
	{0x000d4a, 0x000d4c, PG_U_SPACING_MARK},
	{0x000d4d, 0x000d4d, PG_U_NONSPACING_MARK},
	{0x000d4e, 0x000d4e, PG_U_OTHER_LETTER},
	{0x000d4f, 0x000d4f, PG_U_OTHER_SYMBOL},
	{0x000d54, 0x000d56, PG_U_OTHER_LETTER},
	{0x000d57, 0x000d57, PG_U_SPACING_MARK},
	{0x000d58, 0x000d5e, PG_U_OTHER_NUMBER},
	{0x000d5f, 0x000d61, PG_U_OTHER_LETTER},
	{0x000d62, 0x000d63, PG_U_NONSPACING_MARK},
	{0x000d66, 0x000d6f, PG_U_DECIMAL_NUMBER},
	{0x000d70, 0x000d78, PG_U_OTHER_NUMBER},
	{0x000d79, 0x000d79, PG_U_OTHER_SYMBOL},
	{0x000d7a, 0x000d7f, PG_U_OTHER_LETTER},
	{0x000d81, 0x000d81, PG_U_NONSPACING_MARK},
	{0x000d82, 0x000d83, PG_U_SPACING_MARK},
	{0x000d85, 0x000d96, PG_U_OTHER_LETTER},
	{0x000d9a, 0x000db1, PG_U_OTHER_LETTER},
	{0x000db3, 0x000dbb, PG_U_OTHER_LETTER},
	{0x000dbd, 0x000dbd, PG_U_OTHER_LETTER},
	{0x000dc0, 0x000dc6, PG_U_OTHER_LETTER},
	{0x000dca, 0x000dca, PG_U_NONSPACING_MARK},
	{0x000dcf, 0x000dd1, PG_U_SPACING_MARK},
	{0x000dd2, 0x000dd4, PG_U_NONSPACING_MARK},
	{0x000dd6, 0x000dd6, PG_U_NONSPACING_MARK},
	{0x000dd8, 0x000ddf, PG_U_SPACING_MARK},
	{0x000de6, 0x000def, PG_U_DECIMAL_NUMBER},
	{0x000df2, 0x000df3, PG_U_SPACING_MARK},
	{0x000df4, 0x000df4, PG_U_OTHER_PUNCTUATION},
	{0x000e01, 0x000e30, PG_U_OTHER_LETTER},
	{0x000e31, 0x000e31, PG_U_NONSPACING_MARK},
	{0x000e32, 0x000e33, PG_U_OTHER_LETTER},
	{0x000e34, 0x000e3a, PG_U_NONSPACING_MARK},
	{0x000e3f, 0x000e3f, PG_U_CURRENCY_SYMBOL},
	{0x000e40, 0x000e45, PG_U_OTHER_LETTER},
	{0x000e46, 0x000e46, PG_U_MODIFIER_LETTER},
	{0x000e47, 0x000e4e, PG_U_NONSPACING_MARK},
	{0x000e4f, 0x000e4f, PG_U_OTHER_PUNCTUATION},
	{0x000e50, 0x000e59, PG_U_DECIMAL_NUMBER},
	{0x000e5a, 0x000e5b, PG_U_OTHER_PUNCTUATION},
	{0x000e81, 0x000e82, PG_U_OTHER_LETTER},
	{0x000e84, 0x000e84, PG_U_OTHER_LETTER},
	{0x000e86, 0x000e8a, PG_U_OTHER_LETTER},
	{0x000e8c, 0x000ea3, PG_U_OTHER_LETTER},
	{0x000ea5, 0x000ea5, PG_U_OTHER_LETTER},
	{0x000ea7, 0x000eb0, PG_U_OTHER_LETTER},
	{0x000eb1, 0x000eb1, PG_U_NONSPACING_MARK},
	{0x000eb2, 0x000eb3, PG_U_OTHER_LETTER},
	{0x000eb4, 0x000ebc, PG_U_NONSPACING_MARK},
	{0x000ebd, 0x000ebd, PG_U_OTHER_LETTER},
	{0x000ec0, 0x000ec4, PG_U_OTHER_LETTER},
	{0x000ec6, 0x000ec6, PG_U_MODIFIER_LETTER},
	{0x000ec8, 0x000ece, PG_U_NONSPACING_MARK},
	{0x000ed0, 0x000ed9, PG_U_DECIMAL_NUMBER},
	{0x000edc, 0x000edf, PG_U_OTHER_LETTER},
	{0x000f00, 0x000f00, PG_U_OTHER_LETTER},
	{0x000f01, 0x000f03, PG_U_OTHER_SYMBOL},
	{0x000f04, 0x000f12, PG_U_OTHER_PUNCTUATION},
	{0x000f13, 0x000f13, PG_U_OTHER_SYMBOL},
	{0x000f14, 0x000f14, PG_U_OTHER_PUNCTUATION},
	{0x000f15, 0x000f17, PG_U_OTHER_SYMBOL},
	{0x000f18, 0x000f19, PG_U_NONSPACING_MARK},
	{0x000f1a, 0x000f1f, PG_U_OTHER_SYMBOL},
	{0x000f20, 0x000f29, PG_U_DECIMAL_NUMBER},
	{0x000f2a, 0x000f33, PG_U_OTHER_NUMBER},
	{0x000f34, 0x000f34, PG_U_OTHER_SYMBOL},
	{0x000f35, 0x000f35, PG_U_NONSPACING_MARK},
	{0x000f36, 0x000f36, PG_U_OTHER_SYMBOL},
	{0x000f37, 0x000f37, PG_U_NONSPACING_MARK},
	{0x000f38, 0x000f38, PG_U_OTHER_SYMBOL},
	{0x000f39, 0x000f39, PG_U_NONSPACING_MARK},
	{0x000f3a, 0x000f3a, PG_U_OPEN_PUNCTUATION},
	{0x000f3b, 0x000f3b, PG_U_CLOSE_PUNCTUATION},
	{0x000f3c, 0x000f3c, PG_U_OPEN_PUNCTUATION},
	{0x000f3d, 0x000f3d, PG_U_CLOSE_PUNCTUATION},
	{0x000f3e, 0x000f3f, PG_U_SPACING_MARK},
	{0x000f40, 0x000f47, PG_U_OTHER_LETTER},
	{0x000f49, 0x000f6c, PG_U_OTHER_LETTER},
	{0x000f71, 0x000f7e, PG_U_NONSPACING_MARK},
	{0x000f7f, 0x000f7f, PG_U_SPACING_MARK},
	{0x000f80, 0x000f84, PG_U_NONSPACING_MARK},
	{0x000f85, 0x000f85, PG_U_OTHER_PUNCTUATION},
	{0x000f86, 0x000f87, PG_U_NONSPACING_MARK},
	{0x000f88, 0x000f8c, PG_U_OTHER_LETTER},
	{0x000f8d, 0x000f97, PG_U_NONSPACING_MARK},
	{0x000f99, 0x000fbc, PG_U_NONSPACING_MARK},
	{0x000fbe, 0x000fc5, PG_U_OTHER_SYMBOL},
	{0x000fc6, 0x000fc6, PG_U_NONSPACING_MARK},
	{0x000fc7, 0x000fcc, PG_U_OTHER_SYMBOL},
	{0x000fce, 0x000fcf, PG_U_OTHER_SYMBOL},
	{0x000fd0, 0x000fd4, PG_U_OTHER_PUNCTUATION},
	{0x000fd5, 0x000fd8, PG_U_OTHER_SYMBOL},
	{0x000fd9, 0x000fda, PG_U_OTHER_PUNCTUATION},
	{0x001000, 0x00102a, PG_U_OTHER_LETTER},
	{0x00102b, 0x00102c, PG_U_SPACING_MARK},
	{0x00102d, 0x001030, PG_U_NONSPACING_MARK},
	{0x001031, 0x001031, PG_U_SPACING_MARK},
	{0x001032, 0x001037, PG_U_NONSPACING_MARK},
	{0x001038, 0x001038, PG_U_SPACING_MARK},
	{0x001039, 0x00103a, PG_U_NONSPACING_MARK},
	{0x00103b, 0x00103c, PG_U_SPACING_MARK},
	{0x00103d, 0x00103e, PG_U_NONSPACING_MARK},
	{0x00103f, 0x00103f, PG_U_OTHER_LETTER},
	{0x001040, 0x001049, PG_U_DECIMAL_NUMBER},
	{0x00104a, 0x00104f, PG_U_OTHER_PUNCTUATION},
	{0x001050, 0x001055, PG_U_OTHER_LETTER},
	{0x001056, 0x001057, PG_U_SPACING_MARK},
	{0x001058, 0x001059, PG_U_NONSPACING_MARK},
	{0x00105a, 0x00105d, PG_U_OTHER_LETTER},
	{0x00105e, 0x001060, PG_U_NONSPACING_MARK},
	{0x001061, 0x001061, PG_U_OTHER_LETTER},
	{0x001062, 0x001064, PG_U_SPACING_MARK},
	{0x001065, 0x001066, PG_U_OTHER_LETTER},
	{0x001067, 0x00106d, PG_U_SPACING_MARK},
	{0x00106e, 0x001070, PG_U_OTHER_LETTER},
	{0x001071, 0x001074, PG_U_NONSPACING_MARK},
	{0x001075, 0x001081, PG_U_OTHER_LETTER},
	{0x001082, 0x001082, PG_U_NONSPACING_MARK},
	{0x001083, 0x001084, PG_U_SPACING_MARK},
	{0x001085, 0x001086, PG_U_NONSPACING_MARK},
	{0x001087, 0x00108c, PG_U_SPACING_MARK},
	{0x00108d, 0x00108d, PG_U_NONSPACING_MARK},
	{0x00108e, 0x00108e, PG_U_OTHER_LETTER},
	{0x00108f, 0x00108f, PG_U_SPACING_MARK},
	{0x001090, 0x001099, PG_U_DECIMAL_NUMBER},
	{0x00109a, 0x00109c, PG_U_SPACING_MARK},
	{0x00109d, 0x00109d, PG_U_NONSPACING_MARK},
	{0x00109e, 0x00109f, PG_U_OTHER_SYMBOL},
	{0x0010a0, 0x0010c5, PG_U_UPPERCASE_LETTER},
	{0x0010c7, 0x0010c7, PG_U_UPPERCASE_LETTER},
	{0x0010cd, 0x0010cd, PG_U_UPPERCASE_LETTER},
	{0x0010d0, 0x0010fa, PG_U_LOWERCASE_LETTER},
	{0x0010fb, 0x0010fb, PG_U_OTHER_PUNCTUATION},
	{0x0010fc, 0x0010fc, PG_U_MODIFIER_LETTER},
	{0x0010fd, 0x0010ff, PG_U_LOWERCASE_LETTER},
	{0x001100, 0x001248, PG_U_OTHER_LETTER},
	{0x00124a, 0x00124d, PG_U_OTHER_LETTER},
	{0x001250, 0x001256, PG_U_OTHER_LETTER},
	{0x001258, 0x001258, PG_U_OTHER_LETTER},
	{0x00125a, 0x00125d, PG_U_OTHER_LETTER},
	{0x001260, 0x001288, PG_U_OTHER_LETTER},
	{0x00128a, 0x00128d, PG_U_OTHER_LETTER},
	{0x001290, 0x0012b0, PG_U_OTHER_LETTER},
	{0x0012b2, 0x0012b5, PG_U_OTHER_LETTER},
	{0x0012b8, 0x0012be, PG_U_OTHER_LETTER},
	{0x0012c0, 0x0012c0, PG_U_OTHER_LETTER},
	{0x0012c2, 0x0012c5, PG_U_OTHER_LETTER},
	{0x0012c8, 0x0012d6, PG_U_OTHER_LETTER},
	{0x0012d8, 0x001310, PG_U_OTHER_LETTER},
	{0x001312, 0x001315, PG_U_OTHER_LETTER},
	{0x001318, 0x00135a, PG_U_OTHER_LETTER},
	{0x00135d, 0x00135f, PG_U_NONSPACING_MARK},
	{0x001360, 0x001368, PG_U_OTHER_PUNCTUATION},
	{0x001369, 0x00137c, PG_U_OTHER_NUMBER},
	{0x001380, 0x00138f, PG_U_OTHER_LETTER},
	{0x001390, 0x001399, PG_U_OTHER_SYMBOL},
	{0x0013a0, 0x0013f5, PG_U_UPPERCASE_LETTER},
	{0x0013f8, 0x0013fd, PG_U_LOWERCASE_LETTER},
	{0x001400, 0x001400, PG_U_DASH_PUNCTUATION},
	{0x001401, 0x00166c, PG_U_OTHER_LETTER},
	{0x00166d, 0x00166d, PG_U_OTHER_SYMBOL},
	{0x00166e, 0x00166e, PG_U_OTHER_PUNCTUATION},
	{0x00166f, 0x00167f, PG_U_OTHER_LETTER},
	{0x001680, 0x001680, PG_U_SPACE_SEPARATOR},
	{0x001681, 0x00169a, PG_U_OTHER_LETTER},
	{0x00169b, 0x00169b, PG_U_OPEN_PUNCTUATION},
	{0x00169c, 0x00169c, PG_U_CLOSE_PUNCTUATION},
	{0x0016a0, 0x0016ea, PG_U_OTHER_LETTER},
	{0x0016eb, 0x0016ed, PG_U_OTHER_PUNCTUATION},
	{0x0016ee, 0x0016f0, PG_U_LETTER_NUMBER},
	{0x0016f1, 0x0016f8, PG_U_OTHER_LETTER},
	{0x001700, 0x001711, PG_U_OTHER_LETTER},
	{0x001712, 0x001714, PG_U_NONSPACING_MARK},
	{0x001715, 0x001715, PG_U_SPACING_MARK},
	{0x00171f, 0x001731, PG_U_OTHER_LETTER},
	{0x001732, 0x001733, PG_U_NONSPACING_MARK},
	{0x001734, 0x001734, PG_U_SPACING_MARK},
	{0x001735, 0x001736, PG_U_OTHER_PUNCTUATION},
	{0x001740, 0x001751, PG_U_OTHER_LETTER},
	{0x001752, 0x001753, PG_U_NONSPACING_MARK},
	{0x001760, 0x00176c, PG_U_OTHER_LETTER},
	{0x00176e, 0x001770, PG_U_OTHER_LETTER},
	{0x001772, 0x001773, PG_U_NONSPACING_MARK},
	{0x001780, 0x0017b3, PG_U_OTHER_LETTER},
	{0x0017b4, 0x0017b5, PG_U_NONSPACING_MARK},
	{0x0017b6, 0x0017b6, PG_U_SPACING_MARK},
	{0x0017b7, 0x0017bd, PG_U_NONSPACING_MARK},
	{0x0017be, 0x0017c5, PG_U_SPACING_MARK},
	{0x0017c6, 0x0017c6, PG_U_NONSPACING_MARK},
	{0x0017c7, 0x0017c8, PG_U_SPACING_MARK},
	{0x0017c9, 0x0017d3, PG_U_NONSPACING_MARK},
	{0x0017d4, 0x0017d6, PG_U_OTHER_PUNCTUATION},
	{0x0017d7, 0x0017d7, PG_U_MODIFIER_LETTER},
	{0x0017d8, 0x0017da, PG_U_OTHER_PUNCTUATION},
	{0x0017db, 0x0017db, PG_U_CURRENCY_SYMBOL},
	{0x0017dc, 0x0017dc, PG_U_OTHER_LETTER},
	{0x0017dd, 0x0017dd, PG_U_NONSPACING_MARK},
	{0x0017e0, 0x0017e9, PG_U_DECIMAL_NUMBER},
	{0x0017f0, 0x0017f9, PG_U_OTHER_NUMBER},
	{0x001800, 0x001805, PG_U_OTHER_PUNCTUATION},
	{0x001806, 0x001806, PG_U_DASH_PUNCTUATION},
	{0x001807, 0x00180a, PG_U_OTHER_PUNCTUATION},
	{0x00180b, 0x00180d, PG_U_NONSPACING_MARK},
	{0x00180e, 0x00180e, PG_U_FORMAT},
	{0x00180f, 0x00180f, PG_U_NONSPACING_MARK},
	{0x001810, 0x001819, PG_U_DECIMAL_NUMBER},
	{0x001820, 0x001842, PG_U_OTHER_LETTER},
	{0x001843, 0x001843, PG_U_MODIFIER_LETTER},
	{0x001844, 0x001878, PG_U_OTHER_LETTER},
	{0x001880, 0x001884, PG_U_OTHER_LETTER},
	{0x001885, 0x001886, PG_U_NONSPACING_MARK},
	{0x001887, 0x0018a8, PG_U_OTHER_LETTER},
	{0x0018a9, 0x0018a9, PG_U_NONSPACING_MARK},
	{0x0018aa, 0x0018aa, PG_U_OTHER_LETTER},
	{0x0018b0, 0x0018f5, PG_U_OTHER_LETTER},
	{0x001900, 0x00191e, PG_U_OTHER_LETTER},
	{0x001920, 0x001922, PG_U_NONSPACING_MARK},
	{0x001923, 0x001926, PG_U_SPACING_MARK},
	{0x001927, 0x001928, PG_U_NONSPACING_MARK},
	{0x001929, 0x00192b, PG_U_SPACING_MARK},
	{0x001930, 0x001931, PG_U_SPACING_MARK},
	{0x001932, 0x001932, PG_U_NONSPACING_MARK},
	{0x001933, 0x001938, PG_U_SPACING_MARK},
	{0x001939, 0x00193b, PG_U_NONSPACING_MARK},
	{0x001940, 0x001940, PG_U_OTHER_SYMBOL},
	{0x001944, 0x001945, PG_U_OTHER_PUNCTUATION},
	{0x001946, 0x00194f, PG_U_DECIMAL_NUMBER},
	{0x001950, 0x00196d, PG_U_OTHER_LETTER},
	{0x001970, 0x001974, PG_U_OTHER_LETTER},
	{0x001980, 0x0019ab, PG_U_OTHER_LETTER},
	{0x0019b0, 0x0019c9, PG_U_OTHER_LETTER},
	{0x0019d0, 0x0019d9, PG_U_DECIMAL_NUMBER},
	{0x0019da, 0x0019da, PG_U_OTHER_NUMBER},
	{0x0019de, 0x0019ff, PG_U_OTHER_SYMBOL},
	{0x001a00, 0x001a16, PG_U_OTHER_LETTER},
	{0x001a17, 0x001a18, PG_U_NONSPACING_MARK},
	{0x001a19, 0x001a1a, PG_U_SPACING_MARK},
	{0x001a1b, 0x001a1b, PG_U_NONSPACING_MARK},
	{0x001a1e, 0x001a1f, PG_U_OTHER_PUNCTUATION},
	{0x001a20, 0x001a54, PG_U_OTHER_LETTER},
	{0x001a55, 0x001a55, PG_U_SPACING_MARK},
	{0x001a56, 0x001a56, PG_U_NONSPACING_MARK},
	{0x001a57, 0x001a57, PG_U_SPACING_MARK},
	{0x001a58, 0x001a5e, PG_U_NONSPACING_MARK},
	{0x001a60, 0x001a60, PG_U_NONSPACING_MARK},
	{0x001a61, 0x001a61, PG_U_SPACING_MARK},
	{0x001a62, 0x001a62, PG_U_NONSPACING_MARK},
	{0x001a63, 0x001a64, PG_U_SPACING_MARK},
	{0x001a65, 0x001a6c, PG_U_NONSPACING_MARK},
	{0x001a6d, 0x001a72, PG_U_SPACING_MARK},
	{0x001a73, 0x001a7c, PG_U_NONSPACING_MARK},
	{0x001a7f, 0x001a7f, PG_U_NONSPACING_MARK},
	{0x001a80, 0x001a89, PG_U_DECIMAL_NUMBER},
	{0x001a90, 0x001a99, PG_U_DECIMAL_NUMBER},
	{0x001aa0, 0x001aa6, PG_U_OTHER_PUNCTUATION},
	{0x001aa7, 0x001aa7, PG_U_MODIFIER_LETTER},
	{0x001aa8, 0x001aad, PG_U_OTHER_PUNCTUATION},
	{0x001ab0, 0x001abd, PG_U_NONSPACING_MARK},
	{0x001abe, 0x001abe, PG_U_ENCLOSING_MARK},
	{0x001abf, 0x001ace, PG_U_NONSPACING_MARK},
	{0x001b00, 0x001b03, PG_U_NONSPACING_MARK},
	{0x001b04, 0x001b04, PG_U_SPACING_MARK},
	{0x001b05, 0x001b33, PG_U_OTHER_LETTER},
	{0x001b34, 0x001b34, PG_U_NONSPACING_MARK},
	{0x001b35, 0x001b35, PG_U_SPACING_MARK},
	{0x001b36, 0x001b3a, PG_U_NONSPACING_MARK},
	{0x001b3b, 0x001b3b, PG_U_SPACING_MARK},
	{0x001b3c, 0x001b3c, PG_U_NONSPACING_MARK},
	{0x001b3d, 0x001b41, PG_U_SPACING_MARK},
	{0x001b42, 0x001b42, PG_U_NONSPACING_MARK},
	{0x001b43, 0x001b44, PG_U_SPACING_MARK},
	{0x001b45, 0x001b4c, PG_U_OTHER_LETTER},
	{0x001b50, 0x001b59, PG_U_DECIMAL_NUMBER},
	{0x001b5a, 0x001b60, PG_U_OTHER_PUNCTUATION},
	{0x001b61, 0x001b6a, PG_U_OTHER_SYMBOL},
	{0x001b6b, 0x001b73, PG_U_NONSPACING_MARK},
	{0x001b74, 0x001b7c, PG_U_OTHER_SYMBOL},
	{0x001b7d, 0x001b7e, PG_U_OTHER_PUNCTUATION},
	{0x001b80, 0x001b81, PG_U_NONSPACING_MARK},
	{0x001b82, 0x001b82, PG_U_SPACING_MARK},
	{0x001b83, 0x001ba0, PG_U_OTHER_LETTER},
	{0x001ba1, 0x001ba1, PG_U_SPACING_MARK},
	{0x001ba2, 0x001ba5, PG_U_NONSPACING_MARK},
	{0x001ba6, 0x001ba7, PG_U_SPACING_MARK},
	{0x001ba8, 0x001ba9, PG_U_NONSPACING_MARK},
	{0x001baa, 0x001baa, PG_U_SPACING_MARK},
	{0x001bab, 0x001bad, PG_U_NONSPACING_MARK},
	{0x001bae, 0x001baf, PG_U_OTHER_LETTER},
	{0x001bb0, 0x001bb9, PG_U_DECIMAL_NUMBER},
	{0x001bba, 0x001be5, PG_U_OTHER_LETTER},
	{0x001be6, 0x001be6, PG_U_NONSPACING_MARK},
	{0x001be7, 0x001be7, PG_U_SPACING_MARK},
	{0x001be8, 0x001be9, PG_U_NONSPACING_MARK},
	{0x001bea, 0x001bec, PG_U_SPACING_MARK},
	{0x001bed, 0x001bed, PG_U_NONSPACING_MARK},
	{0x001bee, 0x001bee, PG_U_SPACING_MARK},
	{0x001bef, 0x001bf1, PG_U_NONSPACING_MARK},
	{0x001bf2, 0x001bf3, PG_U_SPACING_MARK},
	{0x001bfc, 0x001bff, PG_U_OTHER_PUNCTUATION},
	{0x001c00, 0x001c23, PG_U_OTHER_LETTER},
	{0x001c24, 0x001c2b, PG_U_SPACING_MARK},
	{0x001c2c, 0x001c33, PG_U_NONSPACING_MARK},
	{0x001c34, 0x001c35, PG_U_SPACING_MARK},
	{0x001c36, 0x001c37, PG_U_NONSPACING_MARK},
	{0x001c3b, 0x001c3f, PG_U_OTHER_PUNCTUATION},
	{0x001c40, 0x001c49, PG_U_DECIMAL_NUMBER},
	{0x001c4d, 0x001c4f, PG_U_OTHER_LETTER},
	{0x001c50, 0x001c59, PG_U_DECIMAL_NUMBER},
	{0x001c5a, 0x001c77, PG_U_OTHER_LETTER},
	{0x001c78, 0x001c7d, PG_U_MODIFIER_LETTER},
	{0x001c7e, 0x001c7f, PG_U_OTHER_PUNCTUATION},
	{0x001c80, 0x001c88, PG_U_LOWERCASE_LETTER},
	{0x001c90, 0x001cba, PG_U_UPPERCASE_LETTER},
	{0x001cbd, 0x001cbf, PG_U_UPPERCASE_LETTER},
	{0x001cc0, 0x001cc7, PG_U_OTHER_PUNCTUATION},
	{0x001cd0, 0x001cd2, PG_U_NONSPACING_MARK},
	{0x001cd3, 0x001cd3, PG_U_OTHER_PUNCTUATION},
	{0x001cd4, 0x001ce0, PG_U_NONSPACING_MARK},
	{0x001ce1, 0x001ce1, PG_U_SPACING_MARK},
	{0x001ce2, 0x001ce8, PG_U_NONSPACING_MARK},
	{0x001ce9, 0x001cec, PG_U_OTHER_LETTER},
	{0x001ced, 0x001ced, PG_U_NONSPACING_MARK},
	{0x001cee, 0x001cf3, PG_U_OTHER_LETTER},
	{0x001cf4, 0x001cf4, PG_U_NONSPACING_MARK},
	{0x001cf5, 0x001cf6, PG_U_OTHER_LETTER},
	{0x001cf7, 0x001cf7, PG_U_SPACING_MARK},
	{0x001cf8, 0x001cf9, PG_U_NONSPACING_MARK},
	{0x001cfa, 0x001cfa, PG_U_OTHER_LETTER},
	{0x001d00, 0x001d2b, PG_U_LOWERCASE_LETTER},
	{0x001d2c, 0x001d6a, PG_U_MODIFIER_LETTER},
	{0x001d6b, 0x001d77, PG_U_LOWERCASE_LETTER},
	{0x001d78, 0x001d78, PG_U_MODIFIER_LETTER},
	{0x001d79, 0x001d9a, PG_U_LOWERCASE_LETTER},
	{0x001d9b, 0x001dbf, PG_U_MODIFIER_LETTER},
	{0x001dc0, 0x001dff, PG_U_NONSPACING_MARK},
	{0x001e00, 0x001e00, PG_U_UPPERCASE_LETTER},
	{0x001e01, 0x001e01, PG_U_LOWERCASE_LETTER},
	{0x001e02, 0x001e02, PG_U_UPPERCASE_LETTER},
	{0x001e03, 0x001e03, PG_U_LOWERCASE_LETTER},
	{0x001e04, 0x001e04, PG_U_UPPERCASE_LETTER},
	{0x001e05, 0x001e05, PG_U_LOWERCASE_LETTER},
	{0x001e06, 0x001e06, PG_U_UPPERCASE_LETTER},
	{0x001e07, 0x001e07, PG_U_LOWERCASE_LETTER},
	{0x001e08, 0x001e08, PG_U_UPPERCASE_LETTER},
	{0x001e09, 0x001e09, PG_U_LOWERCASE_LETTER},
	{0x001e0a, 0x001e0a, PG_U_UPPERCASE_LETTER},
	{0x001e0b, 0x001e0b, PG_U_LOWERCASE_LETTER},
	{0x001e0c, 0x001e0c, PG_U_UPPERCASE_LETTER},
	{0x001e0d, 0x001e0d, PG_U_LOWERCASE_LETTER},
	{0x001e0e, 0x001e0e, PG_U_UPPERCASE_LETTER},
	{0x001e0f, 0x001e0f, PG_U_LOWERCASE_LETTER},
	{0x001e10, 0x001e10, PG_U_UPPERCASE_LETTER},
	{0x001e11, 0x001e11, PG_U_LOWERCASE_LETTER},
	{0x001e12, 0x001e12, PG_U_UPPERCASE_LETTER},
	{0x001e13, 0x001e13, PG_U_LOWERCASE_LETTER},
	{0x001e14, 0x001e14, PG_U_UPPERCASE_LETTER},
	{0x001e15, 0x001e15, PG_U_LOWERCASE_LETTER},
	{0x001e16, 0x001e16, PG_U_UPPERCASE_LETTER},
	{0x001e17, 0x001e17, PG_U_LOWERCASE_LETTER},
	{0x001e18, 0x001e18, PG_U_UPPERCASE_LETTER},
	{0x001e19, 0x001e19, PG_U_LOWERCASE_LETTER},
	{0x001e1a, 0x001e1a, PG_U_UPPERCASE_LETTER},
	{0x001e1b, 0x001e1b, PG_U_LOWERCASE_LETTER},
	{0x001e1c, 0x001e1c, PG_U_UPPERCASE_LETTER},
	{0x001e1d, 0x001e1d, PG_U_LOWERCASE_LETTER},
	{0x001e1e, 0x001e1e, PG_U_UPPERCASE_LETTER},
	{0x001e1f, 0x001e1f, PG_U_LOWERCASE_LETTER},
	{0x001e20, 0x001e20, PG_U_UPPERCASE_LETTER},
	{0x001e21, 0x001e21, PG_U_LOWERCASE_LETTER},
	{0x001e22, 0x001e22, PG_U_UPPERCASE_LETTER},
	{0x001e23, 0x001e23, PG_U_LOWERCASE_LETTER},
	{0x001e24, 0x001e24, PG_U_UPPERCASE_LETTER},
	{0x001e25, 0x001e25, PG_U_LOWERCASE_LETTER},
	{0x001e26, 0x001e26, PG_U_UPPERCASE_LETTER},
	{0x001e27, 0x001e27, PG_U_LOWERCASE_LETTER},
	{0x001e28, 0x001e28, PG_U_UPPERCASE_LETTER},
	{0x001e29, 0x001e29, PG_U_LOWERCASE_LETTER},
	{0x001e2a, 0x001e2a, PG_U_UPPERCASE_LETTER},
	{0x001e2b, 0x001e2b, PG_U_LOWERCASE_LETTER},
	{0x001e2c, 0x001e2c, PG_U_UPPERCASE_LETTER},
	{0x001e2d, 0x001e2d, PG_U_LOWERCASE_LETTER},
	{0x001e2e, 0x001e2e, PG_U_UPPERCASE_LETTER},
	{0x001e2f, 0x001e2f, PG_U_LOWERCASE_LETTER},
	{0x001e30, 0x001e30, PG_U_UPPERCASE_LETTER},
	{0x001e31, 0x001e31, PG_U_LOWERCASE_LETTER},
	{0x001e32, 0x001e32, PG_U_UPPERCASE_LETTER},
	{0x001e33, 0x001e33, PG_U_LOWERCASE_LETTER},
	{0x001e34, 0x001e34, PG_U_UPPERCASE_LETTER},
	{0x001e35, 0x001e35, PG_U_LOWERCASE_LETTER},
	{0x001e36, 0x001e36, PG_U_UPPERCASE_LETTER},
	{0x001e37, 0x001e37, PG_U_LOWERCASE_LETTER},
	{0x001e38, 0x001e38, PG_U_UPPERCASE_LETTER},
	{0x001e39, 0x001e39, PG_U_LOWERCASE_LETTER},
	{0x001e3a, 0x001e3a, PG_U_UPPERCASE_LETTER},
	{0x001e3b, 0x001e3b, PG_U_LOWERCASE_LETTER},
	{0x001e3c, 0x001e3c, PG_U_UPPERCASE_LETTER},
	{0x001e3d, 0x001e3d, PG_U_LOWERCASE_LETTER},
	{0x001e3e, 0x001e3e, PG_U_UPPERCASE_LETTER},
	{0x001e3f, 0x001e3f, PG_U_LOWERCASE_LETTER},
	{0x001e40, 0x001e40, PG_U_UPPERCASE_LETTER},
	{0x001e41, 0x001e41, PG_U_LOWERCASE_LETTER},
	{0x001e42, 0x001e42, PG_U_UPPERCASE_LETTER},
	{0x001e43, 0x001e43, PG_U_LOWERCASE_LETTER},
	{0x001e44, 0x001e44, PG_U_UPPERCASE_LETTER},
	{0x001e45, 0x001e45, PG_U_LOWERCASE_LETTER},
	{0x001e46, 0x001e46, PG_U_UPPERCASE_LETTER},
	{0x001e47, 0x001e47, PG_U_LOWERCASE_LETTER},
	{0x001e48, 0x001e48, PG_U_UPPERCASE_LETTER},
	{0x001e49, 0x001e49, PG_U_LOWERCASE_LETTER},
	{0x001e4a, 0x001e4a, PG_U_UPPERCASE_LETTER},
	{0x001e4b, 0x001e4b, PG_U_LOWERCASE_LETTER},
	{0x001e4c, 0x001e4c, PG_U_UPPERCASE_LETTER},
	{0x001e4d, 0x001e4d, PG_U_LOWERCASE_LETTER},
	{0x001e4e, 0x001e4e, PG_U_UPPERCASE_LETTER},
	{0x001e4f, 0x001e4f, PG_U_LOWERCASE_LETTER},
	{0x001e50, 0x001e50, PG_U_UPPERCASE_LETTER},
	{0x001e51, 0x001e51, PG_U_LOWERCASE_LETTER},
	{0x001e52, 0x001e52, PG_U_UPPERCASE_LETTER},
	{0x001e53, 0x001e53, PG_U_LOWERCASE_LETTER},
	{0x001e54, 0x001e54, PG_U_UPPERCASE_LETTER},
	{0x001e55, 0x001e55, PG_U_LOWERCASE_LETTER},
	{0x001e56, 0x001e56, PG_U_UPPERCASE_LETTER},
	{0x001e57, 0x001e57, PG_U_LOWERCASE_LETTER},
	{0x001e58, 0x001e58, PG_U_UPPERCASE_LETTER},
	{0x001e59, 0x001e59, PG_U_LOWERCASE_LETTER},
	{0x001e5a, 0x001e5a, PG_U_UPPERCASE_LETTER},
	{0x001e5b, 0x001e5b, PG_U_LOWERCASE_LETTER},
	{0x001e5c, 0x001e5c, PG_U_UPPERCASE_LETTER},
	{0x001e5d, 0x001e5d, PG_U_LOWERCASE_LETTER},
	{0x001e5e, 0x001e5e, PG_U_UPPERCASE_LETTER},
	{0x001e5f, 0x001e5f, PG_U_LOWERCASE_LETTER},
	{0x001e60, 0x001e60, PG_U_UPPERCASE_LETTER},
	{0x001e61, 0x001e61, PG_U_LOWERCASE_LETTER},
	{0x001e62, 0x001e62, PG_U_UPPERCASE_LETTER},
	{0x001e63, 0x001e63, PG_U_LOWERCASE_LETTER},
	{0x001e64, 0x001e64, PG_U_UPPERCASE_LETTER},
	{0x001e65, 0x001e65, PG_U_LOWERCASE_LETTER},
	{0x001e66, 0x001e66, PG_U_UPPERCASE_LETTER},
	{0x001e67, 0x001e67, PG_U_LOWERCASE_LETTER},
	{0x001e68, 0x001e68, PG_U_UPPERCASE_LETTER},
	{0x001e69, 0x001e69, PG_U_LOWERCASE_LETTER},
	{0x001e6a, 0x001e6a, PG_U_UPPERCASE_LETTER},
	{0x001e6b, 0x001e6b, PG_U_LOWERCASE_LETTER},
	{0x001e6c, 0x001e6c, PG_U_UPPERCASE_LETTER},
	{0x001e6d, 0x001e6d, PG_U_LOWERCASE_LETTER},
	{0x001e6e, 0x001e6e, PG_U_UPPERCASE_LETTER},
	{0x001e6f, 0x001e6f, PG_U_LOWERCASE_LETTER},
	{0x001e70, 0x001e70, PG_U_UPPERCASE_LETTER},
	{0x001e71, 0x001e71, PG_U_LOWERCASE_LETTER},
	{0x001e72, 0x001e72, PG_U_UPPERCASE_LETTER},
	{0x001e73, 0x001e73, PG_U_LOWERCASE_LETTER},
	{0x001e74, 0x001e74, PG_U_UPPERCASE_LETTER},
	{0x001e75, 0x001e75, PG_U_LOWERCASE_LETTER},
	{0x001e76, 0x001e76, PG_U_UPPERCASE_LETTER},
	{0x001e77, 0x001e77, PG_U_LOWERCASE_LETTER},
	{0x001e78, 0x001e78, PG_U_UPPERCASE_LETTER},
	{0x001e79, 0x001e79, PG_U_LOWERCASE_LETTER},
	{0x001e7a, 0x001e7a, PG_U_UPPERCASE_LETTER},
	{0x001e7b, 0x001e7b, PG_U_LOWERCASE_LETTER},
	{0x001e7c, 0x001e7c, PG_U_UPPERCASE_LETTER},
	{0x001e7d, 0x001e7d, PG_U_LOWERCASE_LETTER},
	{0x001e7e, 0x001e7e, PG_U_UPPERCASE_LETTER},
	{0x001e7f, 0x001e7f, PG_U_LOWERCASE_LETTER},
	{0x001e80, 0x001e80, PG_U_UPPERCASE_LETTER},
	{0x001e81, 0x001e81, PG_U_LOWERCASE_LETTER},
	{0x001e82, 0x001e82, PG_U_UPPERCASE_LETTER},
	{0x001e83, 0x001e83, PG_U_LOWERCASE_LETTER},
	{0x001e84, 0x001e84, PG_U_UPPERCASE_LETTER},
	{0x001e85, 0x001e85, PG_U_LOWERCASE_LETTER},
	{0x001e86, 0x001e86, PG_U_UPPERCASE_LETTER},
	{0x001e87, 0x001e87, PG_U_LOWERCASE_LETTER},
	{0x001e88, 0x001e88, PG_U_UPPERCASE_LETTER},
	{0x001e89, 0x001e89, PG_U_LOWERCASE_LETTER},
	{0x001e8a, 0x001e8a, PG_U_UPPERCASE_LETTER},
	{0x001e8b, 0x001e8b, PG_U_LOWERCASE_LETTER},
	{0x001e8c, 0x001e8c, PG_U_UPPERCASE_LETTER},
	{0x001e8d, 0x001e8d, PG_U_LOWERCASE_LETTER},
	{0x001e8e, 0x001e8e, PG_U_UPPERCASE_LETTER},
	{0x001e8f, 0x001e8f, PG_U_LOWERCASE_LETTER},
	{0x001e90, 0x001e90, PG_U_UPPERCASE_LETTER},
	{0x001e91, 0x001e91, PG_U_LOWERCASE_LETTER},
	{0x001e92, 0x001e92, PG_U_UPPERCASE_LETTER},
	{0x001e93, 0x001e93, PG_U_LOWERCASE_LETTER},
	{0x001e94, 0x001e94, PG_U_UPPERCASE_LETTER},
	{0x001e95, 0x001e9d, PG_U_LOWERCASE_LETTER},
	{0x001e9e, 0x001e9e, PG_U_UPPERCASE_LETTER},
	{0x001e9f, 0x001e9f, PG_U_LOWERCASE_LETTER},
	{0x001ea0, 0x001ea0, PG_U_UPPERCASE_LETTER},
	{0x001ea1, 0x001ea1, PG_U_LOWERCASE_LETTER},
	{0x001ea2, 0x001ea2, PG_U_UPPERCASE_LETTER},
	{0x001ea3, 0x001ea3, PG_U_LOWERCASE_LETTER},
	{0x001ea4, 0x001ea4, PG_U_UPPERCASE_LETTER},
	{0x001ea5, 0x001ea5, PG_U_LOWERCASE_LETTER},
	{0x001ea6, 0x001ea6, PG_U_UPPERCASE_LETTER},
	{0x001ea7, 0x001ea7, PG_U_LOWERCASE_LETTER},
	{0x001ea8, 0x001ea8, PG_U_UPPERCASE_LETTER},
	{0x001ea9, 0x001ea9, PG_U_LOWERCASE_LETTER},
	{0x001eaa, 0x001eaa, PG_U_UPPERCASE_LETTER},
	{0x001eab, 0x001eab, PG_U_LOWERCASE_LETTER},
	{0x001eac, 0x001eac, PG_U_UPPERCASE_LETTER},
	{0x001ead, 0x001ead, PG_U_LOWERCASE_LETTER},
	{0x001eae, 0x001eae, PG_U_UPPERCASE_LETTER},
	{0x001eaf, 0x001eaf, PG_U_LOWERCASE_LETTER},
	{0x001eb0, 0x001eb0, PG_U_UPPERCASE_LETTER},
	{0x001eb1, 0x001eb1, PG_U_LOWERCASE_LETTER},
	{0x001eb2, 0x001eb2, PG_U_UPPERCASE_LETTER},
	{0x001eb3, 0x001eb3, PG_U_LOWERCASE_LETTER},
	{0x001eb4, 0x001eb4, PG_U_UPPERCASE_LETTER},
	{0x001eb5, 0x001eb5, PG_U_LOWERCASE_LETTER},
	{0x001eb6, 0x001eb6, PG_U_UPPERCASE_LETTER},
	{0x001eb7, 0x001eb7, PG_U_LOWERCASE_LETTER},
	{0x001eb8, 0x001eb8, PG_U_UPPERCASE_LETTER},
	{0x001eb9, 0x001eb9, PG_U_LOWERCASE_LETTER},
	{0x001eba, 0x001eba, PG_U_UPPERCASE_LETTER},
	{0x001ebb, 0x001ebb, PG_U_LOWERCASE_LETTER},
	{0x001ebc, 0x001ebc, PG_U_UPPERCASE_LETTER},
	{0x001ebd, 0x001ebd, PG_U_LOWERCASE_LETTER},
	{0x001ebe, 0x001ebe, PG_U_UPPERCASE_LETTER},
	{0x001ebf, 0x001ebf, PG_U_LOWERCASE_LETTER},
	{0x001ec0, 0x001ec0, PG_U_UPPERCASE_LETTER},
	{0x001ec1, 0x001ec1, PG_U_LOWERCASE_LETTER},
	{0x001ec2, 0x001ec2, PG_U_UPPERCASE_LETTER},
	{0x001ec3, 0x001ec3, PG_U_LOWERCASE_LETTER},
	{0x001ec4, 0x001ec4, PG_U_UPPERCASE_LETTER},
	{0x001ec5, 0x001ec5, PG_U_LOWERCASE_LETTER},
	{0x001ec6, 0x001ec6, PG_U_UPPERCASE_LETTER},
	{0x001ec7, 0x001ec7, PG_U_LOWERCASE_LETTER},
	{0x001ec8, 0x001ec8, PG_U_UPPERCASE_LETTER},
	{0x001ec9, 0x001ec9, PG_U_LOWERCASE_LETTER},
	{0x001eca, 0x001eca, PG_U_UPPERCASE_LETTER},
	{0x001ecb, 0x001ecb, PG_U_LOWERCASE_LETTER},
	{0x001ecc, 0x001ecc, PG_U_UPPERCASE_LETTER},
	{0x001ecd, 0x001ecd, PG_U_LOWERCASE_LETTER},
	{0x001ece, 0x001ece, PG_U_UPPERCASE_LETTER},
	{0x001ecf, 0x001ecf, PG_U_LOWERCASE_LETTER},
	{0x001ed0, 0x001ed0, PG_U_UPPERCASE_LETTER},
	{0x001ed1, 0x001ed1, PG_U_LOWERCASE_LETTER},
	{0x001ed2, 0x001ed2, PG_U_UPPERCASE_LETTER},
	{0x001ed3, 0x001ed3, PG_U_LOWERCASE_LETTER},
	{0x001ed4, 0x001ed4, PG_U_UPPERCASE_LETTER},
	{0x001ed5, 0x001ed5, PG_U_LOWERCASE_LETTER},
	{0x001ed6, 0x001ed6, PG_U_UPPERCASE_LETTER},
	{0x001ed7, 0x001ed7, PG_U_LOWERCASE_LETTER},
	{0x001ed8, 0x001ed8, PG_U_UPPERCASE_LETTER},
	{0x001ed9, 0x001ed9, PG_U_LOWERCASE_LETTER},
	{0x001eda, 0x001eda, PG_U_UPPERCASE_LETTER},
	{0x001edb, 0x001edb, PG_U_LOWERCASE_LETTER},
	{0x001edc, 0x001edc, PG_U_UPPERCASE_LETTER},
	{0x001edd, 0x001edd, PG_U_LOWERCASE_LETTER},
	{0x001ede, 0x001ede, PG_U_UPPERCASE_LETTER},
	{0x001edf, 0x001edf, PG_U_LOWERCASE_LETTER},
	{0x001ee0, 0x001ee0, PG_U_UPPERCASE_LETTER},
	{0x001ee1, 0x001ee1, PG_U_LOWERCASE_LETTER},
	{0x001ee2, 0x001ee2, PG_U_UPPERCASE_LETTER},
	{0x001ee3, 0x001ee3, PG_U_LOWERCASE_LETTER},
	{0x001ee4, 0x001ee4, PG_U_UPPERCASE_LETTER},
	{0x001ee5, 0x001ee5, PG_U_LOWERCASE_LETTER},
	{0x001ee6, 0x001ee6, PG_U_UPPERCASE_LETTER},
	{0x001ee7, 0x001ee7, PG_U_LOWERCASE_LETTER},
	{0x001ee8, 0x001ee8, PG_U_UPPERCASE_LETTER},
	{0x001ee9, 0x001ee9, PG_U_LOWERCASE_LETTER},
	{0x001eea, 0x001eea, PG_U_UPPERCASE_LETTER},
	{0x001eeb, 0x001eeb, PG_U_LOWERCASE_LETTER},
	{0x001eec, 0x001eec, PG_U_UPPERCASE_LETTER},
	{0x001eed, 0x001eed, PG_U_LOWERCASE_LETTER},
	{0x001eee, 0x001eee, PG_U_UPPERCASE_LETTER},
	{0x001eef, 0x001eef, PG_U_LOWERCASE_LETTER},
	{0x001ef0, 0x001ef0, PG_U_UPPERCASE_LETTER},
	{0x001ef1, 0x001ef1, PG_U_LOWERCASE_LETTER},
	{0x001ef2, 0x001ef2, PG_U_UPPERCASE_LETTER},
	{0x001ef3, 0x001ef3, PG_U_LOWERCASE_LETTER},
	{0x001ef4, 0x001ef4, PG_U_UPPERCASE_LETTER},
	{0x001ef5, 0x001ef5, PG_U_LOWERCASE_LETTER},
	{0x001ef6, 0x001ef6, PG_U_UPPERCASE_LETTER},
	{0x001ef7, 0x001ef7, PG_U_LOWERCASE_LETTER},
	{0x001ef8, 0x001ef8, PG_U_UPPERCASE_LETTER},
	{0x001ef9, 0x001ef9, PG_U_LOWERCASE_LETTER},
	{0x001efa, 0x001efa, PG_U_UPPERCASE_LETTER},
	{0x001efb, 0x001efb, PG_U_LOWERCASE_LETTER},
	{0x001efc, 0x001efc, PG_U_UPPERCASE_LETTER},
	{0x001efd, 0x001efd, PG_U_LOWERCASE_LETTER},
	{0x001efe, 0x001efe, PG_U_UPPERCASE_LETTER},
	{0x001eff, 0x001f07, PG_U_LOWERCASE_LETTER},
	{0x001f08, 0x001f0f, PG_U_UPPERCASE_LETTER},
	{0x001f10, 0x001f15, PG_U_LOWERCASE_LETTER},
	{0x001f18, 0x001f1d, PG_U_UPPERCASE_LETTER},
	{0x001f20, 0x001f27, PG_U_LOWERCASE_LETTER},
	{0x001f28, 0x001f2f, PG_U_UPPERCASE_LETTER},
	{0x001f30, 0x001f37, PG_U_LOWERCASE_LETTER},
	{0x001f38, 0x001f3f, PG_U_UPPERCASE_LETTER},
	{0x001f40, 0x001f45, PG_U_LOWERCASE_LETTER},
	{0x001f48, 0x001f4d, PG_U_UPPERCASE_LETTER},
	{0x001f50, 0x001f57, PG_U_LOWERCASE_LETTER},
	{0x001f59, 0x001f59, PG_U_UPPERCASE_LETTER},
	{0x001f5b, 0x001f5b, PG_U_UPPERCASE_LETTER},
	{0x001f5d, 0x001f5d, PG_U_UPPERCASE_LETTER},
	{0x001f5f, 0x001f5f, PG_U_UPPERCASE_LETTER},
	{0x001f60, 0x001f67, PG_U_LOWERCASE_LETTER},
	{0x001f68, 0x001f6f, PG_U_UPPERCASE_LETTER},
	{0x001f70, 0x001f7d, PG_U_LOWERCASE_LETTER},
	{0x001f80, 0x001f87, PG_U_LOWERCASE_LETTER},
	{0x001f88, 0x001f8f, PG_U_TITLECASE_LETTER},
	{0x001f90, 0x001f97, PG_U_LOWERCASE_LETTER},
	{0x001f98, 0x001f9f, PG_U_TITLECASE_LETTER},
	{0x001fa0, 0x001fa7, PG_U_LOWERCASE_LETTER},
	{0x001fa8, 0x001faf, PG_U_TITLECASE_LETTER},
	{0x001fb0, 0x001fb4, PG_U_LOWERCASE_LETTER},
	{0x001fb6, 0x001fb7, PG_U_LOWERCASE_LETTER},
	{0x001fb8, 0x001fbb, PG_U_UPPERCASE_LETTER},
	{0x001fbc, 0x001fbc, PG_U_TITLECASE_LETTER},
	{0x001fbd, 0x001fbd, PG_U_MODIFIER_SYMBOL},
	{0x001fbe, 0x001fbe, PG_U_LOWERCASE_LETTER},
	{0x001fbf, 0x001fc1, PG_U_MODIFIER_SYMBOL},
	{0x001fc2, 0x001fc4, PG_U_LOWERCASE_LETTER},
	{0x001fc6, 0x001fc7, PG_U_LOWERCASE_LETTER},
	{0x001fc8, 0x001fcb, PG_U_UPPERCASE_LETTER},
	{0x001fcc, 0x001fcc, PG_U_TITLECASE_LETTER},
	{0x001fcd, 0x001fcf, PG_U_MODIFIER_SYMBOL},
	{0x001fd0, 0x001fd3, PG_U_LOWERCASE_LETTER},
	{0x001fd6, 0x001fd7, PG_U_LOWERCASE_LETTER},
	{0x001fd8, 0x001fdb, PG_U_UPPERCASE_LETTER},
	{0x001fdd, 0x001fdf, PG_U_MODIFIER_SYMBOL},
	{0x001fe0, 0x001fe7, PG_U_LOWERCASE_LETTER},
	{0x001fe8, 0x001fec, PG_U_UPPERCASE_LETTER},
	{0x001fed, 0x001fef, PG_U_MODIFIER_SYMBOL},
	{0x001ff2, 0x001ff4, PG_U_LOWERCASE_LETTER},
	{0x001ff6, 0x001ff7, PG_U_LOWERCASE_LETTER},
	{0x001ff8, 0x001ffb, PG_U_UPPERCASE_LETTER},
	{0x001ffc, 0x001ffc, PG_U_TITLECASE_LETTER},
	{0x001ffd, 0x001ffe, PG_U_MODIFIER_SYMBOL},
	{0x002000, 0x00200a, PG_U_SPACE_SEPARATOR},
	{0x00200b, 0x00200f, PG_U_FORMAT},
	{0x002010, 0x002015, PG_U_DASH_PUNCTUATION},
	{0x002016, 0x002017, PG_U_OTHER_PUNCTUATION},
	{0x002018, 0x002018, PG_U_INITIAL_PUNCTUATION},
	{0x002019, 0x002019, PG_U_FINAL_PUNCTUATION},
	{0x00201a, 0x00201a, PG_U_OPEN_PUNCTUATION},
	{0x00201b, 0x00201c, PG_U_INITIAL_PUNCTUATION},
	{0x00201d, 0x00201d, PG_U_FINAL_PUNCTUATION},
	{0x00201e, 0x00201e, PG_U_OPEN_PUNCTUATION},
	{0x00201f, 0x00201f, PG_U_INITIAL_PUNCTUATION},
	{0x002020, 0x002027, PG_U_OTHER_PUNCTUATION},
	{0x002028, 0x002028, PG_U_LINE_SEPARATOR},
	{0x002029, 0x002029, PG_U_PARAGRAPH_SEPARATOR},
	{0x00202a, 0x00202e, PG_U_FORMAT},
	{0x00202f, 0x00202f, PG_U_SPACE_SEPARATOR},
	{0x002030, 0x002038, PG_U_OTHER_PUNCTUATION},
	{0x002039, 0x002039, PG_U_INITIAL_PUNCTUATION},
	{0x00203a, 0x00203a, PG_U_FINAL_PUNCTUATION},
	{0x00203b, 0x00203e, PG_U_OTHER_PUNCTUATION},
	{0x00203f, 0x002040, PG_U_CONNECTOR_PUNCTUATION},
	{0x002041, 0x002043, PG_U_OTHER_PUNCTUATION},
	{0x002044, 0x002044, PG_U_MATH_SYMBOL},
	{0x002045, 0x002045, PG_U_OPEN_PUNCTUATION},
	{0x002046, 0x002046, PG_U_CLOSE_PUNCTUATION},
	{0x002047, 0x002051, PG_U_OTHER_PUNCTUATION},
	{0x002052, 0x002052, PG_U_MATH_SYMBOL},
	{0x002053, 0x002053, PG_U_OTHER_PUNCTUATION},
	{0x002054, 0x002054, PG_U_CONNECTOR_PUNCTUATION},
	{0x002055, 0x00205e, PG_U_OTHER_PUNCTUATION},
	{0x00205f, 0x00205f, PG_U_SPACE_SEPARATOR},
	{0x002060, 0x002064, PG_U_FORMAT},
	{0x002066, 0x00206f, PG_U_FORMAT},
	{0x002070, 0x002070, PG_U_OTHER_NUMBER},
	{0x002071, 0x002071, PG_U_MODIFIER_LETTER},
	{0x002074, 0x002079, PG_U_OTHER_NUMBER},
	{0x00207a, 0x00207c, PG_U_MATH_SYMBOL},
	{0x00207d, 0x00207d, PG_U_OPEN_PUNCTUATION},
	{0x00207e, 0x00207e, PG_U_CLOSE_PUNCTUATION},
	{0x00207f, 0x00207f, PG_U_MODIFIER_LETTER},
	{0x002080, 0x002089, PG_U_OTHER_NUMBER},
	{0x00208a, 0x00208c, PG_U_MATH_SYMBOL},
	{0x00208d, 0x00208d, PG_U_OPEN_PUNCTUATION},
	{0x00208e, 0x00208e, PG_U_CLOSE_PUNCTUATION},
	{0x002090, 0x00209c, PG_U_MODIFIER_LETTER},
	{0x0020a0, 0x0020c0, PG_U_CURRENCY_SYMBOL},
	{0x0020d0, 0x0020dc, PG_U_NONSPACING_MARK},
	{0x0020dd, 0x0020e0, PG_U_ENCLOSING_MARK},
	{0x0020e1, 0x0020e1, PG_U_NONSPACING_MARK},
	{0x0020e2, 0x0020e4, PG_U_ENCLOSING_MARK},
	{0x0020e5, 0x0020f0, PG_U_NONSPACING_MARK},
	{0x002100, 0x002101, PG_U_OTHER_SYMBOL},
	{0x002102, 0x002102, PG_U_UPPERCASE_LETTER},
	{0x002103, 0x002106, PG_U_OTHER_SYMBOL},
	{0x002107, 0x002107, PG_U_UPPERCASE_LETTER},
	{0x002108, 0x002109, PG_U_OTHER_SYMBOL},
	{0x00210a, 0x00210a, PG_U_LOWERCASE_LETTER},
	{0x00210b, 0x00210d, PG_U_UPPERCASE_LETTER},
	{0x00210e, 0x00210f, PG_U_LOWERCASE_LETTER},
	{0x002110, 0x002112, PG_U_UPPERCASE_LETTER},
	{0x002113, 0x002113, PG_U_LOWERCASE_LETTER},
	{0x002114, 0x002114, PG_U_OTHER_SYMBOL},
	{0x002115, 0x002115, PG_U_UPPERCASE_LETTER},
	{0x002116, 0x002117, PG_U_OTHER_SYMBOL},
	{0x002118, 0x002118, PG_U_MATH_SYMBOL},
	{0x002119, 0x00211d, PG_U_UPPERCASE_LETTER},
	{0x00211e, 0x002123, PG_U_OTHER_SYMBOL},
	{0x002124, 0x002124, PG_U_UPPERCASE_LETTER},
	{0x002125, 0x002125, PG_U_OTHER_SYMBOL},
	{0x002126, 0x002126, PG_U_UPPERCASE_LETTER},
	{0x002127, 0x002127, PG_U_OTHER_SYMBOL},
	{0x002128, 0x002128, PG_U_UPPERCASE_LETTER},
	{0x002129, 0x002129, PG_U_OTHER_SYMBOL},
	{0x00212a, 0x00212d, PG_U_UPPERCASE_LETTER},
	{0x00212e, 0x00212e, PG_U_OTHER_SYMBOL},
	{0x00212f, 0x00212f, PG_U_LOWERCASE_LETTER},
	{0x002130, 0x002133, PG_U_UPPERCASE_LETTER},
	{0x002134, 0x002134, PG_U_LOWERCASE_LETTER},
	{0x002135, 0x002138, PG_U_OTHER_LETTER},
	{0x002139, 0x002139, PG_U_LOWERCASE_LETTER},
	{0x00213a, 0x00213b, PG_U_OTHER_SYMBOL},
	{0x00213c, 0x00213d, PG_U_LOWERCASE_LETTER},
	{0x00213e, 0x00213f, PG_U_UPPERCASE_LETTER},
	{0x002140, 0x002144, PG_U_MATH_SYMBOL},
	{0x002145, 0x002145, PG_U_UPPERCASE_LETTER},
	{0x002146, 0x002149, PG_U_LOWERCASE_LETTER},
	{0x00214a, 0x00214a, PG_U_OTHER_SYMBOL},
	{0x00214b, 0x00214b, PG_U_MATH_SYMBOL},
	{0x00214c, 0x00214d, PG_U_OTHER_SYMBOL},
	{0x00214e, 0x00214e, PG_U_LOWERCASE_LETTER},
	{0x00214f, 0x00214f, PG_U_OTHER_SYMBOL},
	{0x002150, 0x00215f, PG_U_OTHER_NUMBER},
	{0x002160, 0x002182, PG_U_LETTER_NUMBER},
	{0x002183, 0x002183, PG_U_UPPERCASE_LETTER},
	{0x002184, 0x002184, PG_U_LOWERCASE_LETTER},
	{0x002185, 0x002188, PG_U_LETTER_NUMBER},
	{0x002189, 0x002189, PG_U_OTHER_NUMBER},
	{0x00218a, 0x00218b, PG_U_OTHER_SYMBOL},
	{0x002190, 0x002194, PG_U_MATH_SYMBOL},
	{0x002195, 0x002199, PG_U_OTHER_SYMBOL},
	{0x00219a, 0x00219b, PG_U_MATH_SYMBOL},
	{0x00219c, 0x00219f, PG_U_OTHER_SYMBOL},
	{0x0021a0, 0x0021a0, PG_U_MATH_SYMBOL},
	{0x0021a1, 0x0021a2, PG_U_OTHER_SYMBOL},
	{0x0021a3, 0x0021a3, PG_U_MATH_SYMBOL},
	{0x0021a4, 0x0021a5, PG_U_OTHER_SYMBOL},
	{0x0021a6, 0x0021a6, PG_U_MATH_SYMBOL},
	{0x0021a7, 0x0021ad, PG_U_OTHER_SYMBOL},
	{0x0021ae, 0x0021ae, PG_U_MATH_SYMBOL},
	{0x0021af, 0x0021cd, PG_U_OTHER_SYMBOL},
	{0x0021ce, 0x0021cf, PG_U_MATH_SYMBOL},
	{0x0021d0, 0x0021d1, PG_U_OTHER_SYMBOL},
	{0x0021d2, 0x0021d2, PG_U_MATH_SYMBOL},
	{0x0021d3, 0x0021d3, PG_U_OTHER_SYMBOL},
	{0x0021d4, 0x0021d4, PG_U_MATH_SYMBOL},
	{0x0021d5, 0x0021f3, PG_U_OTHER_SYMBOL},
	{0x0021f4, 0x0022ff, PG_U_MATH_SYMBOL},
	{0x002300, 0x002307, PG_U_OTHER_SYMBOL},
	{0x002308, 0x002308, PG_U_OPEN_PUNCTUATION},
	{0x002309, 0x002309, PG_U_CLOSE_PUNCTUATION},
	{0x00230a, 0x00230a, PG_U_OPEN_PUNCTUATION},
	{0x00230b, 0x00230b, PG_U_CLOSE_PUNCTUATION},
	{0x00230c, 0x00231f, PG_U_OTHER_SYMBOL},
	{0x002320, 0x002321, PG_U_MATH_SYMBOL},
	{0x002322, 0x002328, PG_U_OTHER_SYMBOL},
	{0x002329, 0x002329, PG_U_OPEN_PUNCTUATION},
	{0x00232a, 0x00232a, PG_U_CLOSE_PUNCTUATION},
	{0x00232b, 0x00237b, PG_U_OTHER_SYMBOL},
	{0x00237c, 0x00237c, PG_U_MATH_SYMBOL},
	{0x00237d, 0x00239a, PG_U_OTHER_SYMBOL},
	{0x00239b, 0x0023b3, PG_U_MATH_SYMBOL},
	{0x0023b4, 0x0023db, PG_U_OTHER_SYMBOL},
	{0x0023dc, 0x0023e1, PG_U_MATH_SYMBOL},
	{0x0023e2, 0x002426, PG_U_OTHER_SYMBOL},
	{0x002440, 0x00244a, PG_U_OTHER_SYMBOL},
	{0x002460, 0x00249b, PG_U_OTHER_NUMBER},
	{0x00249c, 0x0024e9, PG_U_OTHER_SYMBOL},
	{0x0024ea, 0x0024ff, PG_U_OTHER_NUMBER},
	{0x002500, 0x0025b6, PG_U_OTHER_SYMBOL},
	{0x0025b7, 0x0025b7, PG_U_MATH_SYMBOL},
	{0x0025b8, 0x0025c0, PG_U_OTHER_SYMBOL},
	{0x0025c1, 0x0025c1, PG_U_MATH_SYMBOL},
	{0x0025c2, 0x0025f7, PG_U_OTHER_SYMBOL},
	{0x0025f8, 0x0025ff, PG_U_MATH_SYMBOL},
	{0x002600, 0x00266e, PG_U_OTHER_SYMBOL},
	{0x00266f, 0x00266f, PG_U_MATH_SYMBOL},
	{0x002670, 0x002767, PG_U_OTHER_SYMBOL},
	{0x002768, 0x002768, PG_U_OPEN_PUNCTUATION},
	{0x002769, 0x002769, PG_U_CLOSE_PUNCTUATION},
	{0x00276a, 0x00276a, PG_U_OPEN_PUNCTUATION},
	{0x00276b, 0x00276b, PG_U_CLOSE_PUNCTUATION},
	{0x00276c, 0x00276c, PG_U_OPEN_PUNCTUATION},
	{0x00276d, 0x00276d, PG_U_CLOSE_PUNCTUATION},
	{0x00276e, 0x00276e, PG_U_OPEN_PUNCTUATION},
	{0x00276f, 0x00276f, PG_U_CLOSE_PUNCTUATION},
	{0x002770, 0x002770, PG_U_OPEN_PUNCTUATION},
	{0x002771, 0x002771, PG_U_CLOSE_PUNCTUATION},
	{0x002772, 0x002772, PG_U_OPEN_PUNCTUATION},
	{0x002773, 0x002773, PG_U_CLOSE_PUNCTUATION},
	{0x002774, 0x002774, PG_U_OPEN_PUNCTUATION},
	{0x002775, 0x002775, PG_U_CLOSE_PUNCTUATION},
	{0x002776, 0x002793, PG_U_OTHER_NUMBER},
	{0x002794, 0x0027bf, PG_U_OTHER_SYMBOL},
	{0x0027c0, 0x0027c4, PG_U_MATH_SYMBOL},
	{0x0027c5, 0x0027c5, PG_U_OPEN_PUNCTUATION},
	{0x0027c6, 0x0027c6, PG_U_CLOSE_PUNCTUATION},
	{0x0027c7, 0x0027e5, PG_U_MATH_SYMBOL},
	{0x0027e6, 0x0027e6, PG_U_OPEN_PUNCTUATION},
	{0x0027e7, 0x0027e7, PG_U_CLOSE_PUNCTUATION},
	{0x0027e8, 0x0027e8, PG_U_OPEN_PUNCTUATION},
	{0x0027e9, 0x0027e9, PG_U_CLOSE_PUNCTUATION},
	{0x0027ea, 0x0027ea, PG_U_OPEN_PUNCTUATION},
	{0x0027eb, 0x0027eb, PG_U_CLOSE_PUNCTUATION},
	{0x0027ec, 0x0027ec, PG_U_OPEN_PUNCTUATION},
	{0x0027ed, 0x0027ed, PG_U_CLOSE_PUNCTUATION},
	{0x0027ee, 0x0027ee, PG_U_OPEN_PUNCTUATION},
	{0x0027ef, 0x0027ef, PG_U_CLOSE_PUNCTUATION},
	{0x0027f0, 0x0027ff, PG_U_MATH_SYMBOL},
	{0x002800, 0x0028ff, PG_U_OTHER_SYMBOL},
	{0x002900, 0x002982, PG_U_MATH_SYMBOL},
	{0x002983, 0x002983, PG_U_OPEN_PUNCTUATION},
	{0x002984, 0x002984, PG_U_CLOSE_PUNCTUATION},
	{0x002985, 0x002985, PG_U_OPEN_PUNCTUATION},
	{0x002986, 0x002986, PG_U_CLOSE_PUNCTUATION},
	{0x002987, 0x002987, PG_U_OPEN_PUNCTUATION},
	{0x002988, 0x002988, PG_U_CLOSE_PUNCTUATION},
	{0x002989, 0x002989, PG_U_OPEN_PUNCTUATION},
	{0x00298a, 0x00298a, PG_U_CLOSE_PUNCTUATION},
	{0x00298b, 0x00298b, PG_U_OPEN_PUNCTUATION},
	{0x00298c, 0x00298c, PG_U_CLOSE_PUNCTUATION},
	{0x00298d, 0x00298d, PG_U_OPEN_PUNCTUATION},
	{0x00298e, 0x00298e, PG_U_CLOSE_PUNCTUATION},
	{0x00298f, 0x00298f, PG_U_OPEN_PUNCTUATION},
	{0x002990, 0x002990, PG_U_CLOSE_PUNCTUATION},
	{0x002991, 0x002991, PG_U_OPEN_PUNCTUATION},
	{0x002992, 0x002992, PG_U_CLOSE_PUNCTUATION},
	{0x002993, 0x002993, PG_U_OPEN_PUNCTUATION},
	{0x002994, 0x002994, PG_U_CLOSE_PUNCTUATION},
	{0x002995, 0x002995, PG_U_OPEN_PUNCTUATION},
	{0x002996, 0x002996, PG_U_CLOSE_PUNCTUATION},
	{0x002997, 0x002997, PG_U_OPEN_PUNCTUATION},
	{0x002998, 0x002998, PG_U_CLOSE_PUNCTUATION},
	{0x002999, 0x0029d7, PG_U_MATH_SYMBOL},
	{0x0029d8, 0x0029d8, PG_U_OPEN_PUNCTUATION},
	{0x0029d9, 0x0029d9, PG_U_CLOSE_PUNCTUATION},
	{0x0029da, 0x0029da, PG_U_OPEN_PUNCTUATION},
	{0x0029db, 0x0029db, PG_U_CLOSE_PUNCTUATION},
	{0x0029dc, 0x0029fb, PG_U_MATH_SYMBOL},
	{0x0029fc, 0x0029fc, PG_U_OPEN_PUNCTUATION},
	{0x0029fd, 0x0029fd, PG_U_CLOSE_PUNCTUATION},
	{0x0029fe, 0x002aff, PG_U_MATH_SYMBOL},
	{0x002b00, 0x002b2f, PG_U_OTHER_SYMBOL},
	{0x002b30, 0x002b44, PG_U_MATH_SYMBOL},
	{0x002b45, 0x002b46, PG_U_OTHER_SYMBOL},
	{0x002b47, 0x002b4c, PG_U_MATH_SYMBOL},
	{0x002b4d, 0x002b73, PG_U_OTHER_SYMBOL},
	{0x002b76, 0x002b95, PG_U_OTHER_SYMBOL},
	{0x002b97, 0x002bff, PG_U_OTHER_SYMBOL},
	{0x002c00, 0x002c2f, PG_U_UPPERCASE_LETTER},
	{0x002c30, 0x002c5f, PG_U_LOWERCASE_LETTER},
	{0x002c60, 0x002c60, PG_U_UPPERCASE_LETTER},
	{0x002c61, 0x002c61, PG_U_LOWERCASE_LETTER},
	{0x002c62, 0x002c64, PG_U_UPPERCASE_LETTER},
	{0x002c65, 0x002c66, PG_U_LOWERCASE_LETTER},
	{0x002c67, 0x002c67, PG_U_UPPERCASE_LETTER},
	{0x002c68, 0x002c68, PG_U_LOWERCASE_LETTER},
	{0x002c69, 0x002c69, PG_U_UPPERCASE_LETTER},
	{0x002c6a, 0x002c6a, PG_U_LOWERCASE_LETTER},
	{0x002c6b, 0x002c6b, PG_U_UPPERCASE_LETTER},
	{0x002c6c, 0x002c6c, PG_U_LOWERCASE_LETTER},
	{0x002c6d, 0x002c70, PG_U_UPPERCASE_LETTER},
	{0x002c71, 0x002c71, PG_U_LOWERCASE_LETTER},
	{0x002c72, 0x002c72, PG_U_UPPERCASE_LETTER},
	{0x002c73, 0x002c74, PG_U_LOWERCASE_LETTER},
	{0x002c75, 0x002c75, PG_U_UPPERCASE_LETTER},
	{0x002c76, 0x002c7b, PG_U_LOWERCASE_LETTER},
	{0x002c7c, 0x002c7d, PG_U_MODIFIER_LETTER},
	{0x002c7e, 0x002c80, PG_U_UPPERCASE_LETTER},
	{0x002c81, 0x002c81, PG_U_LOWERCASE_LETTER},
	{0x002c82, 0x002c82, PG_U_UPPERCASE_LETTER},
	{0x002c83, 0x002c83, PG_U_LOWERCASE_LETTER},
	{0x002c84, 0x002c84, PG_U_UPPERCASE_LETTER},
	{0x002c85, 0x002c85, PG_U_LOWERCASE_LETTER},
	{0x002c86, 0x002c86, PG_U_UPPERCASE_LETTER},
	{0x002c87, 0x002c87, PG_U_LOWERCASE_LETTER},
	{0x002c88, 0x002c88, PG_U_UPPERCASE_LETTER},
	{0x002c89, 0x002c89, PG_U_LOWERCASE_LETTER},
	{0x002c8a, 0x002c8a, PG_U_UPPERCASE_LETTER},
	{0x002c8b, 0x002c8b, PG_U_LOWERCASE_LETTER},
	{0x002c8c, 0x002c8c, PG_U_UPPERCASE_LETTER},
	{0x002c8d, 0x002c8d, PG_U_LOWERCASE_LETTER},
	{0x002c8e, 0x002c8e, PG_U_UPPERCASE_LETTER},
	{0x002c8f, 0x002c8f, PG_U_LOWERCASE_LETTER},
	{0x002c90, 0x002c90, PG_U_UPPERCASE_LETTER},
	{0x002c91, 0x002c91, PG_U_LOWERCASE_LETTER},
	{0x002c92, 0x002c92, PG_U_UPPERCASE_LETTER},
	{0x002c93, 0x002c93, PG_U_LOWERCASE_LETTER},
	{0x002c94, 0x002c94, PG_U_UPPERCASE_LETTER},
	{0x002c95, 0x002c95, PG_U_LOWERCASE_LETTER},
	{0x002c96, 0x002c96, PG_U_UPPERCASE_LETTER},
	{0x002c97, 0x002c97, PG_U_LOWERCASE_LETTER},
	{0x002c98, 0x002c98, PG_U_UPPERCASE_LETTER},
	{0x002c99, 0x002c99, PG_U_LOWERCASE_LETTER},
	{0x002c9a, 0x002c9a, PG_U_UPPERCASE_LETTER},
	{0x002c9b, 0x002c9b, PG_U_LOWERCASE_LETTER},
	{0x002c9c, 0x002c9c, PG_U_UPPERCASE_LETTER},
	{0x002c9d, 0x002c9d, PG_U_LOWERCASE_LETTER},
	{0x002c9e, 0x002c9e, PG_U_UPPERCASE_LETTER},
	{0x002c9f, 0x002c9f, PG_U_LOWERCASE_LETTER},
	{0x002ca0, 0x002ca0, PG_U_UPPERCASE_LETTER},
	{0x002ca1, 0x002ca1, PG_U_LOWERCASE_LETTER},
	{0x002ca2, 0x002ca2, PG_U_UPPERCASE_LETTER},
	{0x002ca3, 0x002ca3, PG_U_LOWERCASE_LETTER},
	{0x002ca4, 0x002ca4, PG_U_UPPERCASE_LETTER},
	{0x002ca5, 0x002ca5, PG_U_LOWERCASE_LETTER},
	{0x002ca6, 0x002ca6, PG_U_UPPERCASE_LETTER},
	{0x002ca7, 0x002ca7, PG_U_LOWERCASE_LETTER},
	{0x002ca8, 0x002ca8, PG_U_UPPERCASE_LETTER},
	{0x002ca9, 0x002ca9, PG_U_LOWERCASE_LETTER},
	{0x002caa, 0x002caa, PG_U_UPPERCASE_LETTER},
	{0x002cab, 0x002cab, PG_U_LOWERCASE_LETTER},
	{0x002cac, 0x002cac, PG_U_UPPERCASE_LETTER},
	{0x002cad, 0x002cad, PG_U_LOWERCASE_LETTER},
	{0x002cae, 0x002cae, PG_U_UPPERCASE_LETTER},
	{0x002caf, 0x002caf, PG_U_LOWERCASE_LETTER},
	{0x002cb0, 0x002cb0, PG_U_UPPERCASE_LETTER},
	{0x002cb1, 0x002cb1, PG_U_LOWERCASE_LETTER},
	{0x002cb2, 0x002cb2, PG_U_UPPERCASE_LETTER},
	{0x002cb3, 0x002cb3, PG_U_LOWERCASE_LETTER},
	{0x002cb4, 0x002cb4, PG_U_UPPERCASE_LETTER},
	{0x002cb5, 0x002cb5, PG_U_LOWERCASE_LETTER},
	{0x002cb6, 0x002cb6, PG_U_UPPERCASE_LETTER},
	{0x002cb7, 0x002cb7, PG_U_LOWERCASE_LETTER},
	{0x002cb8, 0x002cb8, PG_U_UPPERCASE_LETTER},
	{0x002cb9, 0x002cb9, PG_U_LOWERCASE_LETTER},
	{0x002cba, 0x002cba, PG_U_UPPERCASE_LETTER},
	{0x002cbb, 0x002cbb, PG_U_LOWERCASE_LETTER},
	{0x002cbc, 0x002cbc, PG_U_UPPERCASE_LETTER},
	{0x002cbd, 0x002cbd, PG_U_LOWERCASE_LETTER},
	{0x002cbe, 0x002cbe, PG_U_UPPERCASE_LETTER},
	{0x002cbf, 0x002cbf, PG_U_LOWERCASE_LETTER},
	{0x002cc0, 0x002cc0, PG_U_UPPERCASE_LETTER},
	{0x002cc1, 0x002cc1, PG_U_LOWERCASE_LETTER},
	{0x002cc2, 0x002cc2, PG_U_UPPERCASE_LETTER},
	{0x002cc3, 0x002cc3, PG_U_LOWERCASE_LETTER},
	{0x002cc4, 0x002cc4, PG_U_UPPERCASE_LETTER},
	{0x002cc5, 0x002cc5, PG_U_LOWERCASE_LETTER},
	{0x002cc6, 0x002cc6, PG_U_UPPERCASE_LETTER},
	{0x002cc7, 0x002cc7, PG_U_LOWERCASE_LETTER},
	{0x002cc8, 0x002cc8, PG_U_UPPERCASE_LETTER},
	{0x002cc9, 0x002cc9, PG_U_LOWERCASE_LETTER},
	{0x002cca, 0x002cca, PG_U_UPPERCASE_LETTER},
	{0x002ccb, 0x002ccb, PG_U_LOWERCASE_LETTER},
	{0x002ccc, 0x002ccc, PG_U_UPPERCASE_LETTER},
	{0x002ccd, 0x002ccd, PG_U_LOWERCASE_LETTER},
	{0x002cce, 0x002cce, PG_U_UPPERCASE_LETTER},
	{0x002ccf, 0x002ccf, PG_U_LOWERCASE_LETTER},
	{0x002cd0, 0x002cd0, PG_U_UPPERCASE_LETTER},
	{0x002cd1, 0x002cd1, PG_U_LOWERCASE_LETTER},
	{0x002cd2, 0x002cd2, PG_U_UPPERCASE_LETTER},
	{0x002cd3, 0x002cd3, PG_U_LOWERCASE_LETTER},
	{0x002cd4, 0x002cd4, PG_U_UPPERCASE_LETTER},
	{0x002cd5, 0x002cd5, PG_U_LOWERCASE_LETTER},
	{0x002cd6, 0x002cd6, PG_U_UPPERCASE_LETTER},
	{0x002cd7, 0x002cd7, PG_U_LOWERCASE_LETTER},
	{0x002cd8, 0x002cd8, PG_U_UPPERCASE_LETTER},
	{0x002cd9, 0x002cd9, PG_U_LOWERCASE_LETTER},
	{0x002cda, 0x002cda, PG_U_UPPERCASE_LETTER},
	{0x002cdb, 0x002cdb, PG_U_LOWERCASE_LETTER},
	{0x002cdc, 0x002cdc, PG_U_UPPERCASE_LETTER},
	{0x002cdd, 0x002cdd, PG_U_LOWERCASE_LETTER},
	{0x002cde, 0x002cde, PG_U_UPPERCASE_LETTER},
	{0x002cdf, 0x002cdf, PG_U_LOWERCASE_LETTER},
	{0x002ce0, 0x002ce0, PG_U_UPPERCASE_LETTER},
	{0x002ce1, 0x002ce1, PG_U_LOWERCASE_LETTER},
	{0x002ce2, 0x002ce2, PG_U_UPPERCASE_LETTER},
	{0x002ce3, 0x002ce4, PG_U_LOWERCASE_LETTER},
	{0x002ce5, 0x002cea, PG_U_OTHER_SYMBOL},
	{0x002ceb, 0x002ceb, PG_U_UPPERCASE_LETTER},
	{0x002cec, 0x002cec, PG_U_LOWERCASE_LETTER},
	{0x002ced, 0x002ced, PG_U_UPPERCASE_LETTER},
	{0x002cee, 0x002cee, PG_U_LOWERCASE_LETTER},
	{0x002cef, 0x002cf1, PG_U_NONSPACING_MARK},
	{0x002cf2, 0x002cf2, PG_U_UPPERCASE_LETTER},
	{0x002cf3, 0x002cf3, PG_U_LOWERCASE_LETTER},
	{0x002cf9, 0x002cfc, PG_U_OTHER_PUNCTUATION},
	{0x002cfd, 0x002cfd, PG_U_OTHER_NUMBER},
	{0x002cfe, 0x002cff, PG_U_OTHER_PUNCTUATION},
	{0x002d00, 0x002d25, PG_U_LOWERCASE_LETTER},
	{0x002d27, 0x002d27, PG_U_LOWERCASE_LETTER},
	{0x002d2d, 0x002d2d, PG_U_LOWERCASE_LETTER},
	{0x002d30, 0x002d67, PG_U_OTHER_LETTER},
	{0x002d6f, 0x002d6f, PG_U_MODIFIER_LETTER},
	{0x002d70, 0x002d70, PG_U_OTHER_PUNCTUATION},
	{0x002d7f, 0x002d7f, PG_U_NONSPACING_MARK},
	{0x002d80, 0x002d96, PG_U_OTHER_LETTER},
	{0x002da0, 0x002da6, PG_U_OTHER_LETTER},
	{0x002da8, 0x002dae, PG_U_OTHER_LETTER},
	{0x002db0, 0x002db6, PG_U_OTHER_LETTER},
	{0x002db8, 0x002dbe, PG_U_OTHER_LETTER},
	{0x002dc0, 0x002dc6, PG_U_OTHER_LETTER},
	{0x002dc8, 0x002dce, PG_U_OTHER_LETTER},
	{0x002dd0, 0x002dd6, PG_U_OTHER_LETTER},
	{0x002dd8, 0x002dde, PG_U_OTHER_LETTER},
	{0x002de0, 0x002dff, PG_U_NONSPACING_MARK},
	{0x002e00, 0x002e01, PG_U_OTHER_PUNCTUATION},
	{0x002e02, 0x002e02, PG_U_INITIAL_PUNCTUATION},
	{0x002e03, 0x002e03, PG_U_FINAL_PUNCTUATION},
	{0x002e04, 0x002e04, PG_U_INITIAL_PUNCTUATION},
	{0x002e05, 0x002e05, PG_U_FINAL_PUNCTUATION},
	{0x002e06, 0x002e08, PG_U_OTHER_PUNCTUATION},
	{0x002e09, 0x002e09, PG_U_INITIAL_PUNCTUATION},
	{0x002e0a, 0x002e0a, PG_U_FINAL_PUNCTUATION},
	{0x002e0b, 0x002e0b, PG_U_OTHER_PUNCTUATION},
	{0x002e0c, 0x002e0c, PG_U_INITIAL_PUNCTUATION},
	{0x002e0d, 0x002e0d, PG_U_FINAL_PUNCTUATION},
	{0x002e0e, 0x002e16, PG_U_OTHER_PUNCTUATION},
	{0x002e17, 0x002e17, PG_U_DASH_PUNCTUATION},
	{0x002e18, 0x002e19, PG_U_OTHER_PUNCTUATION},
	{0x002e1a, 0x002e1a, PG_U_DASH_PUNCTUATION},
	{0x002e1b, 0x002e1b, PG_U_OTHER_PUNCTUATION},
	{0x002e1c, 0x002e1c, PG_U_INITIAL_PUNCTUATION},
	{0x002e1d, 0x002e1d, PG_U_FINAL_PUNCTUATION},
	{0x002e1e, 0x002e1f, PG_U_OTHER_PUNCTUATION},
	{0x002e20, 0x002e20, PG_U_INITIAL_PUNCTUATION},
	{0x002e21, 0x002e21, PG_U_FINAL_PUNCTUATION},
	{0x002e22, 0x002e22, PG_U_OPEN_PUNCTUATION},
	{0x002e23, 0x002e23, PG_U_CLOSE_PUNCTUATION},
	{0x002e24, 0x002e24, PG_U_OPEN_PUNCTUATION},
	{0x002e25, 0x002e25, PG_U_CLOSE_PUNCTUATION},
	{0x002e26, 0x002e26, PG_U_OPEN_PUNCTUATION},
	{0x002e27, 0x002e27, PG_U_CLOSE_PUNCTUATION},
	{0x002e28, 0x002e28, PG_U_OPEN_PUNCTUATION},
	{0x002e29, 0x002e29, PG_U_CLOSE_PUNCTUATION},
	{0x002e2a, 0x002e2e, PG_U_OTHER_PUNCTUATION},
	{0x002e2f, 0x002e2f, PG_U_MODIFIER_LETTER},
	{0x002e30, 0x002e39, PG_U_OTHER_PUNCTUATION},
	{0x002e3a, 0x002e3b, PG_U_DASH_PUNCTUATION},
	{0x002e3c, 0x002e3f, PG_U_OTHER_PUNCTUATION},
	{0x002e40, 0x002e40, PG_U_DASH_PUNCTUATION},
	{0x002e41, 0x002e41, PG_U_OTHER_PUNCTUATION},
	{0x002e42, 0x002e42, PG_U_OPEN_PUNCTUATION},
	{0x002e43, 0x002e4f, PG_U_OTHER_PUNCTUATION},
	{0x002e50, 0x002e51, PG_U_OTHER_SYMBOL},
	{0x002e52, 0x002e54, PG_U_OTHER_PUNCTUATION},
	{0x002e55, 0x002e55, PG_U_OPEN_PUNCTUATION},
	{0x002e56, 0x002e56, PG_U_CLOSE_PUNCTUATION},
	{0x002e57, 0x002e57, PG_U_OPEN_PUNCTUATION},
	{0x002e58, 0x002e58, PG_U_CLOSE_PUNCTUATION},
	{0x002e59, 0x002e59, PG_U_OPEN_PUNCTUATION},
	{0x002e5a, 0x002e5a, PG_U_CLOSE_PUNCTUATION},
	{0x002e5b, 0x002e5b, PG_U_OPEN_PUNCTUATION},
	{0x002e5c, 0x002e5c, PG_U_CLOSE_PUNCTUATION},
	{0x002e5d, 0x002e5d, PG_U_DASH_PUNCTUATION},
	{0x002e80, 0x002e99, PG_U_OTHER_SYMBOL},
	{0x002e9b, 0x002ef3, PG_U_OTHER_SYMBOL},
	{0x002f00, 0x002fd5, PG_U_OTHER_SYMBOL},
	{0x002ff0, 0x002fff, PG_U_OTHER_SYMBOL},
	{0x003000, 0x003000, PG_U_SPACE_SEPARATOR},
	{0x003001, 0x003003, PG_U_OTHER_PUNCTUATION},
	{0x003004, 0x003004, PG_U_OTHER_SYMBOL},
	{0x003005, 0x003005, PG_U_MODIFIER_LETTER},
	{0x003006, 0x003006, PG_U_OTHER_LETTER},
	{0x003007, 0x003007, PG_U_LETTER_NUMBER},
	{0x003008, 0x003008, PG_U_OPEN_PUNCTUATION},
	{0x003009, 0x003009, PG_U_CLOSE_PUNCTUATION},
	{0x00300a, 0x00300a, PG_U_OPEN_PUNCTUATION},
	{0x00300b, 0x00300b, PG_U_CLOSE_PUNCTUATION},
	{0x00300c, 0x00300c, PG_U_OPEN_PUNCTUATION},
	{0x00300d, 0x00300d, PG_U_CLOSE_PUNCTUATION},
	{0x00300e, 0x00300e, PG_U_OPEN_PUNCTUATION},
	{0x00300f, 0x00300f, PG_U_CLOSE_PUNCTUATION},
	{0x003010, 0x003010, PG_U_OPEN_PUNCTUATION},
	{0x003011, 0x003011, PG_U_CLOSE_PUNCTUATION},
	{0x003012, 0x003013, PG_U_OTHER_SYMBOL},
	{0x003014, 0x003014, PG_U_OPEN_PUNCTUATION},
	{0x003015, 0x003015, PG_U_CLOSE_PUNCTUATION},
	{0x003016, 0x003016, PG_U_OPEN_PUNCTUATION},
	{0x003017, 0x003017, PG_U_CLOSE_PUNCTUATION},
	{0x003018, 0x003018, PG_U_OPEN_PUNCTUATION},
	{0x003019, 0x003019, PG_U_CLOSE_PUNCTUATION},
	{0x00301a, 0x00301a, PG_U_OPEN_PUNCTUATION},
	{0x00301b, 0x00301b, PG_U_CLOSE_PUNCTUATION},
	{0x00301c, 0x00301c, PG_U_DASH_PUNCTUATION},
	{0x00301d, 0x00301d, PG_U_OPEN_PUNCTUATION},
	{0x00301e, 0x00301f, PG_U_CLOSE_PUNCTUATION},
	{0x003020, 0x003020, PG_U_OTHER_SYMBOL},
	{0x003021, 0x003029, PG_U_LETTER_NUMBER},
	{0x00302a, 0x00302d, PG_U_NONSPACING_MARK},
	{0x00302e, 0x00302f, PG_U_SPACING_MARK},
	{0x003030, 0x003030, PG_U_DASH_PUNCTUATION},
	{0x003031, 0x003035, PG_U_MODIFIER_LETTER},
	{0x003036, 0x003037, PG_U_OTHER_SYMBOL},
	{0x003038, 0x00303a, PG_U_LETTER_NUMBER},
	{0x00303b, 0x00303b, PG_U_MODIFIER_LETTER},
	{0x00303c, 0x00303c, PG_U_OTHER_LETTER},
	{0x00303d, 0x00303d, PG_U_OTHER_PUNCTUATION},
	{0x00303e, 0x00303f, PG_U_OTHER_SYMBOL},
	{0x003041, 0x003096, PG_U_OTHER_LETTER},
	{0x003099, 0x00309a, PG_U_NONSPACING_MARK},
	{0x00309b, 0x00309c, PG_U_MODIFIER_SYMBOL},
	{0x00309d, 0x00309e, PG_U_MODIFIER_LETTER},
	{0x00309f, 0x00309f, PG_U_OTHER_LETTER},
	{0x0030a0, 0x0030a0, PG_U_DASH_PUNCTUATION},
	{0x0030a1, 0x0030fa, PG_U_OTHER_LETTER},
	{0x0030fb, 0x0030fb, PG_U_OTHER_PUNCTUATION},
	{0x0030fc, 0x0030fe, PG_U_MODIFIER_LETTER},
	{0x0030ff, 0x0030ff, PG_U_OTHER_LETTER},
	{0x003105, 0x00312f, PG_U_OTHER_LETTER},
	{0x003131, 0x00318e, PG_U_OTHER_LETTER},
	{0x003190, 0x003191, PG_U_OTHER_SYMBOL},
	{0x003192, 0x003195, PG_U_OTHER_NUMBER},
	{0x003196, 0x00319f, PG_U_OTHER_SYMBOL},
	{0x0031a0, 0x0031bf, PG_U_OTHER_LETTER},
	{0x0031c0, 0x0031e3, PG_U_OTHER_SYMBOL},
	{0x0031ef, 0x0031ef, PG_U_OTHER_SYMBOL},
	{0x0031f0, 0x0031ff, PG_U_OTHER_LETTER},
	{0x003200, 0x00321e, PG_U_OTHER_SYMBOL},
	{0x003220, 0x003229, PG_U_OTHER_NUMBER},
	{0x00322a, 0x003247, PG_U_OTHER_SYMBOL},
	{0x003248, 0x00324f, PG_U_OTHER_NUMBER},
	{0x003250, 0x003250, PG_U_OTHER_SYMBOL},
	{0x003251, 0x00325f, PG_U_OTHER_NUMBER},
	{0x003260, 0x00327f, PG_U_OTHER_SYMBOL},
	{0x003280, 0x003289, PG_U_OTHER_NUMBER},
	{0x00328a, 0x0032b0, PG_U_OTHER_SYMBOL},
	{0x0032b1, 0x0032bf, PG_U_OTHER_NUMBER},
	{0x0032c0, 0x0033ff, PG_U_OTHER_SYMBOL},
	{0x003400, 0x004dbf, PG_U_OTHER_LETTER},
	{0x004dc0, 0x004dff, PG_U_OTHER_SYMBOL},
	{0x004e00, 0x00a014, PG_U_OTHER_LETTER},
	{0x00a015, 0x00a015, PG_U_MODIFIER_LETTER},
	{0x00a016, 0x00a48c, PG_U_OTHER_LETTER},
	{0x00a490, 0x00a4c6, PG_U_OTHER_SYMBOL},
	{0x00a4d0, 0x00a4f7, PG_U_OTHER_LETTER},
	{0x00a4f8, 0x00a4fd, PG_U_MODIFIER_LETTER},
	{0x00a4fe, 0x00a4ff, PG_U_OTHER_PUNCTUATION},
	{0x00a500, 0x00a60b, PG_U_OTHER_LETTER},
	{0x00a60c, 0x00a60c, PG_U_MODIFIER_LETTER},
	{0x00a60d, 0x00a60f, PG_U_OTHER_PUNCTUATION},
	{0x00a610, 0x00a61f, PG_U_OTHER_LETTER},
	{0x00a620, 0x00a629, PG_U_DECIMAL_NUMBER},
	{0x00a62a, 0x00a62b, PG_U_OTHER_LETTER},
	{0x00a640, 0x00a640, PG_U_UPPERCASE_LETTER},
	{0x00a641, 0x00a641, PG_U_LOWERCASE_LETTER},
	{0x00a642, 0x00a642, PG_U_UPPERCASE_LETTER},
	{0x00a643, 0x00a643, PG_U_LOWERCASE_LETTER},
	{0x00a644, 0x00a644, PG_U_UPPERCASE_LETTER},
	{0x00a645, 0x00a645, PG_U_LOWERCASE_LETTER},
	{0x00a646, 0x00a646, PG_U_UPPERCASE_LETTER},
	{0x00a647, 0x00a647, PG_U_LOWERCASE_LETTER},
	{0x00a648, 0x00a648, PG_U_UPPERCASE_LETTER},
	{0x00a649, 0x00a649, PG_U_LOWERCASE_LETTER},
	{0x00a64a, 0x00a64a, PG_U_UPPERCASE_LETTER},
	{0x00a64b, 0x00a64b, PG_U_LOWERCASE_LETTER},
	{0x00a64c, 0x00a64c, PG_U_UPPERCASE_LETTER},
	{0x00a64d, 0x00a64d, PG_U_LOWERCASE_LETTER},
	{0x00a64e, 0x00a64e, PG_U_UPPERCASE_LETTER},
	{0x00a64f, 0x00a64f, PG_U_LOWERCASE_LETTER},
	{0x00a650, 0x00a650, PG_U_UPPERCASE_LETTER},
	{0x00a651, 0x00a651, PG_U_LOWERCASE_LETTER},
	{0x00a652, 0x00a652, PG_U_UPPERCASE_LETTER},
	{0x00a653, 0x00a653, PG_U_LOWERCASE_LETTER},
	{0x00a654, 0x00a654, PG_U_UPPERCASE_LETTER},
	{0x00a655, 0x00a655, PG_U_LOWERCASE_LETTER},
	{0x00a656, 0x00a656, PG_U_UPPERCASE_LETTER},
	{0x00a657, 0x00a657, PG_U_LOWERCASE_LETTER},
	{0x00a658, 0x00a658, PG_U_UPPERCASE_LETTER},
	{0x00a659, 0x00a659, PG_U_LOWERCASE_LETTER},
	{0x00a65a, 0x00a65a, PG_U_UPPERCASE_LETTER},
	{0x00a65b, 0x00a65b, PG_U_LOWERCASE_LETTER},
	{0x00a65c, 0x00a65c, PG_U_UPPERCASE_LETTER},
	{0x00a65d, 0x00a65d, PG_U_LOWERCASE_LETTER},
	{0x00a65e, 0x00a65e, PG_U_UPPERCASE_LETTER},
	{0x00a65f, 0x00a65f, PG_U_LOWERCASE_LETTER},
	{0x00a660, 0x00a660, PG_U_UPPERCASE_LETTER},
	{0x00a661, 0x00a661, PG_U_LOWERCASE_LETTER},
	{0x00a662, 0x00a662, PG_U_UPPERCASE_LETTER},
	{0x00a663, 0x00a663, PG_U_LOWERCASE_LETTER},
	{0x00a664, 0x00a664, PG_U_UPPERCASE_LETTER},
	{0x00a665, 0x00a665, PG_U_LOWERCASE_LETTER},
	{0x00a666, 0x00a666, PG_U_UPPERCASE_LETTER},
	{0x00a667, 0x00a667, PG_U_LOWERCASE_LETTER},
	{0x00a668, 0x00a668, PG_U_UPPERCASE_LETTER},
	{0x00a669, 0x00a669, PG_U_LOWERCASE_LETTER},
	{0x00a66a, 0x00a66a, PG_U_UPPERCASE_LETTER},
	{0x00a66b, 0x00a66b, PG_U_LOWERCASE_LETTER},
	{0x00a66c, 0x00a66c, PG_U_UPPERCASE_LETTER},
	{0x00a66d, 0x00a66d, PG_U_LOWERCASE_LETTER},
	{0x00a66e, 0x00a66e, PG_U_OTHER_LETTER},
	{0x00a66f, 0x00a66f, PG_U_NONSPACING_MARK},
	{0x00a670, 0x00a672, PG_U_ENCLOSING_MARK},
	{0x00a673, 0x00a673, PG_U_OTHER_PUNCTUATION},
	{0x00a674, 0x00a67d, PG_U_NONSPACING_MARK},
	{0x00a67e, 0x00a67e, PG_U_OTHER_PUNCTUATION},
	{0x00a67f, 0x00a67f, PG_U_MODIFIER_LETTER},
	{0x00a680, 0x00a680, PG_U_UPPERCASE_LETTER},
	{0x00a681, 0x00a681, PG_U_LOWERCASE_LETTER},
	{0x00a682, 0x00a682, PG_U_UPPERCASE_LETTER},
	{0x00a683, 0x00a683, PG_U_LOWERCASE_LETTER},
	{0x00a684, 0x00a684, PG_U_UPPERCASE_LETTER},
	{0x00a685, 0x00a685, PG_U_LOWERCASE_LETTER},
	{0x00a686, 0x00a686, PG_U_UPPERCASE_LETTER},
	{0x00a687, 0x00a687, PG_U_LOWERCASE_LETTER},
	{0x00a688, 0x00a688, PG_U_UPPERCASE_LETTER},
	{0x00a689, 0x00a689, PG_U_LOWERCASE_LETTER},
	{0x00a68a, 0x00a68a, PG_U_UPPERCASE_LETTER},
	{0x00a68b, 0x00a68b, PG_U_LOWERCASE_LETTER},
	{0x00a68c, 0x00a68c, PG_U_UPPERCASE_LETTER},
	{0x00a68d, 0x00a68d, PG_U_LOWERCASE_LETTER},
	{0x00a68e, 0x00a68e, PG_U_UPPERCASE_LETTER},
	{0x00a68f, 0x00a68f, PG_U_LOWERCASE_LETTER},
	{0x00a690, 0x00a690, PG_U_UPPERCASE_LETTER},
	{0x00a691, 0x00a691, PG_U_LOWERCASE_LETTER},
	{0x00a692, 0x00a692, PG_U_UPPERCASE_LETTER},
	{0x00a693, 0x00a693, PG_U_LOWERCASE_LETTER},
	{0x00a694, 0x00a694, PG_U_UPPERCASE_LETTER},
	{0x00a695, 0x00a695, PG_U_LOWERCASE_LETTER},
	{0x00a696, 0x00a696, PG_U_UPPERCASE_LETTER},
	{0x00a697, 0x00a697, PG_U_LOWERCASE_LETTER},
	{0x00a698, 0x00a698, PG_U_UPPERCASE_LETTER},
	{0x00a699, 0x00a699, PG_U_LOWERCASE_LETTER},
	{0x00a69a, 0x00a69a, PG_U_UPPERCASE_LETTER},
	{0x00a69b, 0x00a69b, PG_U_LOWERCASE_LETTER},
	{0x00a69c, 0x00a69d, PG_U_MODIFIER_LETTER},
	{0x00a69e, 0x00a69f, PG_U_NONSPACING_MARK},
	{0x00a6a0, 0x00a6e5, PG_U_OTHER_LETTER},
	{0x00a6e6, 0x00a6ef, PG_U_LETTER_NUMBER},
	{0x00a6f0, 0x00a6f1, PG_U_NONSPACING_MARK},
	{0x00a6f2, 0x00a6f7, PG_U_OTHER_PUNCTUATION},
	{0x00a700, 0x00a716, PG_U_MODIFIER_SYMBOL},
	{0x00a717, 0x00a71f, PG_U_MODIFIER_LETTER},
	{0x00a720, 0x00a721, PG_U_MODIFIER_SYMBOL},
	{0x00a722, 0x00a722, PG_U_UPPERCASE_LETTER},
	{0x00a723, 0x00a723, PG_U_LOWERCASE_LETTER},
	{0x00a724, 0x00a724, PG_U_UPPERCASE_LETTER},
	{0x00a725, 0x00a725, PG_U_LOWERCASE_LETTER},
	{0x00a726, 0x00a726, PG_U_UPPERCASE_LETTER},
	{0x00a727, 0x00a727, PG_U_LOWERCASE_LETTER},
	{0x00a728, 0x00a728, PG_U_UPPERCASE_LETTER},
	{0x00a729, 0x00a729, PG_U_LOWERCASE_LETTER},
	{0x00a72a, 0x00a72a, PG_U_UPPERCASE_LETTER},
	{0x00a72b, 0x00a72b, PG_U_LOWERCASE_LETTER},
	{0x00a72c, 0x00a72c, PG_U_UPPERCASE_LETTER},
	{0x00a72d, 0x00a72d, PG_U_LOWERCASE_LETTER},
	{0x00a72e, 0x00a72e, PG_U_UPPERCASE_LETTER},
	{0x00a72f, 0x00a731, PG_U_LOWERCASE_LETTER},
	{0x00a732, 0x00a732, PG_U_UPPERCASE_LETTER},
	{0x00a733, 0x00a733, PG_U_LOWERCASE_LETTER},
	{0x00a734, 0x00a734, PG_U_UPPERCASE_LETTER},
	{0x00a735, 0x00a735, PG_U_LOWERCASE_LETTER},
	{0x00a736, 0x00a736, PG_U_UPPERCASE_LETTER},
	{0x00a737, 0x00a737, PG_U_LOWERCASE_LETTER},
	{0x00a738, 0x00a738, PG_U_UPPERCASE_LETTER},
	{0x00a739, 0x00a739, PG_U_LOWERCASE_LETTER},
	{0x00a73a, 0x00a73a, PG_U_UPPERCASE_LETTER},
	{0x00a73b, 0x00a73b, PG_U_LOWERCASE_LETTER},
	{0x00a73c, 0x00a73c, PG_U_UPPERCASE_LETTER},
	{0x00a73d, 0x00a73d, PG_U_LOWERCASE_LETTER},
	{0x00a73e, 0x00a73e, PG_U_UPPERCASE_LETTER},
	{0x00a73f, 0x00a73f, PG_U_LOWERCASE_LETTER},
	{0x00a740, 0x00a740, PG_U_UPPERCASE_LETTER},
	{0x00a741, 0x00a741, PG_U_LOWERCASE_LETTER},
	{0x00a742, 0x00a742, PG_U_UPPERCASE_LETTER},
	{0x00a743, 0x00a743, PG_U_LOWERCASE_LETTER},
	{0x00a744, 0x00a744, PG_U_UPPERCASE_LETTER},
	{0x00a745, 0x00a745, PG_U_LOWERCASE_LETTER},
	{0x00a746, 0x00a746, PG_U_UPPERCASE_LETTER},
	{0x00a747, 0x00a747, PG_U_LOWERCASE_LETTER},
	{0x00a748, 0x00a748, PG_U_UPPERCASE_LETTER},
	{0x00a749, 0x00a749, PG_U_LOWERCASE_LETTER},
	{0x00a74a, 0x00a74a, PG_U_UPPERCASE_LETTER},
	{0x00a74b, 0x00a74b, PG_U_LOWERCASE_LETTER},
	{0x00a74c, 0x00a74c, PG_U_UPPERCASE_LETTER},
	{0x00a74d, 0x00a74d, PG_U_LOWERCASE_LETTER},
	{0x00a74e, 0x00a74e, PG_U_UPPERCASE_LETTER},
	{0x00a74f, 0x00a74f, PG_U_LOWERCASE_LETTER},
	{0x00a750, 0x00a750, PG_U_UPPERCASE_LETTER},
	{0x00a751, 0x00a751, PG_U_LOWERCASE_LETTER},
	{0x00a752, 0x00a752, PG_U_UPPERCASE_LETTER},
	{0x00a753, 0x00a753, PG_U_LOWERCASE_LETTER},
	{0x00a754, 0x00a754, PG_U_UPPERCASE_LETTER},
	{0x00a755, 0x00a755, PG_U_LOWERCASE_LETTER},
	{0x00a756, 0x00a756, PG_U_UPPERCASE_LETTER},
	{0x00a757, 0x00a757, PG_U_LOWERCASE_LETTER},
	{0x00a758, 0x00a758, PG_U_UPPERCASE_LETTER},
	{0x00a759, 0x00a759, PG_U_LOWERCASE_LETTER},
	{0x00a75a, 0x00a75a, PG_U_UPPERCASE_LETTER},
	{0x00a75b, 0x00a75b, PG_U_LOWERCASE_LETTER},
	{0x00a75c, 0x00a75c, PG_U_UPPERCASE_LETTER},
	{0x00a75d, 0x00a75d, PG_U_LOWERCASE_LETTER},
	{0x00a75e, 0x00a75e, PG_U_UPPERCASE_LETTER},
	{0x00a75f, 0x00a75f, PG_U_LOWERCASE_LETTER},
	{0x00a760, 0x00a760, PG_U_UPPERCASE_LETTER},
	{0x00a761, 0x00a761, PG_U_LOWERCASE_LETTER},
	{0x00a762, 0x00a762, PG_U_UPPERCASE_LETTER},
	{0x00a763, 0x00a763, PG_U_LOWERCASE_LETTER},
	{0x00a764, 0x00a764, PG_U_UPPERCASE_LETTER},
	{0x00a765, 0x00a765, PG_U_LOWERCASE_LETTER},
	{0x00a766, 0x00a766, PG_U_UPPERCASE_LETTER},
	{0x00a767, 0x00a767, PG_U_LOWERCASE_LETTER},
	{0x00a768, 0x00a768, PG_U_UPPERCASE_LETTER},
	{0x00a769, 0x00a769, PG_U_LOWERCASE_LETTER},
	{0x00a76a, 0x00a76a, PG_U_UPPERCASE_LETTER},
	{0x00a76b, 0x00a76b, PG_U_LOWERCASE_LETTER},
	{0x00a76c, 0x00a76c, PG_U_UPPERCASE_LETTER},
	{0x00a76d, 0x00a76d, PG_U_LOWERCASE_LETTER},
	{0x00a76e, 0x00a76e, PG_U_UPPERCASE_LETTER},
	{0x00a76f, 0x00a76f, PG_U_LOWERCASE_LETTER},
	{0x00a770, 0x00a770, PG_U_MODIFIER_LETTER},
	{0x00a771, 0x00a778, PG_U_LOWERCASE_LETTER},
	{0x00a779, 0x00a779, PG_U_UPPERCASE_LETTER},
	{0x00a77a, 0x00a77a, PG_U_LOWERCASE_LETTER},
	{0x00a77b, 0x00a77b, PG_U_UPPERCASE_LETTER},
	{0x00a77c, 0x00a77c, PG_U_LOWERCASE_LETTER},
	{0x00a77d, 0x00a77e, PG_U_UPPERCASE_LETTER},
	{0x00a77f, 0x00a77f, PG_U_LOWERCASE_LETTER},
	{0x00a780, 0x00a780, PG_U_UPPERCASE_LETTER},
	{0x00a781, 0x00a781, PG_U_LOWERCASE_LETTER},
	{0x00a782, 0x00a782, PG_U_UPPERCASE_LETTER},
	{0x00a783, 0x00a783, PG_U_LOWERCASE_LETTER},
	{0x00a784, 0x00a784, PG_U_UPPERCASE_LETTER},
	{0x00a785, 0x00a785, PG_U_LOWERCASE_LETTER},
	{0x00a786, 0x00a786, PG_U_UPPERCASE_LETTER},
	{0x00a787, 0x00a787, PG_U_LOWERCASE_LETTER},
	{0x00a788, 0x00a788, PG_U_MODIFIER_LETTER},
	{0x00a789, 0x00a78a, PG_U_MODIFIER_SYMBOL},
	{0x00a78b, 0x00a78b, PG_U_UPPERCASE_LETTER},
	{0x00a78c, 0x00a78c, PG_U_LOWERCASE_LETTER},
	{0x00a78d, 0x00a78d, PG_U_UPPERCASE_LETTER},
	{0x00a78e, 0x00a78e, PG_U_LOWERCASE_LETTER},
	{0x00a78f, 0x00a78f, PG_U_OTHER_LETTER},
	{0x00a790, 0x00a790, PG_U_UPPERCASE_LETTER},
	{0x00a791, 0x00a791, PG_U_LOWERCASE_LETTER},
	{0x00a792, 0x00a792, PG_U_UPPERCASE_LETTER},
	{0x00a793, 0x00a795, PG_U_LOWERCASE_LETTER},
	{0x00a796, 0x00a796, PG_U_UPPERCASE_LETTER},
	{0x00a797, 0x00a797, PG_U_LOWERCASE_LETTER},
	{0x00a798, 0x00a798, PG_U_UPPERCASE_LETTER},
	{0x00a799, 0x00a799, PG_U_LOWERCASE_LETTER},
	{0x00a79a, 0x00a79a, PG_U_UPPERCASE_LETTER},
	{0x00a79b, 0x00a79b, PG_U_LOWERCASE_LETTER},
	{0x00a79c, 0x00a79c, PG_U_UPPERCASE_LETTER},
	{0x00a79d, 0x00a79d, PG_U_LOWERCASE_LETTER},
	{0x00a79e, 0x00a79e, PG_U_UPPERCASE_LETTER},
	{0x00a79f, 0x00a79f, PG_U_LOWERCASE_LETTER},
	{0x00a7a0, 0x00a7a0, PG_U_UPPERCASE_LETTER},
	{0x00a7a1, 0x00a7a1, PG_U_LOWERCASE_LETTER},
	{0x00a7a2, 0x00a7a2, PG_U_UPPERCASE_LETTER},
	{0x00a7a3, 0x00a7a3, PG_U_LOWERCASE_LETTER},
	{0x00a7a4, 0x00a7a4, PG_U_UPPERCASE_LETTER},
	{0x00a7a5, 0x00a7a5, PG_U_LOWERCASE_LETTER},
	{0x00a7a6, 0x00a7a6, PG_U_UPPERCASE_LETTER},
	{0x00a7a7, 0x00a7a7, PG_U_LOWERCASE_LETTER},
	{0x00a7a8, 0x00a7a8, PG_U_UPPERCASE_LETTER},
	{0x00a7a9, 0x00a7a9, PG_U_LOWERCASE_LETTER},
	{0x00a7aa, 0x00a7ae, PG_U_UPPERCASE_LETTER},
	{0x00a7af, 0x00a7af, PG_U_LOWERCASE_LETTER},
	{0x00a7b0, 0x00a7b4, PG_U_UPPERCASE_LETTER},
	{0x00a7b5, 0x00a7b5, PG_U_LOWERCASE_LETTER},
	{0x00a7b6, 0x00a7b6, PG_U_UPPERCASE_LETTER},
	{0x00a7b7, 0x00a7b7, PG_U_LOWERCASE_LETTER},
	{0x00a7b8, 0x00a7b8, PG_U_UPPERCASE_LETTER},
	{0x00a7b9, 0x00a7b9, PG_U_LOWERCASE_LETTER},
	{0x00a7ba, 0x00a7ba, PG_U_UPPERCASE_LETTER},
	{0x00a7bb, 0x00a7bb, PG_U_LOWERCASE_LETTER},
	{0x00a7bc, 0x00a7bc, PG_U_UPPERCASE_LETTER},
	{0x00a7bd, 0x00a7bd, PG_U_LOWERCASE_LETTER},
	{0x00a7be, 0x00a7be, PG_U_UPPERCASE_LETTER},
	{0x00a7bf, 0x00a7bf, PG_U_LOWERCASE_LETTER},
	{0x00a7c0, 0x00a7c0, PG_U_UPPERCASE_LETTER},
	{0x00a7c1, 0x00a7c1, PG_U_LOWERCASE_LETTER},
	{0x00a7c2, 0x00a7c2, PG_U_UPPERCASE_LETTER},
	{0x00a7c3, 0x00a7c3, PG_U_LOWERCASE_LETTER},
	{0x00a7c4, 0x00a7c7, PG_U_UPPERCASE_LETTER},
	{0x00a7c8, 0x00a7c8, PG_U_LOWERCASE_LETTER},
	{0x00a7c9, 0x00a7c9, PG_U_UPPERCASE_LETTER},
	{0x00a7ca, 0x00a7ca, PG_U_LOWERCASE_LETTER},
	{0x00a7d0, 0x00a7d0, PG_U_UPPERCASE_LETTER},
	{0x00a7d1, 0x00a7d1, PG_U_LOWERCASE_LETTER},
	{0x00a7d3, 0x00a7d3, PG_U_LOWERCASE_LETTER},
	{0x00a7d5, 0x00a7d5, PG_U_LOWERCASE_LETTER},
	{0x00a7d6, 0x00a7d6, PG_U_UPPERCASE_LETTER},
	{0x00a7d7, 0x00a7d7, PG_U_LOWERCASE_LETTER},
	{0x00a7d8, 0x00a7d8, PG_U_UPPERCASE_LETTER},
	{0x00a7d9, 0x00a7d9, PG_U_LOWERCASE_LETTER},
	{0x00a7f2, 0x00a7f4, PG_U_MODIFIER_LETTER},
	{0x00a7f5, 0x00a7f5, PG_U_UPPERCASE_LETTER},
	{0x00a7f6, 0x00a7f6, PG_U_LOWERCASE_LETTER},
	{0x00a7f7, 0x00a7f7, PG_U_OTHER_LETTER},
	{0x00a7f8, 0x00a7f9, PG_U_MODIFIER_LETTER},
	{0x00a7fa, 0x00a7fa, PG_U_LOWERCASE_LETTER},
	{0x00a7fb, 0x00a801, PG_U_OTHER_LETTER},
	{0x00a802, 0x00a802, PG_U_NONSPACING_MARK},
	{0x00a803, 0x00a805, PG_U_OTHER_LETTER},
	{0x00a806, 0x00a806, PG_U_NONSPACING_MARK},
	{0x00a807, 0x00a80a, PG_U_OTHER_LETTER},
	{0x00a80b, 0x00a80b, PG_U_NONSPACING_MARK},
	{0x00a80c, 0x00a822, PG_U_OTHER_LETTER},
	{0x00a823, 0x00a824, PG_U_SPACING_MARK},
	{0x00a825, 0x00a826, PG_U_NONSPACING_MARK},
	{0x00a827, 0x00a827, PG_U_SPACING_MARK},
	{0x00a828, 0x00a82b, PG_U_OTHER_SYMBOL},
	{0x00a82c, 0x00a82c, PG_U_NONSPACING_MARK},
	{0x00a830, 0x00a835, PG_U_OTHER_NUMBER},
	{0x00a836, 0x00a837, PG_U_OTHER_SYMBOL},
	{0x00a838, 0x00a838, PG_U_CURRENCY_SYMBOL},
	{0x00a839, 0x00a839, PG_U_OTHER_SYMBOL},
	{0x00a840, 0x00a873, PG_U_OTHER_LETTER},
	{0x00a874, 0x00a877, PG_U_OTHER_PUNCTUATION},
	{0x00a880, 0x00a881, PG_U_SPACING_MARK},
	{0x00a882, 0x00a8b3, PG_U_OTHER_LETTER},
	{0x00a8b4, 0x00a8c3, PG_U_SPACING_MARK},
	{0x00a8c4, 0x00a8c5, PG_U_NONSPACING_MARK},
	{0x00a8ce, 0x00a8cf, PG_U_OTHER_PUNCTUATION},
	{0x00a8d0, 0x00a8d9, PG_U_DECIMAL_NUMBER},
	{0x00a8e0, 0x00a8f1, PG_U_NONSPACING_MARK},
	{0x00a8f2, 0x00a8f7, PG_U_OTHER_LETTER},
	{0x00a8f8, 0x00a8fa, PG_U_OTHER_PUNCTUATION},
	{0x00a8fb, 0x00a8fb, PG_U_OTHER_LETTER},
	{0x00a8fc, 0x00a8fc, PG_U_OTHER_PUNCTUATION},
	{0x00a8fd, 0x00a8fe, PG_U_OTHER_LETTER},
	{0x00a8ff, 0x00a8ff, PG_U_NONSPACING_MARK},
	{0x00a900, 0x00a909, PG_U_DECIMAL_NUMBER},
	{0x00a90a, 0x00a925, PG_U_OTHER_LETTER},
	{0x00a926, 0x00a92d, PG_U_NONSPACING_MARK},
	{0x00a92e, 0x00a92f, PG_U_OTHER_PUNCTUATION},
	{0x00a930, 0x00a946, PG_U_OTHER_LETTER},
	{0x00a947, 0x00a951, PG_U_NONSPACING_MARK},
	{0x00a952, 0x00a953, PG_U_SPACING_MARK},
	{0x00a95f, 0x00a95f, PG_U_OTHER_PUNCTUATION},
	{0x00a960, 0x00a97c, PG_U_OTHER_LETTER},
	{0x00a980, 0x00a982, PG_U_NONSPACING_MARK},
	{0x00a983, 0x00a983, PG_U_SPACING_MARK},
	{0x00a984, 0x00a9b2, PG_U_OTHER_LETTER},
	{0x00a9b3, 0x00a9b3, PG_U_NONSPACING_MARK},
	{0x00a9b4, 0x00a9b5, PG_U_SPACING_MARK},
	{0x00a9b6, 0x00a9b9, PG_U_NONSPACING_MARK},
	{0x00a9ba, 0x00a9bb, PG_U_SPACING_MARK},
	{0x00a9bc, 0x00a9bd, PG_U_NONSPACING_MARK},
	{0x00a9be, 0x00a9c0, PG_U_SPACING_MARK},
	{0x00a9c1, 0x00a9cd, PG_U_OTHER_PUNCTUATION},
	{0x00a9cf, 0x00a9cf, PG_U_MODIFIER_LETTER},
	{0x00a9d0, 0x00a9d9, PG_U_DECIMAL_NUMBER},
	{0x00a9de, 0x00a9df, PG_U_OTHER_PUNCTUATION},
	{0x00a9e0, 0x00a9e4, PG_U_OTHER_LETTER},
	{0x00a9e5, 0x00a9e5, PG_U_NONSPACING_MARK},
	{0x00a9e6, 0x00a9e6, PG_U_MODIFIER_LETTER},
	{0x00a9e7, 0x00a9ef, PG_U_OTHER_LETTER},
	{0x00a9f0, 0x00a9f9, PG_U_DECIMAL_NUMBER},
	{0x00a9fa, 0x00a9fe, PG_U_OTHER_LETTER},
	{0x00aa00, 0x00aa28, PG_U_OTHER_LETTER},
	{0x00aa29, 0x00aa2e, PG_U_NONSPACING_MARK},
	{0x00aa2f, 0x00aa30, PG_U_SPACING_MARK},
	{0x00aa31, 0x00aa32, PG_U_NONSPACING_MARK},
	{0x00aa33, 0x00aa34, PG_U_SPACING_MARK},
	{0x00aa35, 0x00aa36, PG_U_NONSPACING_MARK},
	{0x00aa40, 0x00aa42, PG_U_OTHER_LETTER},
	{0x00aa43, 0x00aa43, PG_U_NONSPACING_MARK},
	{0x00aa44, 0x00aa4b, PG_U_OTHER_LETTER},
	{0x00aa4c, 0x00aa4c, PG_U_NONSPACING_MARK},
	{0x00aa4d, 0x00aa4d, PG_U_SPACING_MARK},
	{0x00aa50, 0x00aa59, PG_U_DECIMAL_NUMBER},
	{0x00aa5c, 0x00aa5f, PG_U_OTHER_PUNCTUATION},
	{0x00aa60, 0x00aa6f, PG_U_OTHER_LETTER},
	{0x00aa70, 0x00aa70, PG_U_MODIFIER_LETTER},
	{0x00aa71, 0x00aa76, PG_U_OTHER_LETTER},
	{0x00aa77, 0x00aa79, PG_U_OTHER_SYMBOL},
	{0x00aa7a, 0x00aa7a, PG_U_OTHER_LETTER},
	{0x00aa7b, 0x00aa7b, PG_U_SPACING_MARK},
	{0x00aa7c, 0x00aa7c, PG_U_NONSPACING_MARK},
	{0x00aa7d, 0x00aa7d, PG_U_SPACING_MARK},
	{0x00aa7e, 0x00aaaf, PG_U_OTHER_LETTER},
	{0x00aab0, 0x00aab0, PG_U_NONSPACING_MARK},
	{0x00aab1, 0x00aab1, PG_U_OTHER_LETTER},
	{0x00aab2, 0x00aab4, PG_U_NONSPACING_MARK},
	{0x00aab5, 0x00aab6, PG_U_OTHER_LETTER},
	{0x00aab7, 0x00aab8, PG_U_NONSPACING_MARK},
	{0x00aab9, 0x00aabd, PG_U_OTHER_LETTER},
	{0x00aabe, 0x00aabf, PG_U_NONSPACING_MARK},
	{0x00aac0, 0x00aac0, PG_U_OTHER_LETTER},
	{0x00aac1, 0x00aac1, PG_U_NONSPACING_MARK},
	{0x00aac2, 0x00aac2, PG_U_OTHER_LETTER},
	{0x00aadb, 0x00aadc, PG_U_OTHER_LETTER},
	{0x00aadd, 0x00aadd, PG_U_MODIFIER_LETTER},
	{0x00aade, 0x00aadf, PG_U_OTHER_PUNCTUATION},
	{0x00aae0, 0x00aaea, PG_U_OTHER_LETTER},
	{0x00aaeb, 0x00aaeb, PG_U_SPACING_MARK},
	{0x00aaec, 0x00aaed, PG_U_NONSPACING_MARK},
	{0x00aaee, 0x00aaef, PG_U_SPACING_MARK},
	{0x00aaf0, 0x00aaf1, PG_U_OTHER_PUNCTUATION},
	{0x00aaf2, 0x00aaf2, PG_U_OTHER_LETTER},
	{0x00aaf3, 0x00aaf4, PG_U_MODIFIER_LETTER},
	{0x00aaf5, 0x00aaf5, PG_U_SPACING_MARK},
	{0x00aaf6, 0x00aaf6, PG_U_NONSPACING_MARK},
	{0x00ab01, 0x00ab06, PG_U_OTHER_LETTER},
	{0x00ab09, 0x00ab0e, PG_U_OTHER_LETTER},
	{0x00ab11, 0x00ab16, PG_U_OTHER_LETTER},
	{0x00ab20, 0x00ab26, PG_U_OTHER_LETTER},
	{0x00ab28, 0x00ab2e, PG_U_OTHER_LETTER},
	{0x00ab30, 0x00ab5a, PG_U_LOWERCASE_LETTER},
	{0x00ab5b, 0x00ab5b, PG_U_MODIFIER_SYMBOL},
	{0x00ab5c, 0x00ab5f, PG_U_MODIFIER_LETTER},
	{0x00ab60, 0x00ab68, PG_U_LOWERCASE_LETTER},
	{0x00ab69, 0x00ab69, PG_U_MODIFIER_LETTER},
	{0x00ab6a, 0x00ab6b, PG_U_MODIFIER_SYMBOL},
	{0x00ab70, 0x00abbf, PG_U_LOWERCASE_LETTER},
	{0x00abc0, 0x00abe2, PG_U_OTHER_LETTER},
	{0x00abe3, 0x00abe4, PG_U_SPACING_MARK},
	{0x00abe5, 0x00abe5, PG_U_NONSPACING_MARK},
	{0x00abe6, 0x00abe7, PG_U_SPACING_MARK},
	{0x00abe8, 0x00abe8, PG_U_NONSPACING_MARK},
	{0x00abe9, 0x00abea, PG_U_SPACING_MARK},
	{0x00abeb, 0x00abeb, PG_U_OTHER_PUNCTUATION},
	{0x00abec, 0x00abec, PG_U_SPACING_MARK},
	{0x00abed, 0x00abed, PG_U_NONSPACING_MARK},
	{0x00abf0, 0x00abf9, PG_U_DECIMAL_NUMBER},
	{0x00ac00, 0x00d7a3, PG_U_OTHER_LETTER},
	{0x00d7b0, 0x00d7c6, PG_U_OTHER_LETTER},
	{0x00d7cb, 0x00d7fb, PG_U_OTHER_LETTER},
	{0x00d800, 0x00dfff, PG_U_SURROGATE},
	{0x00e000, 0x00f8ff, PG_U_PRIVATE_USE},
	{0x00f900, 0x00fa6d, PG_U_OTHER_LETTER},
	{0x00fa70, 0x00fad9, PG_U_OTHER_LETTER},
	{0x00fb00, 0x00fb06, PG_U_LOWERCASE_LETTER},
	{0x00fb13, 0x00fb17, PG_U_LOWERCASE_LETTER},
	{0x00fb1d, 0x00fb1d, PG_U_OTHER_LETTER},
	{0x00fb1e, 0x00fb1e, PG_U_NONSPACING_MARK},
	{0x00fb1f, 0x00fb28, PG_U_OTHER_LETTER},
	{0x00fb29, 0x00fb29, PG_U_MATH_SYMBOL},
	{0x00fb2a, 0x00fb36, PG_U_OTHER_LETTER},
	{0x00fb38, 0x00fb3c, PG_U_OTHER_LETTER},
	{0x00fb3e, 0x00fb3e, PG_U_OTHER_LETTER},
	{0x00fb40, 0x00fb41, PG_U_OTHER_LETTER},
	{0x00fb43, 0x00fb44, PG_U_OTHER_LETTER},
	{0x00fb46, 0x00fbb1, PG_U_OTHER_LETTER},
	{0x00fbb2, 0x00fbc2, PG_U_MODIFIER_SYMBOL},
	{0x00fbd3, 0x00fd3d, PG_U_OTHER_LETTER},
	{0x00fd3e, 0x00fd3e, PG_U_CLOSE_PUNCTUATION},
	{0x00fd3f, 0x00fd3f, PG_U_OPEN_PUNCTUATION},
	{0x00fd40, 0x00fd4f, PG_U_OTHER_SYMBOL},
	{0x00fd50, 0x00fd8f, PG_U_OTHER_LETTER},
	{0x00fd92, 0x00fdc7, PG_U_OTHER_LETTER},
	{0x00fdcf, 0x00fdcf, PG_U_OTHER_SYMBOL},
	{0x00fdf0, 0x00fdfb, PG_U_OTHER_LETTER},
	{0x00fdfc, 0x00fdfc, PG_U_CURRENCY_SYMBOL},
	{0x00fdfd, 0x00fdff, PG_U_OTHER_SYMBOL},
	{0x00fe00, 0x00fe0f, PG_U_NONSPACING_MARK},
	{0x00fe10, 0x00fe16, PG_U_OTHER_PUNCTUATION},
	{0x00fe17, 0x00fe17, PG_U_OPEN_PUNCTUATION},
	{0x00fe18, 0x00fe18, PG_U_CLOSE_PUNCTUATION},
	{0x00fe19, 0x00fe19, PG_U_OTHER_PUNCTUATION},
	{0x00fe20, 0x00fe2f, PG_U_NONSPACING_MARK},
	{0x00fe30, 0x00fe30, PG_U_OTHER_PUNCTUATION},
	{0x00fe31, 0x00fe32, PG_U_DASH_PUNCTUATION},
	{0x00fe33, 0x00fe34, PG_U_CONNECTOR_PUNCTUATION},
	{0x00fe35, 0x00fe35, PG_U_OPEN_PUNCTUATION},
	{0x00fe36, 0x00fe36, PG_U_CLOSE_PUNCTUATION},
	{0x00fe37, 0x00fe37, PG_U_OPEN_PUNCTUATION},
	{0x00fe38, 0x00fe38, PG_U_CLOSE_PUNCTUATION},
	{0x00fe39, 0x00fe39, PG_U_OPEN_PUNCTUATION},
	{0x00fe3a, 0x00fe3a, PG_U_CLOSE_PUNCTUATION},
	{0x00fe3b, 0x00fe3b, PG_U_OPEN_PUNCTUATION},
	{0x00fe3c, 0x00fe3c, PG_U_CLOSE_PUNCTUATION},
	{0x00fe3d, 0x00fe3d, PG_U_OPEN_PUNCTUATION},
	{0x00fe3e, 0x00fe3e, PG_U_CLOSE_PUNCTUATION},
	{0x00fe3f, 0x00fe3f, PG_U_OPEN_PUNCTUATION},
	{0x00fe40, 0x00fe40, PG_U_CLOSE_PUNCTUATION},
	{0x00fe41, 0x00fe41, PG_U_OPEN_PUNCTUATION},
	{0x00fe42, 0x00fe42, PG_U_CLOSE_PUNCTUATION},
	{0x00fe43, 0x00fe43, PG_U_OPEN_PUNCTUATION},
	{0x00fe44, 0x00fe44, PG_U_CLOSE_PUNCTUATION},
	{0x00fe45, 0x00fe46, PG_U_OTHER_PUNCTUATION},
	{0x00fe47, 0x00fe47, PG_U_OPEN_PUNCTUATION},
	{0x00fe48, 0x00fe48, PG_U_CLOSE_PUNCTUATION},
	{0x00fe49, 0x00fe4c, PG_U_OTHER_PUNCTUATION},
	{0x00fe4d, 0x00fe4f, PG_U_CONNECTOR_PUNCTUATION},
	{0x00fe50, 0x00fe52, PG_U_OTHER_PUNCTUATION},
	{0x00fe54, 0x00fe57, PG_U_OTHER_PUNCTUATION},
	{0x00fe58, 0x00fe58, PG_U_DASH_PUNCTUATION},
	{0x00fe59, 0x00fe59, PG_U_OPEN_PUNCTUATION},
	{0x00fe5a, 0x00fe5a, PG_U_CLOSE_PUNCTUATION},
	{0x00fe5b, 0x00fe5b, PG_U_OPEN_PUNCTUATION},
	{0x00fe5c, 0x00fe5c, PG_U_CLOSE_PUNCTUATION},
	{0x00fe5d, 0x00fe5d, PG_U_OPEN_PUNCTUATION},
	{0x00fe5e, 0x00fe5e, PG_U_CLOSE_PUNCTUATION},
	{0x00fe5f, 0x00fe61, PG_U_OTHER_PUNCTUATION},
	{0x00fe62, 0x00fe62, PG_U_MATH_SYMBOL},
	{0x00fe63, 0x00fe63, PG_U_DASH_PUNCTUATION},
	{0x00fe64, 0x00fe66, PG_U_MATH_SYMBOL},
	{0x00fe68, 0x00fe68, PG_U_OTHER_PUNCTUATION},
	{0x00fe69, 0x00fe69, PG_U_CURRENCY_SYMBOL},
	{0x00fe6a, 0x00fe6b, PG_U_OTHER_PUNCTUATION},
	{0x00fe70, 0x00fe74, PG_U_OTHER_LETTER},
	{0x00fe76, 0x00fefc, PG_U_OTHER_LETTER},
	{0x00feff, 0x00feff, PG_U_FORMAT},
	{0x00ff01, 0x00ff03, PG_U_OTHER_PUNCTUATION},
	{0x00ff04, 0x00ff04, PG_U_CURRENCY_SYMBOL},
	{0x00ff05, 0x00ff07, PG_U_OTHER_PUNCTUATION},
	{0x00ff08, 0x00ff08, PG_U_OPEN_PUNCTUATION},
	{0x00ff09, 0x00ff09, PG_U_CLOSE_PUNCTUATION},
	{0x00ff0a, 0x00ff0a, PG_U_OTHER_PUNCTUATION},
	{0x00ff0b, 0x00ff0b, PG_U_MATH_SYMBOL},
	{0x00ff0c, 0x00ff0c, PG_U_OTHER_PUNCTUATION},
	{0x00ff0d, 0x00ff0d, PG_U_DASH_PUNCTUATION},
	{0x00ff0e, 0x00ff0f, PG_U_OTHER_PUNCTUATION},
	{0x00ff10, 0x00ff19, PG_U_DECIMAL_NUMBER},
	{0x00ff1a, 0x00ff1b, PG_U_OTHER_PUNCTUATION},
	{0x00ff1c, 0x00ff1e, PG_U_MATH_SYMBOL},
	{0x00ff1f, 0x00ff20, PG_U_OTHER_PUNCTUATION},
	{0x00ff21, 0x00ff3a, PG_U_UPPERCASE_LETTER},
	{0x00ff3b, 0x00ff3b, PG_U_OPEN_PUNCTUATION},
	{0x00ff3c, 0x00ff3c, PG_U_OTHER_PUNCTUATION},
	{0x00ff3d, 0x00ff3d, PG_U_CLOSE_PUNCTUATION},
	{0x00ff3e, 0x00ff3e, PG_U_MODIFIER_SYMBOL},
	{0x00ff3f, 0x00ff3f, PG_U_CONNECTOR_PUNCTUATION},
	{0x00ff40, 0x00ff40, PG_U_MODIFIER_SYMBOL},
	{0x00ff41, 0x00ff5a, PG_U_LOWERCASE_LETTER},
	{0x00ff5b, 0x00ff5b, PG_U_OPEN_PUNCTUATION},
	{0x00ff5c, 0x00ff5c, PG_U_MATH_SYMBOL},
	{0x00ff5d, 0x00ff5d, PG_U_CLOSE_PUNCTUATION},
	{0x00ff5e, 0x00ff5e, PG_U_MATH_SYMBOL},
	{0x00ff5f, 0x00ff5f, PG_U_OPEN_PUNCTUATION},
	{0x00ff60, 0x00ff60, PG_U_CLOSE_PUNCTUATION},
	{0x00ff61, 0x00ff61, PG_U_OTHER_PUNCTUATION},
	{0x00ff62, 0x00ff62, PG_U_OPEN_PUNCTUATION},
	{0x00ff63, 0x00ff63, PG_U_CLOSE_PUNCTUATION},
	{0x00ff64, 0x00ff65, PG_U_OTHER_PUNCTUATION},
	{0x00ff66, 0x00ff6f, PG_U_OTHER_LETTER},
	{0x00ff70, 0x00ff70, PG_U_MODIFIER_LETTER},
	{0x00ff71, 0x00ff9d, PG_U_OTHER_LETTER},
	{0x00ff9e, 0x00ff9f, PG_U_MODIFIER_LETTER},
	{0x00ffa0, 0x00ffbe, PG_U_OTHER_LETTER},
	{0x00ffc2, 0x00ffc7, PG_U_OTHER_LETTER},
	{0x00ffca, 0x00ffcf, PG_U_OTHER_LETTER},
	{0x00ffd2, 0x00ffd7, PG_U_OTHER_LETTER},
	{0x00ffda, 0x00ffdc, PG_U_OTHER_LETTER},
	{0x00ffe0, 0x00ffe1, PG_U_CURRENCY_SYMBOL},
	{0x00ffe2, 0x00ffe2, PG_U_MATH_SYMBOL},
	{0x00ffe3, 0x00ffe3, PG_U_MODIFIER_SYMBOL},
	{0x00ffe4, 0x00ffe4, PG_U_OTHER_SYMBOL},
	{0x00ffe5, 0x00ffe6, PG_U_CURRENCY_SYMBOL},
	{0x00ffe8, 0x00ffe8, PG_U_OTHER_SYMBOL},
	{0x00ffe9, 0x00ffec, PG_U_MATH_SYMBOL},
	{0x00ffed, 0x00ffee, PG_U_OTHER_SYMBOL},
	{0x00fff9, 0x00fffb, PG_U_FORMAT},
	{0x00fffc, 0x00fffd, PG_U_OTHER_SYMBOL},
	{0x010000, 0x01000b, PG_U_OTHER_LETTER},
	{0x01000d, 0x010026, PG_U_OTHER_LETTER},
	{0x010028, 0x01003a, PG_U_OTHER_LETTER},
	{0x01003c, 0x01003d, PG_U_OTHER_LETTER},
	{0x01003f, 0x01004d, PG_U_OTHER_LETTER},
	{0x010050, 0x01005d, PG_U_OTHER_LETTER},
	{0x010080, 0x0100fa, PG_U_OTHER_LETTER},
	{0x010100, 0x010102, PG_U_OTHER_PUNCTUATION},
	{0x010107, 0x010133, PG_U_OTHER_NUMBER},
	{0x010137, 0x01013f, PG_U_OTHER_SYMBOL},
	{0x010140, 0x010174, PG_U_LETTER_NUMBER},
	{0x010175, 0x010178, PG_U_OTHER_NUMBER},
	{0x010179, 0x010189, PG_U_OTHER_SYMBOL},
	{0x01018a, 0x01018b, PG_U_OTHER_NUMBER},
	{0x01018c, 0x01018e, PG_U_OTHER_SYMBOL},
	{0x010190, 0x01019c, PG_U_OTHER_SYMBOL},
	{0x0101a0, 0x0101a0, PG_U_OTHER_SYMBOL},
	{0x0101d0, 0x0101fc, PG_U_OTHER_SYMBOL},
	{0x0101fd, 0x0101fd, PG_U_NONSPACING_MARK},
	{0x010280, 0x01029c, PG_U_OTHER_LETTER},
	{0x0102a0, 0x0102d0, PG_U_OTHER_LETTER},
	{0x0102e0, 0x0102e0, PG_U_NONSPACING_MARK},
	{0x0102e1, 0x0102fb, PG_U_OTHER_NUMBER},
	{0x010300, 0x01031f, PG_U_OTHER_LETTER},
	{0x010320, 0x010323, PG_U_OTHER_NUMBER},
	{0x01032d, 0x010340, PG_U_OTHER_LETTER},
	{0x010341, 0x010341, PG_U_LETTER_NUMBER},
	{0x010342, 0x010349, PG_U_OTHER_LETTER},
	{0x01034a, 0x01034a, PG_U_LETTER_NUMBER},
	{0x010350, 0x010375, PG_U_OTHER_LETTER},
	{0x010376, 0x01037a, PG_U_NONSPACING_MARK},
	{0x010380, 0x01039d, PG_U_OTHER_LETTER},
	{0x01039f, 0x01039f, PG_U_OTHER_PUNCTUATION},
	{0x0103a0, 0x0103c3, PG_U_OTHER_LETTER},
	{0x0103c8, 0x0103cf, PG_U_OTHER_LETTER},
	{0x0103d0, 0x0103d0, PG_U_OTHER_PUNCTUATION},
	{0x0103d1, 0x0103d5, PG_U_LETTER_NUMBER},
	{0x010400, 0x010427, PG_U_UPPERCASE_LETTER},
	{0x010428, 0x01044f, PG_U_LOWERCASE_LETTER},
	{0x010450, 0x01049d, PG_U_OTHER_LETTER},
	{0x0104a0, 0x0104a9, PG_U_DECIMAL_NUMBER},
	{0x0104b0, 0x0104d3, PG_U_UPPERCASE_LETTER},
	{0x0104d8, 0x0104fb, PG_U_LOWERCASE_LETTER},
	{0x010500, 0x010527, PG_U_OTHER_LETTER},
	{0x010530, 0x010563, PG_U_OTHER_LETTER},
	{0x01056f, 0x01056f, PG_U_OTHER_PUNCTUATION},
	{0x010570, 0x01057a, PG_U_UPPERCASE_LETTER},
	{0x01057c, 0x01058a, PG_U_UPPERCASE_LETTER},
	{0x01058c, 0x010592, PG_U_UPPERCASE_LETTER},
	{0x010594, 0x010595, PG_U_UPPERCASE_LETTER},
	{0x010597, 0x0105a1, PG_U_LOWERCASE_LETTER},
	{0x0105a3, 0x0105b1, PG_U_LOWERCASE_LETTER},
	{0x0105b3, 0x0105b9, PG_U_LOWERCASE_LETTER},
	{0x0105bb, 0x0105bc, PG_U_LOWERCASE_LETTER},
	{0x010600, 0x010736, PG_U_OTHER_LETTER},
	{0x010740, 0x010755, PG_U_OTHER_LETTER},
	{0x010760, 0x010767, PG_U_OTHER_LETTER},
	{0x010780, 0x010785, PG_U_MODIFIER_LETTER},
	{0x010787, 0x0107b0, PG_U_MODIFIER_LETTER},
	{0x0107b2, 0x0107ba, PG_U_MODIFIER_LETTER},
	{0x010800, 0x010805, PG_U_OTHER_LETTER},
	{0x010808, 0x010808, PG_U_OTHER_LETTER},
	{0x01080a, 0x010835, PG_U_OTHER_LETTER},
	{0x010837, 0x010838, PG_U_OTHER_LETTER},
	{0x01083c, 0x01083c, PG_U_OTHER_LETTER},
	{0x01083f, 0x010855, PG_U_OTHER_LETTER},
	{0x010857, 0x010857, PG_U_OTHER_PUNCTUATION},
	{0x010858, 0x01085f, PG_U_OTHER_NUMBER},
	{0x010860, 0x010876, PG_U_OTHER_LETTER},
	{0x010877, 0x010878, PG_U_OTHER_SYMBOL},
	{0x010879, 0x01087f, PG_U_OTHER_NUMBER},
	{0x010880, 0x01089e, PG_U_OTHER_LETTER},
	{0x0108a7, 0x0108af, PG_U_OTHER_NUMBER},
	{0x0108e0, 0x0108f2, PG_U_OTHER_LETTER},
	{0x0108f4, 0x0108f5, PG_U_OTHER_LETTER},
	{0x0108fb, 0x0108ff, PG_U_OTHER_NUMBER},
	{0x010900, 0x010915, PG_U_OTHER_LETTER},
	{0x010916, 0x01091b, PG_U_OTHER_NUMBER},
	{0x01091f, 0x01091f, PG_U_OTHER_PUNCTUATION},
	{0x010920, 0x010939, PG_U_OTHER_LETTER},
	{0x01093f, 0x01093f, PG_U_OTHER_PUNCTUATION},
	{0x010980, 0x0109b7, PG_U_OTHER_LETTER},
	{0x0109bc, 0x0109bd, PG_U_OTHER_NUMBER},
	{0x0109be, 0x0109bf, PG_U_OTHER_LETTER},
	{0x0109c0, 0x0109cf, PG_U_OTHER_NUMBER},
	{0x0109d2, 0x0109ff, PG_U_OTHER_NUMBER},
	{0x010a00, 0x010a00, PG_U_OTHER_LETTER},
	{0x010a01, 0x010a03, PG_U_NONSPACING_MARK},
	{0x010a05, 0x010a06, PG_U_NONSPACING_MARK},
	{0x010a0c, 0x010a0f, PG_U_NONSPACING_MARK},
	{0x010a10, 0x010a13, PG_U_OTHER_LETTER},
	{0x010a15, 0x010a17, PG_U_OTHER_LETTER},
	{0x010a19, 0x010a35, PG_U_OTHER_LETTER},
	{0x010a38, 0x010a3a, PG_U_NONSPACING_MARK},
	{0x010a3f, 0x010a3f, PG_U_NONSPACING_MARK},
	{0x010a40, 0x010a48, PG_U_OTHER_NUMBER},
	{0x010a50, 0x010a58, PG_U_OTHER_PUNCTUATION},
	{0x010a60, 0x010a7c, PG_U_OTHER_LETTER},
	{0x010a7d, 0x010a7e, PG_U_OTHER_NUMBER},
	{0x010a7f, 0x010a7f, PG_U_OTHER_PUNCTUATION},
	{0x010a80, 0x010a9c, PG_U_OTHER_LETTER},
	{0x010a9d, 0x010a9f, PG_U_OTHER_NUMBER},
	{0x010ac0, 0x010ac7, PG_U_OTHER_LETTER},
	{0x010ac8, 0x010ac8, PG_U_OTHER_SYMBOL},
	{0x010ac9, 0x010ae4, PG_U_OTHER_LETTER},
	{0x010ae5, 0x010ae6, PG_U_NONSPACING_MARK},
	{0x010aeb, 0x010aef, PG_U_OTHER_NUMBER},
	{0x010af0, 0x010af6, PG_U_OTHER_PUNCTUATION},
	{0x010b00, 0x010b35, PG_U_OTHER_LETTER},
	{0x010b39, 0x010b3f, PG_U_OTHER_PUNCTUATION},
	{0x010b40, 0x010b55, PG_U_OTHER_LETTER},
	{0x010b58, 0x010b5f, PG_U_OTHER_NUMBER},
	{0x010b60, 0x010b72, PG_U_OTHER_LETTER},
	{0x010b78, 0x010b7f, PG_U_OTHER_NUMBER},
	{0x010b80, 0x010b91, PG_U_OTHER_LETTER},
	{0x010b99, 0x010b9c, PG_U_OTHER_PUNCTUATION},
	{0x010ba9, 0x010baf, PG_U_OTHER_NUMBER},
	{0x010c00, 0x010c48, PG_U_OTHER_LETTER},
	{0x010c80, 0x010cb2, PG_U_UPPERCASE_LETTER},
	{0x010cc0, 0x010cf2, PG_U_LOWERCASE_LETTER},
	{0x010cfa, 0x010cff, PG_U_OTHER_NUMBER},
	{0x010d00, 0x010d23, PG_U_OTHER_LETTER},
	{0x010d24, 0x010d27, PG_U_NONSPACING_MARK},
	{0x010d30, 0x010d39, PG_U_DECIMAL_NUMBER},
	{0x010e60, 0x010e7e, PG_U_OTHER_NUMBER},
	{0x010e80, 0x010ea9, PG_U_OTHER_LETTER},
	{0x010eab, 0x010eac, PG_U_NONSPACING_MARK},
	{0x010ead, 0x010ead, PG_U_DASH_PUNCTUATION},
	{0x010eb0, 0x010eb1, PG_U_OTHER_LETTER},
	{0x010efd, 0x010eff, PG_U_NONSPACING_MARK},
	{0x010f00, 0x010f1c, PG_U_OTHER_LETTER},
	{0x010f1d, 0x010f26, PG_U_OTHER_NUMBER},
	{0x010f27, 0x010f27, PG_U_OTHER_LETTER},
	{0x010f30, 0x010f45, PG_U_OTHER_LETTER},
	{0x010f46, 0x010f50, PG_U_NONSPACING_MARK},
	{0x010f51, 0x010f54, PG_U_OTHER_NUMBER},
	{0x010f55, 0x010f59, PG_U_OTHER_PUNCTUATION},
	{0x010f70, 0x010f81, PG_U_OTHER_LETTER},
	{0x010f82, 0x010f85, PG_U_NONSPACING_MARK},
	{0x010f86, 0x010f89, PG_U_OTHER_PUNCTUATION},
	{0x010fb0, 0x010fc4, PG_U_OTHER_LETTER},
	{0x010fc5, 0x010fcb, PG_U_OTHER_NUMBER},
	{0x010fe0, 0x010ff6, PG_U_OTHER_LETTER},
	{0x011000, 0x011000, PG_U_SPACING_MARK},
	{0x011001, 0x011001, PG_U_NONSPACING_MARK},
	{0x011002, 0x011002, PG_U_SPACING_MARK},
	{0x011003, 0x011037, PG_U_OTHER_LETTER},
	{0x011038, 0x011046, PG_U_NONSPACING_MARK},
	{0x011047, 0x01104d, PG_U_OTHER_PUNCTUATION},
	{0x011052, 0x011065, PG_U_OTHER_NUMBER},
	{0x011066, 0x01106f, PG_U_DECIMAL_NUMBER},
	{0x011070, 0x011070, PG_U_NONSPACING_MARK},
	{0x011071, 0x011072, PG_U_OTHER_LETTER},
	{0x011073, 0x011074, PG_U_NONSPACING_MARK},
	{0x011075, 0x011075, PG_U_OTHER_LETTER},
	{0x01107f, 0x011081, PG_U_NONSPACING_MARK},
	{0x011082, 0x011082, PG_U_SPACING_MARK},
	{0x011083, 0x0110af, PG_U_OTHER_LETTER},
	{0x0110b0, 0x0110b2, PG_U_SPACING_MARK},
	{0x0110b3, 0x0110b6, PG_U_NONSPACING_MARK},
	{0x0110b7, 0x0110b8, PG_U_SPACING_MARK},
	{0x0110b9, 0x0110ba, PG_U_NONSPACING_MARK},
	{0x0110bb, 0x0110bc, PG_U_OTHER_PUNCTUATION},
	{0x0110bd, 0x0110bd, PG_U_FORMAT},
	{0x0110be, 0x0110c1, PG_U_OTHER_PUNCTUATION},
	{0x0110c2, 0x0110c2, PG_U_NONSPACING_MARK},
	{0x0110cd, 0x0110cd, PG_U_FORMAT},
	{0x0110d0, 0x0110e8, PG_U_OTHER_LETTER},
	{0x0110f0, 0x0110f9, PG_U_DECIMAL_NUMBER},
	{0x011100, 0x011102, PG_U_NONSPACING_MARK},
	{0x011103, 0x011126, PG_U_OTHER_LETTER},
	{0x011127, 0x01112b, PG_U_NONSPACING_MARK},
	{0x01112c, 0x01112c, PG_U_SPACING_MARK},
	{0x01112d, 0x011134, PG_U_NONSPACING_MARK},
	{0x011136, 0x01113f, PG_U_DECIMAL_NUMBER},
	{0x011140, 0x011143, PG_U_OTHER_PUNCTUATION},
	{0x011144, 0x011144, PG_U_OTHER_LETTER},
	{0x011145, 0x011146, PG_U_SPACING_MARK},
	{0x011147, 0x011147, PG_U_OTHER_LETTER},
	{0x011150, 0x011172, PG_U_OTHER_LETTER},
	{0x011173, 0x011173, PG_U_NONSPACING_MARK},
	{0x011174, 0x011175, PG_U_OTHER_PUNCTUATION},
	{0x011176, 0x011176, PG_U_OTHER_LETTER},
	{0x011180, 0x011181, PG_U_NONSPACING_MARK},
	{0x011182, 0x011182, PG_U_SPACING_MARK},
	{0x011183, 0x0111b2, PG_U_OTHER_LETTER},
	{0x0111b3, 0x0111b5, PG_U_SPACING_MARK},
	{0x0111b6, 0x0111be, PG_U_NONSPACING_MARK},
	{0x0111bf, 0x0111c0, PG_U_SPACING_MARK},
	{0x0111c1, 0x0111c4, PG_U_OTHER_LETTER},
	{0x0111c5, 0x0111c8, PG_U_OTHER_PUNCTUATION},
	{0x0111c9, 0x0111cc, PG_U_NONSPACING_MARK},
	{0x0111cd, 0x0111cd, PG_U_OTHER_PUNCTUATION},
	{0x0111ce, 0x0111ce, PG_U_SPACING_MARK},
	{0x0111cf, 0x0111cf, PG_U_NONSPACING_MARK},
	{0x0111d0, 0x0111d9, PG_U_DECIMAL_NUMBER},
	{0x0111da, 0x0111da, PG_U_OTHER_LETTER},
	{0x0111db, 0x0111db, PG_U_OTHER_PUNCTUATION},
	{0x0111dc, 0x0111dc, PG_U_OTHER_LETTER},
	{0x0111dd, 0x0111df, PG_U_OTHER_PUNCTUATION},
	{0x0111e1, 0x0111f4, PG_U_OTHER_NUMBER},
	{0x011200, 0x011211, PG_U_OTHER_LETTER},
	{0x011213, 0x01122b, PG_U_OTHER_LETTER},
	{0x01122c, 0x01122e, PG_U_SPACING_MARK},
	{0x01122f, 0x011231, PG_U_NONSPACING_MARK},
	{0x011232, 0x011233, PG_U_SPACING_MARK},
	{0x011234, 0x011234, PG_U_NONSPACING_MARK},
	{0x011235, 0x011235, PG_U_SPACING_MARK},
	{0x011236, 0x011237, PG_U_NONSPACING_MARK},
	{0x011238, 0x01123d, PG_U_OTHER_PUNCTUATION},
	{0x01123e, 0x01123e, PG_U_NONSPACING_MARK},
	{0x01123f, 0x011240, PG_U_OTHER_LETTER},
	{0x011241, 0x011241, PG_U_NONSPACING_MARK},
	{0x011280, 0x011286, PG_U_OTHER_LETTER},
	{0x011288, 0x011288, PG_U_OTHER_LETTER},
	{0x01128a, 0x01128d, PG_U_OTHER_LETTER},
	{0x01128f, 0x01129d, PG_U_OTHER_LETTER},
	{0x01129f, 0x0112a8, PG_U_OTHER_LETTER},
	{0x0112a9, 0x0112a9, PG_U_OTHER_PUNCTUATION},
	{0x0112b0, 0x0112de, PG_U_OTHER_LETTER},
	{0x0112df, 0x0112df, PG_U_NONSPACING_MARK},
	{0x0112e0, 0x0112e2, PG_U_SPACING_MARK},
	{0x0112e3, 0x0112ea, PG_U_NONSPACING_MARK},
	{0x0112f0, 0x0112f9, PG_U_DECIMAL_NUMBER},
	{0x011300, 0x011301, PG_U_NONSPACING_MARK},
	{0x011302, 0x011303, PG_U_SPACING_MARK},
	{0x011305, 0x01130c, PG_U_OTHER_LETTER},
	{0x01130f, 0x011310, PG_U_OTHER_LETTER},
	{0x011313, 0x011328, PG_U_OTHER_LETTER},
	{0x01132a, 0x011330, PG_U_OTHER_LETTER},
	{0x011332, 0x011333, PG_U_OTHER_LETTER},
	{0x011335, 0x011339, PG_U_OTHER_LETTER},
	{0x01133b, 0x01133c, PG_U_NONSPACING_MARK},
	{0x01133d, 0x01133d, PG_U_OTHER_LETTER},
	{0x01133e, 0x01133f, PG_U_SPACING_MARK},
	{0x011340, 0x011340, PG_U_NONSPACING_MARK},
	{0x011341, 0x011344, PG_U_SPACING_MARK},
	{0x011347, 0x011348, PG_U_SPACING_MARK},
	{0x01134b, 0x01134d, PG_U_SPACING_MARK},
	{0x011350, 0x011350, PG_U_OTHER_LETTER},
	{0x011357, 0x011357, PG_U_SPACING_MARK},
	{0x01135d, 0x011361, PG_U_OTHER_LETTER},
	{0x011362, 0x011363, PG_U_SPACING_MARK},
	{0x011366, 0x01136c, PG_U_NONSPACING_MARK},
	{0x011370, 0x011374, PG_U_NONSPACING_MARK},
	{0x011400, 0x011434, PG_U_OTHER_LETTER},
	{0x011435, 0x011437, PG_U_SPACING_MARK},
	{0x011438, 0x01143f, PG_U_NONSPACING_MARK},
	{0x011440, 0x011441, PG_U_SPACING_MARK},
	{0x011442, 0x011444, PG_U_NONSPACING_MARK},
	{0x011445, 0x011445, PG_U_SPACING_MARK},
	{0x011446, 0x011446, PG_U_NONSPACING_MARK},
	{0x011447, 0x01144a, PG_U_OTHER_LETTER},
	{0x01144b, 0x01144f, PG_U_OTHER_PUNCTUATION},
	{0x011450, 0x011459, PG_U_DECIMAL_NUMBER},
	{0x01145a, 0x01145b, PG_U_OTHER_PUNCTUATION},
	{0x01145d, 0x01145d, PG_U_OTHER_PUNCTUATION},
	{0x01145e, 0x01145e, PG_U_NONSPACING_MARK},
	{0x01145f, 0x011461, PG_U_OTHER_LETTER},
	{0x011480, 0x0114af, PG_U_OTHER_LETTER},
	{0x0114b0, 0x0114b2, PG_U_SPACING_MARK},
	{0x0114b3, 0x0114b8, PG_U_NONSPACING_MARK},
	{0x0114b9, 0x0114b9, PG_U_SPACING_MARK},
	{0x0114ba, 0x0114ba, PG_U_NONSPACING_MARK},
	{0x0114bb, 0x0114be, PG_U_SPACING_MARK},
	{0x0114bf, 0x0114c0, PG_U_NONSPACING_MARK},
	{0x0114c1, 0x0114c1, PG_U_SPACING_MARK},
	{0x0114c2, 0x0114c3, PG_U_NONSPACING_MARK},
	{0x0114c4, 0x0114c5, PG_U_OTHER_LETTER},
	{0x0114c6, 0x0114c6, PG_U_OTHER_PUNCTUATION},
	{0x0114c7, 0x0114c7, PG_U_OTHER_LETTER},
	{0x0114d0, 0x0114d9, PG_U_DECIMAL_NUMBER},
	{0x011580, 0x0115ae, PG_U_OTHER_LETTER},
	{0x0115af, 0x0115b1, PG_U_SPACING_MARK},
	{0x0115b2, 0x0115b5, PG_U_NONSPACING_MARK},
	{0x0115b8, 0x0115bb, PG_U_SPACING_MARK},
	{0x0115bc, 0x0115bd, PG_U_NONSPACING_MARK},
	{0x0115be, 0x0115be, PG_U_SPACING_MARK},
	{0x0115bf, 0x0115c0, PG_U_NONSPACING_MARK},
	{0x0115c1, 0x0115d7, PG_U_OTHER_PUNCTUATION},
	{0x0115d8, 0x0115db, PG_U_OTHER_LETTER},
	{0x0115dc, 0x0115dd, PG_U_NONSPACING_MARK},
	{0x011600, 0x01162f, PG_U_OTHER_LETTER},
	{0x011630, 0x011632, PG_U_SPACING_MARK},
	{0x011633, 0x01163a, PG_U_NONSPACING_MARK},
	{0x01163b, 0x01163c, PG_U_SPACING_MARK},
	{0x01163d, 0x01163d, PG_U_NONSPACING_MARK},
	{0x01163e, 0x01163e, PG_U_SPACING_MARK},
	{0x01163f, 0x011640, PG_U_NONSPACING_MARK},
	{0x011641, 0x011643, PG_U_OTHER_PUNCTUATION},
	{0x011644, 0x011644, PG_U_OTHER_LETTER},
	{0x011650, 0x011659, PG_U_DECIMAL_NUMBER},
	{0x011660, 0x01166c, PG_U_OTHER_PUNCTUATION},
	{0x011680, 0x0116aa, PG_U_OTHER_LETTER},
	{0x0116ab, 0x0116ab, PG_U_NONSPACING_MARK},
	{0x0116ac, 0x0116ac, PG_U_SPACING_MARK},
	{0x0116ad, 0x0116ad, PG_U_NONSPACING_MARK},
	{0x0116ae, 0x0116af, PG_U_SPACING_MARK},
	{0x0116b0, 0x0116b5, PG_U_NONSPACING_MARK},
	{0x0116b6, 0x0116b6, PG_U_SPACING_MARK},
	{0x0116b7, 0x0116b7, PG_U_NONSPACING_MARK},
	{0x0116b8, 0x0116b8, PG_U_OTHER_LETTER},
	{0x0116b9, 0x0116b9, PG_U_OTHER_PUNCTUATION},
	{0x0116c0, 0x0116c9, PG_U_DECIMAL_NUMBER},
	{0x011700, 0x01171a, PG_U_OTHER_LETTER},
	{0x01171d, 0x01171f, PG_U_NONSPACING_MARK},
	{0x011720, 0x011721, PG_U_SPACING_MARK},
	{0x011722, 0x011725, PG_U_NONSPACING_MARK},
	{0x011726, 0x011726, PG_U_SPACING_MARK},
	{0x011727, 0x01172b, PG_U_NONSPACING_MARK},
	{0x011730, 0x011739, PG_U_DECIMAL_NUMBER},
	{0x01173a, 0x01173b, PG_U_OTHER_NUMBER},
	{0x01173c, 0x01173e, PG_U_OTHER_PUNCTUATION},
	{0x01173f, 0x01173f, PG_U_OTHER_SYMBOL},
	{0x011740, 0x011746, PG_U_OTHER_LETTER},
	{0x011800, 0x01182b, PG_U_OTHER_LETTER},
	{0x01182c, 0x01182e, PG_U_SPACING_MARK},
	{0x01182f, 0x011837, PG_U_NONSPACING_MARK},
	{0x011838, 0x011838, PG_U_SPACING_MARK},
	{0x011839, 0x01183a, PG_U_NONSPACING_MARK},
	{0x01183b, 0x01183b, PG_U_OTHER_PUNCTUATION},
	{0x0118a0, 0x0118bf, PG_U_UPPERCASE_LETTER},
	{0x0118c0, 0x0118df, PG_U_LOWERCASE_LETTER},
	{0x0118e0, 0x0118e9, PG_U_DECIMAL_NUMBER},
	{0x0118ea, 0x0118f2, PG_U_OTHER_NUMBER},
	{0x0118ff, 0x011906, PG_U_OTHER_LETTER},
	{0x011909, 0x011909, PG_U_OTHER_LETTER},
	{0x01190c, 0x011913, PG_U_OTHER_LETTER},
	{0x011915, 0x011916, PG_U_OTHER_LETTER},
	{0x011918, 0x01192f, PG_U_OTHER_LETTER},
	{0x011930, 0x011935, PG_U_SPACING_MARK},
	{0x011937, 0x011938, PG_U_SPACING_MARK},
	{0x01193b, 0x01193c, PG_U_NONSPACING_MARK},
	{0x01193d, 0x01193d, PG_U_SPACING_MARK},
	{0x01193e, 0x01193e, PG_U_NONSPACING_MARK},
	{0x01193f, 0x01193f, PG_U_OTHER_LETTER},
	{0x011940, 0x011940, PG_U_SPACING_MARK},
	{0x011941, 0x011941, PG_U_OTHER_LETTER},
	{0x011942, 0x011942, PG_U_SPACING_MARK},
	{0x011943, 0x011943, PG_U_NONSPACING_MARK},
	{0x011944, 0x011946, PG_U_OTHER_PUNCTUATION},
	{0x011950, 0x011959, PG_U_DECIMAL_NUMBER},
	{0x0119a0, 0x0119a7, PG_U_OTHER_LETTER},
	{0x0119aa, 0x0119d0, PG_U_OTHER_LETTER},
	{0x0119d1, 0x0119d3, PG_U_SPACING_MARK},
	{0x0119d4, 0x0119d7, PG_U_NONSPACING_MARK},
	{0x0119da, 0x0119db, PG_U_NONSPACING_MARK},
	{0x0119dc, 0x0119df, PG_U_SPACING_MARK},
	{0x0119e0, 0x0119e0, PG_U_NONSPACING_MARK},
	{0x0119e1, 0x0119e1, PG_U_OTHER_LETTER},
	{0x0119e2, 0x0119e2, PG_U_OTHER_PUNCTUATION},
	{0x0119e3, 0x0119e3, PG_U_OTHER_LETTER},
	{0x0119e4, 0x0119e4, PG_U_SPACING_MARK},
	{0x011a00, 0x011a00, PG_U_OTHER_LETTER},
	{0x011a01, 0x011a0a, PG_U_NONSPACING_MARK},
	{0x011a0b, 0x011a32, PG_U_OTHER_LETTER},
	{0x011a33, 0x011a38, PG_U_NONSPACING_MARK},
	{0x011a39, 0x011a39, PG_U_SPACING_MARK},
	{0x011a3a, 0x011a3a, PG_U_OTHER_LETTER},
	{0x011a3b, 0x011a3e, PG_U_NONSPACING_MARK},
	{0x011a3f, 0x011a46, PG_U_OTHER_PUNCTUATION},
	{0x011a47, 0x011a47, PG_U_NONSPACING_MARK},
	{0x011a50, 0x011a50, PG_U_OTHER_LETTER},
	{0x011a51, 0x011a56, PG_U_NONSPACING_MARK},
	{0x011a57, 0x011a58, PG_U_SPACING_MARK},
	{0x011a59, 0x011a5b, PG_U_NONSPACING_MARK},
	{0x011a5c, 0x011a89, PG_U_OTHER_LETTER},
	{0x011a8a, 0x011a96, PG_U_NONSPACING_MARK},
	{0x011a97, 0x011a97, PG_U_SPACING_MARK},
	{0x011a98, 0x011a99, PG_U_NONSPACING_MARK},
	{0x011a9a, 0x011a9c, PG_U_OTHER_PUNCTUATION},
	{0x011a9d, 0x011a9d, PG_U_OTHER_LETTER},
	{0x011a9e, 0x011aa2, PG_U_OTHER_PUNCTUATION},
	{0x011ab0, 0x011af8, PG_U_OTHER_LETTER},
	{0x011b00, 0x011b09, PG_U_OTHER_PUNCTUATION},
	{0x011c00, 0x011c08, PG_U_OTHER_LETTER},
	{0x011c0a, 0x011c2e, PG_U_OTHER_LETTER},
	{0x011c2f, 0x011c2f, PG_U_SPACING_MARK},
	{0x011c30, 0x011c36, PG_U_NONSPACING_MARK},
	{0x011c38, 0x011c3d, PG_U_NONSPACING_MARK},
	{0x011c3e, 0x011c3e, PG_U_SPACING_MARK},
	{0x011c3f, 0x011c3f, PG_U_NONSPACING_MARK},
	{0x011c40, 0x011c40, PG_U_OTHER_LETTER},
	{0x011c41, 0x011c45, PG_U_OTHER_PUNCTUATION},
	{0x011c50, 0x011c59, PG_U_DECIMAL_NUMBER},
	{0x011c5a, 0x011c6c, PG_U_OTHER_NUMBER},
	{0x011c70, 0x011c71, PG_U_OTHER_PUNCTUATION},
	{0x011c72, 0x011c8f, PG_U_OTHER_LETTER},
	{0x011c92, 0x011ca7, PG_U_NONSPACING_MARK},
	{0x011ca9, 0x011ca9, PG_U_SPACING_MARK},
	{0x011caa, 0x011cb0, PG_U_NONSPACING_MARK},
	{0x011cb1, 0x011cb1, PG_U_SPACING_MARK},
	{0x011cb2, 0x011cb3, PG_U_NONSPACING_MARK},
	{0x011cb4, 0x011cb4, PG_U_SPACING_MARK},
	{0x011cb5, 0x011cb6, PG_U_NONSPACING_MARK},
	{0x011d00, 0x011d06, PG_U_OTHER_LETTER},
	{0x011d08, 0x011d09, PG_U_OTHER_LETTER},
	{0x011d0b, 0x011d30, PG_U_OTHER_LETTER},
	{0x011d31, 0x011d36, PG_U_NONSPACING_MARK},
	{0x011d3a, 0x011d3a, PG_U_NONSPACING_MARK},
	{0x011d3c, 0x011d3d, PG_U_NONSPACING_MARK},
	{0x011d3f, 0x011d45, PG_U_NONSPACING_MARK},
	{0x011d46, 0x011d46, PG_U_OTHER_LETTER},
	{0x011d47, 0x011d47, PG_U_NONSPACING_MARK},
	{0x011d50, 0x011d59, PG_U_DECIMAL_NUMBER},
	{0x011d60, 0x011d65, PG_U_OTHER_LETTER},
	{0x011d67, 0x011d68, PG_U_OTHER_LETTER},
	{0x011d6a, 0x011d89, PG_U_OTHER_LETTER},
	{0x011d8a, 0x011d8e, PG_U_SPACING_MARK},
	{0x011d90, 0x011d91, PG_U_NONSPACING_MARK},
	{0x011d93, 0x011d94, PG_U_SPACING_MARK},
	{0x011d95, 0x011d95, PG_U_NONSPACING_MARK},
	{0x011d96, 0x011d96, PG_U_SPACING_MARK},
	{0x011d97, 0x011d97, PG_U_NONSPACING_MARK},
	{0x011d98, 0x011d98, PG_U_OTHER_LETTER},
	{0x011da0, 0x011da9, PG_U_DECIMAL_NUMBER},
	{0x011ee0, 0x011ef2, PG_U_OTHER_LETTER},
	{0x011ef3, 0x011ef4, PG_U_NONSPACING_MARK},
	{0x011ef5, 0x011ef6, PG_U_SPACING_MARK},
	{0x011ef7, 0x011ef8, PG_U_OTHER_PUNCTUATION},
	{0x011f00, 0x011f01, PG_U_NONSPACING_MARK},
	{0x011f02, 0x011f02, PG_U_OTHER_LETTER},
	{0x011f03, 0x011f03, PG_U_SPACING_MARK},
	{0x011f04, 0x011f10, PG_U_OTHER_LETTER},
	{0x011f12, 0x011f33, PG_U_OTHER_LETTER},
	{0x011f34, 0x011f35, PG_U_SPACING_MARK},
	{0x011f36, 0x011f3a, PG_U_NONSPACING_MARK},
	{0x011f3e, 0x011f3f, PG_U_SPACING_MARK},
	{0x011f40, 0x011f40, PG_U_NONSPACING_MARK},
	{0x011f41, 0x011f41, PG_U_SPACING_MARK},
	{0x011f42, 0x011f42, PG_U_NONSPACING_MARK},
	{0x011f43, 0x011f4f, PG_U_OTHER_PUNCTUATION},
	{0x011f50, 0x011f59, PG_U_DECIMAL_NUMBER},
	{0x011fb0, 0x011fb0, PG_U_OTHER_LETTER},
	{0x011fc0, 0x011fd4, PG_U_OTHER_NUMBER},
	{0x011fd5, 0x011fdc, PG_U_OTHER_SYMBOL},
	{0x011fdd, 0x011fe0, PG_U_CURRENCY_SYMBOL},
	{0x011fe1, 0x011ff1, PG_U_OTHER_SYMBOL},
	{0x011fff, 0x011fff, PG_U_OTHER_PUNCTUATION},
	{0x012000, 0x012399, PG_U_OTHER_LETTER},
	{0x012400, 0x01246e, PG_U_LETTER_NUMBER},
	{0x012470, 0x012474, PG_U_OTHER_PUNCTUATION},
	{0x012480, 0x012543, PG_U_OTHER_LETTER},
	{0x012f90, 0x012ff0, PG_U_OTHER_LETTER},
	{0x012ff1, 0x012ff2, PG_U_OTHER_PUNCTUATION},
	{0x013000, 0x01342f, PG_U_OTHER_LETTER},
	{0x013430, 0x01343f, PG_U_FORMAT},
	{0x013440, 0x013440, PG_U_NONSPACING_MARK},
	{0x013441, 0x013446, PG_U_OTHER_LETTER},
	{0x013447, 0x013455, PG_U_NONSPACING_MARK},
	{0x014400, 0x014646, PG_U_OTHER_LETTER},
	{0x016800, 0x016a38, PG_U_OTHER_LETTER},
	{0x016a40, 0x016a5e, PG_U_OTHER_LETTER},
	{0x016a60, 0x016a69, PG_U_DECIMAL_NUMBER},
	{0x016a6e, 0x016a6f, PG_U_OTHER_PUNCTUATION},
	{0x016a70, 0x016abe, PG_U_OTHER_LETTER},
	{0x016ac0, 0x016ac9, PG_U_DECIMAL_NUMBER},
	{0x016ad0, 0x016aed, PG_U_OTHER_LETTER},
	{0x016af0, 0x016af4, PG_U_NONSPACING_MARK},
	{0x016af5, 0x016af5, PG_U_OTHER_PUNCTUATION},
	{0x016b00, 0x016b2f, PG_U_OTHER_LETTER},
	{0x016b30, 0x016b36, PG_U_NONSPACING_MARK},
	{0x016b37, 0x016b3b, PG_U_OTHER_PUNCTUATION},
	{0x016b3c, 0x016b3f, PG_U_OTHER_SYMBOL},
	{0x016b40, 0x016b43, PG_U_MODIFIER_LETTER},
	{0x016b44, 0x016b44, PG_U_OTHER_PUNCTUATION},
	{0x016b45, 0x016b45, PG_U_OTHER_SYMBOL},
	{0x016b50, 0x016b59, PG_U_DECIMAL_NUMBER},
	{0x016b5b, 0x016b61, PG_U_OTHER_NUMBER},
	{0x016b63, 0x016b77, PG_U_OTHER_LETTER},
	{0x016b7d, 0x016b8f, PG_U_OTHER_LETTER},
	{0x016e40, 0x016e5f, PG_U_UPPERCASE_LETTER},
	{0x016e60, 0x016e7f, PG_U_LOWERCASE_LETTER},
	{0x016e80, 0x016e96, PG_U_OTHER_NUMBER},
	{0x016e97, 0x016e9a, PG_U_OTHER_PUNCTUATION},
	{0x016f00, 0x016f4a, PG_U_OTHER_LETTER},
	{0x016f4f, 0x016f4f, PG_U_NONSPACING_MARK},
	{0x016f50, 0x016f50, PG_U_OTHER_LETTER},
	{0x016f51, 0x016f87, PG_U_SPACING_MARK},
	{0x016f8f, 0x016f92, PG_U_NONSPACING_MARK},
	{0x016f93, 0x016f9f, PG_U_MODIFIER_LETTER},
	{0x016fe0, 0x016fe1, PG_U_MODIFIER_LETTER},
	{0x016fe2, 0x016fe2, PG_U_OTHER_PUNCTUATION},
	{0x016fe3, 0x016fe3, PG_U_MODIFIER_LETTER},
	{0x016fe4, 0x016fe4, PG_U_NONSPACING_MARK},
	{0x016ff0, 0x016ff1, PG_U_SPACING_MARK},
	{0x017000, 0x0187f7, PG_U_OTHER_LETTER},
	{0x018800, 0x018cd5, PG_U_OTHER_LETTER},
	{0x018d00, 0x018d08, PG_U_OTHER_LETTER},
	{0x01aff0, 0x01aff3, PG_U_MODIFIER_LETTER},
	{0x01aff5, 0x01affb, PG_U_MODIFIER_LETTER},
	{0x01affd, 0x01affe, PG_U_MODIFIER_LETTER},
	{0x01b000, 0x01b122, PG_U_OTHER_LETTER},
	{0x01b132, 0x01b132, PG_U_OTHER_LETTER},
	{0x01b150, 0x01b152, PG_U_OTHER_LETTER},
	{0x01b155, 0x01b155, PG_U_OTHER_LETTER},
	{0x01b164, 0x01b167, PG_U_OTHER_LETTER},
	{0x01b170, 0x01b2fb, PG_U_OTHER_LETTER},
	{0x01bc00, 0x01bc6a, PG_U_OTHER_LETTER},
	{0x01bc70, 0x01bc7c, PG_U_OTHER_LETTER},
	{0x01bc80, 0x01bc88, PG_U_OTHER_LETTER},
	{0x01bc90, 0x01bc99, PG_U_OTHER_LETTER},
	{0x01bc9c, 0x01bc9c, PG_U_OTHER_SYMBOL},
	{0x01bc9d, 0x01bc9e, PG_U_NONSPACING_MARK},
	{0x01bc9f, 0x01bc9f, PG_U_OTHER_PUNCTUATION},
	{0x01bca0, 0x01bca3, PG_U_FORMAT},
	{0x01cf00, 0x01cf2d, PG_U_NONSPACING_MARK},
	{0x01cf30, 0x01cf46, PG_U_NONSPACING_MARK},
	{0x01cf50, 0x01cfc3, PG_U_OTHER_SYMBOL},
	{0x01d000, 0x01d0f5, PG_U_OTHER_SYMBOL},
	{0x01d100, 0x01d126, PG_U_OTHER_SYMBOL},
	{0x01d129, 0x01d164, PG_U_OTHER_SYMBOL},
	{0x01d165, 0x01d166, PG_U_SPACING_MARK},
	{0x01d167, 0x01d169, PG_U_NONSPACING_MARK},
	{0x01d16a, 0x01d16c, PG_U_OTHER_SYMBOL},
	{0x01d16d, 0x01d172, PG_U_SPACING_MARK},
	{0x01d173, 0x01d17a, PG_U_FORMAT},
	{0x01d17b, 0x01d182, PG_U_NONSPACING_MARK},
	{0x01d183, 0x01d184, PG_U_OTHER_SYMBOL},
	{0x01d185, 0x01d18b, PG_U_NONSPACING_MARK},
	{0x01d18c, 0x01d1a9, PG_U_OTHER_SYMBOL},
	{0x01d1aa, 0x01d1ad, PG_U_NONSPACING_MARK},
	{0x01d1ae, 0x01d1ea, PG_U_OTHER_SYMBOL},
	{0x01d200, 0x01d241, PG_U_OTHER_SYMBOL},
	{0x01d242, 0x01d244, PG_U_NONSPACING_MARK},
	{0x01d245, 0x01d245, PG_U_OTHER_SYMBOL},
	{0x01d2c0, 0x01d2d3, PG_U_OTHER_NUMBER},
	{0x01d2e0, 0x01d2f3, PG_U_OTHER_NUMBER},
	{0x01d300, 0x01d356, PG_U_OTHER_SYMBOL},
	{0x01d360, 0x01d378, PG_U_OTHER_NUMBER},
	{0x01d400, 0x01d419, PG_U_UPPERCASE_LETTER},
	{0x01d41a, 0x01d433, PG_U_LOWERCASE_LETTER},
	{0x01d434, 0x01d44d, PG_U_UPPERCASE_LETTER},
	{0x01d44e, 0x01d454, PG_U_LOWERCASE_LETTER},
	{0x01d456, 0x01d467, PG_U_LOWERCASE_LETTER},
	{0x01d468, 0x01d481, PG_U_UPPERCASE_LETTER},
	{0x01d482, 0x01d49b, PG_U_LOWERCASE_LETTER},
	{0x01d49c, 0x01d49c, PG_U_UPPERCASE_LETTER},
	{0x01d49e, 0x01d49f, PG_U_UPPERCASE_LETTER},
	{0x01d4a2, 0x01d4a2, PG_U_UPPERCASE_LETTER},
	{0x01d4a5, 0x01d4a6, PG_U_UPPERCASE_LETTER},
	{0x01d4a9, 0x01d4ac, PG_U_UPPERCASE_LETTER},
	{0x01d4ae, 0x01d4b5, PG_U_UPPERCASE_LETTER},
	{0x01d4b6, 0x01d4b9, PG_U_LOWERCASE_LETTER},
	{0x01d4bb, 0x01d4bb, PG_U_LOWERCASE_LETTER},
	{0x01d4bd, 0x01d4c3, PG_U_LOWERCASE_LETTER},
	{0x01d4c5, 0x01d4cf, PG_U_LOWERCASE_LETTER},
	{0x01d4d0, 0x01d4e9, PG_U_UPPERCASE_LETTER},
	{0x01d4ea, 0x01d503, PG_U_LOWERCASE_LETTER},
	{0x01d504, 0x01d505, PG_U_UPPERCASE_LETTER},
	{0x01d507, 0x01d50a, PG_U_UPPERCASE_LETTER},
	{0x01d50d, 0x01d514, PG_U_UPPERCASE_LETTER},
	{0x01d516, 0x01d51c, PG_U_UPPERCASE_LETTER},
	{0x01d51e, 0x01d537, PG_U_LOWERCASE_LETTER},
	{0x01d538, 0x01d539, PG_U_UPPERCASE_LETTER},
	{0x01d53b, 0x01d53e, PG_U_UPPERCASE_LETTER},
	{0x01d540, 0x01d544, PG_U_UPPERCASE_LETTER},
	{0x01d546, 0x01d546, PG_U_UPPERCASE_LETTER},
	{0x01d54a, 0x01d550, PG_U_UPPERCASE_LETTER},
	{0x01d552, 0x01d56b, PG_U_LOWERCASE_LETTER},
	{0x01d56c, 0x01d585, PG_U_UPPERCASE_LETTER},
	{0x01d586, 0x01d59f, PG_U_LOWERCASE_LETTER},
	{0x01d5a0, 0x01d5b9, PG_U_UPPERCASE_LETTER},
	{0x01d5ba, 0x01d5d3, PG_U_LOWERCASE_LETTER},
	{0x01d5d4, 0x01d5ed, PG_U_UPPERCASE_LETTER},
	{0x01d5ee, 0x01d607, PG_U_LOWERCASE_LETTER},
	{0x01d608, 0x01d621, PG_U_UPPERCASE_LETTER},
	{0x01d622, 0x01d63b, PG_U_LOWERCASE_LETTER},
	{0x01d63c, 0x01d655, PG_U_UPPERCASE_LETTER},
	{0x01d656, 0x01d66f, PG_U_LOWERCASE_LETTER},
	{0x01d670, 0x01d689, PG_U_UPPERCASE_LETTER},
	{0x01d68a, 0x01d6a5, PG_U_LOWERCASE_LETTER},
	{0x01d6a8, 0x01d6c0, PG_U_UPPERCASE_LETTER},
	{0x01d6c1, 0x01d6c1, PG_U_MATH_SYMBOL},
	{0x01d6c2, 0x01d6da, PG_U_LOWERCASE_LETTER},
	{0x01d6db, 0x01d6db, PG_U_MATH_SYMBOL},
	{0x01d6dc, 0x01d6e1, PG_U_LOWERCASE_LETTER},
	{0x01d6e2, 0x01d6fa, PG_U_UPPERCASE_LETTER},
	{0x01d6fb, 0x01d6fb, PG_U_MATH_SYMBOL},
	{0x01d6fc, 0x01d714, PG_U_LOWERCASE_LETTER},
	{0x01d715, 0x01d715, PG_U_MATH_SYMBOL},
	{0x01d716, 0x01d71b, PG_U_LOWERCASE_LETTER},
	{0x01d71c, 0x01d734, PG_U_UPPERCASE_LETTER},
	{0x01d735, 0x01d735, PG_U_MATH_SYMBOL},
	{0x01d736, 0x01d74e, PG_U_LOWERCASE_LETTER},
	{0x01d74f, 0x01d74f, PG_U_MATH_SYMBOL},
	{0x01d750, 0x01d755, PG_U_LOWERCASE_LETTER},
	{0x01d756, 0x01d76e, PG_U_UPPERCASE_LETTER},
	{0x01d76f, 0x01d76f, PG_U_MATH_SYMBOL},
	{0x01d770, 0x01d788, PG_U_LOWERCASE_LETTER},
	{0x01d789, 0x01d789, PG_U_MATH_SYMBOL},
	{0x01d78a, 0x01d78f, PG_U_LOWERCASE_LETTER},
	{0x01d790, 0x01d7a8, PG_U_UPPERCASE_LETTER},
	{0x01d7a9, 0x01d7a9, PG_U_MATH_SYMBOL},
	{0x01d7aa, 0x01d7c2, PG_U_LOWERCASE_LETTER},
	{0x01d7c3, 0x01d7c3, PG_U_MATH_SYMBOL},
	{0x01d7c4, 0x01d7c9, PG_U_LOWERCASE_LETTER},
	{0x01d7ca, 0x01d7ca, PG_U_UPPERCASE_LETTER},
	{0x01d7cb, 0x01d7cb, PG_U_LOWERCASE_LETTER},
	{0x01d7ce, 0x01d7ff, PG_U_DECIMAL_NUMBER},
	{0x01d800, 0x01d9ff, PG_U_OTHER_SYMBOL},
	{0x01da00, 0x01da36, PG_U_NONSPACING_MARK},
	{0x01da37, 0x01da3a, PG_U_OTHER_SYMBOL},
	{0x01da3b, 0x01da6c, PG_U_NONSPACING_MARK},
	{0x01da6d, 0x01da74, PG_U_OTHER_SYMBOL},
	{0x01da75, 0x01da75, PG_U_NONSPACING_MARK},
	{0x01da76, 0x01da83, PG_U_OTHER_SYMBOL},
	{0x01da84, 0x01da84, PG_U_NONSPACING_MARK},
	{0x01da85, 0x01da86, PG_U_OTHER_SYMBOL},
	{0x01da87, 0x01da8b, PG_U_OTHER_PUNCTUATION},
	{0x01da9b, 0x01da9f, PG_U_NONSPACING_MARK},
	{0x01daa1, 0x01daaf, PG_U_NONSPACING_MARK},
	{0x01df00, 0x01df09, PG_U_LOWERCASE_LETTER},
	{0x01df0a, 0x01df0a, PG_U_OTHER_LETTER},
	{0x01df0b, 0x01df1e, PG_U_LOWERCASE_LETTER},
	{0x01df25, 0x01df2a, PG_U_LOWERCASE_LETTER},
	{0x01e000, 0x01e006, PG_U_NONSPACING_MARK},
	{0x01e008, 0x01e018, PG_U_NONSPACING_MARK},
	{0x01e01b, 0x01e021, PG_U_NONSPACING_MARK},
	{0x01e023, 0x01e024, PG_U_NONSPACING_MARK},
	{0x01e026, 0x01e02a, PG_U_NONSPACING_MARK},
	{0x01e030, 0x01e06d, PG_U_MODIFIER_LETTER},
	{0x01e08f, 0x01e08f, PG_U_NONSPACING_MARK},
	{0x01e100, 0x01e12c, PG_U_OTHER_LETTER},
	{0x01e130, 0x01e136, PG_U_NONSPACING_MARK},
	{0x01e137, 0x01e13d, PG_U_MODIFIER_LETTER},
	{0x01e140, 0x01e149, PG_U_DECIMAL_NUMBER},
	{0x01e14e, 0x01e14e, PG_U_OTHER_LETTER},
	{0x01e14f, 0x01e14f, PG_U_OTHER_SYMBOL},
	{0x01e290, 0x01e2ad, PG_U_OTHER_LETTER},
	{0x01e2ae, 0x01e2ae, PG_U_NONSPACING_MARK},
	{0x01e2c0, 0x01e2eb, PG_U_OTHER_LETTER},
	{0x01e2ec, 0x01e2ef, PG_U_NONSPACING_MARK},
	{0x01e2f0, 0x01e2f9, PG_U_DECIMAL_NUMBER},
	{0x01e2ff, 0x01e2ff, PG_U_CURRENCY_SYMBOL},
	{0x01e4d0, 0x01e4ea, PG_U_OTHER_LETTER},
	{0x01e4eb, 0x01e4eb, PG_U_MODIFIER_LETTER},
	{0x01e4ec, 0x01e4ef, PG_U_NONSPACING_MARK},
	{0x01e4f0, 0x01e4f9, PG_U_DECIMAL_NUMBER},
	{0x01e7e0, 0x01e7e6, PG_U_OTHER_LETTER},
	{0x01e7e8, 0x01e7eb, PG_U_OTHER_LETTER},
	{0x01e7ed, 0x01e7ee, PG_U_OTHER_LETTER},
	{0x01e7f0, 0x01e7fe, PG_U_OTHER_LETTER},
	{0x01e800, 0x01e8c4, PG_U_OTHER_LETTER},
	{0x01e8c7, 0x01e8cf, PG_U_OTHER_NUMBER},
	{0x01e8d0, 0x01e8d6, PG_U_NONSPACING_MARK},
	{0x01e900, 0x01e921, PG_U_UPPERCASE_LETTER},
	{0x01e922, 0x01e943, PG_U_LOWERCASE_LETTER},
	{0x01e944, 0x01e94a, PG_U_NONSPACING_MARK},
	{0x01e94b, 0x01e94b, PG_U_MODIFIER_LETTER},
	{0x01e950, 0x01e959, PG_U_DECIMAL_NUMBER},
	{0x01e95e, 0x01e95f, PG_U_OTHER_PUNCTUATION},
	{0x01ec71, 0x01ecab, PG_U_OTHER_NUMBER},
	{0x01ecac, 0x01ecac, PG_U_OTHER_SYMBOL},
	{0x01ecad, 0x01ecaf, PG_U_OTHER_NUMBER},
	{0x01ecb0, 0x01ecb0, PG_U_CURRENCY_SYMBOL},
	{0x01ecb1, 0x01ecb4, PG_U_OTHER_NUMBER},
	{0x01ed01, 0x01ed2d, PG_U_OTHER_NUMBER},
	{0x01ed2e, 0x01ed2e, PG_U_OTHER_SYMBOL},
	{0x01ed2f, 0x01ed3d, PG_U_OTHER_NUMBER},
	{0x01ee00, 0x01ee03, PG_U_OTHER_LETTER},
	{0x01ee05, 0x01ee1f, PG_U_OTHER_LETTER},
	{0x01ee21, 0x01ee22, PG_U_OTHER_LETTER},
	{0x01ee24, 0x01ee24, PG_U_OTHER_LETTER},
	{0x01ee27, 0x01ee27, PG_U_OTHER_LETTER},
	{0x01ee29, 0x01ee32, PG_U_OTHER_LETTER},
	{0x01ee34, 0x01ee37, PG_U_OTHER_LETTER},
	{0x01ee39, 0x01ee39, PG_U_OTHER_LETTER},
	{0x01ee3b, 0x01ee3b, PG_U_OTHER_LETTER},
	{0x01ee42, 0x01ee42, PG_U_OTHER_LETTER},
	{0x01ee47, 0x01ee47, PG_U_OTHER_LETTER},
	{0x01ee49, 0x01ee49, PG_U_OTHER_LETTER},
	{0x01ee4b, 0x01ee4b, PG_U_OTHER_LETTER},
	{0x01ee4d, 0x01ee4f, PG_U_OTHER_LETTER},
	{0x01ee51, 0x01ee52, PG_U_OTHER_LETTER},
	{0x01ee54, 0x01ee54, PG_U_OTHER_LETTER},
	{0x01ee57, 0x01ee57, PG_U_OTHER_LETTER},
	{0x01ee59, 0x01ee59, PG_U_OTHER_LETTER},
	{0x01ee5b, 0x01ee5b, PG_U_OTHER_LETTER},
	{0x01ee5d, 0x01ee5d, PG_U_OTHER_LETTER},
	{0x01ee5f, 0x01ee5f, PG_U_OTHER_LETTER},
	{0x01ee61, 0x01ee62, PG_U_OTHER_LETTER},
	{0x01ee64, 0x01ee64, PG_U_OTHER_LETTER},
	{0x01ee67, 0x01ee6a, PG_U_OTHER_LETTER},
	{0x01ee6c, 0x01ee72, PG_U_OTHER_LETTER},
	{0x01ee74, 0x01ee77, PG_U_OTHER_LETTER},
	{0x01ee79, 0x01ee7c, PG_U_OTHER_LETTER},
	{0x01ee7e, 0x01ee7e, PG_U_OTHER_LETTER},
	{0x01ee80, 0x01ee89, PG_U_OTHER_LETTER},
	{0x01ee8b, 0x01ee9b, PG_U_OTHER_LETTER},
	{0x01eea1, 0x01eea3, PG_U_OTHER_LETTER},
	{0x01eea5, 0x01eea9, PG_U_OTHER_LETTER},
	{0x01eeab, 0x01eebb, PG_U_OTHER_LETTER},
	{0x01eef0, 0x01eef1, PG_U_MATH_SYMBOL},
	{0x01f000, 0x01f02b, PG_U_OTHER_SYMBOL},
	{0x01f030, 0x01f093, PG_U_OTHER_SYMBOL},
	{0x01f0a0, 0x01f0ae, PG_U_OTHER_SYMBOL},
	{0x01f0b1, 0x01f0bf, PG_U_OTHER_SYMBOL},
	{0x01f0c1, 0x01f0cf, PG_U_OTHER_SYMBOL},
	{0x01f0d1, 0x01f0f5, PG_U_OTHER_SYMBOL},
	{0x01f100, 0x01f10c, PG_U_OTHER_NUMBER},
	{0x01f10d, 0x01f1ad, PG_U_OTHER_SYMBOL},
	{0x01f1e6, 0x01f202, PG_U_OTHER_SYMBOL},
	{0x01f210, 0x01f23b, PG_U_OTHER_SYMBOL},
	{0x01f240, 0x01f248, PG_U_OTHER_SYMBOL},
	{0x01f250, 0x01f251, PG_U_OTHER_SYMBOL},
	{0x01f260, 0x01f265, PG_U_OTHER_SYMBOL},
	{0x01f300, 0x01f3fa, PG_U_OTHER_SYMBOL},
	{0x01f3fb, 0x01f3ff, PG_U_MODIFIER_SYMBOL},
	{0x01f400, 0x01f6d7, PG_U_OTHER_SYMBOL},
	{0x01f6dc, 0x01f6ec, PG_U_OTHER_SYMBOL},
	{0x01f6f0, 0x01f6fc, PG_U_OTHER_SYMBOL},
	{0x01f700, 0x01f776, PG_U_OTHER_SYMBOL},
	{0x01f77b, 0x01f7d9, PG_U_OTHER_SYMBOL},
	{0x01f7e0, 0x01f7eb, PG_U_OTHER_SYMBOL},
	{0x01f7f0, 0x01f7f0, PG_U_OTHER_SYMBOL},
	{0x01f800, 0x01f80b, PG_U_OTHER_SYMBOL},
	{0x01f810, 0x01f847, PG_U_OTHER_SYMBOL},
	{0x01f850, 0x01f859, PG_U_OTHER_SYMBOL},
	{0x01f860, 0x01f887, PG_U_OTHER_SYMBOL},
	{0x01f890, 0x01f8ad, PG_U_OTHER_SYMBOL},
	{0x01f8b0, 0x01f8b1, PG_U_OTHER_SYMBOL},
	{0x01f900, 0x01fa53, PG_U_OTHER_SYMBOL},
	{0x01fa60, 0x01fa6d, PG_U_OTHER_SYMBOL},
	{0x01fa70, 0x01fa7c, PG_U_OTHER_SYMBOL},
	{0x01fa80, 0x01fa88, PG_U_OTHER_SYMBOL},
	{0x01fa90, 0x01fabd, PG_U_OTHER_SYMBOL},
	{0x01fabf, 0x01fac5, PG_U_OTHER_SYMBOL},
	{0x01face, 0x01fadb, PG_U_OTHER_SYMBOL},
	{0x01fae0, 0x01fae8, PG_U_OTHER_SYMBOL},
	{0x01faf0, 0x01faf8, PG_U_OTHER_SYMBOL},
	{0x01fb00, 0x01fb92, PG_U_OTHER_SYMBOL},
	{0x01fb94, 0x01fbca, PG_U_OTHER_SYMBOL},
	{0x01fbf0, 0x01fbf9, PG_U_DECIMAL_NUMBER},
	{0x020000, 0x02a6df, PG_U_OTHER_LETTER},
	{0x02a700, 0x02b739, PG_U_OTHER_LETTER},
	{0x02b740, 0x02b81d, PG_U_OTHER_LETTER},
	{0x02b820, 0x02cea1, PG_U_OTHER_LETTER},
	{0x02ceb0, 0x02ebe0, PG_U_OTHER_LETTER},
	{0x02ebf0, 0x02ee5d, PG_U_OTHER_LETTER},
	{0x02f800, 0x02fa1d, PG_U_OTHER_LETTER},
	{0x030000, 0x03134a, PG_U_OTHER_LETTER},
	{0x031350, 0x0323af, PG_U_OTHER_LETTER},
	{0x0e0001, 0x0e0001, PG_U_FORMAT},
	{0x0e0020, 0x0e007f, PG_U_FORMAT},
	{0x0e0100, 0x0e01ef, PG_U_NONSPACING_MARK},
	{0x0f0000, 0x0ffffd, PG_U_PRIVATE_USE},
	{0x100000, 0x10fffd, PG_U_PRIVATE_USE},
};

/* table of Unicode codepoint ranges of Alphabetic characters */
static const pg_unicode_range unicode_alphabetic[1141] =
{
	{0x000041, 0x00005a},
	{0x000061, 0x00007a},
	{0x0000aa, 0x0000aa},
	{0x0000b5, 0x0000b5},
	{0x0000ba, 0x0000ba},
	{0x0000c0, 0x0000d6},
	{0x0000d8, 0x0000f6},
	{0x0000f8, 0x0001ba},
	{0x0001bb, 0x0001bb},
	{0x0001bc, 0x0001bf},
	{0x0001c0, 0x0001c3},
	{0x0001c4, 0x000293},
	{0x000294, 0x000294},
	{0x000295, 0x0002af},
	{0x0002b0, 0x0002c1},
	{0x0002c6, 0x0002d1},
	{0x0002e0, 0x0002e4},
	{0x0002ec, 0x0002ec},
	{0x0002ee, 0x0002ee},
	{0x000345, 0x000345},
	{0x000370, 0x000373},
	{0x000374, 0x000374},
	{0x000376, 0x000377},
	{0x00037a, 0x00037a},
	{0x00037b, 0x00037d},
	{0x00037f, 0x00037f},
	{0x000386, 0x000386},
	{0x000388, 0x00038a},
	{0x00038c, 0x00038c},
	{0x00038e, 0x0003a1},
	{0x0003a3, 0x0003f5},
	{0x0003f7, 0x000481},
	{0x00048a, 0x00052f},
	{0x000531, 0x000556},
	{0x000559, 0x000559},
	{0x000560, 0x000588},
	{0x0005b0, 0x0005bd},
	{0x0005bf, 0x0005bf},
	{0x0005c1, 0x0005c2},
	{0x0005c4, 0x0005c5},
	{0x0005c7, 0x0005c7},
	{0x0005d0, 0x0005ea},
	{0x0005ef, 0x0005f2},
	{0x000610, 0x00061a},
	{0x000620, 0x00063f},
	{0x000640, 0x000640},
	{0x000641, 0x00064a},
	{0x00064b, 0x000657},
	{0x000659, 0x00065f},
	{0x00066e, 0x00066f},
	{0x000670, 0x000670},
	{0x000671, 0x0006d3},
	{0x0006d5, 0x0006d5},
	{0x0006d6, 0x0006dc},
	{0x0006e1, 0x0006e4},
	{0x0006e5, 0x0006e6},
	{0x0006e7, 0x0006e8},
	{0x0006ed, 0x0006ed},
	{0x0006ee, 0x0006ef},
	{0x0006fa, 0x0006fc},
	{0x0006ff, 0x0006ff},
	{0x000710, 0x000710},
	{0x000711, 0x000711},
	{0x000712, 0x00072f},
	{0x000730, 0x00073f},
	{0x00074d, 0x0007a5},
	{0x0007a6, 0x0007b0},
	{0x0007b1, 0x0007b1},
	{0x0007ca, 0x0007ea},
	{0x0007f4, 0x0007f5},
	{0x0007fa, 0x0007fa},
	{0x000800, 0x000815},
	{0x000816, 0x000817},
	{0x00081a, 0x00081a},
	{0x00081b, 0x000823},
	{0x000824, 0x000824},
	{0x000825, 0x000827},
	{0x000828, 0x000828},
	{0x000829, 0x00082c},
	{0x000840, 0x000858},
	{0x000860, 0x00086a},
	{0x000870, 0x000887},
	{0x000889, 0x00088e},
	{0x0008a0, 0x0008c8},
	{0x0008c9, 0x0008c9},
	{0x0008d4, 0x0008df},
	{0x0008e3, 0x0008e9},
	{0x0008f0, 0x000902},
	{0x000903, 0x000903},
	{0x000904, 0x000939},
	{0x00093a, 0x00093a},
	{0x00093b, 0x00093b},
	{0x00093d, 0x00093d},
	{0x00093e, 0x000940},
	{0x000941, 0x000948},
	{0x000949, 0x00094c},
	{0x00094e, 0x00094f},
	{0x000950, 0x000950},
	{0x000955, 0x000957},
	{0x000958, 0x000961},
	{0x000962, 0x000963},
	{0x000971, 0x000971},
	{0x000972, 0x000980},
	{0x000981, 0x000981},
	{0x000982, 0x000983},
	{0x000985, 0x00098c},
	{0x00098f, 0x000990},
	{0x000993, 0x0009a8},
	{0x0009aa, 0x0009b0},
	{0x0009b2, 0x0009b2},
	{0x0009b6, 0x0009b9},
	{0x0009bd, 0x0009bd},
	{0x0009be, 0x0009c0},
	{0x0009c1, 0x0009c4},
	{0x0009c7, 0x0009c8},
	{0x0009cb, 0x0009cc},
	{0x0009ce, 0x0009ce},
	{0x0009d7, 0x0009d7},
	{0x0009dc, 0x0009dd},
	{0x0009df, 0x0009e1},
	{0x0009e2, 0x0009e3},
	{0x0009f0, 0x0009f1},
	{0x0009fc, 0x0009fc},
	{0x000a01, 0x000a02},
	{0x000a03, 0x000a03},
	{0x000a05, 0x000a0a},
	{0x000a0f, 0x000a10},
	{0x000a13, 0x000a28},
	{0x000a2a, 0x000a30},
	{0x000a32, 0x000a33},
	{0x000a35, 0x000a36},
	{0x000a38, 0x000a39},
	{0x000a3e, 0x000a40},
	{0x000a41, 0x000a42},
	{0x000a47, 0x000a48},
	{0x000a4b, 0x000a4c},
	{0x000a51, 0x000a51},
	{0x000a59, 0x000a5c},
	{0x000a5e, 0x000a5e},
	{0x000a70, 0x000a71},
	{0x000a72, 0x000a74},
	{0x000a75, 0x000a75},
	{0x000a81, 0x000a82},
	{0x000a83, 0x000a83},
	{0x000a85, 0x000a8d},
	{0x000a8f, 0x000a91},
	{0x000a93, 0x000aa8},
	{0x000aaa, 0x000ab0},
	{0x000ab2, 0x000ab3},
	{0x000ab5, 0x000ab9},
	{0x000abd, 0x000abd},
	{0x000abe, 0x000ac0},
	{0x000ac1, 0x000ac5},
	{0x000ac7, 0x000ac8},
	{0x000ac9, 0x000ac9},
	{0x000acb, 0x000acc},
	{0x000ad0, 0x000ad0},
	{0x000ae0, 0x000ae1},
	{0x000ae2, 0x000ae3},
	{0x000af9, 0x000af9},
	{0x000afa, 0x000afc},
	{0x000b01, 0x000b01},
	{0x000b02, 0x000b03},
	{0x000b05, 0x000b0c},
	{0x000b0f, 0x000b10},
	{0x000b13, 0x000b28},
	{0x000b2a, 0x000b30},
	{0x000b32, 0x000b33},
	{0x000b35, 0x000b39},
	{0x000b3d, 0x000b3d},
	{0x000b3e, 0x000b3e},
	{0x000b3f, 0x000b3f},
	{0x000b40, 0x000b40},
	{0x000b41, 0x000b44},
	{0x000b47, 0x000b48},
	{0x000b4b, 0x000b4c},
	{0x000b56, 0x000b56},
	{0x000b57, 0x000b57},
	{0x000b5c, 0x000b5d},
	{0x000b5f, 0x000b61},
	{0x000b62, 0x000b63},
	{0x000b71, 0x000b71},
	{0x000b82, 0x000b82},
	{0x000b83, 0x000b83},
	{0x000b85, 0x000b8a},
	{0x000b8e, 0x000b90},
	{0x000b92, 0x000b95},
	{0x000b99, 0x000b9a},
	{0x000b9c, 0x000b9c},
	{0x000b9e, 0x000b9f},
	{0x000ba3, 0x000ba4},
	{0x000ba8, 0x000baa},
	{0x000bae, 0x000bb9},
	{0x000bbe, 0x000bbf},
	{0x000bc0, 0x000bc0},
	{0x000bc1, 0x000bc2},
	{0x000bc6, 0x000bc8},
	{0x000bca, 0x000bcc},
	{0x000bd0, 0x000bd0},
	{0x000bd7, 0x000bd7},
	{0x000c00, 0x000c00},
	{0x000c01, 0x000c03},
	{0x000c04, 0x000c04},
	{0x000c05, 0x000c0c},
	{0x000c0e, 0x000c10},
	{0x000c12, 0x000c28},
	{0x000c2a, 0x000c39},
	{0x000c3d, 0x000c3d},
	{0x000c3e, 0x000c40},
	{0x000c41, 0x000c44},
	{0x000c46, 0x000c48},
	{0x000c4a, 0x000c4c},
	{0x000c55, 0x000c56},
	{0x000c58, 0x000c5a},
	{0x000c5d, 0x000c5d},
	{0x000c60, 0x000c61},
	{0x000c62, 0x000c63},
	{0x000c80, 0x000c80},
	{0x000c81, 0x000c81},
	{0x000c82, 0x000c83},
	{0x000c85, 0x000c8c},
	{0x000c8e, 0x000c90},
	{0x000c92, 0x000ca8},
	{0x000caa, 0x000cb3},
	{0x000cb5, 0x000cb9},
	{0x000cbd, 0x000cbd},
	{0x000cbe, 0x000cbe},
	{0x000cbf, 0x000cbf},
	{0x000cc0, 0x000cc4},
	{0x000cc6, 0x000cc6},
	{0x000cc7, 0x000cc8},
	{0x000cca, 0x000ccb},
	{0x000ccc, 0x000ccc},
	{0x000cd5, 0x000cd6},
	{0x000cdd, 0x000cde},
	{0x000ce0, 0x000ce1},
	{0x000ce2, 0x000ce3},
	{0x000cf1, 0x000cf2},
	{0x000cf3, 0x000cf3},
	{0x000d00, 0x000d01},
	{0x000d02, 0x000d03},
	{0x000d04, 0x000d0c},
	{0x000d0e, 0x000d10},
	{0x000d12, 0x000d3a},
	{0x000d3d, 0x000d3d},
	{0x000d3e, 0x000d40},
	{0x000d41, 0x000d44},
	{0x000d46, 0x000d48},
	{0x000d4a, 0x000d4c},
	{0x000d4e, 0x000d4e},
	{0x000d54, 0x000d56},
	{0x000d57, 0x000d57},
	{0x000d5f, 0x000d61},
	{0x000d62, 0x000d63},
	{0x000d7a, 0x000d7f},
	{0x000d81, 0x000d81},
	{0x000d82, 0x000d83},
	{0x000d85, 0x000d96},
	{0x000d9a, 0x000db1},
	{0x000db3, 0x000dbb},
	{0x000dbd, 0x000dbd},
	{0x000dc0, 0x000dc6},
	{0x000dcf, 0x000dd1},
	{0x000dd2, 0x000dd4},
	{0x000dd6, 0x000dd6},
	{0x000dd8, 0x000ddf},
	{0x000df2, 0x000df3},
	{0x000e01, 0x000e30},
	{0x000e31, 0x000e31},
	{0x000e32, 0x000e33},
	{0x000e34, 0x000e3a},
	{0x000e40, 0x000e45},
	{0x000e46, 0x000e46},
	{0x000e4d, 0x000e4d},
	{0x000e81, 0x000e82},
	{0x000e84, 0x000e84},
	{0x000e86, 0x000e8a},
	{0x000e8c, 0x000ea3},
	{0x000ea5, 0x000ea5},
	{0x000ea7, 0x000eb0},
	{0x000eb1, 0x000eb1},
	{0x000eb2, 0x000eb3},
	{0x000eb4, 0x000eb9},
	{0x000ebb, 0x000ebc},
	{0x000ebd, 0x000ebd},
	{0x000ec0, 0x000ec4},
	{0x000ec6, 0x000ec6},
	{0x000ecd, 0x000ecd},
	{0x000edc, 0x000edf},
	{0x000f00, 0x000f00},
	{0x000f40, 0x000f47},
	{0x000f49, 0x000f6c},
	{0x000f71, 0x000f7e},
	{0x000f7f, 0x000f7f},
	{0x000f80, 0x000f83},
	{0x000f88, 0x000f8c},
	{0x000f8d, 0x000f97},
	{0x000f99, 0x000fbc},
	{0x001000, 0x00102a},
	{0x00102b, 0x00102c},
	{0x00102d, 0x001030},
	{0x001031, 0x001031},
	{0x001032, 0x001036},
	{0x001038, 0x001038},
	{0x00103b, 0x00103c},
	{0x00103d, 0x00103e},
	{0x00103f, 0x00103f},
	{0x001050, 0x001055},
	{0x001056, 0x001057},
	{0x001058, 0x001059},
	{0x00105a, 0x00105d},
	{0x00105e, 0x001060},
	{0x001061, 0x001061},
	{0x001062, 0x001064},
	{0x001065, 0x001066},
	{0x001067, 0x00106d},
	{0x00106e, 0x001070},
	{0x001071, 0x001074},
	{0x001075, 0x001081},
	{0x001082, 0x001082},
	{0x001083, 0x001084},
	{0x001085, 0x001086},
	{0x001087, 0x00108c},
	{0x00108d, 0x00108d},
	{0x00108e, 0x00108e},
	{0x00108f, 0x00108f},
	{0x00109a, 0x00109c},
	{0x00109d, 0x00109d},
	{0x0010a0, 0x0010c5},
	{0x0010c7, 0x0010c7},
	{0x0010cd, 0x0010cd},
	{0x0010d0, 0x0010fa},
	{0x0010fc, 0x0010fc},
	{0x0010fd, 0x0010ff},
	{0x001100, 0x001248},
	{0x00124a, 0x00124d},
	{0x001250, 0x001256},
	{0x001258, 0x001258},
	{0x00125a, 0x00125d},
	{0x001260, 0x001288},
	{0x00128a, 0x00128d},
	{0x001290, 0x0012b0},
	{0x0012b2, 0x0012b5},
	{0x0012b8, 0x0012be},
	{0x0012c0, 0x0012c0},
	{0x0012c2, 0x0012c5},
	{0x0012c8, 0x0012d6},
	{0x0012d8, 0x001310},
	{0x001312, 0x001315},
	{0x001318, 0x00135a},
	{0x001380, 0x00138f},
	{0x0013a0, 0x0013f5},
	{0x0013f8, 0x0013fd},
	{0x001401, 0x00166c},
	{0x00166f, 0x00167f},
	{0x001681, 0x00169a},
	{0x0016a0, 0x0016ea},
	{0x0016ee, 0x0016f0},
	{0x0016f1, 0x0016f8},
	{0x001700, 0x001711},
	{0x001712, 0x001713},
	{0x00171f, 0x001731},
	{0x001732, 0x001733},
	{0x001740, 0x001751},
	{0x001752, 0x001753},
	{0x001760, 0x00176c},
	{0x00176e, 0x001770},
	{0x001772, 0x001773},
	{0x001780, 0x0017b3},
	{0x0017b6, 0x0017b6},
	{0x0017b7, 0x0017bd},
	{0x0017be, 0x0017c5},
	{0x0017c6, 0x0017c6},
	{0x0017c7, 0x0017c8},
	{0x0017d7, 0x0017d7},
	{0x0017dc, 0x0017dc},
	{0x001820, 0x001842},
	{0x001843, 0x001843},
	{0x001844, 0x001878},
	{0x001880, 0x001884},
	{0x001885, 0x001886},
	{0x001887, 0x0018a8},
	{0x0018a9, 0x0018a9},
	{0x0018aa, 0x0018aa},
	{0x0018b0, 0x0018f5},
	{0x001900, 0x00191e},
	{0x001920, 0x001922},
	{0x001923, 0x001926},
	{0x001927, 0x001928},
	{0x001929, 0x00192b},
	{0x001930, 0x001931},
	{0x001932, 0x001932},
	{0x001933, 0x001938},
	{0x001950, 0x00196d},
	{0x001970, 0x001974},
	{0x001980, 0x0019ab},
	{0x0019b0, 0x0019c9},
	{0x001a00, 0x001a16},
	{0x001a17, 0x001a18},
	{0x001a19, 0x001a1a},
	{0x001a1b, 0x001a1b},
	{0x001a20, 0x001a54},
	{0x001a55, 0x001a55},
	{0x001a56, 0x001a56},
	{0x001a57, 0x001a57},
	{0x001a58, 0x001a5e},
	{0x001a61, 0x001a61},
	{0x001a62, 0x001a62},
	{0x001a63, 0x001a64},
	{0x001a65, 0x001a6c},
	{0x001a6d, 0x001a72},
	{0x001a73, 0x001a74},
	{0x001aa7, 0x001aa7},
	{0x001abf, 0x001ac0},
	{0x001acc, 0x001ace},
	{0x001b00, 0x001b03},
	{0x001b04, 0x001b04},
	{0x001b05, 0x001b33},
	{0x001b35, 0x001b35},
	{0x001b36, 0x001b3a},
	{0x001b3b, 0x001b3b},
	{0x001b3c, 0x001b3c},
	{0x001b3d, 0x001b41},
	{0x001b42, 0x001b42},
	{0x001b43, 0x001b43},
	{0x001b45, 0x001b4c},
	{0x001b80, 0x001b81},
	{0x001b82, 0x001b82},
	{0x001b83, 0x001ba0},
	{0x001ba1, 0x001ba1},
	{0x001ba2, 0x001ba5},
	{0x001ba6, 0x001ba7},
	{0x001ba8, 0x001ba9},
	{0x001bac, 0x001bad},
	{0x001bae, 0x001baf},
	{0x001bba, 0x001be5},
	{0x001be7, 0x001be7},
	{0x001be8, 0x001be9},
	{0x001bea, 0x001bec},
	{0x001bed, 0x001bed},
	{0x001bee, 0x001bee},
	{0x001bef, 0x001bf1},
	{0x001c00, 0x001c23},
	{0x001c24, 0x001c2b},
	{0x001c2c, 0x001c33},
	{0x001c34, 0x001c35},
	{0x001c36, 0x001c36},
	{0x001c4d, 0x001c4f},
	{0x001c5a, 0x001c77},
	{0x001c78, 0x001c7d},
	{0x001c80, 0x001c88},
	{0x001c90, 0x001cba},
	{0x001cbd, 0x001cbf},
	{0x001ce9, 0x001cec},
	{0x001cee, 0x001cf3},
	{0x001cf5, 0x001cf6},
	{0x001cfa, 0x001cfa},
	{0x001d00, 0x001d2b},
	{0x001d2c, 0x001d6a},
	{0x001d6b, 0x001d77},
	{0x001d78, 0x001d78},
	{0x001d79, 0x001d9a},
	{0x001d9b, 0x001dbf},
	{0x001de7, 0x001df4},
	{0x001e00, 0x001f15},
	{0x001f18, 0x001f1d},
	{0x001f20, 0x001f45},
	{0x001f48, 0x001f4d},
	{0x001f50, 0x001f57},
	{0x001f59, 0x001f59},
	{0x001f5b, 0x001f5b},
	{0x001f5d, 0x001f5d},
	{0x001f5f, 0x001f7d},
	{0x001f80, 0x001fb4},
	{0x001fb6, 0x001fbc},
	{0x001fbe, 0x001fbe},
	{0x001fc2, 0x001fc4},
	{0x001fc6, 0x001fcc},
	{0x001fd0, 0x001fd3},
	{0x001fd6, 0x001fdb},
	{0x001fe0, 0x001fec},
	{0x001ff2, 0x001ff4},
	{0x001ff6, 0x001ffc},
	{0x002071, 0x002071},
	{0x00207f, 0x00207f},
	{0x002090, 0x00209c},
	{0x002102, 0x002102},
	{0x002107, 0x002107},
	{0x00210a, 0x002113},
	{0x002115, 0x002115},
	{0x002119, 0x00211d},
	{0x002124, 0x002124},
	{0x002126, 0x002126},
	{0x002128, 0x002128},
	{0x00212a, 0x00212d},
	{0x00212f, 0x002134},
	{0x002135, 0x002138},
	{0x002139, 0x002139},
	{0x00213c, 0x00213f},
	{0x002145, 0x002149},
	{0x00214e, 0x00214e},
	{0x002160, 0x002182},
	{0x002183, 0x002184},
	{0x002185, 0x002188},
	{0x0024b6, 0x0024e9},
	{0x002c00, 0x002c7b},
	{0x002c7c, 0x002c7d},
	{0x002c7e, 0x002ce4},
	{0x002ceb, 0x002cee},
	{0x002cf2, 0x002cf3},
	{0x002d00, 0x002d25},
	{0x002d27, 0x002d27},
	{0x002d2d, 0x002d2d},
	{0x002d30, 0x002d67},
	{0x002d6f, 0x002d6f},
	{0x002d80, 0x002d96},
	{0x002da0, 0x002da6},
	{0x002da8, 0x002dae},
	{0x002db0, 0x002db6},
	{0x002db8, 0x002dbe},
	{0x002dc0, 0x002dc6},
	{0x002dc8, 0x002dce},
	{0x002dd0, 0x002dd6},
	{0x002dd8, 0x002dde},
	{0x002de0, 0x002dff},
	{0x002e2f, 0x002e2f},
	{0x003005, 0x003005},
	{0x003006, 0x003006},
	{0x003007, 0x003007},
	{0x003021, 0x003029},
	{0x003031, 0x003035},
	{0x003038, 0x00303a},
	{0x00303b, 0x00303b},
	{0x00303c, 0x00303c},
	{0x003041, 0x003096},
	{0x00309d, 0x00309e},
	{0x00309f, 0x00309f},
	{0x0030a1, 0x0030fa},
	{0x0030fc, 0x0030fe},
	{0x0030ff, 0x0030ff},
	{0x003105, 0x00312f},
	{0x003131, 0x00318e},
	{0x0031a0, 0x0031bf},
	{0x0031f0, 0x0031ff},
	{0x003400, 0x004dbf},
	{0x004e00, 0x00a014},
	{0x00a015, 0x00a015},
	{0x00a016, 0x00a48c},
	{0x00a4d0, 0x00a4f7},
	{0x00a4f8, 0x00a4fd},
	{0x00a500, 0x00a60b},
	{0x00a60c, 0x00a60c},
	{0x00a610, 0x00a61f},
	{0x00a62a, 0x00a62b},
	{0x00a640, 0x00a66d},
	{0x00a66e, 0x00a66e},
	{0x00a674, 0x00a67b},
	{0x00a67f, 0x00a67f},
	{0x00a680, 0x00a69b},
	{0x00a69c, 0x00a69d},
	{0x00a69e, 0x00a69f},
	{0x00a6a0, 0x00a6e5},
	{0x00a6e6, 0x00a6ef},
	{0x00a717, 0x00a71f},
	{0x00a722, 0x00a76f},
	{0x00a770, 0x00a770},
	{0x00a771, 0x00a787},
	{0x00a788, 0x00a788},
	{0x00a78b, 0x00a78e},
	{0x00a78f, 0x00a78f},
	{0x00a790, 0x00a7ca},
	{0x00a7d0, 0x00a7d1},
	{0x00a7d3, 0x00a7d3},
	{0x00a7d5, 0x00a7d9},
	{0x00a7f2, 0x00a7f4},
	{0x00a7f5, 0x00a7f6},
	{0x00a7f7, 0x00a7f7},
	{0x00a7f8, 0x00a7f9},
	{0x00a7fa, 0x00a7fa},
	{0x00a7fb, 0x00a801},
	{0x00a802, 0x00a802},
	{0x00a803, 0x00a805},
	{0x00a807, 0x00a80a},
	{0x00a80b, 0x00a80b},
	{0x00a80c, 0x00a822},
	{0x00a823, 0x00a824},
	{0x00a825, 0x00a826},
	{0x00a827, 0x00a827},
	{0x00a840, 0x00a873},
	{0x00a880, 0x00a881},
	{0x00a882, 0x00a8b3},
	{0x00a8b4, 0x00a8c3},
	{0x00a8c5, 0x00a8c5},
	{0x00a8f2, 0x00a8f7},
	{0x00a8fb, 0x00a8fb},
	{0x00a8fd, 0x00a8fe},
	{0x00a8ff, 0x00a8ff},
	{0x00a90a, 0x00a925},
	{0x00a926, 0x00a92a},
	{0x00a930, 0x00a946},
	{0x00a947, 0x00a951},
	{0x00a952, 0x00a952},
	{0x00a960, 0x00a97c},
	{0x00a980, 0x00a982},
	{0x00a983, 0x00a983},
	{0x00a984, 0x00a9b2},
	{0x00a9b4, 0x00a9b5},
	{0x00a9b6, 0x00a9b9},
	{0x00a9ba, 0x00a9bb},
	{0x00a9bc, 0x00a9bd},
	{0x00a9be, 0x00a9bf},
	{0x00a9cf, 0x00a9cf},
	{0x00a9e0, 0x00a9e4},
	{0x00a9e5, 0x00a9e5},
	{0x00a9e6, 0x00a9e6},
	{0x00a9e7, 0x00a9ef},
	{0x00a9fa, 0x00a9fe},
	{0x00aa00, 0x00aa28},
	{0x00aa29, 0x00aa2e},
	{0x00aa2f, 0x00aa30},
	{0x00aa31, 0x00aa32},
	{0x00aa33, 0x00aa34},
	{0x00aa35, 0x00aa36},
	{0x00aa40, 0x00aa42},
	{0x00aa43, 0x00aa43},
	{0x00aa44, 0x00aa4b},
	{0x00aa4c, 0x00aa4c},
	{0x00aa4d, 0x00aa4d},
	{0x00aa60, 0x00aa6f},
	{0x00aa70, 0x00aa70},
	{0x00aa71, 0x00aa76},
	{0x00aa7a, 0x00aa7a},
	{0x00aa7b, 0x00aa7b},
	{0x00aa7c, 0x00aa7c},
	{0x00aa7d, 0x00aa7d},
	{0x00aa7e, 0x00aaaf},
	{0x00aab0, 0x00aab0},
	{0x00aab1, 0x00aab1},
	{0x00aab2, 0x00aab4},
	{0x00aab5, 0x00aab6},
	{0x00aab7, 0x00aab8},
	{0x00aab9, 0x00aabd},
	{0x00aabe, 0x00aabe},
	{0x00aac0, 0x00aac0},
	{0x00aac2, 0x00aac2},
	{0x00aadb, 0x00aadc},
	{0x00aadd, 0x00aadd},
	{0x00aae0, 0x00aaea},
	{0x00aaeb, 0x00aaeb},
	{0x00aaec, 0x00aaed},
	{0x00aaee, 0x00aaef},
	{0x00aaf2, 0x00aaf2},
	{0x00aaf3, 0x00aaf4},
	{0x00aaf5, 0x00aaf5},
	{0x00ab01, 0x00ab06},
	{0x00ab09, 0x00ab0e},
	{0x00ab11, 0x00ab16},
	{0x00ab20, 0x00ab26},
	{0x00ab28, 0x00ab2e},
	{0x00ab30, 0x00ab5a},
	{0x00ab5c, 0x00ab5f},
	{0x00ab60, 0x00ab68},
	{0x00ab69, 0x00ab69},
	{0x00ab70, 0x00abbf},
	{0x00abc0, 0x00abe2},
	{0x00abe3, 0x00abe4},
	{0x00abe5, 0x00abe5},
	{0x00abe6, 0x00abe7},
	{0x00abe8, 0x00abe8},
	{0x00abe9, 0x00abea},
	{0x00ac00, 0x00d7a3},
	{0x00d7b0, 0x00d7c6},
	{0x00d7cb, 0x00d7fb},
	{0x00f900, 0x00fa6d},
	{0x00fa70, 0x00fad9},
	{0x00fb00, 0x00fb06},
	{0x00fb13, 0x00fb17},
	{0x00fb1d, 0x00fb1d},
	{0x00fb1e, 0x00fb1e},
	{0x00fb1f, 0x00fb28},
	{0x00fb2a, 0x00fb36},
	{0x00fb38, 0x00fb3c},
	{0x00fb3e, 0x00fb3e},
	{0x00fb40, 0x00fb41},
	{0x00fb43, 0x00fb44},
	{0x00fb46, 0x00fbb1},
	{0x00fbd3, 0x00fd3d},
	{0x00fd50, 0x00fd8f},
	{0x00fd92, 0x00fdc7},
	{0x00fdf0, 0x00fdfb},
	{0x00fe70, 0x00fe74},
	{0x00fe76, 0x00fefc},
	{0x00ff21, 0x00ff3a},
	{0x00ff41, 0x00ff5a},
	{0x00ff66, 0x00ff6f},
	{0x00ff70, 0x00ff70},
	{0x00ff71, 0x00ff9d},
	{0x00ff9e, 0x00ff9f},
	{0x00ffa0, 0x00ffbe},
	{0x00ffc2, 0x00ffc7},
	{0x00ffca, 0x00ffcf},
	{0x00ffd2, 0x00ffd7},
	{0x00ffda, 0x00ffdc},
	{0x010000, 0x01000b},
	{0x01000d, 0x010026},
	{0x010028, 0x01003a},
	{0x01003c, 0x01003d},
	{0x01003f, 0x01004d},
	{0x010050, 0x01005d},
	{0x010080, 0x0100fa},
	{0x010140, 0x010174},
	{0x010280, 0x01029c},
	{0x0102a0, 0x0102d0},
	{0x010300, 0x01031f},
	{0x01032d, 0x010340},
	{0x010341, 0x010341},
	{0x010342, 0x010349},
	{0x01034a, 0x01034a},
	{0x010350, 0x010375},
	{0x010376, 0x01037a},
	{0x010380, 0x01039d},
	{0x0103a0, 0x0103c3},
	{0x0103c8, 0x0103cf},
	{0x0103d1, 0x0103d5},
	{0x010400, 0x01044f},
	{0x010450, 0x01049d},
	{0x0104b0, 0x0104d3},
	{0x0104d8, 0x0104fb},
	{0x010500, 0x010527},
	{0x010530, 0x010563},
	{0x010570, 0x01057a},
	{0x01057c, 0x01058a},
	{0x01058c, 0x010592},
	{0x010594, 0x010595},
	{0x010597, 0x0105a1},
	{0x0105a3, 0x0105b1},
	{0x0105b3, 0x0105b9},
	{0x0105bb, 0x0105bc},
	{0x010600, 0x010736},
	{0x010740, 0x010755},
	{0x010760, 0x010767},
	{0x010780, 0x010785},
	{0x010787, 0x0107b0},
	{0x0107b2, 0x0107ba},
	{0x010800, 0x010805},
	{0x010808, 0x010808},
	{0x01080a, 0x010835},
	{0x010837, 0x010838},
	{0x01083c, 0x01083c},
	{0x01083f, 0x010855},
	{0x010860, 0x010876},
	{0x010880, 0x01089e},
	{0x0108e0, 0x0108f2},
	{0x0108f4, 0x0108f5},
	{0x010900, 0x010915},
	{0x010920, 0x010939},
	{0x010980, 0x0109b7},
	{0x0109be, 0x0109bf},
	{0x010a00, 0x010a00},
	{0x010a01, 0x010a03},
	{0x010a05, 0x010a06},
	{0x010a0c, 0x010a0f},
	{0x010a10, 0x010a13},
	{0x010a15, 0x010a17},
	{0x010a19, 0x010a35},
	{0x010a60, 0x010a7c},
	{0x010a80, 0x010a9c},
	{0x010ac0, 0x010ac7},
	{0x010ac9, 0x010ae4},
	{0x010b00, 0x010b35},
	{0x010b40, 0x010b55},
	{0x010b60, 0x010b72},
	{0x010b80, 0x010b91},
	{0x010c00, 0x010c48},
	{0x010c80, 0x010cb2},
	{0x010cc0, 0x010cf2},
	{0x010d00, 0x010d23},
	{0x010d24, 0x010d27},
	{0x010e80, 0x010ea9},
	{0x010eab, 0x010eac},
	{0x010eb0, 0x010eb1},
	{0x010f00, 0x010f1c},
	{0x010f27, 0x010f27},
	{0x010f30, 0x010f45},
	{0x010f70, 0x010f81},
	{0x010fb0, 0x010fc4},
	{0x010fe0, 0x010ff6},
	{0x011000, 0x011000},
	{0x011001, 0x011001},
	{0x011002, 0x011002},
	{0x011003, 0x011037},
	{0x011038, 0x011045},
	{0x011071, 0x011072},
	{0x011073, 0x011074},
	{0x011075, 0x011075},
	{0x011080, 0x011081},
	{0x011082, 0x011082},
	{0x011083, 0x0110af},
	{0x0110b0, 0x0110b2},
	{0x0110b3, 0x0110b6},
	{0x0110b7, 0x0110b8},
	{0x0110c2, 0x0110c2},
	{0x0110d0, 0x0110e8},
	{0x011100, 0x011102},
	{0x011103, 0x011126},
	{0x011127, 0x01112b},
	{0x01112c, 0x01112c},
	{0x01112d, 0x011132},
	{0x011144, 0x011144},
	{0x011145, 0x011146},
	{0x011147, 0x011147},
	{0x011150, 0x011172},
	{0x011176, 0x011176},
	{0x011180, 0x011181},
	{0x011182, 0x011182},
	{0x011183, 0x0111b2},
	{0x0111b3, 0x0111b5},
	{0x0111b6, 0x0111be},
	{0x0111bf, 0x0111bf},
	{0x0111c1, 0x0111c4},
	{0x0111ce, 0x0111ce},
	{0x0111cf, 0x0111cf},
	{0x0111da, 0x0111da},
	{0x0111dc, 0x0111dc},
	{0x011200, 0x011211},
	{0x011213, 0x01122b},
	{0x01122c, 0x01122e},
	{0x01122f, 0x011231},
	{0x011232, 0x011233},
	{0x011234, 0x011234},
	{0x011237, 0x011237},
	{0x01123e, 0x01123e},
	{0x01123f, 0x011240},
	{0x011241, 0x011241},
	{0x011280, 0x011286},
	{0x011288, 0x011288},
	{0x01128a, 0x01128d},
	{0x01128f, 0x01129d},
	{0x01129f, 0x0112a8},
	{0x0112b0, 0x0112de},
	{0x0112df, 0x0112df},
	{0x0112e0, 0x0112e2},
	{0x0112e3, 0x0112e8},
	{0x011300, 0x011301},
	{0x011302, 0x011303},
	{0x011305, 0x01130c},
	{0x01130f, 0x011310},
	{0x011313, 0x011328},
	{0x01132a, 0x011330},
	{0x011332, 0x011333},
	{0x011335, 0x011339},
	{0x01133d, 0x01133d},
	{0x01133e, 0x01133f},
	{0x011340, 0x011340},
	{0x011341, 0x011344},
	{0x011347, 0x011348},
	{0x01134b, 0x01134c},
	{0x011350, 0x011350},
	{0x011357, 0x011357},
	{0x01135d, 0x011361},
	{0x011362, 0x011363},
	{0x011400, 0x011434},
	{0x011435, 0x011437},
	{0x011438, 0x01143f},
	{0x011440, 0x011441},
	{0x011443, 0x011444},
	{0x011445, 0x011445},
	{0x011447, 0x01144a},
	{0x01145f, 0x011461},
	{0x011480, 0x0114af},
	{0x0114b0, 0x0114b2},
	{0x0114b3, 0x0114b8},
	{0x0114b9, 0x0114b9},
	{0x0114ba, 0x0114ba},
	{0x0114bb, 0x0114be},
	{0x0114bf, 0x0114c0},
	{0x0114c1, 0x0114c1},
	{0x0114c4, 0x0114c5},
	{0x0114c7, 0x0114c7},
	{0x011580, 0x0115ae},
	{0x0115af, 0x0115b1},
	{0x0115b2, 0x0115b5},
	{0x0115b8, 0x0115bb},
	{0x0115bc, 0x0115bd},
	{0x0115be, 0x0115be},
	{0x0115d8, 0x0115db},
	{0x0115dc, 0x0115dd},
	{0x011600, 0x01162f},
	{0x011630, 0x011632},
	{0x011633, 0x01163a},
	{0x01163b, 0x01163c},
	{0x01163d, 0x01163d},
	{0x01163e, 0x01163e},
	{0x011640, 0x011640},
	{0x011644, 0x011644},
	{0x011680, 0x0116aa},
	{0x0116ab, 0x0116ab},
	{0x0116ac, 0x0116ac},
	{0x0116ad, 0x0116ad},
	{0x0116ae, 0x0116af},
	{0x0116b0, 0x0116b5},
	{0x0116b8, 0x0116b8},
	{0x011700, 0x01171a},
	{0x01171d, 0x01171f},
	{0x011720, 0x011721},
	{0x011722, 0x011725},
	{0x011726, 0x011726},
	{0x011727, 0x01172a},
	{0x011740, 0x011746},
	{0x011800, 0x01182b},
	{0x01182c, 0x01182e},
	{0x01182f, 0x011837},
	{0x011838, 0x011838},
	{0x0118a0, 0x0118df},
	{0x0118ff, 0x011906},
	{0x011909, 0x011909},
	{0x01190c, 0x011913},
	{0x011915, 0x011916},
	{0x011918, 0x01192f},
	{0x011930, 0x011935},
	{0x011937, 0x011938},
	{0x01193b, 0x01193c},
	{0x01193f, 0x01193f},
	{0x011940, 0x011940},
	{0x011941, 0x011941},
	{0x011942, 0x011942},
	{0x0119a0, 0x0119a7},
	{0x0119aa, 0x0119d0},
	{0x0119d1, 0x0119d3},
	{0x0119d4, 0x0119d7},
	{0x0119da, 0x0119db},
	{0x0119dc, 0x0119df},
	{0x0119e1, 0x0119e1},
	{0x0119e3, 0x0119e3},
	{0x0119e4, 0x0119e4},
	{0x011a00, 0x011a00},
	{0x011a01, 0x011a0a},
	{0x011a0b, 0x011a32},
	{0x011a35, 0x011a38},
	{0x011a39, 0x011a39},
	{0x011a3a, 0x011a3a},
	{0x011a3b, 0x011a3e},
	{0x011a50, 0x011a50},
	{0x011a51, 0x011a56},
	{0x011a57, 0x011a58},
	{0x011a59, 0x011a5b},
	{0x011a5c, 0x011a89},
	{0x011a8a, 0x011a96},
	{0x011a97, 0x011a97},
	{0x011a9d, 0x011a9d},
	{0x011ab0, 0x011af8},
	{0x011c00, 0x011c08},
	{0x011c0a, 0x011c2e},
	{0x011c2f, 0x011c2f},
	{0x011c30, 0x011c36},
	{0x011c38, 0x011c3d},
	{0x011c3e, 0x011c3e},
	{0x011c40, 0x011c40},
	{0x011c72, 0x011c8f},
	{0x011c92, 0x011ca7},
	{0x011ca9, 0x011ca9},
	{0x011caa, 0x011cb0},
	{0x011cb1, 0x011cb1},
	{0x011cb2, 0x011cb3},
	{0x011cb4, 0x011cb4},
	{0x011cb5, 0x011cb6},
	{0x011d00, 0x011d06},
	{0x011d08, 0x011d09},
	{0x011d0b, 0x011d30},
	{0x011d31, 0x011d36},
	{0x011d3a, 0x011d3a},
	{0x011d3c, 0x011d3d},
	{0x011d3f, 0x011d41},
	{0x011d43, 0x011d43},
	{0x011d46, 0x011d46},
	{0x011d47, 0x011d47},
	{0x011d60, 0x011d65},
	{0x011d67, 0x011d68},
	{0x011d6a, 0x011d89},
	{0x011d8a, 0x011d8e},
	{0x011d90, 0x011d91},
	{0x011d93, 0x011d94},
	{0x011d95, 0x011d95},
	{0x011d96, 0x011d96},
	{0x011d98, 0x011d98},
	{0x011ee0, 0x011ef2},
	{0x011ef3, 0x011ef4},
	{0x011ef5, 0x011ef6},
	{0x011f00, 0x011f01},
	{0x011f02, 0x011f02},
	{0x011f03, 0x011f03},
	{0x011f04, 0x011f10},
	{0x011f12, 0x011f33},
	{0x011f34, 0x011f35},
	{0x011f36, 0x011f3a},
	{0x011f3e, 0x011f3f},
	{0x011f40, 0x011f40},
	{0x011fb0, 0x011fb0},
	{0x012000, 0x012399},
	{0x012400, 0x01246e},
	{0x012480, 0x012543},
	{0x012f90, 0x012ff0},
	{0x013000, 0x01342f},
	{0x013441, 0x013446},
	{0x014400, 0x014646},
	{0x016800, 0x016a38},
	{0x016a40, 0x016a5e},
	{0x016a70, 0x016abe},
	{0x016ad0, 0x016aed},
	{0x016b00, 0x016b2f},
	{0x016b40, 0x016b43},
	{0x016b63, 0x016b77},
	{0x016b7d, 0x016b8f},
	{0x016e40, 0x016e7f},
	{0x016f00, 0x016f4a},
	{0x016f4f, 0x016f4f},
	{0x016f50, 0x016f50},
	{0x016f51, 0x016f87},
	{0x016f8f, 0x016f92},
	{0x016f93, 0x016f9f},
	{0x016fe0, 0x016fe1},
	{0x016fe3, 0x016fe3},
	{0x016ff0, 0x016ff1},
	{0x017000, 0x0187f7},
	{0x018800, 0x018cd5},
	{0x018d00, 0x018d08},
	{0x01aff0, 0x01aff3},
	{0x01aff5, 0x01affb},
	{0x01affd, 0x01affe},
	{0x01b000, 0x01b122},
	{0x01b132, 0x01b132},
	{0x01b150, 0x01b152},
	{0x01b155, 0x01b155},
	{0x01b164, 0x01b167},
	{0x01b170, 0x01b2fb},
	{0x01bc00, 0x01bc6a},
	{0x01bc70, 0x01bc7c},
	{0x01bc80, 0x01bc88},
	{0x01bc90, 0x01bc99},
	{0x01bc9e, 0x01bc9e},
	{0x01d400, 0x01d454},
	{0x01d456, 0x01d49c},
	{0x01d49e, 0x01d49f},
	{0x01d4a2, 0x01d4a2},
	{0x01d4a5, 0x01d4a6},
	{0x01d4a9, 0x01d4ac},
	{0x01d4ae, 0x01d4b9},
	{0x01d4bb, 0x01d4bb},
	{0x01d4bd, 0x01d4c3},
	{0x01d4c5, 0x01d505},
	{0x01d507, 0x01d50a},
	{0x01d50d, 0x01d514},
	{0x01d516, 0x01d51c},
	{0x01d51e, 0x01d539},
	{0x01d53b, 0x01d53e},
	{0x01d540, 0x01d544},
	{0x01d546, 0x01d546},
	{0x01d54a, 0x01d550},
	{0x01d552, 0x01d6a5},
	{0x01d6a8, 0x01d6c0},
	{0x01d6c2, 0x01d6da},
	{0x01d6dc, 0x01d6fa},
	{0x01d6fc, 0x01d714},
	{0x01d716, 0x01d734},
	{0x01d736, 0x01d74e},
	{0x01d750, 0x01d76e},
	{0x01d770, 0x01d788},
	{0x01d78a, 0x01d7a8},
	{0x01d7aa, 0x01d7c2},
	{0x01d7c4, 0x01d7cb},
	{0x01df00, 0x01df09},
	{0x01df0a, 0x01df0a},
	{0x01df0b, 0x01df1e},
	{0x01df25, 0x01df2a},
	{0x01e000, 0x01e006},
	{0x01e008, 0x01e018},
	{0x01e01b, 0x01e021},
	{0x01e023, 0x01e024},
	{0x01e026, 0x01e02a},
	{0x01e030, 0x01e06d},
	{0x01e08f, 0x01e08f},
	{0x01e100, 0x01e12c},
	{0x01e137, 0x01e13d},
	{0x01e14e, 0x01e14e},
	{0x01e290, 0x01e2ad},
	{0x01e2c0, 0x01e2eb},
	{0x01e4d0, 0x01e4ea},
	{0x01e4eb, 0x01e4eb},
	{0x01e7e0, 0x01e7e6},
	{0x01e7e8, 0x01e7eb},
	{0x01e7ed, 0x01e7ee},
	{0x01e7f0, 0x01e7fe},
	{0x01e800, 0x01e8c4},
	{0x01e900, 0x01e943},
	{0x01e947, 0x01e947},
	{0x01e94b, 0x01e94b},
	{0x01ee00, 0x01ee03},
	{0x01ee05, 0x01ee1f},
	{0x01ee21, 0x01ee22},
	{0x01ee24, 0x01ee24},
	{0x01ee27, 0x01ee27},
	{0x01ee29, 0x01ee32},
	{0x01ee34, 0x01ee37},
	{0x01ee39, 0x01ee39},
	{0x01ee3b, 0x01ee3b},
	{0x01ee42, 0x01ee42},
	{0x01ee47, 0x01ee47},
	{0x01ee49, 0x01ee49},
	{0x01ee4b, 0x01ee4b},
	{0x01ee4d, 0x01ee4f},
	{0x01ee51, 0x01ee52},
	{0x01ee54, 0x01ee54},
	{0x01ee57, 0x01ee57},
	{0x01ee59, 0x01ee59},
	{0x01ee5b, 0x01ee5b},
	{0x01ee5d, 0x01ee5d},
	{0x01ee5f, 0x01ee5f},
	{0x01ee61, 0x01ee62},
	{0x01ee64, 0x01ee64},
	{0x01ee67, 0x01ee6a},
	{0x01ee6c, 0x01ee72},
	{0x01ee74, 0x01ee77},
	{0x01ee79, 0x01ee7c},
	{0x01ee7e, 0x01ee7e},
	{0x01ee80, 0x01ee89},
	{0x01ee8b, 0x01ee9b},
	{0x01eea1, 0x01eea3},
	{0x01eea5, 0x01eea9},
	{0x01eeab, 0x01eebb},
	{0x01f130, 0x01f149},
	{0x01f150, 0x01f169},
	{0x01f170, 0x01f189},
	{0x020000, 0x02a6df},
	{0x02a700, 0x02b739},
	{0x02b740, 0x02b81d},
	{0x02b820, 0x02cea1},
	{0x02ceb0, 0x02ebe0},
	{0x02ebf0, 0x02ee5d},
	{0x02f800, 0x02fa1d},
	{0x030000, 0x03134a},
	{0x031350, 0x0323af},
};

/* table of Unicode codepoint ranges of Lowercase characters */
static const pg_unicode_range unicode_lowercase[686] =
{
	{0x000061, 0x00007a},
	{0x0000aa, 0x0000aa},
	{0x0000b5, 0x0000b5},
	{0x0000ba, 0x0000ba},
	{0x0000df, 0x0000f6},
	{0x0000f8, 0x0000ff},
	{0x000101, 0x000101},
	{0x000103, 0x000103},
	{0x000105, 0x000105},
	{0x000107, 0x000107},
	{0x000109, 0x000109},
	{0x00010b, 0x00010b},
	{0x00010d, 0x00010d},
	{0x00010f, 0x00010f},
	{0x000111, 0x000111},
	{0x000113, 0x000113},
	{0x000115, 0x000115},
	{0x000117, 0x000117},
	{0x000119, 0x000119},
	{0x00011b, 0x00011b},
	{0x00011d, 0x00011d},
	{0x00011f, 0x00011f},
	{0x000121, 0x000121},
	{0x000123, 0x000123},
	{0x000125, 0x000125},
	{0x000127, 0x000127},
	{0x000129, 0x000129},
	{0x00012b, 0x00012b},
	{0x00012d, 0x00012d},
	{0x00012f, 0x00012f},
	{0x000131, 0x000131},
	{0x000133, 0x000133},
	{0x000135, 0x000135},
	{0x000137, 0x000138},
	{0x00013a, 0x00013a},
	{0x00013c, 0x00013c},
	{0x00013e, 0x00013e},
	{0x000140, 0x000140},
	{0x000142, 0x000142},
	{0x000144, 0x000144},
	{0x000146, 0x000146},
	{0x000148, 0x000149},
	{0x00014b, 0x00014b},
	{0x00014d, 0x00014d},
	{0x00014f, 0x00014f},
	{0x000151, 0x000151},
	{0x000153, 0x000153},
	{0x000155, 0x000155},
	{0x000157, 0x000157},
	{0x000159, 0x000159},
	{0x00015b, 0x00015b},
	{0x00015d, 0x00015d},
	{0x00015f, 0x00015f},
	{0x000161, 0x000161},
	{0x000163, 0x000163},
	{0x000165, 0x000165},
	{0x000167, 0x000167},
	{0x000169, 0x000169},
	{0x00016b, 0x00016b},
	{0x00016d, 0x00016d},
	{0x00016f, 0x00016f},
	{0x000171, 0x000171},
	{0x000173, 0x000173},
	{0x000175, 0x000175},
	{0x000177, 0x000177},
	{0x00017a, 0x00017a},
	{0x00017c, 0x00017c},
	{0x00017e, 0x000180},
	{0x000183, 0x000183},
	{0x000185, 0x000185},
	{0x000188, 0x000188},
	{0x00018c, 0x00018d},
	{0x000192, 0x000192},
	{0x000195, 0x000195},
	{0x000199, 0x00019b},
	{0x00019e, 0x00019e},
	{0x0001a1, 0x0001a1},
	{0x0001a3, 0x0001a3},
	{0x0001a5, 0x0001a5},
	{0x0001a8, 0x0001a8},
	{0x0001aa, 0x0001ab},
	{0x0001ad, 0x0001ad},
	{0x0001b0, 0x0001b0},
	{0x0001b4, 0x0001b4},
	{0x0001b6, 0x0001b6},
	{0x0001b9, 0x0001ba},
	{0x0001bd, 0x0001bf},
	{0x0001c6, 0x0001c6},
	{0x0001c9, 0x0001c9},
	{0x0001cc, 0x0001cc},
	{0x0001ce, 0x0001ce},
	{0x0001d0, 0x0001d0},
	{0x0001d2, 0x0001d2},
	{0x0001d4, 0x0001d4},
	{0x0001d6, 0x0001d6},
	{0x0001d8, 0x0001d8},
	{0x0001da, 0x0001da},
	{0x0001dc, 0x0001dd},
	{0x0001df, 0x0001df},
	{0x0001e1, 0x0001e1},
	{0x0001e3, 0x0001e3},
	{0x0001e5, 0x0001e5},
	{0x0001e7, 0x0001e7},
	{0x0001e9, 0x0001e9},
	{0x0001eb, 0x0001eb},
	{0x0001ed, 0x0001ed},
	{0x0001ef, 0x0001f0},
	{0x0001f3, 0x0001f3},
	{0x0001f5, 0x0001f5},
	{0x0001f9, 0x0001f9},
	{0x0001fb, 0x0001fb},
	{0x0001fd, 0x0001fd},
	{0x0001ff, 0x0001ff},
	{0x000201, 0x000201},
	{0x000203, 0x000203},
	{0x000205, 0x000205},
	{0x000207, 0x000207},
	{0x000209, 0x000209},
	{0x00020b, 0x00020b},
	{0x00020d, 0x00020d},
	{0x00020f, 0x00020f},
	{0x000211, 0x000211},
	{0x000213, 0x000213},
	{0x000215, 0x000215},
	{0x000217, 0x000217},
	{0x000219, 0x000219},
	{0x00021b, 0x00021b},
	{0x00021d, 0x00021d},
	{0x00021f, 0x00021f},
	{0x000221, 0x000221},
	{0x000223, 0x000223},
	{0x000225, 0x000225},
	{0x000227, 0x000227},
	{0x000229, 0x000229},
	{0x00022b, 0x00022b},
	{0x00022d, 0x00022d},
	{0x00022f, 0x00022f},
	{0x000231, 0x000231},
	{0x000233, 0x000239},
	{0x00023c, 0x00023c},
	{0x00023f, 0x000240},
	{0x000242, 0x000242},
	{0x000247, 0x000247},
	{0x000249, 0x000249},
	{0x00024b, 0x00024b},
	{0x00024d, 0x00024d},
	{0x00024f, 0x000293},
	{0x000295, 0x0002af},
	{0x0002b0, 0x0002b8},
	{0x0002c0, 0x0002c1},
	{0x0002e0, 0x0002e4},
	{0x000345, 0x000345},
	{0x000371, 0x000371},
	{0x000373, 0x000373},
	{0x000377, 0x000377},
	{0x00037a, 0x00037a},
	{0x00037b, 0x00037d},
	{0x000390, 0x000390},
	{0x0003ac, 0x0003ce},
	{0x0003d0, 0x0003d1},
	{0x0003d5, 0x0003d7},
	{0x0003d9, 0x0003d9},
	{0x0003db, 0x0003db},
	{0x0003dd, 0x0003dd},
	{0x0003df, 0x0003df},
	{0x0003e1, 0x0003e1},
	{0x0003e3, 0x0003e3},
	{0x0003e5, 0x0003e5},
	{0x0003e7, 0x0003e7},
	{0x0003e9, 0x0003e9},
	{0x0003eb, 0x0003eb},
	{0x0003ed, 0x0003ed},
	{0x0003ef, 0x0003f3},
	{0x0003f5, 0x0003f5},
	{0x0003f8, 0x0003f8},
	{0x0003fb, 0x0003fc},
	{0x000430, 0x00045f},
	{0x000461, 0x000461},
	{0x000463, 0x000463},
	{0x000465, 0x000465},
	{0x000467, 0x000467},
	{0x000469, 0x000469},
	{0x00046b, 0x00046b},
	{0x00046d, 0x00046d},
	{0x00046f, 0x00046f},
	{0x000471, 0x000471},
	{0x000473, 0x000473},
	{0x000475, 0x000475},
	{0x000477, 0x000477},
	{0x000479, 0x000479},
	{0x00047b, 0x00047b},
	{0x00047d, 0x00047d},
	{0x00047f, 0x00047f},
	{0x000481, 0x000481},
	{0x00048b, 0x00048b},
	{0x00048d, 0x00048d},
	{0x00048f, 0x00048f},
	{0x000491, 0x000491},
	{0x000493, 0x000493},
	{0x000495, 0x000495},
	{0x000497, 0x000497},
	{0x000499, 0x000499},
	{0x00049b, 0x00049b},
	{0x00049d, 0x00049d},
	{0x00049f, 0x00049f},
	{0x0004a1, 0x0004a1},
	{0x0004a3, 0x0004a3},
	{0x0004a5, 0x0004a5},
	{0x0004a7, 0x0004a7},
	{0x0004a9, 0x0004a9},
	{0x0004ab, 0x0004ab},
	{0x0004ad, 0x0004ad},
	{0x0004af, 0x0004af},
	{0x0004b1, 0x0004b1},
	{0x0004b3, 0x0004b3},
	{0x0004b5, 0x0004b5},
	{0x0004b7, 0x0004b7},
	{0x0004b9, 0x0004b9},
	{0x0004bb, 0x0004bb},
	{0x0004bd, 0x0004bd},
	{0x0004bf, 0x0004bf},
	{0x0004c2, 0x0004c2},
	{0x0004c4, 0x0004c4},
	{0x0004c6, 0x0004c6},
	{0x0004c8, 0x0004c8},
	{0x0004ca, 0x0004ca},
	{0x0004cc, 0x0004cc},
	{0x0004ce, 0x0004cf},
	{0x0004d1, 0x0004d1},
	{0x0004d3, 0x0004d3},
	{0x0004d5, 0x0004d5},
	{0x0004d7, 0x0004d7},
	{0x0004d9, 0x0004d9},
	{0x0004db, 0x0004db},
	{0x0004dd, 0x0004dd},
	{0x0004df, 0x0004df},
	{0x0004e1, 0x0004e1},
	{0x0004e3, 0x0004e3},
	{0x0004e5, 0x0004e5},
	{0x0004e7, 0x0004e7},
	{0x0004e9, 0x0004e9},
	{0x0004eb, 0x0004eb},
	{0x0004ed, 0x0004ed},
	{0x0004ef, 0x0004ef},
	{0x0004f1, 0x0004f1},
	{0x0004f3, 0x0004f3},
	{0x0004f5, 0x0004f5},
	{0x0004f7, 0x0004f7},
	{0x0004f9, 0x0004f9},
	{0x0004fb, 0x0004fb},
	{0x0004fd, 0x0004fd},
	{0x0004ff, 0x0004ff},
	{0x000501, 0x000501},
	{0x000503, 0x000503},
	{0x000505, 0x000505},
	{0x000507, 0x000507},
	{0x000509, 0x000509},
	{0x00050b, 0x00050b},
	{0x00050d, 0x00050d},
	{0x00050f, 0x00050f},
	{0x000511, 0x000511},
	{0x000513, 0x000513},
	{0x000515, 0x000515},
	{0x000517, 0x000517},
	{0x000519, 0x000519},
	{0x00051b, 0x00051b},
	{0x00051d, 0x00051d},
	{0x00051f, 0x00051f},
	{0x000521, 0x000521},
	{0x000523, 0x000523},
	{0x000525, 0x000525},
	{0x000527, 0x000527},
	{0x000529, 0x000529},
	{0x00052b, 0x00052b},
	{0x00052d, 0x00052d},
	{0x00052f, 0x00052f},
	{0x000560, 0x000588},
	{0x0010d0, 0x0010fa},
	{0x0010fc, 0x0010fc},
	{0x0010fd, 0x0010ff},
	{0x0013f8, 0x0013fd},
	{0x001c80, 0x001c88},
	{0x001d00, 0x001d2b},
	{0x001d2c, 0x001d6a},
	{0x001d6b, 0x001d77},
	{0x001d78, 0x001d78},
	{0x001d79, 0x001d9a},
	{0x001d9b, 0x001dbf},
	{0x001e01, 0x001e01},
	{0x001e03, 0x001e03},
	{0x001e05, 0x001e05},
	{0x001e07, 0x001e07},
	{0x001e09, 0x001e09},
	{0x001e0b, 0x001e0b},
	{0x001e0d, 0x001e0d},
	{0x001e0f, 0x001e0f},
	{0x001e11, 0x001e11},
	{0x001e13, 0x001e13},
	{0x001e15, 0x001e15},
	{0x001e17, 0x001e17},
	{0x001e19, 0x001e19},
	{0x001e1b, 0x001e1b},
	{0x001e1d, 0x001e1d},
	{0x001e1f, 0x001e1f},
	{0x001e21, 0x001e21},
	{0x001e23, 0x001e23},
	{0x001e25, 0x001e25},
	{0x001e27, 0x001e27},
	{0x001e29, 0x001e29},
	{0x001e2b, 0x001e2b},
	{0x001e2d, 0x001e2d},
	{0x001e2f, 0x001e2f},
	{0x001e31, 0x001e31},
	{0x001e33, 0x001e33},
	{0x001e35, 0x001e35},
	{0x001e37, 0x001e37},
	{0x001e39, 0x001e39},
	{0x001e3b, 0x001e3b},
	{0x001e3d, 0x001e3d},
	{0x001e3f, 0x001e3f},
	{0x001e41, 0x001e41},
	{0x001e43, 0x001e43},
	{0x001e45, 0x001e45},
	{0x001e47, 0x001e47},
	{0x001e49, 0x001e49},
	{0x001e4b, 0x001e4b},
	{0x001e4d, 0x001e4d},
	{0x001e4f, 0x001e4f},
	{0x001e51, 0x001e51},
	{0x001e53, 0x001e53},
	{0x001e55, 0x001e55},
	{0x001e57, 0x001e57},
	{0x001e59, 0x001e59},
	{0x001e5b, 0x001e5b},
	{0x001e5d, 0x001e5d},
	{0x001e5f, 0x001e5f},
	{0x001e61, 0x001e61},
	{0x001e63, 0x001e63},
	{0x001e65, 0x001e65},
	{0x001e67, 0x001e67},
	{0x001e69, 0x001e69},
	{0x001e6b, 0x001e6b},
	{0x001e6d, 0x001e6d},
	{0x001e6f, 0x001e6f},
	{0x001e71, 0x001e71},
	{0x001e73, 0x001e73},
	{0x001e75, 0x001e75},
	{0x001e77, 0x001e77},
	{0x001e79, 0x001e79},
	{0x001e7b, 0x001e7b},
	{0x001e7d, 0x001e7d},
	{0x001e7f, 0x001e7f},
	{0x001e81, 0x001e81},
	{0x001e83, 0x001e83},
	{0x001e85, 0x001e85},
	{0x001e87, 0x001e87},
	{0x001e89, 0x001e89},
	{0x001e8b, 0x001e8b},
	{0x001e8d, 0x001e8d},
	{0x001e8f, 0x001e8f},
	{0x001e91, 0x001e91},
	{0x001e93, 0x001e93},
	{0x001e95, 0x001e9d},
	{0x001e9f, 0x001e9f},
	{0x001ea1, 0x001ea1},
	{0x001ea3, 0x001ea3},
	{0x001ea5, 0x001ea5},
	{0x001ea7, 0x001ea7},
	{0x001ea9, 0x001ea9},
	{0x001eab, 0x001eab},
	{0x001ead, 0x001ead},
	{0x001eaf, 0x001eaf},
	{0x001eb1, 0x001eb1},
	{0x001eb3, 0x001eb3},
	{0x001eb5, 0x001eb5},
	{0x001eb7, 0x001eb7},
	{0x001eb9, 0x001eb9},
	{0x001ebb, 0x001ebb},
	{0x001ebd, 0x001ebd},
	{0x001ebf, 0x001ebf},
	{0x001ec1, 0x001ec1},
	{0x001ec3, 0x001ec3},
	{0x001ec5, 0x001ec5},
	{0x001ec7, 0x001ec7},
	{0x001ec9, 0x001ec9},
	{0x001ecb, 0x001ecb},
	{0x001ecd, 0x001ecd},
	{0x001ecf, 0x001ecf},
	{0x001ed1, 0x001ed1},
	{0x001ed3, 0x001ed3},
	{0x001ed5, 0x001ed5},
	{0x001ed7, 0x001ed7},
	{0x001ed9, 0x001ed9},
	{0x001edb, 0x001edb},
	{0x001edd, 0x001edd},
	{0x001edf, 0x001edf},
	{0x001ee1, 0x001ee1},
	{0x001ee3, 0x001ee3},
	{0x001ee5, 0x001ee5},
	{0x001ee7, 0x001ee7},
	{0x001ee9, 0x001ee9},
	{0x001eeb, 0x001eeb},
	{0x001eed, 0x001eed},
	{0x001eef, 0x001eef},
	{0x001ef1, 0x001ef1},
	{0x001ef3, 0x001ef3},
	{0x001ef5, 0x001ef5},
	{0x001ef7, 0x001ef7},
	{0x001ef9, 0x001ef9},
	{0x001efb, 0x001efb},
	{0x001efd, 0x001efd},
	{0x001eff, 0x001f07},
	{0x001f10, 0x001f15},
	{0x001f20, 0x001f27},
	{0x001f30, 0x001f37},
	{0x001f40, 0x001f45},
	{0x001f50, 0x001f57},
	{0x001f60, 0x001f67},
	{0x001f70, 0x001f7d},
	{0x001f80, 0x001f87},
	{0x001f90, 0x001f97},
	{0x001fa0, 0x001fa7},
	{0x001fb0, 0x001fb4},
	{0x001fb6, 0x001fb7},
	{0x001fbe, 0x001fbe},
	{0x001fc2, 0x001fc4},
	{0x001fc6, 0x001fc7},
	{0x001fd0, 0x001fd3},
	{0x001fd6, 0x001fd7},
	{0x001fe0, 0x001fe7},
	{0x001ff2, 0x001ff4},
	{0x001ff6, 0x001ff7},
	{0x002071, 0x002071},
	{0x00207f, 0x00207f},
	{0x002090, 0x00209c},
	{0x00210a, 0x00210a},
	{0x00210e, 0x00210f},
	{0x002113, 0x002113},
	{0x00212f, 0x00212f},
	{0x002134, 0x002134},
	{0x002139, 0x002139},
	{0x00213c, 0x00213d},
	{0x002146, 0x002149},
	{0x00214e, 0x00214e},
	{0x002170, 0x00217f},
	{0x002184, 0x002184},
	{0x0024d0, 0x0024e9},
	{0x002c30, 0x002c5f},
	{0x002c61, 0x002c61},
	{0x002c65, 0x002c66},
	{0x002c68, 0x002c68},
	{0x002c6a, 0x002c6a},
	{0x002c6c, 0x002c6c},
	{0x002c71, 0x002c71},
	{0x002c73, 0x002c74},
	{0x002c76, 0x002c7b},
	{0x002c7c, 0x002c7d},
	{0x002c81, 0x002c81},
	{0x002c83, 0x002c83},
	{0x002c85, 0x002c85},
	{0x002c87, 0x002c87},
	{0x002c89, 0x002c89},
	{0x002c8b, 0x002c8b},
	{0x002c8d, 0x002c8d},
	{0x002c8f, 0x002c8f},
	{0x002c91, 0x002c91},
	{0x002c93, 0x002c93},
	{0x002c95, 0x002c95},
	{0x002c97, 0x002c97},
	{0x002c99, 0x002c99},
	{0x002c9b, 0x002c9b},
	{0x002c9d, 0x002c9d},
	{0x002c9f, 0x002c9f},
	{0x002ca1, 0x002ca1},
	{0x002ca3, 0x002ca3},
	{0x002ca5, 0x002ca5},
	{0x002ca7, 0x002ca7},
	{0x002ca9, 0x002ca9},
	{0x002cab, 0x002cab},
	{0x002cad, 0x002cad},
	{0x002caf, 0x002caf},
	{0x002cb1, 0x002cb1},
	{0x002cb3, 0x002cb3},
	{0x002cb5, 0x002cb5},
	{0x002cb7, 0x002cb7},
	{0x002cb9, 0x002cb9},
	{0x002cbb, 0x002cbb},
	{0x002cbd, 0x002cbd},
	{0x002cbf, 0x002cbf},
	{0x002cc1, 0x002cc1},
	{0x002cc3, 0x002cc3},
	{0x002cc5, 0x002cc5},
	{0x002cc7, 0x002cc7},
	{0x002cc9, 0x002cc9},
	{0x002ccb, 0x002ccb},
	{0x002ccd, 0x002ccd},
	{0x002ccf, 0x002ccf},
	{0x002cd1, 0x002cd1},
	{0x002cd3, 0x002cd3},
	{0x002cd5, 0x002cd5},
	{0x002cd7, 0x002cd7},
	{0x002cd9, 0x002cd9},
	{0x002cdb, 0x002cdb},
	{0x002cdd, 0x002cdd},
	{0x002cdf, 0x002cdf},
	{0x002ce1, 0x002ce1},
	{0x002ce3, 0x002ce4},
	{0x002cec, 0x002cec},
	{0x002cee, 0x002cee},
	{0x002cf3, 0x002cf3},
	{0x002d00, 0x002d25},
	{0x002d27, 0x002d27},
	{0x002d2d, 0x002d2d},
	{0x00a641, 0x00a641},
	{0x00a643, 0x00a643},
	{0x00a645, 0x00a645},
	{0x00a647, 0x00a647},
	{0x00a649, 0x00a649},
	{0x00a64b, 0x00a64b},
	{0x00a64d, 0x00a64d},
	{0x00a64f, 0x00a64f},
	{0x00a651, 0x00a651},
	{0x00a653, 0x00a653},
	{0x00a655, 0x00a655},
	{0x00a657, 0x00a657},
	{0x00a659, 0x00a659},
	{0x00a65b, 0x00a65b},
	{0x00a65d, 0x00a65d},
	{0x00a65f, 0x00a65f},
	{0x00a661, 0x00a661},
	{0x00a663, 0x00a663},
	{0x00a665, 0x00a665},
	{0x00a667, 0x00a667},
	{0x00a669, 0x00a669},
	{0x00a66b, 0x00a66b},
	{0x00a66d, 0x00a66d},
	{0x00a681, 0x00a681},
	{0x00a683, 0x00a683},
	{0x00a685, 0x00a685},
	{0x00a687, 0x00a687},
	{0x00a689, 0x00a689},
	{0x00a68b, 0x00a68b},
	{0x00a68d, 0x00a68d},
	{0x00a68f, 0x00a68f},
	{0x00a691, 0x00a691},
	{0x00a693, 0x00a693},
	{0x00a695, 0x00a695},
	{0x00a697, 0x00a697},
	{0x00a699, 0x00a699},
	{0x00a69b, 0x00a69b},
	{0x00a69c, 0x00a69d},
	{0x00a723, 0x00a723},
	{0x00a725, 0x00a725},
	{0x00a727, 0x00a727},
	{0x00a729, 0x00a729},
	{0x00a72b, 0x00a72b},
	{0x00a72d, 0x00a72d},
	{0x00a72f, 0x00a731},
	{0x00a733, 0x00a733},
	{0x00a735, 0x00a735},
	{0x00a737, 0x00a737},
	{0x00a739, 0x00a739},
	{0x00a73b, 0x00a73b},
	{0x00a73d, 0x00a73d},
	{0x00a73f, 0x00a73f},
	{0x00a741, 0x00a741},
	{0x00a743, 0x00a743},
	{0x00a745, 0x00a745},
	{0x00a747, 0x00a747},
	{0x00a749, 0x00a749},
	{0x00a74b, 0x00a74b},
	{0x00a74d, 0x00a74d},
	{0x00a74f, 0x00a74f},
	{0x00a751, 0x00a751},
	{0x00a753, 0x00a753},
	{0x00a755, 0x00a755},
	{0x00a757, 0x00a757},
	{0x00a759, 0x00a759},
	{0x00a75b, 0x00a75b},
	{0x00a75d, 0x00a75d},
	{0x00a75f, 0x00a75f},
	{0x00a761, 0x00a761},
	{0x00a763, 0x00a763},
	{0x00a765, 0x00a765},
	{0x00a767, 0x00a767},
	{0x00a769, 0x00a769},
	{0x00a76b, 0x00a76b},
	{0x00a76d, 0x00a76d},
	{0x00a76f, 0x00a76f},
	{0x00a770, 0x00a770},
	{0x00a771, 0x00a778},
	{0x00a77a, 0x00a77a},
	{0x00a77c, 0x00a77c},
	{0x00a77f, 0x00a77f},
	{0x00a781, 0x00a781},
	{0x00a783, 0x00a783},
	{0x00a785, 0x00a785},
	{0x00a787, 0x00a787},
	{0x00a78c, 0x00a78c},
	{0x00a78e, 0x00a78e},
	{0x00a791, 0x00a791},
	{0x00a793, 0x00a795},
	{0x00a797, 0x00a797},
	{0x00a799, 0x00a799},
	{0x00a79b, 0x00a79b},
	{0x00a79d, 0x00a79d},
	{0x00a79f, 0x00a79f},
	{0x00a7a1, 0x00a7a1},
	{0x00a7a3, 0x00a7a3},
	{0x00a7a5, 0x00a7a5},
	{0x00a7a7, 0x00a7a7},
	{0x00a7a9, 0x00a7a9},
	{0x00a7af, 0x00a7af},
	{0x00a7b5, 0x00a7b5},
	{0x00a7b7, 0x00a7b7},
	{0x00a7b9, 0x00a7b9},
	{0x00a7bb, 0x00a7bb},
	{0x00a7bd, 0x00a7bd},
	{0x00a7bf, 0x00a7bf},
	{0x00a7c1, 0x00a7c1},
	{0x00a7c3, 0x00a7c3},
	{0x00a7c8, 0x00a7c8},
	{0x00a7ca, 0x00a7ca},
	{0x00a7d1, 0x00a7d1},
	{0x00a7d3, 0x00a7d3},
	{0x00a7d5, 0x00a7d5},
	{0x00a7d7, 0x00a7d7},
	{0x00a7d9, 0x00a7d9},
	{0x00a7f2, 0x00a7f4},
	{0x00a7f6, 0x00a7f6},
	{0x00a7f8, 0x00a7f9},
	{0x00a7fa, 0x00a7fa},
	{0x00ab30, 0x00ab5a},
	{0x00ab5c, 0x00ab5f},
	{0x00ab60, 0x00ab68},
	{0x00ab69, 0x00ab69},
	{0x00ab70, 0x00abbf},
	{0x00fb00, 0x00fb06},
	{0x00fb13, 0x00fb17},
	{0x00ff41, 0x00ff5a},
	{0x010428, 0x01044f},
	{0x0104d8, 0x0104fb},
	{0x010597, 0x0105a1},
	{0x0105a3, 0x0105b1},
	{0x0105b3, 0x0105b9},
	{0x0105bb, 0x0105bc},
	{0x010780, 0x010780},
	{0x010783, 0x010785},
	{0x010787, 0x0107b0},
	{0x0107b2, 0x0107ba},
	{0x010cc0, 0x010cf2},
	{0x0118c0, 0x0118df},
	{0x016e60, 0x016e7f},
	{0x01d41a, 0x01d433},
	{0x01d44e, 0x01d454},
	{0x01d456, 0x01d467},
	{0x01d482, 0x01d49b},
	{0x01d4b6, 0x01d4b9},
	{0x01d4bb, 0x01d4bb},
	{0x01d4bd, 0x01d4c3},
	{0x01d4c5, 0x01d4cf},
	{0x01d4ea, 0x01d503},
	{0x01d51e, 0x01d537},
	{0x01d552, 0x01d56b},
	{0x01d586, 0x01d59f},
	{0x01d5ba, 0x01d5d3},
	{0x01d5ee, 0x01d607},
	{0x01d622, 0x01d63b},
	{0x01d656, 0x01d66f},
	{0x01d68a, 0x01d6a5},
	{0x01d6c2, 0x01d6da},
	{0x01d6dc, 0x01d6e1},
	{0x01d6fc, 0x01d714},
	{0x01d716, 0x01d71b},
	{0x01d736, 0x01d74e},
	{0x01d750, 0x01d755},
	{0x01d770, 0x01d788},
	{0x01d78a, 0x01d78f},
	{0x01d7aa, 0x01d7c2},
	{0x01d7c4, 0x01d7c9},
	{0x01d7cb, 0x01d7cb},
	{0x01df00, 0x01df09},
	{0x01df0b, 0x01df1e},
	{0x01df25, 0x01df2a},
	{0x01e030, 0x01e06d},
	{0x01e922, 0x01e943},
};

/* table of Unicode codepoint ranges of Uppercase characters */
static const pg_unicode_range unicode_uppercase[651] =
{
	{0x000041, 0x00005a},
	{0x0000c0, 0x0000d6},
	{0x0000d8, 0x0000de},
	{0x000100, 0x000100},
	{0x000102, 0x000102},
	{0x000104, 0x000104},
	{0x000106, 0x000106},
	{0x000108, 0x000108},
	{0x00010a, 0x00010a},
	{0x00010c, 0x00010c},
	{0x00010e, 0x00010e},
	{0x000110, 0x000110},
	{0x000112, 0x000112},
	{0x000114, 0x000114},
	{0x000116, 0x000116},
	{0x000118, 0x000118},
	{0x00011a, 0x00011a},
	{0x00011c, 0x00011c},
	{0x00011e, 0x00011e},
	{0x000120, 0x000120},
	{0x000122, 0x000122},
	{0x000124, 0x000124},
	{0x000126, 0x000126},
	{0x000128, 0x000128},
	{0x00012a, 0x00012a},
	{0x00012c, 0x00012c},
	{0x00012e, 0x00012e},
	{0x000130, 0x000130},
	{0x000132, 0x000132},
	{0x000134, 0x000134},
	{0x000136, 0x000136},
	{0x000139, 0x000139},
	{0x00013b, 0x00013b},
	{0x00013d, 0x00013d},
	{0x00013f, 0x00013f},
	{0x000141, 0x000141},
	{0x000143, 0x000143},
	{0x000145, 0x000145},
	{0x000147, 0x000147},
	{0x00014a, 0x00014a},
	{0x00014c, 0x00014c},
	{0x00014e, 0x00014e},
	{0x000150, 0x000150},
	{0x000152, 0x000152},
	{0x000154, 0x000154},
	{0x000156, 0x000156},
	{0x000158, 0x000158},
	{0x00015a, 0x00015a},
	{0x00015c, 0x00015c},
	{0x00015e, 0x00015e},
	{0x000160, 0x000160},
	{0x000162, 0x000162},
	{0x000164, 0x000164},
	{0x000166, 0x000166},
	{0x000168, 0x000168},
	{0x00016a, 0x00016a},
	{0x00016c, 0x00016c},
	{0x00016e, 0x00016e},
	{0x000170, 0x000170},
	{0x000172, 0x000172},
	{0x000174, 0x000174},
	{0x000176, 0x000176},
	{0x000178, 0x000179},
	{0x00017b, 0x00017b},
	{0x00017d, 0x00017d},
	{0x000181, 0x000182},
	{0x000184, 0x000184},
	{0x000186, 0x000187},
	{0x000189, 0x00018b},
	{0x00018e, 0x000191},
	{0x000193, 0x000194},
	{0x000196, 0x000198},
	{0x00019c, 0x00019d},
	{0x00019f, 0x0001a0},
	{0x0001a2, 0x0001a2},
	{0x0001a4, 0x0001a4},
	{0x0001a6, 0x0001a7},
	{0x0001a9, 0x0001a9},
	{0x0001ac, 0x0001ac},
	{0x0001ae, 0x0001af},
	{0x0001b1, 0x0001b3},
	{0x0001b5, 0x0001b5},
	{0x0001b7, 0x0001b8},
	{0x0001bc, 0x0001bc},
	{0x0001c4, 0x0001c4},
	{0x0001c7, 0x0001c7},
	{0x0001ca, 0x0001ca},
	{0x0001cd, 0x0001cd},
	{0x0001cf, 0x0001cf},
	{0x0001d1, 0x0001d1},
	{0x0001d3, 0x0001d3},
	{0x0001d5, 0x0001d5},
	{0x0001d7, 0x0001d7},
	{0x0001d9, 0x0001d9},
	{0x0001db, 0x0001db},
	{0x0001de, 0x0001de},
	{0x0001e0, 0x0001e0},
	{0x0001e2, 0x0001e2},
	{0x0001e4, 0x0001e4},
	{0x0001e6, 0x0001e6},
	{0x0001e8, 0x0001e8},
	{0x0001ea, 0x0001ea},
	{0x0001ec, 0x0001ec},
	{0x0001ee, 0x0001ee},
	{0x0001f1, 0x0001f1},
	{0x0001f4, 0x0001f4},
	{0x0001f6, 0x0001f8},
	{0x0001fa, 0x0001fa},
	{0x0001fc, 0x0001fc},
	{0x0001fe, 0x0001fe},
	{0x000200, 0x000200},
	{0x000202, 0x000202},
	{0x000204, 0x000204},
	{0x000206, 0x000206},
	{0x000208, 0x000208},
	{0x00020a, 0x00020a},
	{0x00020c, 0x00020c},
	{0x00020e, 0x00020e},
	{0x000210, 0x000210},
	{0x000212, 0x000212},
	{0x000214, 0x000214},
	{0x000216, 0x000216},
	{0x000218, 0x000218},
	{0x00021a, 0x00021a},
	{0x00021c, 0x00021c},
	{0x00021e, 0x00021e},
	{0x000220, 0x000220},
	{0x000222, 0x000222},
	{0x000224, 0x000224},
	{0x000226, 0x000226},
	{0x000228, 0x000228},
	{0x00022a, 0x00022a},
	{0x00022c, 0x00022c},
	{0x00022e, 0x00022e},
	{0x000230, 0x000230},
	{0x000232, 0x000232},
	{0x00023a, 0x00023b},
	{0x00023d, 0x00023e},
	{0x000241, 0x000241},
	{0x000243, 0x000246},
	{0x000248, 0x000248},
	{0x00024a, 0x00024a},
	{0x00024c, 0x00024c},
	{0x00024e, 0x00024e},
	{0x000370, 0x000370},
	{0x000372, 0x000372},
	{0x000376, 0x000376},
	{0x00037f, 0x00037f},
	{0x000386, 0x000386},
	{0x000388, 0x00038a},
	{0x00038c, 0x00038c},
	{0x00038e, 0x00038f},
	{0x000391, 0x0003a1},
	{0x0003a3, 0x0003ab},
	{0x0003cf, 0x0003cf},
	{0x0003d2, 0x0003d4},
	{0x0003d8, 0x0003d8},
	{0x0003da, 0x0003da},
	{0x0003dc, 0x0003dc},
	{0x0003de, 0x0003de},
	{0x0003e0, 0x0003e0},
	{0x0003e2, 0x0003e2},
	{0x0003e4, 0x0003e4},
	{0x0003e6, 0x0003e6},
	{0x0003e8, 0x0003e8},
	{0x0003ea, 0x0003ea},
	{0x0003ec, 0x0003ec},
	{0x0003ee, 0x0003ee},
	{0x0003f4, 0x0003f4},
	{0x0003f7, 0x0003f7},
	{0x0003f9, 0x0003fa},
	{0x0003fd, 0x00042f},
	{0x000460, 0x000460},
	{0x000462, 0x000462},
	{0x000464, 0x000464},
	{0x000466, 0x000466},
	{0x000468, 0x000468},
	{0x00046a, 0x00046a},
	{0x00046c, 0x00046c},
	{0x00046e, 0x00046e},
	{0x000470, 0x000470},
	{0x000472, 0x000472},
	{0x000474, 0x000474},
	{0x000476, 0x000476},
	{0x000478, 0x000478},
	{0x00047a, 0x00047a},
	{0x00047c, 0x00047c},
	{0x00047e, 0x00047e},
	{0x000480, 0x000480},
	{0x00048a, 0x00048a},
	{0x00048c, 0x00048c},
	{0x00048e, 0x00048e},
	{0x000490, 0x000490},
	{0x000492, 0x000492},
	{0x000494, 0x000494},
	{0x000496, 0x000496},
	{0x000498, 0x000498},
	{0x00049a, 0x00049a},
	{0x00049c, 0x00049c},
	{0x00049e, 0x00049e},
	{0x0004a0, 0x0004a0},
	{0x0004a2, 0x0004a2},
	{0x0004a4, 0x0004a4},
	{0x0004a6, 0x0004a6},
	{0x0004a8, 0x0004a8},
	{0x0004aa, 0x0004aa},
	{0x0004ac, 0x0004ac},
	{0x0004ae, 0x0004ae},
	{0x0004b0, 0x0004b0},
	{0x0004b2, 0x0004b2},
	{0x0004b4, 0x0004b4},
	{0x0004b6, 0x0004b6},
	{0x0004b8, 0x0004b8},
	{0x0004ba, 0x0004ba},
	{0x0004bc, 0x0004bc},
	{0x0004be, 0x0004be},
	{0x0004c0, 0x0004c1},
	{0x0004c3, 0x0004c3},
	{0x0004c5, 0x0004c5},
	{0x0004c7, 0x0004c7},
	{0x0004c9, 0x0004c9},
	{0x0004cb, 0x0004cb},
	{0x0004cd, 0x0004cd},
	{0x0004d0, 0x0004d0},
	{0x0004d2, 0x0004d2},
	{0x0004d4, 0x0004d4},
	{0x0004d6, 0x0004d6},
	{0x0004d8, 0x0004d8},
	{0x0004da, 0x0004da},
	{0x0004dc, 0x0004dc},
	{0x0004de, 0x0004de},
	{0x0004e0, 0x0004e0},
	{0x0004e2, 0x0004e2},
	{0x0004e4, 0x0004e4},
	{0x0004e6, 0x0004e6},
	{0x0004e8, 0x0004e8},
	{0x0004ea, 0x0004ea},
	{0x0004ec, 0x0004ec},
	{0x0004ee, 0x0004ee},
	{0x0004f0, 0x0004f0},
	{0x0004f2, 0x0004f2},
	{0x0004f4, 0x0004f4},
	{0x0004f6, 0x0004f6},
	{0x0004f8, 0x0004f8},
	{0x0004fa, 0x0004fa},
	{0x0004fc, 0x0004fc},
	{0x0004fe, 0x0004fe},
	{0x000500, 0x000500},
	{0x000502, 0x000502},
	{0x000504, 0x000504},
	{0x000506, 0x000506},
	{0x000508, 0x000508},
	{0x00050a, 0x00050a},
	{0x00050c, 0x00050c},
	{0x00050e, 0x00050e},
	{0x000510, 0x000510},
	{0x000512, 0x000512},
	{0x000514, 0x000514},
	{0x000516, 0x000516},
	{0x000518, 0x000518},
	{0x00051a, 0x00051a},
	{0x00051c, 0x00051c},
	{0x00051e, 0x00051e},
	{0x000520, 0x000520},
	{0x000522, 0x000522},
	{0x000524, 0x000524},
	{0x000526, 0x000526},
	{0x000528, 0x000528},
	{0x00052a, 0x00052a},
	{0x00052c, 0x00052c},
	{0x00052e, 0x00052e},
	{0x000531, 0x000556},
	{0x0010a0, 0x0010c5},
	{0x0010c7, 0x0010c7},
	{0x0010cd, 0x0010cd},
	{0x0013a0, 0x0013f5},
	{0x001c90, 0x001cba},
	{0x001cbd, 0x001cbf},
	{0x001e00, 0x001e00},
	{0x001e02, 0x001e02},
	{0x001e04, 0x001e04},
	{0x001e06, 0x001e06},
	{0x001e08, 0x001e08},
	{0x001e0a, 0x001e0a},
	{0x001e0c, 0x001e0c},
	{0x001e0e, 0x001e0e},
	{0x001e10, 0x001e10},
	{0x001e12, 0x001e12},
	{0x001e14, 0x001e14},
	{0x001e16, 0x001e16},
	{0x001e18, 0x001e18},
	{0x001e1a, 0x001e1a},
	{0x001e1c, 0x001e1c},
	{0x001e1e, 0x001e1e},
	{0x001e20, 0x001e20},
	{0x001e22, 0x001e22},
	{0x001e24, 0x001e24},
	{0x001e26, 0x001e26},
	{0x001e28, 0x001e28},
	{0x001e2a, 0x001e2a},
	{0x001e2c, 0x001e2c},
	{0x001e2e, 0x001e2e},
	{0x001e30, 0x001e30},
	{0x001e32, 0x001e32},
	{0x001e34, 0x001e34},
	{0x001e36, 0x001e36},
	{0x001e38, 0x001e38},
	{0x001e3a, 0x001e3a},
	{0x001e3c, 0x001e3c},
	{0x001e3e, 0x001e3e},
	{0x001e40, 0x001e40},
	{0x001e42, 0x001e42},
	{0x001e44, 0x001e44},
	{0x001e46, 0x001e46},
	{0x001e48, 0x001e48},
	{0x001e4a, 0x001e4a},
	{0x001e4c, 0x001e4c},
	{0x001e4e, 0x001e4e},
	{0x001e50, 0x001e50},
	{0x001e52, 0x001e52},
	{0x001e54, 0x001e54},
	{0x001e56, 0x001e56},
	{0x001e58, 0x001e58},
	{0x001e5a, 0x001e5a},
	{0x001e5c, 0x001e5c},
	{0x001e5e, 0x001e5e},
	{0x001e60, 0x001e60},
	{0x001e62, 0x001e62},
	{0x001e64, 0x001e64},
	{0x001e66, 0x001e66},
	{0x001e68, 0x001e68},
	{0x001e6a, 0x001e6a},
	{0x001e6c, 0x001e6c},
	{0x001e6e, 0x001e6e},
	{0x001e70, 0x001e70},
	{0x001e72, 0x001e72},
	{0x001e74, 0x001e74},
	{0x001e76, 0x001e76},
	{0x001e78, 0x001e78},
	{0x001e7a, 0x001e7a},
	{0x001e7c, 0x001e7c},
	{0x001e7e, 0x001e7e},
	{0x001e80, 0x001e80},
	{0x001e82, 0x001e82},
	{0x001e84, 0x001e84},
	{0x001e86, 0x001e86},
	{0x001e88, 0x001e88},
	{0x001e8a, 0x001e8a},
	{0x001e8c, 0x001e8c},
	{0x001e8e, 0x001e8e},
	{0x001e90, 0x001e90},
	{0x001e92, 0x001e92},
	{0x001e94, 0x001e94},
	{0x001e9e, 0x001e9e},
	{0x001ea0, 0x001ea0},
	{0x001ea2, 0x001ea2},
	{0x001ea4, 0x001ea4},
	{0x001ea6, 0x001ea6},
	{0x001ea8, 0x001ea8},
	{0x001eaa, 0x001eaa},
	{0x001eac, 0x001eac},
	{0x001eae, 0x001eae},
	{0x001eb0, 0x001eb0},
	{0x001eb2, 0x001eb2},
	{0x001eb4, 0x001eb4},
	{0x001eb6, 0x001eb6},
	{0x001eb8, 0x001eb8},
	{0x001eba, 0x001eba},
	{0x001ebc, 0x001ebc},
	{0x001ebe, 0x001ebe},
	{0x001ec0, 0x001ec0},
	{0x001ec2, 0x001ec2},
	{0x001ec4, 0x001ec4},
	{0x001ec6, 0x001ec6},
	{0x001ec8, 0x001ec8},
	{0x001eca, 0x001eca},
	{0x001ecc, 0x001ecc},
	{0x001ece, 0x001ece},
	{0x001ed0, 0x001ed0},
	{0x001ed2, 0x001ed2},
	{0x001ed4, 0x001ed4},
	{0x001ed6, 0x001ed6},
	{0x001ed8, 0x001ed8},
	{0x001eda, 0x001eda},
	{0x001edc, 0x001edc},
	{0x001ede, 0x001ede},
	{0x001ee0, 0x001ee0},
	{0x001ee2, 0x001ee2},
	{0x001ee4, 0x001ee4},
	{0x001ee6, 0x001ee6},
	{0x001ee8, 0x001ee8},
	{0x001eea, 0x001eea},
	{0x001eec, 0x001eec},
	{0x001eee, 0x001eee},
	{0x001ef0, 0x001ef0},
	{0x001ef2, 0x001ef2},
	{0x001ef4, 0x001ef4},
	{0x001ef6, 0x001ef6},
	{0x001ef8, 0x001ef8},
	{0x001efa, 0x001efa},
	{0x001efc, 0x001efc},
	{0x001efe, 0x001efe},
	{0x001f08, 0x001f0f},
	{0x001f18, 0x001f1d},
	{0x001f28, 0x001f2f},
	{0x001f38, 0x001f3f},
	{0x001f48, 0x001f4d},
	{0x001f59, 0x001f59},
	{0x001f5b, 0x001f5b},
	{0x001f5d, 0x001f5d},
	{0x001f5f, 0x001f5f},
	{0x001f68, 0x001f6f},
	{0x001fb8, 0x001fbb},
	{0x001fc8, 0x001fcb},
	{0x001fd8, 0x001fdb},
	{0x001fe8, 0x001fec},
	{0x001ff8, 0x001ffb},
	{0x002102, 0x002102},
	{0x002107, 0x002107},
	{0x00210b, 0x00210d},
	{0x002110, 0x002112},
	{0x002115, 0x002115},
	{0x002119, 0x00211d},
	{0x002124, 0x002124},
	{0x002126, 0x002126},
	{0x002128, 0x002128},
	{0x00212a, 0x00212d},
	{0x002130, 0x002133},
	{0x00213e, 0x00213f},
	{0x002145, 0x002145},
	{0x002160, 0x00216f},
	{0x002183, 0x002183},
	{0x0024b6, 0x0024cf},
	{0x002c00, 0x002c2f},
	{0x002c60, 0x002c60},
	{0x002c62, 0x002c64},
	{0x002c67, 0x002c67},
	{0x002c69, 0x002c69},
	{0x002c6b, 0x002c6b},
	{0x002c6d, 0x002c70},
	{0x002c72, 0x002c72},
	{0x002c75, 0x002c75},
	{0x002c7e, 0x002c80},
	{0x002c82, 0x002c82},
	{0x002c84, 0x002c84},
	{0x002c86, 0x002c86},
	{0x002c88, 0x002c88},
	{0x002c8a, 0x002c8a},
	{0x002c8c, 0x002c8c},
	{0x002c8e, 0x002c8e},
	{0x002c90, 0x002c90},
	{0x002c92, 0x002c92},
	{0x002c94, 0x002c94},
	{0x002c96, 0x002c96},
	{0x002c98, 0x002c98},
	{0x002c9a, 0x002c9a},
	{0x002c9c, 0x002c9c},
	{0x002c9e, 0x002c9e},
	{0x002ca0, 0x002ca0},
	{0x002ca2, 0x002ca2},
	{0x002ca4, 0x002ca4},
	{0x002ca6, 0x002ca6},
	{0x002ca8, 0x002ca8},
	{0x002caa, 0x002caa},
	{0x002cac, 0x002cac},
	{0x002cae, 0x002cae},
	{0x002cb0, 0x002cb0},
	{0x002cb2, 0x002cb2},
	{0x002cb4, 0x002cb4},
	{0x002cb6, 0x002cb6},
	{0x002cb8, 0x002cb8},
	{0x002cba, 0x002cba},
	{0x002cbc, 0x002cbc},
	{0x002cbe, 0x002cbe},
	{0x002cc0, 0x002cc0},
	{0x002cc2, 0x002cc2},
	{0x002cc4, 0x002cc4},
	{0x002cc6, 0x002cc6},
	{0x002cc8, 0x002cc8},
	{0x002cca, 0x002cca},
	{0x002ccc, 0x002ccc},
	{0x002cce, 0x002cce},
	{0x002cd0, 0x002cd0},
	{0x002cd2, 0x002cd2},
	{0x002cd4, 0x002cd4},
	{0x002cd6, 0x002cd6},
	{0x002cd8, 0x002cd8},
	{0x002cda, 0x002cda},
	{0x002cdc, 0x002cdc},
	{0x002cde, 0x002cde},
	{0x002ce0, 0x002ce0},
	{0x002ce2, 0x002ce2},
	{0x002ceb, 0x002ceb},
	{0x002ced, 0x002ced},
	{0x002cf2, 0x002cf2},
	{0x00a640, 0x00a640},
	{0x00a642, 0x00a642},
	{0x00a644, 0x00a644},
	{0x00a646, 0x00a646},
	{0x00a648, 0x00a648},
	{0x00a64a, 0x00a64a},
	{0x00a64c, 0x00a64c},
	{0x00a64e, 0x00a64e},
	{0x00a650, 0x00a650},
	{0x00a652, 0x00a652},
	{0x00a654, 0x00a654},
	{0x00a656, 0x00a656},
	{0x00a658, 0x00a658},
	{0x00a65a, 0x00a65a},
	{0x00a65c, 0x00a65c},
	{0x00a65e, 0x00a65e},
	{0x00a660, 0x00a660},
	{0x00a662, 0x00a662},
	{0x00a664, 0x00a664},
	{0x00a666, 0x00a666},
	{0x00a668, 0x00a668},
	{0x00a66a, 0x00a66a},
	{0x00a66c, 0x00a66c},
	{0x00a680, 0x00a680},
	{0x00a682, 0x00a682},
	{0x00a684, 0x00a684},
	{0x00a686, 0x00a686},
	{0x00a688, 0x00a688},
	{0x00a68a, 0x00a68a},
	{0x00a68c, 0x00a68c},
	{0x00a68e, 0x00a68e},
	{0x00a690, 0x00a690},
	{0x00a692, 0x00a692},
	{0x00a694, 0x00a694},
	{0x00a696, 0x00a696},
	{0x00a698, 0x00a698},
	{0x00a69a, 0x00a69a},
	{0x00a722, 0x00a722},
	{0x00a724, 0x00a724},
	{0x00a726, 0x00a726},
	{0x00a728, 0x00a728},
	{0x00a72a, 0x00a72a},
	{0x00a72c, 0x00a72c},
	{0x00a72e, 0x00a72e},
	{0x00a732, 0x00a732},
	{0x00a734, 0x00a734},
	{0x00a736, 0x00a736},
	{0x00a738, 0x00a738},
	{0x00a73a, 0x00a73a},
	{0x00a73c, 0x00a73c},
	{0x00a73e, 0x00a73e},
	{0x00a740, 0x00a740},
	{0x00a742, 0x00a742},
	{0x00a744, 0x00a744},
	{0x00a746, 0x00a746},
	{0x00a748, 0x00a748},
	{0x00a74a, 0x00a74a},
	{0x00a74c, 0x00a74c},
	{0x00a74e, 0x00a74e},
	{0x00a750, 0x00a750},
	{0x00a752, 0x00a752},
	{0x00a754, 0x00a754},
	{0x00a756, 0x00a756},
	{0x00a758, 0x00a758},
	{0x00a75a, 0x00a75a},
	{0x00a75c, 0x00a75c},
	{0x00a75e, 0x00a75e},
	{0x00a760, 0x00a760},
	{0x00a762, 0x00a762},
	{0x00a764, 0x00a764},
	{0x00a766, 0x00a766},
	{0x00a768, 0x00a768},
	{0x00a76a, 0x00a76a},
	{0x00a76c, 0x00a76c},
	{0x00a76e, 0x00a76e},
	{0x00a779, 0x00a779},
	{0x00a77b, 0x00a77b},
	{0x00a77d, 0x00a77e},
	{0x00a780, 0x00a780},
	{0x00a782, 0x00a782},
	{0x00a784, 0x00a784},
	{0x00a786, 0x00a786},
	{0x00a78b, 0x00a78b},
	{0x00a78d, 0x00a78d},
	{0x00a790, 0x00a790},
	{0x00a792, 0x00a792},
	{0x00a796, 0x00a796},
	{0x00a798, 0x00a798},
	{0x00a79a, 0x00a79a},
	{0x00a79c, 0x00a79c},
	{0x00a79e, 0x00a79e},
	{0x00a7a0, 0x00a7a0},
	{0x00a7a2, 0x00a7a2},
	{0x00a7a4, 0x00a7a4},
	{0x00a7a6, 0x00a7a6},
	{0x00a7a8, 0x00a7a8},
	{0x00a7aa, 0x00a7ae},
	{0x00a7b0, 0x00a7b4},
	{0x00a7b6, 0x00a7b6},
	{0x00a7b8, 0x00a7b8},
	{0x00a7ba, 0x00a7ba},
	{0x00a7bc, 0x00a7bc},
	{0x00a7be, 0x00a7be},
	{0x00a7c0, 0x00a7c0},
	{0x00a7c2, 0x00a7c2},
	{0x00a7c4, 0x00a7c7},
	{0x00a7c9, 0x00a7c9},
	{0x00a7d0, 0x00a7d0},
	{0x00a7d6, 0x00a7d6},
	{0x00a7d8, 0x00a7d8},
	{0x00a7f5, 0x00a7f5},
	{0x00ff21, 0x00ff3a},
	{0x010400, 0x010427},
	{0x0104b0, 0x0104d3},
	{0x010570, 0x01057a},
	{0x01057c, 0x01058a},
	{0x01058c, 0x010592},
	{0x010594, 0x010595},
	{0x010c80, 0x010cb2},
	{0x0118a0, 0x0118bf},
	{0x016e40, 0x016e5f},
	{0x01d400, 0x01d419},
	{0x01d434, 0x01d44d},
	{0x01d468, 0x01d481},
	{0x01d49c, 0x01d49c},
	{0x01d49e, 0x01d49f},
	{0x01d4a2, 0x01d4a2},
	{0x01d4a5, 0x01d4a6},
	{0x01d4a9, 0x01d4ac},
	{0x01d4ae, 0x01d4b5},
	{0x01d4d0, 0x01d4e9},
	{0x01d504, 0x01d505},
	{0x01d507, 0x01d50a},
	{0x01d50d, 0x01d514},
	{0x01d516, 0x01d51c},
	{0x01d538, 0x01d539},
	{0x01d53b, 0x01d53e},
	{0x01d540, 0x01d544},
	{0x01d546, 0x01d546},
	{0x01d54a, 0x01d550},
	{0x01d56c, 0x01d585},
	{0x01d5a0, 0x01d5b9},
	{0x01d5d4, 0x01d5ed},
	{0x01d608, 0x01d621},
	{0x01d63c, 0x01d655},
	{0x01d670, 0x01d689},
	{0x01d6a8, 0x01d6c0},
	{0x01d6e2, 0x01d6fa},
	{0x01d71c, 0x01d734},
	{0x01d756, 0x01d76e},
	{0x01d790, 0x01d7a8},
	{0x01d7ca, 0x01d7ca},
	{0x01e900, 0x01e921},
	{0x01f130, 0x01f149},
	{0x01f150, 0x01f169},
	{0x01f170, 0x01f189},
};

/* table of Unicode codepoint ranges of Case_Ignorable characters */
static const pg_unicode_range unicode_case_ignorable[491] =
{
	{0x000027, 0x000027},
	{0x00002e, 0x00002e},
	{0x00003a, 0x00003a},
	{0x00005e, 0x00005e},
	{0x000060, 0x000060},
	{0x0000a8, 0x0000a8},
	{0x0000ad, 0x0000ad},
	{0x0000af, 0x0000af},
	{0x0000b4, 0x0000b4},
	{0x0000b7, 0x0000b7},
	{0x0000b8, 0x0000b8},
	{0x0002b0, 0x0002c1},
	{0x0002c2, 0x0002c5},
	{0x0002c6, 0x0002d1},
	{0x0002d2, 0x0002df},
	{0x0002e0, 0x0002e4},
	{0x0002e5, 0x0002eb},
	{0x0002ec, 0x0002ec},
	{0x0002ed, 0x0002ed},
	{0x0002ee, 0x0002ee},
	{0x0002ef, 0x0002ff},
	{0x000300, 0x00036f},
	{0x000374, 0x000374},
	{0x000375, 0x000375},
	{0x00037a, 0x00037a},
	{0x000384, 0x000385},
	{0x000387, 0x000387},
	{0x000483, 0x000487},
	{0x000488, 0x000489},
	{0x000559, 0x000559},
	{0x00055f, 0x00055f},
	{0x000591, 0x0005bd},
	{0x0005bf, 0x0005bf},
	{0x0005c1, 0x0005c2},
	{0x0005c4, 0x0005c5},
	{0x0005c7, 0x0005c7},
	{0x0005f4, 0x0005f4},
	{0x000600, 0x000605},
	{0x000610, 0x00061a},
	{0x00061c, 0x00061c},
	{0x000640, 0x000640},
	{0x00064b, 0x00065f},
	{0x000670, 0x000670},
	{0x0006d6, 0x0006dc},
	{0x0006dd, 0x0006dd},
	{0x0006df, 0x0006e4},
	{0x0006e5, 0x0006e6},
	{0x0006e7, 0x0006e8},
	{0x0006ea, 0x0006ed},
	{0x00070f, 0x00070f},
	{0x000711, 0x000711},
	{0x000730, 0x00074a},
	{0x0007a6, 0x0007b0},
	{0x0007eb, 0x0007f3},
	{0x0007f4, 0x0007f5},
	{0x0007fa, 0x0007fa},
	{0x0007fd, 0x0007fd},
	{0x000816, 0x000819},
	{0x00081a, 0x00081a},
	{0x00081b, 0x000823},
	{0x000824, 0x000824},
	{0x000825, 0x000827},
	{0x000828, 0x000828},
	{0x000829, 0x00082d},
	{0x000859, 0x00085b},
	{0x000888, 0x000888},
	{0x000890, 0x000891},
	{0x000898, 0x00089f},
	{0x0008c9, 0x0008c9},
	{0x0008ca, 0x0008e1},
	{0x0008e2, 0x0008e2},
	{0x0008e3, 0x000902},
	{0x00093a, 0x00093a},
	{0x00093c, 0x00093c},
	{0x000941, 0x000948},
	{0x00094d, 0x00094d},
	{0x000951, 0x000957},
	{0x000962, 0x000963},
	{0x000971, 0x000971},
	{0x000981, 0x000981},
	{0x0009bc, 0x0009bc},
	{0x0009c1, 0x0009c4},
	{0x0009cd, 0x0009cd},
	{0x0009e2, 0x0009e3},
	{0x0009fe, 0x0009fe},
	{0x000a01, 0x000a02},
	{0x000a3c, 0x000a3c},
	{0x000a41, 0x000a42},
	{0x000a47, 0x000a48},
	{0x000a4b, 0x000a4d},
	{0x000a51, 0x000a51},
	{0x000a70, 0x000a71},
	{0x000a75, 0x000a75},
	{0x000a81, 0x000a82},
	{0x000abc, 0x000abc},
	{0x000ac1, 0x000ac5},
	{0x000ac7, 0x000ac8},
	{0x000acd, 0x000acd},
	{0x000ae2, 0x000ae3},
	{0x000afa, 0x000aff},
	{0x000b01, 0x000b01},
	{0x000b3c, 0x000b3c},
	{0x000b3f, 0x000b3f},
	{0x000b41, 0x000b44},
	{0x000b4d, 0x000b4d},
	{0x000b55, 0x000b56},
	{0x000b62, 0x000b63},
	{0x000b82, 0x000b82},
	{0x000bc0, 0x000bc0},
	{0x000bcd, 0x000bcd},
	{0x000c00, 0x000c00},
	{0x000c04, 0x000c04},
	{0x000c3c, 0x000c3c},
	{0x000c3e, 0x000c40},
	{0x000c46, 0x000c48},
	{0x000c4a, 0x000c4d},
	{0x000c55, 0x000c56},
	{0x000c62, 0x000c63},
	{0x000c81, 0x000c81},
	{0x000cbc, 0x000cbc},
	{0x000cbf, 0x000cbf},
	{0x000cc6, 0x000cc6},
	{0x000ccc, 0x000ccd},
	{0x000ce2, 0x000ce3},
	{0x000d00, 0x000d01},
	{0x000d3b, 0x000d3c},
	{0x000d41, 0x000d44},
	{0x000d4d, 0x000d4d},
	{0x000d62, 0x000d63},
	{0x000d81, 0x000d81},
	{0x000dca, 0x000dca},
	{0x000dd2, 0x000dd4},
	{0x000dd6, 0x000dd6},
	{0x000e31, 0x000e31},
	{0x000e34, 0x000e3a},
	{0x000e46, 0x000e46},
	{0x000e47, 0x000e4e},
	{0x000eb1, 0x000eb1},
	{0x000eb4, 0x000ebc},
	{0x000ec6, 0x000ec6},
	{0x000ec8, 0x000ece},
	{0x000f18, 0x000f19},
	{0x000f35, 0x000f35},
	{0x000f37, 0x000f37},
	{0x000f39, 0x000f39},
	{0x000f71, 0x000f7e},
	{0x000f80, 0x000f84},
	{0x000f86, 0x000f87},
	{0x000f8d, 0x000f97},
	{0x000f99, 0x000fbc},
	{0x000fc6, 0x000fc6},
	{0x00102d, 0x001030},
	{0x001032, 0x001037},
	{0x001039, 0x00103a},
	{0x00103d, 0x00103e},
	{0x001058, 0x001059},
	{0x00105e, 0x001060},
	{0x001071, 0x001074},
	{0x001082, 0x001082},
	{0x001085, 0x001086},
	{0x00108d, 0x00108d},
	{0x00109d, 0x00109d},
	{0x0010fc, 0x0010fc},
	{0x00135d, 0x00135f},
	{0x001712, 0x001714},
	{0x001732, 0x001733},
	{0x001752, 0x001753},
	{0x001772, 0x001773},
	{0x0017b4, 0x0017b5},
	{0x0017b7, 0x0017bd},
	{0x0017c6, 0x0017c6},
	{0x0017c9, 0x0017d3},
	{0x0017d7, 0x0017d7},
	{0x0017dd, 0x0017dd},
	{0x00180b, 0x00180d},
	{0x00180e, 0x00180e},
	{0x00180f, 0x00180f},
	{0x001843, 0x001843},
	{0x001885, 0x001886},
	{0x0018a9, 0x0018a9},
	{0x001920, 0x001922},
	{0x001927, 0x001928},
	{0x001932, 0x001932},
	{0x001939, 0x00193b},
	{0x001a17, 0x001a18},
	{0x001a1b, 0x001a1b},
	{0x001a56, 0x001a56},
	{0x001a58, 0x001a5e},
	{0x001a60, 0x001a60},
	{0x001a62, 0x001a62},
	{0x001a65, 0x001a6c},
	{0x001a73, 0x001a7c},
	{0x001a7f, 0x001a7f},
	{0x001aa7, 0x001aa7},
	{0x001ab0, 0x001abd},
	{0x001abe, 0x001abe},
	{0x001abf, 0x001ace},
	{0x001b00, 0x001b03},
	{0x001b34, 0x001b34},
	{0x001b36, 0x001b3a},
	{0x001b3c, 0x001b3c},
	{0x001b42, 0x001b42},
	{0x001b6b, 0x001b73},
	{0x001b80, 0x001b81},
	{0x001ba2, 0x001ba5},
	{0x001ba8, 0x001ba9},
	{0x001bab, 0x001bad},
	{0x001be6, 0x001be6},
	{0x001be8, 0x001be9},
	{0x001bed, 0x001bed},
	{0x001bef, 0x001bf1},
	{0x001c2c, 0x001c33},
	{0x001c36, 0x001c37},
	{0x001c78, 0x001c7d},
	{0x001cd0, 0x001cd2},
	{0x001cd4, 0x001ce0},
	{0x001ce2, 0x001ce8},
	{0x001ced, 0x001ced},
	{0x001cf4, 0x001cf4},
	{0x001cf8, 0x001cf9},
	{0x001d2c, 0x001d6a},
	{0x001d78, 0x001d78},
	{0x001d9b, 0x001dbf},
	{0x001dc0, 0x001dff},
	{0x001fbd, 0x001fbd},
	{0x001fbf, 0x001fc1},
	{0x001fcd, 0x001fcf},
	{0x001fdd, 0x001fdf},
	{0x001fed, 0x001fef},
	{0x001ffd, 0x001ffe},
	{0x00200b, 0x00200f},
	{0x002018, 0x002018},
	{0x002019, 0x002019},
	{0x002024, 0x002024},
	{0x002027, 0x002027},
	{0x00202a, 0x00202e},
	{0x002060, 0x002064},
	{0x002066, 0x00206f},
	{0x002071, 0x002071},
	{0x00207f, 0x00207f},
	{0x002090, 0x00209c},
	{0x0020d0, 0x0020dc},
	{0x0020dd, 0x0020e0},
	{0x0020e1, 0x0020e1},
	{0x0020e2, 0x0020e4},
	{0x0020e5, 0x0020f0},
	{0x002c7c, 0x002c7d},
	{0x002cef, 0x002cf1},
	{0x002d6f, 0x002d6f},
	{0x002d7f, 0x002d7f},
	{0x002de0, 0x002dff},
	{0x002e2f, 0x002e2f},
	{0x003005, 0x003005},
	{0x00302a, 0x00302d},
	{0x003031, 0x003035},
	{0x00303b, 0x00303b},
	{0x003099, 0x00309a},
	{0x00309b, 0x00309c},
	{0x00309d, 0x00309e},
	{0x0030fc, 0x0030fe},
	{0x00a015, 0x00a015},
	{0x00a4f8, 0x00a4fd},
	{0x00a60c, 0x00a60c},
	{0x00a66f, 0x00a66f},
	{0x00a670, 0x00a672},
	{0x00a674, 0x00a67d},
	{0x00a67f, 0x00a67f},
	{0x00a69c, 0x00a69d},
	{0x00a69e, 0x00a69f},
	{0x00a6f0, 0x00a6f1},
	{0x00a700, 0x00a716},
	{0x00a717, 0x00a71f},
	{0x00a720, 0x00a721},
	{0x00a770, 0x00a770},
	{0x00a788, 0x00a788},
	{0x00a789, 0x00a78a},
	{0x00a7f2, 0x00a7f4},
	{0x00a7f8, 0x00a7f9},
	{0x00a802, 0x00a802},
	{0x00a806, 0x00a806},
	{0x00a80b, 0x00a80b},
	{0x00a825, 0x00a826},
	{0x00a82c, 0x00a82c},
	{0x00a8c4, 0x00a8c5},
	{0x00a8e0, 0x00a8f1},
	{0x00a8ff, 0x00a8ff},
	{0x00a926, 0x00a92d},
	{0x00a947, 0x00a951},
	{0x00a980, 0x00a982},
	{0x00a9b3, 0x00a9b3},
	{0x00a9b6, 0x00a9b9},
	{0x00a9bc, 0x00a9bd},
	{0x00a9cf, 0x00a9cf},
	{0x00a9e5, 0x00a9e5},
	{0x00a9e6, 0x00a9e6},
	{0x00aa29, 0x00aa2e},
	{0x00aa31, 0x00aa32},
	{0x00aa35, 0x00aa36},
	{0x00aa43, 0x00aa43},
	{0x00aa4c, 0x00aa4c},
	{0x00aa70, 0x00aa70},
	{0x00aa7c, 0x00aa7c},
	{0x00aab0, 0x00aab0},
	{0x00aab2, 0x00aab4},
	{0x00aab7, 0x00aab8},
	{0x00aabe, 0x00aabf},
	{0x00aac1, 0x00aac1},
	{0x00aadd, 0x00aadd},
	{0x00aaec, 0x00aaed},
	{0x00aaf3, 0x00aaf4},
	{0x00aaf6, 0x00aaf6},
	{0x00ab5b, 0x00ab5b},
	{0x00ab5c, 0x00ab5f},
	{0x00ab69, 0x00ab69},
	{0x00ab6a, 0x00ab6b},
	{0x00abe5, 0x00abe5},
	{0x00abe8, 0x00abe8},
	{0x00abed, 0x00abed},
	{0x00fb1e, 0x00fb1e},
	{0x00fbb2, 0x00fbc2},
	{0x00fe00, 0x00fe0f},
	{0x00fe13, 0x00fe13},
	{0x00fe20, 0x00fe2f},
	{0x00fe52, 0x00fe52},
	{0x00fe55, 0x00fe55},
	{0x00feff, 0x00feff},
	{0x00ff07, 0x00ff07},
	{0x00ff0e, 0x00ff0e},
	{0x00ff1a, 0x00ff1a},
	{0x00ff3e, 0x00ff3e},
	{0x00ff40, 0x00ff40},
	{0x00ff70, 0x00ff70},
	{0x00ff9e, 0x00ff9f},
	{0x00ffe3, 0x00ffe3},
	{0x00fff9, 0x00fffb},
	{0x0101fd, 0x0101fd},
	{0x0102e0, 0x0102e0},
	{0x010376, 0x01037a},
	{0x010780, 0x010785},
	{0x010787, 0x0107b0},
	{0x0107b2, 0x0107ba},
	{0x010a01, 0x010a03},
	{0x010a05, 0x010a06},
	{0x010a0c, 0x010a0f},
	{0x010a38, 0x010a3a},
	{0x010a3f, 0x010a3f},
	{0x010ae5, 0x010ae6},
	{0x010d24, 0x010d27},
	{0x010eab, 0x010eac},
	{0x010efd, 0x010eff},
	{0x010f46, 0x010f50},
	{0x010f82, 0x010f85},
	{0x011001, 0x011001},
	{0x011038, 0x011046},
	{0x011070, 0x011070},
	{0x011073, 0x011074},
	{0x01107f, 0x011081},
	{0x0110b3, 0x0110b6},
	{0x0110b9, 0x0110ba},
	{0x0110bd, 0x0110bd},
	{0x0110c2, 0x0110c2},
	{0x0110cd, 0x0110cd},
	{0x011100, 0x011102},
	{0x011127, 0x01112b},
	{0x01112d, 0x011134},
	{0x011173, 0x011173},
	{0x011180, 0x011181},
	{0x0111b6, 0x0111be},
	{0x0111c9, 0x0111cc},
	{0x0111cf, 0x0111cf},
	{0x01122f, 0x011231},
	{0x011234, 0x011234},
	{0x011236, 0x011237},
	{0x01123e, 0x01123e},
	{0x011241, 0x011241},
	{0x0112df, 0x0112df},
	{0x0112e3, 0x0112ea},
	{0x011300, 0x011301},
	{0x01133b, 0x01133c},
	{0x011340, 0x011340},
	{0x011366, 0x01136c},
	{0x011370, 0x011374},
	{0x011438, 0x01143f},
	{0x011442, 0x011444},
	{0x011446, 0x011446},
	{0x01145e, 0x01145e},
	{0x0114b3, 0x0114b8},
	{0x0114ba, 0x0114ba},
	{0x0114bf, 0x0114c0},
	{0x0114c2, 0x0114c3},
	{0x0115b2, 0x0115b5},
	{0x0115bc, 0x0115bd},
	{0x0115bf, 0x0115c0},
	{0x0115dc, 0x0115dd},
	{0x011633, 0x01163a},
	{0x01163d, 0x01163d},
	{0x01163f, 0x011640},
	{0x0116ab, 0x0116ab},
	{0x0116ad, 0x0116ad},
	{0x0116b0, 0x0116b5},
	{0x0116b7, 0x0116b7},
	{0x01171d, 0x01171f},
	{0x011722, 0x011725},
	{0x011727, 0x01172b},
	{0x01182f, 0x011837},
	{0x011839, 0x01183a},
	{0x01193b, 0x01193c},
	{0x01193e, 0x01193e},
	{0x011943, 0x011943},
	{0x0119d4, 0x0119d7},
	{0x0119da, 0x0119db},
	{0x0119e0, 0x0119e0},
	{0x011a01, 0x011a0a},
	{0x011a33, 0x011a38},
	{0x011a3b, 0x011a3e},
	{0x011a47, 0x011a47},
	{0x011a51, 0x011a56},
	{0x011a59, 0x011a5b},
	{0x011a8a, 0x011a96},
	{0x011a98, 0x011a99},
	{0x011c30, 0x011c36},
	{0x011c38, 0x011c3d},
	{0x011c3f, 0x011c3f},
	{0x011c92, 0x011ca7},
	{0x011caa, 0x011cb0},
	{0x011cb2, 0x011cb3},
	{0x011cb5, 0x011cb6},
	{0x011d31, 0x011d36},
	{0x011d3a, 0x011d3a},
	{0x011d3c, 0x011d3d},
	{0x011d3f, 0x011d45},
	{0x011d47, 0x011d47},
	{0x011d90, 0x011d91},
	{0x011d95, 0x011d95},
	{0x011d97, 0x011d97},
	{0x011ef3, 0x011ef4},
	{0x011f00, 0x011f01},
	{0x011f36, 0x011f3a},
	{0x011f40, 0x011f40},
	{0x011f42, 0x011f42},
	{0x013430, 0x01343f},
	{0x013440, 0x013440},
	{0x013447, 0x013455},
	{0x016af0, 0x016af4},
	{0x016b30, 0x016b36},
	{0x016b40, 0x016b43},
	{0x016f4f, 0x016f4f},
	{0x016f8f, 0x016f92},
	{0x016f93, 0x016f9f},
	{0x016fe0, 0x016fe1},
	{0x016fe3, 0x016fe3},
	{0x016fe4, 0x016fe4},
	{0x01aff0, 0x01aff3},
	{0x01aff5, 0x01affb},
	{0x01affd, 0x01affe},
	{0x01bc9d, 0x01bc9e},
	{0x01bca0, 0x01bca3},
	{0x01cf00, 0x01cf2d},
	{0x01cf30, 0x01cf46},
	{0x01d167, 0x01d169},
	{0x01d173, 0x01d17a},
	{0x01d17b, 0x01d182},
	{0x01d185, 0x01d18b},
	{0x01d1aa, 0x01d1ad},
	{0x01d242, 0x01d244},
	{0x01da00, 0x01da36},
	{0x01da3b, 0x01da6c},
	{0x01da75, 0x01da75},
	{0x01da84, 0x01da84},
	{0x01da9b, 0x01da9f},
	{0x01daa1, 0x01daaf},
	{0x01e000, 0x01e006},
	{0x01e008, 0x01e018},
	{0x01e01b, 0x01e021},
	{0x01e023, 0x01e024},
	{0x01e026, 0x01e02a},
	{0x01e030, 0x01e06d},
	{0x01e08f, 0x01e08f},
	{0x01e130, 0x01e136},
	{0x01e137, 0x01e13d},
	{0x01e2ae, 0x01e2ae},
	{0x01e2ec, 0x01e2ef},
	{0x01e4eb, 0x01e4eb},
	{0x01e4ec, 0x01e4ef},
	{0x01e8d0, 0x01e8d6},
	{0x01e944, 0x01e94a},
	{0x01e94b, 0x01e94b},
	{0x01f3fb, 0x01f3ff},
	{0x0e0001, 0x0e0001},
	{0x0e0020, 0x0e007f},
	{0x0e0100, 0x0e01ef},
};

/* table of Unicode codepoint ranges of White_Space characters */
static const pg_unicode_range unicode_white_space[11] =
{
	{0x000009, 0x00000d},
	{0x000020, 0x000020},
	{0x000085, 0x000085},
	{0x0000a0, 0x0000a0},
	{0x001680, 0x001680},
	{0x002000, 0x00200a},
	{0x002028, 0x002028},
	{0x002029, 0x002029},
	{0x00202f, 0x00202f},
	{0x00205f, 0x00205f},
	{0x003000, 0x003000},
};

/* table of Unicode codepoint ranges of Hex_Digit characters */
static const pg_unicode_range unicode_hex_digit[6] =
{
	{0x000030, 0x000039},
	{0x000041, 0x000046},
	{0x000061, 0x000066},
	{0x00ff10, 0x00ff19},
	{0x00ff21, 0x00ff26},
	{0x00ff41, 0x00ff46},
};

/* table of Unicode codepoint ranges of Join_Control characters */
static const pg_unicode_range unicode_join_control[1] =
{
	{0x00200c, 0x00200d},
};
