/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.io;

import java.awt.Color;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLParserFactory;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.io.Base64;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.io.StreamPosTokenizer;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.SVGConstants;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.samples.svg.io.DefaultSVGFigureFactory;
import org.jhotdraw.samples.svg.io.SVGFigureFactory;
import org.jhotdraw.text.FontFormatter;
import org.jhotdraw.util.LocaleUtil;
import org.jhotdraw.xml.css.CSSParser;
import org.jhotdraw.xml.css.StyleManager;

public class SVGInputFormat
implements InputFormat {
    private static final boolean DEBUG = false;
    private SVGFigureFactory factory;
    private URL url;
    private HashMap<String, IXMLElement> identifiedElements;
    private HashMap<IXMLElement, Object> elementObjects;
    private StreamPosTokenizer toPathTokenizer;
    private FontFormatter fontFormatter = new FontFormatter();
    private Stack<Viewport> viewportStack;
    private StyleManager styleManager;
    private LinkedList<Figure> figures;
    private IXMLElement document;
    private static final HashSet<String> supportedFeatures = new HashSet<String>(Arrays.asList("http://www.w3.org/Graphics/SVG/feature/1.2/#SVG-static", "http://www.w3.org/Graphics/SVG/feature/1.2/#CoreAttribute", "http://www.w3.org/Graphics/SVG/feature/1.2/#Structure", "http://www.w3.org/Graphics/SVG/feature/1.2/#ConditionalProcessing", "http://www.w3.org/Graphics/SVG/feature/1.2/#ConditionalProcessingAttribute", "http://www.w3.org/Graphics/SVG/feature/1.2/#Image", "http://www.w3.org/Graphics/SVG/feature/1.2/#Shape", "http://www.w3.org/Graphics/SVG/feature/1.2/#Text", "http://www.w3.org/Graphics/SVG/feature/1.2/#PaintAttribute", "http://www.w3.org/Graphics/SVG/feature/1.2/#OpacityAttribute", "http://www.w3.org/Graphics/SVG/feature/1.2/#GraphicsAttribute", "http://www.w3.org/Graphics/SVG/feature/1.2/#Gradient", "http://www.w3.org/Graphics/SVG/feature/1.2/#SolidColor", "http://www.w3.org/Graphics/SVG/feature/1.2/#Hyperlinking"));

    public SVGInputFormat() {
        this(new DefaultSVGFigureFactory());
    }

    public SVGInputFormat(SVGFigureFactory sVGFigureFactory) {
        this.factory = sVGFigureFactory;
    }

    @Override
    public void read(File file, Drawing drawing) throws IOException {
        this.read(file, drawing, true);
    }

    @Override
    public void read(InputStream inputStream, Drawing drawing, boolean bl) throws IOException {
        Object object;
        IXMLParser iXMLParser;
        long l = System.currentTimeMillis();
        this.figures = new LinkedList();
        try {
            iXMLParser = XMLParserFactory.createDefaultXMLParser();
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Unable to instantiate NanoXML Parser");
            internalError.initCause(exception);
            throw internalError;
        }
        System.out.println("SVGInputFormat parser created " + (System.currentTimeMillis() - l));
        StdXMLReader stdXMLReader = new StdXMLReader(inputStream);
        iXMLParser.setReader(stdXMLReader);
        System.out.println("SVGInputFormat reader created " + (System.currentTimeMillis() - l));
        try {
            this.document = (IXMLElement)iXMLParser.parse();
        }
        catch (XMLException xMLException) {
            IOException iOException = new IOException(xMLException.getMessage());
            iOException.initCause(xMLException);
            throw iOException;
        }
        System.out.println("SVGInputFormat document created " + (System.currentTimeMillis() - l));
        IXMLElement iXMLElement = this.document;
        Stack stack = new Stack();
        LinkedList<IXMLElement> linkedList = new LinkedList<IXMLElement>();
        linkedList.add(this.document);
        stack.push(linkedList.iterator());
        while (!stack.empty() && ((Iterator)stack.peek()).hasNext()) {
            Iterator iterator = (Iterator)stack.peek();
            IXMLElement iXMLElement2 = (IXMLElement)iterator.next();
            Object object2 = object = iXMLElement2.getChildren() == null ? null : iXMLElement2.getChildren().iterator();
            if (!iterator.hasNext()) {
                stack.pop();
            }
            if (object != null && object.hasNext()) {
                stack.push(object);
            }
            if (iXMLElement2.getName() == null || !iXMLElement2.getName().equals("svg") || iXMLElement2.getNamespace() != null && !iXMLElement2.getNamespace().equals("http://www.w3.org/2000/svg")) continue;
            iXMLElement = iXMLElement2;
            break;
        }
        if (iXMLElement.getName() == null || !iXMLElement.getName().equals("svg") || iXMLElement.getNamespace() != null && !iXMLElement.getNamespace().equals("http://www.w3.org/2000/svg")) {
            throw new IOException("'svg' element expected: " + iXMLElement.getName());
        }
        this.initStorageContext(this.document);
        this.flattenStyles(iXMLElement);
        this.readElement(iXMLElement);
        long l2 = System.currentTimeMillis();
        if (bl) {
            drawing.removeAllChildren();
        }
        drawing.addAll(this.figures);
        if (bl) {
            object = (Viewport)this.viewportStack.firstElement();
            drawing.set(SVGAttributeKeys.VIEWPORT_FILL, SVGAttributeKeys.VIEWPORT_FILL.get(((Viewport)object).attributes));
            drawing.set(SVGAttributeKeys.VIEWPORT_FILL_OPACITY, SVGAttributeKeys.VIEWPORT_FILL_OPACITY.get(((Viewport)object).attributes));
            drawing.set(SVGAttributeKeys.VIEWPORT_HEIGHT, SVGAttributeKeys.VIEWPORT_HEIGHT.get(((Viewport)object).attributes));
            drawing.set(SVGAttributeKeys.VIEWPORT_WIDTH, SVGAttributeKeys.VIEWPORT_WIDTH.get(((Viewport)object).attributes));
        }
        this.document.dispose();
        this.identifiedElements.clear();
        this.elementObjects.clear();
        this.viewportStack.clear();
        this.styleManager.clear();
        this.document = null;
        this.identifiedElements = null;
        this.elementObjects = null;
        this.viewportStack = null;
        this.styleManager = null;
    }

    private void initStorageContext(IXMLElement iXMLElement) {
        this.identifiedElements = new HashMap();
        this.identifyElements(iXMLElement);
        this.elementObjects = new HashMap();
        this.viewportStack = new Stack();
        this.viewportStack.push(new Viewport());
        this.styleManager = new StyleManager();
    }

    private void flattenStyles(IXMLElement iXMLElement) throws IOException {
        if (iXMLElement.getName() != null && iXMLElement.getName().equals("style") && this.readAttribute(iXMLElement, "type", "").equals("text/css") && iXMLElement.getContent() != null) {
            CSSParser cSSParser = new CSSParser();
            cSSParser.parse(iXMLElement.getContent(), this.styleManager);
        } else if (iXMLElement.getNamespace() == null || iXMLElement.getNamespace().equals("http://www.w3.org/2000/svg")) {
            String string = this.readAttribute(iXMLElement, "style", null);
            if (string != null) {
                for (String string2 : string.split(";")) {
                    String[] stringArray = string2.split(":");
                    if (stringArray.length != 2 || iXMLElement.hasAttribute(stringArray[0].trim(), "http://www.w3.org/2000/svg")) continue;
                    iXMLElement.setAttribute(stringArray[0].trim(), "http://www.w3.org/2000/svg", stringArray[1].trim());
                }
            }
            this.styleManager.applyStylesTo(iXMLElement);
            for (IXMLElement iXMLElement2 : iXMLElement.getChildren()) {
                if (!(iXMLElement2 instanceof IXMLElement)) continue;
                IXMLElement iXMLElement3 = iXMLElement2;
                this.flattenStyles(iXMLElement3);
            }
        }
    }

    private Figure readElement(IXMLElement iXMLElement) throws IOException {
        String string;
        Figure figure = null;
        if ((iXMLElement.getNamespace() == null || iXMLElement.getNamespace().equals("http://www.w3.org/2000/svg")) && (string = iXMLElement.getName()) != null) {
            if (string.equals("a")) {
                figure = this.readAElement(iXMLElement);
            } else if (string.equals("circle")) {
                figure = this.readCircleElement(iXMLElement);
            } else if (string.equals("defs")) {
                this.readDefsElement(iXMLElement);
                figure = null;
            } else if (string.equals("ellipse")) {
                figure = this.readEllipseElement(iXMLElement);
            } else if (string.equals("g")) {
                figure = this.readGElement(iXMLElement);
            } else if (string.equals("image")) {
                figure = this.readImageElement(iXMLElement);
            } else if (string.equals("line")) {
                figure = this.readLineElement(iXMLElement);
            } else if (string.equals("linearGradient")) {
                this.readLinearGradientElement(iXMLElement);
                figure = null;
            } else if (string.equals("path")) {
                figure = this.readPathElement(iXMLElement);
            } else if (string.equals("polygon")) {
                figure = this.readPolygonElement(iXMLElement);
            } else if (string.equals("polyline")) {
                figure = this.readPolylineElement(iXMLElement);
            } else if (string.equals("radialGradient")) {
                this.readRadialGradientElement(iXMLElement);
                figure = null;
            } else if (string.equals("rect")) {
                figure = this.readRectElement(iXMLElement);
            } else if (string.equals("solidColor")) {
                this.readSolidColorElement(iXMLElement);
                figure = null;
            } else if (string.equals("svg")) {
                figure = this.readSVGElement(iXMLElement);
            } else if (string.equals("switch")) {
                figure = this.readSwitchElement(iXMLElement);
            } else if (string.equals("text")) {
                figure = this.readTextElement(iXMLElement);
            } else if (string.equals("textArea")) {
                figure = this.readTextAreaElement(iXMLElement);
            } else if (!string.equals("title")) {
                if (string.equals("use")) {
                    figure = this.readUseElement(iXMLElement);
                } else if (string.equals("style")) {
                    // empty if block
                }
            }
        }
        if (figure instanceof SVGFigure) {
            if (((SVGFigure)figure).isEmpty()) {
                return null;
            }
        } else if (figure != null) {
            // empty if block
        }
        return figure;
    }

    private void readDefsElement(IXMLElement iXMLElement) throws IOException {
        for (IXMLElement iXMLElement2 : iXMLElement.getChildren()) {
            if (!(iXMLElement2 instanceof IXMLElement)) continue;
            IXMLElement iXMLElement3 = iXMLElement2;
            Figure figure = this.readElement(iXMLElement3);
        }
    }

    private Figure readGElement(IXMLElement iXMLElement) throws IOException {
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(iXMLElement, hashMap);
        this.readOpacityAttribute(iXMLElement, hashMap);
        CompositeFigure compositeFigure = this.factory.createG(hashMap);
        for (IXMLElement iXMLElement2 : iXMLElement.getChildren()) {
            if (!(iXMLElement2 instanceof IXMLElement)) continue;
            IXMLElement iXMLElement3 = iXMLElement2;
            Figure figure = this.readElement(iXMLElement3);
            if (!this.readAttribute(iXMLElement3, "visibility", "visible").equals("visible") || this.readAttribute(iXMLElement3, "display", "inline").equals("none") || figure == null) continue;
            compositeFigure.basicAdd(figure);
        }
        this.readTransformAttribute(iXMLElement, hashMap);
        if (SVGAttributeKeys.TRANSFORM.get(hashMap) != null) {
            compositeFigure.transform((AffineTransform)SVGAttributeKeys.TRANSFORM.get(hashMap));
        }
        return compositeFigure;
    }

    private Figure readAElement(IXMLElement iXMLElement) throws IOException {
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(iXMLElement, hashMap);
        CompositeFigure compositeFigure = this.factory.createG(hashMap);
        String string = this.readAttribute(iXMLElement, "xlink:href", null);
        if (string == null) {
            string = this.readAttribute(iXMLElement, "href", null);
        }
        String string2 = this.readAttribute(iXMLElement, "target", null);
        for (IXMLElement iXMLElement2 : iXMLElement.getChildren()) {
            if (!(iXMLElement2 instanceof IXMLElement)) continue;
            IXMLElement iXMLElement3 = iXMLElement2;
            Figure figure = this.readElement(iXMLElement3);
            if (this.readAttribute(iXMLElement3, "visibility", "visible").equals("visible") && !this.readAttribute(iXMLElement3, "display", "inline").equals("none") && figure != null) {
                compositeFigure.basicAdd(figure);
            }
            if (figure == null) continue;
            figure.set(SVGAttributeKeys.LINK, string);
            figure.set(SVGAttributeKeys.LINK_TARGET, string2);
        }
        return compositeFigure.getChildCount() == 1 ? compositeFigure.getChild(0) : compositeFigure;
    }

    private Figure readSVGElement(IXMLElement iXMLElement) throws IOException {
        Object object;
        Viewport viewport = new Viewport();
        String string = this.readAttribute(iXMLElement, "width", "100%");
        String string2 = this.readAttribute(iXMLElement, "height", "100%");
        viewport.width = this.toWidth(iXMLElement, string);
        viewport.height = this.toHeight(iXMLElement, string2);
        if (this.readAttribute(iXMLElement, "viewBox", "none").equals("none")) {
            viewport.viewBox.width = viewport.width;
            viewport.viewBox.height = viewport.height;
        } else {
            object = SVGInputFormat.toWSOrCommaSeparatedArray(this.readAttribute(iXMLElement, "viewBox", "none"));
            viewport.viewBox.x = this.toNumber(iXMLElement, object[0]);
            viewport.viewBox.y = this.toNumber(iXMLElement, object[1]);
            viewport.viewBox.width = this.toNumber(iXMLElement, object[2]);
            viewport.viewBox.height = this.toNumber(iXMLElement, object[3]);
            if (string.indexOf(37) > 0) {
                viewport.width = viewport.viewBox.width;
            }
            if (string2.indexOf(37) > 0) {
                viewport.height = viewport.viewBox.height;
            }
        }
        viewport.isPreserveAspectRatio = this.viewportStack.size() == 1 ? true : !this.readAttribute(iXMLElement, "preserveAspectRatio", "none").equals("none");
        viewport.widthPercentFactor = viewport.viewBox.width / 100.0;
        viewport.heightPercentFactor = viewport.viewBox.height / 100.0;
        viewport.numberFactor = Math.min(viewport.width / viewport.viewBox.width, viewport.height / viewport.viewBox.height);
        object = new AffineTransform();
        ((AffineTransform)object).translate(-viewport.viewBox.x * viewport.width / viewport.viewBox.width, -viewport.viewBox.y * viewport.height / viewport.viewBox.height);
        if (viewport.isPreserveAspectRatio) {
            double d = Math.min(viewport.width / viewport.viewBox.width, viewport.height / viewport.viewBox.height);
            ((AffineTransform)object).scale(d, d);
        } else {
            ((AffineTransform)object).scale(viewport.width / viewport.viewBox.width, viewport.height / viewport.viewBox.height);
        }
        this.viewportStack.push(viewport);
        this.readViewportAttributes(iXMLElement, ((Viewport)this.viewportStack.firstElement()).attributes);
        for (IXMLElement iXMLElement2 : iXMLElement.getChildren()) {
            if (!(iXMLElement2 instanceof IXMLElement)) continue;
            IXMLElement iXMLElement3 = iXMLElement2;
            Figure figure = this.readElement(iXMLElement3);
            if (!this.readAttribute(iXMLElement3, "visibility", "visible").equals("visible") || this.readAttribute(iXMLElement3, "display", "inline").equals("none") || figure == null) continue;
            figure.transform((AffineTransform)object);
            this.figures.add(figure);
        }
        this.viewportStack.pop();
        return null;
    }

    private Figure readRectElement(IXMLElement iXMLElement) throws IOException {
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(iXMLElement, hashMap);
        this.readTransformAttribute(iXMLElement, hashMap);
        this.readOpacityAttribute(iXMLElement, hashMap);
        this.readShapeAttributes(iXMLElement, hashMap);
        double d = this.toNumber(iXMLElement, this.readAttribute(iXMLElement, "x", "0"));
        double d2 = this.toNumber(iXMLElement, this.readAttribute(iXMLElement, "y", "0"));
        double d3 = this.toWidth(iXMLElement, this.readAttribute(iXMLElement, "width", "0"));
        double d4 = this.toHeight(iXMLElement, this.readAttribute(iXMLElement, "height", "0"));
        String string = this.readAttribute(iXMLElement, "rx", "none");
        String string2 = this.readAttribute(iXMLElement, "ry", "none");
        if (string.equals("none")) {
            string = string2;
        }
        if (string2.equals("none")) {
            string2 = string;
        }
        double d5 = this.toNumber(iXMLElement, string.equals("none") ? "0" : string);
        double d6 = this.toNumber(iXMLElement, string2.equals("none") ? "0" : string2);
        Figure figure = this.factory.createRect(d, d2, d3, d4, d5, d6, hashMap);
        this.elementObjects.put(iXMLElement, figure);
        return figure;
    }

    private Figure readCircleElement(IXMLElement iXMLElement) throws IOException {
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(iXMLElement, hashMap);
        this.readTransformAttribute(iXMLElement, hashMap);
        this.readOpacityAttribute(iXMLElement, hashMap);
        this.readShapeAttributes(iXMLElement, hashMap);
        double d = this.toWidth(iXMLElement, this.readAttribute(iXMLElement, "cx", "0"));
        double d2 = this.toHeight(iXMLElement, this.readAttribute(iXMLElement, "cy", "0"));
        double d3 = this.toWidth(iXMLElement, this.readAttribute(iXMLElement, "r", "0"));
        Figure figure = this.factory.createCircle(d, d2, d3, hashMap);
        this.elementObjects.put(iXMLElement, figure);
        return figure;
    }

    private Figure readEllipseElement(IXMLElement iXMLElement) throws IOException {
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(iXMLElement, hashMap);
        this.readTransformAttribute(iXMLElement, hashMap);
        this.readOpacityAttribute(iXMLElement, hashMap);
        this.readShapeAttributes(iXMLElement, hashMap);
        double d = this.toWidth(iXMLElement, this.readAttribute(iXMLElement, "cx", "0"));
        double d2 = this.toHeight(iXMLElement, this.readAttribute(iXMLElement, "cy", "0"));
        double d3 = this.toWidth(iXMLElement, this.readAttribute(iXMLElement, "rx", "0"));
        double d4 = this.toHeight(iXMLElement, this.readAttribute(iXMLElement, "ry", "0"));
        Figure figure = this.factory.createEllipse(d, d2, d3, d4, hashMap);
        this.elementObjects.put(iXMLElement, figure);
        return figure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Figure readImageElement(IXMLElement iXMLElement) throws IOException {
        Object object;
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(iXMLElement, hashMap);
        this.readTransformAttribute(iXMLElement, hashMap);
        this.readOpacityAttribute(iXMLElement, hashMap);
        double d = this.toNumber(iXMLElement, this.readAttribute(iXMLElement, "x", "0"));
        double d2 = this.toNumber(iXMLElement, this.readAttribute(iXMLElement, "y", "0"));
        double d3 = this.toWidth(iXMLElement, this.readAttribute(iXMLElement, "width", "0"));
        double d4 = this.toHeight(iXMLElement, this.readAttribute(iXMLElement, "height", "0"));
        String string = this.readAttribute(iXMLElement, "xlink:href", null);
        if (string == null) {
            string = this.readAttribute(iXMLElement, "href", null);
        }
        byte[] byArray = null;
        if (string != null) {
            if (string.startsWith("data:")) {
                int n = string.indexOf(59);
                if (n == -1) throw new IOException("Unsupported data href in image element:" + string);
                if (string.indexOf(";base64,") != n) throw new IOException("Unsupported encoding in data href in image element:" + string);
                byArray = Base64.decode(string.substring(n + 8));
            } else {
                URL uRL = new URL(this.url, string);
                if (uRL.getFile().endsWith("svg")) {
                    SVGInputFormat sVGInputFormat = new SVGInputFormat(this.factory);
                    DefaultDrawing defaultDrawing = new DefaultDrawing();
                    sVGInputFormat.read(uRL, (Drawing)defaultDrawing, true);
                    CompositeFigure compositeFigure = this.factory.createG(hashMap);
                    for (Figure figure : defaultDrawing.getChildren()) {
                        compositeFigure.add(figure);
                    }
                    compositeFigure.setBounds(new Point2D.Double(d, d2), new Point2D.Double(d + d3, d2 + d4));
                    return compositeFigure;
                }
                object = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[512];
                int n = 0;
                InputStream inputStream = null;
                try {
                    inputStream = uRL.openStream();
                    while ((n = inputStream.read(byArray2)) > 0) {
                        ((ByteArrayOutputStream)object).write(byArray2, 0, n);
                    }
                    byArray = ((ByteArrayOutputStream)object).toByteArray();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
        }
        BufferedImage bufferedImage = null;
        if (byArray != null) {
            try {
                bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
            }
            catch (IIOException iIOException) {
                System.err.println("SVGInputFormat warning: skipped unsupported image format.");
                iIOException.printStackTrace();
            }
        }
        if (bufferedImage == null) {
            byArray = null;
        }
        object = this.factory.createImage(d, d2, d3, d4, byArray, bufferedImage, hashMap);
        this.elementObjects.put(iXMLElement, object);
        return object;
    }

    private Figure readLineElement(IXMLElement iXMLElement) throws IOException {
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(iXMLElement, hashMap);
        this.readTransformAttribute(iXMLElement, hashMap);
        this.readOpacityAttribute(iXMLElement, hashMap);
        this.readLineAttributes(iXMLElement, hashMap);
        if (SVGAttributeKeys.FILL_COLOR.get(hashMap) != null && SVGAttributeKeys.STROKE_COLOR.get(hashMap) == null) {
            SVGAttributeKeys.STROKE_COLOR.put(hashMap, SVGAttributeKeys.FILL_COLOR.get(hashMap));
        }
        if (SVGAttributeKeys.FILL_GRADIENT.get(hashMap) != null && SVGAttributeKeys.STROKE_GRADIENT.get(hashMap) == null) {
            SVGAttributeKeys.STROKE_GRADIENT.put(hashMap, SVGAttributeKeys.FILL_GRADIENT.get(hashMap));
        }
        SVGAttributeKeys.FILL_COLOR.put(hashMap, null);
        SVGAttributeKeys.FILL_GRADIENT.put(hashMap, null);
        double d = this.toNumber(iXMLElement, this.readAttribute(iXMLElement, "x1", "0"));
        double d2 = this.toNumber(iXMLElement, this.readAttribute(iXMLElement, "y1", "0"));
        double d3 = this.toNumber(iXMLElement, this.readAttribute(iXMLElement, "x2", "0"));
        double d4 = this.toNumber(iXMLElement, this.readAttribute(iXMLElement, "y2", "0"));
        Figure figure = this.factory.createLine(d, d2, d3, d4, hashMap);
        this.elementObjects.put(iXMLElement, figure);
        return figure;
    }

    private Figure readPolylineElement(IXMLElement iXMLElement) throws IOException {
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(iXMLElement, hashMap);
        this.readTransformAttribute(iXMLElement, hashMap);
        this.readOpacityAttribute(iXMLElement, hashMap);
        this.readLineAttributes(iXMLElement, hashMap);
        Point2D.Double[] doubleArray = this.toPoints(iXMLElement, this.readAttribute(iXMLElement, "points", ""));
        Figure figure = this.factory.createPolyline(doubleArray, hashMap);
        this.elementObjects.put(iXMLElement, figure);
        return figure;
    }

    private Figure readPolygonElement(IXMLElement iXMLElement) throws IOException {
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(iXMLElement, hashMap);
        this.readTransformAttribute(iXMLElement, hashMap);
        this.readOpacityAttribute(iXMLElement, hashMap);
        this.readShapeAttributes(iXMLElement, hashMap);
        Point2D.Double[] doubleArray = this.toPoints(iXMLElement, this.readAttribute(iXMLElement, "points", ""));
        Figure figure = this.factory.createPolygon(doubleArray, hashMap);
        this.elementObjects.put(iXMLElement, figure);
        return figure;
    }

    private Figure readPathElement(IXMLElement iXMLElement) throws IOException {
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(iXMLElement, hashMap);
        this.readTransformAttribute(iXMLElement, hashMap);
        this.readOpacityAttribute(iXMLElement, hashMap);
        this.readShapeAttributes(iXMLElement, hashMap);
        BezierPath[] bezierPathArray = this.toPath(iXMLElement, this.readAttribute(iXMLElement, "d", ""));
        Figure figure = this.factory.createPath(bezierPathArray, hashMap);
        this.elementObjects.put(iXMLElement, figure);
        return figure;
    }

    private Figure readTextElement(IXMLElement iXMLElement) throws IOException {
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(iXMLElement, hashMap);
        this.readTransformAttribute(iXMLElement, hashMap);
        this.readOpacityAttribute(iXMLElement, hashMap);
        this.readShapeAttributes(iXMLElement, hashMap);
        this.readFontAttributes(iXMLElement, hashMap);
        this.readTextAttributes(iXMLElement, hashMap);
        String[] stringArray = SVGInputFormat.toCommaSeparatedArray(this.readAttribute(iXMLElement, "x", "0"));
        String[] stringArray2 = SVGInputFormat.toCommaSeparatedArray(this.readAttribute(iXMLElement, "y", "0"));
        Point2D.Double[] doubleArray = new Point2D.Double[Math.max(stringArray.length, stringArray2.length)];
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < doubleArray.length; ++i) {
            if (stringArray.length > i) {
                try {
                    d = this.toNumber(iXMLElement, stringArray[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (stringArray2.length > i) {
                try {
                    d2 = this.toNumber(iXMLElement, stringArray2[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            doubleArray[i] = new Point2D.Double(d, d2);
        }
        String[] stringArray3 = SVGInputFormat.toCommaSeparatedArray(this.readAttribute(iXMLElement, "rotate", ""));
        double[] dArray = new double[stringArray3.length];
        for (int i = 0; i < stringArray3.length; ++i) {
            try {
                dArray[i] = this.toDouble(iXMLElement, stringArray3[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                dArray[i] = 0.0;
            }
        }
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
        try {
            if (iXMLElement.getContent() != null) {
                defaultStyledDocument.insertString(0, this.toText(iXMLElement, iXMLElement.getContent()), null);
            } else {
                for (IXMLElement iXMLElement2 : iXMLElement.getChildren()) {
                    if (iXMLElement2.getName() == null) {
                        defaultStyledDocument.insertString(0, this.toText(iXMLElement, iXMLElement2.getContent()), null);
                        continue;
                    }
                    if (!iXMLElement2.getName().equals("tspan")) continue;
                    this.readTSpanElement(iXMLElement2, defaultStyledDocument);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            InternalError internalError = new InternalError(badLocationException.getMessage());
            internalError.initCause(badLocationException);
            throw internalError;
        }
        Figure figure = this.factory.createText(doubleArray, dArray, defaultStyledDocument, hashMap);
        this.elementObjects.put(iXMLElement, figure);
        return figure;
    }

    private Figure readTextAreaElement(IXMLElement iXMLElement) throws IOException {
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(iXMLElement, hashMap);
        this.readTransformAttribute(iXMLElement, hashMap);
        this.readOpacityAttribute(iXMLElement, hashMap);
        this.readShapeAttributes(iXMLElement, hashMap);
        this.readFontAttributes(iXMLElement, hashMap);
        this.readTextAttributes(iXMLElement, hashMap);
        this.readTextFlowAttributes(iXMLElement, hashMap);
        double d = this.toNumber(iXMLElement, this.readAttribute(iXMLElement, "x", "0"));
        double d2 = this.toNumber(iXMLElement, this.readAttribute(iXMLElement, "y", "0"));
        double d3 = this.toWidth(iXMLElement, this.readAttribute(iXMLElement, "width", "0"));
        double d4 = this.toHeight(iXMLElement, this.readAttribute(iXMLElement, "height", "0"));
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
        try {
            if (iXMLElement.getContent() != null) {
                defaultStyledDocument.insertString(0, this.toText(iXMLElement, iXMLElement.getContent()), null);
            } else {
                for (IXMLElement iXMLElement2 : iXMLElement.getChildren()) {
                    if (iXMLElement2.getName() == null) {
                        defaultStyledDocument.insertString(defaultStyledDocument.getLength(), this.toText(iXMLElement, iXMLElement2.getContent()), null);
                        continue;
                    }
                    if (iXMLElement2.getName().equals("tbreak")) {
                        defaultStyledDocument.insertString(defaultStyledDocument.getLength(), "\n", null);
                        continue;
                    }
                    if (!iXMLElement2.getName().equals("tspan")) continue;
                    this.readTSpanElement(iXMLElement2, defaultStyledDocument);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            InternalError internalError = new InternalError(badLocationException.getMessage());
            internalError.initCause(badLocationException);
            throw internalError;
        }
        Figure figure = this.factory.createTextArea(d, d2, d3, d4, defaultStyledDocument, hashMap);
        this.elementObjects.put(iXMLElement, figure);
        return figure;
    }

    private void readTSpanElement(IXMLElement iXMLElement, DefaultStyledDocument defaultStyledDocument) throws IOException {
        try {
            if (iXMLElement.getContent() != null) {
                defaultStyledDocument.insertString(defaultStyledDocument.getLength(), this.toText(iXMLElement, iXMLElement.getContent()), null);
            } else {
                for (IXMLElement iXMLElement2 : iXMLElement.getChildren()) {
                    if (iXMLElement2 instanceof IXMLElement) {
                        IXMLElement iXMLElement3 = iXMLElement2;
                        if (iXMLElement2.getName() == null || !iXMLElement2.getName().equals("tspan")) continue;
                        this.readTSpanElement(iXMLElement2, defaultStyledDocument);
                        continue;
                    }
                    if (iXMLElement2.getName() != null) continue;
                    defaultStyledDocument.insertString(defaultStyledDocument.getLength(), this.toText(iXMLElement, iXMLElement2.getContent()), null);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            InternalError internalError = new InternalError(badLocationException.getMessage());
            internalError.initCause(badLocationException);
            throw internalError;
        }
    }

    private Figure readSwitchElement(IXMLElement iXMLElement) throws IOException {
        for (IXMLElement iXMLElement2 : iXMLElement.getChildren()) {
            Cloneable cloneable;
            boolean bl;
            if (!(iXMLElement2 instanceof IXMLElement)) continue;
            IXMLElement iXMLElement3 = iXMLElement2;
            String[] stringArray = SVGInputFormat.toWSOrCommaSeparatedArray(this.readAttribute(iXMLElement3, "requiredFeatures", ""));
            String[] stringArray2 = SVGInputFormat.toWSOrCommaSeparatedArray(this.readAttribute(iXMLElement3, "requiredExtensions", ""));
            String[] stringArray3 = SVGInputFormat.toWSOrCommaSeparatedArray(this.readAttribute(iXMLElement3, "systemLanguage", ""));
            String[] stringArray4 = SVGInputFormat.toWSOrCommaSeparatedArray(this.readAttribute(iXMLElement3, "requiredFormats", ""));
            String[] stringArray5 = SVGInputFormat.toWSOrCommaSeparatedArray(this.readAttribute(iXMLElement3, "requiredFonts", ""));
            boolean bl2 = bl = supportedFeatures.containsAll(Arrays.asList(stringArray)) && stringArray2.length == 0 && stringArray4.length == 0 && stringArray5.length == 0;
            if (bl && stringArray3.length > 0) {
                bl = false;
                cloneable = LocaleUtil.getDefault();
                for (String string : stringArray3) {
                    int n = string.indexOf(45);
                    if (n == -1) {
                        if (!((Locale)cloneable).getLanguage().equals(string)) continue;
                        bl = true;
                        break;
                    }
                    if (!((Locale)cloneable).getLanguage().equals(string.substring(0, n)) || !((Locale)cloneable).getCountry().toLowerCase().equals(string.substring(n + 1))) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) continue;
            cloneable = this.readElement(iXMLElement3);
            if (this.readAttribute(iXMLElement3, "visibility", "visible").equals("visible") && !this.readAttribute(iXMLElement3, "display", "inline").equals("none")) {
                return cloneable;
            }
            return null;
        }
        return null;
    }

    private Figure readUseElement(IXMLElement iXMLElement) throws IOException {
        Figure figure;
        IXMLElement iXMLElement2;
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(iXMLElement, hashMap);
        HashMap<AttributeKey, Object> hashMap2 = new HashMap<AttributeKey, Object>();
        this.readTransformAttribute(iXMLElement, hashMap);
        this.readOpacityAttribute(iXMLElement, hashMap2);
        this.readUseShapeAttributes(iXMLElement, hashMap2);
        this.readFontAttributes(iXMLElement, hashMap2);
        String string = this.readAttribute(iXMLElement, "xlink:href", null);
        if (string != null && string.startsWith("#") && (iXMLElement2 = this.identifiedElements.get(string.substring(1))) != null && (figure = this.readElement(iXMLElement2)) instanceof Figure) {
            Figure figure2 = (Figure)figure.clone();
            for (Map.Entry<AttributeKey, Object> entry : hashMap2.entrySet()) {
                figure2.set(entry.getKey(), entry.getValue());
            }
            AffineTransform affineTransform = SVGAttributeKeys.TRANSFORM.get(hashMap) == null ? new AffineTransform() : (AffineTransform)SVGAttributeKeys.TRANSFORM.get(hashMap);
            double d = this.toNumber(iXMLElement, this.readAttribute(iXMLElement, "x", "0"));
            double d2 = this.toNumber(iXMLElement, this.readAttribute(iXMLElement, "y", "0"));
            affineTransform.translate(d, d2);
            figure2.transform(affineTransform);
            return figure2;
        }
        return null;
    }

    private String readInheritAttribute(IXMLElement iXMLElement, String string, String string2) {
        if (iXMLElement.hasAttribute(string, "http://www.w3.org/2000/svg")) {
            String string3 = iXMLElement.getAttribute(string, "http://www.w3.org/2000/svg", null);
            if (string3.equals("inherit")) {
                return this.readInheritAttribute(iXMLElement.getParent(), string, string2);
            }
            return string3;
        }
        if (iXMLElement.hasAttribute(string)) {
            String string4 = iXMLElement.getAttribute(string);
            if (string4.equals("inherit")) {
                return this.readInheritAttribute(iXMLElement.getParent(), string, string2);
            }
            return string4;
        }
        if (iXMLElement.getParent() != null && (iXMLElement.getParent().getNamespace() == null || iXMLElement.getParent().getNamespace().equals("http://www.w3.org/2000/svg"))) {
            return this.readInheritAttribute(iXMLElement.getParent(), string, string2);
        }
        return string2;
    }

    private String readInheritColorAttribute(IXMLElement iXMLElement, String string, String string2) {
        String string3 = null;
        if (iXMLElement.hasAttribute(string, "http://www.w3.org/2000/svg")) {
            string3 = iXMLElement.getAttribute(string, "http://www.w3.org/2000/svg", null);
            if (string3.equals("inherit")) {
                return this.readInheritColorAttribute(iXMLElement.getParent(), string, string2);
            }
        } else if (iXMLElement.hasAttribute(string)) {
            string3 = iXMLElement.getAttribute(string);
            if (string3.equals("inherit")) {
                return this.readInheritColorAttribute(iXMLElement.getParent(), string, string2);
            }
        } else {
            string3 = iXMLElement.getParent() != null && (iXMLElement.getParent().getNamespace() == null || iXMLElement.getParent().getNamespace().equals("http://www.w3.org/2000/svg")) ? this.readInheritColorAttribute(iXMLElement.getParent(), string, string2) : string2;
        }
        if (string3 != null && string3.toLowerCase().equals("currentcolor") && !string.equals("color")) {
            string3 = this.readInheritColorAttribute(iXMLElement, "color", "defaultValue");
        }
        return string3;
    }

    private double readInheritFontSizeAttribute(IXMLElement iXMLElement, String string, String string2) throws IOException {
        String string3 = null;
        if (iXMLElement.hasAttribute(string, "http://www.w3.org/2000/svg")) {
            string3 = iXMLElement.getAttribute(string, "http://www.w3.org/2000/svg", null);
        } else if (iXMLElement.hasAttribute(string)) {
            string3 = iXMLElement.getAttribute(string, null);
        } else {
            if (iXMLElement.getParent() != null && (iXMLElement.getParent().getNamespace() == null || iXMLElement.getParent().getNamespace().equals("http://www.w3.org/2000/svg"))) {
                return this.readInheritFontSizeAttribute(iXMLElement.getParent(), string, string2);
            }
            string3 = string2;
        }
        if (string3.equals("inherit")) {
            return this.readInheritFontSizeAttribute(iXMLElement.getParent(), string, string2);
        }
        if (SVGConstants.SVG_ABSOLUTE_FONT_SIZES.containsKey(string3)) {
            return SVGConstants.SVG_ABSOLUTE_FONT_SIZES.get(string3);
        }
        if (SVGConstants.SVG_RELATIVE_FONT_SIZES.containsKey(string3)) {
            return SVGConstants.SVG_RELATIVE_FONT_SIZES.get(string3) * this.readInheritFontSizeAttribute(iXMLElement.getParent(), string, string2);
        }
        if (string3.endsWith("%")) {
            double d = Double.valueOf(string3.substring(0, string3.length() - 1));
            return d * this.readInheritFontSizeAttribute(iXMLElement.getParent(), string, string2);
        }
        return this.toNumber(iXMLElement, string3);
    }

    private String readAttribute(IXMLElement iXMLElement, String string, String string2) {
        if (iXMLElement.hasAttribute(string, "http://www.w3.org/2000/svg")) {
            String string3 = iXMLElement.getAttribute(string, "http://www.w3.org/2000/svg", null);
            if (string3.equals("inherit")) {
                return this.readAttribute(iXMLElement.getParent(), string, string2);
            }
            return string3;
        }
        if (iXMLElement.hasAttribute(string)) {
            String string4 = iXMLElement.getAttribute(string, null);
            if (string4.equals("inherit")) {
                return this.readAttribute(iXMLElement.getParent(), string, string2);
            }
            return string4;
        }
        return string2;
    }

    private double toWidth(IXMLElement iXMLElement, String string) throws IOException {
        return this.toLength(iXMLElement, string, this.viewportStack.peek().widthPercentFactor);
    }

    private double toHeight(IXMLElement iXMLElement, String string) throws IOException {
        return this.toLength(iXMLElement, string, this.viewportStack.peek().heightPercentFactor);
    }

    private double toNumber(IXMLElement iXMLElement, String string) throws IOException {
        return this.toLength(iXMLElement, string, this.viewportStack.peek().numberFactor);
    }

    private double toLength(IXMLElement iXMLElement, String string, double d) throws IOException {
        double d2 = 1.0;
        if (string == null || string.length() == 0 || string.equals("none")) {
            return 0.0;
        }
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
            d2 = d;
        } else if (string.endsWith("px")) {
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("pt")) {
            string = string.substring(0, string.length() - 2);
            d2 = 1.25;
        } else if (string.endsWith("pc")) {
            string = string.substring(0, string.length() - 2);
            d2 = 15.0;
        } else if (string.endsWith("mm")) {
            string = string.substring(0, string.length() - 2);
            d2 = 3.543307;
        } else if (string.endsWith("cm")) {
            string = string.substring(0, string.length() - 2);
            d2 = 35.43307;
        } else if (string.endsWith("in")) {
            string = string.substring(0, string.length() - 2);
            d2 = 90.0;
        } else if (string.endsWith("em")) {
            string = string.substring(0, string.length() - 2);
            d2 = this.toLength(iXMLElement, this.readAttribute(iXMLElement, "font-size", "0"), d);
        } else {
            d2 = 1.0;
        }
        return Double.parseDouble(string) * d2;
    }

    public static String[] toCommaSeparatedArray(String string) throws IOException {
        return string.split("\\s*,\\s*");
    }

    public static String[] toWSOrCommaSeparatedArray(String string) throws IOException {
        String[] stringArray = string.split("(\\s*,\\s*|\\s+)");
        if (stringArray.length == 1 && stringArray[0].equals("")) {
            return new String[0];
        }
        return stringArray;
    }

    public static String[] toQuotedAndCommaSeparatedArray(String string) throws IOException {
        LinkedList<String> linkedList = new LinkedList<String>();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(160, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.quoteChar(34);
        streamTokenizer.quoteChar(39);
        while (streamTokenizer.nextToken() != -1) {
            switch (streamTokenizer.ttype) {
                case -3: 
                case 34: 
                case 39: {
                    linkedList.add(streamTokenizer.sval);
                }
            }
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private Point2D.Double[] toPoints(IXMLElement iXMLElement, String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        Point2D.Double[] doubleArray = new Point2D.Double[stringTokenizer.countTokens() / 2];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = new Point2D.Double(this.toNumber(iXMLElement, stringTokenizer.nextToken()), this.toNumber(iXMLElement, stringTokenizer.nextToken()));
        }
        return doubleArray;
    }

    private BezierPath[] toPath(IXMLElement iXMLElement, String string) throws IOException {
        StreamPosTokenizer streamPosTokenizer;
        LinkedList<ArrayList> linkedList = new LinkedList<ArrayList>();
        ArrayList arrayList = null;
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        Point2D.Double double_3 = new Point2D.Double();
        if (this.toPathTokenizer == null) {
            streamPosTokenizer = new StreamPosTokenizer(new StringReader(string));
            streamPosTokenizer.resetSyntax();
            streamPosTokenizer.parseNumbers();
            streamPosTokenizer.parseExponents();
            streamPosTokenizer.parsePlusAsNumber();
            streamPosTokenizer.whitespaceChars(0, 32);
            streamPosTokenizer.whitespaceChars(44, 44);
            this.toPathTokenizer = streamPosTokenizer;
        } else {
            streamPosTokenizer = this.toPathTokenizer;
            streamPosTokenizer.setReader(new StringReader(string));
        }
        int n = 77;
        int n2 = 77;
        block21: while (streamPosTokenizer.nextToken() != -1) {
            if (streamPosTokenizer.ttype > 0) {
                n2 = (char)streamPosTokenizer.ttype;
            } else {
                n2 = n;
                streamPosTokenizer.pushBack();
            }
            switch (n2) {
                case 77: {
                    if (arrayList != null) {
                        linkedList.add(arrayList);
                    }
                    arrayList = new BezierPath();
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'M' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.x = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'M' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.y = streamPosTokenizer.nval;
                    ((BezierPath)arrayList).moveTo(double_.x, double_.y);
                    n = 76;
                    continue block21;
                }
                case 109: {
                    if (arrayList != null) {
                        linkedList.add(arrayList);
                    }
                    arrayList = new BezierPath();
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 'm' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.x += streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 'm' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.y += streamPosTokenizer.nval;
                    ((BezierPath)arrayList).moveTo(double_.x, double_.y);
                    n = 108;
                    continue block21;
                }
                case 90: 
                case 122: {
                    double_.x = ((BezierPath.Node)arrayList.get((int)0)).x[0];
                    double_.y = ((BezierPath.Node)arrayList.get((int)0)).y[0];
                    if (arrayList.size() > 1) {
                        BezierPath.Node node = (BezierPath.Node)arrayList.get(0);
                        BezierPath.Node node2 = (BezierPath.Node)arrayList.get(arrayList.size() - 1);
                        if (node.x[0] == node2.x[0] && node.y[0] == node2.y[0]) {
                            if ((node2.mask & 1) != 0) {
                                node.mask |= 1;
                                node.x[1] = node2.x[1];
                                node.y[1] = node2.y[1];
                            }
                            arrayList.remove(arrayList.size() - 1);
                        }
                    }
                    ((BezierPath)arrayList).setClosed(true);
                    continue block21;
                }
                case 76: {
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'L' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.x = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'L' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.y = streamPosTokenizer.nval;
                    ((BezierPath)arrayList).lineTo(double_.x, double_.y);
                    n = 76;
                    continue block21;
                }
                case 108: {
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 'l' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.x += streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 'l' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.y += streamPosTokenizer.nval;
                    ((BezierPath)arrayList).lineTo(double_.x, double_.y);
                    n = 108;
                    continue block21;
                }
                case 72: {
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'H' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.x = streamPosTokenizer.nval;
                    ((BezierPath)arrayList).lineTo(double_.x, double_.y);
                    n = 72;
                    continue block21;
                }
                case 104: {
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 'h' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.x += streamPosTokenizer.nval;
                    ((BezierPath)arrayList).lineTo(double_.x, double_.y);
                    n = 104;
                    continue block21;
                }
                case 86: {
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'V' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.y = streamPosTokenizer.nval;
                    ((BezierPath)arrayList).lineTo(double_.x, double_.y);
                    n = 86;
                    continue block21;
                }
                case 118: {
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 'v' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.y += streamPosTokenizer.nval;
                    ((BezierPath)arrayList).lineTo(double_.x, double_.y);
                    n = 118;
                    continue block21;
                }
                case 67: {
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("x1 coordinate missing for 'C' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_2.x = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("y1 coordinate missing for 'C' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_2.y = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("x2 coordinate missing for 'C' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_3.x = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("y2 coordinate missing for 'C' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_3.y = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'C' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.x = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'C' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.y = streamPosTokenizer.nval;
                    ((BezierPath)arrayList).curveTo(double_2.x, double_2.y, double_3.x, double_3.y, double_.x, double_.y);
                    n = 67;
                    continue block21;
                }
                case 99: {
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dx1 coordinate missing for 'c' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_2.x = double_.x + streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dy1 coordinate missing for 'c' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_2.y = double_.y + streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dx2 coordinate missing for 'c' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_3.x = double_.x + streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dy2 coordinate missing for 'c' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_3.y = double_.y + streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 'c' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.x += streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 'c' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.y += streamPosTokenizer.nval;
                    ((BezierPath)arrayList).curveTo(double_2.x, double_2.y, double_3.x, double_3.y, double_.x, double_.y);
                    n = 99;
                    continue block21;
                }
                case 83: {
                    BezierPath.Node node = (BezierPath.Node)arrayList.get(arrayList.size() - 1);
                    double_2.x = node.x[0] * 2.0 - node.x[1];
                    double_2.y = node.y[0] * 2.0 - node.y[1];
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("x2 coordinate missing for 'S' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_3.x = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("y2 coordinate missing for 'S' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_3.y = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'S' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.x = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'S' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.y = streamPosTokenizer.nval;
                    ((BezierPath)arrayList).curveTo(double_2.x, double_2.y, double_3.x, double_3.y, double_.x, double_.y);
                    n = 83;
                    continue block21;
                }
                case 115: {
                    BezierPath.Node node = (BezierPath.Node)arrayList.get(arrayList.size() - 1);
                    double_2.x = node.x[0] * 2.0 - node.x[1];
                    double_2.y = node.y[0] * 2.0 - node.y[1];
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dx2 coordinate missing for 's' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_3.x = double_.x + streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dy2 coordinate missing for 's' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_3.y = double_.y + streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 's' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.x += streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 's' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.y += streamPosTokenizer.nval;
                    ((BezierPath)arrayList).curveTo(double_2.x, double_2.y, double_3.x, double_3.y, double_.x, double_.y);
                    n = 115;
                    continue block21;
                }
                case 81: {
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("x1 coordinate missing for 'Q' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_2.x = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("y1 coordinate missing for 'Q' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_2.y = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'Q' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.x = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'Q' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.y = streamPosTokenizer.nval;
                    ((BezierPath)arrayList).quadTo(double_2.x, double_2.y, double_.x, double_.y);
                    n = 81;
                    continue block21;
                }
                case 113: {
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dx1 coordinate missing for 'q' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_2.x = double_.x + streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dy1 coordinate missing for 'q' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_2.y = double_.y + streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 'q' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.x += streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 'q' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.y += streamPosTokenizer.nval;
                    ((BezierPath)arrayList).quadTo(double_2.x, double_2.y, double_.x, double_.y);
                    n = 113;
                    continue block21;
                }
                case 84: {
                    BezierPath.Node node = (BezierPath.Node)arrayList.get(arrayList.size() - 1);
                    double_2.x = node.x[0] * 2.0 - node.x[1];
                    double_2.y = node.y[0] * 2.0 - node.y[1];
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'T' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.x = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'T' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.y = streamPosTokenizer.nval;
                    ((BezierPath)arrayList).quadTo(double_2.x, double_2.y, double_.x, double_.y);
                    n = 84;
                    continue block21;
                }
                case 116: {
                    BezierPath.Node node = (BezierPath.Node)arrayList.get(arrayList.size() - 1);
                    double_2.x = node.x[0] * 2.0 - node.x[1];
                    double_2.y = node.y[0] * 2.0 - node.y[1];
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 't' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.x += streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 't' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.y += streamPosTokenizer.nval;
                    ((BezierPath)arrayList).quadTo(double_2.x, double_2.y, double_.x, double_.y);
                    n = 115;
                    continue block21;
                }
                case 65: {
                    boolean bl;
                    boolean bl2;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("rx coordinate missing for 'A' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double d = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("ry coordinate missing for 'A' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double d2 = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("x-axis-rotation missing for 'A' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double d3 = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("large-arc-flag missing for 'A' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    boolean bl3 = bl2 = streamPosTokenizer.nval != 0.0;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("sweep-flag missing for 'A' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    boolean bl4 = bl = streamPosTokenizer.nval != 0.0;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'A' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.x = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'A' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.y = streamPosTokenizer.nval;
                    ((BezierPath)arrayList).arcTo(d, d2, d3, bl2, bl, double_.x, double_.y);
                    n = 65;
                    continue block21;
                }
                case 97: {
                    boolean bl;
                    boolean bl2;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("rx coordinate missing for 'A' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double d = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("ry coordinate missing for 'A' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double d2 = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("x-axis-rotation missing for 'A' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double d3 = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("large-arc-flag missing for 'A' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    boolean bl5 = bl2 = streamPosTokenizer.nval != 0.0;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("sweep-flag missing for 'A' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    boolean bl6 = bl = streamPosTokenizer.nval != 0.0;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'A' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.x += streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'A' at position " + streamPosTokenizer.getStartPosition() + " in " + string);
                    }
                    double_.y += streamPosTokenizer.nval;
                    ((BezierPath)arrayList).arcTo(d, d2, d3, bl2, bl, double_.x, double_.y);
                    n = 97;
                    continue block21;
                }
            }
            break;
        }
        if (arrayList != null) {
            linkedList.add(arrayList);
        }
        return linkedList.toArray(new BezierPath[linkedList.size()]);
    }

    private void readCoreAttributes(IXMLElement iXMLElement, HashMap<AttributeKey, Object> hashMap) throws IOException {
    }

    private void identifyElements(IXMLElement iXMLElement) {
        this.identifiedElements.put(iXMLElement.getAttribute("id"), iXMLElement);
        this.identifiedElements.put(iXMLElement.getAttribute("xml:id"), iXMLElement);
        for (IXMLElement iXMLElement2 : iXMLElement.getChildren()) {
            this.identifyElements(iXMLElement2);
        }
    }

    private void readOpacityAttribute(IXMLElement iXMLElement, Map<AttributeKey, Object> map) throws IOException {
        double d = this.toDouble(iXMLElement, this.readAttribute(iXMLElement, "opacity", "1"), 1.0, 0.0, 1.0);
        SVGAttributeKeys.OPACITY.put(map, d);
    }

    private void readTextAttributes(IXMLElement iXMLElement, Map<AttributeKey, Object> map) throws IOException {
        String string = this.readInheritAttribute(iXMLElement, "text-anchor", "start");
        if (SVGConstants.SVG_TEXT_ANCHORS.get(string) != null) {
            SVGAttributeKeys.TEXT_ANCHOR.put(map, SVGConstants.SVG_TEXT_ANCHORS.get(string));
        }
        if (!(string = this.readInheritAttribute(iXMLElement, "display-align", "auto")).equals("auto")) {
            if (string.equals("center")) {
                SVGAttributeKeys.TEXT_ANCHOR.put(map, SVGAttributeKeys.TextAnchor.MIDDLE);
            } else if (string.equals("before")) {
                SVGAttributeKeys.TEXT_ANCHOR.put(map, SVGAttributeKeys.TextAnchor.END);
            }
        }
        if (!(string = this.readInheritAttribute(iXMLElement, "text-align", "start")).equals("start")) {
            SVGAttributeKeys.TEXT_ALIGN.put(map, SVGConstants.SVG_TEXT_ALIGNS.get(string));
        }
    }

    private void readTextFlowAttributes(IXMLElement iXMLElement, HashMap<AttributeKey, Object> hashMap) throws IOException {
        String string = this.readInheritAttribute(iXMLElement, "line-increment", "auto");
    }

    private void readTransformAttribute(IXMLElement iXMLElement, HashMap<AttributeKey, Object> hashMap) throws IOException {
        String string = this.readAttribute(iXMLElement, "transform", "none");
        if (!string.equals("none")) {
            SVGAttributeKeys.TRANSFORM.put(hashMap, SVGInputFormat.toTransform(iXMLElement, string));
        }
    }

    private void readSolidColorElement(IXMLElement iXMLElement) throws IOException {
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(iXMLElement, hashMap);
        Color color = this.toColor(iXMLElement, this.readAttribute(iXMLElement, "solid-color", "black"));
        double d = this.toDouble(iXMLElement, this.readAttribute(iXMLElement, "solid-opacity", "1"), 1.0, 0.0, 1.0);
        if (d != 1.0) {
            color = new Color((int)(255.0 * d) << 24 | 0xFFFFFF & color.getRGB(), true);
        }
        this.elementObjects.put(iXMLElement, color);
    }

    private void readShapeAttributes(IXMLElement iXMLElement, HashMap<AttributeKey, Object> hashMap) throws IOException {
        Object object = this.toPaint(iXMLElement, this.readInheritColorAttribute(iXMLElement, "fill", "black"));
        if (object instanceof Color) {
            SVGAttributeKeys.FILL_COLOR.put(hashMap, (Color)object);
        } else if (object instanceof Gradient) {
            SVGAttributeKeys.FILL_GRADIENT.putClone(hashMap, (Gradient)object);
        } else if (object == null) {
            SVGAttributeKeys.FILL_COLOR.put(hashMap, null);
        } else {
            SVGAttributeKeys.FILL_COLOR.put(hashMap, null);
        }
        object = this.readInheritAttribute(iXMLElement, "fill-opacity", "1");
        SVGAttributeKeys.FILL_OPACITY.put(hashMap, this.toDouble(iXMLElement, (String)object, 1.0, 0.0, 1.0));
        String string = this.readInheritAttribute(iXMLElement, "fill-rule", "nonzero");
        SVGAttributeKeys.WINDING_RULE.put(hashMap, SVGConstants.SVG_FILL_RULES.get(string));
        object = this.toPaint(iXMLElement, this.readInheritColorAttribute(iXMLElement, "stroke", "none"));
        if (object instanceof Color) {
            SVGAttributeKeys.STROKE_COLOR.put(hashMap, (Color)object);
        } else if (object instanceof Gradient) {
            SVGAttributeKeys.STROKE_GRADIENT.putClone(hashMap, (Gradient)object);
        } else if (object == null) {
            SVGAttributeKeys.STROKE_COLOR.put(hashMap, null);
        } else {
            SVGAttributeKeys.STROKE_COLOR.put(hashMap, null);
        }
        string = this.readInheritAttribute(iXMLElement, "stroke-dasharray", "none");
        if (!string.equals("none")) {
            String[] stringArray = SVGInputFormat.toWSOrCommaSeparatedArray(string);
            double[] dArray = new double[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                dArray[i] = this.toNumber(iXMLElement, stringArray[i]);
            }
            SVGAttributeKeys.STROKE_DASHES.put(hashMap, dArray);
        }
        double d = this.toNumber(iXMLElement, this.readInheritAttribute(iXMLElement, "stroke-dashoffset", "0"));
        SVGAttributeKeys.STROKE_DASH_PHASE.put(hashMap, d);
        SVGAttributeKeys.IS_STROKE_DASH_FACTOR.put(hashMap, false);
        string = this.readInheritAttribute(iXMLElement, "stroke-linecap", "butt");
        SVGAttributeKeys.STROKE_CAP.put(hashMap, SVGConstants.SVG_STROKE_LINECAPS.get(string));
        string = this.readInheritAttribute(iXMLElement, "stroke-linejoin", "miter");
        SVGAttributeKeys.STROKE_JOIN.put(hashMap, SVGConstants.SVG_STROKE_LINEJOINS.get(string));
        d = this.toDouble(iXMLElement, this.readInheritAttribute(iXMLElement, "stroke-miterlimit", "4"), 4.0, 1.0, Double.MAX_VALUE);
        SVGAttributeKeys.STROKE_MITER_LIMIT.put(hashMap, d);
        SVGAttributeKeys.IS_STROKE_MITER_LIMIT_FACTOR.put(hashMap, false);
        object = this.readInheritAttribute(iXMLElement, "stroke-opacity", "1");
        SVGAttributeKeys.STROKE_OPACITY.put(hashMap, this.toDouble(iXMLElement, (String)object, 1.0, 0.0, 1.0));
        d = this.toNumber(iXMLElement, this.readInheritAttribute(iXMLElement, "stroke-width", "1"));
        SVGAttributeKeys.STROKE_WIDTH.put(hashMap, d);
    }

    private void readUseShapeAttributes(IXMLElement iXMLElement, HashMap<AttributeKey, Object> hashMap) throws IOException {
        double d;
        String string;
        Object object = this.readInheritColorAttribute(iXMLElement, "fill", null);
        if (object != null) {
            if ((object = this.toPaint(iXMLElement, (String)object)) instanceof Color) {
                SVGAttributeKeys.FILL_COLOR.put(hashMap, (Color)object);
            } else if (object instanceof Gradient) {
                SVGAttributeKeys.FILL_GRADIENT.put(hashMap, (Gradient)object);
            } else if (object == null) {
                SVGAttributeKeys.FILL_COLOR.put(hashMap, null);
            } else {
                SVGAttributeKeys.FILL_COLOR.put(hashMap, null);
            }
        }
        if ((object = this.readInheritAttribute(iXMLElement, "fill-opacity", null)) != null) {
            SVGAttributeKeys.FILL_OPACITY.put(hashMap, this.toDouble(iXMLElement, (String)object, 1.0, 0.0, 1.0));
        }
        if ((string = this.readInheritAttribute(iXMLElement, "fill-rule", null)) != null) {
            SVGAttributeKeys.WINDING_RULE.put(hashMap, SVGConstants.SVG_FILL_RULES.get(string));
        }
        if ((object = this.toPaint(iXMLElement, this.readInheritColorAttribute(iXMLElement, "stroke", null))) != null) {
            if (object instanceof Color) {
                SVGAttributeKeys.STROKE_COLOR.put(hashMap, (Color)object);
            } else if (object instanceof Gradient) {
                SVGAttributeKeys.STROKE_GRADIENT.put(hashMap, (Gradient)object);
            }
        }
        if ((string = this.readInheritAttribute(iXMLElement, "stroke-dasharray", null)) != null && !string.equals("none")) {
            String[] stringArray = SVGInputFormat.toCommaSeparatedArray(string);
            double[] dArray = new double[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                dArray[i] = this.toNumber(iXMLElement, stringArray[i]);
            }
            SVGAttributeKeys.STROKE_DASHES.put(hashMap, dArray);
        }
        if ((object = this.readInheritAttribute(iXMLElement, "stroke-dashoffset", null)) != null) {
            d = this.toNumber(iXMLElement, (String)object);
            SVGAttributeKeys.STROKE_DASH_PHASE.put(hashMap, d);
            SVGAttributeKeys.IS_STROKE_DASH_FACTOR.put(hashMap, false);
        }
        if ((string = this.readInheritAttribute(iXMLElement, "stroke-linecap", null)) != null) {
            SVGAttributeKeys.STROKE_CAP.put(hashMap, SVGConstants.SVG_STROKE_LINECAPS.get(string));
        }
        if ((string = this.readInheritAttribute(iXMLElement, "stroke-linejoin", null)) != null) {
            SVGAttributeKeys.STROKE_JOIN.put(hashMap, SVGConstants.SVG_STROKE_LINEJOINS.get(string));
        }
        if ((object = this.readInheritAttribute(iXMLElement, "stroke-miterlimit", null)) != null) {
            d = this.toDouble(iXMLElement, (String)object, 4.0, 1.0, Double.MAX_VALUE);
            SVGAttributeKeys.STROKE_MITER_LIMIT.put(hashMap, d);
            SVGAttributeKeys.IS_STROKE_MITER_LIMIT_FACTOR.put(hashMap, false);
        }
        if ((object = this.readInheritAttribute(iXMLElement, "stroke-opacity", null)) != null) {
            SVGAttributeKeys.STROKE_OPACITY.put(hashMap, this.toDouble(iXMLElement, (String)object, 1.0, 0.0, 1.0));
        }
        if ((object = this.readInheritAttribute(iXMLElement, "stroke-width", null)) != null) {
            d = this.toNumber(iXMLElement, (String)object);
            SVGAttributeKeys.STROKE_WIDTH.put(hashMap, d);
        }
    }

    private void readLineAttributes(IXMLElement iXMLElement, HashMap<AttributeKey, Object> hashMap) throws IOException {
        Object object = this.toPaint(iXMLElement, this.readInheritColorAttribute(iXMLElement, "fill", "none"));
        if (object instanceof Color) {
            SVGAttributeKeys.FILL_COLOR.put(hashMap, (Color)object);
        } else if (object instanceof Gradient) {
            SVGAttributeKeys.FILL_GRADIENT.putClone(hashMap, (Gradient)object);
        } else if (object == null) {
            SVGAttributeKeys.FILL_COLOR.put(hashMap, null);
        } else {
            SVGAttributeKeys.FILL_COLOR.put(hashMap, null);
        }
        object = this.readInheritAttribute(iXMLElement, "fill-opacity", "1");
        SVGAttributeKeys.FILL_OPACITY.put(hashMap, this.toDouble(iXMLElement, (String)object, 1.0, 0.0, 1.0));
        String string = this.readInheritAttribute(iXMLElement, "fill-rule", "nonzero");
        SVGAttributeKeys.WINDING_RULE.put(hashMap, SVGConstants.SVG_FILL_RULES.get(string));
        object = this.toPaint(iXMLElement, this.readInheritColorAttribute(iXMLElement, "stroke", "black"));
        if (object instanceof Color) {
            SVGAttributeKeys.STROKE_COLOR.put(hashMap, (Color)object);
        } else if (object instanceof Gradient) {
            SVGAttributeKeys.STROKE_GRADIENT.putClone(hashMap, (Gradient)object);
        } else if (object == null) {
            SVGAttributeKeys.STROKE_COLOR.put(hashMap, null);
        } else {
            SVGAttributeKeys.STROKE_COLOR.put(hashMap, null);
        }
        string = this.readInheritAttribute(iXMLElement, "stroke-dasharray", "none");
        if (!string.equals("none")) {
            String[] stringArray = SVGInputFormat.toWSOrCommaSeparatedArray(string);
            double[] dArray = new double[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                dArray[i] = this.toNumber(iXMLElement, stringArray[i]);
            }
            SVGAttributeKeys.STROKE_DASHES.put(hashMap, dArray);
        }
        double d = this.toNumber(iXMLElement, this.readInheritAttribute(iXMLElement, "stroke-dashoffset", "0"));
        SVGAttributeKeys.STROKE_DASH_PHASE.put(hashMap, d);
        SVGAttributeKeys.IS_STROKE_DASH_FACTOR.put(hashMap, false);
        string = this.readInheritAttribute(iXMLElement, "stroke-linecap", "butt");
        SVGAttributeKeys.STROKE_CAP.put(hashMap, SVGConstants.SVG_STROKE_LINECAPS.get(string));
        string = this.readInheritAttribute(iXMLElement, "stroke-linejoin", "miter");
        SVGAttributeKeys.STROKE_JOIN.put(hashMap, SVGConstants.SVG_STROKE_LINEJOINS.get(string));
        d = this.toDouble(iXMLElement, this.readInheritAttribute(iXMLElement, "stroke-miterlimit", "4"), 4.0, 1.0, Double.MAX_VALUE);
        SVGAttributeKeys.STROKE_MITER_LIMIT.put(hashMap, d);
        SVGAttributeKeys.IS_STROKE_MITER_LIMIT_FACTOR.put(hashMap, false);
        object = this.readInheritAttribute(iXMLElement, "stroke-opacity", "1");
        SVGAttributeKeys.STROKE_OPACITY.put(hashMap, this.toDouble(iXMLElement, (String)object, 1.0, 0.0, 1.0));
        d = this.toNumber(iXMLElement, this.readInheritAttribute(iXMLElement, "stroke-width", "1"));
        SVGAttributeKeys.STROKE_WIDTH.put(hashMap, d);
    }

    private void readViewportAttributes(IXMLElement iXMLElement, HashMap<AttributeKey, Object> hashMap) throws IOException {
        Double d;
        Object object = this.readAttribute(iXMLElement, "width", null);
        if (object != null) {
            d = this.toLength(iXMLElement, (String)object, this.viewportStack.peek().widthPercentFactor);
            SVGAttributeKeys.VIEWPORT_WIDTH.put(hashMap, d);
        }
        if ((object = this.readAttribute(iXMLElement, "height", null)) != null) {
            d = this.toLength(iXMLElement, (String)object, this.viewportStack.peek().heightPercentFactor);
            SVGAttributeKeys.VIEWPORT_HEIGHT.put(hashMap, d);
        }
        if ((object = this.toPaint(iXMLElement, this.readInheritColorAttribute(iXMLElement, "viewport-fill", "none"))) == null || object instanceof Color) {
            SVGAttributeKeys.VIEWPORT_FILL.put(hashMap, (Color)object);
        }
        d = this.toDouble(iXMLElement, this.readAttribute(iXMLElement, "viewport-fill-opacity", "1.0"));
        SVGAttributeKeys.VIEWPORT_FILL_OPACITY.put(hashMap, d);
    }

    private void readGraphicsAttributes(IXMLElement iXMLElement, Figure figure) throws IOException {
        String string = this.readAttribute(iXMLElement, "display", "inline");
        string = this.readInheritAttribute(iXMLElement, "image-rendering", "auto");
        string = this.readInheritAttribute(iXMLElement, "pointer-events", "visiblePainted");
        string = this.readInheritAttribute(iXMLElement, "shape-rendering", "auto");
        string = this.readInheritAttribute(iXMLElement, "text-rendering", "auto");
        string = this.readAttribute(iXMLElement, "vector-effect", "none");
        string = this.readInheritAttribute(iXMLElement, "visibility", null);
    }

    private void readLinearGradientElement(IXMLElement iXMLElement) throws IOException {
        Object object;
        Object object2;
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(iXMLElement, hashMap);
        double d = this.toLength(iXMLElement, this.readAttribute(iXMLElement, "x1", "0"), 0.01);
        double d2 = this.toLength(iXMLElement, this.readAttribute(iXMLElement, "y1", "0"), 0.01);
        double d3 = this.toLength(iXMLElement, this.readAttribute(iXMLElement, "x2", "1"), 0.01);
        double d4 = this.toLength(iXMLElement, this.readAttribute(iXMLElement, "y2", "0"), 0.01);
        boolean bl = this.readAttribute(iXMLElement, "gradientUnits", "objectBoundingBox").equals("objectBoundingBox");
        ArrayList<IXMLElement> arrayList = iXMLElement.getChildrenNamed("stop", "http://www.w3.org/2000/svg");
        if (arrayList.size() == 0) {
            arrayList = iXMLElement.getChildrenNamed("stop");
        }
        if (arrayList.size() == 0 && ((String)(object2 = this.readAttribute(iXMLElement, "xlink:href", ""))).startsWith("#") && this.identifiedElements.get(((String)object2).substring(1)) != null && (arrayList = this.identifiedElements.get(((String)object2).substring(1)).getChildrenNamed("stop", "http://www.w3.org/2000/svg")).size() == 0) {
            arrayList = this.identifiedElements.get(((String)object2).substring(1)).getChildrenNamed("stop");
        }
        if (arrayList.size() == 0) {
            // empty if block
        }
        object2 = new double[arrayList.size()];
        Color[] colorArray = new Color[arrayList.size()];
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object = arrayList.get(i);
            String string = this.readAttribute((IXMLElement)object, "offset", "0");
            object2[i] = string.endsWith("%") ? (Object)(this.toDouble((IXMLElement)object, string.substring(0, string.length() - 1), 0.0, 0.0, 100.0) / 100.0) : (Object)this.toDouble((IXMLElement)object, string, 0.0, 0.0, 1.0);
            colorArray[i] = this.toColor((IXMLElement)object, this.readAttribute((IXMLElement)object, "stop-color", "black"));
            if (colorArray[i] == null) {
                colorArray[i] = new Color(0, true);
            }
            dArray[i] = this.toDouble((IXMLElement)object, this.readAttribute((IXMLElement)object, "stop-opacity", "1"), 1.0, 0.0, 1.0);
        }
        AffineTransform affineTransform = SVGInputFormat.toTransform(iXMLElement, this.readAttribute(iXMLElement, "gradientTransform", "none"));
        object = this.factory.createLinearGradient(d, d2, d3, d4, (double[])object2, colorArray, dArray, bl, affineTransform);
        this.elementObjects.put(iXMLElement, object);
    }

    private void readRadialGradientElement(IXMLElement iXMLElement) throws IOException {
        Object object;
        Object object2;
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        this.readCoreAttributes(iXMLElement, hashMap);
        double d = this.toLength(iXMLElement, this.readAttribute(iXMLElement, "cx", "0.5"), 0.01);
        double d2 = this.toLength(iXMLElement, this.readAttribute(iXMLElement, "cy", "0.5"), 0.01);
        double d3 = this.toLength(iXMLElement, this.readAttribute(iXMLElement, "fx", this.readAttribute(iXMLElement, "cx", "0.5")), 0.01);
        double d4 = this.toLength(iXMLElement, this.readAttribute(iXMLElement, "fy", this.readAttribute(iXMLElement, "cy", "0.5")), 0.01);
        double d5 = this.toLength(iXMLElement, this.readAttribute(iXMLElement, "r", "0.5"), 0.01);
        boolean bl = this.readAttribute(iXMLElement, "gradientUnits", "objectBoundingBox").equals("objectBoundingBox");
        ArrayList<IXMLElement> arrayList = iXMLElement.getChildrenNamed("stop", "http://www.w3.org/2000/svg");
        if (arrayList.size() == 0) {
            arrayList = iXMLElement.getChildrenNamed("stop");
        }
        if (arrayList.size() == 0 && ((String)(object2 = (Object)this.readAttribute(iXMLElement, "xlink:href", ""))).startsWith("#") && this.identifiedElements.get(((String)object2).substring(1)) != null && (arrayList = this.identifiedElements.get(((String)object2).substring(1)).getChildrenNamed("stop", "http://www.w3.org/2000/svg")).size() == 0) {
            arrayList = this.identifiedElements.get(((String)object2).substring(1)).getChildrenNamed("stop");
        }
        object2 = new double[arrayList.size()];
        Color[] colorArray = new Color[arrayList.size()];
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object = arrayList.get(i);
            String string = this.readAttribute((IXMLElement)object, "offset", "0");
            object2[i] = string.endsWith("%") ? (Object)(this.toDouble((IXMLElement)object, string.substring(0, string.length() - 1), 0.0, 0.0, 100.0) / 100.0) : (Object)this.toDouble((IXMLElement)object, string, 0.0, 0.0, 1.0);
            colorArray[i] = this.toColor((IXMLElement)object, this.readAttribute((IXMLElement)object, "stop-color", "black"));
            if (colorArray[i] == null) {
                colorArray[i] = new Color(0, true);
            }
            dArray[i] = this.toDouble((IXMLElement)object, this.readAttribute((IXMLElement)object, "stop-opacity", "1"), 1.0, 0.0, 1.0);
        }
        AffineTransform affineTransform = SVGInputFormat.toTransform(iXMLElement, this.readAttribute(iXMLElement, "gradientTransform", "none"));
        object = this.factory.createRadialGradient(d, d2, d3, d4, d5, (double[])object2, colorArray, dArray, bl, affineTransform);
        this.elementObjects.put(iXMLElement, object);
    }

    private void readFontAttributes(IXMLElement iXMLElement, Map<AttributeKey, Object> map) throws IOException {
        String string = this.readInheritAttribute(iXMLElement, "font-family", "Dialog");
        String[] stringArray = SVGInputFormat.toQuotedAndCommaSeparatedArray(string);
        Font font = null;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                font = (Font)this.fontFormatter.stringToValue(stringArray[i]);
                break;
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        if (font == null && stringArray.length > 0) {
            this.fontFormatter.setAllowsUnknownFont(true);
            try {
                font = (Font)this.fontFormatter.stringToValue(stringArray[0]);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.fontFormatter.setAllowsUnknownFont(false);
        }
        if (font == null) {
            font = new Font("Dialog", 0, 12);
        }
        SVGAttributeKeys.FONT_FACE.put(map, font);
        double d = this.readInheritFontSizeAttribute(iXMLElement, "font-size", "medium");
        SVGAttributeKeys.FONT_SIZE.put(map, d);
        string = this.readInheritAttribute(iXMLElement, "font-style", "normal");
        SVGAttributeKeys.FONT_ITALIC.put(map, string.equals("italic"));
        string = this.readInheritAttribute(iXMLElement, "font-variant", "normal");
        string = this.readInheritAttribute(iXMLElement, "font-weight", "normal");
        SVGAttributeKeys.FONT_BOLD.put(map, string.equals("bold") || string.equals("bolder") || string.equals("400") || string.equals("500") || string.equals("600") || string.equals("700") || string.equals("800") || string.equals("900"));
        string = this.readAttribute(iXMLElement, "text-decoration", "none");
        SVGAttributeKeys.FONT_UNDERLINE.put(map, string.equals("underline"));
    }

    private Object toPaint(IXMLElement iXMLElement, String string) throws IOException {
        String string2 = string;
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim().toLowerCase()).equals("none")) {
            return null;
        }
        if (string2.equals("currentcolor")) {
            String string3 = this.readInheritAttribute(iXMLElement, "color", "black");
            if (string3 == null || string3.trim().toLowerCase().equals("currentColor")) {
                return null;
            }
            return this.toPaint(iXMLElement, string3);
        }
        if (SVGConstants.SVG_COLORS.containsKey(string2)) {
            return SVGConstants.SVG_COLORS.get(string2);
        }
        if (string2.startsWith("#") && string2.length() == 7) {
            return new Color(Integer.decode(string2));
        }
        if (string2.startsWith("#") && string2.length() == 4) {
            int n = Integer.decode(string2);
            return new Color(n & 0xF | (n & 0xF) << 4 | (n & 0xF0) << 4 | (n & 0xF0) << 8 | (n & 0xF00) << 8 | (n & 0xF00) << 12);
        }
        if (string2.startsWith("rgb")) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "() ,");
                stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                Color color = new Color(string4.endsWith("%") ? (int)(Double.parseDouble(string4.substring(0, string4.length() - 1)) * 2.55) : Integer.decode(string4), string5.endsWith("%") ? (int)(Double.parseDouble(string5.substring(0, string5.length() - 1)) * 2.55) : Integer.decode(string5), string6.endsWith("%") ? (int)(Double.parseDouble(string6.substring(0, string6.length() - 1)) * 2.55) : Integer.decode(string6));
                return color;
            }
            catch (Exception exception) {
                System.out.println("SVGInputFormat.toPaint illegal RGB value " + string2);
                exception.printStackTrace();
                return null;
            }
        }
        if (string2.startsWith("url(")) {
            String string7 = string.substring(4, string.length() - 1);
            if (this.identifiedElements.containsKey(string7.substring(1)) && this.elementObjects.containsKey(this.identifiedElements.get(string7.substring(1)))) {
                Object object = this.elementObjects.get(this.identifiedElements.get(string7.substring(1)));
                return object;
            }
            return null;
        }
        return null;
    }

    private Color toColor(IXMLElement iXMLElement, String string) throws IOException {
        String string2 = string;
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim().toLowerCase()).equals("currentcolor")) {
            String string3 = this.readInheritAttribute(iXMLElement, "color", "black");
            if (string3 == null || string3.trim().toLowerCase().equals("currentColor")) {
                return null;
            }
            return this.toColor(iXMLElement, string3);
        }
        if (SVGConstants.SVG_COLORS.containsKey(string2)) {
            return SVGConstants.SVG_COLORS.get(string2);
        }
        if (string2.startsWith("#") && string2.length() == 7) {
            return new Color(Integer.decode(string2));
        }
        if (string2.startsWith("#") && string2.length() == 4) {
            int n = Integer.decode(string2);
            return new Color(n & 0xF | (n & 0xF) << 4 | (n & 0xF0) << 4 | (n & 0xF0) << 8 | (n & 0xF00) << 8 | (n & 0xF00) << 12);
        }
        if (string2.startsWith("rgb")) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "() ,");
                stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                Color color = new Color(string4.endsWith("%") ? (int)((double)Integer.decode(string4.substring(0, string4.length() - 1)).intValue() * 2.55) : Integer.decode(string4), string5.endsWith("%") ? (int)((double)Integer.decode(string5.substring(0, string5.length() - 1)).intValue() * 2.55) : Integer.decode(string5), string6.endsWith("%") ? (int)((double)Integer.decode(string6.substring(0, string6.length() - 1)).intValue() * 2.55) : Integer.decode(string6));
                return color;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (string2.startsWith("url")) {
            return null;
        }
        return null;
    }

    private double toDouble(IXMLElement iXMLElement, String string) throws IOException {
        return this.toDouble(iXMLElement, string, 0.0, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    private double toDouble(IXMLElement iXMLElement, String string, double d, double d2, double d3) throws IOException {
        try {
            double d4 = Double.valueOf(string);
            return Math.max(Math.min(d4, d3), d2);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    private String toText(IXMLElement iXMLElement, String string) throws IOException {
        String string2 = this.readInheritAttribute(iXMLElement, "xml:space", "default");
        if (string2.equals("default")) {
            return string.trim().replaceAll("\\s++", " ");
        }
        return string;
    }

    public static AffineTransform toTransform(IXMLElement iXMLElement, String string) throws IOException {
        AffineTransform affineTransform = new AffineTransform();
        if (string != null && !string.equals("none")) {
            StreamPosTokenizer streamPosTokenizer = new StreamPosTokenizer(new StringReader(string));
            streamPosTokenizer.resetSyntax();
            streamPosTokenizer.wordChars(97, 122);
            streamPosTokenizer.wordChars(65, 90);
            streamPosTokenizer.wordChars(160, 255);
            streamPosTokenizer.whitespaceChars(0, 32);
            streamPosTokenizer.whitespaceChars(44, 44);
            streamPosTokenizer.parseNumbers();
            streamPosTokenizer.parseExponents();
            while (streamPosTokenizer.nextToken() != -1) {
                double d;
                if (streamPosTokenizer.ttype != -3) {
                    throw new IOException("Illegal transform " + string);
                }
                String string2 = streamPosTokenizer.sval;
                if (streamPosTokenizer.nextToken() != 40) {
                    throw new IOException("'(' not found in transform " + string);
                }
                if (string2.equals("matrix")) {
                    double[] dArray = new double[6];
                    for (int i = 0; i < 6; ++i) {
                        if (streamPosTokenizer.nextToken() != -2) {
                            throw new IOException("Matrix value " + i + " not found in transform " + string + " token:" + streamPosTokenizer.ttype + " " + streamPosTokenizer.sval);
                        }
                        dArray[i] = streamPosTokenizer.nval;
                    }
                    affineTransform.concatenate(new AffineTransform(dArray));
                } else if (string2.equals("translate")) {
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("X-translation value not found in transform " + string);
                    }
                    double d2 = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() == -2) {
                        d = streamPosTokenizer.nval;
                    } else {
                        streamPosTokenizer.pushBack();
                        d = 0.0;
                    }
                    affineTransform.translate(d2, d);
                } else if (string2.equals("scale")) {
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("X-scale value not found in transform " + string);
                    }
                    double d3 = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() == -2) {
                        d = streamPosTokenizer.nval;
                    } else {
                        streamPosTokenizer.pushBack();
                        d = d3;
                    }
                    affineTransform.scale(d3, d);
                } else if (string2.equals("rotate")) {
                    double d4;
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("Angle value not found in transform " + string);
                    }
                    double d5 = streamPosTokenizer.nval;
                    if (streamPosTokenizer.nextToken() == -2) {
                        d = streamPosTokenizer.nval;
                        if (streamPosTokenizer.nextToken() != -2) {
                            throw new IOException("Y-center value not found in transform " + string);
                        }
                        d4 = streamPosTokenizer.nval;
                    } else {
                        streamPosTokenizer.pushBack();
                        d4 = 0.0;
                        d = 0.0;
                    }
                    affineTransform.rotate(d5 * Math.PI / 180.0, d, d4);
                } else if (string2.equals("skewX")) {
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("Skew angle not found in transform " + string);
                    }
                    double d6 = streamPosTokenizer.nval;
                    affineTransform.concatenate(new AffineTransform(1.0, 0.0, Math.tan(d6 * Math.PI / 180.0), 1.0, 0.0, 0.0));
                } else if (string2.equals("skewY")) {
                    if (streamPosTokenizer.nextToken() != -2) {
                        throw new IOException("Skew angle not found in transform " + string);
                    }
                    double d7 = streamPosTokenizer.nval;
                    affineTransform.concatenate(new AffineTransform(1.0, Math.tan(d7 * Math.PI / 180.0), 0.0, 1.0, 0.0, 0.0));
                } else if (string2.equals("ref")) {
                    System.err.println("SVGInputFormat warning: ignored ref(...) transform attribute in element " + iXMLElement);
                    while (streamPosTokenizer.nextToken() != 41 && streamPosTokenizer.ttype != -1) {
                    }
                    streamPosTokenizer.pushBack();
                } else {
                    throw new IOException("Unknown transform " + string2 + " in " + string + " in element " + iXMLElement);
                }
                if (streamPosTokenizer.nextToken() == 41) continue;
                throw new IOException("')' not found in transform " + string);
            }
        }
        return affineTransform;
    }

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter("Scalable Vector Graphics (SVG)", "svg");
    }

    @Override
    public JComponent getInputFormatAccessory() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(File file, Drawing drawing, boolean bl) throws IOException {
        this.url = file.toURL();
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            this.read(bufferedInputStream, drawing, bl);
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        this.url = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(URL uRL, Drawing drawing, boolean bl) throws IOException {
        this.url = uRL;
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            this.read(inputStream, drawing, bl);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        this.url = null;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.getPrimaryType().equals("image") && dataFlavor.getSubType().equals("svg+xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(Transferable transferable, Drawing drawing, boolean bl) throws UnsupportedFlavorException, IOException {
        InputStream inputStream = null;
        try {
            inputStream = (InputStream)transferable.getTransferData(new DataFlavor("image/svg+xml", "Image SVG"));
            this.read(inputStream, drawing, false);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private static class Viewport {
        public double width = 640.0;
        public double height = 480.0;
        public Rectangle2D.Double viewBox = new Rectangle2D.Double(0.0, 0.0, 640.0, 480.0);
        public double widthPercentFactor = 6.4;
        public double heightPercentFactor = 4.8;
        public double numberFactor;
        public boolean isPreserveAspectRatio = true;
        private HashMap<AttributeKey, Object> attributes = new HashMap();

        private Viewport() {
        }

        public String toString() {
            return "widthPercentFactor:" + this.widthPercentFactor + ";" + "heightPercentFactor:" + this.heightPercentFactor + ";" + "numberFactor:" + this.numberFactor + ";" + this.attributes;
        }
    }
}

