/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.zoom;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;
import org.jhotdraw.contrib.zoom.DoubleBufferImage;

public class ScalingGraphics
extends Graphics {
    private double scale = 1.0;
    private Graphics real;
    private Font userFont;
    private Rectangle userClip;

    public ScalingGraphics(Graphics graphics) {
        this.real = graphics;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getScale() {
        return this.scale;
    }

    private static Font scaledFont(Font font, double d) {
        int n = font.getSize();
        int n2 = (int)((double)n * d);
        return new Font(font.getFamily(), font.getStyle(), n2);
    }

    private static Shape scaledShape(Shape shape, double d) {
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            return new Rectangle((int)((double)rectangle.x * d), (int)((double)rectangle.y * d), (int)((double)rectangle.width * d), (int)((double)rectangle.height * d));
        }
        throw new RuntimeException("Cannot scale shape: " + shape.getClass().getName());
    }

    public Graphics create() {
        Graphics graphics = this.real.create();
        ScalingGraphics scalingGraphics = new ScalingGraphics(graphics);
        scalingGraphics.setScale(this.getScale());
        return scalingGraphics;
    }

    public void translate(int n, int n2) {
        this.real.translate((int)((double)n * this.scale), (int)((double)n2 * this.scale));
    }

    public Color getColor() {
        return this.real.getColor();
    }

    public void setColor(Color color) {
        this.real.setColor(color);
    }

    public void setPaintMode() {
        this.real.setPaintMode();
    }

    public void setXORMode(Color color) {
        this.real.setXORMode(color);
    }

    public Font getFont() {
        if (this.userFont == null) {
            this.userFont = this.real.getFont();
        }
        return this.userFont;
    }

    public void setFont(Font font) {
        this.userFont = font;
        this.real.setFont(ScalingGraphics.scaledFont(font, this.scale));
    }

    public FontMetrics getFontMetrics() {
        return new ScalingFontMetrics(this.userFont, this.real.getFontMetrics());
    }

    public FontMetrics getFontMetrics(Font font) {
        return new ScalingFontMetrics(font, this.real.getFontMetrics(ScalingGraphics.scaledFont(font, this.scale)));
    }

    public Rectangle getClipBounds() {
        return this.userClip;
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.userClip = this.userClip == null ? new Rectangle(n, n2, n3, n4) : this.userClip.intersection(new Rectangle(n, n2, n3, n4));
        this.real.clipRect((int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale));
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.userClip = new Rectangle(n, n2, n3, n4);
        this.real.setClip((int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale));
    }

    public Shape getClip() {
        return this.userClip;
    }

    public void setClip(Shape shape) {
        this.userClip = (Rectangle)shape;
        if (shape != null) {
            this.real.setClip(ScalingGraphics.scaledShape(shape, this.scale));
        } else {
            this.real.setClip(null);
        }
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.real.copyArea((int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale), (int)((double)n5 * this.scale), (int)((double)n6 * this.scale));
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.real.drawLine((int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale));
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.real.fillRect((int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale));
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.real.clearRect((int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale));
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.real.drawRoundRect((int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale), (int)((double)n5 * this.scale), (int)((double)n6 * this.scale));
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.real.fillRoundRect((int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale), (int)((double)n5 * this.scale), (int)((double)n6 * this.scale));
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.real.drawOval((int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale));
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.real.fillOval((int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale));
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.real.drawArc((int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale), n5, n6);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.real.fillArc((int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale), n5, n6);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = (int)((double)nArray[i] * this.scale);
            nArray4[i] = (int)((double)nArray2[i] * this.scale);
        }
        this.real.drawPolyline(nArray3, nArray4, n);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = (int)((double)nArray[i] * this.scale);
            nArray4[i] = (int)((double)nArray2[i] * this.scale);
        }
        this.real.drawPolygon(nArray3, nArray4, n);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = (int)((double)nArray[i] * this.scale);
            nArray4[i] = (int)((double)nArray2[i] * this.scale);
        }
        this.real.fillPolygon(nArray3, nArray4, n);
    }

    public void drawString(String string, int n, int n2) {
        this.real.drawString(string, (int)((double)n * this.scale), (int)((double)n2 * this.scale));
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.real.drawString(attributedCharacterIterator, (int)((double)n * this.scale), (int)((double)n2 * this.scale));
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (image instanceof DoubleBufferImage) {
            return this.real.drawImage(((DoubleBufferImage)image).getRealImage(), n, n2, imageObserver);
        }
        return this.real.drawImage(image, (int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)image.getWidth(imageObserver) * this.scale), (int)((double)image.getHeight(imageObserver) * this.scale), imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (image instanceof DoubleBufferImage) {
            return this.real.drawImage(((DoubleBufferImage)image).getRealImage(), n, n2, n3, n4, imageObserver);
        }
        return this.real.drawImage(image, (int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale), imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (image instanceof DoubleBufferImage) {
            return this.real.drawImage(((DoubleBufferImage)image).getRealImage(), n, n2, color, imageObserver);
        }
        return this.real.drawImage(image, (int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)image.getWidth(imageObserver) * this.scale), (int)((double)image.getHeight(imageObserver) * this.scale), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (image instanceof DoubleBufferImage) {
            return this.real.drawImage(((DoubleBufferImage)image).getRealImage(), n, n2, n3, n4, color, imageObserver);
        }
        return this.real.drawImage(image, (int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        if (image instanceof DoubleBufferImage) {
            return this.real.drawImage(((DoubleBufferImage)image).getRealImage(), n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
        }
        return this.real.drawImage(image, (int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale), (int)((double)n5 * this.scale), (int)((double)n6 * this.scale), (int)((double)n7 * this.scale), (int)((double)n8 * this.scale), imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (image instanceof DoubleBufferImage) {
            return this.real.drawImage(((DoubleBufferImage)image).getRealImage(), n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
        }
        return this.real.drawImage(image, (int)((double)n * this.scale), (int)((double)n2 * this.scale), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale), (int)((double)n5 * this.scale), (int)((double)n6 * this.scale), (int)((double)n7 * this.scale), (int)((double)n8 * this.scale), color, imageObserver);
    }

    public void dispose() {
        this.real.dispose();
    }

    private class ScalingFontMetrics
    extends FontMetrics {
        private FontMetrics real;
        private Font userFont;

        public ScalingFontMetrics(Font font, FontMetrics fontMetrics) {
            super(null);
            this.userFont = font;
            this.real = fontMetrics;
        }

        public Font getFont() {
            return this.userFont;
        }

        public int getAscent() {
            return (int)((double)this.real.getAscent() / ScalingGraphics.this.getScale());
        }

        public int getLeading() {
            return (int)((double)this.real.getLeading() / ScalingGraphics.this.getScale());
        }

        public int getMaxAdvance() {
            return (int)((double)this.real.getMaxAdvance() / ScalingGraphics.this.getScale());
        }

        public int charWidth(char c) {
            return (int)((double)this.real.charWidth(c) / ScalingGraphics.this.getScale());
        }

        public int charsWidth(char[] cArray, int n, int n2) {
            return (int)((double)this.real.charsWidth(cArray, n, n2) / ScalingGraphics.this.getScale());
        }
    }
}

