// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _TNaming_Builder_HeaderFile
#define _TNaming_Builder_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _TNaming_PtrDataMapOfShapePtrRefShape_HeaderFile
#include <TNaming_PtrDataMapOfShapePtrRefShape.hxx>
#endif
#ifndef _TNaming_PtrAttribute_HeaderFile
#include <TNaming_PtrAttribute.hxx>
#endif
#ifndef _Handle_TNaming_NamedShape_HeaderFile
#include <Handle_TNaming_NamedShape.hxx>
#endif
class Standard_ConstructionError;
class TDF_Label;
class TopoDS_Shape;
class TNaming_NamedShape;


//! A tool to create and maintain topological <br>
//! attributes. <br>
//! Constructor creates an empty <br>
//! TNaming_NamedShape attribute at the given <br>
//! label. It allows adding "old shape" and "new <br>
//! shape" pairs with the specified evolution to this <br>
//! named shape. One evolution type per one <br>
//! builder must be used. <br>
class TNaming_Builder  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //!  Create an   Builder. <br>
//!  Warning:  Before Addition copies the current Value, and clear <br>
  Standard_EXPORT   TNaming_Builder(const TDF_Label& aLabel);
  //!  Records the shape newShape which was <br>
//! generated during a topological construction. <br>
//!  As an example, consider the case of a face <br>
//!  generated in construction of a box. <br>
  Standard_EXPORT     void Generated(const TopoDS_Shape& newShape) ;
  //! Records the shape newShape which was <br>
//!  generated from the shape oldShape during a topological construction. <br>
//! As an example, consider the case of a face <br>
//! generated from an edge in construction of a prism. <br>
  Standard_EXPORT     void Generated(const TopoDS_Shape& oldShape,const TopoDS_Shape& newShape) ;
  //!  Records the shape oldShape which was deleted from the current label. <br>
//! As an example, consider the case of a face removed by a Boolean operation. <br>
  Standard_EXPORT     void Delete(const TopoDS_Shape& oldShape) ;
  //!  Records the shape newShape which is a <br>
//! modification of the shape oldShape. <br>
//! As an example, consider the case of a face split <br>
//!  or merged in a Boolean operation. <br>
//! <br>
  Standard_EXPORT     void Modify(const TopoDS_Shape& oldShape,const TopoDS_Shape& newShape) ;
  //! Records the shape newShape which is a <br>
//! modification of the shape oldShape but has a <br>
//! different geometry as a result of the construction operation. <br>
//! As an example, consider the case of a face <br>
//! resulting from construction of a draft in a box or prism. <br>
  Standard_EXPORT     void Replace(const TopoDS_Shape& oldShape,const TopoDS_Shape& newShape) ;
  //!   Add a  Shape to the current label ,  This Shape is <br>
//!          unmodified.  Used for example  to define a set <br>
//!          of shapes under a label. <br>
  Standard_EXPORT     void Select(const TopoDS_Shape& aShape,const TopoDS_Shape& inShape) ;
  //! Returns the NamedShape which has been build or is under construction. <br>
  Standard_EXPORT     Handle_TNaming_NamedShape NamedShape() const;





protected:





private:



TNaming_PtrDataMapOfShapePtrRefShape myMap;
TNaming_PtrAttribute myAtt;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
