// <copyright file="GlobalSuppressions.cs" company="WebDriver Committers">
// Licensed to the Software Freedom Conservancy (SFC) under one
// or more contributor license agreements. See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership. The SFC licenses this file
// to you under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// </copyright>

// This file is used by Code Analysis to maintain SuppressMessage
// attributes that are applied to this project.
// Project-level suppressions either have no target or are given
// a specific target and scoped to a namespace, type, member, etc.
//
// To add a suppression to this file, right-click the message in the
// Error List, point to "Suppress Message(s)", and click
// "In Project Suppression File".
// You do not need to add suppressions to this file manually.
[assembly: System.CLSCompliant(true)]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1006:DoNotNestGenericTypesInMemberSignatures", Scope = "member", Target = "OpenQA.Selenium.By.#FindElementsMethod", Justification = "Type is properly specified. It should be a Func<T, TResult> that returns a ReadOnlyCollection<IWebElement>")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1006:DoNotNestGenericTypesInMemberSignatures", Scope = "member", Target = "OpenQA.Selenium.By.#.ctor(System.Func`2<OpenQA.Selenium.ISearchContext,OpenQA.Selenium.IWebElement>,System.Func`2<OpenQA.Selenium.ISearchContext,System.Collections.ObjectModel.ReadOnlyCollection`1<OpenQA.Selenium.IWebElement>>)", Justification = "Type is properly specified. It should be a Func<T, TResult> that returns a ReadOnlyCollection<IWebElement>")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace", Target = "OpenQA.Selenium.Interactions", Justification = "Namespaces are properly scoped.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace", Target = "OpenQA.Selenium.Chrome", Justification = "Namespaces are properly scoped.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace", Target = "OpenQA.Selenium.Safari", Justification = "Namespaces are properly scoped.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "OpenQA.Selenium.ITakesScreenshot.#GetScreenshot()", Justification = "API specification demands method.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1027:MarkEnumsWithFlags", Scope = "type", Target = "OpenQA.Selenium.ProxyKind", Justification = "The ProxyKind enum is not a set of flags, but has values determined by an external API.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1027:MarkEnumsWithFlags", Scope = "type", Target = "OpenQA.Selenium.WebDriverResult", Justification = "The WebDriverResult enum is not a set of flags, but has values determined by an external API.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "OpenQA.Selenium.IWebDriver.#Url", Justification = "Specification demands string value for property.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "OpenQA.Selenium.Proxy.#ProxyAutoConfigUrl", Justification = "Proxy configuration can be string instead of Uri.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "OpenQA.Selenium.IE.InternetExplorerOptions.#InitialBrowserUrl", Justification = "InitialBrowserUrl should be string instead of Uri.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "OpenQA.Selenium.Chrome.ChromeDriverService.#UrlPathPrefix", Justification = "UrlPathPrefix is a prefix for use with ChromeDriver, and should be a string.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Globalization", "CA1303:Do not pass literals as localized parameters", MessageId = "System.Console.WriteLine(System.String,System.Object)", Scope = "member", Target = "OpenQA.Selenium.Internal.FileUtilities.#DeleteDirectory(System.String)", Justification = "Informational message only.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase", Scope = "member", Target = "OpenQA.Selenium.Firefox.Preferences.#SetPreferenceValue(System.String,System.Object)", Justification = "Strings are normalized to lower case by JSON wire protocol.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase", Scope = "member", Target = "OpenQA.Selenium.Remote.RemoteWebElement.#GetAttribute(System.String)", Justification = "Strings are normalized to lower case by JSON wire protocol.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase", Scope = "member", Target = "OpenQA.Selenium.Firefox.FirefoxDriverService.#CommandLineArguments", Justification = "Strings are normalized to lower case by JSON wire protocol.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase", Scope = "member", Target = "OpenQA.Selenium.Interactions.PointerInputDevice+PointerMoveInteraction.#Serialize()", Justification = "Strings are normalized to lower case by JSON wire protocol.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase", Scope = "member", Target = "OpenQA.Selenium.Interactions.PointerInputDevice.#Serialize()", Justification = "Strings are normalized to lower case by JSON wire protocol.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase", Scope = "member", Target = "OpenQA.Selenium.Firefox.FirefoxOptions.#GenerateFirefoxOptionsDictionary()", Justification = "Strings are normalized to lower case by JSON wire protocol.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase", Scope = "member", Target = "OpenQA.Selenium.Interactions.PointerInputDevice+PointerMoveInteraction.#ToDictionary()", Justification = "Strings are normalized to lower case by JSON wire protocol.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase", Scope = "member", Target = "OpenQA.Selenium.Interactions.PointerInputDevice.#ToDictionary()", Justification = "Strings are normalized to lower case by JSON wire protocol.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Maintainability", "CA1506:AvoidExcessiveClassCoupling", Scope = "type", Target = "OpenQA.Selenium.Remote.RemoteWebDriver", Justification = "RemoteWebDriver is a large class, and will have tight couplings with a lot of classes.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId = "OnScreen", Scope = "member", Target = "OpenQA.Selenium.Interactions.Internal.ICoordinates.#LocationOnScreen", Justification = "On Screen is properly used as two-word discrete term.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId = "OnScreen", Scope = "member", Target = "OpenQA.Selenium.ILocatable.#LocationOnScreenOnceScrolledIntoView", Justification = "On Screen is properly used as two-word discrete term.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId = "BridgePort", Scope = "member", Target = "OpenQA.Selenium.Chrome.ChromeDriverService.#AndroidDebugBridgePort", Justification = "Bridge Port is properly used as two-word discrete term.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId = "TouchScreen", Scope = "type", Target = "OpenQA.Selenium.IHasTouchScreen", Justification = "Touch Screen is properly used as two-word discrete term.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId = "TouchScreen", Scope = "member", Target = "OpenQA.Selenium.IHasTouchScreen.#TouchScreen", Justification = "Touch Screen is properly used as two-word discrete term.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId = "TouchScreen", Scope = "type", Target = "OpenQA.Selenium.ITouchScreen", Justification = "Touch Screen is properly used as two-word discrete term.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId = "TouchScreen", Scope = "type", Target = "OpenQA.Selenium.Remote.RemoteTouchScreen", Justification = "Touch Screen is properly used as two-word discrete term.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "xpath", Scope = "member", Target = "OpenQA.Selenium.By.#XPath(System.String)", Justification = "XPath is spelled correctly.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "xpath", Scope = "member", Target = "OpenQA.Selenium.Internal.IFindsByXPath.#FindElementByXPath(System.String)", Justification = "XPath is spelled correctly.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "xpath", Scope = "member", Target = "OpenQA.Selenium.Internal.IFindsByXPath.#FindElementsByXPath(System.String)", Justification = "XPath is spelled correctly.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Minidump", Scope = "member", Target = "OpenQA.Selenium.Chrome.ChromeOptions.#MinidumpPath", Justification = "Minidump is spelled correctly.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Api", Scope = "member", Target = "OpenQA.Selenium.IE.InternetExplorerOptions.#ForceCreateProcessApi", Justification = "API is spelled and cased correctly for use in method names.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Api", Scope = "member", Target = "OpenQA.Selenium.IE.InternetExplorerOptions.#ForceShellWindowsApi", Justification = "API is spelled and cased correctly for use in method names.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Uncached", Scope = "member", Target = "OpenQA.Selenium.Html5.AppCacheStatus.#Uncached", Justification = "Uncached property is correctly spelled.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "x", Scope = "member", Target = "OpenQA.Selenium.Interactions.PointerInputDevice.#CreatePointerMove(OpenQA.Selenium.IWebElement,OpenQA.Selenium.Interactions.CoordinateOrigin,System.Int32,System.Int32,System.TimeSpan)", Justification = "An x-offset is an appropriate name for the parameter.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "y", Scope = "member", Target = "OpenQA.Selenium.Interactions.PointerInputDevice.#CreatePointerMove(OpenQA.Selenium.IWebElement,OpenQA.Selenium.Interactions.CoordinateOrigin,System.Int32,System.Int32,System.TimeSpan)", Justification = "A y-offset is an appropriate name for the parameter.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Png", Scope = "member", Target = "OpenQA.Selenium.ScreenshotImageFormat.#Png", Justification = "PNG is the propert term for Portable Network Graphics.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "OpenQA.Selenium.Cookie.#ExpirySeconds", Justification = "This property only exists so that the JSON serializer can serialize a cookie without resorting to a custom converter.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "OpenQA.Selenium.Remote.ErrorResponse.#StackTrace", Justification = "Specification compliance demands use of an array.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "OpenQA.Selenium.Screenshot.#AsByteArray", Justification = "Specification compliance demands use of an array.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Reliability", "CA2000:Dispose objects before losing scope", Scope = "member", Target = "OpenQA.Selenium.Chrome.ChromeDriver.#.ctor(OpenQA.Selenium.Chrome.ChromeOptions)", Justification = "Driver ensures that all dependent service objects are properly disposed.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Reliability", "CA2000:Dispose objects before losing scope", Scope = "member", Target = "OpenQA.Selenium.Chrome.ChromeDriver.#.ctor(System.String,OpenQA.Selenium.Chrome.ChromeOptions,System.TimeSpan)", Justification = "Driver ensures that all dependent service objects are properly disposed.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Reliability", "CA2000:Dispose objects before losing scope", Scope = "member", Target = "OpenQA.Selenium.Edge.EdgeDriver.#.ctor(OpenQA.Selenium.Edge.EdgeOptions)", Justification = "Driver ensures that all dependent service objects are properly disposed.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Reliability", "CA2000:Dispose objects before losing scope", Scope = "member", Target = "OpenQA.Selenium.Edge.EdgeDriver.#.ctor(System.String,OpenQA.Selenium.Edge.EdgeOptions,System.TimeSpan)", Justification = "Driver ensures that all dependent service objects are properly disposed.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Reliability", "CA2000:Dispose objects before losing scope", Scope = "member", Target = "OpenQA.Selenium.IE.InternetExplorerDriver.#.ctor(OpenQA.Selenium.IE.InternetExplorerOptions)", Justification = "Driver ensures that all dependent service objects are properly disposed.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Reliability", "CA2000:Dispose objects before losing scope", Scope = "member", Target = "OpenQA.Selenium.IE.InternetExplorerDriver.#.ctor(System.String,OpenQA.Selenium.IE.InternetExplorerOptions,System.TimeSpan)", Justification = "Driver ensures that all dependent service objects are properly disposed.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Reliability", "CA2000:Dispose objects before losing scope", Scope = "member", Target = "OpenQA.Selenium.Safari.SafariDriver.#.ctor(OpenQA.Selenium.Safari.SafariOptions)", Justification = "Driver ensures that all dependent service objects are properly disposed.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Reliability", "CA2000:Dispose objects before losing scope", Scope = "member", Target = "OpenQA.Selenium.Safari.SafariDriver.#.ctor(System.String,OpenQA.Selenium.Safari.SafariOptions,System.TimeSpan)", Justification = "Driver ensures that all dependent service objects are properly disposed.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Reliability", "CA2000:Dispose objects before losing scope", Scope = "member", Target = "OpenQA.Selenium.Firefox.FirefoxDriver.#.ctor(OpenQA.Selenium.Firefox.FirefoxOptions)", Justification = "Driver ensures that all dependent service objects are properly disposed.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Reliability", "CA2000:Dispose objects before losing scope", Scope = "member", Target = "OpenQA.Selenium.Firefox.FirefoxDriver.#.ctor()", Justification = "Driver ensures that all dependent service objects are properly disposed.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Reliability", "CA2000:Dispose objects before losing scope", Scope = "member", Target = "OpenQA.Selenium.Firefox.FirefoxDriver.#.ctor(OpenQA.Selenium.Firefox.FirefoxProfile)", Justification = "Driver ensures that all dependent service objects are properly disposed.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Reliability", "CA2000:Dispose objects before losing scope", Scope = "member", Target = "OpenQA.Selenium.Firefox.FirefoxDriver.#CreateExtensionConnection(OpenQA.Selenium.Firefox.FirefoxBinary,OpenQA.Selenium.Firefox.FirefoxProfile,System.TimeSpan)", Justification = "Driver ensures that all dependent service objects are properly disposed.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Usage", "CA2202:Do not dispose objects multiple times", Scope = "member", Target = "OpenQA.Selenium.Firefox.FirefoxProfile.#FromBase64String(System.String)", Justification = "Separate disposal of the stream object is approved, and ensures disposal if there are exceptions in nested object constructor or method.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Usage", "CA2202:Do not dispose objects multiple times", Scope = "member", Target = "OpenQA.Selenium.Firefox.FirefoxProfile.#ReadDefaultPreferences()", Justification = "Separate disposal of the stream object is approved, and ensures disposal if there are exceptions in nested object constructor or method.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Usage", "CA2202:Do not dispose objects multiple times", Scope = "member", Target = "OpenQA.Selenium.Firefox.FirefoxProfile.#ToBase64String()", Justification = "Separate disposal of the stream object is approved, and ensures disposal if there are exceptions in nested object constructor or method.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Usage", "CA2202:Do not dispose objects multiple times", Scope = "member", Target = "OpenQA.Selenium.Remote.RemoteWebElement.#UploadFile(System.String)", Justification = "Separate disposal of the stream object is approved, and ensures disposal if there are exceptions in nested object constructor or method.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Usage", "CA2202:Do not dispose objects multiple times", Scope = "member", Target = "OpenQA.Selenium.Remote.RemoteWebElement.#GetAtom(System.String)", Justification = "Separate disposal of the stream object is approved, and ensures disposal if there are exceptions in nested object constructor or method.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA2204:Literals should be spelled correctly", MessageId = "WebDriver", Scope = "member", Target = "OpenQA.Selenium.Remote.HttpCommandExecutor.#CreateResponse(System.Net.WebRequest)", Justification = "WebDriver is correctly used as a single word.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA2204:Literals should be spelled correctly", MessageId = "HasApplicationCache", Scope = "member", Target = "OpenQA.Selenium.Remote.RemoteWebDriver.#ApplicationCache", Justification = "HasApplicationCache property name is properly spelled")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA2204:Literals should be spelled correctly", MessageId = "HasLocationContext", Scope = "member", Target = "OpenQA.Selenium.Remote.RemoteWebDriver.#LocationContext", Justification = "HasLocationContext property name is properly spelled")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA2204:Literals should be spelled correctly", MessageId = "HasWebStorage", Scope = "member", Target = "OpenQA.Selenium.Remote.RemoteWebDriver.#WebStorage", Justification = "HasWebStorage property name is properly spelled")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA2204:Literals should be spelled correctly", MessageId = "geolocation", Scope = "member", Target = "OpenQA.Selenium.Remote.RemoteWebDriver.#LocationContext", Justification = "Geolocation is properly spelled")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "OpenQA.Selenium.Remote.RemoteWebDriver.#.ctor(OpenQA.Selenium.Remote.ICommandExecutor,OpenQA.Selenium.ICapabilities)", Justification = "Class provides a hook for subclasses to modify functionality, so virtual method call in constructor is appropriate.")]

// Temporary suppressions until Interactions API is fully updated.
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "OpenQA.Selenium.Interactions.PauseInteraction.#.ctor(OpenQA.Selenium.Interactions.InputDevice)", Justification = "Temporary suppressions until Interactions API is made public.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "OpenQA.Selenium.Interactions.PointerInputDevice.#.ctor(OpenQA.Selenium.Interactions.PointerKind)", Justification = "Temporary suppressions until Interactions API is made public.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "OpenQA.Selenium.Interactions.PointerInputDevice.#CreatePointerCancel()", Justification = "Temporary suppressions until Interactions API is made public.")]
[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "OpenQA.Selenium.Interactions.PointerInputDevice+PointerCancelInteraction.#.ctor(OpenQA.Selenium.Interactions.InputDevice)", Justification = "Temporary suppressions until Interactions API is made public.")]
