// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"


namespace Rivet {


  /// @brief e+e- > K0K0 (+pions)
  class BABAR_2014_I1287920 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BABAR_2014_I1287920);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(FinalState(), "FS");

      // Book histograms
      bool pass = false;
      for (size_t ix=0; ix<_sqs.size(); ++ix) {
        book(_sigma[ix], 9+ix, 1, 1);
        for (const string& en : _sigma[ix].binning().edges<0>()) {
          const double eval = std::stod(en)*GeV;
          if (isCompatibleWithSqrtS(eval)) {
            _sqs[ix] = en;
            pass = true;
            break;
          }
        }
      }
      raiseBeamErrorIf(!pass);
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");

      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
        nCount[p.pid()] += 1;
        ++ntotal;
      }

      if (ntotal==2 && nCount[130]==1 && nCount[310]==1) {
        if (!_sqs[0].empty()) _sigma[0]->fill(_sqs[0]);
      }
      else if(ntotal==4 &&  nCount[130]==1 && nCount[310]==1 && nCount[211]==1 && nCount[-211]==1) {
        if(!_sqs[1].empty()) _sigma[1]->fill(_sqs[1]);
      }
      else if (ntotal==4 && nCount[310]==2 && nCount[211]==1 && nCount[-211]==1 ) {
        if(!_sqs[2].empty()) _sigma[2]->fill(_sqs[2]);
      }
      else if (ntotal==4 && nCount[310]==2 && nCount[321]==1 && nCount[-321]==1) {
        if(!_sqs[3].empty()) _sigma[3]->fill(_sqs[3]);
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_sigma, crossSection()/ sumOfWeights() /nanobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _sigma[4];
    vector<string> _sqs{""s, ""s, ""s, ""s};
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BABAR_2014_I1287920);


}
