// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"

namespace Rivet {


  /// @brief hadronic cross section
  class PLUTO_1979_I140818 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(PLUTO_1979_I140818);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      // Initialise and register projections
      declare(FinalState(), "FS");
      // counters for R
      book(_c_hadrons, 2, 1, 1);
      for (const string& en : _c_hadrons.binning().edges<0>()) {
        double eval = stod(en)*GeV;
        if (isCompatibleWithSqrtS(eval)) {
          _sqs = en; break;
        }
      }
      raiseBeamErrorIf(_sqs.empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");

      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
        nCount[p.pid()] += 1;
        ++ntotal;
      }
      if (nCount[-13]==1 && nCount[13]==1 && ntotal==2+nCount[22]) {
        // mu+mu- + photons
        vetoEvent;
      }
      else {
        // everything else
        _c_hadrons->fill(_sqs);
      }

    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_c_hadrons, crossSection()/sumOfWeights()/nanobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _c_hadrons;
    string _sqs;
    /// @}


  };


  RIVET_DECLARE_PLUGIN(PLUTO_1979_I140818);
}
